<?php

use Bitrix\Main\Application;
use Bitrix\Main;
use Bitrix\Catalog;

IncludeModuleLangFile(__FILE__);

class CAllCatalogGroup
{
	protected static array $arBaseGroupCache = [];

	public static function CheckFields($ACTION, &$arFields, $ID = 0)
	{
		global $APPLICATION;
		global $USER;
		global $DB;

		$boolResult = true;
		$arMsg = array();

		$ACTION = mb_strtoupper($ACTION);
		if ('UPDATE' != $ACTION && 'ADD' != $ACTION)
			return false;

		if (array_key_exists("NAME", $arFields) || $ACTION=="ADD")
		{
			$arFields["NAME"] = trim($arFields["NAME"]);
			if ('' == $arFields["NAME"])
			{
				$arMsg[] = array('id' => 'NAME', 'text' => GetMessage('BT_MOD_CAT_GROUP_ERR_EMPTY_NAME'));
				$boolResult = false;
			}
		}

		if ((array_key_exists("BASE", $arFields) || $ACTION=="ADD") && $arFields["BASE"] != "Y")
		{
			$arFields["BASE"] = "N";
		}

		if (array_key_exists("SORT", $arFields) || $ACTION=="ADD")
		{
			$arFields["SORT"] = intval($arFields["SORT"]);
			if (0 >= $arFields["SORT"])
				$arFields["SORT"] = 100;
		}

		$intUserID = 0;
		$boolUserExist = CCatalog::IsUserExists();
		if ($boolUserExist)
			$intUserID = intval($USER->GetID());
		$strDateFunction = $DB->GetNowFunction();
		if (array_key_exists('TIMESTAMP_X', $arFields))
			unset($arFields['TIMESTAMP_X']);
		if (array_key_exists('DATE_CREATE', $arFields))
			unset($arFields['DATE_CREATE']);
		$arFields['~TIMESTAMP_X'] = $strDateFunction;
		if (array_key_exists('MODIFIED_BY', $arFields))
		{
			if ($arFields['MODIFIED_BY'] !== false)
			{
				$arFields['MODIFIED_BY'] = (int)$arFields['MODIFIED_BY'];
				if ($arFields['MODIFIED_BY'] <= 0)
				{
					unset($arFields['MODIFIED_BY']);
				}
			}
		}
		if (!isset($arFields['MODIFIED_BY']) && $boolUserExist)
		{
			$arFields["MODIFIED_BY"] = $intUserID;
		}
		if ('ADD' == $ACTION)
		{
			$arFields['~DATE_CREATE'] = $strDateFunction;
			if (array_key_exists('CREATED_BY', $arFields))
			{
				if ($arFields['CREATED_BY'] !== false)
				{
					$arFields['CREATED_BY'] = (int)$arFields['CREATED_BY'];
					if ($arFields['CREATED_BY'] <= 0)
					{
						unset($arFields['CREATED_BY']);
					}
				}
			}
			if (!isset($arFields['CREATED_BY']) && $boolUserExist)
			{
				$arFields["CREATED_BY"] = $intUserID;
			}
		}
		if ('UPDATE' == $ACTION)
		{
			if (array_key_exists('CREATED_BY', $arFields))
				unset($arFields['CREATED_BY']);
		}

		if (is_set($arFields, 'USER_GROUP') || $ACTION=="ADD")
		{
			if (!is_array($arFields['USER_GROUP']) || empty($arFields['USER_GROUP']))
			{
				$arMsg[] = array('id' => 'USER_GROUP', 'text' => GetMessage('BT_MOD_CAT_GROUP_ERR_EMPTY_USER_GROUP'));
				$boolResult = false;
			}
			else
			{
				$arValid = array();
				foreach ($arFields['USER_GROUP'] as &$intValue)
				{
					$intValue = intval($intValue);
					if (0 < $intValue)
						$arValid[] = $intValue;
				}
				if (isset($intValue))
					unset($intValue);
				if (!empty($arValid))
				{
					$arFields['USER_GROUP'] = array_values(array_unique($arValid));
				}
				else
				{
					$arMsg[] = array('id' => 'USER_GROUP', 'text' => GetMessage('BT_MOD_CAT_GROUP_ERR_EMPTY_USER_GROUP'));
					$boolResult = false;
				}
			}
		}

		if (is_set($arFields, 'USER_GROUP_BUY') || $ACTION=="ADD")
		{
			if (!is_array($arFields['USER_GROUP_BUY']) || empty($arFields['USER_GROUP_BUY']))
			{
				$arMsg[] = array('id' => 'USER_GROUP_BUY', 'text' => GetMessage('BT_MOD_CAT_GROUP_ERR_EMPTY_USER_GROUP_BUY'));
				$boolResult = false;
			}
			else
			{
				$arValid = array();
				foreach ($arFields['USER_GROUP_BUY'] as &$intValue)
				{
					$intValue = intval($intValue);
					if (0 < $intValue)
						$arValid[] = $intValue;
				}
				if (isset($intValue))
					unset($intValue);
				if (!empty($arValid))
				{
					$arFields['USER_GROUP_BUY'] = array_values(array_unique($arValid));
				}
				else
				{
					$arMsg[] = array('id' => 'USER_GROUP_BUY', 'text' => GetMessage('BT_MOD_CAT_GROUP_ERR_EMPTY_USER_GROUP_BUY'));
					$boolResult = false;
				}
			}
		}

		if (!$boolResult)
		{
			$obError = new CAdminException($arMsg);
			$APPLICATION->ResetException();
			$APPLICATION->ThrowException($obError);
		}
		return $boolResult;
	}

	public static function GetGroupsPerms($arUserGroups = array(), $arCatalogGroupsFilter = array())
	{
		global $USER;

		if (!is_array($arUserGroups))
			$arUserGroups = array($arUserGroups);

		if (empty($arUserGroups))
			$arUserGroups = (CCatalog::IsUserExists() ? $USER->GetUserGroupArray() : array(2));
		Main\Type\Collection::normalizeArrayValuesByInt($arUserGroups);

		if (!is_array($arCatalogGroupsFilter))
			$arCatalogGroupsFilter = array($arCatalogGroupsFilter);
		Main\Type\Collection::normalizeArrayValuesByInt($arCatalogGroupsFilter);
		if (!empty($arCatalogGroupsFilter))
			$arCatalogGroupsFilter = array_fill_keys($arCatalogGroupsFilter, true);

		$result = array(
			'view' => array(),
			'buy' => array()
		);

		if (empty($arUserGroups))
			return $result;

		if (defined('CATALOG_SKIP_CACHE') && CATALOG_SKIP_CACHE)
		{
			$priceTypeIterator = CCatalogGroup::GetGroupsList(array('@GROUP_ID' => $arUserGroups));
			while ($priceType = $priceTypeIterator->Fetch())
			{
				$priceTypeId = (int)$priceType['CATALOG_GROUP_ID'];;
				$key = ($priceType['BUY'] == 'Y' ? 'buy' : 'view');
				if ($key == 'view' && !empty($arCatalogGroupsFilter) && !isset($arCatalogGroupsFilter[$priceTypeId]))
					continue;
				$result[$key][$priceTypeId] = $priceTypeId;
				unset($key, $priceTypeId);
			}
			unset($priceType, $priceTypeIterator);
			if (!empty($result['view']))
				$result['view'] = array_values($result['view']);
			if (!empty($result['buy']))
				$result['buy'] = array_values($result['buy']);

			return $result;
		}

		$data = array();
		$cacheTime = (int)(defined('CATALOG_CACHE_TIME') ? CATALOG_CACHE_TIME : CATALOG_CACHE_DEFAULT_TIME);
		$managedCache = Application::getInstance()->getManagedCache();
		if ($managedCache->read($cacheTime, 'catalog_group_perms'))
		{
			$data = $managedCache->get('catalog_group_perms');
		}
		else
		{
			$priceTypeIterator = CCatalogGroup::GetGroupsList();
			while ($priceType = $priceTypeIterator->Fetch())
			{
				$priceTypeId = (int)$priceType['CATALOG_GROUP_ID'];
				$groupId = (int)($priceType['GROUP_ID']);
				$key = ($priceType['BUY'] == 'Y' ? 'buy' : 'view');

				if (!isset($data[$groupId]))
					$data[$groupId] = array(
						'view' => array(),
						'buy' => array()
					);
				$data[$groupId][$key][$priceTypeId] = $priceTypeId;
				unset($key, $groupId, $priceTypeId);
			}
			unset($priceType, $priceTypeIterator);
			if (!empty($data))
			{
				foreach ($data as &$groupData)
				{
					if (!empty($groupData['view']))
						$groupData['view'] = array_values($groupData['view']);
					if (!empty($groupData['buy']))
						$groupData['buy'] = array_values($groupData['buy']);
				}
				unset($groupData);
			}
			$managedCache->set('catalog_group_perms', $data);
		}

		foreach ($arUserGroups as &$groupId)
		{
			if (!isset($data[$groupId]))
				continue;
			if (!empty($data[$groupId]['view']))
			{
				$priceTypeList = $data[$groupId]['view'];
				foreach ($priceTypeList as &$priceTypeId)
				{
					if (!empty($arCatalogGroupsFilter) && !isset($arCatalogGroupsFilter[$priceTypeId]))
						continue;
					$result['view'][$priceTypeId] = $priceTypeId;
				}
				unset($priceTypeId, $priceTypeList);
			}
			if (!empty($data[$groupId]['buy']))
			{
				$priceTypeList = $data[$groupId]['buy'];
				foreach ($priceTypeList as &$priceTypeId)
					$result['buy'][$priceTypeId] = $priceTypeId;
				unset($priceTypeId, $priceTypeList);
			}
		}
		unset($groupId);

		if (!empty($result['view']))
			$result['view'] = array_values($result['view']);
		if (!empty($result['buy']))
			$result['buy'] = array_values($result['buy']);

		return $result;
	}

	/**
	 * @deprecated
	 * @see Catalog\GroupTable::getTypeList()
	 *
	 * @return array
	 */
	public static function GetListArray(): array
	{
		return Catalog\GroupTable::getTypeList();
	}

	/**
	 * @deprecated
	 * @see Catalog\GroupTable::getBasePriceType()
	 *
	 * @return array|false
	 */
	public static function GetBaseGroup()
	{
		$group = Catalog\GroupTable::getBasePriceType();
		if (!empty($group))
		{
			$group['NAME_LANG'] = (string)$group['NAME_LANG'];
			$group['XML_ID'] = (string)$group['XML_ID'];

			return $group;
		}

		return false;
	}

	/**
	 * @deprecated
	 * @see Catalog\GroupTable::getBasePriceTypeId()
	 *
	 * @return int|null
	 */
	public static function GetBaseGroupId(): ?int
	{
		return Catalog\GroupTable::getBasePriceTypeId();
	}

	public static function GetByID($ID, $lang = LANGUAGE_ID): false|array
	{
		global $USER;

		$ID = (int)$ID;
		if ($ID <= 0)
		{
			return false;
		}

		$lang = (string)$lang;

		$row = Catalog\GroupTable::getRow([
			'select' => [
				'ID',
				'NAME',
				'BASE',
				'SORT',
				'XML_ID',
				'CREATED_BY',
				'MODIFIED_BY',
				'TIMESTAMP_X',
				'DATE_CREATE',
			],
			'filter' => [
				'=ID' => $ID,
			],
		]);

		if ($row === null)
		{
			return false;
		}
		if ($row['TIMESTAMP_X'] instanceof Main\Type\DateTime)
		{
			$row['TIMESTAMP_X'] = $row['TIMESTAMP_X']->toString();
		}
		if ($row['DATE_CREATE'] instanceof Main\Type\DateTime)
		{
			$row['DATE_CREATE'] = $row['DATE_CREATE']->toString();
		}

		$langName = Catalog\GroupLangTable::getRow([
			'select' => [
				'NAME',
			],
			'filter' => [
				'=CATALOG_GROUP_ID' => $ID,
				'=LANG' => $lang,
			],
		]);

		$row['NAME_LANG'] = $langName === null ? null : $langName['NAME'];

		$userGroupIds =
			CCatalog::IsUserExists()
				? $USER->GetUserGroupArray()
				: [2]
		;

		$access = Catalog\GroupAccessTable::getRow([
			'select' => [
				'ID',
			],
			'filter' => [
				'=CATALOG_GROUP_ID' => $ID,
				'@GROUP_ID' => $userGroupIds,
				'=ACCESS' => Catalog\GroupAccessTable::ACCESS_VIEW,
			]
		]);
		$row['CAN_ACCESS'] = $access === null ? 'N' : 'Y';

		$access = Catalog\GroupAccessTable::getRow([
			'select' => [
				'ID',
			],
			'filter' => [
				'=CATALOG_GROUP_ID' => $ID,
				'@GROUP_ID' => $userGroupIds,
				'=ACCESS' => Catalog\GroupAccessTable::ACCESS_BUY,
			]
		]);
		$row['CAN_BUY'] = $access === null ? 'N' : 'Y';

		return $row;
	}
}
