CREATE TABLE b_cluster_group
(
	ID INT(11) NOT NULL auto_increment,
	NAME VARCHAR(50),

	PRIMARY KEY pk_b_cluster_group(ID)
);

CREATE TABLE b_cluster_dbnode
(
	ID INT(11) NOT NULL auto_increment,
	ACTIVE CHAR(1) NOT NULL DEFAULT 'Y',
	GROUP_ID INT(11),
	ROLE_ID VARCHAR(50),
	NAME VARCHAR(50),
	DESCRIPTION VARCHAR(250),

	DB_HOST VARCHAR(250),
	DB_NAME VARCHAR(250),
	DB_LOGIN VARCHAR(50),
	DB_PASSWORD VARCHAR(50),

	MASTER_ID INT(11),
	MASTER_HOST VARCHAR(50),
	MASTER_PORT INT(11),

	SERVER_ID VARCHAR(50),
	STATUS VARCHAR(50),
	UNIQID VARCHAR(50),

	SELECTABLE CHAR(1),
	WEIGHT INT(11),

	PRIMARY KEY pk_b_cluster_dbnode(ID)
);

CREATE TABLE b_cluster_webnode
(
	ID INT(11) NOT NULL auto_increment,
	GROUP_ID INT(11),
	NAME VARCHAR(50),
	DESCRIPTION VARCHAR(250),
	HOST VARCHAR(250),
	PORT INT(11),
	STATUS_URL VARCHAR(250),

	PRIMARY KEY pk_b_cluster_webnode(ID)
);

CREATE TABLE b_cluster_table
(
	ID INT(11) NOT NULL auto_increment,
	TIMESTAMP_X TIMESTAMP,
	MODULE_ID VARCHAR(50),
	TABLE_NAME VARCHAR(64),
	KEY_COLUMN VARCHAR(50),

	FROM_NODE_ID INT(11),
	TO_NODE_ID INT(11),
	REC_COUNT INT(11),
	LAST_ID VARCHAR(250),

	PRIMARY KEY pk_b_cluster_table(ID)
);

CREATE TABLE b_cluster_queue
(
	ID BIGINT(11) NOT NULL auto_increment,
	TIMESTAMP_X TIMESTAMP,
	GROUP_ID INT(11) NOT NULL,
	COMMAND VARCHAR(50),
	PARAM1 VARCHAR(255),
	PARAM2 VARCHAR(255),
	PARAM3 VARCHAR(255),
	PRIMARY KEY pk_b_cluster_queue(ID),
	KEY ix_b_cluster_queue_time(TIMESTAMP_X),
	KEY ix_b_cluster_queue_group(GROUP_ID)
);
