
CREATE TABLE b_cluster_group (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  NAME varchar(50),
  PRIMARY KEY (ID)
);
ALTER TABLE b_cluster_group ALTER COLUMN ID RESTART WITH 2;

CREATE TABLE b_cluster_dbnode (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  GROUP_ID int,
  ROLE_ID varchar(50),
  NAME varchar(50),
  DESCRIPTION varchar(250),
  DB_HOST varchar(250),
  DB_NAME varchar(250),
  DB_LOGIN varchar(50),
  DB_PASSWORD varchar(50),
  MASTER_ID int,
  MASTER_HOST varchar(50),
  MASTER_PORT int,
  SERVER_ID varchar(50),
  STATUS varchar(50),
  UNIQID varchar(50),
  SELECTABLE char(1),
  WEIGHT int,
  PRIMARY KEY (ID)
);
ALTER TABLE b_cluster_dbnode ALTER COLUMN ID RESTART WITH 2;

CREATE TABLE b_cluster_webnode (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  GROUP_ID int,
  NAME varchar(50),
  DESCRIPTION varchar(250),
  HOST varchar(250),
  PORT int,
  STATUS_URL varchar(250),
  PRIMARY KEY (ID)
);

CREATE TABLE b_cluster_table (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TIMESTAMP_X timestamp DEFAULT CURRENT_TIMESTAMP,
  MODULE_ID varchar(50),
  TABLE_NAME varchar(64),
  KEY_COLUMN varchar(50),
  FROM_NODE_ID int,
  TO_NODE_ID int,
  REC_COUNT int,
  LAST_ID varchar(250),
  PRIMARY KEY (ID)
);

CREATE TABLE b_cluster_queue (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TIMESTAMP_X timestamp DEFAULT CURRENT_TIMESTAMP,
  GROUP_ID int NOT NULL,
  COMMAND varchar(50),
  PARAM1 varchar(255),
  PARAM2 varchar(255),
  PARAM3 varchar(255),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_cluster_queue_timestamp_x ON b_cluster_queue (timestamp_x);
CREATE INDEX ix_b_cluster_queue_group_id ON b_cluster_queue (group_id);
