
CREATE TABLE b_catalog_currency (
  CURRENCY char(3) NOT NULL,
  AMOUNT_CNT int NOT NULL DEFAULT 1,
  AMOUNT decimal,
  SORT int NOT NULL DEFAULT 100,
  DATE_UPDATE timestamp NOT NULL,
  NUMCODE char(3),
  BASE char(1) NOT NULL DEFAULT 'N',
  CREATED_BY int,
  DATE_CREATE timestamp,
  MODIFIED_BY int,
  CURRENT_BASE_RATE decimal,
  PRIMARY KEY (CURRENCY)
);

CREATE TABLE b_catalog_currency_lang (
  CURRENCY char(3) NOT NULL,
  LID char(2) NOT NULL,
  FORMAT_STRING varchar(50) NOT NULL,
  FULL_NAME varchar(50),
  DEC_POINT varchar(16) DEFAULT '.',
  THOUSANDS_SEP varchar(16) DEFAULT ' ',
  DECIMALS smallint NOT NULL DEFAULT 2,
  THOUSANDS_VARIANT char(1),
  HIDE_ZERO char(1) NOT NULL DEFAULT 'N',
  CREATED_BY int,
  DATE_CREATE timestamp,
  MODIFIED_BY int,
  TIMESTAMP_X timestamp,
  PRIMARY KEY (CURRENCY, LID)
);

CREATE TABLE b_catalog_currency_rate (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CURRENCY char(3) NOT NULL,
  BASE_CURRENCY char(3),
  DATE_RATE date NOT NULL,
  RATE_CNT int NOT NULL DEFAULT 1,
  RATE decimal NOT NULL DEFAULT 0,
  CREATED_BY int,
  DATE_CREATE timestamp,
  MODIFIED_BY int,
  TIMESTAMP_X timestamp,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_catalog_currency_rate_currency_date_rate ON b_catalog_currency_rate (currency, date_rate);
