CREATE TABLE b_medialib_collection (
      ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
      NAME varchar(255) NOT NULL,
      DESCRIPTION text,
      ACTIVE char(1) NOT NULL DEFAULT 'Y',
      DATE_UPDATE timestamp NOT NULL,
      OWNER_ID int,
      PARENT_ID int,
      SITE_ID char(2),
      KEYWORDS varchar(255),
      ITEMS_COUNT int,
      ML_TYPE int NOT NULL DEFAULT 0,
      PRIMARY KEY (ID)
);

CREATE TABLE b_medialib_collection_item (
      COLLECTION_ID int NOT NULL,
      ITEM_ID int NOT NULL,
      PRIMARY KEY (ITEM_ID, COLLECTION_ID)
);

CREATE TABLE b_medialib_item (
      ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
      NAME varchar(255) NOT NULL,
      ITEM_TYPE char(30),
      DESCRIPTION text,
      DATE_CREATE timestamp NOT NULL,
      DATE_UPDATE timestamp NOT NULL,
      SOURCE_ID int NOT NULL,
      KEYWORDS varchar(255),
      SEARCHABLE_CONTENT text,
      PRIMARY KEY (ID)
);

CREATE TABLE b_group_collection_task (
      GROUP_ID int NOT NULL,
      TASK_ID int NOT NULL,
      COLLECTION_ID int NOT NULL,
      PRIMARY KEY (GROUP_ID, TASK_ID, COLLECTION_ID)
);

CREATE TABLE b_medialib_type (
      ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
      NAME varchar(255),
      CODE varchar(255) NOT NULL,
      EXT varchar(255) NOT NULL,
      SYSTEM char(1) NOT NULL DEFAULT 'N',
      DESCRIPTION text,
      PRIMARY KEY (ID)
);

CREATE TABLE b_file_search (
      ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
      SESS_ID varchar(255) NOT NULL,
      TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
      F_PATH varchar(255),
      B_DIR int NOT NULL DEFAULT 0,
      F_SIZE int NOT NULL DEFAULT 0,
      F_TIME int NOT NULL DEFAULT 0,
      PRIMARY KEY (ID)
);

CREATE TABLE b_sticker (
      ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
      SITE_ID char(2),
      PAGE_URL varchar(255) NOT NULL,
      PAGE_TITLE varchar(255) NOT NULL,
      DATE_CREATE timestamp NOT NULL,
      DATE_UPDATE timestamp NOT NULL,
      MODIFIED_BY int NOT NULL,
      CREATED_BY int NOT NULL,
      PERSONAL char(1) NOT NULL DEFAULT 'N',
      CONTENT text,
      POS_TOP int,
      POS_LEFT int,
      WIDTH int,
      HEIGHT int,
      COLOR int,
      COLLAPSED char(1) NOT NULL DEFAULT 'N',
      COMPLETED char(1) NOT NULL DEFAULT 'N',
      CLOSED char(1) NOT NULL DEFAULT 'N',
      DELETED char(1) NOT NULL DEFAULT 'N',
      MARKER_TOP int,
      MARKER_LEFT int,
      MARKER_WIDTH int,
      MARKER_HEIGHT int,
      MARKER_ADJUST text,
      PRIMARY KEY (ID)
);

CREATE TABLE b_sticker_group_task (
      GROUP_ID int NOT NULL,
      TASK_ID int NOT NULL,
      PRIMARY KEY (GROUP_ID, TASK_ID)
);