/* eslint-disable */
this.BX = this.BX || {};
this.BX.Messenger = this.BX.Messenger || {};
this.BX.Messenger.v2 = this.BX.Messenger.v2 || {};
this.BX.Messenger.v2.Component = this.BX.Messenger.v2.Component || {};
(function (exports,im_v2_lib_channel,im_v2_component_elements,ui_avatar,im_v2_lib_copilot,ui_icons_disk,im_v2_lib_parser,rest_client,ui_loader,im_v2_model,ui_notification,im_public,im_v2_provider_service,im_v2_lib_phone,main_popup,ui_forms,main_core_events,im_v2_lib_localStorage,ui_vue3,im_v2_lib_textHighlighter,im_v2_lib_utils,im_v2_lib_permission,im_v2_lib_inputAction,im_v2_lib_dateFormatter,im_v2_application_core,im_v2_lib_user,im_v2_lib_logger,im_v2_const,ai_rolesDialog,ui_vue3_components_hint,ui_fonts_opensans,main_polyfill_intersectionobserver,ui_vue3_directives_lazyload,im_v2_component_animation,main_core,ui_lottie) {
	'use strict';

	const AvatarSize = Object.freeze({
	  XXS: 'XXS',
	  XS: 'XS',
	  S: 'S',
	  M: 'M',
	  L: 'L',
	  XL: 'XL',
	  XXL: 'XXL',
	  XXXL: 'XXXL'
	});
	const AvatarSizeMap = Object.freeze({
	  [AvatarSize.XXXL]: 94,
	  [AvatarSize.XXL]: 60,
	  [AvatarSize.XL]: 48,
	  [AvatarSize.L]: 42,
	  [AvatarSize.M]: 32,
	  [AvatarSize.S]: 22,
	  [AvatarSize.XS]: 18,
	  [AvatarSize.XXS]: 14
	});

	// @vue/component
	const Avatar = {
	  name: 'MessengerAvatar',
	  props: {
	    dialogId: {
	      type: [String, Number],
	      default: 0
	    },
	    customSource: {
	      type: String,
	      default: ''
	    },
	    size: {
	      type: String,
	      default: AvatarSize.M
	    },
	    withAvatarLetters: {
	      type: Boolean,
	      default: true
	    },
	    withSpecialTypes: {
	      type: Boolean,
	      default: true
	    },
	    withSpecialTypeIcon: {
	      type: Boolean,
	      default: true
	    },
	    withTooltip: {
	      type: Boolean,
	      default: true
	    },
	    backgroundColor: {
	      type: String,
	      default: ''
	    }
	  },
	  data() {
	    return {
	      imageLoadError: false
	    };
	  },
	  computed: {
	    dialog() {
	      return this.$store.getters['chats/get'](this.dialogId, true);
	    },
	    isChannel() {
	      return im_v2_lib_channel.ChannelManager.isChannel(this.dialogId);
	    },
	    isSpecialType() {
	      const commonTypes = [im_v2_const.ChatType.user, im_v2_const.ChatType.chat, im_v2_const.ChatType.open, im_v2_const.ChatType.lines];
	      return !commonTypes.includes(this.dialog.type);
	    },
	    containerTitle() {
	      if (!this.withTooltip) {
	        return '';
	      }
	      return this.dialog.name;
	    },
	    containerClasses() {
	      const classes = [`--size-${this.size.toLowerCase()}`];
	      if (this.withSpecialTypes && this.isSpecialType) {
	        classes.push('--special');
	      }
	      const typeClass = im_v2_const.ChatType[this.dialog.type] ? `--${this.dialog.type}` : '--default';
	      classes.push(typeClass);
	      return classes;
	    },
	    backgroundColorStyle() {
	      if (this.backgroundColor) {
	        return {
	          backgroundColor: this.backgroundColor
	        };
	      }
	      return {
	        backgroundColor: this.dialog.color
	      };
	    },
	    avatarText() {
	      if (!this.showAvatarLetters || !this.isEnoughSizeForText) {
	        return '';
	      }
	      return im_v2_lib_utils.Utils.text.getFirstLetters(this.dialog.name);
	    },
	    showAvatarLetters() {
	      const SPECIAL_TYPES_WITH_LETTERS = [im_v2_const.ChatType.openChannel, im_v2_const.ChatType.channel];
	      if (SPECIAL_TYPES_WITH_LETTERS.includes(this.dialog.type)) {
	        return true;
	      }
	      return !this.isSpecialType;
	    },
	    showSpecialTypeIcon() {
	      if (!this.withSpecialTypes || !this.withSpecialTypeIcon || this.isChannel) {
	        return false;
	      }
	      return this.isSpecialType;
	    },
	    isEnoughSizeForText() {
	      const avatarSizesWithText = [AvatarSize.M, AvatarSize.L, AvatarSize.XL, AvatarSize.XXL, AvatarSize.XXXL];
	      return avatarSizesWithText.includes(this.size.toUpperCase());
	    },
	    avatarUrl() {
	      return this.customSource.length > 0 ? this.customSource : this.dialog.avatar;
	    },
	    hasImage() {
	      return this.avatarUrl && !this.imageLoadError;
	    }
	  },
	  watch: {
	    avatarUrl() {
	      this.imageLoadError = false;
	    }
	  },
	  methods: {
	    onImageLoadError() {
	      this.imageLoadError = true;
	    }
	  },
	  template: `
		<div :title="containerTitle" :class="containerClasses" class="bx-im-avatar__scope bx-im-avatar__container">
			<!-- Avatar -->
			<template v-if="hasImage">
				<img :src="avatarUrl" :alt="dialog.name" class="bx-im-avatar__content --image" @error="onImageLoadError" draggable="false"/>
				<div v-if="showSpecialTypeIcon" :style="backgroundColorStyle" class="bx-im-avatar__special-type_icon"></div>
			</template>
			<div v-else-if="withAvatarLetters && avatarText" :style="backgroundColorStyle" class="bx-im-avatar__content --text">
				{{ avatarText }}
			</div>
			<div v-else :style="backgroundColorStyle" class="bx-im-avatar__content bx-im-avatar__icon"></div>
		</div>
	`
	};

	const AvatarType = {
	  extranet: 'extranet',
	  collaber: 'collaber',
	  collab: 'collab',
	  default: 'default'
	};

	// @vue/component
	const BaseUiAvatar = {
	  props: {
	    type: {
	      type: String,
	      required: true,
	      validator(value) {
	        return Object.values(AvatarType).includes(value);
	      }
	    },
	    size: {
	      type: String,
	      default: AvatarSize.M
	    },
	    url: {
	      type: String,
	      default: ''
	    },
	    title: {
	      type: String,
	      default: ''
	    },
	    backgroundColor: {
	      type: String,
	      default: ''
	    }
	  },
	  computed: {
	    AvatarSize: () => AvatarSize,
	    calculatedSize() {
	      return AvatarSizeMap[this.size];
	    }
	  },
	  watch: {
	    title() {
	      this.avatar.setTitle(this.title);
	    },
	    url() {
	      this.setAvatarImage();
	    }
	  },
	  created() {
	    const classMap = {
	      extranet: ui_avatar.AvatarRoundExtranet,
	      collaber: ui_avatar.AvatarRoundGuest,
	      collab: ui_avatar.AvatarHexagonGuest,
	      default: ui_avatar.AvatarBase
	    };
	    const AvatarClass = classMap[this.type] || classMap.default;
	    this.avatar = new AvatarClass({
	      size: this.calculatedSize,
	      title: this.title
	    });
	    this.setAvatarImage();
	    this.setBackgroundColor();
	  },
	  mounted() {
	    if (this.avatar && this.$refs.avatarContainer) {
	      this.avatar.renderTo(this.$refs.avatarContainer);
	    }
	  },
	  methods: {
	    setAvatarImage() {
	      if (!this.url) {
	        return;
	      }
	      this.avatar.setUserPic(this.url);
	    },
	    setBackgroundColor() {
	      if (!this.backgroundColor) {
	        return;
	      }
	      this.avatar.setBaseColor(this.backgroundColor);
	    }
	  },
	  template: `
		<div class="bx-im-base-ui-avatar__container" ref="avatarContainer"></div>
	`
	};

	// @vue/component
	const CollabChatAvatar = {
	  name: 'CollabChatAvatar',
	  components: {
	    BaseUiAvatar
	  },
	  props: {
	    dialogId: {
	      type: [String, Number],
	      default: 0
	    },
	    size: {
	      type: String,
	      default: AvatarSize.M
	    },
	    withAvatarLetters: {
	      type: Boolean,
	      default: true
	    },
	    customSource: {
	      type: String,
	      default: ''
	    },
	    withSpecialTypes: {
	      type: Boolean,
	      default: true
	    },
	    withSpecialTypeIcon: {
	      type: Boolean,
	      default: true
	    },
	    withTooltip: {
	      type: Boolean,
	      default: true
	    }
	  },
	  computed: {
	    AvatarType: () => AvatarType,
	    dialog() {
	      return this.$store.getters['chats/get'](this.dialogId, true);
	    },
	    dialogName() {
	      return this.dialog.name;
	    },
	    dialogAvatarUrl() {
	      return this.dialog.avatar;
	    },
	    collabBackgroundColor() {
	      return im_v2_const.Color.collab60;
	    }
	  },
	  template: `
		<BaseUiAvatar
			:type="AvatarType.collab"
			:key="dialogId"
			:title="dialogName" 
			:size="size" 
			:url="dialogAvatarUrl" 
			:backgroundColor="collabBackgroundColor" 
		/>
	`
	};

	// @vue/component
	const CollaberAvatar = {
	  name: 'CollaberAvatar',
	  components: {
	    BaseUiAvatar
	  },
	  props: {
	    dialogId: {
	      type: [String, Number],
	      default: 0
	    },
	    size: {
	      type: String,
	      default: AvatarSize.M
	    },
	    withAvatarLetters: {
	      type: Boolean,
	      default: true
	    },
	    customSource: {
	      type: String,
	      default: ''
	    },
	    withSpecialTypes: {
	      type: Boolean,
	      default: true
	    },
	    withSpecialTypeIcon: {
	      type: Boolean,
	      default: true
	    },
	    withTooltip: {
	      type: Boolean,
	      default: true
	    }
	  },
	  computed: {
	    AvatarType: () => AvatarType,
	    dialog() {
	      return this.$store.getters['chats/get'](this.dialogId, true);
	    },
	    dialogName() {
	      return this.dialog.name;
	    },
	    dialogAvatarUrl() {
	      return this.dialog.avatar;
	    },
	    collaberBackgroundColor() {
	      return im_v2_const.Color.collab60;
	    }
	  },
	  template: `
		<BaseUiAvatar
			:type="AvatarType.collaber"
			:key="dialogId"
			:title="dialogName" 
			:size="size" 
			:url="dialogAvatarUrl"
			:backgroundColor="collaberBackgroundColor" 
		/>
	`
	};

	// @vue/component
	const ExtranetChatAvatar = {
	  name: 'ExtranetChatAvatar',
	  components: {
	    Avatar
	  },
	  props: {
	    dialogId: {
	      type: [String, Number],
	      default: 0
	    },
	    size: {
	      type: String,
	      default: AvatarSize.M
	    },
	    withAvatarLetters: {
	      type: Boolean,
	      default: true
	    },
	    customSource: {
	      type: String,
	      default: ''
	    },
	    withSpecialTypes: {
	      type: Boolean,
	      default: true
	    },
	    withSpecialTypeIcon: {
	      type: Boolean,
	      default: true
	    },
	    withTooltip: {
	      type: Boolean,
	      default: true
	    }
	  },
	  computed: {
	    dialog() {
	      return this.$store.getters['chats/get'](this.dialogId, true);
	    },
	    dialogName() {
	      return this.dialog.name;
	    },
	    dialogAvatarUrl() {
	      return this.dialog.avatar;
	    },
	    extranetBackgroundColor() {
	      return im_v2_const.Color.orange50;
	    }
	  },
	  template: `
		<Avatar
			:dialogId="dialogId"
			:title="dialogName" 
			:size="size" 
			:url="dialogAvatarUrl" 
			:backgroundColor="extranetBackgroundColor" 
		/>
	`
	};

	// @vue/component
	const ChatNotesAvatar = {
	  name: 'ChatNotesAvatar',
	  props: {
	    dialogId: {
	      type: [String, Number],
	      default: 0
	    },
	    size: {
	      type: String,
	      default: AvatarSize.M
	    },
	    withAvatarLetters: {
	      type: Boolean,
	      default: true
	    },
	    customSource: {
	      type: String,
	      default: ''
	    },
	    withSpecialTypes: {
	      type: Boolean,
	      default: true
	    },
	    withSpecialTypeIcon: {
	      type: Boolean,
	      default: true
	    },
	    withTooltip: {
	      type: Boolean,
	      default: true
	    }
	  },
	  computed: {
	    sizeClass() {
	      return `--size-${this.size.toLowerCase()}`;
	    }
	  },
	  methods: {
	    loc(phraseCode) {
	      return this.$Bitrix.Loc.getMessage(phraseCode);
	    }
	  },
	  template: `
		<div :class="sizeClass" class="bx-im-chat-notes-avatar" :title="loc('IM_ELEMENTS_CHAT_MY_NOTES')"></div>
	`
	};

	const ChatAvatarType = {
	  notes: 'notes'
	};

	// @vue/component
	const ChatAvatar = {
	  name: 'ChatAvatar',
	  components: {
	    Avatar,
	    CollabAvatar: CollabChatAvatar,
	    CollaberAvatar,
	    ExtranetUserAvatar: im_v2_component_elements.ExtranetUserAvatar,
	    ChatNotesAvatar
	  },
	  props: {
	    avatarDialogId: {
	      type: [String, Number],
	      default: 0
	    },
	    contextDialogId: {
	      type: String,
	      required: true
	    },
	    size: {
	      type: String,
	      default: AvatarSize.M
	    },
	    withAvatarLetters: {
	      type: Boolean,
	      default: true
	    },
	    withSpecialTypes: {
	      type: Boolean,
	      default: true
	    },
	    withSpecialTypeIcon: {
	      type: Boolean,
	      default: true
	    },
	    withTooltip: {
	      type: Boolean,
	      default: true
	    },
	    customType: {
	      type: String,
	      default: ''
	    }
	  },
	  computed: {
	    isUser() {
	      return this.avatarDialog.type === im_v2_const.ChatType.user;
	    },
	    user() {
	      return this.$store.getters['users/get'](this.avatarDialogId, true);
	    },
	    customAvatarUrl() {
	      const copilotManager = new im_v2_lib_copilot.CopilotManager();
	      if (!copilotManager.isCopilotChatOrBot(this.avatarDialogId)) {
	        return '';
	      }
	      return copilotManager.getRoleAvatarUrl({
	        avatarDialogId: this.avatarDialogId,
	        contextDialogId: this.contextDialogId
	      });
	    },
	    avatarDialog() {
	      return this.$store.getters['chats/get'](this.avatarDialogId, true);
	    },
	    isCollabChat() {
	      return this.avatarDialog.type === im_v2_const.ChatType.collab;
	    },
	    isCollaber() {
	      var _this$user;
	      return ((_this$user = this.user) == null ? void 0 : _this$user.type) === im_v2_const.UserType.collaber;
	    },
	    isExtranetChat() {
	      return this.avatarDialog.extranet;
	    },
	    isExtranet() {
	      var _this$user2;
	      return ((_this$user2 = this.user) == null ? void 0 : _this$user2.type) === im_v2_const.UserType.extranet;
	    },
	    avatarComponent() {
	      if (this.customType === ChatAvatarType.notes) {
	        return ChatNotesAvatar;
	      }
	      if (this.isExtranet) {
	        return im_v2_component_elements.ExtranetUserAvatar;
	      }
	      if (this.isCollaber) {
	        return CollaberAvatar;
	      }
	      if (this.isCollabChat) {
	        return CollabChatAvatar;
	      }
	      return this.isExtranetChat ? ExtranetChatAvatar : Avatar;
	    }
	  },
	  template: `
		<component
			:is="avatarComponent"
			:dialogId="avatarDialogId"
			:customSource="customAvatarUrl"
			:size="size"
			:withAvatarLetters="withAvatarLetters"
			:withSpecialTypes="withSpecialTypes"
			:withSpecialTypeIcon="withSpecialTypeIcon"
			:withTooltip="withTooltip"
		/>
	`
	};

	// @vue/component
	const ExtranetUserAvatar = {
	  name: 'ExtranetUserAvatar',
	  components: {
	    BaseUiAvatar
	  },
	  props: {
	    dialogId: {
	      type: [String, Number],
	      default: 0
	    },
	    size: {
	      type: String,
	      default: AvatarSize.M
	    },
	    withAvatarLetters: {
	      type: Boolean,
	      default: true
	    },
	    customSource: {
	      type: String,
	      default: ''
	    },
	    withSpecialTypes: {
	      type: Boolean,
	      default: true
	    },
	    withSpecialTypeIcon: {
	      type: Boolean,
	      default: true
	    },
	    withTooltip: {
	      type: Boolean,
	      default: true
	    }
	  },
	  computed: {
	    AvatarType: () => AvatarType,
	    dialog() {
	      return this.$store.getters['chats/get'](this.dialogId, true);
	    },
	    dialogName() {
	      return this.dialog.name;
	    },
	    dialogAvatarUrl() {
	      return this.dialog.avatar;
	    }
	  },
	  template: `
		<BaseUiAvatar
			:type="AvatarType.extranet"
			:title="dialogName"
			:size="size"
			:url="dialogAvatarUrl"
		/>
	`
	};

	// @vue/component
	const MessageAvatar = {
	  name: 'MessageAvatar',
	  components: {
	    Avatar,
	    CollaberAvatar
	  },
	  props: {
	    messageId: {
	      type: [String, Number],
	      default: 0
	    },
	    authorId: {
	      type: [String, Number],
	      default: 0
	    },
	    size: {
	      type: String,
	      default: AvatarSize.M
	    },
	    withAvatarLetters: {
	      type: Boolean,
	      default: true
	    },
	    withSpecialTypes: {
	      type: Boolean,
	      default: true
	    },
	    withSpecialTypeIcon: {
	      type: Boolean,
	      default: true
	    },
	    withTooltip: {
	      type: Boolean,
	      default: true
	    }
	  },
	  computed: {
	    customAvatarUrl() {
	      const copilotManager = new im_v2_lib_copilot.CopilotManager();
	      if (!copilotManager.isCopilotMessage(this.messageId)) {
	        return '';
	      }
	      return copilotManager.getMessageRoleAvatar(this.messageId);
	    },
	    user() {
	      return this.$store.getters['users/get'](this.authorId, true);
	    },
	    avatarComponent() {
	      var _avatarMap$this$user$;
	      const avatarMap = {
	        [im_v2_const.UserType.extranet]: ExtranetUserAvatar,
	        [im_v2_const.UserType.collaber]: CollaberAvatar
	      };
	      return (_avatarMap$this$user$ = avatarMap[this.user.type]) != null ? _avatarMap$this$user$ : Avatar;
	    }
	  },
	  template: `
		<component
			:is="avatarComponent"
			:dialogId="authorId"
			:customSource="customAvatarUrl"
			:size="size"
			:withAvatarLetters="withAvatarLetters"
			:withSpecialTypes="withSpecialTypes"
			:withSpecialTypeIcon="withSpecialTypeIcon"
			:withTooltip="withTooltip"
		/>
	`
	};

	const EmptyAvatarType = Object.freeze({
	  default: 'default',
	  squared: 'squared',
	  collab: 'collab'
	});
	const COLLAB_EMPTY_AVATAR_URL = '/bitrix/js/im/v2/component/elements/src/avatar/components/base/css/images/camera.png';

	// @vue/component
	const EmptyAvatar = {
	  name: 'EmptyAvatar',
	  components: {
	    BaseUiAvatar
	  },
	  props: {
	    url: {
	      type: String,
	      default: ''
	    },
	    title: {
	      type: String,
	      default: ''
	    },
	    type: {
	      type: String,
	      default: EmptyAvatarType.default
	    },
	    size: {
	      type: String,
	      default: AvatarSize.M
	    }
	  },
	  data() {
	    return {
	      imageLoadError: false
	    };
	  },
	  computed: {
	    AvatarSize: () => AvatarSize,
	    AvatarType: () => AvatarType,
	    Color: () => im_v2_const.Color,
	    isSquared() {
	      return this.type === EmptyAvatarType.squared;
	    },
	    isCollabType() {
	      return this.type === EmptyAvatarType.collab;
	    },
	    collabEmptyAvatarUrl() {
	      if (!main_core.Type.isStringFilled(this.url)) {
	        return COLLAB_EMPTY_AVATAR_URL;
	      }
	      return this.url;
	    },
	    containerClasses() {
	      const classes = [`--size-${this.size.toLowerCase()}`];
	      if (this.isSquared) {
	        classes.push('--squared');
	      }
	      return classes;
	    }
	  },
	  template: `
		<BaseUiAvatar
			:type="AvatarType.collab"
			v-if="isCollabType" 
			:url="collabEmptyAvatarUrl" 
			:size="size"
			:title="title"
			:backgroundColor="Color.collab10"
		/>
		<div v-else class="bx-im-empty-avatar__container" :class="containerClasses">
			<div v-if="!url" class="bx-im-empty-avatar__avatar --default"></div>
			<img v-else class="bx-im-empty-avatar__avatar --image" :src="url" :alt="title"/>
		</div>
	`
	};

	const DialogSpecialType = {
	  bot: 'bot',
	  extranet: 'extranet',
	  network: 'network',
	  collaber: 'collaber',
	  support24: 'support24'
	};
	const TitleIcons = {
	  absent: 'absent',
	  birthday: 'birthday'
	};
	const ChatTitleType = {
	  notes: 'notes'
	};
	const ChatTitle = {
	  name: 'ChatTitle',
	  props: {
	    dialogId: {
	      type: [Number, String],
	      default: 0
	    },
	    text: {
	      type: String,
	      default: ''
	    },
	    showItsYou: {
	      type: Boolean,
	      default: true
	    },
	    withLeftIcon: {
	      type: Boolean,
	      default: true
	    },
	    withColor: {
	      type: Boolean,
	      default: false
	    },
	    withMute: {
	      type: Boolean,
	      default: false
	    },
	    onlyFirstName: {
	      type: Boolean,
	      default: false
	    },
	    twoLine: {
	      type: Boolean,
	      default: false
	    },
	    customType: {
	      type: String,
	      default: ''
	    }
	  },
	  computed: {
	    dialog() {
	      return this.$store.getters['chats/get'](this.dialogId, true);
	    },
	    user() {
	      return this.$store.getters['users/get'](this.dialogId, true);
	    },
	    botType() {
	      if (!this.isUser) {
	        return '';
	      }
	      const {
	        type
	      } = this.$store.getters['users/bots/getByUserId'](this.dialogId);
	      return type;
	    },
	    isUser() {
	      return this.dialog.type === im_v2_const.ChatType.user;
	    },
	    isSelfChat() {
	      return this.isUser && this.user.id === im_v2_application_core.Core.getUserId();
	    },
	    containerClasses() {
	      const classes = [];
	      if (this.twoLine) {
	        classes.push('--twoline');
	      }
	      return classes;
	    },
	    dialogName() {
	      if (this.customType === ChatTitleType.notes) {
	        return this.loc('IM_SEARCH_MY_NOTES');
	      }
	      if (this.text) {
	        return main_core.Text.encode(this.text);
	      }
	      let resultText = this.dialog.name;
	      if (this.isUser) {
	        resultText = this.onlyFirstName ? this.user.firstName : this.user.name;
	      }
	      return main_core.Text.encode(resultText);
	    },
	    dialogSpecialType() {
	      if (!this.isUser) {
	        if (this.isCollabChat) {
	          return '';
	        }
	        if (this.isExtranet) {
	          return DialogSpecialType.extranet;
	        }
	        if ([im_v2_const.ChatType.support24Notifier, im_v2_const.ChatType.support24Question].includes(this.dialog.type)) {
	          return DialogSpecialType.support24;
	        }
	        return '';
	      }
	      if (this.isSelfChat) {
	        return '';
	      }
	      if (this.isBot) {
	        return this.botType;
	      }
	      if (this.isExtranet) {
	        return DialogSpecialType.extranet;
	      }
	      if (this.isCollaber) {
	        return DialogSpecialType.collaber;
	      }
	      if (this.isNetwork) {
	        return DialogSpecialType.network;
	      }
	      return '';
	    },
	    isDialogSpecialTypeWithLeftIcon() {
	      if (this.isCollaber || this.isExtranet) {
	        return false;
	      }
	      return main_core.Type.isStringFilled(this.dialogSpecialType);
	    },
	    leftIcon() {
	      if (!this.withLeftIcon || this.isSelfChat) {
	        return '';
	      }
	      if (this.isDialogSpecialTypeWithLeftIcon) {
	        return this.dialogSpecialType;
	      }
	      if (!this.isUser) {
	        return '';
	      }
	      if (this.showBirthdays && this.user.isBirthday) {
	        return TitleIcons.birthday;
	      }
	      if (this.user.isAbsent) {
	        return TitleIcons.absent;
	      }
	      return '';
	    },
	    color() {
	      if (!this.withColor || this.specialColor) {
	        return '';
	      }
	      return this.dialog.color;
	    },
	    specialColor() {
	      return this.dialogSpecialType;
	    },
	    isBot() {
	      if (!this.isUser) {
	        return false;
	      }
	      return this.user.type === im_v2_const.UserType.bot;
	    },
	    isExtranet() {
	      if (this.isUser) {
	        return this.user.type === im_v2_const.UserType.extranet;
	      }
	      return this.dialog.extranet;
	    },
	    isCollaber() {
	      return this.user.type === im_v2_const.UserType.collaber;
	    },
	    isCollabChat() {
	      return this.dialog.type === im_v2_const.ChatType.collab;
	    },
	    isNetwork() {
	      if (this.isUser) {
	        return this.user.network;
	      }
	      return false;
	    },
	    isChatMuted() {
	      if (this.isUser) {
	        return false;
	      }
	      const isMuted = this.dialog.muteList.find(element => {
	        return element === im_v2_application_core.Core.getUserId();
	      });
	      return Boolean(isMuted);
	    },
	    tooltipText() {
	      if (this.customType === ChatTitleType.notes) {
	        return this.loc('IM_SEARCH_MY_NOTES');
	      }
	      if (this.isSelfChat && this.showItsYou) {
	        return `${this.dialog.name} (${this.loc('IM_LIST_RECENT_CHAT_SELF')})`;
	      }
	      return this.dialog.name;
	    },
	    showBirthdays() {
	      return this.$store.getters['application/settings/get'](im_v2_const.Settings.recent.showBirthday);
	    }
	  },
	  methods: {
	    loc(phraseCode) {
	      return this.$Bitrix.Loc.getMessage(phraseCode);
	    }
	  },
	  template: `
		<div :class="containerClasses" class="bx-im-chat-title__scope bx-im-chat-title__container">
			<span class="bx-im-chat-title__content">
				<span v-if="leftIcon" :class="'--' + leftIcon" class="bx-im-chat-title__icon"></span>
				<span
					:class="[specialColor ? '--' + specialColor : '']"
					:style="{color: color}"
					:title="tooltipText"
					class="bx-im-chat-title__text"
					v-html="dialogName"
				></span>
				<strong v-if="isSelfChat && showItsYou">
					<span class="bx-im-chat-title__text --self">({{ loc('IM_LIST_RECENT_CHAT_SELF') }})</span>
				</strong>
				<span v-if="withMute && isChatMuted" class="bx-im-chat-title__muted-icon"></span>
			</span>
		</div>
	`
	};

	// @vue/component
	const MessageAuthorTitle = {
	  name: 'MessageAuthorTitle',
	  components: {
	    ChatTitle
	  },
	  props: {
	    dialogId: {
	      type: [Number, String],
	      default: 0
	    },
	    messageId: {
	      type: [Number, String],
	      default: 0
	    },
	    text: {
	      type: String,
	      default: ''
	    },
	    showItsYou: {
	      type: Boolean,
	      default: true
	    },
	    withLeftIcon: {
	      type: Boolean,
	      default: true
	    },
	    withColor: {
	      type: Boolean,
	      default: false
	    },
	    withMute: {
	      type: Boolean,
	      default: false
	    },
	    onlyFirstName: {
	      type: Boolean,
	      default: false
	    },
	    twoLine: {
	      type: Boolean,
	      default: false
	    }
	  },
	  computed: {
	    message() {
	      return this.$store.getters['messages/getById'](this.messageId);
	    },
	    authorId() {
	      return this.message.authorId;
	    },
	    customAuthorName() {
	      const copilotManager = new im_v2_lib_copilot.CopilotManager();
	      if (!copilotManager.isCopilotBot(this.dialogId)) {
	        return '';
	      }
	      return copilotManager.getNameWithRole({
	        dialogId: this.dialogId,
	        messageId: this.messageId
	      });
	    }
	  },
	  template: `
		<ChatTitle 
			:dialogId="dialogId"
			:text="customAuthorName"
			:showItsYou="showItsYou"
			:withLeftIcon="withLeftIcon"
			:withColor="withColor"
			:withMute="withMute"
			:onlyFirstName="onlyFirstName"
			:twoLine="twoLine"
		/>
	`
	};

	const ButtonSize = {
	  S: 'S',
	  // 18
	  M: 'M',
	  // 26
	  L: 'L',
	  // 31
	  XL: 'XL',
	  // 39
	  XXL: 'XXL' // 47
	};

	const ButtonColor = {
	  Primary: 'primary',
	  PrimaryLight: 'primary-light',
	  Copilot: 'copilot',
	  Success: 'success',
	  Danger: 'danger',
	  LightBorder: 'light-border',
	  DangerBorder: 'danger-border',
	  PrimaryBorder: 'primary-border',
	  Link: 'link',
	  Collab: 'collab',
	  Delete: 'delete',
	  Forward: 'forward'
	};
	const ButtonIcon = {
	  Plus: 'plus',
	  Link: 'link',
	  Call: 'call',
	  EndCall: 'end-call',
	  AddUser: 'add-user',
	  Camera: 'camera',
	  Delete: 'delete',
	  Forward: 'forward'
	};
	// @vue/component
	const Button = {
	  name: 'MessengerButton',
	  props: {
	    size: {
	      type: String,
	      required: true
	    },
	    text: {
	      type: String,
	      required: false,
	      default: ''
	    },
	    icon: {
	      type: String,
	      required: false,
	      default: ''
	    },
	    color: {
	      type: String,
	      required: false,
	      default: ButtonColor.Primary
	    },
	    customColorScheme: {
	      type: Object,
	      required: false,
	      default: () => {
	        return {
	          borderColor: '',
	          backgroundColor: '',
	          iconColor: '',
	          textColor: '',
	          hoverColor: '',
	          textHoverColor: ''
	        };
	      }
	    },
	    isRounded: {
	      type: Boolean,
	      required: false,
	      default: false
	    },
	    isDisabled: {
	      type: Boolean,
	      required: false,
	      default: false
	    },
	    isLoading: {
	      type: Boolean,
	      required: false,
	      default: false
	    },
	    isUppercase: {
	      type: Boolean,
	      required: false,
	      default: true
	    }
	  },
	  emits: ['click'],
	  computed: {
	    buttonStyles() {
	      const result = {};
	      if (this.hasCustomColorScheme) {
	        var _this$customColorSche;
	        result['--im-button__border-color'] = this.customColorScheme.borderColor;
	        result['--im-button__background-color'] = this.customColorScheme.backgroundColor;
	        result['--im-button__color'] = this.customColorScheme.textColor;
	        result['--im-button__background-color_hover'] = this.customColorScheme.hoverColor;
	        result['--im-button__color_hover'] = (_this$customColorSche = this.customColorScheme.textHoverColor) != null ? _this$customColorSche : this.customColorScheme.textColor;
	      }
	      return result;
	    },
	    buttonClasses() {
	      const classes = [`--size-${this.size.toLowerCase()}`];
	      if (!this.hasCustomColorScheme) {
	        classes.push(`--color-${this.color.toLowerCase()}`);
	      }
	      if (this.isRounded) {
	        classes.push('--rounded');
	      }
	      if (this.isDisabled) {
	        classes.push('--disabled');
	      }
	      if (this.isLoading) {
	        classes.push('--loading');
	      }
	      if (this.isUppercase && this.size !== ButtonSize.S) {
	        classes.push('--uppercase');
	      }
	      if (this.text === '') {
	        classes.push('--no-text');
	      }
	      return classes;
	    },
	    iconStyles() {
	      const result = {};
	      if (this.hasCustomColorScheme) {
	        result.backgroundColor = this.customColorScheme.iconColor;
	      }
	      return result;
	    },
	    iconClasses() {
	      const classes = [`--${this.icon}`];
	      if (this.hasCustomColorScheme) {
	        classes.push('--custom-color');
	      }
	      return classes;
	    },
	    hasCustomColorScheme() {
	      return main_core.Type.isPlainObject(this.customColorScheme) && main_core.Type.isStringFilled(this.customColorScheme.borderColor) && main_core.Type.isStringFilled(this.customColorScheme.iconColor) && main_core.Type.isStringFilled(this.customColorScheme.textColor) && main_core.Type.isStringFilled(this.customColorScheme.hoverColor);
	    }
	  },
	  methods: {
	    onClick(event) {
	      if (this.isDisabled || this.isLoading) {
	        return;
	      }
	      this.$emit('click', event);
	    }
	  },
	  template: `
		<button
			:class="buttonClasses"
			:style="buttonStyles"
			@click.stop="onClick"
			class="bx-im-button__scope bx-im-button__container"
		>
			<span v-if="icon" :style="iconStyles" :class="iconClasses" class="bx-im-button__icon"></span>
			<span class="bx-im-button__text">{{ text }}</span>
		</button>
	`
	};

	const POPUP_CONTAINER_PREFIX = '#popup-window-content-';
	const POPUP_BORDER_RADIUS = '10px';

	// @vue/component
	const MessengerPopup = {
	  name: 'MessengerPopup',
	  props: {
	    id: {
	      type: String,
	      required: true
	    },
	    config: {
	      type: Object,
	      required: false,
	      default() {
	        return {};
	      }
	    }
	  },
	  emits: ['close'],
	  computed: {
	    popupContainer() {
	      return `${POPUP_CONTAINER_PREFIX}${this.id}`;
	    }
	  },
	  created() {
	    im_v2_lib_logger.Logger.warn(`Popup: ${this.id} created`);
	    this.instance = this.getPopupInstance();
	    this.instance.show();
	  },
	  mounted() {
	    this.instance.adjustPosition({
	      forceBindPosition: true,
	      position: this.getPopupConfig().bindOptions.position
	    });
	  },
	  beforeUnmount() {
	    if (!this.instance) {
	      return;
	    }
	    this.closePopup();
	  },
	  methods: {
	    getPopupInstance() {
	      if (!this.instance) {
	        var _PopupManager$getPopu;
	        (_PopupManager$getPopu = main_popup.PopupManager.getPopupById(this.id)) == null ? void 0 : _PopupManager$getPopu.destroy();
	        this.instance = new main_popup.Popup(this.getPopupConfig());
	      }
	      return this.instance;
	    },
	    getDefaultConfig() {
	      return {
	        id: this.id,
	        bindOptions: {
	          position: 'bottom'
	        },
	        offsetTop: 0,
	        offsetLeft: 0,
	        className: 'bx-im-messenger__scope',
	        cacheable: false,
	        closeIcon: false,
	        autoHide: true,
	        closeByEsc: true,
	        animation: 'fading',
	        events: {
	          onPopupClose: this.closePopup.bind(this),
	          onPopupDestroy: this.closePopup.bind(this)
	        },
	        contentBorderRadius: POPUP_BORDER_RADIUS
	      };
	    },
	    getPopupConfig() {
	      var _this$config$offsetTo, _this$config$bindOpti;
	      const defaultConfig = this.getDefaultConfig();
	      const modifiedOptions = {};
	      const defaultClassName = defaultConfig.className;
	      if (this.config.className) {
	        modifiedOptions.className = `${defaultClassName} ${this.config.className}`;
	      }
	      const offsetTop = (_this$config$offsetTo = this.config.offsetTop) != null ? _this$config$offsetTo : defaultConfig.offsetTop;
	      // adjust for default popup margin for shadow
	      if (((_this$config$bindOpti = this.config.bindOptions) == null ? void 0 : _this$config$bindOpti.position) === 'top' && main_core.Type.isNumber(this.config.offsetTop)) {
	        modifiedOptions.offsetTop = offsetTop - 10;
	      }
	      return {
	        ...defaultConfig,
	        ...this.config,
	        ...modifiedOptions
	      };
	    },
	    closePopup() {
	      im_v2_lib_logger.Logger.warn(`Popup: ${this.id} closing`);
	      this.$emit('close');
	      this.instance.destroy();
	      this.instance = null;
	    },
	    enableAutoHide() {
	      this.getPopupInstance().setAutoHide(true);
	    },
	    disableAutoHide() {
	      this.getPopupInstance().setAutoHide(false);
	    },
	    adjustPosition() {
	      this.getPopupInstance().adjustPosition({
	        forceBindPosition: true,
	        position: this.getPopupConfig().bindOptions.position
	      });
	    }
	  },
	  template: `
		<Teleport :to="popupContainer">
			<slot
				:adjustPosition="adjustPosition"
				:enableAutoHide="enableAutoHide"
				:disableAutoHide="disableAutoHide"
			></slot>
		</Teleport>
	`
	};

	const MenuItemIcon = {
	  chat: 'chat',
	  channel: 'channel',
	  collab: 'collab',
	  conference: 'conference',
	  upload: 'upload',
	  file: 'file',
	  task: 'task',
	  meeting: 'meeting',
	  summary: 'summary',
	  vote: 'vote',
	  aiText: 'ai-text',
	  aiImage: 'ai-image',
	  copilot: 'copilot',
	  calendarSlot: 'calendar-slot',
	  documentSign: 'document-sign',
	  b24: 'b24'
	};

	// @vue/component
	const MenuItem = {
	  name: 'MenuItem',
	  props: {
	    icon: {
	      type: String,
	      required: false,
	      default: ''
	    },
	    title: {
	      type: String,
	      required: true
	    },
	    subtitle: {
	      type: String,
	      required: false,
	      default: ''
	    },
	    disabled: {
	      type: Boolean,
	      required: false,
	      default: false
	    },
	    counter: {
	      type: Number,
	      required: false,
	      default: 0
	    }
	  },
	  computed: {
	    formattedCounter() {
	      if (this.counter === 0) {
	        return '';
	      }
	      return this.counter > 99 ? '99+' : String(this.counter);
	    }
	  },
	  template: `
		<div class="bx-im-menu-item__container" :class="{'--disabled': disabled}">
			<div class="bx-im-menu-item__content" :class="{'--with-icon': !!icon}">
				<div v-if="icon" class="bx-im-menu_item__icon" :class="'--' + icon"></div>
				<div class="bx-im-menu-item__text-content" :class="{'--with-subtitle': !!subtitle}">
					<div class="bx-im-menu-item__title">
						<div class="bx-im-menu-item__title_text">{{ title }}</div>
						<slot name="after-title"></slot>
						<div v-if="counter" class="bx-im-menu-item__title_counter">{{ formattedCounter }}</div>
					</div>
					<div v-if="subtitle" :title="subtitle" class="bx-im-menu-item__subtitle">{{ subtitle }}</div>
					<slot name="below-content"></slot>
				</div>
			</div>
		</div>
	`
	};

	const ID_PREFIX = 'im-v2-menu';

	// @vue/component
	const MessengerMenu = {
	  name: 'MessengerMenu',
	  components: {
	    MessengerPopup
	  },
	  props: {
	    config: {
	      type: Object,
	      required: true
	    },
	    className: {
	      type: String,
	      required: false,
	      default: ''
	    }
	  },
	  emits: ['close'],
	  data() {
	    return {
	      id: ''
	    };
	  },
	  created() {
	    var _this$config$id;
	    this.id = (_this$config$id = this.config.id) != null ? _this$config$id : `${ID_PREFIX}-${im_v2_lib_utils.Utils.text.getUuidV4()}`;
	  },
	  template: `
		<MessengerPopup
			:config="config"
			@close="$emit('close')"
			:id="id"
		>
			<div class="bx-im-menu__container" :class="className">
				<slot name="header"></slot>
				<slot></slot>
				<slot name="footer"></slot>
			</div>
		</MessengerPopup>
	`
	};

	// @vue/component
	const AttachDelimiter = {
	  name: 'AttachDelimiter',
	  props: {
	    config: {
	      type: Object,
	      default: () => {}
	    }
	  },
	  computed: {
	    internalConfig() {
	      return this.config;
	    },
	    styles() {
	      const result = {};
	      if (this.internalConfig.delimiter.color) {
	        result.backgroundColor = this.internalConfig.delimiter.color;
	      }
	      if (this.internalConfig.delimiter.size > 0) {
	        result.width = `${this.internalConfig.delimiter.size}px`;
	      }
	      return result;
	    }
	  },
	  template: `
		<div class="bx-im-attach-delimiter__container" :style="styles"></div>
	`
	};

	const AttachFileItem = {
	  name: 'AttachFileItem',
	  props: {
	    config: {
	      type: Object,
	      default: () => {}
	    }
	  },
	  computed: {
	    internalConfig() {
	      return this.config;
	    },
	    fileName() {
	      return this.internalConfig.name;
	    },
	    fileSize() {
	      return this.internalConfig.size;
	    },
	    link() {
	      return this.internalConfig.link;
	    },
	    fileShortName() {
	      const NAME_MAX_LENGTH = 70;
	      const fileName = main_core.Type.isStringFilled(this.fileName) ? this.fileName : this.$Bitrix.Loc.getMessage('IM_ELEMENTS_ATTACH_RICH_FILE_NO_NAME');
	      return im_v2_lib_utils.Utils.file.getShortFileName(fileName, NAME_MAX_LENGTH);
	    },
	    formattedFileSize() {
	      if (!this.fileSize) {
	        return '';
	      }
	      return im_v2_lib_utils.Utils.file.formatFileSize(this.fileSize);
	    },
	    iconClasses() {
	      return ['ui-icon', `ui-icon-file-${this.fileIcon}`];
	    },
	    fileIcon() {
	      return im_v2_lib_utils.Utils.file.getIconTypeByFilename(this.fileName);
	    }
	  },
	  methods: {
	    openLink() {
	      if (!this.link) {
	        return;
	      }
	      window.open(this.link, '_blank');
	    }
	  },
	  template: `
		<div @click="openLink" class="bx-im-attach-file__container">
			<div class="bx-im-attach-file__item">
				<div class="bx-im-attach-file__icon">
					<div :class="iconClasses"><i></i></div>
				</div>
				<div class="bx-im-attach-file__block">
					<div class="bx-im-attach-file__name" :title="fileName">
						{{ fileShortName }}
					</div>
					<div class="bx-im-attach-file__size">
						{{ formattedFileSize }}
					</div>
				</div>
			</div>
		</div>
	`
	};

	// @vue/component
	const AttachFile = {
	  name: 'AttachFile',
	  components: {
	    AttachFileItem
	  },
	  props: {
	    config: {
	      type: Object,
	      default: () => {}
	    }
	  },
	  computed: {
	    internalConfig() {
	      return this.config;
	    }
	  },
	  template: `
		<div class="bx-im-attach-file__container">
			<AttachFileItem
				v-for="(fileItem, index) in internalConfig.file"
				:config="fileItem"
				:key="index"
			/>
		</div>
	`
	};

	const AttachGridItemDisplayType = {
	  block: 'block',
	  line: 'line',
	  row: 'row'
	};
	const DisplayType = AttachGridItemDisplayType;

	// @vue/component
	const AttachGridItem = {
	  name: 'AttachGridItem',
	  props: {
	    config: {
	      type: Object,
	      default: () => {}
	    }
	  },
	  computed: {
	    DisplayType: () => DisplayType,
	    internalConfig() {
	      return this.config;
	    },
	    display() {
	      return this.internalConfig.display.toLowerCase();
	    },
	    width() {
	      if (!this.value || !this.internalConfig.width) {
	        return '';
	      }
	      return `${this.internalConfig.width}px`;
	    },
	    value() {
	      if (!this.internalConfig.value) {
	        return '';
	      }
	      return im_v2_lib_parser.Parser.decodeText(this.internalConfig.value);
	    },
	    colorToken() {
	      return this.internalConfig.colorToken || 'base';
	    },
	    name() {
	      return this.internalConfig.name;
	    },
	    link() {
	      return this.internalConfig.link;
	    }
	  },
	  template: `
		<div v-if="display === DisplayType.block" :style="{width}" class="bx-im-attach-grid__item --block">
			<div class="bx-im-attach-grid__name">{{ name }}</div>
			<div v-if="link" class="bx-im-attach-grid__value --link">
				<a :href="link" target="_blank" :class="colorToken" v-html="value"></a>
			</div>
			<div v-else v-html="value" :class="colorToken" class="bx-im-attach-grid__value"></div>
		</div>
		<div v-if="display === DisplayType.line" :style="{width}" class="bx-im-attach-grid__item --line">
			<div class="bx-im-attach-grid__name">{{ name }}</div>
			<div v-if="link" :class="colorToken" class="bx-im-attach-grid__value --link">
				<a :href="link" target="_blank" v-html="value"></a>
			</div>
			<div v-else class="bx-im-attach-grid__value" :class="colorToken" v-html="value"></div>
		</div>
		<div v-if="display === DisplayType.row" class="bx-im-attach-grid__item --row">
			<table>
				<tbody>
					<tr>
						<td v-if="name" :colspan="value? 1: 2" :style="{width}" class="bx-im-attach-grid__name">
							{{ name }}
						</td>
						<td
							v-if="value && link"
							:colspan="name? 1: 2"
							:class="colorToken"
							class="bx-im-attach-grid__value --link"
						>
							<a :href="link" target="_blank" v-html="value"></a>
						</td>
						<td
							v-if="value && !link"
							:colspan="name? 1: 2"
							:class="colorToken"
							v-html="value"
							class="bx-im-attach-grid__value"
						>
						</td>
					</tr>
				</tbody>
			</table>
		</div>
	`
	};

	// @vue/component
	const AttachGrid = {
	  name: 'AttachGrid',
	  components: {
	    AttachGridItem
	  },
	  props: {
	    config: {
	      type: Object,
	      default: () => {}
	    }
	  },
	  computed: {
	    internalConfig() {
	      return this.config;
	    }
	  },
	  template: `
		<div class="bx-im-attach-grid__container">
			<AttachGridItem
				v-for="(gridItem, index) in internalConfig.grid"
				:config="gridItem"
				:key="index"
			/>
		</div>
	`
	};

	const AttachHtml = {
	  props: {
	    config: {
	      type: Object,
	      default: () => {}
	    }
	  },
	  computed: {
	    internalConfig() {
	      return this.config;
	    },
	    html() {
	      return im_v2_lib_parser.Parser.decodeHtml(this.internalConfig.html);
	    }
	  },
	  template: `
		<div class="bx-im-element-attach-type-html" v-html="html"></div>
	`
	};

	const MAX_IMAGE_SIZE = 272;

	// @vue/component
	const AttachImageItem = {
	  name: 'AttachImageItem',
	  directives: {
	    lazyload: ui_vue3_directives_lazyload.lazyload
	  },
	  props: {
	    config: {
	      type: Object,
	      default: () => {}
	    }
	  },
	  computed: {
	    internalConfig() {
	      return this.config;
	    },
	    width() {
	      return this.internalConfig.width || 0;
	    },
	    height() {
	      return this.internalConfig.height || 0;
	    },
	    link() {
	      return this.internalConfig.link;
	    },
	    name() {
	      return this.internalConfig.name;
	    },
	    preview() {
	      return this.internalConfig.preview;
	    },
	    source() {
	      var _this$preview;
	      return (_this$preview = this.preview) != null ? _this$preview : this.link;
	    },
	    imageSize() {
	      if (this.width === 0 || this.height === 0) {
	        return {};
	      }
	      const sizes = im_v2_lib_utils.Utils.file.resizeToFitMaxSize(this.width, this.height, MAX_IMAGE_SIZE);
	      return {
	        width: `${sizes.width}px`,
	        height: `${sizes.height}px`,
	        'object-fit': sizes.width < 100 || sizes.height < 100 ? 'cover' : 'contain'
	      };
	    },
	    hasWidth() {
	      return Boolean(this.imageSize.width);
	    }
	  },
	  methods: {
	    open() {
	      if (!this.link) {
	        return;
	      }
	      window.open(this.link, '_blank');
	    },
	    lazyLoadCallback(event) {
	      const {
	        element
	      } = event;
	      if (!main_core.Dom.style(element, 'width')) {
	        main_core.Dom.style(element, 'width', `${element.offsetWidth}px`);
	      }
	      if (!main_core.Dom.style(element, 'height')) {
	        main_core.Dom.style(element, 'height', `${element.offsetHeight}px`);
	      }
	    }
	  },
	  template: `
		<div class="bx-im-attach-image__item" :class="{'--with-width': hasWidth }" @click="open">
			<img
				v-lazyload="{callback: lazyLoadCallback}"
				:data-lazyload-src="source"
				:style="imageSize"
				:title="name"
				:alt="name"
				class="bx-im-attach-image__source"
			/>
		</div>
	`
	};

	const AttachImage = {
	  name: 'AttachImage',
	  components: {
	    AttachImageItem
	  },
	  props: {
	    config: {
	      type: Object,
	      default: () => {}
	    }
	  },
	  computed: {
	    internalConfig() {
	      return this.config;
	    }
	  },
	  template: `
		<div class="bx-im-attach-image__container bx-im-attach-image__scope">
			<AttachImageItem v-for="(image, index) in internalConfig.image" :config="image" :key="index" />
		</div>
	`
	};

	// @vue/component
	const AttachLinkItem = {
	  name: 'AttachLinkItem',
	  components: {
	    AttachImage
	  },
	  props: {
	    config: {
	      type: Object,
	      default: () => {}
	    }
	  },
	  computed: {
	    internalConfig() {
	      return this.config;
	    },
	    link() {
	      return this.internalConfig.link;
	    },
	    name() {
	      var _this$internalConfig$;
	      return (_this$internalConfig$ = this.internalConfig.name) != null ? _this$internalConfig$ : this.link;
	    },
	    description() {
	      return this.internalConfig.desc;
	    },
	    html() {
	      const content = this.internalConfig.html || this.description;
	      return im_v2_lib_parser.Parser.decodeText(content);
	    },
	    preview() {
	      return this.internalConfig.preview;
	    },
	    imageConfig() {
	      return {
	        image: [{
	          name: this.internalConfig.name,
	          preview: this.internalConfig.preview,
	          width: this.internalConfig.width,
	          height: this.internalConfig.height
	        }]
	      };
	    }
	  },
	  template: `
		<div class="bx-im-attach-link__item">
			<a v-if="link" :href="link" target="_blank" class="bx-im-attach-link__link">
				{{ name }}
			</a>
			<span v-else class="bx-im-attach-link__name">
				{{ name }}
			</span>
			<div v-if="internalConfig.html || description" class="bx-im-attach-link__desc" v-html="html"></div>
			<div v-if="preview" class="bx-im-attach-link__image">
				<AttachImage :config="imageConfig" />
			</div>
		</div>
	`
	};

	// @vue/component
	const AttachLink = {
	  name: 'AttachLink',
	  components: {
	    AttachLinkItem
	  },
	  props: {
	    config: {
	      type: Object,
	      default: () => {}
	    }
	  },
	  computed: {
	    internalConfig() {
	      return this.config;
	    }
	  },
	  template: `
		<div class="bx-im-attach-link__container">
			<AttachLinkItem v-for="(link, index) in internalConfig.link" :config="link" :key="index" />
		</div>
	`
	};

	// @vue/component
	const AttachMessage = {
	  name: 'AttachMessage',
	  props: {
	    config: {
	      type: Object,
	      default: () => {}
	    }
	  },
	  computed: {
	    internalConfig() {
	      return this.config;
	    },
	    message() {
	      return im_v2_lib_parser.Parser.decodeText(this.internalConfig.message);
	    }
	  },
	  template: `
		<div class="bx-im-attach-message__container" v-html="message"></div>
	`
	};

	var _restClient = /*#__PURE__*/babelHelpers.classPrivateFieldLooseKey("restClient");
	var _store = /*#__PURE__*/babelHelpers.classPrivateFieldLooseKey("store");
	var _message = /*#__PURE__*/babelHelpers.classPrivateFieldLooseKey("message");
	class RichService {
	  constructor(message) {
	    Object.defineProperty(this, _restClient, {
	      writable: true,
	      value: void 0
	    });
	    Object.defineProperty(this, _store, {
	      writable: true,
	      value: void 0
	    });
	    Object.defineProperty(this, _message, {
	      writable: true,
	      value: void 0
	    });
	    babelHelpers.classPrivateFieldLooseBase(this, _restClient)[_restClient] = im_v2_application_core.Core.getRestClient();
	    babelHelpers.classPrivateFieldLooseBase(this, _store)[_store] = im_v2_application_core.Core.getStore();
	    babelHelpers.classPrivateFieldLooseBase(this, _message)[_message] = message;
	  }
	  deleteRichLink(attachId) {
	    babelHelpers.classPrivateFieldLooseBase(this, _store)[_store].dispatch('messages/deleteAttach', {
	      messageId: babelHelpers.classPrivateFieldLooseBase(this, _message)[_message].id,
	      attachId
	    });
	    babelHelpers.classPrivateFieldLooseBase(this, _restClient)[_restClient].callMethod(im_v2_const.RestMethod.imV2ChatMessageDeleteRichUrl, {
	      messageId: babelHelpers.classPrivateFieldLooseBase(this, _message)[_message].id
	    }).catch(error => {
	      console.error('RichService: error deleting rich link', error);
	    });
	  }
	}

	// @vue/component
	const AttachRichItem = {
	  name: 'AttachRichItem',
	  components: {
	    AttachImage
	  },
	  inject: ['message'],
	  props: {
	    config: {
	      type: Object,
	      default: () => {}
	    },
	    attachId: {
	      type: String,
	      required: true
	    }
	  },
	  computed: {
	    internalConfig() {
	      return this.config;
	    },
	    link() {
	      return this.internalConfig.link;
	    },
	    name() {
	      return im_v2_lib_utils.Utils.text.convertHtmlEntities(this.internalConfig.name);
	    },
	    description() {
	      return im_v2_lib_utils.Utils.text.convertHtmlEntities(this.internalConfig.desc);
	    },
	    html() {
	      return this.internalConfig.html;
	    },
	    preview() {
	      return this.internalConfig.preview;
	    },
	    previewSize() {
	      var _this$internalConfig$, _this$internalConfig$2, _this$internalConfig$3, _this$internalConfig$4;
	      return {
	        width: (_this$internalConfig$ = (_this$internalConfig$2 = this.internalConfig.previewSize) == null ? void 0 : _this$internalConfig$2.width) != null ? _this$internalConfig$ : 0,
	        height: (_this$internalConfig$3 = (_this$internalConfig$4 = this.internalConfig.previewSize) == null ? void 0 : _this$internalConfig$4.height) != null ? _this$internalConfig$3 : 0
	      };
	    },
	    imageConfig() {
	      return {
	        image: [{
	          name: this.name,
	          preview: this.preview,
	          width: this.previewSize.width,
	          height: this.previewSize.height
	        }]
	      };
	    },
	    canShowDeleteIcon() {
	      if (!this.message) {
	        return false;
	      }
	      return this.message.authorId === im_v2_application_core.Core.getUserId();
	    },
	    deleteRichLinkTitle() {
	      return this.$Bitrix.Loc.getMessage('IM_ELEMENTS_ATTACH_RICH_LINK_DELETE');
	    },
	    imageStyles() {
	      if (this.previewSize.width === 0 || this.previewSize.height === 0) {
	        return {
	          width: '272px',
	          height: '272px'
	        };
	      }
	      return {};
	    }
	  },
	  methods: {
	    openLink() {
	      if (!this.link) {
	        return;
	      }
	      window.open(this.link, '_blank');
	    },
	    deleteRichLink() {
	      if (!this.message) {
	        return;
	      }
	      new RichService(this.message).deleteRichLink(this.attachId);
	    }
	  },
	  template: `
		<div class="bx-im-attach-rich__scope bx-im-attach-rich__container">
			<div class="bx-im-attach-rich__block">
				<div class="bx-im-attach-rich__name" @click="openLink">{{ name }}</div>
				<div v-if="html || description" class="bx-im-attach-rich__desc">{{ html || description }}</div>
				<button 
					v-if="canShowDeleteIcon" 
					class="bx-im-attach-rich__hide-icon"
					@click="deleteRichLink"
					:title="deleteRichLinkTitle"
				></button>
			</div>
			<div v-if="preview" class="bx-im-attach-rich__image" @click="openLink" :style="imageStyles">
				<AttachImage :config="imageConfig" />
			</div>
		</div>
	`
	};

	// @vue/component
	const AttachRich = {
	  components: {
	    AttachRichItem
	  },
	  props: {
	    config: {
	      type: Object,
	      default: () => {}
	    },
	    attachId: {
	      type: String,
	      required: true
	    }
	  },
	  computed: {
	    internalConfig() {
	      return this.config;
	    }
	  },
	  template: `
		<div class="bx-im-attach-rich__container">
			<AttachRichItem 
				v-for="(rich, index) in internalConfig.richLink" 
				:config="rich"
				:key="index" 
				:attachId="attachId" 
			/>
		</div>
	`
	};

	const AVATAR_TYPE = {
	  user: 'user',
	  chat: 'chat',
	  bot: 'bot'
	};

	// @vue/component
	const AttachUserItem = {
	  name: 'AttachUserItem',
	  directives: {
	    lazyload: ui_vue3_directives_lazyload.lazyload
	  },
	  props: {
	    config: {
	      type: Object,
	      default: () => {}
	    }
	  },
	  computed: {
	    internalConfig() {
	      return this.config;
	    },
	    name() {
	      return this.internalConfig.name;
	    },
	    avatar() {
	      return this.internalConfig.avatar;
	    },
	    avatarType() {
	      return this.internalConfig.avatarType;
	    },
	    link() {
	      return this.internalConfig.link;
	    },
	    avatarTypeClass() {
	      if (this.avatar) {
	        return '';
	      }
	      let avatarType = AVATAR_TYPE.user;
	      if (this.avatarType === AVATAR_TYPE.chat) {
	        avatarType = AVATAR_TYPE.chat;
	      } else if (this.avatarType === AVATAR_TYPE.bot) {
	        avatarType = AVATAR_TYPE.bot;
	      }
	      return [`--${avatarType}`, 'base'];
	    }
	  },
	  template: `
		<div class="bx-im-attach-user__item">
			<div class="bx-im-attach-user__avatar" :class="avatarTypeClass">
				<img v-if="avatar" v-lazyload :data-lazyload-src="avatar" class="bx-im-attach-user__source" alt="name" />
			</div>
			<a v-if="link" :href="link" class="bx-im-attach-user__name" target="_blank">
				{{ name }}
			</a>
			<span class="bx-im-attach-user__name" v-else>
				{{ name }}
			</span>
		</div>
	`
	};

	// @vue/component
	const AttachUser = {
	  name: 'AttachUser',
	  components: {
	    AttachUserItem
	  },
	  props: {
	    config: {
	      type: Object,
	      default: () => {}
	    }
	  },
	  computed: {
	    internalConfig() {
	      return this.config;
	    }
	  },
	  template: `
		<div class="bx-im-attach-user__container">
			<AttachUserItem v-for="(user, index) in internalConfig.user" :config="user" :key="index" />
		</div>
	`
	};

	const PropertyToComponentMap = {
	  [im_v2_const.AttachType.Delimiter]: AttachDelimiter,
	  [im_v2_const.AttachType.File]: AttachFile,
	  [im_v2_const.AttachType.Grid]: AttachGrid,
	  [im_v2_const.AttachType.Html]: AttachHtml,
	  [im_v2_const.AttachType.Image]: AttachImage,
	  [im_v2_const.AttachType.Link]: AttachLink,
	  [im_v2_const.AttachType.Message]: AttachMessage,
	  [im_v2_const.AttachType.Rich]: AttachRich,
	  [im_v2_const.AttachType.User]: AttachUser
	};

	// @vue/component
	const Attach = {
	  name: 'MessengerAttach',
	  components: {
	    AttachDelimiter,
	    AttachFile,
	    AttachGrid,
	    AttachHtml,
	    AttachImage,
	    AttachLink,
	    AttachMessage,
	    AttachRich,
	    AttachUser
	  },
	  props: {
	    config: {
	      type: Object,
	      default: () => {}
	    }
	  },
	  computed: {
	    internalConfig() {
	      return this.config;
	    },
	    blocks() {
	      return this.internalConfig.blocks;
	    },
	    colorToken() {
	      const {
	        colorToken = im_v2_const.ColorToken.base
	      } = this.internalConfig;
	      return colorToken;
	    }
	  },
	  methods: {
	    getComponentForBlock(block) {
	      const [blockType] = Object.keys(block);
	      if (!PropertyToComponentMap[blockType]) {
	        return '';
	      }
	      return PropertyToComponentMap[blockType];
	    }
	  },
	  template: `
		<div class="bx-im-attach__container bx-im-attach__scope">
			<div class="bx-im-attach__border" :class="colorToken"></div>
			<div class="bx-im-attach__content">
				<component
					v-for="(block, index) in blocks"
					:is="getComponentForBlock(block)"
					:config="block"
					:colorToken="colorToken"
					:key="index"
					:attachId="internalConfig.id.toString()"
				/>
			</div>
		</div>
	`
	};

	// @vue/component
	const ChatInfoContent = {
	  components: {
	    ChatAvatar,
	    ChatTitle,
	    Button
	  },
	  props: {
	    dialogId: {
	      type: String,
	      required: true
	    }
	  },
	  data() {
	    return {
	      hasError: false,
	      isLoading: false
	    };
	  },
	  computed: {
	    ButtonColor: () => ButtonColor,
	    ButtonSize: () => ButtonSize,
	    dialog() {
	      return this.$store.getters['chats/get'](this.dialogId);
	    },
	    user() {
	      return this.$store.getters['users/get'](this.dialogId, true);
	    },
	    isUser() {
	      var _this$dialog;
	      return ((_this$dialog = this.dialog) == null ? void 0 : _this$dialog.type) === im_v2_const.ChatType.user;
	    },
	    isBot() {
	      if (this.isUser) {
	        return this.user.type === im_v2_const.UserType.bot;
	      }
	      return false;
	    },
	    isChat() {
	      return !this.isUser;
	    },
	    chatType() {
	      if (this.isUser) {
	        return this.$store.getters['users/getPosition'](this.dialogId);
	      }
	      return this.$Bitrix.Loc.getMessage('IM_LIST_RECENT_CHAT_TYPE_GROUP_V2');
	    },
	    openChatButtonText() {
	      if (this.isChat) {
	        return this.$Bitrix.Loc.getMessage('IM_ELEMENTS_CHAT_INFO_POPUP_OPEN_CHAT');
	      }
	      return this.$Bitrix.Loc.getMessage('IM_ELEMENTS_CHAT_INFO_POPUP_WRITE_A_MESSAGE');
	    },
	    userProfileLink() {
	      return im_v2_lib_utils.Utils.user.getProfileLink(this.dialogId);
	    }
	  },
	  created() {
	    this.chatService = new im_v2_provider_service.ChatService();
	    if (!this.dialog) {
	      this.loadChat();
	    }
	  },
	  methods: {
	    loadChat() {
	      this.isLoading = true;
	      this.chatService.loadChat(this.dialogId).then(() => {
	        this.isLoading = false;
	      }).catch(error => {
	        this.isLoading = false;
	        this.hasError = true;
	        console.error(error);
	      });
	    },
	    onOpenChat() {
	      im_public.Messenger.openChat(this.dialogId);
	    },
	    onClickVideoCall() {
	      im_public.Messenger.startVideoCall(this.dialogId);
	    }
	  },
	  template: `
		<div class="bx-im-chat-info-content__container">
			<template v-if="!isLoading && !hasError">
				<div class="bx-im-chat-info-content__detail-info-container">
					<div class="bx-im-chat-info-content__avatar-container">
						<ChatAvatar :avatarDialogId="dialogId" :contextDialogId="dialogId" size="XL"/>
					</div>
					<div class="bx-im-chat-info-content__title-container">
						<ChatTitle v-if="isChat" :dialogId="dialogId" />
						<a v-else :href="userProfileLink" target="_blank">
							<ChatTitle :dialogId="dialogId" />
						</a>
						<div class="bx-im-chat-info-content__chat-description_text">
							{{ chatType }}
						</div>
					</div>
				</div>
				<div class="bx-im-chat-info-content__buttons-container">
					<Button
						:size="ButtonSize.M"
						:color="ButtonColor.PrimaryBorder"
						:isRounded="true"
						:text="openChatButtonText"
						:isUppercase="false"
						@click="onOpenChat"
					/>
					<Button
						v-if="isUser && !isBot"
						:size="ButtonSize.M"
						:color="ButtonColor.PrimaryBorder"
						:isRounded="true"
						:isUppercase="false"
						:text="$Bitrix.Loc.getMessage('IM_ELEMENTS_CHAT_INFO_POPUP_VIDEOCALL')"
						@click="onClickVideoCall"
					/>
				</div>
			</template>
			<template v-else-if="isLoading">
				<div class="bx-im-chat-info-content__loader-container">
					<div class="bx-im-chat-info-content__loader_icon"></div>
				</div>
			</template>
			<template v-else-if="hasError">
				<div class="bx-im-chat-info-content__error-container">
					{{ $Bitrix.Loc.getMessage('IM_ELEMENTS_CHAT_INFO_POPUP_NO_ACCESS') }}
				</div>
			</template>
		</div>
	`
	};

	const POPUP_ID = 'im-chat-info-popup';

	// @vue/component
	const ChatInfoPopup = {
	  name: 'ChatInfoPopup',
	  components: {
	    MessengerPopup,
	    ChatInfoContent
	  },
	  props: {
	    showPopup: {
	      type: Boolean,
	      required: true
	    },
	    bindElement: {
	      type: Object,
	      required: true
	    },
	    dialogId: {
	      type: String,
	      required: true
	    }
	  },
	  emits: ['close'],
	  computed: {
	    POPUP_ID: () => POPUP_ID,
	    config() {
	      return {
	        minWidth: 313,
	        height: 134,
	        bindElement: this.bindElement,
	        targetContainer: document.body,
	        offsetTop: 0,
	        padding: 16,
	        angle: true
	      };
	    }
	  },
	  template: `
		<MessengerPopup
			v-if="showPopup" 
			:config="config"
			@close="$emit('close')"
			:id="POPUP_ID"
		>
			<ChatInfoContent :dialogId="dialogId"/>
		</MessengerPopup>
	`
	};

	var _store$1 = /*#__PURE__*/babelHelpers.classPrivateFieldLooseKey("store");
	var _restClient$1 = /*#__PURE__*/babelHelpers.classPrivateFieldLooseKey("restClient");
	var _userManager = /*#__PURE__*/babelHelpers.classPrivateFieldLooseKey("userManager");
	class UserListService {
	  constructor() {
	    Object.defineProperty(this, _store$1, {
	      writable: true,
	      value: void 0
	    });
	    Object.defineProperty(this, _restClient$1, {
	      writable: true,
	      value: void 0
	    });
	    Object.defineProperty(this, _userManager, {
	      writable: true,
	      value: void 0
	    });
	    babelHelpers.classPrivateFieldLooseBase(this, _store$1)[_store$1] = im_v2_application_core.Core.getStore();
	    babelHelpers.classPrivateFieldLooseBase(this, _restClient$1)[_restClient$1] = im_v2_application_core.Core.getRestClient();
	    babelHelpers.classPrivateFieldLooseBase(this, _userManager)[_userManager] = new im_v2_lib_user.UserManager();
	  }
	  loadUsers(userIds) {
	    return babelHelpers.classPrivateFieldLooseBase(this, _restClient$1)[_restClient$1].callMethod(im_v2_const.RestMethod.imUserListGet, {
	      ID: userIds
	    }).then(response => {
	      return babelHelpers.classPrivateFieldLooseBase(this, _userManager)[_userManager].setUsersToModel(Object.values(response.data()));
	    });
	  }
	}

	const LOADER_SIZE = 'xs';
	const LOADER_TYPE = 'BULLET';

	// @vue/component
	const Loader = {
	  name: 'MessengerLoader',
	  mounted() {
	    this.loader = new ui_loader.Loader({
	      target: this.$refs['messenger-loader'],
	      type: LOADER_TYPE,
	      size: LOADER_SIZE
	    });
	    this.loader.render();
	    this.loader.show();
	  },
	  beforeUnmount() {
	    this.loader.hide();
	    this.loader = null;
	  },
	  template: `
		<div class="bx-im-elements-loader__container" ref="messenger-loader"></div>
	`
	};

	// @vue/component
	const UserItem = {
	  name: 'UserItem',
	  components: {
	    ChatAvatar,
	    ChatTitle
	  },
	  props: {
	    userId: {
	      type: Number,
	      required: true
	    },
	    contextDialogId: {
	      type: String,
	      required: true
	    }
	  },
	  computed: {
	    AvatarSize: () => AvatarSize,
	    user() {
	      return this.$store.getters['users/get'](this.userId, true);
	    },
	    userDialogId() {
	      return this.userId.toString();
	    }
	  },
	  methods: {
	    onUserClick() {
	      void im_public.Messenger.openChat(this.userDialogId);
	    }
	  },
	  template: `
		<div class="bx-im-user-list-content__user-container" @click="onUserClick">
			<div class="bx-im-user-list-content__avatar-container">
				<ChatAvatar
					:avatarDialogId="userDialogId"
					:contextDialogId="contextDialogId"
					:size="AvatarSize.XS"
				/>
			</div>
			<ChatTitle 
				:dialogId="userDialogId" 
				:showItsYou="false" 
				class="bx-im-user-list-content__chat-title-container" 
			/>
		</div>
	`
	};

	// @vue/component
	const UserListContent = {
	  components: {
	    UserItem,
	    Loader
	  },
	  props: {
	    userIds: {
	      type: Array,
	      required: true
	    },
	    adjustPopupFunction: {
	      type: Function,
	      required: true
	    },
	    loading: {
	      type: Boolean,
	      required: false,
	      default: false
	    },
	    contextDialogId: {
	      type: String,
	      required: true
	    }
	  },
	  data() {
	    return {
	      hasError: false,
	      isLoadingUsers: false
	    };
	  },
	  computed: {
	    isLoading() {
	      return this.loading || this.isLoadingUsers;
	    }
	  },
	  watch: {
	    userIds() {
	      this.$nextTick(() => {
	        this.adjustPopupFunction();
	      });
	    }
	  },
	  created() {
	    if (this.needUserRequest()) {
	      this.requestUserData();
	    }
	  },
	  methods: {
	    getUserListService() {
	      if (!this.userListService) {
	        this.userListService = new UserListService();
	      }
	      return this.userListService;
	    },
	    getUser(userId) {
	      return this.$store.getters['users/get'](userId);
	    },
	    needUserRequest() {
	      return this.userIds.some(userId => !this.getUser(userId));
	    },
	    requestUserData() {
	      this.isLoadingUsers = true;
	      this.getUserListService().loadUsers(this.userIds).then(() => {
	        this.isLoadingUsers = false;
	      }).catch(error => {
	        // eslint-disable-next-line no-console
	        console.error(error);
	        this.hasError = true;
	        this.isLoadingUsers = false;
	      });
	    },
	    loc(phraseCode) {
	      return this.$Bitrix.Loc.getMessage(phraseCode);
	    }
	  },
	  template: `
		<div class="bx-im-user-list-content__container bx-im-user-list-content__scope">
			<template v-if="!isLoading && !hasError">
				<UserItem v-for="userId in userIds" :userId="userId" :contextDialogId="contextDialogId" />
			</template>
			<div v-else-if="isLoading" class="bx-im-user-list-content__loader-container">
				<Loader />
			</div>
			<div v-else-if="hasError">
				{{ loc('IM_ELEMENTS_CHAT_INFO_POPUP_NO_ACCESS') }}
			</div>
		</div>
	`
	};

	const POPUP_ID$1 = 'im-user-list-popup';

	// @vue/component
	const UserListPopup = {
	  name: 'UserListPopup',
	  components: {
	    MessengerPopup,
	    UserListContent
	  },
	  props: {
	    showPopup: {
	      type: Boolean,
	      required: true
	    },
	    id: {
	      type: String,
	      required: false,
	      default: POPUP_ID$1
	    },
	    bindElement: {
	      type: Object,
	      required: true
	    },
	    userIds: {
	      type: Array,
	      required: true
	    },
	    contextDialogId: {
	      type: String,
	      required: false,
	      default: ''
	    },
	    withAngle: {
	      type: Boolean,
	      required: false,
	      default: true
	    },
	    loading: {
	      type: Boolean,
	      required: false,
	      default: false
	    },
	    forceTop: {
	      type: Boolean,
	      required: false,
	      default: false
	    },
	    offsetLeft: {
	      type: Number,
	      required: false,
	      default: 0
	    }
	  },
	  emits: ['close'],
	  computed: {
	    POPUP_ID: () => POPUP_ID$1,
	    config() {
	      const config = {
	        bindElement: this.bindElement,
	        targetContainer: document.body,
	        offsetTop: 4,
	        offsetLeft: this.offsetLeft,
	        padding: 0,
	        angle: this.withAngle
	      };
	      if (this.forceTop) {
	        config.bindOptions = {
	          position: 'top'
	        };
	      }
	      return config;
	    }
	  },
	  template: `
		<MessengerPopup
			v-if="showPopup"
			v-slot="{adjustPosition}"
			:config="config"
			@close="$emit('close')"
			:id="id"
		>
			<UserListContent 
				:userIds="userIds"
				:contextDialogId="contextDialogId"
				:loading="loading" 
				:adjustPopupFunction="adjustPosition"
			/>
		</MessengerPopup>
	`
	};

	// @vue/component
	const KeyboardButton = {
	  name: 'KeyboardButton',
	  props: {
	    config: {
	      type: Object,
	      required: true
	    },
	    keyboardBlocked: {
	      type: Boolean,
	      required: true
	    }
	  },
	  emits: ['action', 'customCommand', 'blockKeyboard'],
	  data() {
	    return {};
	  },
	  computed: {
	    button() {
	      return this.config;
	    },
	    buttonClasses() {
	      const {
	        bgColorToken = im_v2_const.ColorToken.base,
	        display,
	        disabled,
	        wait
	      } = this.button;
	      const displayClass = display === im_v2_const.KeyboardButtonDisplay.block ? '--block' : '--line';
	      const classes = [displayClass, bgColorToken];
	      if (this.keyboardBlocked || disabled) {
	        classes.push('--disabled');
	      }
	      if (wait) {
	        classes.push('--loading');
	      }
	      return classes;
	    },
	    buttonStyles() {
	      const styles = {};
	      const {
	        width
	      } = this.button;
	      if (width) {
	        styles.width = `${width}px`;
	      }
	      return styles;
	    }
	  },
	  methods: {
	    onClick() {
	      if (this.keyboardBlocked || this.button.disabled || this.button.wait) {
	        return;
	      }
	      if (this.button.action && this.button.actionValue) {
	        this.handleAction();
	      } else if (this.button.appId) {
	        im_v2_lib_logger.Logger.warn('Messenger keyboard: open app is not implemented.');
	      } else if (this.button.link) {
	        const preparedLink = main_core.Text.decode(this.button.link);
	        im_v2_lib_utils.Utils.browser.openLink(preparedLink);
	      } else if (this.button.command) {
	        this.handleCustomCommand();
	      }
	    },
	    handleAction() {
	      this.$emit('action', {
	        action: this.button.action,
	        payload: this.button.actionValue
	      });
	    },
	    handleCustomCommand() {
	      if (this.button.block) {
	        this.$emit('blockKeyboard');
	      }
	      this.button.wait = true;
	      this.$emit('customCommand', {
	        botId: this.button.botId,
	        command: this.button.command,
	        payload: this.button.commandParams
	      });
	    }
	  },
	  template: `
		<div
			class="bx-im-keyboard-button__container"
			:class="buttonClasses"
			:style="buttonStyles"
			@click="onClick"
		>
			{{ button.text }}
		</div>
	`
	};

	// @vue/component
	const KeyboardSeparator = {
	  name: 'KeyboardSeparator',
	  data() {
	    return {};
	  },
	  template: `
		<div class="bx-im-keyboard-button__separator"></div>
	`
	};

	var _dialogId = /*#__PURE__*/babelHelpers.classPrivateFieldLooseKey("dialogId");
	var _actionHandlers = /*#__PURE__*/babelHelpers.classPrivateFieldLooseKey("actionHandlers");
	var _sendMessage = /*#__PURE__*/babelHelpers.classPrivateFieldLooseKey("sendMessage");
	var _insertText = /*#__PURE__*/babelHelpers.classPrivateFieldLooseKey("insertText");
	var _startCall = /*#__PURE__*/babelHelpers.classPrivateFieldLooseKey("startCall");
	var _copyText = /*#__PURE__*/babelHelpers.classPrivateFieldLooseKey("copyText");
	var _openChat = /*#__PURE__*/babelHelpers.classPrivateFieldLooseKey("openChat");
	class ActionManager {
	  constructor(dialogId) {
	    Object.defineProperty(this, _openChat, {
	      value: _openChat2
	    });
	    Object.defineProperty(this, _copyText, {
	      value: _copyText2
	    });
	    Object.defineProperty(this, _startCall, {
	      value: _startCall2
	    });
	    Object.defineProperty(this, _insertText, {
	      value: _insertText2
	    });
	    Object.defineProperty(this, _sendMessage, {
	      value: _sendMessage2
	    });
	    Object.defineProperty(this, _dialogId, {
	      writable: true,
	      value: void 0
	    });
	    Object.defineProperty(this, _actionHandlers, {
	      writable: true,
	      value: {
	        [im_v2_const.KeyboardButtonAction.send]: babelHelpers.classPrivateFieldLooseBase(this, _sendMessage)[_sendMessage].bind(this),
	        [im_v2_const.KeyboardButtonAction.put]: babelHelpers.classPrivateFieldLooseBase(this, _insertText)[_insertText].bind(this),
	        [im_v2_const.KeyboardButtonAction.call]: babelHelpers.classPrivateFieldLooseBase(this, _startCall)[_startCall].bind(this),
	        [im_v2_const.KeyboardButtonAction.copy]: babelHelpers.classPrivateFieldLooseBase(this, _copyText)[_copyText].bind(this),
	        [im_v2_const.KeyboardButtonAction.dialog]: babelHelpers.classPrivateFieldLooseBase(this, _openChat)[_openChat].bind(this)
	      }
	    });
	    babelHelpers.classPrivateFieldLooseBase(this, _dialogId)[_dialogId] = dialogId;
	  }
	  handleAction(event) {
	    const {
	      action,
	      payload
	    } = event;
	    if (!babelHelpers.classPrivateFieldLooseBase(this, _actionHandlers)[_actionHandlers][action]) {
	      // eslint-disable-next-line no-console
	      console.error('Keyboard: action not found');
	    }
	    babelHelpers.classPrivateFieldLooseBase(this, _actionHandlers)[_actionHandlers][action](payload);
	  }
	}
	function _sendMessage2(payload) {
	  im_v2_provider_service.SendingService.getInstance().sendMessage({
	    text: payload,
	    dialogId: babelHelpers.classPrivateFieldLooseBase(this, _dialogId)[_dialogId]
	  });
	}
	function _insertText2(payload) {
	  main_core_events.EventEmitter.emit(im_v2_const.EventType.textarea.insertText, {
	    text: payload,
	    dialogId: babelHelpers.classPrivateFieldLooseBase(this, _dialogId)[_dialogId]
	  });
	}
	function _startCall2(payload) {
	  im_v2_lib_phone.PhoneManager.getInstance().startCall(payload);
	}
	function _copyText2(payload) {
	  var _BX$clipboard;
	  if ((_BX$clipboard = BX.clipboard) != null && _BX$clipboard.copy(payload)) {
	    BX.UI.Notification.Center.notify({
	      content: main_core.Loc.getMessage('IM_ELEMENTS_KEYBOARD_BUTTON_ACTION_COPY_SUCCESS')
	    });
	  }
	}
	function _openChat2(payload) {
	  im_public.Messenger.openChat(payload);
	}

	var _messageId = /*#__PURE__*/babelHelpers.classPrivateFieldLooseKey("messageId");
	var _dialogId$1 = /*#__PURE__*/babelHelpers.classPrivateFieldLooseKey("dialogId");
	class BotService {
	  constructor(params) {
	    Object.defineProperty(this, _messageId, {
	      writable: true,
	      value: void 0
	    });
	    Object.defineProperty(this, _dialogId$1, {
	      writable: true,
	      value: void 0
	    });
	    const {
	      messageId,
	      dialogId
	    } = params;
	    babelHelpers.classPrivateFieldLooseBase(this, _messageId)[_messageId] = messageId;
	    babelHelpers.classPrivateFieldLooseBase(this, _dialogId$1)[_dialogId$1] = dialogId;
	  }
	  sendCommand(event) {
	    const {
	      botId,
	      command,
	      payload
	    } = event;
	    im_v2_application_core.Core.getRestClient().callMethod(im_v2_const.RestMethod.imMessageCommand, {
	      MESSAGE_ID: babelHelpers.classPrivateFieldLooseBase(this, _messageId)[_messageId],
	      DIALOG_ID: babelHelpers.classPrivateFieldLooseBase(this, _dialogId$1)[_dialogId$1],
	      BOT_ID: botId,
	      COMMAND: command,
	      COMMAND_PARAMS: payload
	    }).catch(error => {
	      // eslint-disable-next-line no-console
	      console.error('BotService: error sending command:', error);
	    });
	  }
	}

	const Keyboard = {
	  props: {
	    buttons: {
	      type: Array,
	      required: true
	    },
	    dialogId: {
	      type: String,
	      required: true
	    },
	    messageId: {
	      type: [Number, String],
	      required: true
	    }
	  },
	  components: {
	    KeyboardButton,
	    KeyboardSeparator
	  },
	  data() {
	    return {
	      keyboardBlocked: false
	    };
	  },
	  emits: ['click'],
	  watch: {
	    buttons() {
	      this.keyboardBlocked = false;
	    }
	  },
	  computed: {
	    ButtonType: () => im_v2_const.KeyboardButtonType,
	    preparedButtons() {
	      return this.buttons.filter(button => {
	        return button.context !== im_v2_const.KeyboardButtonContext.mobile;
	      });
	    }
	  },
	  methods: {
	    onButtonActionClick(event) {
	      this.getActionManager().handleAction(event);
	    },
	    onButtonCustomCommandClick(event) {
	      this.getBotService().sendCommand(event);
	    },
	    getActionManager() {
	      if (!this.actionManager) {
	        this.actionManager = new ActionManager(this.dialogId);
	      }
	      return this.actionManager;
	    },
	    getBotService() {
	      if (!this.botService) {
	        this.botService = new BotService({
	          messageId: this.messageId,
	          dialogId: this.dialogId
	        });
	      }
	      return this.botService;
	    }
	  },
	  template: `
		<div class="bx-im-keyboard__container">
			<template v-for="button in preparedButtons">
				<KeyboardButton
					v-if="button.type === ButtonType.button"
					:config="button"
					:keyboardBlocked="keyboardBlocked"
					@blockKeyboard="keyboardBlocked = true"
					@action="onButtonActionClick"
					@customCommand="onButtonCustomCommandClick"
				/>
				<KeyboardSeparator v-else-if="button.type === ButtonType.newLine" />
			</template>
		</div>
	`
	};

	const UserStatusSize = {
	  S: 'S',
	  M: 'M',
	  L: 'L',
	  XL: 'XL',
	  XXL: 'XXL'
	};

	// @vue/component
	const UserStatus = {
	  name: 'UserStatus',
	  props: {
	    status: {
	      type: String,
	      required: true,
	      validator(value) {
	        return Object.values(im_v2_const.UserStatus).includes(value);
	      }
	    },
	    size: {
	      type: String,
	      default: UserStatusSize.M,
	      validator(value) {
	        return Object.values(UserStatusSize).includes(value);
	      }
	    }
	  },
	  data() {
	    return {};
	  },
	  computed: {
	    containerClasses() {
	      return [`--size-${this.size.toLowerCase()}`, `--${this.status}`];
	    }
	  },
	  template: `
		<div :class="containerClasses" class="bx-im-user-status__container bx-im-user-status__scope"></div>
	`
	};

	// @vue/component
	const Dropdown = {
	  name: 'ChatDropdown',
	  props: {
	    items: {
	      type: Object,
	      required: true
	    },
	    id: {
	      type: String,
	      required: true
	    }
	  },
	  emits: ['itemChange'],
	  data() {
	    return {
	      selectedElement: '',
	      menuOpened: false
	    };
	  },
	  computed: {
	    formattedItems() {
	      const map = {};
	      this.items.forEach(item => {
	        map[item.value] = item;
	      });
	      return map;
	    },
	    defaultItem() {
	      return this.items.find(item => {
	        return item.default === true;
	      });
	    }
	  },
	  created() {
	    this.menuInstance = null;
	    if (this.defaultItem) {
	      this.selectedElement = this.defaultItem.value;
	    }
	  },
	  beforeUnmount() {
	    var _this$menuInstance;
	    (_this$menuInstance = this.menuInstance) == null ? void 0 : _this$menuInstance.destroy();
	  },
	  methods: {
	    toggleMenu() {
	      if (!this.menuInstance) {
	        this.menuInstance = this.getMenuInstance();
	      }
	      if (this.menuOpened) {
	        this.menuInstance.close();
	        return;
	      }
	      this.menuInstance.show();
	      const width = this.$refs.container.clientWidth;
	      this.menuInstance.getPopupWindow().setWidth(width);
	      this.menuOpened = true;
	    },
	    getMenuInstance() {
	      return main_popup.MenuManager.create({
	        id: this.id,
	        bindOptions: {
	          forceBindPosition: true,
	          position: 'bottom'
	        },
	        targetContainer: document.body,
	        bindElement: this.$refs.container,
	        items: this.getMenuItems(),
	        events: {
	          onClose: () => {
	            this.menuOpened = false;
	          }
	        }
	      });
	    },
	    getMenuItems() {
	      return Object.values(this.formattedItems).map(item => {
	        return {
	          text: item.text,
	          onclick: () => {
	            this.selectedElement = item.value;
	            this.$emit('itemChange', item.value);
	            this.menuInstance.close();
	          }
	        };
	      });
	    }
	  },
	  template: `
		<div class="bx-im-dropdown__container bx-im-dropdown__scope">
			<div @click="toggleMenu" class="ui-ctl ui-ctl-xl ui-ctl-w100 ui-ctl-after-icon ui-ctl-dropdown" ref="container">
				<div class="ui-ctl-after ui-ctl-icon-angle"></div>
				<div class="ui-ctl-element">{{ formattedItems[selectedElement].text }}</div>
			</div>
		</div>
	`
	};

	const SpinnerSize = Object.freeze({
	  XXS: 'XXS',
	  S: 'S',
	  L: 'L'
	});
	const SpinnerColor = Object.freeze({
	  grey: 'grey',
	  blue: 'blue'
	});

	// @vue/component
	const Spinner = {
	  name: 'MessengerSpinner',
	  props: {
	    size: {
	      type: String,
	      default: SpinnerSize.S
	    },
	    color: {
	      type: String,
	      default: SpinnerColor.blue
	    }
	  },
	  computed: {
	    sizeClassName() {
	      return `--size-${this.size.toLowerCase()}`;
	    },
	    colorClassName() {
	      return `--color-${this.color.toLowerCase()}`;
	    }
	  },
	  template: `
		<div class="bx-im-elements-spinner__container bx-im-elements-spinner__scope">
			<div class="bx-im-elements-spinner__spinner" :class="[sizeClassName, colorClassName]"></div>
		</div>
	`
	};

	// @vue/component
	const LineLoader = {
	  name: 'LineLoader',
	  props: {
	    width: {
	      type: Number,
	      required: true
	    },
	    height: {
	      type: Number,
	      required: true
	    }
	  },
	  data() {
	    return {};
	  },
	  computed: {
	    containerStyles() {
	      return {
	        width: `${this.width}px`,
	        height: `${this.height}px`
	      };
	    }
	  },
	  template: `
		<div class="bx-im-elements-line-loader__container" :style="containerStyles">
			<div class="bx-im-elements-line-loader__content"></div>
		</div>
	`
	};

	const ToggleSize = {
	  S: 'S',
	  M: 'M'
	};

	// @vue/component
	const Toggle = {
	  name: 'ToggleControl',
	  props: {
	    size: {
	      type: String,
	      required: true
	    },
	    isEnabled: {
	      type: Boolean,
	      default: true
	    }
	  },
	  emits: ['change'],
	  computed: {
	    containerClasses() {
	      const classes = [`--size-${this.size.toLowerCase()}`];
	      if (!this.isEnabled) {
	        classes.push('--off');
	      }
	      return classes;
	    }
	  },
	  template: `
		<div :class="containerClasses" class="bx-im-toggle__container bx-im-toggle__scope">
			<span class="bx-im-toggle__cursor"></span>
			<span class="bx-im-toggle__enabled"></span>
			<span class="bx-im-toggle__disabled"></span>
		</div>
	`
	};

	const ARROW_CONTROL_SIZE = 50;
	const TabsColorScheme = Object.freeze({
	  white: 'white',
	  gray: 'gray'
	});

	// @vue/component
	const MessengerTabs = {
	  name: 'MessengerTabs',
	  props: {
	    colorScheme: {
	      type: String,
	      required: true,
	      default: TabsColorScheme.white,
	      validator: value => Object.values(TabsColorScheme).includes(value.toLowerCase())
	    },
	    tabs: {
	      type: Array,
	      default: () => []
	    }
	  },
	  data() {
	    return {
	      hasLeftControl: false,
	      hasRightControl: false,
	      currentElementIndex: 0,
	      highlightOffsetLeft: 0,
	      highlightWidth: 0,
	      isFirstCall: true
	    };
	  },
	  computed: {
	    highlightStyle() {
	      return {
	        left: `${this.highlightOffsetLeft}px`,
	        width: `${this.highlightWidth}px`
	      };
	    },
	    colorSchemeClass() {
	      return this.colorScheme === TabsColorScheme.white ? '--white' : '--gray';
	    }
	  },
	  watch: {
	    currentElementIndex(newIndex) {
	      this.updateHighlightPosition(newIndex);
	      this.$emit('tabSelect', this.tabs[newIndex]);
	      this.scrollToElement(newIndex);
	    }
	  },
	  mounted() {
	    const savedTabIndex = localStorage.getItem('lastOpenedTabIndex');
	    if (this.$refs.tabs.scrollWidth > this.$refs.tabs.offsetWidth) {
	      this.hasRightControl = true;
	    }
	    if (savedTabIndex && this.tabs[savedTabIndex]) {
	      this.currentElementIndex = parseInt(savedTabIndex, 10);
	    }
	    this.updateHighlightPosition(this.currentElementIndex);
	    setTimeout(() => {
	      this.isFirstCall = false;
	    }, 100);
	  },
	  beforeUnmount() {
	    localStorage.setItem('lastOpenedTabIndex', this.currentElementIndex.toString());
	  },
	  methods: {
	    getElementNodeByIndex(index) {
	      return [...this.$refs.tabs.children].filter(node => !main_core.Dom.hasClass(node, 'bx-im-elements-tabs__highlight'))[index];
	    },
	    updateHighlightPosition(index) {
	      const element = this.getElementNodeByIndex(index);
	      this.highlightOffsetLeft = element.offsetLeft;
	      this.highlightWidth = element.offsetWidth;
	    },
	    scrollToElement(elementIndex) {
	      const element = this.getElementNodeByIndex(elementIndex);
	      this.$refs.tabs.scroll({
	        left: element.offsetLeft - ARROW_CONTROL_SIZE,
	        behavior: 'smooth'
	      });
	    },
	    onTabClick(event) {
	      this.currentElementIndex = event.index;
	    },
	    isSelectedTab(index) {
	      return index === this.currentElementIndex;
	    },
	    onLeftClick() {
	      if (this.currentElementIndex <= 0) {
	        return;
	      }
	      this.currentElementIndex--;
	    },
	    onRightClick() {
	      if (this.currentElementIndex >= this.tabs.length - 1) {
	        return;
	      }
	      this.currentElementIndex++;
	    },
	    updateControlsVisibility() {
	      this.hasRightControl = this.$refs.tabs.scrollWidth > this.$refs.tabs.scrollLeft + this.$refs.tabs.clientWidth;
	      this.hasLeftControl = this.$refs.tabs.scrollLeft > 0;
	    }
	  },
	  template: `
		<div class="bx-im-elements-tabs__container bx-im-elements-tabs__scope" :class="colorSchemeClass">
			<div v-if="hasLeftControl" @click.stop="onLeftClick" class="bx-im-elements-tabs__control --left">
				<div class="bx-im-elements-tabs__forward-icon"></div>
			</div>
			<div v-if="hasRightControl" @click.stop="onRightClick" class="bx-im-elements-tabs__control --right">
				<div class="bx-im-elements-tabs__forward-icon"></div>
			</div>
			<div class="bx-im-elements-tabs__elements" ref="tabs" @scroll.passive="updateControlsVisibility">
				<div class="bx-im-elements-tabs__highlight" :class="isFirstCall ? '' : '--transition'" :style="highlightStyle"></div>
				<div
					v-for="(tab, index) in tabs"
					:key="tab.id"
					class="bx-im-elements-tabs__item"
					:class="[isSelectedTab(index) ? '--selected' : '']"
					@click="onTabClick({index: index})"
					:title="tab.title"
				>
					<div class="bx-im-elements-tabs__item-title" :class="isFirstCall ? '' : '--transition'">{{ tab.title }}</div>
				</div>
			</div>
		</div>
	`
	};

	function formatTime(seconds) {
	  const hours = Math.floor(seconds / 3600);
	  const minutes = Math.floor(seconds % 3600 / 60);
	  const remainingSeconds = Math.floor(seconds % 60);
	  const formattedHours = hours > 0 ? `${hours}:` : '';
	  const formattedMinutes = hours > 0 ? padZero(minutes) : minutes.toString();
	  const formattedSeconds = padZero(remainingSeconds);
	  return `${formattedHours}${formattedMinutes}:${formattedSeconds}`;
	}
	function padZero(num) {
	  return num.toString().padStart(2, '0');
	}

	const ID_KEY = 'im:audioplayer:id';

	// @vue/component
	const AudioPlayer$$1 = {
	  name: 'AudioPlayer',
	  components: {
	    MessageAvatar
	  },
	  props: {
	    id: {
	      type: Number,
	      default: 0
	    },
	    src: {
	      type: String,
	      default: ''
	    },
	    file: {
	      type: Object,
	      required: true
	    },
	    authorId: {
	      type: Number,
	      required: true
	    },
	    messageId: {
	      type: [String, Number],
	      required: true
	    },
	    timelineType: {
	      type: Number,
	      required: true
	    },
	    withContextMenu: {
	      type: Boolean,
	      default: true
	    },
	    withAvatar: {
	      type: Boolean,
	      default: true
	    },
	    withPlaybackRateControl: {
	      type: Boolean,
	      default: false
	    }
	  },
	  data() {
	    return {
	      preload: 'none',
	      loaded: false,
	      loading: false,
	      state: im_v2_const.AudioPlaybackState.none,
	      progress: 0,
	      progressInPixel: 0,
	      seek: 0,
	      timeCurrent: 0,
	      timeTotal: 0,
	      showContextButton: false,
	      currentRate: im_v2_const.AudioPlaybackRate['1']
	    };
	  },
	  computed: {
	    State: () => im_v2_const.AudioPlaybackState,
	    seekPosition() {
	      if (!this.loaded && !this.seek) {
	        return 'display: none';
	      }
	      return `left: ${this.seek}px;`;
	    },
	    isPlaying() {
	      return this.state === im_v2_const.AudioPlaybackState.play;
	    },
	    labelTime() {
	      if (!this.loaded && !this.timeTotal) {
	        return '--:--';
	      }
	      let time = 0;
	      if (this.isPlaying) {
	        time = this.timeTotal - this.timeCurrent;
	      } else {
	        time = this.timeTotal;
	      }
	      return formatTime(time);
	    },
	    AvatarSize: () => AvatarSize,
	    fileSize() {
	      return im_v2_lib_utils.Utils.file.formatFileSize(this.file.size);
	    },
	    progressPosition() {
	      if (!this.loaded || this.state === im_v2_const.AudioPlaybackState.none) {
	        return {
	          width: '100%'
	        };
	      }
	      return {
	        width: `${this.progressInPixel}px`
	      };
	    },
	    activeTimelineStyles() {
	      const TIMELINE_VERTICAL_SHIFT = 44;
	      const ACTIVE_TIMELINE_VERTICAL_SHIFT = 19;
	      const shift = this.timelineType * TIMELINE_VERTICAL_SHIFT + ACTIVE_TIMELINE_VERTICAL_SHIFT;
	      return {
	        ...this.progressPosition,
	        'background-position-y': `-${shift}px`
	      };
	    },
	    timelineStyles() {
	      const TIMELINE_VERTICAL_SHIFT = 44;
	      const shift = this.timelineType * TIMELINE_VERTICAL_SHIFT;
	      return {
	        'background-position-y': `-${shift}px`
	      };
	    },
	    getAudioPlayerIds() {
	      return this.$Bitrix.Data.get(ID_KEY, []);
	    },
	    currentRateLabel() {
	      return this.isPlaying ? `${this.currentRate}x` : '';
	    },
	    metaInfo() {
	      return `${this.fileSize}, ${this.labelTime}`;
	    }
	  },
	  watch: {
	    id(value) {
	      this.registerPlayer(value);
	    },
	    progress(value) {
	      if (value > 70) {
	        this.preloadNext();
	      }
	    }
	  },
	  created() {
	    this.localStorageInst = im_v2_lib_localStorage.LocalStorageManager.getInstance();
	    this.currentRate = this.getRateFromLS();
	    this.preloadRequestSent = false;
	    this.registeredId = 0;
	    this.registerPlayer(this.id);
	    main_core_events.EventEmitter.subscribe(im_v2_const.EventType.audioPlayer.play, this.onPlay);
	    main_core_events.EventEmitter.subscribe(im_v2_const.EventType.audioPlayer.stop, this.onStop);
	    main_core_events.EventEmitter.subscribe(im_v2_const.EventType.audioPlayer.pause, this.onPause);
	    main_core_events.EventEmitter.subscribe(im_v2_const.EventType.audioPlayer.preload, this.onPreload);
	  },
	  mounted() {
	    this.getObserver().observe(this.$refs.body);
	  },
	  beforeUnmount() {
	    this.unregisterPlayer();
	    main_core_events.EventEmitter.unsubscribe(im_v2_const.EventType.audioPlayer.play, this.onPlay);
	    main_core_events.EventEmitter.unsubscribe(im_v2_const.EventType.audioPlayer.stop, this.onStop);
	    main_core_events.EventEmitter.unsubscribe(im_v2_const.EventType.audioPlayer.pause, this.onPause);
	    main_core_events.EventEmitter.unsubscribe(im_v2_const.EventType.audioPlayer.preload, this.onPreload);
	    this.getObserver().unobserve(this.$refs.body);
	  },
	  methods: {
	    loadFile(play = false) {
	      if (this.loaded || this.loading && !play) {
	        return;
	      }
	      this.preload = 'auto';
	      if (!play) {
	        return;
	      }
	      this.loading = true;
	      if (this.source()) {
	        void this.source().play();
	      }
	    },
	    clickToButton() {
	      if (!this.src) {
	        return;
	      }
	      if (this.isPlaying) {
	        this.pause();
	      } else {
	        this.play();
	      }
	    },
	    play() {
	      this.updateRate(this.getRateFromLS());
	      if (!this.loaded) {
	        this.loadFile(true);
	        return;
	      }
	      void this.source().play();
	    },
	    pause() {
	      this.source().pause();
	    },
	    stop() {
	      this.state = im_v2_const.AudioPlaybackState.stop;
	      this.source().pause();
	    },
	    setPosition() {
	      if (!this.loaded) {
	        this.loadFile(true);
	        return;
	      }
	      const pixelPerPercent = this.$refs.track.offsetWidth / 100;
	      this.setProgress(this.seek / pixelPerPercent, this.seek);
	      if (this.state !== im_v2_const.AudioPlaybackState.play) {
	        this.state = im_v2_const.AudioPlaybackState.pause;
	      }
	      this.play();
	      this.source().currentTime = this.timeTotal / 100 * this.progress;
	    },
	    getRateFromLS() {
	      return this.localStorageInst.get(im_v2_const.LocalStorageKey.audioPlaybackRate) || im_v2_const.AudioPlaybackRate['1'];
	    },
	    setRateInLS(newRate) {
	      this.localStorageInst.set(im_v2_const.LocalStorageKey.audioPlaybackRate, newRate);
	    },
	    getNextPlaybackRate(currentRate) {
	      const rates = Object.values(im_v2_const.AudioPlaybackRate).sort();
	      const currentIndex = rates.indexOf(currentRate);
	      const nextIndex = (currentIndex + 1) % rates.length;
	      return rates[nextIndex];
	    },
	    changeRate() {
	      if ([im_v2_const.AudioPlaybackState.pause, im_v2_const.AudioPlaybackState.none].includes(this.state)) {
	        return;
	      }
	      const commonCurrentRate = this.getRateFromLS();
	      const newRate = this.getNextPlaybackRate(commonCurrentRate);
	      this.setRateInLS(newRate);
	      this.updateRate(newRate);
	    },
	    updateRate(newRate) {
	      this.currentRate = newRate;
	      this.source().playbackRate = newRate;
	    },
	    seeking(event) {
	      if (!this.loaded) {
	        return;
	      }
	      this.seek = event.offsetX > 0 ? event.offsetX : 0;
	    },
	    setProgress(percent, pixel = -1) {
	      this.progress = percent;
	      this.progressInPixel = pixel > 0 ? pixel : Math.round(this.$refs.track.offsetWidth / 100 * percent);
	    },
	    registerPlayer(id) {
	      if (id <= 0) {
	        return;
	      }
	      this.unregisterPlayer();
	      const audioIdArray = [...new Set([...this.getAudioPlayerIds, id])];
	      this.$Bitrix.Data.set(ID_KEY, audioIdArray.sort((a, b) => a - b));
	      this.registeredId = id;
	    },
	    unregisterPlayer() {
	      if (!this.registeredId) {
	        return;
	      }
	      this.$Bitrix.Data.get(ID_KEY, this.getAudioPlayerIds.filter(id => id !== this.registeredId));
	      this.registeredId = 0;
	    },
	    playNext() {
	      if (!this.registeredId) {
	        return;
	      }
	      const nextId = this.getAudioPlayerIds.filter(id => id > this.registeredId).slice(0, 1)[0];
	      if (nextId) {
	        main_core_events.EventEmitter.emit(im_v2_const.EventType.audioPlayer.play, {
	          id: nextId,
	          start: true
	        });
	      }
	    },
	    preloadNext() {
	      if (this.preloadRequestSent || !this.registeredId) {
	        return;
	      }
	      this.preloadRequestSent = true;
	      const nextId = this.getAudioPlayerIds.filter(id => id > this.registeredId).slice(0, 1)[0];
	      if (nextId) {
	        main_core_events.EventEmitter.emit(im_v2_const.EventType.audioPlayer.preload, {
	          id: nextId
	        });
	      }
	    },
	    onPlay(event) {
	      const data = event.getData();
	      if (data.id !== this.id) {
	        return;
	      }
	      if (data.start) {
	        this.stop();
	      }
	      this.play();
	    },
	    onStop(event) {
	      const data = event.getData();
	      if (data.initiator === this.id) {
	        return;
	      }
	      this.stop();
	    },
	    onPause(event) {
	      const data = event.getData();
	      if (data.initiator === this.id) {
	        return;
	      }
	      this.pause();
	    },
	    onPreload(event) {
	      const data = event.getData();
	      if (data.id !== this.id) {
	        return;
	      }
	      this.loadFile();
	    },
	    source() {
	      return this.$refs.source;
	    },
	    audioEventRouter(eventName, event) {
	      // eslint-disable-next-line default-case
	      switch (eventName) {
	        case 'durationchange':
	        case 'loadeddata':
	        case 'loadedmetadata':
	          if (!this.source()) {
	            return;
	          }
	          this.timeTotal = this.source().duration;
	          break;
	        case 'abort':
	        case 'error':
	          console.error('BxAudioPlayer: load failed', this.id, event);
	          this.loading = false;
	          this.state = im_v2_const.AudioPlaybackState.none;
	          this.timeTotal = 0;
	          this.preload = 'none';
	          break;
	        case 'canplaythrough':
	          this.loading = false;
	          this.loaded = true;
	          break;
	        case 'timeupdate':
	          if (!this.source()) {
	            return;
	          }
	          this.timeCurrent = this.source().currentTime;
	          this.setProgress(Math.round(100 / this.timeTotal * this.timeCurrent));
	          if (this.isPlaying && this.timeCurrent >= this.timeTotal) {
	            this.playNext();
	          }
	          break;
	        case 'pause':
	          if (this.state !== im_v2_const.AudioPlaybackState.stop) {
	            this.state = im_v2_const.AudioPlaybackState.pause;
	          }
	          break;
	        case 'play':
	          this.state = im_v2_const.AudioPlaybackState.play;
	          if (this.state === im_v2_const.AudioPlaybackState.stop) {
	            this.progress = 0;
	            this.timeCurrent = 0;
	          }
	          if (this.id > 0) {
	            main_core_events.EventEmitter.emit(im_v2_const.EventType.audioPlayer.pause, {
	              initiator: this.id
	            });
	          }
	          break;
	        // No default
	      }
	    },

	    getObserver() {
	      if (this.observer) {
	        return this.observer;
	      }
	      this.observer = new IntersectionObserver(entries => {
	        entries.forEach(entry => {
	          if (entry.isIntersecting && this.preload === 'none') {
	            this.preload = 'metadata';
	            this.observer.unobserve(entry.target);
	          }
	        });
	      }, {
	        threshold: [0, 1]
	      });
	      return this.observer;
	    }
	  },
	  template: `
		<div 
			class="bx-im-audio-player__container bx-im-audio-player__scope" 
			ref="body"
			@mouseover="showContextButton = true"
			@mouseleave="showContextButton = false"
		>
			<div class="bx-im-audio-player__control-container">
				<button
					class="bx-im-audio-player__control-button"
					:class="{
						'bx-im-audio-player__control-loader': loading,
						'bx-im-audio-player__control-play': !loading && !this.isPlaying,
						'bx-im-audio-player__control-pause': !loading && this.isPlaying,
					}"
					@click="clickToButton"
				></button>
				<div v-if="withAvatar" class="bx-im-audio-player__author-avatar-container">
					<MessageAvatar 
						:messageId="messageId"
						:authorId="authorId"
						:size="AvatarSize.XS" 
					/>
				</div>
			</div>
			<div class="bx-im-audio-player__timeline-container">
				<div class="bx-im-audio-player__track-container" @click="setPosition" ref="track">
					<div class="bx-im-audio-player__track-mask" :style="timelineStyles"></div>
					<div class="bx-im-audio-player__track-mask --active" :style="activeTimelineStyles"></div>
					<div class="bx-im-audio-player__track-seek" :style="seekPosition"></div>
					<div class="bx-im-audio-player__track-event" @mousemove="seeking"></div>
				</div>
				<div class="bx-im-audio-player__timer-container --ellipsis">
					{{metaInfo}}
				</div>
			</div>
			<div
				v-if="!withPlaybackRateControl"
				class="bx-im-audio-player__rate-button-container"
			>
				<button
					:class="{'--active': isPlaying}"
					@click="changeRate"
				>
					<span :class="{'bx-im-audio-player__rate-icon': !isPlaying}">
						{{currentRateLabel}}
					</span>
				</button>
			</div>
			<button
				v-if="showContextButton && withContextMenu"
				class="bx-im-messenger__context-menu-icon bx-im-audio-player__context-menu-button"
				@click="$emit('contextMenuClick', $event)"
			></button>
			<audio 
				v-if="src" 
				:src="src" 
				class="bx-im-audio-player__audio-source" 
				ref="source" 
				:preload="preload"
				@abort="audioEventRouter('abort', $event)"
				@error="audioEventRouter('error', $event)"
				@suspend="audioEventRouter('suspend', $event)"
				@canplay="audioEventRouter('canplay', $event)"
				@canplaythrough="audioEventRouter('canplaythrough', $event)"
				@durationchange="audioEventRouter('durationchange', $event)"
				@loadeddata="audioEventRouter('loadeddata', $event)"
				@loadedmetadata="audioEventRouter('loadedmetadata', $event)"
				@timeupdate="audioEventRouter('timeupdate', $event)"
				@play="audioEventRouter('play', $event)"
				@playing="audioEventRouter('playing', $event)"
				@pause="audioEventRouter('pause', $event)"
			></audio>
		</div>
	`
	};

	// @vue/component
	const ChatTitleWithHighlighting$$1 = ui_vue3.BitrixVue.cloneComponent(ChatTitle, {
	  name: 'ChatTitleWithHighlighting',
	  props: {
	    textToHighlight: {
	      type: String,
	      default: ''
	    }
	  },
	  computed: {
	    dialogName() {
	      // noinspection JSUnresolvedVariable
	      return im_v2_lib_textHighlighter.highlightText(this.parentDialogName, this.textToHighlight);
	    }
	  }
	});

	// @vue/component
	const SearchInput$$1 = {
	  name: 'SearchInput',
	  components: {
	    Spinner
	  },
	  props: {
	    placeholder: {
	      type: String,
	      default: ''
	    },
	    searchMode: {
	      type: Boolean,
	      default: true
	    },
	    withIcon: {
	      type: Boolean,
	      default: true
	    },
	    withLoader: {
	      type: Boolean,
	      default: false
	    },
	    isLoading: {
	      type: Boolean,
	      default: false
	    },
	    delayForFocusOnStart: {
	      type: Number || null,
	      default: null
	    }
	  },
	  emits: ['queryChange', 'inputFocus', 'inputBlur', 'keyPressed', 'close'],
	  data() {
	    return {
	      query: '',
	      hasFocus: false
	    };
	  },
	  computed: {
	    SpinnerSize: () => SpinnerSize,
	    SpinnerColor: () => SpinnerColor,
	    isEmptyQuery() {
	      return this.query.length === 0;
	    }
	  },
	  watch: {
	    searchMode(newValue) {
	      if (newValue === true) {
	        this.focus();
	      } else {
	        this.query = '';
	        this.blur();
	      }
	    }
	  },
	  mounted() {
	    if (this.delayForFocusOnStart === 0) {
	      this.focus();
	    } else if (this.delayForFocusOnStart > 0) {
	      setTimeout(() => {
	        this.focus();
	      }, this.delayForFocusOnStart);
	    }
	  },
	  methods: {
	    onInputUpdate() {
	      this.$emit('queryChange', this.query);
	    },
	    onFocus() {
	      this.focus();
	      this.$emit('inputFocus');
	    },
	    onCloseClick() {
	      this.query = '';
	      this.hasFocus = false;
	      this.$emit('queryChange', this.query);
	      this.$emit('close');
	    },
	    onClearInput() {
	      this.query = '';
	      this.focus();
	      this.$emit('queryChange', this.query);
	    },
	    onKeyUp(event) {
	      if (im_v2_lib_utils.Utils.key.isCombination(event, 'Escape')) {
	        this.onEscapePressed();
	        return;
	      }
	      this.$emit('keyPressed', event);
	    },
	    onEscapePressed() {
	      if (this.isEmptyQuery) {
	        this.onCloseClick();
	        this.blur();
	      } else {
	        this.onClearInput();
	      }
	    },
	    focus() {
	      this.hasFocus = true;
	      this.$refs.searchInput.focus();
	    },
	    blur() {
	      this.hasFocus = false;
	      this.$refs.searchInput.blur();
	    }
	  },
	  template: `
		<div class="bx-im-search-input__scope bx-im-search-input__container" :class="{'--has-focus': hasFocus}">
			<div v-if="!isLoading" class="bx-im-search-input__search-icon"></div>
			<Spinner 
				v-if="withLoader && isLoading" 
				:size="SpinnerSize.XXS" 
				:color="SpinnerColor.grey" 
				class="bx-im-search-input__loader"
			/>
			<input
				@focus="onFocus"
				@input="onInputUpdate"
				@keyup="onKeyUp"
				v-model="query"
				class="bx-im-search-input__element"
				:class="{'--with-icon': withIcon}"
				:placeholder="placeholder"
				ref="searchInput"
			/>
			<div v-if="hasFocus" class="bx-im-search-input__close-icon" @click="onCloseClick"></div>
		</div>
	`
	};

	const INPUT_PADDING = 5;

	// @vue/component
	const EditableChatTitle = {
	  name: 'EditableChatTitle',
	  components: {
	    ChatTitle
	  },
	  props: {
	    dialogId: {
	      type: String,
	      required: true
	    }
	  },
	  emits: ['newTitleSubmit'],
	  data() {
	    return {
	      isEditing: false,
	      inputWidth: 0,
	      showEditIcon: false,
	      chatTitle: ''
	    };
	  },
	  computed: {
	    dialog() {
	      return this.$store.getters['chats/get'](this.dialogId, true);
	    },
	    canBeRenamed() {
	      return im_v2_lib_permission.PermissionManager.getInstance().canPerformActionByRole(im_v2_const.ActionByRole.rename, this.dialogId);
	    },
	    inputStyle() {
	      return {
	        width: `calc(${this.inputWidth}ch + ${INPUT_PADDING}px)`
	      };
	    }
	  },
	  watch: {
	    chatTitle() {
	      this.inputWidth = this.chatTitle.length;
	    }
	  },
	  mounted() {
	    this.chatTitle = this.dialog.name;
	  },
	  methods: {
	    async onTitleClick() {
	      if (!this.canBeRenamed) {
	        return;
	      }
	      if (!this.chatTitle) {
	        this.chatTitle = this.dialog.name;
	      }
	      this.isEditing = true;
	      await this.$nextTick();
	      this.$refs.titleInput.focus();
	    },
	    onNewTitleSubmit() {
	      if (!this.isEditing) {
	        return;
	      }
	      this.isEditing = false;
	      const nameNotChanged = this.chatTitle === this.dialog.name;
	      if (nameNotChanged || this.chatTitle === '') {
	        return;
	      }
	      this.$emit('newTitleSubmit', this.chatTitle);
	    },
	    onEditCancel() {
	      this.isEditing = false;
	      this.showEditIcon = false;
	      this.chatTitle = this.dialog.name;
	    }
	  },
	  template: `
		<div
			v-if="!isEditing"
			@click="onTitleClick"
			@mouseover="showEditIcon = true"
			@mouseleave="showEditIcon = false"
			class="bx-im-elements-editable-chat-title__wrap"
			:class="{'--can-rename': canBeRenamed}"
		>
			<div class="bx-im-elements-editable-chat-title__container">
				<ChatTitle :dialogId="dialogId" :withMute="true" />
			</div>
			<div class="bx-im-elements-editable-chat-title__edit-icon_container">
				<div v-if="showEditIcon && canBeRenamed" class="bx-im-elements-editable-chat-title__edit-icon"></div>
			</div>
		</div>
		<div v-else class="bx-im-elements-editable-chat-title__input_container">
			<input
				v-model="chatTitle"
				:style="inputStyle"
				@focus="$event.target.select()"
				@blur="onNewTitleSubmit"
				@keyup.enter="onNewTitleSubmit"
				@keyup.esc="onEditCancel"
				type="text"
				class="bx-im-elements-editable-chat-title__input"
				ref="titleInput"
			/>
		</div>
	`
	};

	// @vue/component
	const ScrollWithGradient = {
	  name: 'ScrollWithGradient',
	  props: {
	    containerMaxHeight: {
	      type: Number,
	      default: 0,
	      required: false
	    },
	    gradientHeight: {
	      type: Number,
	      default: 0
	    },
	    withShadow: {
	      type: Boolean,
	      default: true
	    }
	  },
	  data() {
	    return {
	      showTopGradient: false,
	      showBottomGradient: false
	    };
	  },
	  computed: {
	    contentHeightStyle() {
	      if (!this.containerMaxHeight) {
	        return {
	          height: '100%'
	        };
	      }
	      return {
	        maxHeight: `${this.containerMaxHeight}px`
	      };
	    },
	    gradientHeightStyle() {
	      return {
	        maxHeight: `${this.gradientHeightStyle}px`
	      };
	    }
	  },
	  mounted() {
	    // const container = this.$refs['scroll-container'];
	    // this.showBottomGradient = container.scrollHeight > container.clientHeight;
	  },
	  methods: {
	    onScroll(event) {
	      this.$emit('scroll', event);
	      const scrollPosition = Math.floor(event.target.scrollTop + event.target.clientHeight);
	      this.showBottomGradient = scrollPosition !== event.target.scrollHeight;
	      if (event.target.scrollTop === 0) {
	        this.showTopGradient = false;
	        return;
	      }
	      this.showTopGradient = true;
	    }
	  },
	  template: `
		<div class="bx-im-scroll-with-gradient__container">
			<Transition name="gradient-fade">
				<div v-if="showTopGradient" class="bx-im-scroll-with-gradient__gradient --top" :style="gradientHeightStyle">
					<div v-if="withShadow" class="bx-im-scroll-with-gradient__gradient-inner"></div>
				</div>
			</Transition>
			<div 
				class="bx-im-scroll-with-gradient__content" 
				:style="contentHeightStyle" 
				@scroll="onScroll"
				ref="scroll-container"
			>
				<slot></slot>
			</div>
			<Transition name="gradient-fade">
				<div v-if="showBottomGradient" class="bx-im-scroll-with-gradient__gradient --bottom" :style="gradientHeightStyle">
					<div v-if="withShadow" class="bx-im-scroll-with-gradient__gradient-inner"></div>
				</div>
			</Transition>
		</div>
	`
	};

	var fr = 60;
	var v = "5.9.6";
	var ip = 0;
	var op = 56.12;
	var w = 18;
	var h = 18;
	var nm = "record";
	var ddd = 0;
	var markers = [];
	var assets = [{
	  nm: "[FRAME] record - Null / Ellipse 3 - Null / Ellipse 3 / Ellipse 3 - Null / Ellipse 3 / Ellipse 3 - Null / Ellipse 3",
	  fr: 60,
	  id: "m2czmkdti6rnkip3",
	  layers: [{
	    ty: 3,
	    ddd: 0,
	    ind: 4,
	    hd: false,
	    nm: "record - Null",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [0, 0]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 57.12,
	    st: 0,
	    bm: 0
	  }, {
	    ty: 3,
	    ddd: 0,
	    ind: 5,
	    hd: false,
	    nm: "Ellipse 3 - Null",
	    sr: 1,
	    parent: 4,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 1,
	        k: [{
	          t: 0.06,
	          s: [60],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          }
	        }, {
	          t: 30.06,
	          s: [100],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          }
	        }, {
	          t: 30.12,
	          s: [100],
	          o: {
	            x: [0.42],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          }
	        }, {
	          t: 57.12,
	          s: [60]
	        }]
	      },
	      p: {
	        a: 1,
	        k: [{
	          t: 0.06,
	          s: [8, 8],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 30.06,
	          s: [6, 6],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 30.12,
	          s: [6, 6],
	          o: {
	            x: [0.42],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 57.12,
	          s: [8, 8]
	        }]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0.06,
	    op: 57.12,
	    st: 0,
	    bm: 0
	  }, {
	    ty: 4,
	    ddd: 0,
	    ind: 6,
	    hd: false,
	    nm: "Ellipse 3",
	    sr: 1,
	    parent: 5,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      p: {
	        a: 0,
	        k: [0, 0]
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      o: {
	        a: 1,
	        k: [{
	          t: 0.06,
	          s: [60],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          }
	        }, {
	          t: 30.06,
	          s: [100],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          }
	        }, {
	          t: 30.12,
	          s: [100],
	          o: {
	            x: [0.42],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          }
	        }, {
	          t: 57.12,
	          s: [60]
	        }]
	      }
	    },
	    ao: 0,
	    ip: 0.06,
	    op: 57.12,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      nm: "Group",
	      hd: false,
	      np: 3,
	      it: [{
	        ty: "sh",
	        nm: "Path",
	        hd: false,
	        ks: {
	          a: 1,
	          k: [{
	            t: 0.06,
	            s: [{
	              c: true,
	              v: [[2, 1], [1, 2], [0, 1], [1, 0], [2, 1], [2, 1]],
	              i: [[0, 0], [0.5523, 0], [0, 0.5523], [-0.5523, 0], [0, -0.5523], [0, 0]],
	              o: [[0, 0.5523], [-0.5523, 0], [0, -0.5523], [0.5523, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 1.062,
	            s: [{
	              c: true,
	              v: [[2.222, 1.111], [1.111, 2.222], [0, 1.111], [1.111, 0], [2.222, 1.111], [2.222, 1.111]],
	              i: [[0, 0], [0.6136, 0], [0, 0.6136], [-0.6136, 0], [0, -0.6136], [0, 0]],
	              o: [[0, 0.6136000000000001], [-0.6136, 0], [0, -0.6136], [0.6136000000000001, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 2.058,
	            s: [{
	              c: true,
	              v: [[2.4344, 1.2172], [1.2172, 2.4344], [0, 1.2172], [1.2172, 0], [2.4344, 1.2172], [2.4344, 1.2172]],
	              i: [[0, 0], [0.6723, 0], [0, 0.6723], [-0.6723, 0], [0, -0.6723], [0, 0]],
	              o: [[0, 0.6722999999999999], [-0.6723, 0], [0, -0.6723], [0.6722999999999999, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 3.0599999999999996,
	            s: [{
	              c: true,
	              v: [[2.6424, 1.3212], [1.3212, 2.6424], [0.0001, 1.3212], [1.3212, 0.0001], [2.6424, 1.3212], [2.6424, 1.3212]],
	              i: [[0, 0], [0.7297, 0], [0, 0.7297], [-0.7297, 0], [0, -0.7297], [0, 0]],
	              o: [[0, 0.7297], [-0.7297, 0], [0, -0.7297], [0.7297, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 4.061999999999999,
	            s: [{
	              c: true,
	              v: [[2.8448, 1.4224], [1.4224, 2.8448], [0, 1.4224], [1.4224, 0], [2.8448, 1.4224], [2.8448, 1.4224]],
	              i: [[0, 0], [0.7856, 0], [0, 0.7856], [-0.7856, 0], [0, -0.7856], [0, 0]],
	              o: [[0, 0.7856000000000001], [-0.7856, 0], [0, -0.7856], [0.7856000000000001, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 5.058,
	            s: [{
	              c: true,
	              v: [[3.041, 1.5205], [1.5205, 3.041], [0, 1.5205], [1.5205, 0], [3.041, 1.5205], [3.041, 1.5205]],
	              i: [[0, 0], [0.8398, 0], [0, 0.8398], [-0.8398, 0], [0, -0.8398], [0, 0]],
	              o: [[0, 0.8398000000000001], [-0.8398, 0], [0, -0.8398], [0.8398000000000001, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 6.0600000000000005,
	            s: [{
	              c: true,
	              v: [[3.2336, 1.6168], [1.6168, 3.2336], [0.0001, 1.6168], [1.6168, 0.0001], [3.2336, 1.6168], [3.2336, 1.6168]],
	              i: [[0, 0], [0.8929, 0], [0, 0.8929], [-0.8929, 0], [0, -0.8929], [0, 0]],
	              o: [[0, 0.8929], [-0.8929, 0], [0, -0.8929], [0.8929, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 7.062,
	            s: [{
	              c: true,
	              v: [[3.4212, 1.7106], [1.7106, 3.4212], [0.0001, 1.7106], [1.7106, 0.0001], [3.4212, 1.7106], [3.4212, 1.7106]],
	              i: [[0, 0], [0.9447, 0], [0, 0.9447], [-0.9447, 0], [0, -0.9447], [0, 0]],
	              o: [[0, 0.9447000000000001], [-0.9447, 0], [0, -0.9447], [0.9447000000000001, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 8.058,
	            s: [{
	              c: true,
	              v: [[3.6028, 1.8014], [1.8014, 3.6028], [0, 1.8014], [1.8014, 0], [3.6028, 1.8014], [3.6028, 1.8014]],
	              i: [[0, 0], [0.9949, 0], [0, 0.9949], [-0.9949, 0], [0, -0.9949], [0, 0]],
	              o: [[0, 0.9949000000000001], [-0.9949, 0], [0, -0.9949], [0.9949000000000001, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 9.06,
	            s: [{
	              c: true,
	              v: [[3.7808, 1.8904], [1.8904, 3.7808], [0.0001, 1.8904], [1.8904, 0.0001], [3.7808, 1.8904], [3.7808, 1.8904]],
	              i: [[0, 0], [1.044, 0], [0, 1.044], [-1.044, 0], [0, -1.044], [0, 0]],
	              o: [[0, 1.044], [-1.044, 0], [0, -1.044], [1.044, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 10.062,
	            s: [{
	              c: true,
	              v: [[3.9538, 1.9769], [1.9769, 3.9538], [0.0001, 1.9769], [1.9769, 0.0001], [3.9538, 1.9769], [3.9538, 1.9769]],
	              i: [[0, 0], [1.0918, 0], [0, 1.0918], [-1.0918, 0], [0, -1.0918], [0, 0]],
	              o: [[0, 1.0918], [-1.0918, 0], [0, -1.0918], [1.0918, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 11.058,
	            s: [{
	              c: true,
	              v: [[4.1208, 2.0604], [2.0604, 4.1208], [0.0001, 2.0604], [2.0604, 0.0001], [4.1208, 2.0604], [4.1208, 2.0604]],
	              i: [[0, 0], [1.1379, 0], [0, 1.1379], [-1.1379, 0], [0, -1.1379], [0, 0]],
	              o: [[0, 1.1378999999999997], [-1.1379, 0], [0, -1.1379], [1.1378999999999997, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 12.06,
	            s: [{
	              c: true,
	              v: [[4.2836, 2.1418], [2.1418, 4.2836], [0.0001, 2.1418], [2.1418, 0.0001], [4.2836, 2.1418], [4.2836, 2.1418]],
	              i: [[0, 0], [1.1829, 0], [0, 1.1829], [-1.1829, 0], [0, -1.1829], [0, 0]],
	              o: [[0, 1.1829], [-1.1829, 0], [0, -1.1829], [1.1829, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 13.062000000000001,
	            s: [{
	              c: true,
	              v: [[4.441, 2.2205], [2.2205, 4.441], [0, 2.2205], [2.2205, 0], [4.441, 2.2205], [4.441, 2.2205]],
	              i: [[0, 0], [1.2264, 0], [0, 1.2264], [-1.2264, 0], [0, -1.2264], [0, 0]],
	              o: [[0, 1.2264], [-1.2264, 0], [0, -1.2264], [1.2264, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 14.058,
	            s: [{
	              c: true,
	              v: [[4.5922, 2.2961], [2.2961, 4.5922], [0, 2.2961], [2.2961, 0], [4.5922, 2.2961], [4.5922, 2.2961]],
	              i: [[0, 0], [1.2681, 0], [0, 1.2681], [-1.2681, 0], [0, -1.2681], [0, 0]],
	              o: [[0, 1.2681], [-1.2681, 0], [0, -1.2681], [1.2681, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 15.06,
	            s: [{
	              c: true,
	              v: [[4.7386, 2.3693], [2.3693, 4.7386], [0, 2.3693], [2.3693, 0], [4.7386, 2.3693], [4.7386, 2.3693]],
	              i: [[0, 0], [1.3086, 0], [0, 1.3086], [-1.3086, 0], [0, -1.3086], [0, 0]],
	              o: [[0, 1.3086000000000002], [-1.3086, 0], [0, -1.3086], [1.3086000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 16.062,
	            s: [{
	              c: true,
	              v: [[4.8792, 2.4396], [2.4396, 4.8792], [0.0001, 2.4396], [2.4396, 0.0001], [4.8792, 2.4396], [4.8792, 2.4396]],
	              i: [[0, 0], [1.3474, 0], [0, 1.3474], [-1.3474, 0], [0, -1.3474], [0, 0]],
	              o: [[0, 1.3474], [-1.3474, 0], [0, -1.3474], [1.3474, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 17.058,
	            s: [{
	              c: true,
	              v: [[5.0126, 2.5063], [2.5063, 5.0126], [0, 2.5063], [2.5063, 0], [5.0126, 2.5063], [5.0126, 2.5063]],
	              i: [[0, 0], [1.3842, 0], [0, 1.3842], [-1.3842, 0], [0, -1.3842], [0, 0]],
	              o: [[0, 1.3842000000000003], [-1.3842, 0], [0, -1.3842], [1.3842000000000003, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 18.06,
	            s: [{
	              c: true,
	              v: [[5.1406, 2.5703], [2.5703, 5.1406], [0, 2.5703], [2.5703, 0], [5.1406, 2.5703], [5.1406, 2.5703]],
	              i: [[0, 0], [1.4196, 0], [0, 1.4196], [-1.4196, 0], [0, -1.4196], [0, 0]],
	              o: [[0, 1.4196], [-1.4196, 0], [0, -1.4196], [1.4196, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 19.061999999999998,
	            s: [{
	              c: true,
	              v: [[5.2618, 2.6309], [2.6309, 5.2618], [0.0001, 2.6309], [2.6309, 0.0001], [5.2618, 2.6309], [5.2618, 2.6309]],
	              i: [[0, 0], [1.453, 0], [0, 1.453], [-1.453, 0], [0, -1.453], [0, 0]],
	              o: [[0, 1.4529999999999998], [-1.453, 0], [0, -1.453], [1.4529999999999998, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 20.058,
	            s: [{
	              c: true,
	              v: [[5.3752, 2.6876], [2.6876, 5.3752], [0.0001, 2.6876], [2.6876, 0.0001], [5.3752, 2.6876], [5.3752, 2.6876]],
	              i: [[0, 0], [1.4843, 0], [0, 1.4843], [-1.4843, 0], [0, -1.4843], [0, 0]],
	              o: [[0, 1.4842999999999997], [-1.4843, 0], [0, -1.4843], [1.4842999999999997, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 21.06,
	            s: [{
	              c: true,
	              v: [[5.4818, 2.7409], [2.7409, 5.4818], [0.0001, 2.7409], [2.7409, 0.0001], [5.4818, 2.7409], [5.4818, 2.7409]],
	              i: [[0, 0], [1.5138, 0], [0, 1.5138], [-1.5138, 0], [0, -1.5138], [0, 0]],
	              o: [[0, 1.5137999999999998], [-1.5138, 0], [0, -1.5138], [1.5137999999999998, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 22.062,
	            s: [{
	              c: true,
	              v: [[5.5804, 2.7902], [2.7902, 5.5804], [0.0001, 2.7902], [2.7902, 0.0001], [5.5804, 2.7902], [5.5804, 2.7902]],
	              i: [[0, 0], [1.541, 0], [0, 1.541], [-1.541, 0], [0, -1.541], [0, 0]],
	              o: [[0, 1.541], [-1.541, 0], [0, -1.541], [1.541, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 23.058,
	            s: [{
	              c: true,
	              v: [[5.6698, 2.8349], [2.8349, 5.6698], [0, 2.8349], [2.8349, 0], [5.6698, 2.8349], [5.6698, 2.8349]],
	              i: [[0, 0], [1.5657, 0], [0, 1.5657], [-1.5657, 0], [0, -1.5657], [0, 0]],
	              o: [[0, 1.5657000000000005], [-1.5657, 0], [0, -1.5657], [1.5657000000000005, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 24.060000000000002,
	            s: [{
	              c: true,
	              v: [[5.7509, 2.8755], [2.8754, 5.751], [0, 2.8755], [2.8754, 0.0001], [5.7509, 2.8755], [5.7509, 2.8755]],
	              i: [[0, 0], [1.5881, 0], [0, 1.5881], [-1.5881, 0], [0, -1.5881], [0, 0]],
	              o: [[0, 1.5881000000000003], [-1.5881, 0], [0, -1.5881], [1.5880999999999998, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 25.062,
	            s: [{
	              c: true,
	              v: [[5.8222, 2.9111], [2.9111, 5.8222], [0.0001, 2.9111], [2.9111, 0.0001], [5.8222, 2.9111], [5.8222, 2.9111]],
	              i: [[0, 0], [1.6078, 0], [0, 1.6078], [-1.6078, 0], [0, -1.6078], [0, 0]],
	              o: [[0, 1.6077999999999997], [-1.6078, 0], [0, -1.6078], [1.6077999999999997, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 26.058,
	            s: [{
	              c: true,
	              v: [[5.8826, 2.9413], [2.9413, 5.8826], [0.0001, 2.9413], [2.9413, 0.0001], [5.8826, 2.9413], [5.8826, 2.9413]],
	              i: [[0, 0], [1.6245, 0], [0, 1.6245], [-1.6245, 0], [0, -1.6245], [0, 0]],
	              o: [[0, 1.6245000000000003], [-1.6245, 0], [0, -1.6245], [1.6245000000000003, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 27.060000000000002,
	            s: [{
	              c: true,
	              v: [[5.9319, 2.966], [2.9659, 5.932], [0, 2.966], [2.9659, 0.0001], [5.9319, 2.966], [5.9319, 2.966]],
	              i: [[0, 0], [1.6381, 0], [0, 1.6381], [-1.6381, 0], [0, -1.6381], [0, 0]],
	              o: [[0, 1.6380999999999997], [-1.6381, 0], [0, -1.6381], [1.6381000000000001, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 28.062,
	            s: [{
	              c: true,
	              v: [[5.9688, 2.9844], [2.9844, 5.9688], [0, 2.9844], [2.9844, 0], [5.9688, 2.9844], [5.9688, 2.9844]],
	              i: [[0, 0], [1.6483, 0], [0, 1.6483], [-1.6483, 0], [0, -1.6483], [0, 0]],
	              o: [[0, 1.6482999999999999], [-1.6483, 0], [0, -1.6483], [1.6482999999999999, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 29.058,
	            s: [{
	              c: true,
	              v: [[5.992, 2.996], [2.996, 5.992], [0.0001, 2.996], [2.996, 0.0001], [5.992, 2.996], [5.992, 2.996]],
	              i: [[0, 0], [1.6547, 0], [0, 1.6547], [-1.6547, 0], [0, -1.6547], [0, 0]],
	              o: [[0, 1.6547000000000005], [-1.6547, 0], [0, -1.6547], [1.6547000000000005, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 30.06,
	            s: [{
	              c: true,
	              v: [[6, 3], [3, 6], [0, 3], [3, 0], [6, 3], [6, 3]],
	              i: [[0, 0], [1.6569, 0], [0, 1.6569], [-1.6569, 0], [0, -1.6569], [0, 0]],
	              o: [[0, 1.6569000000000003], [-1.6569, 0], [0, -1.6569], [1.6569000000000003, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 30.12,
	            s: [{
	              c: true,
	              v: [[6, 3], [3, 6], [0, 3], [3, 0], [6, 3], [6, 3]],
	              i: [[0, 0], [1.6569, 0], [0, 1.6569], [-1.6569, 0], [0, -1.6569], [0, 0]],
	              o: [[0, 1.6569000000000003], [-1.6569, 0], [0, -1.6569], [1.6569000000000003, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 31.122000000000003,
	            s: [{
	              c: true,
	              v: [[5.9894, 2.9947], [2.9947, 5.9894], [0, 2.9947], [2.9947, 0], [5.9894, 2.9947], [5.9894, 2.9947]],
	              i: [[0, 0], [1.654, 0], [0, 1.654], [-1.654, 0], [0, -1.654], [0, 0]],
	              o: [[0, 1.654], [-1.654, 0], [0, -1.654], [1.654, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 32.118,
	            s: [{
	              c: true,
	              v: [[5.9574, 2.9787], [2.9787, 5.9574], [0.0001, 2.9787], [2.9787, 0.0001], [5.9574, 2.9787], [5.9574, 2.9787]],
	              i: [[0, 0], [1.6451, 0], [0, 1.6451], [-1.6451, 0], [0, -1.6451], [0, 0]],
	              o: [[0, 1.6451000000000002], [-1.6451, 0], [0, -1.6451], [1.6451000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 33.120000000000005,
	            s: [{
	              c: true,
	              v: [[5.9022, 2.9511], [2.9511, 5.9022], [0, 2.9511], [2.9511, 0], [5.9022, 2.9511], [5.9022, 2.9511]],
	              i: [[0, 0], [1.6299, 0], [0, 1.6299], [-1.6299, 0], [0, -1.6299], [0, 0]],
	              o: [[0, 1.6298999999999997], [-1.6299, 0], [0, -1.6299], [1.6298999999999997, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 34.122,
	            s: [{
	              c: true,
	              v: [[5.8236, 2.9118], [2.9118, 5.8236], [0.0001, 2.9118], [2.9118, 0.0001], [5.8236, 2.9118], [5.8236, 2.9118]],
	              i: [[0, 0], [1.6082, 0], [0, 1.6082], [-1.6082, 0], [0, -1.6082], [0, 0]],
	              o: [[0, 1.6081999999999996], [-1.6082, 0], [0, -1.6082], [1.6081999999999996, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 35.118,
	            s: [{
	              c: true,
	              v: [[5.7214, 2.8607], [2.8607, 5.7214], [0, 2.8607], [2.8607, 0], [5.7214, 2.8607], [5.7214, 2.8607]],
	              i: [[0, 0], [1.58, 0], [0, 1.58], [-1.58, 0], [0, -1.58], [0, 0]],
	              o: [[0, 1.5799999999999996], [-1.58, 0], [0, -1.58], [1.5799999999999996, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 36.12,
	            s: [{
	              c: true,
	              v: [[5.5943, 2.7971], [2.7972, 5.5942], [0.0001, 2.7971], [2.7972, 0], [5.5943, 2.7971], [5.5943, 2.7971]],
	              i: [[0, 0], [1.5449, 0], [0, 1.5449], [-1.5449, 0], [0, -1.5449], [0, 0]],
	              o: [[0, 1.5448999999999997], [-1.5449, 0], [0, -1.5449], [1.5449000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 37.122,
	            s: [{
	              c: true,
	              v: [[5.4432, 2.7216], [2.7216, 5.4432], [0.0001, 2.7216], [2.7216, 0.0001], [5.4432, 2.7216], [5.4432, 2.7216]],
	              i: [[0, 0], [1.5031, 0], [0, 1.5031], [-1.5031, 0], [0, -1.5031], [0, 0]],
	              o: [[0, 1.5031000000000003], [-1.5031, 0], [0, -1.5031], [1.5031000000000003, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 38.117999999999995,
	            s: [{
	              c: true,
	              v: [[5.2696, 2.6348], [2.6348, 5.2696], [0.0001, 2.6348], [2.6348, 0.0001], [5.2696, 2.6348], [5.2696, 2.6348]],
	              i: [[0, 0], [1.4552, 0], [0, 1.4552], [-1.4552, 0], [0, -1.4552], [0, 0]],
	              o: [[0, 1.4552], [-1.4552, 0], [0, -1.4552], [1.4552, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 39.120000000000005,
	            s: [{
	              c: true,
	              v: [[5.0729, 2.5365], [2.5364, 5.073], [0, 2.5365], [2.5364, 0.0001], [5.0729, 2.5365], [5.0729, 2.5365]],
	              i: [[0, 0], [1.4009, 0], [0, 1.4009], [-1.4009, 0], [0, -1.4009], [0, 0]],
	              o: [[0, 1.4009], [-1.4009, 0], [0, -1.4009], [1.4009, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 40.122,
	            s: [{
	              c: true,
	              v: [[4.8568, 2.4284], [2.4284, 4.8568], [0.0001, 2.4284], [2.4284, 0.0001], [4.8568, 2.4284], [4.8568, 2.4284]],
	              i: [[0, 0], [1.3412, 0], [0, 1.3412], [-1.3412, 0], [0, -1.3412], [0, 0]],
	              o: [[0, 1.3411999999999997], [-1.3412, 0], [0, -1.3412], [1.3411999999999997, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 41.118,
	            s: [{
	              c: true,
	              v: [[4.6254, 2.3127], [2.3127, 4.6254], [0, 2.3127], [2.3127, 0], [4.6254, 2.3127], [4.6254, 2.3127]],
	              i: [[0, 0], [1.2773, 0], [0, 1.2773], [-1.2773, 0], [0, -1.2773], [0, 0]],
	              o: [[0, 1.2772999999999999], [-1.2773, 0], [0, -1.2773], [1.2772999999999999, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 42.12,
	            s: [{
	              c: true,
	              v: [[4.3802, 2.1901], [2.1901, 4.3802], [0.0001, 2.1901], [2.1901, 0.0001], [4.3802, 2.1901], [4.3802, 2.1901]],
	              i: [[0, 0], [1.2096, 0], [0, 1.2096], [-1.2096, 0], [0, -1.2096], [0, 0]],
	              o: [[0, 1.2096], [-1.2096, 0], [0, -1.2096], [1.2096, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 43.122,
	            s: [{
	              c: true,
	              v: [[4.1272, 2.0636], [2.0636, 4.1272], [0, 2.0636], [2.0636, 0], [4.1272, 2.0636], [4.1272, 2.0636]],
	              i: [[0, 0], [1.1397, 0], [0, 1.1397], [-1.1397, 0], [0, -1.1397], [0, 0]],
	              o: [[0, 1.1397], [-1.1397, 0], [0, -1.1397], [1.1397, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 44.117999999999995,
	            s: [{
	              c: true,
	              v: [[3.873, 1.9365], [1.9365, 3.873], [0.0001, 1.9365], [1.9365, 0.0001], [3.873, 1.9365], [3.873, 1.9365]],
	              i: [[0, 0], [1.0695, 0], [0, 1.0695], [-1.0695, 0], [0, -1.0695], [0, 0]],
	              o: [[0, 1.0695000000000001], [-1.0695, 0], [0, -1.0695], [1.0695000000000001, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 45.12,
	            s: [{
	              c: true,
	              v: [[3.62, 1.81], [1.81, 3.62], [0.0001, 1.81], [1.81, 0.0001], [3.62, 1.81], [3.62, 1.81]],
	              i: [[0, 0], [0.9996, 0], [0, 0.9996], [-0.9996, 0], [0, -0.9996], [0, 0]],
	              o: [[0, 0.9996], [-0.9996, 0], [0, -0.9996], [0.9996, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 46.122,
	            s: [{
	              c: true,
	              v: [[3.3746, 1.6873], [1.6873, 3.3746], [0, 1.6873], [1.6873, 0], [3.3746, 1.6873], [3.3746, 1.6873]],
	              i: [[0, 0], [0.9319, 0], [0, 0.9319], [-0.9319, 0], [0, -0.9319], [0, 0]],
	              o: [[0, 0.9319000000000002], [-0.9319, 0], [0, -0.9319], [0.9319000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 47.118,
	            s: [{
	              c: true,
	              v: [[3.1434, 1.5717], [1.5717, 3.1434], [0.0001, 1.5717], [1.5717, 0.0001], [3.1434, 1.5717], [3.1434, 1.5717]],
	              i: [[0, 0], [0.868, 0], [0, 0.868], [-0.868, 0], [0, -0.868], [0, 0]],
	              o: [[0, 0.8680000000000001], [-0.868, 0], [0, -0.868], [0.8680000000000001, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 48.120000000000005,
	            s: [{
	              c: true,
	              v: [[2.9271, 1.4635], [1.4636, 2.927], [0.0001, 1.4635], [1.4636, 0], [2.9271, 1.4635], [2.9271, 1.4635]],
	              i: [[0, 0], [0.8083, 0], [0, 0.8083], [-0.8083, 0], [0, -0.8083], [0, 0]],
	              o: [[0, 0.8082999999999998], [-0.8083, 0], [0, -0.8083], [0.8083, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 49.122,
	            s: [{
	              c: true,
	              v: [[2.7306, 1.3653], [1.3653, 2.7306], [0.0001, 1.3653], [1.3653, 0.0001], [2.7306, 1.3653], [2.7306, 1.3653]],
	              i: [[0, 0], [0.754, 0], [0, 0.754], [-0.754, 0], [0, -0.754], [0, 0]],
	              o: [[0, 0.754], [-0.754, 0], [0, -0.754], [0.754, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 50.118,
	            s: [{
	              c: true,
	              v: [[2.557, 1.2785], [1.2785, 2.557], [0.0001, 1.2785], [1.2785, 0.0001], [2.557, 1.2785], [2.557, 1.2785]],
	              i: [[0, 0], [0.7061, 0], [0, 0.7061], [-0.7061, 0], [0, -0.7061], [0, 0]],
	              o: [[0, 0.7061], [-0.7061, 0], [0, -0.7061], [0.7061, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 51.12,
	            s: [{
	              c: true,
	              v: [[2.4058, 1.2029], [1.2029, 2.4058], [0.0001, 1.2029], [1.2029, 0.0001], [2.4058, 1.2029], [2.4058, 1.2029]],
	              i: [[0, 0], [0.6643, 0], [0, 0.6643], [-0.6643, 0], [0, -0.6643], [0, 0]],
	              o: [[0, 0.6642999999999999], [-0.6643, 0], [0, -0.6643], [0.6642999999999999, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 52.122,
	            s: [{
	              c: true,
	              v: [[2.2786, 1.1393], [1.1393, 2.2786], [0, 1.1393], [1.1393, 0], [2.2786, 1.1393], [2.2786, 1.1393]],
	              i: [[0, 0], [0.6292, 0], [0, 0.6292], [-0.6292, 0], [0, -0.6292], [0, 0]],
	              o: [[0, 0.6292], [-0.6292, 0], [0, -0.6292], [0.6292, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 53.117999999999995,
	            s: [{
	              c: true,
	              v: [[2.1766, 1.0883], [1.0883, 2.1766], [0.0001, 1.0883], [1.0883, 0.0001], [2.1766, 1.0883], [2.1766, 1.0883]],
	              i: [[0, 0], [0.601, 0], [0, 0.601], [-0.601, 0], [0, -0.601], [0, 0]],
	              o: [[0, 0.601], [-0.601, 0], [0, -0.601], [0.601, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 54.120000000000005,
	            s: [{
	              c: true,
	              v: [[2.0978, 1.0489], [1.0489, 2.0978], [0, 1.0489], [1.0489, 0], [2.0978, 1.0489], [2.0978, 1.0489]],
	              i: [[0, 0], [0.5793, 0], [0, 0.5793], [-0.5793, 0], [0, -0.5793], [0, 0]],
	              o: [[0, 0.5793000000000001], [-0.5793, 0], [0, -0.5793], [0.5793000000000001, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 55.122,
	            s: [{
	              c: true,
	              v: [[2.0428, 1.0214], [1.0214, 2.0428], [0.0001, 1.0214], [1.0214, 0.0001], [2.0428, 1.0214], [2.0428, 1.0214]],
	              i: [[0, 0], [0.5641, 0], [0, 0.5641], [-0.5641, 0], [0, -0.5641], [0, 0]],
	              o: [[0, 0.5641], [-0.5641, 0], [0, -0.5641], [0.5641, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 56.118,
	            s: [{
	              c: true,
	              v: [[2.0106, 1.0053], [1.0053, 2.0106], [0, 1.0053], [1.0053, 0], [2.0106, 1.0053], [2.0106, 1.0053]],
	              i: [[0, 0], [0.5552, 0], [0, 0.5552], [-0.5552, 0], [0, -0.5552], [0, 0]],
	              o: [[0, 0.5552000000000001], [-0.5552, 0], [0, -0.5552], [0.5552000000000001, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 57.12,
	            s: [{
	              c: true,
	              v: [[2, 1], [1, 2], [0, 1], [1, 0], [2, 1], [2, 1]],
	              i: [[0, 0], [0.5523, 0], [0, 0.5523], [-0.5523, 0], [0, -0.5523], [0, 0]],
	              o: [[0, 0.5523], [-0.5523, 0], [0, -0.5523], [0.5523, 0], [0, 0], [0, 0]]
	            }]
	          }]
	        }
	      }, {
	        ty: "fl",
	        o: {
	          a: 0,
	          k: 100
	        },
	        c: {
	          a: 0,
	          k: [1, 1, 1, 1]
	        },
	        nm: "Fill",
	        hd: false,
	        r: 1
	      }, {
	        ty: "tr",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        o: {
	          a: 0,
	          k: 100
	        }
	      }]
	    }]
	  }, {
	    ty: 3,
	    ddd: 0,
	    ind: 7,
	    hd: false,
	    nm: "Ellipse 3 - Null",
	    sr: 1,
	    parent: 4,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 1,
	        k: [{
	          t: 30.12,
	          s: [100],
	          o: {
	            x: [0.42],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          }
	        }, {
	          t: 57.12,
	          s: [60]
	        }]
	      },
	      p: {
	        a: 1,
	        k: [{
	          t: 30.12,
	          s: [6, 6],
	          o: {
	            x: [0.42],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 57.12,
	          s: [8, 8]
	        }]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 30.12,
	    op: 57.12,
	    st: 0,
	    bm: 0
	  }, {
	    ty: 4,
	    ddd: 0,
	    ind: 8,
	    hd: false,
	    nm: "Ellipse 3",
	    sr: 1,
	    parent: 7,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      p: {
	        a: 0,
	        k: [0, 0]
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      o: {
	        a: 1,
	        k: [{
	          t: 30.12,
	          s: [100],
	          o: {
	            x: [0.42],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          }
	        }, {
	          t: 57.12,
	          s: [60]
	        }]
	      }
	    },
	    ao: 0,
	    ip: 30.12,
	    op: 57.12,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      nm: "Group",
	      hd: false,
	      np: 3,
	      it: [{
	        ty: "sh",
	        nm: "Path",
	        hd: false,
	        ks: {
	          a: 1,
	          k: [{
	            t: 30.12,
	            s: [{
	              c: true,
	              v: [[6, 3], [3, 6], [0, 3], [3, 0], [6, 3], [6, 3]],
	              i: [[0, 0], [1.6569, 0], [0, 1.6569], [-1.6569, 0], [0, -1.6569], [0, 0]],
	              o: [[0, 1.6569000000000003], [-1.6569, 0], [0, -1.6569], [1.6569000000000003, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 31.122000000000003,
	            s: [{
	              c: true,
	              v: [[5.9894, 2.9947], [2.9947, 5.9894], [0, 2.9947], [2.9947, 0], [5.9894, 2.9947], [5.9894, 2.9947]],
	              i: [[0, 0], [1.654, 0], [0, 1.654], [-1.654, 0], [0, -1.654], [0, 0]],
	              o: [[0, 1.654], [-1.654, 0], [0, -1.654], [1.654, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 32.118,
	            s: [{
	              c: true,
	              v: [[5.9574, 2.9787], [2.9787, 5.9574], [0.0001, 2.9787], [2.9787, 0.0001], [5.9574, 2.9787], [5.9574, 2.9787]],
	              i: [[0, 0], [1.6451, 0], [0, 1.6451], [-1.6451, 0], [0, -1.6451], [0, 0]],
	              o: [[0, 1.6451000000000002], [-1.6451, 0], [0, -1.6451], [1.6451000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 33.120000000000005,
	            s: [{
	              c: true,
	              v: [[5.9022, 2.9511], [2.9511, 5.9022], [0, 2.9511], [2.9511, 0], [5.9022, 2.9511], [5.9022, 2.9511]],
	              i: [[0, 0], [1.6299, 0], [0, 1.6299], [-1.6299, 0], [0, -1.6299], [0, 0]],
	              o: [[0, 1.6298999999999997], [-1.6299, 0], [0, -1.6299], [1.6298999999999997, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 34.122,
	            s: [{
	              c: true,
	              v: [[5.8236, 2.9118], [2.9118, 5.8236], [0.0001, 2.9118], [2.9118, 0.0001], [5.8236, 2.9118], [5.8236, 2.9118]],
	              i: [[0, 0], [1.6082, 0], [0, 1.6082], [-1.6082, 0], [0, -1.6082], [0, 0]],
	              o: [[0, 1.6081999999999996], [-1.6082, 0], [0, -1.6082], [1.6081999999999996, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 35.118,
	            s: [{
	              c: true,
	              v: [[5.7214, 2.8607], [2.8607, 5.7214], [0, 2.8607], [2.8607, 0], [5.7214, 2.8607], [5.7214, 2.8607]],
	              i: [[0, 0], [1.58, 0], [0, 1.58], [-1.58, 0], [0, -1.58], [0, 0]],
	              o: [[0, 1.5799999999999996], [-1.58, 0], [0, -1.58], [1.5799999999999996, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 36.12,
	            s: [{
	              c: true,
	              v: [[5.5943, 2.7971], [2.7972, 5.5942], [0.0001, 2.7971], [2.7972, 0], [5.5943, 2.7971], [5.5943, 2.7971]],
	              i: [[0, 0], [1.5449, 0], [0, 1.5449], [-1.5449, 0], [0, -1.5449], [0, 0]],
	              o: [[0, 1.5448999999999997], [-1.5449, 0], [0, -1.5449], [1.5449000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 37.122,
	            s: [{
	              c: true,
	              v: [[5.4432, 2.7216], [2.7216, 5.4432], [0.0001, 2.7216], [2.7216, 0.0001], [5.4432, 2.7216], [5.4432, 2.7216]],
	              i: [[0, 0], [1.5031, 0], [0, 1.5031], [-1.5031, 0], [0, -1.5031], [0, 0]],
	              o: [[0, 1.5031000000000003], [-1.5031, 0], [0, -1.5031], [1.5031000000000003, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 38.117999999999995,
	            s: [{
	              c: true,
	              v: [[5.2696, 2.6348], [2.6348, 5.2696], [0.0001, 2.6348], [2.6348, 0.0001], [5.2696, 2.6348], [5.2696, 2.6348]],
	              i: [[0, 0], [1.4552, 0], [0, 1.4552], [-1.4552, 0], [0, -1.4552], [0, 0]],
	              o: [[0, 1.4552], [-1.4552, 0], [0, -1.4552], [1.4552, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 39.120000000000005,
	            s: [{
	              c: true,
	              v: [[5.0729, 2.5365], [2.5364, 5.073], [0, 2.5365], [2.5364, 0.0001], [5.0729, 2.5365], [5.0729, 2.5365]],
	              i: [[0, 0], [1.4009, 0], [0, 1.4009], [-1.4009, 0], [0, -1.4009], [0, 0]],
	              o: [[0, 1.4009], [-1.4009, 0], [0, -1.4009], [1.4009, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 40.122,
	            s: [{
	              c: true,
	              v: [[4.8568, 2.4284], [2.4284, 4.8568], [0.0001, 2.4284], [2.4284, 0.0001], [4.8568, 2.4284], [4.8568, 2.4284]],
	              i: [[0, 0], [1.3412, 0], [0, 1.3412], [-1.3412, 0], [0, -1.3412], [0, 0]],
	              o: [[0, 1.3411999999999997], [-1.3412, 0], [0, -1.3412], [1.3411999999999997, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 41.118,
	            s: [{
	              c: true,
	              v: [[4.6254, 2.3127], [2.3127, 4.6254], [0, 2.3127], [2.3127, 0], [4.6254, 2.3127], [4.6254, 2.3127]],
	              i: [[0, 0], [1.2773, 0], [0, 1.2773], [-1.2773, 0], [0, -1.2773], [0, 0]],
	              o: [[0, 1.2772999999999999], [-1.2773, 0], [0, -1.2773], [1.2772999999999999, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 42.12,
	            s: [{
	              c: true,
	              v: [[4.3802, 2.1901], [2.1901, 4.3802], [0.0001, 2.1901], [2.1901, 0.0001], [4.3802, 2.1901], [4.3802, 2.1901]],
	              i: [[0, 0], [1.2096, 0], [0, 1.2096], [-1.2096, 0], [0, -1.2096], [0, 0]],
	              o: [[0, 1.2096], [-1.2096, 0], [0, -1.2096], [1.2096, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 43.122,
	            s: [{
	              c: true,
	              v: [[4.1272, 2.0636], [2.0636, 4.1272], [0, 2.0636], [2.0636, 0], [4.1272, 2.0636], [4.1272, 2.0636]],
	              i: [[0, 0], [1.1397, 0], [0, 1.1397], [-1.1397, 0], [0, -1.1397], [0, 0]],
	              o: [[0, 1.1397], [-1.1397, 0], [0, -1.1397], [1.1397, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 44.117999999999995,
	            s: [{
	              c: true,
	              v: [[3.873, 1.9365], [1.9365, 3.873], [0.0001, 1.9365], [1.9365, 0.0001], [3.873, 1.9365], [3.873, 1.9365]],
	              i: [[0, 0], [1.0695, 0], [0, 1.0695], [-1.0695, 0], [0, -1.0695], [0, 0]],
	              o: [[0, 1.0695000000000001], [-1.0695, 0], [0, -1.0695], [1.0695000000000001, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 45.12,
	            s: [{
	              c: true,
	              v: [[3.62, 1.81], [1.81, 3.62], [0.0001, 1.81], [1.81, 0.0001], [3.62, 1.81], [3.62, 1.81]],
	              i: [[0, 0], [0.9996, 0], [0, 0.9996], [-0.9996, 0], [0, -0.9996], [0, 0]],
	              o: [[0, 0.9996], [-0.9996, 0], [0, -0.9996], [0.9996, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 46.122,
	            s: [{
	              c: true,
	              v: [[3.3746, 1.6873], [1.6873, 3.3746], [0, 1.6873], [1.6873, 0], [3.3746, 1.6873], [3.3746, 1.6873]],
	              i: [[0, 0], [0.9319, 0], [0, 0.9319], [-0.9319, 0], [0, -0.9319], [0, 0]],
	              o: [[0, 0.9319000000000002], [-0.9319, 0], [0, -0.9319], [0.9319000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 47.118,
	            s: [{
	              c: true,
	              v: [[3.1434, 1.5717], [1.5717, 3.1434], [0.0001, 1.5717], [1.5717, 0.0001], [3.1434, 1.5717], [3.1434, 1.5717]],
	              i: [[0, 0], [0.868, 0], [0, 0.868], [-0.868, 0], [0, -0.868], [0, 0]],
	              o: [[0, 0.8680000000000001], [-0.868, 0], [0, -0.868], [0.8680000000000001, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 48.120000000000005,
	            s: [{
	              c: true,
	              v: [[2.9271, 1.4635], [1.4636, 2.927], [0.0001, 1.4635], [1.4636, 0], [2.9271, 1.4635], [2.9271, 1.4635]],
	              i: [[0, 0], [0.8083, 0], [0, 0.8083], [-0.8083, 0], [0, -0.8083], [0, 0]],
	              o: [[0, 0.8082999999999998], [-0.8083, 0], [0, -0.8083], [0.8083, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 49.122,
	            s: [{
	              c: true,
	              v: [[2.7306, 1.3653], [1.3653, 2.7306], [0.0001, 1.3653], [1.3653, 0.0001], [2.7306, 1.3653], [2.7306, 1.3653]],
	              i: [[0, 0], [0.754, 0], [0, 0.754], [-0.754, 0], [0, -0.754], [0, 0]],
	              o: [[0, 0.754], [-0.754, 0], [0, -0.754], [0.754, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 50.118,
	            s: [{
	              c: true,
	              v: [[2.557, 1.2785], [1.2785, 2.557], [0.0001, 1.2785], [1.2785, 0.0001], [2.557, 1.2785], [2.557, 1.2785]],
	              i: [[0, 0], [0.7061, 0], [0, 0.7061], [-0.7061, 0], [0, -0.7061], [0, 0]],
	              o: [[0, 0.7061], [-0.7061, 0], [0, -0.7061], [0.7061, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 51.12,
	            s: [{
	              c: true,
	              v: [[2.4058, 1.2029], [1.2029, 2.4058], [0.0001, 1.2029], [1.2029, 0.0001], [2.4058, 1.2029], [2.4058, 1.2029]],
	              i: [[0, 0], [0.6643, 0], [0, 0.6643], [-0.6643, 0], [0, -0.6643], [0, 0]],
	              o: [[0, 0.6642999999999999], [-0.6643, 0], [0, -0.6643], [0.6642999999999999, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 52.122,
	            s: [{
	              c: true,
	              v: [[2.2786, 1.1393], [1.1393, 2.2786], [0, 1.1393], [1.1393, 0], [2.2786, 1.1393], [2.2786, 1.1393]],
	              i: [[0, 0], [0.6292, 0], [0, 0.6292], [-0.6292, 0], [0, -0.6292], [0, 0]],
	              o: [[0, 0.6292], [-0.6292, 0], [0, -0.6292], [0.6292, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 53.117999999999995,
	            s: [{
	              c: true,
	              v: [[2.1766, 1.0883], [1.0883, 2.1766], [0.0001, 1.0883], [1.0883, 0.0001], [2.1766, 1.0883], [2.1766, 1.0883]],
	              i: [[0, 0], [0.601, 0], [0, 0.601], [-0.601, 0], [0, -0.601], [0, 0]],
	              o: [[0, 0.601], [-0.601, 0], [0, -0.601], [0.601, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 54.120000000000005,
	            s: [{
	              c: true,
	              v: [[2.0978, 1.0489], [1.0489, 2.0978], [0, 1.0489], [1.0489, 0], [2.0978, 1.0489], [2.0978, 1.0489]],
	              i: [[0, 0], [0.5793, 0], [0, 0.5793], [-0.5793, 0], [0, -0.5793], [0, 0]],
	              o: [[0, 0.5793000000000001], [-0.5793, 0], [0, -0.5793], [0.5793000000000001, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 55.122,
	            s: [{
	              c: true,
	              v: [[2.0428, 1.0214], [1.0214, 2.0428], [0.0001, 1.0214], [1.0214, 0.0001], [2.0428, 1.0214], [2.0428, 1.0214]],
	              i: [[0, 0], [0.5641, 0], [0, 0.5641], [-0.5641, 0], [0, -0.5641], [0, 0]],
	              o: [[0, 0.5641], [-0.5641, 0], [0, -0.5641], [0.5641, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 56.118,
	            s: [{
	              c: true,
	              v: [[2.0106, 1.0053], [1.0053, 2.0106], [0, 1.0053], [1.0053, 0], [2.0106, 1.0053], [2.0106, 1.0053]],
	              i: [[0, 0], [0.5552, 0], [0, 0.5552], [-0.5552, 0], [0, -0.5552], [0, 0]],
	              o: [[0, 0.5552000000000001], [-0.5552, 0], [0, -0.5552], [0.5552000000000001, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 57.12,
	            s: [{
	              c: true,
	              v: [[2, 1], [1, 2], [0, 1], [1, 0], [2, 1], [2, 1]],
	              i: [[0, 0], [0.5523, 0], [0, 0.5523], [-0.5523, 0], [0, -0.5523], [0, 0]],
	              o: [[0, 0.5523], [-0.5523, 0], [0, -0.5523], [0.5523, 0], [0, 0], [0, 0]]
	            }]
	          }]
	        }
	      }, {
	        ty: "fl",
	        o: {
	          a: 0,
	          k: 100
	        },
	        c: {
	          a: 0,
	          k: [1, 1, 1, 1]
	        },
	        nm: "Fill",
	        hd: false,
	        r: 1
	      }, {
	        ty: "tr",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        o: {
	          a: 0,
	          k: 100
	        }
	      }]
	    }]
	  }, {
	    ty: 3,
	    ddd: 0,
	    ind: 9,
	    hd: false,
	    nm: "Ellipse 3 - Null",
	    sr: 1,
	    parent: 4,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 1,
	        k: [{
	          t: 0.06,
	          s: [60],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          }
	        }, {
	          t: 30.06,
	          s: [100]
	        }]
	      },
	      p: {
	        a: 1,
	        k: [{
	          t: 0.06,
	          s: [8, 8],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 30.06,
	          s: [6, 6]
	        }]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 30.06,
	    st: 0,
	    bm: 0
	  }, {
	    ty: 4,
	    ddd: 0,
	    ind: 10,
	    hd: false,
	    nm: "Ellipse 3",
	    sr: 1,
	    parent: 9,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      p: {
	        a: 0,
	        k: [0, 0]
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      o: {
	        a: 1,
	        k: [{
	          t: 0.06,
	          s: [60],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          }
	        }, {
	          t: 30.06,
	          s: [100]
	        }]
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 30.06,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      nm: "Group",
	      hd: false,
	      np: 3,
	      it: [{
	        ty: "sh",
	        nm: "Path",
	        hd: false,
	        ks: {
	          a: 1,
	          k: [{
	            t: 0.06,
	            s: [{
	              c: true,
	              v: [[2, 1], [1, 2], [0, 1], [1, 0], [2, 1], [2, 1]],
	              i: [[0, 0], [0.5523, 0], [0, 0.5523], [-0.5523, 0], [0, -0.5523], [0, 0]],
	              o: [[0, 0.5523], [-0.5523, 0], [0, -0.5523], [0.5523, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 1.062,
	            s: [{
	              c: true,
	              v: [[2.222, 1.111], [1.111, 2.222], [0, 1.111], [1.111, 0], [2.222, 1.111], [2.222, 1.111]],
	              i: [[0, 0], [0.6136, 0], [0, 0.6136], [-0.6136, 0], [0, -0.6136], [0, 0]],
	              o: [[0, 0.6136000000000001], [-0.6136, 0], [0, -0.6136], [0.6136000000000001, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 2.058,
	            s: [{
	              c: true,
	              v: [[2.4344, 1.2172], [1.2172, 2.4344], [0, 1.2172], [1.2172, 0], [2.4344, 1.2172], [2.4344, 1.2172]],
	              i: [[0, 0], [0.6723, 0], [0, 0.6723], [-0.6723, 0], [0, -0.6723], [0, 0]],
	              o: [[0, 0.6722999999999999], [-0.6723, 0], [0, -0.6723], [0.6722999999999999, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 3.0599999999999996,
	            s: [{
	              c: true,
	              v: [[2.6424, 1.3212], [1.3212, 2.6424], [0.0001, 1.3212], [1.3212, 0.0001], [2.6424, 1.3212], [2.6424, 1.3212]],
	              i: [[0, 0], [0.7297, 0], [0, 0.7297], [-0.7297, 0], [0, -0.7297], [0, 0]],
	              o: [[0, 0.7297], [-0.7297, 0], [0, -0.7297], [0.7297, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 4.061999999999999,
	            s: [{
	              c: true,
	              v: [[2.8448, 1.4224], [1.4224, 2.8448], [0, 1.4224], [1.4224, 0], [2.8448, 1.4224], [2.8448, 1.4224]],
	              i: [[0, 0], [0.7856, 0], [0, 0.7856], [-0.7856, 0], [0, -0.7856], [0, 0]],
	              o: [[0, 0.7856000000000001], [-0.7856, 0], [0, -0.7856], [0.7856000000000001, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 5.058,
	            s: [{
	              c: true,
	              v: [[3.041, 1.5205], [1.5205, 3.041], [0, 1.5205], [1.5205, 0], [3.041, 1.5205], [3.041, 1.5205]],
	              i: [[0, 0], [0.8398, 0], [0, 0.8398], [-0.8398, 0], [0, -0.8398], [0, 0]],
	              o: [[0, 0.8398000000000001], [-0.8398, 0], [0, -0.8398], [0.8398000000000001, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 6.0600000000000005,
	            s: [{
	              c: true,
	              v: [[3.2336, 1.6168], [1.6168, 3.2336], [0.0001, 1.6168], [1.6168, 0.0001], [3.2336, 1.6168], [3.2336, 1.6168]],
	              i: [[0, 0], [0.8929, 0], [0, 0.8929], [-0.8929, 0], [0, -0.8929], [0, 0]],
	              o: [[0, 0.8929], [-0.8929, 0], [0, -0.8929], [0.8929, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 7.062,
	            s: [{
	              c: true,
	              v: [[3.4212, 1.7106], [1.7106, 3.4212], [0.0001, 1.7106], [1.7106, 0.0001], [3.4212, 1.7106], [3.4212, 1.7106]],
	              i: [[0, 0], [0.9447, 0], [0, 0.9447], [-0.9447, 0], [0, -0.9447], [0, 0]],
	              o: [[0, 0.9447000000000001], [-0.9447, 0], [0, -0.9447], [0.9447000000000001, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 8.058,
	            s: [{
	              c: true,
	              v: [[3.6028, 1.8014], [1.8014, 3.6028], [0, 1.8014], [1.8014, 0], [3.6028, 1.8014], [3.6028, 1.8014]],
	              i: [[0, 0], [0.9949, 0], [0, 0.9949], [-0.9949, 0], [0, -0.9949], [0, 0]],
	              o: [[0, 0.9949000000000001], [-0.9949, 0], [0, -0.9949], [0.9949000000000001, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 9.06,
	            s: [{
	              c: true,
	              v: [[3.7808, 1.8904], [1.8904, 3.7808], [0.0001, 1.8904], [1.8904, 0.0001], [3.7808, 1.8904], [3.7808, 1.8904]],
	              i: [[0, 0], [1.044, 0], [0, 1.044], [-1.044, 0], [0, -1.044], [0, 0]],
	              o: [[0, 1.044], [-1.044, 0], [0, -1.044], [1.044, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 10.062,
	            s: [{
	              c: true,
	              v: [[3.9538, 1.9769], [1.9769, 3.9538], [0.0001, 1.9769], [1.9769, 0.0001], [3.9538, 1.9769], [3.9538, 1.9769]],
	              i: [[0, 0], [1.0918, 0], [0, 1.0918], [-1.0918, 0], [0, -1.0918], [0, 0]],
	              o: [[0, 1.0918], [-1.0918, 0], [0, -1.0918], [1.0918, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 11.058,
	            s: [{
	              c: true,
	              v: [[4.1208, 2.0604], [2.0604, 4.1208], [0.0001, 2.0604], [2.0604, 0.0001], [4.1208, 2.0604], [4.1208, 2.0604]],
	              i: [[0, 0], [1.1379, 0], [0, 1.1379], [-1.1379, 0], [0, -1.1379], [0, 0]],
	              o: [[0, 1.1378999999999997], [-1.1379, 0], [0, -1.1379], [1.1378999999999997, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 12.06,
	            s: [{
	              c: true,
	              v: [[4.2836, 2.1418], [2.1418, 4.2836], [0.0001, 2.1418], [2.1418, 0.0001], [4.2836, 2.1418], [4.2836, 2.1418]],
	              i: [[0, 0], [1.1829, 0], [0, 1.1829], [-1.1829, 0], [0, -1.1829], [0, 0]],
	              o: [[0, 1.1829], [-1.1829, 0], [0, -1.1829], [1.1829, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 13.062000000000001,
	            s: [{
	              c: true,
	              v: [[4.441, 2.2205], [2.2205, 4.441], [0, 2.2205], [2.2205, 0], [4.441, 2.2205], [4.441, 2.2205]],
	              i: [[0, 0], [1.2264, 0], [0, 1.2264], [-1.2264, 0], [0, -1.2264], [0, 0]],
	              o: [[0, 1.2264], [-1.2264, 0], [0, -1.2264], [1.2264, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 14.058,
	            s: [{
	              c: true,
	              v: [[4.5922, 2.2961], [2.2961, 4.5922], [0, 2.2961], [2.2961, 0], [4.5922, 2.2961], [4.5922, 2.2961]],
	              i: [[0, 0], [1.2681, 0], [0, 1.2681], [-1.2681, 0], [0, -1.2681], [0, 0]],
	              o: [[0, 1.2681], [-1.2681, 0], [0, -1.2681], [1.2681, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 15.06,
	            s: [{
	              c: true,
	              v: [[4.7386, 2.3693], [2.3693, 4.7386], [0, 2.3693], [2.3693, 0], [4.7386, 2.3693], [4.7386, 2.3693]],
	              i: [[0, 0], [1.3086, 0], [0, 1.3086], [-1.3086, 0], [0, -1.3086], [0, 0]],
	              o: [[0, 1.3086000000000002], [-1.3086, 0], [0, -1.3086], [1.3086000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 16.062,
	            s: [{
	              c: true,
	              v: [[4.8792, 2.4396], [2.4396, 4.8792], [0.0001, 2.4396], [2.4396, 0.0001], [4.8792, 2.4396], [4.8792, 2.4396]],
	              i: [[0, 0], [1.3474, 0], [0, 1.3474], [-1.3474, 0], [0, -1.3474], [0, 0]],
	              o: [[0, 1.3474], [-1.3474, 0], [0, -1.3474], [1.3474, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 17.058,
	            s: [{
	              c: true,
	              v: [[5.0126, 2.5063], [2.5063, 5.0126], [0, 2.5063], [2.5063, 0], [5.0126, 2.5063], [5.0126, 2.5063]],
	              i: [[0, 0], [1.3842, 0], [0, 1.3842], [-1.3842, 0], [0, -1.3842], [0, 0]],
	              o: [[0, 1.3842000000000003], [-1.3842, 0], [0, -1.3842], [1.3842000000000003, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 18.06,
	            s: [{
	              c: true,
	              v: [[5.1406, 2.5703], [2.5703, 5.1406], [0, 2.5703], [2.5703, 0], [5.1406, 2.5703], [5.1406, 2.5703]],
	              i: [[0, 0], [1.4196, 0], [0, 1.4196], [-1.4196, 0], [0, -1.4196], [0, 0]],
	              o: [[0, 1.4196], [-1.4196, 0], [0, -1.4196], [1.4196, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 19.061999999999998,
	            s: [{
	              c: true,
	              v: [[5.2618, 2.6309], [2.6309, 5.2618], [0.0001, 2.6309], [2.6309, 0.0001], [5.2618, 2.6309], [5.2618, 2.6309]],
	              i: [[0, 0], [1.453, 0], [0, 1.453], [-1.453, 0], [0, -1.453], [0, 0]],
	              o: [[0, 1.4529999999999998], [-1.453, 0], [0, -1.453], [1.4529999999999998, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 20.058,
	            s: [{
	              c: true,
	              v: [[5.3752, 2.6876], [2.6876, 5.3752], [0.0001, 2.6876], [2.6876, 0.0001], [5.3752, 2.6876], [5.3752, 2.6876]],
	              i: [[0, 0], [1.4843, 0], [0, 1.4843], [-1.4843, 0], [0, -1.4843], [0, 0]],
	              o: [[0, 1.4842999999999997], [-1.4843, 0], [0, -1.4843], [1.4842999999999997, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 21.06,
	            s: [{
	              c: true,
	              v: [[5.4818, 2.7409], [2.7409, 5.4818], [0.0001, 2.7409], [2.7409, 0.0001], [5.4818, 2.7409], [5.4818, 2.7409]],
	              i: [[0, 0], [1.5138, 0], [0, 1.5138], [-1.5138, 0], [0, -1.5138], [0, 0]],
	              o: [[0, 1.5137999999999998], [-1.5138, 0], [0, -1.5138], [1.5137999999999998, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 22.062,
	            s: [{
	              c: true,
	              v: [[5.5804, 2.7902], [2.7902, 5.5804], [0.0001, 2.7902], [2.7902, 0.0001], [5.5804, 2.7902], [5.5804, 2.7902]],
	              i: [[0, 0], [1.541, 0], [0, 1.541], [-1.541, 0], [0, -1.541], [0, 0]],
	              o: [[0, 1.541], [-1.541, 0], [0, -1.541], [1.541, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 23.058,
	            s: [{
	              c: true,
	              v: [[5.6698, 2.8349], [2.8349, 5.6698], [0, 2.8349], [2.8349, 0], [5.6698, 2.8349], [5.6698, 2.8349]],
	              i: [[0, 0], [1.5657, 0], [0, 1.5657], [-1.5657, 0], [0, -1.5657], [0, 0]],
	              o: [[0, 1.5657000000000005], [-1.5657, 0], [0, -1.5657], [1.5657000000000005, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 24.060000000000002,
	            s: [{
	              c: true,
	              v: [[5.7509, 2.8755], [2.8754, 5.751], [0, 2.8755], [2.8754, 0.0001], [5.7509, 2.8755], [5.7509, 2.8755]],
	              i: [[0, 0], [1.5881, 0], [0, 1.5881], [-1.5881, 0], [0, -1.5881], [0, 0]],
	              o: [[0, 1.5881000000000003], [-1.5881, 0], [0, -1.5881], [1.5880999999999998, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 25.062,
	            s: [{
	              c: true,
	              v: [[5.8222, 2.9111], [2.9111, 5.8222], [0.0001, 2.9111], [2.9111, 0.0001], [5.8222, 2.9111], [5.8222, 2.9111]],
	              i: [[0, 0], [1.6078, 0], [0, 1.6078], [-1.6078, 0], [0, -1.6078], [0, 0]],
	              o: [[0, 1.6077999999999997], [-1.6078, 0], [0, -1.6078], [1.6077999999999997, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 26.058,
	            s: [{
	              c: true,
	              v: [[5.8826, 2.9413], [2.9413, 5.8826], [0.0001, 2.9413], [2.9413, 0.0001], [5.8826, 2.9413], [5.8826, 2.9413]],
	              i: [[0, 0], [1.6245, 0], [0, 1.6245], [-1.6245, 0], [0, -1.6245], [0, 0]],
	              o: [[0, 1.6245000000000003], [-1.6245, 0], [0, -1.6245], [1.6245000000000003, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 27.060000000000002,
	            s: [{
	              c: true,
	              v: [[5.9319, 2.966], [2.9659, 5.932], [0, 2.966], [2.9659, 0.0001], [5.9319, 2.966], [5.9319, 2.966]],
	              i: [[0, 0], [1.6381, 0], [0, 1.6381], [-1.6381, 0], [0, -1.6381], [0, 0]],
	              o: [[0, 1.6380999999999997], [-1.6381, 0], [0, -1.6381], [1.6381000000000001, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 28.062,
	            s: [{
	              c: true,
	              v: [[5.9688, 2.9844], [2.9844, 5.9688], [0, 2.9844], [2.9844, 0], [5.9688, 2.9844], [5.9688, 2.9844]],
	              i: [[0, 0], [1.6483, 0], [0, 1.6483], [-1.6483, 0], [0, -1.6483], [0, 0]],
	              o: [[0, 1.6482999999999999], [-1.6483, 0], [0, -1.6483], [1.6482999999999999, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 29.058,
	            s: [{
	              c: true,
	              v: [[5.992, 2.996], [2.996, 5.992], [0.0001, 2.996], [2.996, 0.0001], [5.992, 2.996], [5.992, 2.996]],
	              i: [[0, 0], [1.6547, 0], [0, 1.6547], [-1.6547, 0], [0, -1.6547], [0, 0]],
	              o: [[0, 1.6547000000000005], [-1.6547, 0], [0, -1.6547], [1.6547000000000005, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 30.06,
	            s: [{
	              c: true,
	              v: [[6, 3], [3, 6], [0, 3], [3, 0], [6, 3], [6, 3]],
	              i: [[0, 0], [1.6569, 0], [0, 1.6569], [-1.6569, 0], [0, -1.6569], [0, 0]],
	              o: [[0, 1.6569000000000003], [-1.6569, 0], [0, -1.6569], [1.6569000000000003, 0], [0, 0], [0, 0]]
	            }]
	          }]
	        }
	      }, {
	        ty: "fl",
	        o: {
	          a: 0,
	          k: 100
	        },
	        c: {
	          a: 0,
	          k: [1, 1, 1, 1]
	        },
	        nm: "Fill",
	        hd: false,
	        r: 1
	      }, {
	        ty: "tr",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        o: {
	          a: 0,
	          k: 100
	        }
	      }]
	    }]
	  }]
	}];
	var layers = [{
	  ddd: 0,
	  ind: 1,
	  ty: 0,
	  nm: "record",
	  refId: "m2czmkdti6rnkip3",
	  sr: 1,
	  ks: {
	    a: {
	      a: 0,
	      k: [0, 0]
	    },
	    p: {
	      a: 0,
	      k: [0, 0]
	    },
	    s: {
	      a: 0,
	      k: [100, 100]
	    },
	    sk: {
	      a: 0,
	      k: 0
	    },
	    sa: {
	      a: 0,
	      k: 0
	    },
	    r: {
	      a: 0,
	      k: 0
	    },
	    o: {
	      a: 0,
	      k: 100
	    }
	  },
	  ao: 0,
	  w: 18,
	  h: 18,
	  ip: 0,
	  op: 57.12,
	  st: 0,
	  hd: false,
	  bm: 0
	}];
	var meta = {
	  a: "",
	  d: "",
	  tc: "",
	  g: "Aninix"
	};
	var RecordingAnimation = {
	  fr: fr,
	  v: v,
	  ip: ip,
	  op: op,
	  w: w,
	  h: h,
	  nm: nm,
	  ddd: ddd,
	  markers: markers,
	  assets: assets,
	  layers: layers,
	  meta: meta
	};

	var fr$1 = 60;
	var v$1 = "5.9.6";
	var ip$1 = 0;
	var op$1 = 137.12;
	var w$1 = 19;
	var h$1 = 18;
	var nm$1 = "send/1";
	var ddd$1 = 0;
	var markers$1 = [];
	var assets$1 = [{
	  id: "ad33659c33381eac40061641b81f19d65a13ad9f",
	  w: 1,
	  h: 1,
	  e: 1,
	  u: "",
	  p: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAAXNSR0IArs4c6QAAAAtJREFUGFdjYAACAAAFAAGq1chRAAAAAElFTkSuQmCC"
	}, {
	  nm: "frame",
	  fr: 60,
	  id: "m2czp0x468684051",
	  layers: [{
	    ty: 3,
	    ddd: 0,
	    ind: 4,
	    hd: false,
	    nm: "send/1 - Null",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [0, 0]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 138.12,
	    st: 0,
	    bm: 0
	  }, {
	    ty: 3,
	    ddd: 0,
	    ind: 5,
	    hd: false,
	    nm: "frame - Null",
	    sr: 1,
	    parent: 4,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 1,
	        k: [{
	          t: 24.12,
	          s: [0, 7],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [1],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 54.120000000000005,
	          s: [2, 7]
	        }]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 138.12,
	    st: 0,
	    bm: 0
	  }, {
	    ty: 4,
	    ddd: 0,
	    ind: 6,
	    hd: false,
	    nm: "frame - Shape Mask",
	    sr: 1,
	    parent: 5,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      p: {
	        a: 0,
	        k: [0, 0]
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      o: {
	        a: 0,
	        k: 100
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 138.12,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      nm: "Group",
	      hd: false,
	      np: 3,
	      it: [{
	        ty: "sh",
	        nm: "Path",
	        hd: false,
	        ks: {
	          a: 0,
	          k: {
	            c: true,
	            v: [[2.5, 0], [14.5, 0], [17, 2.5], [17, 2.5], [14.5, 5], [2.5, 5], [0, 2.5], [0, 2.5], [2.5, 0], [2.5, 0]],
	            i: [[0, 0], [0, 0], [0, -1.3807], [0, 0], [1.3807, 0], [0, 0], [0, 1.3807], [0, 0], [-1.3807, 0], [0, 0]],
	            o: [[0, 0], [1.3807100000000005, 0], [0, 0], [0, 1.38071], [0, 0], [-1.38071, 0], [0, 0], [0, -1.38071], [0, 0], [0, 0]]
	          }
	        }
	      }, {
	        ty: "fl",
	        o: {
	          a: 0,
	          k: 100
	        },
	        c: {
	          a: 0,
	          k: [0, 1, 0, 1]
	        },
	        nm: "Fill",
	        hd: false,
	        r: 1
	      }, {
	        ty: "tr",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        o: {
	          a: 0,
	          k: 100
	        }
	      }]
	    }]
	  }]
	}, {
	  nm: "frame",
	  fr: 60,
	  id: "m2czqsy8jrzqk00c",
	  layers: [{
	    ty: 3,
	    ddd: 0,
	    ind: 14,
	    hd: false,
	    nm: "send/1 - Null",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [0, 0]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 138.12,
	    st: 0,
	    bm: 0
	  }, {
	    ty: 3,
	    ddd: 0,
	    ind: 15,
	    hd: false,
	    nm: "frame - Null",
	    sr: 1,
	    parent: 14,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 1,
	        k: [{
	          t: 24.12,
	          s: [0, 7],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [1],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 54.120000000000005,
	          s: [2, 7]
	        }]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 138.12,
	    st: 0,
	    bm: 0
	  }, {
	    ty: 3,
	    ddd: 0,
	    ind: 9,
	    hd: false,
	    nm: "fill - Null",
	    sr: 1,
	    parent: 15,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 1,
	        k: [{
	          t: 0.06,
	          s: [0.5, 1],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [1],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 24.060000000000002,
	          s: [1, 1],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [1],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 24.12,
	          s: [1, 1],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [1],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 54.120000000000005,
	          s: [17.25, 1]
	        }]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 138.12,
	    st: 0,
	    bm: 0
	  }, {
	    ty: 4,
	    ddd: 0,
	    ind: 10,
	    hd: false,
	    nm: "fill",
	    sr: 1,
	    parent: 9,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      p: {
	        a: 0,
	        k: [0, 0]
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      o: {
	        a: 0,
	        k: 100
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 138.12,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      nm: "Group",
	      hd: false,
	      np: 3,
	      it: [{
	        ty: "sh",
	        nm: "Path",
	        hd: false,
	        ks: {
	          a: 1,
	          k: [{
	            t: 0.06,
	            s: [{
	              c: true,
	              v: [[1.75, 0], [1.75, 0], [3.5, 1.75], [3.5, 1.75], [1.75, 3.5], [1.75, 3.5], [0, 1.75], [0, 1.75], [1.75, 0], [1.75, 0]],
	              i: [[0, 0], [0, 0], [0, -0.9665], [0, 0], [0.9665, 0], [0, 0], [0, 0.9665], [0, 0], [-0.9665, 0], [0, 0]],
	              o: [[0, 0], [0.9664999999999999, 0], [0, 0], [0, 0.9664999999999999], [0, 0], [-0.9665, 0], [0, 0], [0, -0.9665], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 24.060000000000002,
	            s: [{
	              c: true,
	              v: [[1.5, 0], [13.5, 0], [15, 1.5], [15, 1.5], [13.5, 3], [1.5, 3], [0, 1.5], [0, 1.5], [1.5, 0], [1.5, 0]],
	              i: [[0, 0], [0, 0], [0, -0.8284], [0, 0], [0.8284, 0], [0, 0], [0, 0.8284], [0, 0], [-0.8284, 0], [0, 0]],
	              o: [[0, 0], [0.8284300000000009, 0], [0, 0], [0, 0.82843], [0, 0], [-0.82843, 0], [0, 0], [0, -0.82843], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 24.12,
	            s: [{
	              c: true,
	              v: [[1.5, 0], [13.5, 0], [15, 1.5], [15, 1.5], [13.5, 3], [1.5, 3], [0, 1.5], [0, 1.5], [1.5, 0], [1.5, 0]],
	              i: [[0, 0], [0, 0], [0, -0.8284], [0, 0], [0.8284, 0], [0, 0], [0, 0.8284], [0, 0], [-0.8284, 0], [0, 0]],
	              o: [[0, 0], [0.8284300000000009, 0], [0, 0], [0, 0.82843], [0, 0], [-0.82843, 0], [0, 0], [0, -0.82843], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 54.120000000000005,
	            s: [{
	              c: true,
	              v: [[1.75, 0], [1.75, 0], [3.5, 1.75], [3.5, 1.75], [1.75, 3.5], [1.75, 3.5], [0, 1.75], [0, 1.75], [1.75, 0], [1.75, 0]],
	              i: [[0, 0], [0, 0], [0, -0.9665], [0, 0], [0.9665, 0], [0, 0], [0, 0.9665], [0, 0], [-0.9665, 0], [0, 0]],
	              o: [[0, 0], [0.9664999999999999, 0], [0, 0], [0, 0.9664999999999999], [0, 0], [-0.9665, 0], [0, 0], [0, -0.9665], [0, 0], [0, 0]]
	            }]
	          }]
	        }
	      }, {
	        ty: "fl",
	        o: {
	          a: 0,
	          k: 100
	        },
	        c: {
	          a: 0,
	          k: [1, 1, 1, 1]
	        },
	        nm: "Fill",
	        hd: false,
	        r: 1
	      }, {
	        ty: "tr",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        o: {
	          a: 0,
	          k: 100
	        }
	      }]
	    }]
	  }]
	}, {
	  nm: "[FRAME] send/1 - Null / send/1 - Null / frame - Null / send/1 - Null / frame - Null / frame / frame / send/1 - Shape Mask / send/1",
	  fr: 60,
	  id: "m2czqsxwn53un534",
	  layers: [{
	    ty: 3,
	    ddd: 0,
	    ind: 11,
	    hd: false,
	    nm: "send/1 - Null",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [0, 0]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 138.12,
	    st: 0,
	    bm: 0
	  }, {
	    ty: 3,
	    ddd: 0,
	    ind: 12,
	    hd: false,
	    nm: "send/1 - Null",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [0, 0]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 138.12,
	    st: 0,
	    bm: 0
	  }, {
	    ty: 3,
	    ddd: 0,
	    ind: 13,
	    hd: false,
	    nm: "frame - Null",
	    sr: 1,
	    parent: 12,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 1,
	        k: [{
	          t: 24.12,
	          s: [0, 7],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [1],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 54.120000000000005,
	          s: [2, 7]
	        }]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 138.12,
	    st: 0,
	    bm: 0
	  }, {
	    ty: 3,
	    ddd: 0,
	    ind: 14,
	    hd: false,
	    nm: "send/1 - Null",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [0, 0]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 138.12,
	    st: 0,
	    bm: 0
	  }, {
	    ty: 3,
	    ddd: 0,
	    ind: 15,
	    hd: false,
	    nm: "frame - Null",
	    sr: 1,
	    parent: 14,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 1,
	        k: [{
	          t: 24.12,
	          s: [0, 7],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [1],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 54.120000000000005,
	          s: [2, 7]
	        }]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 138.12,
	    st: 0,
	    bm: 0
	  }, {
	    ddd: 0,
	    ind: 16,
	    ty: 0,
	    nm: "frame",
	    td: 1,
	    refId: "m2czp0x468684051",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      p: {
	        a: 0,
	        k: [0, 0]
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      o: {
	        a: 0,
	        k: 100
	      }
	    },
	    ao: 0,
	    w: 19,
	    h: 18,
	    ip: 0,
	    op: 138.12,
	    st: 0,
	    hd: false,
	    bm: 0
	  }, {
	    ddd: 0,
	    ind: 17,
	    ty: 0,
	    nm: "frame",
	    refId: "m2czqsy8jrzqk00c",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      p: {
	        a: 0,
	        k: [0, 0]
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      o: {
	        a: 0,
	        k: 100
	      }
	    },
	    ao: 0,
	    w: 19,
	    h: 18,
	    ip: 0,
	    op: 138.12,
	    st: 0,
	    hd: false,
	    bm: 0,
	    tt: 1
	  }, {
	    ty: 4,
	    ddd: 0,
	    ind: 18,
	    hd: false,
	    nm: "send/1 - Shape Mask",
	    sr: 1,
	    parent: 11,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      p: {
	        a: 0,
	        k: [0, 0]
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      o: {
	        a: 0,
	        k: 100
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 138.12,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      nm: "Group",
	      hd: false,
	      np: 3,
	      it: [{
	        ty: "sh",
	        nm: "Path",
	        hd: false,
	        ks: {
	          a: 0,
	          k: {
	            c: true,
	            v: [[9, 0], [10, 0], [19, 9], [19, 9], [10, 18], [9, 18], [0, 9], [0, 9], [9, 0], [9, 0]],
	            i: [[0, 0], [0, 0], [0, -4.9706], [0, 0], [4.9706, 0], [0, 0], [0, 4.9706], [0, 0], [-4.9706, 0], [0, 0]],
	            o: [[0, 0], [4.970559999999999, 0], [0, 0], [0, 4.970559999999999], [0, 0], [-4.97056, 0], [0, 0], [0, -4.97056], [0, 0], [0, 0]]
	          }
	        }
	      }, {
	        ty: "fl",
	        o: {
	          a: 0,
	          k: 100
	        },
	        c: {
	          a: 0,
	          k: [0, 1, 0, 1]
	        },
	        nm: "Fill",
	        hd: false,
	        r: 1
	      }, {
	        ty: "tr",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        o: {
	          a: 0,
	          k: 100
	        }
	      }]
	    }],
	    td: 1
	  }, {
	    ty: 2,
	    ddd: 0,
	    ind: 19,
	    hd: false,
	    nm: "send/1",
	    sr: 1,
	    parent: 11,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      p: {
	        a: 0,
	        k: [1.4921396702006693e-13, 0]
	      },
	      s: {
	        a: 0,
	        k: [1399.9999297292645, 1399.9999297292645]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      o: {
	        a: 0,
	        k: 100
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 138.12,
	    st: 0,
	    bm: 0,
	    refId: "ad33659c33381eac40061641b81f19d65a13ad9f",
	    tt: 1
	  }]
	}];
	var layers$1 = [{
	  ddd: 0,
	  ind: 1,
	  ty: 0,
	  nm: "send/1",
	  refId: "m2czqsxwn53un534",
	  sr: 1,
	  ks: {
	    a: {
	      a: 0,
	      k: [0, 0]
	    },
	    p: {
	      a: 0,
	      k: [0, 0]
	    },
	    s: {
	      a: 0,
	      k: [100, 100]
	    },
	    sk: {
	      a: 0,
	      k: 0
	    },
	    sa: {
	      a: 0,
	      k: 0
	    },
	    r: {
	      a: 0,
	      k: 0
	    },
	    o: {
	      a: 0,
	      k: 100
	    }
	  },
	  ao: 0,
	  w: 19,
	  h: 18,
	  ip: 0,
	  op: 138.12,
	  st: 0,
	  hd: false,
	  bm: 0
	}];
	var meta$1 = {
	  a: "",
	  d: "",
	  tc: "",
	  g: "Aninix"
	};
	var UploadingAnimation = {
	  fr: fr$1,
	  v: v$1,
	  ip: ip$1,
	  op: op$1,
	  w: w$1,
	  h: h$1,
	  nm: nm$1,
	  ddd: ddd$1,
	  markers: markers$1,
	  assets: assets$1,
	  layers: layers$1,
	  meta: meta$1
	};

	var fr$2 = 60;
	var v$2 = "5.9.6";
	var ip$2 = 0;
	var op$2 = 65.3;
	var w$2 = 18;
	var h$2 = 18;
	var nm$2 = "typing";
	var ddd$2 = 0;
	var markers$2 = [];
	var assets$2 = [{
	  nm: "[FRAME] typing - Null / Ellipse 3 - Null / Ellipse 3 / Ellipse 2 - Null / Ellipse 2 / Ellipse 1 - Null / Ellipse 1",
	  fr: 60,
	  id: "m2czolqy5p73gm5l",
	  layers: [{
	    ty: 3,
	    ddd: 0,
	    ind: 4,
	    hd: false,
	    nm: "typing - Null",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [0, 0]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 66.3,
	    st: 0,
	    bm: 0
	  }, {
	    ty: 3,
	    ddd: 0,
	    ind: 5,
	    hd: false,
	    nm: "Ellipse 3 - Null",
	    sr: 1,
	    parent: 4,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 1,
	        k: [{
	          t: 0.06,
	          s: [13.0745, 7],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 8.459999999999999,
	          s: [13.0745, 8.1111],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 8.52,
	          s: [13.07, 8.11],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 16.919999999999998,
	          s: [13.0745, 8.1111],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 16.979999999999997,
	          s: [13.07, 8.11],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 25.38,
	          s: [13.0745, 5],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 25.439999999999998,
	          s: [13.07, 5],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 33.839999999999996,
	          s: [13.0742, 7.8008],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 33.9,
	          s: [13.07, 7.8],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 42.3,
	          s: [13.0745, 7],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [1],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 48.300000000000004,
	          s: [13.07, 7],
	          o: {
	            x: [0.42],
	            y: [-0.2]
	          },
	          i: {
	            x: [1],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 66.3,
	          s: [13.0745, 7]
	        }]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 66.3,
	    st: 0,
	    bm: 0
	  }, {
	    ty: 4,
	    ddd: 0,
	    ind: 6,
	    hd: false,
	    nm: "Ellipse 3",
	    sr: 1,
	    parent: 5,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      p: {
	        a: 0,
	        k: [0, 0]
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      o: {
	        a: 0,
	        k: 100
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 66.3,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      nm: "Group",
	      hd: false,
	      np: 3,
	      it: [{
	        ty: "sh",
	        nm: "Path",
	        hd: false,
	        ks: {
	          a: 1,
	          k: [{
	            t: 0.06,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8341], [1.8, 3.6682], [0, 1.8341], [1.8, 0], [3.6, 1.8341], [3.6, 1.8341]],
	              i: [[0, 0], [0.9941, 0], [0, 1.013], [-0.9941, 0], [0, -1.013], [0, 0]],
	              o: [[0, 1.0130000000000001], [-0.9941, 0], [0, -1.013], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 1.062,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8244], [1.8, 3.6488], [0, 1.8244], [1.8, 0], [3.6, 1.8244], [3.6, 1.8244]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0076], [-0.9941, 0], [0, -1.0076], [0, 0]],
	              o: [[0, 1.0075999999999998], [-0.9941, 0], [0, -1.0076], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 2.058,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8157], [1.8, 3.6314], [0, 1.8157], [1.8, 0], [3.6, 1.8157], [3.6, 1.8157]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0028], [-0.9941, 0], [0, -1.0028], [0, 0]],
	              o: [[0, 1.0028000000000001], [-0.9941, 0], [0, -1.0028], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 3.0599999999999996,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8077], [1.8, 3.6154], [0, 1.8077], [1.8, 0], [3.6, 1.8077], [3.6, 1.8077]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9984], [-0.9941, 0], [0, -0.9984], [0, 0]],
	              o: [[0, 0.9983999999999997], [-0.9941, 0], [0, -0.9984], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 4.061999999999999,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8006], [1.8, 3.6012], [0, 1.8006], [1.8, 0.0001], [3.6, 1.8006], [3.6, 1.8006]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9944], [-0.9941, 0], [0, -0.9944], [0, 0]],
	              o: [[0, 0.9944], [-0.9941, 0], [0, -0.9944], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 5.058,
	            s: [{
	              c: true,
	              v: [[3.6, 1.7944], [1.8, 3.5888], [0, 1.7944], [1.8, 0.0001], [3.6, 1.7944], [3.6, 1.7944]],
	              i: [[0, 0], [0.9941, 0], [0, 0.991], [-0.9941, 0], [0, -0.991], [0, 0]],
	              o: [[0, 0.9910000000000001], [-0.9941, 0], [0, -0.991], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 6.0600000000000005,
	            s: [{
	              c: true,
	              v: [[3.6, 1.7892], [1.8, 3.5784], [0, 1.7892], [1.8, 0], [3.6, 1.7892], [3.6, 1.7892]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9882], [-0.9941, 0], [0, -0.9882], [0, 0]],
	              o: [[0, 0.9882000000000002], [-0.9941, 0], [0, -0.9882], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 7.062,
	            s: [{
	              c: true,
	              v: [[3.6, 1.7854], [1.8, 3.5708], [0, 1.7854], [1.8, 0], [3.6, 1.7854], [3.6, 1.7854]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9861], [-0.9941, 0], [0, -0.9861], [0, 0]],
	              o: [[0, 0.9861], [-0.9941, 0], [0, -0.9861], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 8.058,
	            s: [{
	              c: true,
	              v: [[3.6, 1.7834], [1.8, 3.5668], [0, 1.7834], [1.8, 0.0001], [3.6, 1.7834], [3.6, 1.7834]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9849], [-0.9941, 0], [0, -0.9849], [0, 0]],
	              o: [[0, 0.9848999999999999], [-0.9941, 0], [0, -0.9849], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 8.459999999999999,
	            s: [{
	              c: true,
	              v: [[3.6, 1.7832], [1.8, 3.5664], [0, 1.7832], [1.8, 0.0001], [3.6, 1.7832], [3.6, 1.7832]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9848], [-0.9941, 0], [0, -0.9848], [0, 0]],
	              o: [[0, 0.9847999999999999], [-0.9941, 0], [0, -0.9848], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 9.462,
	            s: [{
	              c: true,
	              v: [[3.6, 1.7832], [1.8, 3.5664], [0, 1.7832], [1.8, 0.0001], [3.6, 1.7832], [3.6, 1.7832]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9848], [-0.9941, 0], [0, -0.9848], [0, 0]],
	              o: [[0, 0.9847999999999999], [-0.9941, 0], [0, -0.9848], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 10.458,
	            s: [{
	              c: true,
	              v: [[3.6, 1.7832], [1.8, 3.5664], [0, 1.7832], [1.8, 0.0001], [3.6, 1.7832], [3.6, 1.7832]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9848], [-0.9941, 0], [0, -0.9848], [0, 0]],
	              o: [[0, 0.9847999999999999], [-0.9941, 0], [0, -0.9848], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 11.46,
	            s: [{
	              c: true,
	              v: [[3.6, 1.7832], [1.8, 3.5664], [0, 1.7832], [1.8, 0.0001], [3.6, 1.7832], [3.6, 1.7832]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9848], [-0.9941, 0], [0, -0.9848], [0, 0]],
	              o: [[0, 0.9847999999999999], [-0.9941, 0], [0, -0.9848], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 12.462,
	            s: [{
	              c: true,
	              v: [[3.6, 1.7832], [1.8, 3.5664], [0, 1.7832], [1.8, 0.0001], [3.6, 1.7832], [3.6, 1.7832]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9848], [-0.9941, 0], [0, -0.9848], [0, 0]],
	              o: [[0, 0.9847999999999999], [-0.9941, 0], [0, -0.9848], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 13.458,
	            s: [{
	              c: true,
	              v: [[3.6, 1.7832], [1.8, 3.5664], [0, 1.7832], [1.8, 0.0001], [3.6, 1.7832], [3.6, 1.7832]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9848], [-0.9941, 0], [0, -0.9848], [0, 0]],
	              o: [[0, 0.9847999999999999], [-0.9941, 0], [0, -0.9848], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 14.459999999999999,
	            s: [{
	              c: true,
	              v: [[3.6, 1.7832], [1.8, 3.5664], [0, 1.7832], [1.8, 0.0001], [3.6, 1.7832], [3.6, 1.7832]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9848], [-0.9941, 0], [0, -0.9848], [0, 0]],
	              o: [[0, 0.9847999999999999], [-0.9941, 0], [0, -0.9848], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 15.462,
	            s: [{
	              c: true,
	              v: [[3.6, 1.7832], [1.8, 3.5664], [0, 1.7832], [1.8, 0.0001], [3.6, 1.7832], [3.6, 1.7832]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9848], [-0.9941, 0], [0, -0.9848], [0, 0]],
	              o: [[0, 0.9847999999999999], [-0.9941, 0], [0, -0.9848], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 16.458,
	            s: [{
	              c: true,
	              v: [[3.6, 1.7832], [1.8, 3.5664], [0, 1.7832], [1.8, 0.0001], [3.6, 1.7832], [3.6, 1.7832]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9848], [-0.9941, 0], [0, -0.9848], [0, 0]],
	              o: [[0, 0.9847999999999999], [-0.9941, 0], [0, -0.9848], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 16.979999999999997,
	            s: [{
	              c: true,
	              v: [[3.6, 1.7832], [1.8, 3.5664], [0, 1.7832], [1.8, 0.0001], [3.6, 1.7832], [3.6, 1.7832]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9848], [-0.9941, 0], [0, -0.9848], [0, 0]],
	              o: [[0, 0.9847999999999999], [-0.9941, 0], [0, -0.9848], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 17.982000000000003,
	            s: [{
	              c: true,
	              v: [[3.6, 1.951], [1.8, 3.902], [0, 1.951], [1.8, 0], [3.6, 1.951], [3.6, 1.951]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0775], [-0.9941, 0], [0, -1.0775], [0, 0]],
	              o: [[0, 1.0775000000000001], [-0.9941, 0], [0, -1.0775], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 18.978,
	            s: [{
	              c: true,
	              v: [[3.6, 2.1025], [1.8, 4.205], [0, 2.1025], [1.8, 0], [3.6, 2.1025], [3.6, 2.1025]],
	              i: [[0, 0], [0.9941, 0], [0, 1.1612], [-0.9941, 0], [0, -1.1612], [0, 0]],
	              o: [[0, 1.1612], [-0.9941, 0], [0, -1.1612], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 19.98,
	            s: [{
	              c: true,
	              v: [[3.6, 2.2412], [1.8, 4.4824], [0, 2.2412], [1.8, 0], [3.6, 2.2412], [3.6, 2.2412]],
	              i: [[0, 0], [0.9941, 0], [0, 1.2378], [-0.9941, 0], [0, -1.2378], [0, 0]],
	              o: [[0, 1.2378], [-0.9941, 0], [0, -1.2378], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 20.982,
	            s: [{
	              c: true,
	              v: [[3.6, 2.3654], [1.8, 4.7308], [0, 2.3654], [1.8, 0.0001], [3.6, 2.3654], [3.6, 2.3654]],
	              i: [[0, 0], [0.9941, 0], [0, 1.3064], [-0.9941, 0], [0, -1.3064], [0, 0]],
	              o: [[0, 1.3064], [-0.9941, 0], [0, -1.3064], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 21.978,
	            s: [{
	              c: true,
	              v: [[3.6, 2.4727], [1.8, 4.9454], [0, 2.4727], [1.8, 0], [3.6, 2.4727], [3.6, 2.4727]],
	              i: [[0, 0], [0.9941, 0], [0, 1.3657], [-0.9941, 0], [0, -1.3657], [0, 0]],
	              o: [[0, 1.3657], [-0.9941, 0], [0, -1.3657], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 22.98,
	            s: [{
	              c: true,
	              v: [[3.6, 2.5617], [1.8, 5.1234], [0, 2.5617], [1.8, 0], [3.6, 2.5617], [3.6, 2.5617]],
	              i: [[0, 0], [0.9941, 0], [0, 1.4148], [-0.9941, 0], [0, -1.4148], [0, 0]],
	              o: [[0, 1.4148], [-0.9941, 0], [0, -1.4148], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 23.982,
	            s: [{
	              c: true,
	              v: [[3.6, 2.6275], [1.8, 5.255], [0, 2.6275], [1.8, 0.0001], [3.6, 2.6275], [3.6, 2.6275]],
	              i: [[0, 0], [0.9941, 0], [0, 1.4511], [-0.9941, 0], [0, -1.4511], [0, 0]],
	              o: [[0, 1.4510999999999998], [-0.9941, 0], [0, -1.4511], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 24.978,
	            s: [{
	              c: true,
	              v: [[3.6, 2.663], [1.8, 5.326], [0, 2.663], [1.8, 0], [3.6, 2.663], [3.6, 2.663]],
	              i: [[0, 0], [0.9941, 0], [0, 1.4708], [-0.9941, 0], [0, -1.4708], [0, 0]],
	              o: [[0, 1.4708], [-0.9941, 0], [0, -1.4708], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 25.38,
	            s: [{
	              c: true,
	              v: [[3.6, 2.6667], [1.8, 5.3334], [0, 2.6667], [1.8, 0], [3.6, 2.6667], [3.6, 2.6667]],
	              i: [[0, 0], [0.9941, 0], [0, 1.4728], [-0.9941, 0], [0, -1.4728], [0, 0]],
	              o: [[0, 1.4727999999999999], [-0.9941, 0], [0, -1.4728], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 25.439999999999998,
	            s: [{
	              c: true,
	              v: [[3.6, 2.6667], [1.8, 5.3334], [0, 2.6667], [1.8, 0], [3.6, 2.6667], [3.6, 2.6667]],
	              i: [[0, 0], [0.9941, 0], [0, 1.4728], [-0.9941, 0], [0, -1.4728], [0, 0]],
	              o: [[0, 1.4727999999999999], [-0.9941, 0], [0, -1.4728], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 26.442,
	            s: [{
	              c: true,
	              v: [[3.6, 2.4641], [1.8, 4.9282], [0, 2.4641], [1.8, 0.0001], [3.6, 2.4641], [3.6, 2.4641]],
	              i: [[0, 0], [0.9941, 0], [0, 1.3609], [-0.9941, 0], [0, -1.3609], [0, 0]],
	              o: [[0, 1.3609], [-0.9941, 0], [0, -1.3609], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 27.438,
	            s: [{
	              c: true,
	              v: [[3.6, 2.2811], [1.8, 4.5622], [0, 2.2811], [1.8, 0], [3.6, 2.2811], [3.6, 2.2811]],
	              i: [[0, 0], [0.9941, 0], [0, 1.2599], [-0.9941, 0], [0, -1.2599], [0, 0]],
	              o: [[0, 1.2599], [-0.9941, 0], [0, -1.2599], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 28.439999999999998,
	            s: [{
	              c: true,
	              v: [[3.6, 2.1137], [1.8, 4.2274], [0, 2.1137], [1.8, 0], [3.6, 2.1137], [3.6, 2.1137]],
	              i: [[0, 0], [0.9941, 0], [0, 1.1674], [-0.9941, 0], [0, -1.1674], [0, 0]],
	              o: [[0, 1.1674000000000002], [-0.9941, 0], [0, -1.1674], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 29.442,
	            s: [{
	              c: true,
	              v: [[3.6, 1.9638], [1.8, 3.9276], [0, 1.9638], [1.8, 0.0001], [3.6, 1.9638], [3.6, 1.9638]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0846], [-0.9941, 0], [0, -1.0846], [0, 0]],
	              o: [[0, 1.0846], [-0.9941, 0], [0, -1.0846], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 30.438,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8342], [1.8, 3.6684], [0, 1.8342], [1.8, 0], [3.6, 1.8342], [3.6, 1.8342]],
	              i: [[0, 0], [0.9941, 0], [0, 1.013], [-0.9941, 0], [0, -1.013], [0, 0]],
	              o: [[0, 1.013], [-0.9941, 0], [0, -1.013], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 31.44,
	            s: [{
	              c: true,
	              v: [[3.6, 1.7267], [1.8, 3.4534], [0, 1.7267], [1.8, 0], [3.6, 1.7267], [3.6, 1.7267]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9537], [-0.9941, 0], [0, -0.9537], [0, 0]],
	              o: [[0, 0.9536999999999998], [-0.9941, 0], [0, -0.9537], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 32.442,
	            s: [{
	              c: true,
	              v: [[3.6, 1.6474], [1.8, 3.2948], [0, 1.6474], [1.8, 0.0001], [3.6, 1.6474], [3.6, 1.6474]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9098], [-0.9941, 0], [0, -0.9098], [0, 0]],
	              o: [[0, 0.9097999999999999], [-0.9941, 0], [0, -0.9098], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 33.438,
	            s: [{
	              c: true,
	              v: [[3.6, 1.6044], [1.8, 3.2088], [0, 1.6044], [1.8, 0], [3.6, 1.6044], [3.6, 1.6044]],
	              i: [[0, 0], [0.9941, 0], [0, 0.8861], [-0.9941, 0], [0, -0.8861], [0, 0]],
	              o: [[0, 0.8860999999999999], [-0.9941, 0], [0, -0.8861], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 33.839999999999996,
	            s: [{
	              c: true,
	              v: [[3.6, 1.6], [1.8, 3.2], [0, 1.6], [1.8, 0], [3.6, 1.6], [3.6, 1.6]],
	              i: [[0, 0], [0.9941, 0], [0, 0.8837], [-0.9941, 0], [0, -0.8837], [0, 0]],
	              o: [[0, 0.8837000000000002], [-0.9941, 0], [0, -0.8837], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 33.9,
	            s: [{
	              c: true,
	              v: [[3.6, 1.6], [1.8, 3.2], [0, 1.6], [1.8, 0], [3.6, 1.6], [3.6, 1.6]],
	              i: [[0, 0], [0.9941, 0], [0, 0.8837], [-0.9941, 0], [0, -0.8837], [0, 0]],
	              o: [[0, 0.8837000000000002], [-0.9941, 0], [0, -0.8837], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 34.902,
	            s: [{
	              c: true,
	              v: [[3.6, 1.6445], [1.8, 3.289], [0, 1.6445], [1.8, 0.0001], [3.6, 1.6445], [3.6, 1.6445]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9082], [-0.9941, 0], [0, -0.9082], [0, 0]],
	              o: [[0, 0.9082000000000001], [-0.9941, 0], [0, -0.9082], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 35.898,
	            s: [{
	              c: true,
	              v: [[3.6, 1.6846], [1.8, 3.3692], [0, 1.6846], [1.8, 0], [3.6, 1.6846], [3.6, 1.6846]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9304], [-0.9941, 0], [0, -0.9304], [0, 0]],
	              o: [[0, 0.9304000000000001], [-0.9941, 0], [0, -0.9304], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 36.9,
	            s: [{
	              c: true,
	              v: [[3.6, 1.7214], [1.8, 3.4428], [0, 1.7214], [1.8, 0.0001], [3.6, 1.7214], [3.6, 1.7214]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9507], [-0.9941, 0], [0, -0.9507], [0, 0]],
	              o: [[0, 0.9506999999999999], [-0.9941, 0], [0, -0.9507], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 37.902,
	            s: [{
	              c: true,
	              v: [[3.6, 1.7543], [1.8, 3.5086], [0, 1.7543], [1.8, 0.0001], [3.6, 1.7543], [3.6, 1.7543]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9689], [-0.9941, 0], [0, -0.9689], [0, 0]],
	              o: [[0, 0.9688999999999999], [-0.9941, 0], [0, -0.9689], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 38.897999999999996,
	            s: [{
	              c: true,
	              v: [[3.6, 1.7827], [1.8, 3.5654], [0, 1.7827], [1.8, 0], [3.6, 1.7827], [3.6, 1.7827]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9846], [-0.9941, 0], [0, -0.9846], [0, 0]],
	              o: [[0, 0.9846000000000001], [-0.9941, 0], [0, -0.9846], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 39.900000000000006,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8063], [1.8, 3.6126], [0, 1.8063], [1.8, 0], [3.6, 1.8063], [3.6, 1.8063]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9976], [-0.9941, 0], [0, -0.9976], [0, 0]],
	              o: [[0, 0.9976], [-0.9941, 0], [0, -0.9976], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 40.902,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8237], [1.8, 3.6474], [0, 1.8237], [1.8, 0], [3.6, 1.8237], [3.6, 1.8237]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0072], [-0.9941, 0], [0, -1.0072], [0, 0]],
	              o: [[0, 1.0072], [-0.9941, 0], [0, -1.0072], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 41.898,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8332], [1.8, 3.6664], [0, 1.8332], [1.8, 0.0001], [3.6, 1.8332], [3.6, 1.8332]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0124], [-0.9941, 0], [0, -1.0124], [0, 0]],
	              o: [[0, 1.0124000000000002], [-0.9941, 0], [0, -1.0124], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 42.3,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8341], [1.8, 3.6682], [0, 1.8341], [1.8, 0], [3.6, 1.8341], [3.6, 1.8341]],
	              i: [[0, 0], [0.9941, 0], [0, 1.013], [-0.9941, 0], [0, -1.013], [0, 0]],
	              o: [[0, 1.0130000000000001], [-0.9941, 0], [0, -1.013], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }]
	          }]
	        }
	      }, {
	        ty: "fl",
	        o: {
	          a: 0,
	          k: 100
	        },
	        c: {
	          a: 0,
	          k: [1, 1, 1, 1]
	        },
	        nm: "Fill",
	        hd: false,
	        r: 1
	      }, {
	        ty: "tr",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        o: {
	          a: 0,
	          k: 100
	        }
	      }]
	    }]
	  }, {
	    ty: 3,
	    ddd: 0,
	    ind: 7,
	    hd: false,
	    nm: "Ellipse 2 - Null",
	    sr: 1,
	    parent: 4,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 1,
	        k: [{
	          t: 0.06,
	          s: [6.5371, 7],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 8.459999999999999,
	          s: [6.5371, 8.1111],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 8.52,
	          s: [6.54, 8.11],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 16.919999999999998,
	          s: [6.5371, 5],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 16.979999999999997,
	          s: [6.54, 5],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 25.38,
	          s: [6.5371, 9.4453],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 25.439999999999998,
	          s: [6.54, 9.45],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 33.839999999999996,
	          s: [6.5371, 7],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 33.9,
	          s: [6.54, 7],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 42.3,
	          s: [6.5371, 7],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [1],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 48.300000000000004,
	          s: [6.54, 7],
	          o: {
	            x: [0.42],
	            y: [-0.2]
	          },
	          i: {
	            x: [1],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 66.3,
	          s: [6.5371, 7]
	        }]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 66.3,
	    st: 0,
	    bm: 0
	  }, {
	    ty: 4,
	    ddd: 0,
	    ind: 8,
	    hd: false,
	    nm: "Ellipse 2",
	    sr: 1,
	    parent: 7,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      p: {
	        a: 0,
	        k: [0, 0]
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      o: {
	        a: 0,
	        k: 100
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 66.3,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      nm: "Group",
	      hd: false,
	      np: 3,
	      it: [{
	        ty: "sh",
	        nm: "Path",
	        hd: false,
	        ks: {
	          a: 1,
	          k: [{
	            t: 0.06,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8341], [1.8, 3.6682], [0, 1.8341], [1.8, 0], [3.6, 1.8341], [3.6, 1.8341]],
	              i: [[0, 0], [0.9941, 0], [0, 1.013], [-0.9941, 0], [0, -1.013], [0, 0]],
	              o: [[0, 1.0130000000000001], [-0.9941, 0], [0, -1.013], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 1.062,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8244], [1.8, 3.6488], [0, 1.8244], [1.8, 0], [3.6, 1.8244], [3.6, 1.8244]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0076], [-0.9941, 0], [0, -1.0076], [0, 0]],
	              o: [[0, 1.0075999999999998], [-0.9941, 0], [0, -1.0076], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 2.058,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8157], [1.8, 3.6314], [0, 1.8157], [1.8, 0], [3.6, 1.8157], [3.6, 1.8157]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0028], [-0.9941, 0], [0, -1.0028], [0, 0]],
	              o: [[0, 1.0028000000000001], [-0.9941, 0], [0, -1.0028], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 3.0599999999999996,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8077], [1.8, 3.6154], [0, 1.8077], [1.8, 0], [3.6, 1.8077], [3.6, 1.8077]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9984], [-0.9941, 0], [0, -0.9984], [0, 0]],
	              o: [[0, 0.9983999999999997], [-0.9941, 0], [0, -0.9984], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 4.061999999999999,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8006], [1.8, 3.6012], [0, 1.8006], [1.8, 0.0001], [3.6, 1.8006], [3.6, 1.8006]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9944], [-0.9941, 0], [0, -0.9944], [0, 0]],
	              o: [[0, 0.9944], [-0.9941, 0], [0, -0.9944], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 5.058,
	            s: [{
	              c: true,
	              v: [[3.6, 1.7944], [1.8, 3.5888], [0, 1.7944], [1.8, 0.0001], [3.6, 1.7944], [3.6, 1.7944]],
	              i: [[0, 0], [0.9941, 0], [0, 0.991], [-0.9941, 0], [0, -0.991], [0, 0]],
	              o: [[0, 0.9910000000000001], [-0.9941, 0], [0, -0.991], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 6.0600000000000005,
	            s: [{
	              c: true,
	              v: [[3.6, 1.7892], [1.8, 3.5784], [0, 1.7892], [1.8, 0], [3.6, 1.7892], [3.6, 1.7892]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9882], [-0.9941, 0], [0, -0.9882], [0, 0]],
	              o: [[0, 0.9882000000000002], [-0.9941, 0], [0, -0.9882], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 7.062,
	            s: [{
	              c: true,
	              v: [[3.6, 1.7854], [1.8, 3.5708], [0, 1.7854], [1.8, 0], [3.6, 1.7854], [3.6, 1.7854]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9861], [-0.9941, 0], [0, -0.9861], [0, 0]],
	              o: [[0, 0.9861], [-0.9941, 0], [0, -0.9861], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 8.058,
	            s: [{
	              c: true,
	              v: [[3.6, 1.7834], [1.8, 3.5668], [0, 1.7834], [1.8, 0.0001], [3.6, 1.7834], [3.6, 1.7834]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9849], [-0.9941, 0], [0, -0.9849], [0, 0]],
	              o: [[0, 0.9848999999999999], [-0.9941, 0], [0, -0.9849], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 8.459999999999999,
	            s: [{
	              c: true,
	              v: [[3.6, 1.7832], [1.8, 3.5664], [0, 1.7832], [1.8, 0.0001], [3.6, 1.7832], [3.6, 1.7832]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9848], [-0.9941, 0], [0, -0.9848], [0, 0]],
	              o: [[0, 0.9847999999999999], [-0.9941, 0], [0, -0.9848], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 8.52,
	            s: [{
	              c: true,
	              v: [[3.6, 1.7832], [1.8, 3.5664], [0, 1.7832], [1.8, 0.0001], [3.6, 1.7832], [3.6, 1.7832]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9848], [-0.9941, 0], [0, -0.9848], [0, 0]],
	              o: [[0, 0.9847999999999999], [-0.9941, 0], [0, -0.9848], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 9.522,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8877], [1.8, 3.7754], [0, 1.8877], [1.8, 0.0001], [3.6, 1.8877], [3.6, 1.8877]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0425], [-0.9941, 0], [0, -1.0425], [0, 0]],
	              o: [[0, 1.0425000000000002], [-0.9941, 0], [0, -1.0425], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 10.518,
	            s: [{
	              c: true,
	              v: [[3.6, 1.982], [1.8, 3.964], [0, 1.982], [1.8, 0], [3.6, 1.982], [3.6, 1.982]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0947], [-0.9941, 0], [0, -1.0947], [0, 0]],
	              o: [[0, 1.0946999999999998], [-0.9941, 0], [0, -1.0947], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 11.52,
	            s: [{
	              c: true,
	              v: [[3.6, 2.0684], [1.8, 4.1368], [0, 2.0684], [1.8, 0], [3.6, 2.0684], [3.6, 2.0684]],
	              i: [[0, 0], [0.9941, 0], [0, 1.1424], [-0.9941, 0], [0, -1.1424], [0, 0]],
	              o: [[0, 1.1423999999999999], [-0.9941, 0], [0, -1.1424], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 12.522,
	            s: [{
	              c: true,
	              v: [[3.6, 2.1457], [1.8, 4.2914], [0, 2.1457], [1.8, 0], [3.6, 2.1457], [3.6, 2.1457]],
	              i: [[0, 0], [0.9941, 0], [0, 1.1851], [-0.9941, 0], [0, -1.1851], [0, 0]],
	              o: [[0, 1.1850999999999998], [-0.9941, 0], [0, -1.1851], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 13.518,
	            s: [{
	              c: true,
	              v: [[3.6, 2.2125], [1.8, 4.425], [0, 2.2125], [1.8, 0], [3.6, 2.2125], [3.6, 2.2125]],
	              i: [[0, 0], [0.9941, 0], [0, 1.222], [-0.9941, 0], [0, -1.222], [0, 0]],
	              o: [[0, 1.222], [-0.9941, 0], [0, -1.222], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 14.52,
	            s: [{
	              c: true,
	              v: [[3.6, 2.268], [1.8, 4.536], [0, 2.268], [1.8, 0], [3.6, 2.268], [3.6, 2.268]],
	              i: [[0, 0], [0.9941, 0], [0, 1.2526], [-0.9941, 0], [0, -1.2526], [0, 0]],
	              o: [[0, 1.2526000000000002], [-0.9941, 0], [0, -1.2526], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 15.521999999999998,
	            s: [{
	              c: true,
	              v: [[3.6, 2.309], [1.8, 4.618], [0, 2.309], [1.8, 0.0001], [3.6, 2.309], [3.6, 2.309]],
	              i: [[0, 0], [0.9941, 0], [0, 1.2752], [-0.9941, 0], [0, -1.2752], [0, 0]],
	              o: [[0, 1.2752], [-0.9941, 0], [0, -1.2752], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 16.518,
	            s: [{
	              c: true,
	              v: [[3.6, 2.3311], [1.8, 4.6622], [0, 2.3311], [1.8, 0], [3.6, 2.3311], [3.6, 2.3311]],
	              i: [[0, 0], [0.9941, 0], [0, 1.2875], [-0.9941, 0], [0, -1.2875], [0, 0]],
	              o: [[0, 1.2875], [-0.9941, 0], [0, -1.2875], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 16.919999999999998,
	            s: [{
	              c: true,
	              v: [[3.6, 2.3333], [1.8, 4.6666], [0, 2.3333], [1.8, 0], [3.6, 2.3333], [3.6, 2.3333]],
	              i: [[0, 0], [0.9941, 0], [0, 1.2887], [-0.9941, 0], [0, -1.2887], [0, 0]],
	              o: [[0, 1.2887], [-0.9941, 0], [0, -1.2887], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 16.979999999999997,
	            s: [{
	              c: true,
	              v: [[3.6, 2.3333], [1.8, 4.6666], [0, 2.3333], [1.8, 0], [3.6, 2.3333], [3.6, 2.3333]],
	              i: [[0, 0], [0.9941, 0], [0, 1.2887], [-0.9941, 0], [0, -1.2887], [0, 0]],
	              o: [[0, 1.2887], [-0.9941, 0], [0, -1.2887], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 17.982000000000003,
	            s: [{
	              c: true,
	              v: [[3.6, 2.2278], [1.8, 4.4556], [0, 2.2278], [1.8, 0], [3.6, 2.2278], [3.6, 2.2278]],
	              i: [[0, 0], [0.9941, 0], [0, 1.2304], [-0.9941, 0], [0, -1.2304], [0, 0]],
	              o: [[0, 1.2304], [-0.9941, 0], [0, -1.2304], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 18.978,
	            s: [{
	              c: true,
	              v: [[3.6, 2.1326], [1.8, 4.2652], [0, 2.1326], [1.8, 0.0001], [3.6, 2.1326], [3.6, 2.1326]],
	              i: [[0, 0], [0.9941, 0], [0, 1.1778], [-0.9941, 0], [0, -1.1778], [0, 0]],
	              o: [[0, 1.1778], [-0.9941, 0], [0, -1.1778], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 19.98,
	            s: [{
	              c: true,
	              v: [[3.6, 2.0454], [1.8, 4.0908], [0, 2.0454], [1.8, 0.0001], [3.6, 2.0454], [3.6, 2.0454]],
	              i: [[0, 0], [0.9941, 0], [0, 1.1296], [-0.9941, 0], [0, -1.1296], [0, 0]],
	              o: [[0, 1.1296], [-0.9941, 0], [0, -1.1296], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 20.982,
	            s: [{
	              c: true,
	              v: [[3.6, 1.9673], [1.8, 3.9346], [0, 1.9673], [1.8, 0.0001], [3.6, 1.9673], [3.6, 1.9673]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0865], [-0.9941, 0], [0, -1.0865], [0, 0]],
	              o: [[0, 1.0864999999999998], [-0.9941, 0], [0, -1.0865], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 21.978,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8998], [1.8, 3.7996], [0, 1.8998], [1.8, 0.0001], [3.6, 1.8998], [3.6, 1.8998]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0492], [-0.9941, 0], [0, -1.0492], [0, 0]],
	              o: [[0, 1.0492], [-0.9941, 0], [0, -1.0492], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 22.98,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8438], [1.8, 3.6876], [0, 1.8438], [1.8, 0], [3.6, 1.8438], [3.6, 1.8438]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0183], [-0.9941, 0], [0, -1.0183], [0, 0]],
	              o: [[0, 1.0182999999999998], [-0.9941, 0], [0, -1.0183], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 23.982,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8025], [1.8, 3.605], [0, 1.8025], [1.8, 0.0001], [3.6, 1.8025], [3.6, 1.8025]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9955], [-0.9941, 0], [0, -0.9955], [0, 0]],
	              o: [[0, 0.9955], [-0.9941, 0], [0, -0.9955], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 24.978,
	            s: [{
	              c: true,
	              v: [[3.6, 1.7801], [1.8, 3.5602], [0, 1.7801], [1.8, 0], [3.6, 1.7801], [3.6, 1.7801]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9831], [-0.9941, 0], [0, -0.9831], [0, 0]],
	              o: [[0, 0.9830999999999999], [-0.9941, 0], [0, -0.9831], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 25.38,
	            s: [{
	              c: true,
	              v: [[3.6, 1.7778], [1.8, 3.5556], [0, 1.7778], [1.8, 0], [3.6, 1.7778], [3.6, 1.7778]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9819], [-0.9941, 0], [0, -0.9819], [0, 0]],
	              o: [[0, 0.9819], [-0.9941, 0], [0, -0.9819], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 25.439999999999998,
	            s: [{
	              c: true,
	              v: [[3.6, 1.7778], [1.8, 3.5556], [0, 1.7778], [1.8, 0], [3.6, 1.7778], [3.6, 1.7778]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9819], [-0.9941, 0], [0, -0.9819], [0, 0]],
	              o: [[0, 0.9819], [-0.9941, 0], [0, -0.9819], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 26.442,
	            s: [{
	              c: true,
	              v: [[3.6, 1.82], [1.8, 3.64], [0, 1.82], [1.8, 0], [3.6, 1.82], [3.6, 1.82]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0052], [-0.9941, 0], [0, -1.0052], [0, 0]],
	              o: [[0, 1.0052], [-0.9941, 0], [0, -1.0052], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 27.438,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8581], [1.8, 3.7162], [0, 1.8581], [1.8, 0], [3.6, 1.8581], [3.6, 1.8581]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0262], [-0.9941, 0], [0, -1.0262], [0, 0]],
	              o: [[0, 1.0262], [-0.9941, 0], [0, -1.0262], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 28.439999999999998,
	            s: [{
	              c: true,
	              v: [[3.6, 1.893], [1.8, 3.786], [0, 1.893], [1.8, 0], [3.6, 1.893], [3.6, 1.893]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0455], [-0.9941, 0], [0, -1.0455], [0, 0]],
	              o: [[0, 1.0455000000000003], [-0.9941, 0], [0, -1.0455], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 29.442,
	            s: [{
	              c: true,
	              v: [[3.6, 1.9242], [1.8, 3.8484], [0, 1.9242], [1.8, 0], [3.6, 1.9242], [3.6, 1.9242]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0627], [-0.9941, 0], [0, -1.0627], [0, 0]],
	              o: [[0, 1.0627], [-0.9941, 0], [0, -1.0627], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 30.438,
	            s: [{
	              c: true,
	              v: [[3.6, 1.9512], [1.8, 3.9024], [0, 1.9512], [1.8, 0], [3.6, 1.9512], [3.6, 1.9512]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0776], [-0.9941, 0], [0, -1.0776], [0, 0]],
	              o: [[0, 1.0776], [-0.9941, 0], [0, -1.0776], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 31.44,
	            s: [{
	              c: true,
	              v: [[3.6, 1.9736], [1.8, 3.9472], [0, 1.9736], [1.8, 0], [3.6, 1.9736], [3.6, 1.9736]],
	              i: [[0, 0], [0.9941, 0], [0, 1.09], [-0.9941, 0], [0, -1.09], [0, 0]],
	              o: [[0, 1.09], [-0.9941, 0], [0, -1.09], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 32.442,
	            s: [{
	              c: true,
	              v: [[3.6, 1.9902], [1.8, 3.9804], [0, 1.9902], [1.8, 0.0001], [3.6, 1.9902], [3.6, 1.9902]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0992], [-0.9941, 0], [0, -1.0992], [0, 0]],
	              o: [[0, 1.0992], [-0.9941, 0], [0, -1.0992], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 33.438,
	            s: [{
	              c: true,
	              v: [[3.6, 1.9991], [1.8, 3.9982], [0, 1.9991], [1.8, 0], [3.6, 1.9991], [3.6, 1.9991]],
	              i: [[0, 0], [0.9941, 0], [0, 1.1041], [-0.9941, 0], [0, -1.1041], [0, 0]],
	              o: [[0, 1.1041], [-0.9941, 0], [0, -1.1041], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 33.839999999999996,
	            s: [{
	              c: true,
	              v: [[3.6, 2], [1.8, 4], [0, 2], [1.8, 0], [3.6, 2], [3.6, 2]],
	              i: [[0, 0], [0.9941, 0], [0, 1.1046], [-0.9941, 0], [0, -1.1046], [0, 0]],
	              o: [[0, 1.1046], [-0.9941, 0], [0, -1.1046], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 33.9,
	            s: [{
	              c: true,
	              v: [[3.6, 2], [1.8, 4], [0, 2], [1.8, 0], [3.6, 2], [3.6, 2]],
	              i: [[0, 0], [0.9941, 0], [0, 1.1046], [-0.9941, 0], [0, -1.1046], [0, 0]],
	              o: [[0, 1.1046], [-0.9941, 0], [0, -1.1046], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 34.902,
	            s: [{
	              c: true,
	              v: [[3.6, 1.9685], [1.8, 3.937], [0, 1.9685], [1.8, 0], [3.6, 1.9685], [3.6, 1.9685]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0872], [-0.9941, 0], [0, -1.0872], [0, 0]],
	              o: [[0, 1.0872], [-0.9941, 0], [0, -1.0872], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 35.898,
	            s: [{
	              c: true,
	              v: [[3.6, 1.9401], [1.8, 3.8802], [0, 1.9401], [1.8, 0.0001], [3.6, 1.9401], [3.6, 1.9401]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0715], [-0.9941, 0], [0, -1.0715], [0, 0]],
	              o: [[0, 1.0714999999999997], [-0.9941, 0], [0, -1.0715], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 36.9,
	            s: [{
	              c: true,
	              v: [[3.6, 1.914], [1.8, 3.828], [0, 1.914], [1.8, 0], [3.6, 1.914], [3.6, 1.914]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0571], [-0.9941, 0], [0, -1.0571], [0, 0]],
	              o: [[0, 1.0571], [-0.9941, 0], [0, -1.0571], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 37.902,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8907], [1.8, 3.7814], [0, 1.8907], [1.8, 0], [3.6, 1.8907], [3.6, 1.8907]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0442], [-0.9941, 0], [0, -1.0442], [0, 0]],
	              o: [[0, 1.0441999999999998], [-0.9941, 0], [0, -1.0442], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 38.897999999999996,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8705], [1.8, 3.741], [0, 1.8705], [1.8, 0], [3.6, 1.8705], [3.6, 1.8705]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0331], [-0.9941, 0], [0, -1.0331], [0, 0]],
	              o: [[0, 1.0331], [-0.9941, 0], [0, -1.0331], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 39.900000000000006,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8538], [1.8, 3.7076], [0, 1.8538], [1.8, 0], [3.6, 1.8538], [3.6, 1.8538]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0239], [-0.9941, 0], [0, -1.0239], [0, 0]],
	              o: [[0, 1.0239], [-0.9941, 0], [0, -1.0239], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 40.902,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8415], [1.8, 3.683], [0, 1.8415], [1.8, 0.0001], [3.6, 1.8415], [3.6, 1.8415]],
	              i: [[0, 0], [0.9941, 0], [0, 1.017], [-0.9941, 0], [0, -1.017], [0, 0]],
	              o: [[0, 1.017], [-0.9941, 0], [0, -1.017], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 41.898,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8348], [1.8, 3.6696], [0, 1.8348], [1.8, 0], [3.6, 1.8348], [3.6, 1.8348]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0134], [-0.9941, 0], [0, -1.0134], [0, 0]],
	              o: [[0, 1.0134000000000003], [-0.9941, 0], [0, -1.0134], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 42.3,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8341], [1.8, 3.6682], [0, 1.8341], [1.8, 0], [3.6, 1.8341], [3.6, 1.8341]],
	              i: [[0, 0], [0.9941, 0], [0, 1.013], [-0.9941, 0], [0, -1.013], [0, 0]],
	              o: [[0, 1.0130000000000001], [-0.9941, 0], [0, -1.013], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }]
	          }]
	        }
	      }, {
	        ty: "fl",
	        o: {
	          a: 0,
	          k: 100
	        },
	        c: {
	          a: 0,
	          k: [1, 1, 1, 1]
	        },
	        nm: "Fill",
	        hd: false,
	        r: 1
	      }, {
	        ty: "tr",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        o: {
	          a: 0,
	          k: 100
	        }
	      }]
	    }]
	  }, {
	    ty: 3,
	    ddd: 0,
	    ind: 9,
	    hd: false,
	    nm: "Ellipse 1 - Null",
	    sr: 1,
	    parent: 4,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 1,
	        k: [{
	          t: 0.06,
	          s: [0, 7],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 8.459999999999999,
	          s: [0, 5],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 8.52,
	          s: [0, 5],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 16.919999999999998,
	          s: [0, 8.8889],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 16.979999999999997,
	          s: [0, 8.89],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 25.38,
	          s: [0, 8.5547],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 25.439999999999998,
	          s: [0, 8.55],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 33.839999999999996,
	          s: [0, 7],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 33.9,
	          s: [0, 7],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [0.58],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 42.3,
	          s: [0, 7],
	          o: {
	            x: [0],
	            y: [0]
	          },
	          i: {
	            x: [1],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 48.300000000000004,
	          s: [0, 7],
	          o: {
	            x: [0.42],
	            y: [-0.2]
	          },
	          i: {
	            x: [1],
	            y: [1]
	          },
	          ti: [0, 0],
	          to: [0, 0]
	        }, {
	          t: 66.3,
	          s: [0, 7]
	        }]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 66.3,
	    st: 0,
	    bm: 0
	  }, {
	    ty: 4,
	    ddd: 0,
	    ind: 10,
	    hd: false,
	    nm: "Ellipse 1",
	    sr: 1,
	    parent: 9,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      p: {
	        a: 0,
	        k: [0, 0]
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      o: {
	        a: 0,
	        k: 100
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 66.3,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      nm: "Group",
	      hd: false,
	      np: 3,
	      it: [{
	        ty: "sh",
	        nm: "Path",
	        hd: false,
	        ks: {
	          a: 1,
	          k: [{
	            t: 0.06,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8341], [1.8, 3.6682], [0, 1.8341], [1.8, 0], [3.6, 1.8341], [3.6, 1.8341]],
	              i: [[0, 0], [0.9941, 0], [0, 1.013], [-0.9941, 0], [0, -1.013], [0, 0]],
	              o: [[0, 1.0130000000000001], [-0.9941, 0], [0, -1.013], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 1.062,
	            s: [{
	              c: true,
	              v: [[3.6, 1.929], [1.8, 3.858], [0, 1.929], [1.8, 0.0001], [3.6, 1.929], [3.6, 1.929]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0654], [-0.9941, 0], [0, -1.0654], [0, 0]],
	              o: [[0, 1.0653999999999997], [-0.9941, 0], [0, -1.0654], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 2.058,
	            s: [{
	              c: true,
	              v: [[3.6, 2.0146], [1.8, 4.0292], [0, 2.0146], [1.8, 0.0001], [3.6, 2.0146], [3.6, 2.0146]],
	              i: [[0, 0], [0.9941, 0], [0, 1.1126], [-0.9941, 0], [0, -1.1126], [0, 0]],
	              o: [[0, 1.1126], [-0.9941, 0], [0, -1.1126], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 3.0599999999999996,
	            s: [{
	              c: true,
	              v: [[3.6, 2.0929], [1.8, 4.1858], [0, 2.0929], [1.8, 0], [3.6, 2.0929], [3.6, 2.0929]],
	              i: [[0, 0], [0.9941, 0], [0, 1.1559], [-0.9941, 0], [0, -1.1559], [0, 0]],
	              o: [[0, 1.1559], [-0.9941, 0], [0, -1.1559], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 4.061999999999999,
	            s: [{
	              c: true,
	              v: [[3.6, 2.1631], [1.8, 4.3262], [0, 2.1631], [1.8, 0], [3.6, 2.1631], [3.6, 2.1631]],
	              i: [[0, 0], [0.9941, 0], [0, 1.1947], [-0.9941, 0], [0, -1.1947], [0, 0]],
	              o: [[0, 1.1947], [-0.9941, 0], [0, -1.1947], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 5.058,
	            s: [{
	              c: true,
	              v: [[3.6, 2.2238], [1.8, 4.4476], [0, 2.2238], [1.8, 0.0001], [3.6, 2.2238], [3.6, 2.2238]],
	              i: [[0, 0], [0.9941, 0], [0, 1.2282], [-0.9941, 0], [0, -1.2282], [0, 0]],
	              o: [[0, 1.2281999999999997], [-0.9941, 0], [0, -1.2282], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 6.0600000000000005,
	            s: [{
	              c: true,
	              v: [[3.6, 2.2741], [1.8, 4.5482], [0, 2.2741], [1.8, 0.0001], [3.6, 2.2741], [3.6, 2.2741]],
	              i: [[0, 0], [0.9941, 0], [0, 1.256], [-0.9941, 0], [0, -1.256], [0, 0]],
	              o: [[0, 1.2560000000000002], [-0.9941, 0], [0, -1.256], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 7.062,
	            s: [{
	              c: true,
	              v: [[3.6, 2.3112], [1.8, 4.6224], [0, 2.3112], [1.8, 0], [3.6, 2.3112], [3.6, 2.3112]],
	              i: [[0, 0], [0.9941, 0], [0, 1.2765], [-0.9941, 0], [0, -1.2765], [0, 0]],
	              o: [[0, 1.2765], [-0.9941, 0], [0, -1.2765], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 8.058,
	            s: [{
	              c: true,
	              v: [[3.6, 2.3313], [1.8, 4.6626], [0, 2.3313], [1.8, 0], [3.6, 2.3313], [3.6, 2.3313]],
	              i: [[0, 0], [0.9941, 0], [0, 1.2876], [-0.9941, 0], [0, -1.2876], [0, 0]],
	              o: [[0, 1.2875999999999999], [-0.9941, 0], [0, -1.2876], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 8.459999999999999,
	            s: [{
	              c: true,
	              v: [[3.6, 2.3333], [1.8, 4.6666], [0, 2.3333], [1.8, 0], [3.6, 2.3333], [3.6, 2.3333]],
	              i: [[0, 0], [0.9941, 0], [0, 1.2887], [-0.9941, 0], [0, -1.2887], [0, 0]],
	              o: [[0, 1.2887], [-0.9941, 0], [0, -1.2887], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 8.52,
	            s: [{
	              c: true,
	              v: [[3.6, 2.3333], [1.8, 4.6666], [0, 2.3333], [1.8, 0], [3.6, 2.3333], [3.6, 2.3333]],
	              i: [[0, 0], [0.9941, 0], [0, 1.2887], [-0.9941, 0], [0, -1.2887], [0, 0]],
	              o: [[0, 1.2887], [-0.9941, 0], [0, -1.2887], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 9.522,
	            s: [{
	              c: true,
	              v: [[3.6, 2.1856], [1.8, 4.3712], [0, 2.1856], [1.8, 0], [3.6, 2.1856], [3.6, 2.1856]],
	              i: [[0, 0], [0.9941, 0], [0, 1.2071], [-0.9941, 0], [0, -1.2071], [0, 0]],
	              o: [[0, 1.2071], [-0.9941, 0], [0, -1.2071], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 10.518,
	            s: [{
	              c: true,
	              v: [[3.6, 2.0522], [1.8, 4.1044], [0, 2.0522], [1.8, 0], [3.6, 2.0522], [3.6, 2.0522]],
	              i: [[0, 0], [0.9941, 0], [0, 1.1334], [-0.9941, 0], [0, -1.1334], [0, 0]],
	              o: [[0, 1.1334], [-0.9941, 0], [0, -1.1334], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 11.52,
	            s: [{
	              c: true,
	              v: [[3.6, 1.9302], [1.8, 3.8604], [0, 1.9302], [1.8, 0.0001], [3.6, 1.9302], [3.6, 1.9302]],
	              i: [[0, 0], [0.9941, 0], [0, 1.066], [-0.9941, 0], [0, -1.066], [0, 0]],
	              o: [[0, 1.066], [-0.9941, 0], [0, -1.066], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 12.522,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8208], [1.8, 3.6416], [0, 1.8208], [1.8, 0], [3.6, 1.8208], [3.6, 1.8208]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0056], [-0.9941, 0], [0, -1.0056], [0, 0]],
	              o: [[0, 1.0056], [-0.9941, 0], [0, -1.0056], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 13.518,
	            s: [{
	              c: true,
	              v: [[3.6, 1.7263], [1.8, 3.4526], [0, 1.7263], [1.8, 0], [3.6, 1.7263], [3.6, 1.7263]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9534], [-0.9941, 0], [0, -0.9534], [0, 0]],
	              o: [[0, 0.9534], [-0.9941, 0], [0, -0.9534], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 14.52,
	            s: [{
	              c: true,
	              v: [[3.6, 1.648], [1.8, 3.296], [0, 1.648], [1.8, 0.0001], [3.6, 1.648], [3.6, 1.648]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9102], [-0.9941, 0], [0, -0.9102], [0, 0]],
	              o: [[0, 0.9101999999999999], [-0.9941, 0], [0, -0.9102], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 15.521999999999998,
	            s: [{
	              c: true,
	              v: [[3.6, 1.5901], [1.8, 3.1802], [0, 1.5901], [1.8, 0.0001], [3.6, 1.5901], [3.6, 1.5901]],
	              i: [[0, 0], [0.9941, 0], [0, 0.8782], [-0.9941, 0], [0, -0.8782], [0, 0]],
	              o: [[0, 0.8782000000000001], [-0.9941, 0], [0, -0.8782], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 16.518,
	            s: [{
	              c: true,
	              v: [[3.6, 1.5588], [1.8, 3.1176], [0, 1.5588], [1.8, 0.0001], [3.6, 1.5588], [3.6, 1.5588]],
	              i: [[0, 0], [0.9941, 0], [0, 0.8609], [-0.9941, 0], [0, -0.8609], [0, 0]],
	              o: [[0, 0.8608999999999998], [-0.9941, 0], [0, -0.8609], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 16.919999999999998,
	            s: [{
	              c: true,
	              v: [[3.6, 1.5556], [1.8, 3.1112], [0, 1.5556], [1.8, 0.0001], [3.6, 1.5556], [3.6, 1.5556]],
	              i: [[0, 0], [0.9941, 0], [0, 0.8591], [-0.9941, 0], [0, -0.8591], [0, 0]],
	              o: [[0, 0.8590999999999998], [-0.9941, 0], [0, -0.8591], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 16.979999999999997,
	            s: [{
	              c: true,
	              v: [[3.6, 1.5556], [1.8, 3.1112], [0, 1.5556], [1.8, 0.0001], [3.6, 1.5556], [3.6, 1.5556]],
	              i: [[0, 0], [0.9941, 0], [0, 0.8591], [-0.9941, 0], [0, -0.8591], [0, 0]],
	              o: [[0, 0.8590999999999998], [-0.9941, 0], [0, -0.8591], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 17.982000000000003,
	            s: [{
	              c: true,
	              v: [[3.6, 1.6472], [1.8, 3.2944], [0, 1.6472], [1.8, 0], [3.6, 1.6472], [3.6, 1.6472]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9097], [-0.9941, 0], [0, -0.9097], [0, 0]],
	              o: [[0, 0.9096999999999997], [-0.9941, 0], [0, -0.9097], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 18.978,
	            s: [{
	              c: true,
	              v: [[3.6, 1.7299], [1.8, 3.4598], [0, 1.7299], [1.8, 0], [3.6, 1.7299], [3.6, 1.7299]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9554], [-0.9941, 0], [0, -0.9554], [0, 0]],
	              o: [[0, 0.9553999999999998], [-0.9941, 0], [0, -0.9554], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 19.98,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8056], [1.8, 3.6112], [0, 1.8056], [1.8, 0], [3.6, 1.8056], [3.6, 1.8056]],
	              i: [[0, 0], [0.9941, 0], [0, 0.9972], [-0.9941, 0], [0, -0.9972], [0, 0]],
	              o: [[0, 0.9971999999999999], [-0.9941, 0], [0, -0.9972], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 20.982,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8734], [1.8, 3.7468], [0, 1.8734], [1.8, 0], [3.6, 1.8734], [3.6, 1.8734]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0347], [-0.9941, 0], [0, -1.0347], [0, 0]],
	              o: [[0, 1.0347000000000002], [-0.9941, 0], [0, -1.0347], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 21.978,
	            s: [{
	              c: true,
	              v: [[3.6, 1.932], [1.8, 3.864], [0, 1.932], [1.8, 0], [3.6, 1.932], [3.6, 1.932]],
	              i: [[0, 0], [0.9941, 0], [0, 1.067], [-0.9941, 0], [0, -1.067], [0, 0]],
	              o: [[0, 1.0669999999999997], [-0.9941, 0], [0, -1.067], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 22.98,
	            s: [{
	              c: true,
	              v: [[3.6, 1.9806], [1.8, 3.9612], [0, 1.9806], [1.8, 0], [3.6, 1.9806], [3.6, 1.9806]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0939], [-0.9941, 0], [0, -1.0939], [0, 0]],
	              o: [[0, 1.0939], [-0.9941, 0], [0, -1.0939], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 23.982,
	            s: [{
	              c: true,
	              v: [[3.6, 2.0165], [1.8, 4.033], [0, 2.0165], [1.8, 0], [3.6, 2.0165], [3.6, 2.0165]],
	              i: [[0, 0], [0.9941, 0], [0, 1.1137], [-0.9941, 0], [0, -1.1137], [0, 0]],
	              o: [[0, 1.1137000000000001], [-0.9941, 0], [0, -1.1137], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 24.978,
	            s: [{
	              c: true,
	              v: [[3.6, 2.0359], [1.8, 4.0718], [0, 2.0359], [1.8, 0], [3.6, 2.0359], [3.6, 2.0359]],
	              i: [[0, 0], [0.9941, 0], [0, 1.1244], [-0.9941, 0], [0, -1.1244], [0, 0]],
	              o: [[0, 1.1244], [-0.9941, 0], [0, -1.1244], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 25.38,
	            s: [{
	              c: true,
	              v: [[3.6, 2.0379], [1.8, 4.0758], [0, 2.0379], [1.8, 0], [3.6, 2.0379], [3.6, 2.0379]],
	              i: [[0, 0], [0.9941, 0], [0, 1.1255], [-0.9941, 0], [0, -1.1255], [0, 0]],
	              o: [[0, 1.1255000000000002], [-0.9941, 0], [0, -1.1255], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 25.439999999999998,
	            s: [{
	              c: true,
	              v: [[3.6, 2.0379], [1.8, 4.0758], [0, 2.0379], [1.8, 0], [3.6, 2.0379], [3.6, 2.0379]],
	              i: [[0, 0], [0.9941, 0], [0, 1.1255], [-0.9941, 0], [0, -1.1255], [0, 0]],
	              o: [[0, 1.1255000000000002], [-0.9941, 0], [0, -1.1255], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 26.442,
	            s: [{
	              c: true,
	              v: [[3.6, 1.9992], [1.8, 3.9984], [0, 1.9992], [1.8, 0], [3.6, 1.9992], [3.6, 1.9992]],
	              i: [[0, 0], [0.9941, 0], [0, 1.1042], [-0.9941, 0], [0, -1.1042], [0, 0]],
	              o: [[0, 1.1042], [-0.9941, 0], [0, -1.1042], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 27.438,
	            s: [{
	              c: true,
	              v: [[3.6, 1.9643], [1.8, 3.9286], [0, 1.9643], [1.8, 0.0001], [3.6, 1.9643], [3.6, 1.9643]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0849], [-0.9941, 0], [0, -1.0849], [0, 0]],
	              o: [[0, 1.0849], [-0.9941, 0], [0, -1.0849], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 28.439999999999998,
	            s: [{
	              c: true,
	              v: [[3.6, 1.9323], [1.8, 3.8646], [0, 1.9323], [1.8, 0.0001], [3.6, 1.9323], [3.6, 1.9323]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0672], [-0.9941, 0], [0, -1.0672], [0, 0]],
	              o: [[0, 1.0672], [-0.9941, 0], [0, -1.0672], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 29.442,
	            s: [{
	              c: true,
	              v: [[3.6, 1.9036], [1.8, 3.8072], [0, 1.9036], [1.8, 0], [3.6, 1.9036], [3.6, 1.9036]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0514], [-0.9941, 0], [0, -1.0514], [0, 0]],
	              o: [[0, 1.0514000000000001], [-0.9941, 0], [0, -1.0514], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 30.438,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8789], [1.8, 3.7578], [0, 1.8789], [1.8, 0.0001], [3.6, 1.8789], [3.6, 1.8789]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0377], [-0.9941, 0], [0, -1.0377], [0, 0]],
	              o: [[0, 1.0376999999999998], [-0.9941, 0], [0, -1.0377], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 31.44,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8583], [1.8, 3.7166], [0, 1.8583], [1.8, 0], [3.6, 1.8583], [3.6, 1.8583]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0263], [-0.9941, 0], [0, -1.0263], [0, 0]],
	              o: [[0, 1.0262999999999998], [-0.9941, 0], [0, -1.0263], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 32.442,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8432], [1.8, 3.6864], [0, 1.8432], [1.8, 0.0001], [3.6, 1.8432], [3.6, 1.8432]],
	              i: [[0, 0], [0.9941, 0], [0, 1.018], [-0.9941, 0], [0, -1.018], [0, 0]],
	              o: [[0, 1.0180000000000002], [-0.9941, 0], [0, -1.018], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 33.438,
	            s: [{
	              c: true,
	              v: [[3.6, 1.835], [1.8, 3.67], [0, 1.835], [1.8, 0.0001], [3.6, 1.835], [3.6, 1.835]],
	              i: [[0, 0], [0.9941, 0], [0, 1.0134], [-0.9941, 0], [0, -1.0134], [0, 0]],
	              o: [[0, 1.0133999999999999], [-0.9941, 0], [0, -1.0134], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }],
	            o: {
	              x: [0],
	              y: [0]
	            },
	            i: {
	              x: [1],
	              y: [1]
	            }
	          }, {
	            t: 33.839999999999996,
	            s: [{
	              c: true,
	              v: [[3.6, 1.8341], [1.8, 3.6682], [0, 1.8341], [1.8, 0], [3.6, 1.8341], [3.6, 1.8341]],
	              i: [[0, 0], [0.9941, 0], [0, 1.013], [-0.9941, 0], [0, -1.013], [0, 0]],
	              o: [[0, 1.0130000000000001], [-0.9941, 0], [0, -1.013], [0.9941000000000002, 0], [0, 0], [0, 0]]
	            }]
	          }]
	        }
	      }, {
	        ty: "fl",
	        o: {
	          a: 0,
	          k: 100
	        },
	        c: {
	          a: 0,
	          k: [1, 1, 1, 1]
	        },
	        nm: "Fill",
	        hd: false,
	        r: 1
	      }, {
	        ty: "tr",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        o: {
	          a: 0,
	          k: 100
	        }
	      }]
	    }]
	  }]
	}];
	var layers$2 = [{
	  ddd: 0,
	  ind: 1,
	  ty: 0,
	  nm: "typing",
	  refId: "m2czolqy5p73gm5l",
	  sr: 1,
	  ks: {
	    a: {
	      a: 0,
	      k: [0, 0]
	    },
	    p: {
	      a: 0,
	      k: [0, 0]
	    },
	    s: {
	      a: 0,
	      k: [100, 100]
	    },
	    sk: {
	      a: 0,
	      k: 0
	    },
	    sa: {
	      a: 0,
	      k: 0
	    },
	    r: {
	      a: 0,
	      k: 0
	    },
	    o: {
	      a: 0,
	      k: 100
	    }
	  },
	  ao: 0,
	  w: 18,
	  h: 18,
	  ip: 0,
	  op: 66.3,
	  st: 0,
	  hd: false,
	  bm: 0
	}];
	var meta$2 = {
	  a: "",
	  d: "",
	  tc: "",
	  g: "Aninix"
	};
	var WritingAnimation = {
	  fr: fr$2,
	  v: v$2,
	  ip: ip$2,
	  op: op$2,
	  w: w$2,
	  h: h$2,
	  nm: nm$2,
	  ddd: ddd$2,
	  markers: markers$2,
	  assets: assets$2,
	  layers: layers$2,
	  meta: meta$2
	};

	const USERS_TO_SHOW = 3;
	const AnimationByActionType = {
	  [im_v2_lib_inputAction.InputAction.writing]: WritingAnimation,
	  [im_v2_lib_inputAction.InputAction.sendingFile]: UploadingAnimation,
	  [im_v2_lib_inputAction.InputAction.recordingVoice]: RecordingAnimation
	};
	const LocCodeByActionType = {
	  [im_v2_lib_inputAction.InputAction.writing]: 'IM_ELEMENTS_STATUS_TYPING',
	  [im_v2_lib_inputAction.InputAction.sendingFile]: 'IM_ELEMENTS_STATUS_SENDING_FILE',
	  [im_v2_lib_inputAction.InputAction.recordingVoice]: 'IM_ELEMENTS_STATUS_RECORDING_VOICE'
	};

	// @vue/component
	const InputActions = {
	  name: 'InputActions',
	  props: {
	    dialogId: {
	      required: true,
	      type: String
	    },
	    enterAnimationFinished: {
	      required: true,
	      type: Boolean
	    }
	  },
	  computed: {
	    chatInputActions() {
	      return this.$store.getters['chats/inputActions/getByDialogId'](this.dialogId);
	    },
	    uniqueUserRecords() {
	      const uniqueUserRecords = {};
	      this.chatInputActions.forEach(userRecord => {
	        uniqueUserRecords[userRecord.userId] = userRecord.userName;
	      });
	      return Object.entries(uniqueUserRecords).map(([userId, userName]) => {
	        return {
	          userId,
	          userName
	        };
	      });
	    },
	    isSingleUserActive() {
	      const userIds = this.chatInputActions.map(element => element.userId);
	      const uniqueUsers = new Set(userIds);
	      return uniqueUsers.size === 1;
	    },
	    usersToShowText() {
	      const usersToShow = this.uniqueUserRecords.slice(0, USERS_TO_SHOW);
	      return usersToShow.map(element => element.userName).join(', ');
	    },
	    inputActionText() {
	      if (this.isSingleUserActive) {
	        return this.getActionTextForSingleUser();
	      }

	      // Ivan, Alex, Rob and 7 more are writing
	      const remainingUsersCount = this.uniqueUserRecords.length - USERS_TO_SHOW;
	      if (remainingUsersCount > 0) {
	        return this.loc('IM_ELEMENTS_STATUS_TYPING_PLURAL_MORE', {
	          '#USERS#': this.usersToShowText,
	          '#COUNT#': remainingUsersCount
	        });
	      }

	      // Ivan, Alex, Rob are writing
	      return this.loc('IM_ELEMENTS_STATUS_TYPING_PLURAL', {
	        '#USERS#': this.usersToShowText
	      });
	    },
	    animationName() {
	      if (this.isSingleUserActive) {
	        const [firstUserRecord] = this.chatInputActions;
	        const {
	          type
	        } = firstUserRecord;
	        return AnimationByActionType[type];
	      }
	      return WritingAnimation;
	    }
	  },
	  watch: {
	    enterAnimationFinished() {
	      if (this.currentAnimation) {
	        return;
	      }
	      this.playAnimation(this.animationName);
	    },
	    animationName(newAnimation) {
	      this.stopAnimation();
	      this.playAnimation(newAnimation);
	    }
	  },
	  mounted() {
	    if (!this.$refs.animationContainer) {
	      return;
	    }
	    this.playAnimation(this.animationName);
	  },
	  beforeUnmount() {
	    this.stopAnimation();
	  },
	  methods: {
	    getActionTextForSingleUser() {
	      const [firstUserRecord] = this.chatInputActions;
	      const {
	        type,
	        userName
	      } = firstUserRecord;
	      const code = LocCodeByActionType[type];
	      return this.loc(code, {
	        '#USER#': userName
	      });
	    },
	    playAnimation(animationName) {
	      this.currentAnimation = ui_lottie.Lottie.loadAnimation({
	        animationData: animationName,
	        container: this.$refs.animationContainer,
	        renderer: 'svg',
	        loop: true,
	        autoplay: true
	      });
	    },
	    stopAnimation() {
	      if (!this.currentAnimation) {
	        return;
	      }
	      this.currentAnimation.destroy();
	    },
	    loc(phraseCode, replacements = {}) {
	      return this.$Bitrix.Loc.getMessage(phraseCode, replacements);
	    }
	  },
	  template: `
		<div class="bx-im-dialog-chat-status__content">
			<div class="bx-im-dialog-chat-status__animation" ref="animationContainer"></div>
			<div class="bx-im-dialog-chat-status__text">{{ inputActionText }}</div>
		</div>
	`
	};

	class UserService {
	  async loadReadUsers(messageId) {
	    im_v2_lib_logger.Logger.warn('Dialog-status: UserService: loadReadUsers', messageId);
	    const response = await im_v2_application_core.Core.getRestClient().callMethod(im_v2_const.RestMethod.imV2ChatMessageTailViewers, {
	      id: messageId
	    }).catch(error => {
	      // eslint-disable-next-line no-console
	      console.error('Dialog-status: UserService: loadReadUsers error', error);
	      throw new Error(error);
	    });
	    const users = response.data().users;
	    const userManager = new im_v2_lib_user.UserManager();
	    await userManager.setUsersToModel(Object.values(users));
	    return users.map(user => user.id);
	  }
	}

	// @vue/component
	const AdditionalUsers = {
	  components: {
	    UserListPopup
	  },
	  props: {
	    dialogId: {
	      type: String,
	      required: true
	    },
	    show: {
	      type: Boolean,
	      required: true
	    },
	    bindElement: {
	      type: Object,
	      required: true
	    }
	  },
	  emits: ['close'],
	  data() {
	    return {
	      showPopup: false,
	      loadingAdditionalUsers: false,
	      additionalUsers: []
	    };
	  },
	  computed: {
	    dialog() {
	      return this.$store.getters['chats/get'](this.dialogId, true);
	    }
	  },
	  watch: {
	    show(newValue, oldValue) {
	      if (!oldValue && newValue) {
	        this.showPopup = true;
	        void this.loadUsers();
	      }
	    }
	  },
	  methods: {
	    async loadUsers() {
	      this.loadingAdditionalUsers = true;
	      const userIds = await this.getUserService().loadReadUsers(this.dialog.lastMessageId).catch(() => {
	        this.loadingAdditionalUsers = false;
	      });
	      this.additionalUsers = this.prepareAdditionalUsers(userIds);
	      this.loadingAdditionalUsers = false;
	    },
	    onPopupClose() {
	      this.showPopup = false;
	      this.$emit('close');
	    },
	    prepareAdditionalUsers(userIds) {
	      const firstViewerId = this.dialog.lastMessageViews.firstViewer.userId;
	      return userIds.filter(userId => {
	        return userId !== im_v2_application_core.Core.getUserId() && userId !== firstViewerId;
	      });
	    },
	    getUserService() {
	      if (!this.userService) {
	        this.userService = new UserService();
	      }
	      return this.userService;
	    }
	  },
	  template: `
		<UserListPopup
			id="bx-im-dialog-read-users"
			:showPopup="showPopup"
			:loading="loadingAdditionalUsers"
			:userIds="additionalUsers"
			:contextDialogId="dialogId"
			:bindElement="bindElement || {}"
			:withAngle="false"
			:forceTop="true"
			@close="onPopupClose"
		/>
	`
	};

	const MORE_USERS_CSS_CLASS = 'bx-im-dialog-chat-status__user-count';

	// @vue/component
	const ReadStatus = {
	  name: 'ReadStatus',
	  components: {
	    AdditionalUsers
	  },
	  props: {
	    dialogId: {
	      required: true,
	      type: String
	    }
	  },
	  data() {
	    return {
	      showAdditionalUsers: false,
	      additionalUsersLinkElement: null
	    };
	  },
	  computed: {
	    dialog() {
	      return this.$store.getters['chats/get'](this.dialogId, true);
	    },
	    isUser() {
	      return this.dialog.type === im_v2_const.ChatType.user;
	    },
	    lastMessageViews() {
	      return this.dialog.lastMessageViews;
	    },
	    readStatusText() {
	      if (this.isUser) {
	        return this.formatUserViewStatus();
	      }
	      return this.formatChatViewStatus();
	    }
	  },
	  methods: {
	    formatUserViewStatus() {
	      const {
	        date
	      } = this.lastMessageViews.firstViewer;
	      return this.loc('IM_ELEMENTS_STATUS_READ_USER_MSGVER_1', {
	        '#DATE#': im_v2_lib_dateFormatter.DateFormatter.formatByTemplate(date, im_v2_lib_dateFormatter.DateTemplate.messageReadStatus)
	      });
	    },
	    formatChatViewStatus() {
	      const {
	        countOfViewers,
	        firstViewer
	      } = this.lastMessageViews;
	      if (countOfViewers === 1) {
	        return this.loc('IM_ELEMENTS_STATUS_READ_CHAT', {
	          '#USER#': main_core.Text.encode(firstViewer.userName)
	        });
	      }
	      return this.loc('IM_ELEMENTS_STATUS_READ_CHAT_PLURAL', {
	        '#USERS#': main_core.Text.encode(firstViewer.userName),
	        '#LINK_START#': `<span class="${MORE_USERS_CSS_CLASS}">`,
	        '#COUNT#': countOfViewers - 1,
	        '#LINK_END#': '</span>'
	      });
	    },
	    onClick(event) {
	      if (!event.target.matches(`.${MORE_USERS_CSS_CLASS}`)) {
	        return;
	      }
	      this.openUsersPopup();
	    },
	    openUsersPopup() {
	      this.additionalUsersLinkElement = document.querySelector(`.${MORE_USERS_CSS_CLASS}`);
	      this.showAdditionalUsers = true;
	    },
	    onUsersPopupClose() {
	      this.showAdditionalUsers = false;
	      this.additionalUsersLinkElement = null;
	    },
	    loc(phraseCode, replacements = {}) {
	      return this.$Bitrix.Loc.getMessage(phraseCode, replacements);
	    }
	  },
	  template: `
		<div class="bx-im-dialog-chat-status__content">
			<div class="bx-im-dialog-chat-status__icon --read"></div>
			<div v-html="readStatusText" @click="onClick" class="bx-im-dialog-chat-status__text"></div>
			<AdditionalUsers
				:dialogId="dialogId"
				:show="showAdditionalUsers"
				:bindElement="additionalUsersLinkElement || {}"
				@close="onUsersPopupClose"
			/>
		</div>
	`
	};

	// @vue/component
	const DialogStatus = {
	  components: {
	    InputActions,
	    ReadStatus
	  },
	  props: {
	    dialogId: {
	      required: true,
	      type: String
	    }
	  },
	  data() {
	    return {
	      enterAnimationFinished: false
	    };
	  },
	  computed: {
	    dialog() {
	      return this.$store.getters['chats/get'](this.dialogId, true);
	    },
	    chatInputActions() {
	      return this.$store.getters['chats/inputActions/getByDialogId'](this.dialogId);
	    },
	    showInputStatus() {
	      return this.dialog.inited && this.chatInputActions;
	    },
	    showReadStatus() {
	      return this.dialog.inited && this.dialog.lastMessageViews.countOfViewers > 0;
	    }
	  },
	  template: `
		<div class="bx-im-dialog-chat-status__container">
			<Transition
				name="im-dialog-status-animation"
				mode="out-in"
				@before-enter="enterAnimationFinished = false"
				@enter="enterAnimationFinished = true"
			>
				<InputActions v-if="showInputStatus" :dialogId="dialogId" :enterAnimationFinished="enterAnimationFinished" />
				<ReadStatus v-else-if="showReadStatus" :dialogId="dialogId" />
			</Transition>
		</div>
	`
	};

	const POPUP_ID$2 = 'im-create-chat-promo-popup';

	// @vue/component
	const PromoPopup = {
	  name: 'PromoPopup',
	  components: {
	    MessengerPopup
	  },
	  emits: ['close'],
	  computed: {
	    POPUP_ID: () => POPUP_ID$2,
	    config() {
	      return {
	        width: 468,
	        padding: 0,
	        overlay: true,
	        autoHide: false,
	        closeByEsc: false
	      };
	    }
	  },
	  template: `
		<MessengerPopup
			:config="config"
			@close="$emit('close')"
			:id="POPUP_ID"
		>
			<slot></slot>
		</MessengerPopup>
	`
	};

	var assets$3 = [{
	  id: "ygVDTsB_fW5gJ9rCcbJPh",
	  layers: []
	}, {
	  id: "xC6AluSgfv8TgYhGS3Nj7",
	  layers: [{
	    ddd: 0,
	    ind: 107,
	    ty: 4,
	    nm: "",
	    ln: "TwG0xJ0K-cHrJqItFoZLc107",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49994.5, 49995]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [133.33, 133.33]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      nm: "surface1131",
	      it: [{
	        ty: "gr",
	        it: [{
	          ty: "sh",
	          d: 1,
	          ks: {
	            a: 0,
	            k: {
	              c: true,
	              i: [[0, 0], [0.01, -0.7], [-0.01, -0.16], [-0.09, -0.27], [-0.25, -0.32], [-0.21, -0.2], [0, 0], [-0.29, 0.27], [-0.18, 0.25], [-0.07, 0.45], [0, 0.16], [0.07, 0.23], [0.46, 0.27], [0.3, 0.03], [0.19, -0.03], [0.29, -0.22], [0.16, -0.25], [0, 0], [0.02, 0.04], [0.38, 0.19], [0.25, 0.02], [0.07, 0], [0.09, -0.01], [0.23, -0.12]],
	              o: [[-0.66, 0.34], [0, 0.16], [0.01, 0.19], [0.09, 0.27], [0.18, 0.23], [0.33, 0.3], [0, 0], [0.23, -0.21], [0.27, -0.37], [0.02, -0.16], [0.01, -0.24], [-0.14, -0.51], [-0.26, -0.15], [-0.19, -0.02], [-0.36, 0.06], [-0.24, 0.18], [-0.01, 0.01], [-0.03, -0.04], [-0.23, -0.34], [-0.23, -0.11], [-0.07, -0.01], [-0.09, 0], [-0.25, 0.03], [0, 0]],
	              v: [[1.19, 0.61], [0, 2.3], [0.02, 2.78], [0.16, 3.36], [0.77, 4.38], [1.37, 5.01], [4.14, 7.12], [6.95, 4.95], [7.57, 4.25], [8.2, 3.02], [8.25, 2.54], [8.18, 1.83], [7.14, 0.66], [6.3, 0.39], [5.73, 0.39], [4.75, 0.81], [4.14, 1.47], [4.13, 1.49], [4.05, 1.39], [3.14, 0.59], [2.41, 0.38], [2.2, 0.37], [1.91, 0.39], [1.19, 0.61]]
	            }
	          }
	        }, {
	          ty: "fl",
	          c: {
	            a: 0,
	            k: [1, 0.6, 0.59, 1]
	          },
	          r: 2,
	          o: {
	            a: 0,
	            k: 100
	          }
	        }, {
	          ty: "tr",
	          nm: "Transform",
	          a: {
	            a: 0,
	            k: [0, 0]
	          },
	          o: {
	            a: 0,
	            k: 100
	          },
	          p: {
	            a: 0,
	            k: [0, 0]
	          },
	          r: {
	            a: 0,
	            k: 0
	          },
	          s: {
	            a: 0,
	            k: [100, 100]
	          },
	          sk: {
	            a: 0,
	            k: 0
	          },
	          sa: {
	            a: 0,
	            k: 0
	          }
	        }]
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }]
	    }]
	  }]
	}, {
	  id: "c1xlHDkjW9tfeCBPfD-Xk",
	  layers: [{
	    ddd: 0,
	    ind: 109,
	    ty: 4,
	    nm: "",
	    ln: "ow2OjA3sjUVwDU7Yv8vlG109",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [11, 10]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0, 0, 0]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "kcIAKldVbqwSKE1a47Rbp",
	  layers: [{
	    ddd: 0,
	    ind: 108,
	    ty: 0,
	    nm: "",
	    td: 1,
	    ln: "precomp_QrKwA7GS_xJIxsEWtLjXw108",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "c1xlHDkjW9tfeCBPfD-Xk"
	  }, {
	    ddd: 0,
	    ind: 106,
	    ty: 0,
	    nm: "",
	    tt: 1,
	    ln: "precomp_3nE3MfBEH7tig5aKrwG3T106",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "xC6AluSgfv8TgYhGS3Nj7"
	  }]
	}, {
	  id: "3XP7aF81fTEGvvlpwNrB8",
	  layers: []
	}, {
	  id: "cn95eDa7Gvf4AWFWROIEf",
	  layers: []
	}, {
	  id: "TJFvaksh6O2qDLAPxapeh",
	  layers: [{
	    ddd: 0,
	    ind: 104,
	    ty: 0,
	    nm: "",
	    ln: "precomp_qPsu-uwqQ5yZ0XaiypwMV104",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "ygVDTsB_fW5gJ9rCcbJPh"
	  }, {
	    ddd: 0,
	    ind: 105,
	    ty: 0,
	    nm: "",
	    ln: "precomp_3nE3MfBEH7tig5aKrwG3T105",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "kcIAKldVbqwSKE1a47Rbp"
	  }, {
	    ddd: 0,
	    ind: 110,
	    ty: 0,
	    nm: "",
	    ln: "precomp_LZUMU1lCe8n2KKj-36PFX110",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "3XP7aF81fTEGvvlpwNrB8"
	  }, {
	    ddd: 0,
	    ind: 111,
	    ty: 0,
	    nm: "",
	    ln: "precomp_qGNtrPofRLuOopd-TmpXZ111",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "cn95eDa7Gvf4AWFWROIEf"
	  }]
	}, {
	  id: "KD1-b5VP1-69GdKBp8JsJ",
	  layers: [{
	    ddd: 0,
	    ind: 113,
	    ty: 4,
	    nm: "",
	    ln: "rj0eioCXr3I3FNjE0dOrg113",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 53
	        },
	        s: {
	          a: 0,
	          k: [78, 4]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0.32, 0.36, 0.41]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 10.2
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "RLhCaQ6HCq9yPpLhLiVgW",
	  layers: [{
	    ddd: 0,
	    ind: 115,
	    ty: 4,
	    nm: "",
	    ln: "tZww9-oZV4VpQWToNnp3z115",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 53
	        },
	        s: {
	          a: 0,
	          k: [174, 4]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0.32, 0.36, 0.41]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 10.2
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "NNvNFAo4uuJIxbFFCT9Xd",
	  layers: [{
	    ddd: 0,
	    ind: 117,
	    ty: 4,
	    nm: "",
	    ln: "vNLAmt-2zyOVVAj0UkIU6117",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 53
	        },
	        s: {
	          a: 0,
	          k: [11.61, 4]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [1, 0.77, 0.3]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "KQwm-LgbPDi3x_uA5aKrm",
	  layers: [{
	    ddd: 0,
	    ind: 119,
	    ty: 4,
	    nm: "",
	    ln: "Wr0zAhw8vw_UmYXAcBSI5119",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 53
	        },
	        s: {
	          a: 0,
	          k: [41, 4]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [1, 0.77, 0.3]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "0NC-yuc5tFr60sVEKCa6s",
	  layers: [{
	    ddd: 0,
	    ind: 121,
	    ty: 4,
	    nm: "",
	    ln: "x-0xXfmob86N14LvwwO8K121",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 53
	        },
	        s: {
	          a: 0,
	          k: [189, 4]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0.32, 0.36, 0.41]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 10.2
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "HGlTs4Sd4pXZPdN1vy5Sq",
	  layers: []
	}, {
	  h: 39,
	  id: "VBt3H4ggnVjQzIdWKshFD",
	  p: "data:image/png;base64,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",
	  u: "",
	  w: 39,
	  e: 1
	}, {
	  id: "8aoQaVQY7GeDE73vJ7onW",
	  layers: [{
	    ddd: 0,
	    ind: 126,
	    ty: 2,
	    nm: "",
	    ln: "VBt3H4ggnVjQzIdWKshFD126",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49980.75, 49980.75]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "VBt3H4ggnVjQzIdWKshFD"
	  }]
	}, {
	  id: "jryCk9qldICNfDdtDwLTT",
	  layers: [{
	    ddd: 0,
	    ind: 128,
	    ty: 4,
	    nm: "",
	    ln: "XDCHnPLZcMQ4-TIx7Tjxx128",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [38.5, 38.5]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0, 0, 0]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "w5buIMrR3g1Cbve2qydNa",
	  layers: [{
	    ddd: 0,
	    ind: 127,
	    ty: 0,
	    nm: "",
	    td: 1,
	    ln: "precomp_ekSf0oX7PPeMqv-urLU63127",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "jryCk9qldICNfDdtDwLTT"
	  }, {
	    ddd: 0,
	    ind: 125,
	    ty: 0,
	    nm: "",
	    tt: 1,
	    ln: "precomp_Fy9QTIumqMVnrwFQzJM6e125",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "8aoQaVQY7GeDE73vJ7onW"
	  }]
	}, {
	  id: "mW_NJXgWEkjYAhZBnvHmO",
	  layers: []
	}, {
	  id: "L6RRoQcV_3D3aF62G8d-g",
	  layers: []
	}, {
	  id: "5uFiCLYj4jiyugsNVeCcu",
	  layers: [{
	    ddd: 0,
	    ind: 123,
	    ty: 0,
	    nm: "",
	    ln: "precomp_zedtyugyOr6GXdYav4oYx123",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "HGlTs4Sd4pXZPdN1vy5Sq"
	  }, {
	    ddd: 0,
	    ind: 124,
	    ty: 0,
	    nm: "",
	    ln: "precomp_Fy9QTIumqMVnrwFQzJM6e124",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "w5buIMrR3g1Cbve2qydNa"
	  }, {
	    ddd: 0,
	    ind: 129,
	    ty: 0,
	    nm: "",
	    ln: "precomp_tiykRrqbFBJrqFHzY7S1g129",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "mW_NJXgWEkjYAhZBnvHmO"
	  }, {
	    ddd: 0,
	    ind: 130,
	    ty: 0,
	    nm: "",
	    ln: "precomp_kbLXx--qPlbLh1RKgTDhP130",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "L6RRoQcV_3D3aF62G8d-g"
	  }]
	}, {
	  id: "RR_0ZpRhvep3VsefZu-CO",
	  layers: []
	}, {
	  h: 76,
	  id: "Z4z9knXZJH0RqGlq2TgrR",
	  p: "data:image/png;base64,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",
	  u: "",
	  w: 245,
	  e: 1
	}, {
	  id: "J87GHBll4UwySRuqjvDxd",
	  layers: [{
	    ddd: 0,
	    ind: 135,
	    ty: 2,
	    nm: "",
	    ln: "Z4z9knXZJH0RqGlq2TgrR135",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49877.5, 49962]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "Z4z9knXZJH0RqGlq2TgrR"
	  }]
	}, {
	  id: "D3MEvIc6nTkZqtM5AvO0B",
	  layers: [{
	    ddd: 0,
	    ind: 137,
	    ty: 4,
	    nm: "",
	    ln: "MUNzLQgjYD2cVvKrEMnd0137",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [245, 76]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0, 0, 0]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "9X-XGH6doCPYWF6wRKRg6",
	  layers: [{
	    ddd: 0,
	    ind: 136,
	    ty: 0,
	    nm: "",
	    td: 1,
	    ln: "precomp_rFwJxmBZGrqJkYFQd0Mo_136",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "D3MEvIc6nTkZqtM5AvO0B"
	  }, {
	    ddd: 0,
	    ind: 134,
	    ty: 0,
	    nm: "",
	    tt: 1,
	    ln: "precomp_2nzHnLsLZDsGWwPZShRPz134",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "J87GHBll4UwySRuqjvDxd"
	  }]
	}, {
	  id: "K7pjOGYykQOOeuPvoBL5Q",
	  layers: []
	}, {
	  id: "1EcS6auZRUqbzL3Yy-lYV",
	  layers: []
	}, {
	  id: "w-sBRh7CPk2D5bd8yMSxD",
	  layers: [{
	    ddd: 0,
	    ind: 132,
	    ty: 0,
	    nm: "",
	    ln: "precomp_mZXQeQFU2hNwhQj3UTks2132",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "RR_0ZpRhvep3VsefZu-CO"
	  }, {
	    ddd: 0,
	    ind: 133,
	    ty: 0,
	    nm: "",
	    ln: "precomp_2nzHnLsLZDsGWwPZShRPz133",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "9X-XGH6doCPYWF6wRKRg6"
	  }, {
	    ddd: 0,
	    ind: 138,
	    ty: 0,
	    nm: "",
	    ln: "precomp_PbbPu45uFeEOSmPxZmWCH138",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "K7pjOGYykQOOeuPvoBL5Q"
	  }, {
	    ddd: 0,
	    ind: 139,
	    ty: 0,
	    nm: "",
	    ln: "precomp_u0z16zlM57CmbyePvoXjR139",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "1EcS6auZRUqbzL3Yy-lYV"
	  }]
	}, {
	  id: "CQXcj-dzfXhtUXwfRB9p0",
	  layers: []
	}, {
	  id: "EZwQu0pOd8V-6xISyaE0J",
	  layers: []
	}, {
	  id: "xC5Li4LkvpYyklBDBnkOO",
	  layers: [{
	    ddd: 0,
	    ind: 103,
	    ty: 0,
	    nm: "",
	    ln: "precomp_LI8l9WYsgg446oedhYDw4103",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50118, 49981]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "TJFvaksh6O2qDLAPxapeh"
	  }, {
	    ddd: 0,
	    ind: 112,
	    ty: 0,
	    nm: "",
	    ln: "precomp_SUd8eX4HvWmH6snfmnbTU112",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49952.5, 50014]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "KD1-b5VP1-69GdKBp8JsJ"
	  }, {
	    ddd: 0,
	    ind: 114,
	    ty: 0,
	    nm: "",
	    ln: "precomp_0eT4mAfiocQVSeaGZBjQ8114",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000.5, 50004]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "RLhCaQ6HCq9yPpLhLiVgW"
	  }, {
	    ddd: 0,
	    ind: 116,
	    ty: 0,
	    nm: "",
	    ln: "precomp_qVPl5JAZn9aGyYMglLzks116",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49964.31, 49981]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "NNvNFAo4uuJIxbFFCT9Xd"
	  }, {
	    ddd: 0,
	    ind: 118,
	    ty: 0,
	    nm: "",
	    ln: "precomp_R5iTOp_ZO8wUrzKKYb1ta118",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49934, 49981]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "KQwm-LgbPDi3x_uA5aKrm"
	  }, {
	    ddd: 0,
	    ind: 120,
	    ty: 0,
	    nm: "",
	    ln: "precomp_RDrd3OzMJQLFJAJFwsPb4120",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50008, 49994]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "0NC-yuc5tFr60sVEKCa6s"
	  }, {
	    ddd: 0,
	    ind: 122,
	    ty: 0,
	    nm: "",
	    ln: "precomp_ittukn8PPUAw_5iXNTmHG122",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49878.75, 49983.25]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "5uFiCLYj4jiyugsNVeCcu"
	  }, {
	    ddd: 0,
	    ind: 131,
	    ty: 0,
	    nm: "",
	    ln: "precomp_RhKv9LCdMHX1gUMxVQSQR131",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50016, 50002]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "w-sBRh7CPk2D5bd8yMSxD"
	  }, {
	    ddd: 0,
	    ind: 140,
	    ty: 0,
	    nm: "",
	    ln: "precomp_tjnR7IqKOXwSyQEAK5CuF140",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "CQXcj-dzfXhtUXwfRB9p0"
	  }, {
	    ddd: 0,
	    ind: 141,
	    ty: 0,
	    nm: "",
	    ln: "precomp_erSr2EWDe2C_N85ePO5Uk141",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "EZwQu0pOd8V-6xISyaE0J"
	  }]
	}, {
	  id: "WKntxjxab4btwCsCOexwV",
	  layers: []
	}, {
	  id: "FWmkVqtd6URyhyYWWaMa0",
	  layers: []
	}, {
	  id: "JeZqylgpVIgndqC2JuNDW",
	  layers: [{
	    ddd: 0,
	    ind: 152,
	    ty: 4,
	    nm: "",
	    ln: "d3oiFs9EdtmM2gcFgFSnx152",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49988, 49988]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [133.33, 133.33]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      nm: "surface1126",
	      it: [{
	        ty: "gr",
	        it: [{
	          ty: "sh",
	          d: 1,
	          ks: {
	            a: 0,
	            k: {
	              c: true,
	              i: [[0, 0], [0, 0], [0, -1.14], [0, 0], [1.14, 0], [0, 0], [0, 1.14], [0, 0], [-1.14, 0]],
	              o: [[0, 0], [1.14, 0], [0, 0], [0, 1.14], [0, 0], [-1.14, 0], [0, 0], [0, -1.14], [0, 0]],
	              v: [[2.31, 0.25], [15.69, 0.25], [17.75, 2.31], [17.75, 15.69], [15.69, 17.75], [2.31, 17.75], [0.25, 15.69], [0.25, 2.31], [2.31, 0.25]]
	            }
	          }
	        }, {
	          ty: "sh",
	          d: 1,
	          ks: {
	            a: 0,
	            k: {
	              c: true,
	              i: [[0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0]],
	              o: [[0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0]],
	              v: [[2.89, 15.07], [15.15, 15.07], [15.15, 14.13], [11.88, 10.36], [10.25, 12.24], [6.16, 7.52], [2.89, 11.3]]
	            }
	          }
	        }, {
	          ty: "sh",
	          d: 1,
	          ks: {
	            a: 0,
	            k: {
	              c: true,
	              i: [[0, 0], [0, 0.87], [0.88, 0], [0, -0.87], [-0.87, 0]],
	              o: [[0.88, 0], [0, -0.87], [-0.87, 0], [0, 0.87], [0, 0]],
	              v: [[12.37, 7.17], [13.95, 5.59], [12.37, 4], [10.79, 5.59], [12.37, 7.17]]
	            }
	          }
	        }, {
	          ty: "fl",
	          c: {
	            a: 0,
	            k: [1, 1, 1, 1]
	          },
	          r: 2,
	          o: {
	            a: 0,
	            k: 100
	          }
	        }, {
	          ty: "tr",
	          nm: "Transform",
	          a: {
	            a: 0,
	            k: [0, 0]
	          },
	          o: {
	            a: 0,
	            k: 100
	          },
	          p: {
	            a: 0,
	            k: [0, 0]
	          },
	          r: {
	            a: 0,
	            k: 0
	          },
	          s: {
	            a: 0,
	            k: [100, 100]
	          },
	          sk: {
	            a: 0,
	            k: 0
	          },
	          sa: {
	            a: 0,
	            k: 0
	          }
	        }]
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }]
	    }]
	  }]
	}, {
	  id: "ZlUb7eu4_ntwbZsvOiorN",
	  layers: [{
	    ddd: 0,
	    ind: 154,
	    ty: 4,
	    nm: "",
	    ln: "PfsiGH10aTm_PSiqQzh36154",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [24, 24]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0, 0, 0]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "0aWPMYHYpayzhfchsO3kd",
	  layers: [{
	    ddd: 0,
	    ind: 153,
	    ty: 0,
	    nm: "",
	    td: 1,
	    ln: "precomp_acG31-07WzIa1lBHRD9wi153",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "ZlUb7eu4_ntwbZsvOiorN"
	  }, {
	    ddd: 0,
	    ind: 151,
	    ty: 0,
	    nm: "",
	    tt: 1,
	    ln: "precomp_d8nNrVR5JyrkrYeJHjidZ151",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "JeZqylgpVIgndqC2JuNDW"
	  }]
	}, {
	  id: "3-AE5UZaS8tZ6716Y0wuq",
	  layers: []
	}, {
	  id: "Ud-7patC8sE_23B1OqNM6",
	  layers: []
	}, {
	  id: "_kBOnUi5rCY5hU4KSEYS_",
	  layers: [{
	    ddd: 0,
	    ind: 149,
	    ty: 0,
	    nm: "",
	    ln: "precomp_zcxp3kiNf2L7A7D5OOUGY149",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "FWmkVqtd6URyhyYWWaMa0"
	  }, {
	    ddd: 0,
	    ind: 150,
	    ty: 0,
	    nm: "",
	    ln: "precomp_d8nNrVR5JyrkrYeJHjidZ150",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "0aWPMYHYpayzhfchsO3kd"
	  }, {
	    ddd: 0,
	    ind: 155,
	    ty: 0,
	    nm: "",
	    ln: "precomp_mFEOnUS7FQT3YY89lCtMV155",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "3-AE5UZaS8tZ6716Y0wuq"
	  }, {
	    ddd: 0,
	    ind: 156,
	    ty: 0,
	    nm: "",
	    ln: "precomp_Jtkb7myIM5MD_PEjGZ5jc156",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "Ud-7patC8sE_23B1OqNM6"
	  }]
	}, {
	  id: "7ImImrjIKjnQailO8QChC",
	  layers: [{
	    ddd: 0,
	    ind: 148,
	    ty: 0,
	    nm: "",
	    ln: "precomp_WAVkzi-yPCSHbJRrkTYlW148",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "_kBOnUi5rCY5hU4KSEYS_"
	  }]
	}, {
	  id: "uhaGQLTacmNRb-NFyYTWE",
	  layers: [{
	    ddd: 0,
	    ind: 158,
	    ty: 4,
	    nm: "",
	    ln: "3uw4jKW8VxwnE7ZaIcyAM158",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [40, 40]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0, 0, 0]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "vgJsSCFWy3fXi5R5Nk8ZI",
	  layers: [{
	    ddd: 0,
	    ind: 157,
	    ty: 0,
	    nm: "",
	    td: 1,
	    ln: "precomp_ZJJSogCLosY5SquqrDhPi157",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "uhaGQLTacmNRb-NFyYTWE"
	  }, {
	    ddd: 0,
	    ind: 147,
	    ty: 0,
	    nm: "",
	    tt: 1,
	    ln: "precomp_deNm7TFQ2P_m0FAm0PTMx147",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "7ImImrjIKjnQailO8QChC"
	  }]
	}, {
	  id: "DnZRTxCD7dd05svBhwutt",
	  layers: []
	}, {
	  id: "CqEkrRNm4Cc--nZANSGw6",
	  layers: [{
	    ddd: 0,
	    ind: 145,
	    ty: 0,
	    nm: "",
	    ln: "precomp_SaZ3ztLsr5269xJuqRloL145",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "WKntxjxab4btwCsCOexwV"
	  }, {
	    ddd: 0,
	    ind: 146,
	    ty: 0,
	    nm: "",
	    ln: "precomp_deNm7TFQ2P_m0FAm0PTMx146",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "vgJsSCFWy3fXi5R5Nk8ZI"
	  }, {
	    ddd: 0,
	    ind: 159,
	    ty: 0,
	    nm: "",
	    ln: "precomp_IgleaO26M_1BjSd8WAzPO159",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "DnZRTxCD7dd05svBhwutt"
	  }]
	}, {
	  id: "4uuznY_qkh4Ml31pGb2bG",
	  layers: [{
	    ddd: 0,
	    ind: 161,
	    ty: 4,
	    nm: "",
	    ln: "3vV07VuS3iAiK0M7SAQZ8161",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 6
	        },
	        s: {
	          a: 0,
	          k: [227.72, 56.33]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0.2, 0.91, 0.87]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "wVYDl6PhyQtFN6ANxBbPM",
	  layers: []
	}, {
	  id: "Vymhhl7aOEyCqSOAQZTMy",
	  layers: []
	}, {
	  id: "4Y9oHRN8H1DLm-lmf2CyH",
	  layers: [{
	    ddd: 0,
	    ind: 144,
	    ty: 0,
	    nm: "",
	    ln: "precomp_wafne4kwspTVcuEcdeeFP144",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50001.14, 50001]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "CqEkrRNm4Cc--nZANSGw6"
	  }, {
	    ddd: 0,
	    ind: 160,
	    ty: 0,
	    nm: "",
	    ln: "precomp_tjNYi5piFL-j-UbV5L9z-160",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 30
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "4uuznY_qkh4Ml31pGb2bG"
	  }, {
	    ddd: 0,
	    ind: 162,
	    ty: 0,
	    nm: "",
	    ln: "precomp_10HKBsfvLWkbhOAc2FmMW162",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "wVYDl6PhyQtFN6ANxBbPM"
	  }, {
	    ddd: 0,
	    ind: 163,
	    ty: 0,
	    nm: "",
	    ln: "precomp_k45aB3KfiFraAbV888_DL163",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "Vymhhl7aOEyCqSOAQZTMy"
	  }]
	}, {
	  id: "SABKhAibW0ZxLUeLgLe4Z",
	  layers: []
	}, {
	  id: "PAE-YMQ1ch2atlbO8bZNL",
	  layers: []
	}, {
	  id: "IZ7yKI19OstGi2fnMAWD4",
	  layers: [{
	    ddd: 0,
	    ind: 165,
	    ty: 0,
	    nm: "",
	    ln: "precomp_ES7nYu9RpIwPFJdxFByL6165",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "SABKhAibW0ZxLUeLgLe4Z"
	  }, {
	    ddd: 0,
	    ind: 166,
	    ty: 0,
	    nm: "",
	    ln: "precomp_YznA3Sb0s3ovawWs4ncZG166",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "PAE-YMQ1ch2atlbO8bZNL"
	  }]
	}, {
	  id: "IrfaoR76v08TTh5Dmap5r",
	  layers: [{
	    ddd: 0,
	    ind: 168,
	    ty: 4,
	    nm: "",
	    ln: "2CAxuUX4Gh_16wAuTvZtV168",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 53
	        },
	        s: {
	          a: 0,
	          k: [17, 4]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0.02, 0.71, 0.67]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "IFUafPCOFC-GiEm90Y830",
	  layers: [{
	    ddd: 0,
	    ind: 170,
	    ty: 4,
	    nm: "",
	    ln: "_dHF5PCtf2lcEz13T79el170",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 53
	        },
	        s: {
	          a: 0,
	          k: [79, 4]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0.02, 0.71, 0.67]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "CAXsJDQX3ziwAfZn2OvYv",
	  layers: []
	}, {
	  h: 39,
	  id: "4wccn49kc2mkQxCXNyiQi",
	  p: "data:image/png;base64,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",
	  u: "",
	  w: 39,
	  e: 1
	}, {
	  id: "ZHSQLOJKNPkGNHJQPJUNy",
	  layers: [{
	    ddd: 0,
	    ind: 175,
	    ty: 2,
	    nm: "",
	    ln: "4wccn49kc2mkQxCXNyiQi175",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49980.75, 49980.75]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "4wccn49kc2mkQxCXNyiQi"
	  }]
	}, {
	  id: "tHhVDnx08M50N2uW-klBF",
	  layers: [{
	    ddd: 0,
	    ind: 177,
	    ty: 4,
	    nm: "",
	    ln: "n0SRN5b7xReAMxDso_nOo177",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [38.5, 38.5]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0, 0, 0]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "V3mvVvOkk6e69og6r-O7R",
	  layers: [{
	    ddd: 0,
	    ind: 176,
	    ty: 0,
	    nm: "",
	    td: 1,
	    ln: "precomp_c2JLhF0N2OZYbjjAGWQSU176",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "tHhVDnx08M50N2uW-klBF"
	  }, {
	    ddd: 0,
	    ind: 174,
	    ty: 0,
	    nm: "",
	    tt: 1,
	    ln: "precomp_P6GKW5Eirubaa7E5rdoUj174",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "ZHSQLOJKNPkGNHJQPJUNy"
	  }]
	}, {
	  id: "Wrmd9toX_MrUEPgg9tl4R",
	  layers: []
	}, {
	  id: "-6ymk48YBRnP3opSR9ypl",
	  layers: []
	}, {
	  id: "odSozBoZVjuiAEPBwq7IX",
	  layers: [{
	    ddd: 0,
	    ind: 172,
	    ty: 0,
	    nm: "",
	    ln: "precomp_xL6ScShRNWQadeyD_E2T6172",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "CAXsJDQX3ziwAfZn2OvYv"
	  }, {
	    ddd: 0,
	    ind: 173,
	    ty: 0,
	    nm: "",
	    ln: "precomp_P6GKW5Eirubaa7E5rdoUj173",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "V3mvVvOkk6e69og6r-O7R"
	  }, {
	    ddd: 0,
	    ind: 178,
	    ty: 0,
	    nm: "",
	    ln: "precomp_s_nxfd2GMuTp_oWSbbIup178",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "Wrmd9toX_MrUEPgg9tl4R"
	  }, {
	    ddd: 0,
	    ind: 179,
	    ty: 0,
	    nm: "",
	    ln: "precomp_VEzw8djOAM5QQk6YYGcXl179",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "-6ymk48YBRnP3opSR9ypl"
	  }]
	}, {
	  id: "no3q6ury3nORPqa_8AU1R",
	  layers: []
	}, {
	  h: 110,
	  id: "BZj7WtrCemsULNH5kLFwa",
	  p: "data:image/png;base64,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",
	  u: "",
	  w: 267,
	  e: 1
	}, {
	  id: "Q64Lb8uYapWWEk3pB-2R4",
	  layers: [{
	    ddd: 0,
	    ind: 184,
	    ty: 2,
	    nm: "",
	    ln: "BZj7WtrCemsULNH5kLFwa184",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49866.5, 49945]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "BZj7WtrCemsULNH5kLFwa"
	  }]
	}, {
	  id: "ThBgEdY1dq7k_HMvOLRfU",
	  layers: [{
	    ddd: 0,
	    ind: 186,
	    ty: 4,
	    nm: "",
	    ln: "kn1se59kIFYQSEVDvDRnR186",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [267, 110]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0, 0, 0]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "0uTH8or7K0iPunRVSVMBh",
	  layers: [{
	    ddd: 0,
	    ind: 185,
	    ty: 0,
	    nm: "",
	    td: 1,
	    ln: "precomp_RdY3y7MF_yiZp47Kqhgp0185",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "ThBgEdY1dq7k_HMvOLRfU"
	  }, {
	    ddd: 0,
	    ind: 183,
	    ty: 0,
	    nm: "",
	    tt: 1,
	    ln: "precomp_F21OTzs8MWiZJahFQ0-fI183",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "Q64Lb8uYapWWEk3pB-2R4"
	  }]
	}, {
	  id: "-WQkNVjjtT6sLVNm0o_a_",
	  layers: []
	}, {
	  id: "XMTWvdd39BCbXagMAKwiK",
	  layers: []
	}, {
	  id: "kbYsraQvOUUTKHju7GaZx",
	  layers: [{
	    ddd: 0,
	    ind: 181,
	    ty: 0,
	    nm: "",
	    ln: "precomp_tqsr62pIYM5Pb-H_3ic5g181",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "no3q6ury3nORPqa_8AU1R"
	  }, {
	    ddd: 0,
	    ind: 182,
	    ty: 0,
	    nm: "",
	    ln: "precomp_F21OTzs8MWiZJahFQ0-fI182",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "0uTH8or7K0iPunRVSVMBh"
	  }, {
	    ddd: 0,
	    ind: 187,
	    ty: 0,
	    nm: "",
	    ln: "precomp_mJ1apo0-gcQZQKgjalo0M187",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "-WQkNVjjtT6sLVNm0o_a_"
	  }, {
	    ddd: 0,
	    ind: 188,
	    ty: 0,
	    nm: "",
	    ln: "precomp_eLSg-98RWxlHe3UiAYgt7188",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "XMTWvdd39BCbXagMAKwiK"
	  }]
	}, {
	  id: "9S0fasuOB6egZzxlPOQPr",
	  layers: []
	}, {
	  id: "oj6Io1jYHt9mXXHtBonC3",
	  layers: []
	}, {
	  id: "raESU4HI_WBvduSf8g4jC",
	  layers: [{
	    ddd: 0,
	    ind: 143,
	    ty: 0,
	    nm: "",
	    ln: "precomp_d-Dawoby6_IsBdX4-pfgR143",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50017.78, 49992.32]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "4Y9oHRN8H1DLm-lmf2CyH"
	  }, {
	    ddd: 0,
	    ind: 164,
	    ty: 0,
	    nm: "",
	    ln: "precomp_2f4Nq_SgyPYFPvfWpewYQ164",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49931.5, 50001.58]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "IZ7yKI19OstGi2fnMAWD4"
	  }, {
	    ddd: 0,
	    ind: 167,
	    ty: 0,
	    nm: "",
	    ln: "precomp_2y3Th-vZEGipcyI2C01pH167",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 70
	      },
	      p: {
	        a: 0,
	        k: [49916.5, 50034]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "IrfaoR76v08TTh5Dmap5r"
	  }, {
	    ddd: 0,
	    ind: 169,
	    ty: 0,
	    nm: "",
	    ln: "precomp_tMhF31I52FzY3H9kqySnQ169",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 70
	      },
	      p: {
	        a: 0,
	        k: [49969.5, 50034]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "IFUafPCOFC-GiEm90Y830"
	  }, {
	    ddd: 0,
	    ind: 171,
	    ty: 0,
	    nm: "",
	    ln: "precomp_D8zxLmH3WwDkbl7YE-lbY171",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49868.25, 49966.25]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "odSozBoZVjuiAEPBwq7IX"
	  }, {
	    ddd: 0,
	    ind: 180,
	    ty: 0,
	    nm: "",
	    ln: "precomp_acoZ5T24S2XfdWmrxTEYV180",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50015.5, 50002]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "kbYsraQvOUUTKHju7GaZx"
	  }, {
	    ddd: 0,
	    ind: 189,
	    ty: 0,
	    nm: "",
	    ln: "precomp_xg-P1dnLJvgztJDMU6WVG189",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "9S0fasuOB6egZzxlPOQPr"
	  }, {
	    ddd: 0,
	    ind: 190,
	    ty: 0,
	    nm: "",
	    ln: "precomp_IbXkZ6ScAOqtG_4YblXOV190",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "oj6Io1jYHt9mXXHtBonC3"
	  }]
	}, {
	  id: "ce4yFgy-Y3XTVApusl1Dq",
	  layers: []
	}, {
	  h: 200,
	  id: "BIsY6R-PtMTJVhMAhn_XN",
	  p: "data:image/png;base64,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",
	  u: "",
	  w: 428,
	  e: 1
	}, {
	  id: "vZ3pLxlJlv0fW2HJOg3TP",
	  layers: [{
	    ddd: 0,
	    ind: 195,
	    ty: 2,
	    nm: "",
	    ln: "BIsY6R-PtMTJVhMAhn_XN195",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49786, 49900]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "BIsY6R-PtMTJVhMAhn_XN"
	  }]
	}, {
	  id: "n8N0hSmLBykcviG2PcjMj",
	  layers: [{
	    ddd: 0,
	    ind: 197,
	    ty: 4,
	    nm: "",
	    ln: "oLY2RmJMcA5wGYg_ZLkxo197",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [428, 200]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0, 0, 0]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "_WmmXSuedYE2HZ3PPwGxI",
	  layers: [{
	    ddd: 0,
	    ind: 196,
	    ty: 0,
	    nm: "",
	    td: 1,
	    ln: "precomp_oMvhutzhnshhrBuFoXeDC196",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "n8N0hSmLBykcviG2PcjMj"
	  }, {
	    ddd: 0,
	    ind: 194,
	    ty: 0,
	    nm: "",
	    tt: 1,
	    ln: "precomp_zGDILq90CcAM9dzArnot_194",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "vZ3pLxlJlv0fW2HJOg3TP"
	  }]
	}, {
	  id: "zuKw514FIuXI9kj4Z7yzt",
	  layers: []
	}, {
	  id: "uaP4NTbU0_O361ixdYgaE",
	  layers: []
	}, {
	  id: "KzjjVG3JbFbGH4P_yRR31",
	  layers: [{
	    ddd: 0,
	    ind: 192,
	    ty: 0,
	    nm: "",
	    ln: "precomp_pMqHejJh2YJDFgDea762H192",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "ce4yFgy-Y3XTVApusl1Dq"
	  }, {
	    ddd: 0,
	    ind: 193,
	    ty: 0,
	    nm: "",
	    ln: "precomp_zGDILq90CcAM9dzArnot_193",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "_WmmXSuedYE2HZ3PPwGxI"
	  }, {
	    ddd: 0,
	    ind: 198,
	    ty: 0,
	    nm: "",
	    ln: "precomp_Xyt0qQt370V38BchcNJv2198",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "zuKw514FIuXI9kj4Z7yzt"
	  }, {
	    ddd: 0,
	    ind: 199,
	    ty: 0,
	    nm: "",
	    ln: "precomp_TiCdEiOfdzBPiz1qstSlh199",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "uaP4NTbU0_O361ixdYgaE"
	  }]
	}, {
	  id: "T2Wo9YjiQWOuQ2XVJpz7w",
	  layers: []
	}, {
	  id: "BnQCV8mrmThH3Z0hYmePn",
	  layers: []
	}, {
	  id: "JdAp0MWiUXFdMBoa7kHAW",
	  layers: [{
	    ddd: 0,
	    ind: 102,
	    ty: 0,
	    nm: "",
	    ln: "precomp_IOQNUw2SRtRxBfqLMl2v0102",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 1,
	        k: [{
	          t: 0,
	          s: [100],
	          h: 1
	        }, {
	          t: 0,
	          s: [0],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 0,
	          s: [0],
	          h: 1
	        }, {
	          t: 37.8,
	          s: [0],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 61.8,
	          s: [100],
	          h: 1
	        }, {
	          t: 72,
	          s: [100],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 90,
	          s: [0],
	          h: 1
	        }]
	      },
	      p: {
	        a: 1,
	        k: [{
	          t: 0,
	          s: [50020.5, 50054],
	          h: 1
	        }, {
	          t: 0,
	          s: [50020.5, 50086],
	          i: {
	            x: 0,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 0,
	          s: [50020.5, 50086],
	          h: 1
	        }, {
	          t: 37.8,
	          s: [50020.5, 50086],
	          i: {
	            x: 0,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 61.8,
	          s: [50020.5, 50054],
	          h: 1
	        }, {
	          t: 72,
	          s: [50020.5, 50054],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 1,
	            y: 0
	          }
	        }, {
	          t: 90,
	          s: [50052.5, 50054],
	          h: 1
	        }]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "xC5Li4LkvpYyklBDBnkOO"
	  }, {
	    ddd: 0,
	    ind: 142,
	    ty: 0,
	    nm: "",
	    ln: "precomp_P2DzJdOE11sM4KcBtgF8L142",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 1,
	        k: [{
	          t: 0,
	          s: [100],
	          h: 1
	        }, {
	          t: 0,
	          s: [0],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 0,
	          s: [0],
	          h: 1
	        }, {
	          t: 11.4,
	          s: [0],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 35.4,
	          s: [100],
	          h: 1
	        }, {
	          t: 72,
	          s: [100],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 90,
	          s: [0],
	          h: 1
	        }]
	      },
	      p: {
	        a: 1,
	        k: [{
	          t: 0,
	          s: [49972, 49962],
	          h: 1
	        }, {
	          t: 0,
	          s: [49972, 50011],
	          i: {
	            x: 0,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 0,
	          s: [49972, 50011],
	          h: 1
	        }, {
	          t: 11.4,
	          s: [49972, 50011],
	          i: {
	            x: 0,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 35.4,
	          s: [49972, 49962],
	          h: 1
	        }, {
	          t: 72,
	          s: [49972, 49962],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 1,
	            y: 0
	          }
	        }, {
	          t: 90,
	          s: [49923, 49962],
	          h: 1
	        }]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "raESU4HI_WBvduSf8g4jC"
	  }, {
	    ddd: 0,
	    ind: 191,
	    ty: 0,
	    nm: "",
	    ln: "precomp_khdwyBLEYXxWkvWfgFFPd191",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "KzjjVG3JbFbGH4P_yRR31"
	  }, {
	    ddd: 0,
	    ind: 200,
	    ty: 0,
	    nm: "",
	    ln: "precomp_2RDWpS3TFFvH2mn16abmP200",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "T2Wo9YjiQWOuQ2XVJpz7w"
	  }, {
	    ddd: 0,
	    ind: 201,
	    ty: 0,
	    nm: "",
	    ln: "precomp_zxfQdngl1wh80HYMzAJ7P201",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 121,
	    st: 0,
	    bm: 0,
	    refId: "BnQCV8mrmThH3Z0hYmePn"
	  }]
	}];
	var ddd$3 = 0;
	var fr$3 = 60;
	var h$3 = 200;
	var ip$3 = 0;
	var layers$3 = [{
	  ddd: 0,
	  ind: 101,
	  ty: 0,
	  nm: "",
	  ln: "precomp_r2Hju1Zq-ErAPtYVHvWED101",
	  sr: 1,
	  ks: {
	    a: {
	      a: 0,
	      k: [50000, 50000]
	    },
	    o: {
	      a: 0,
	      k: 100
	    },
	    p: {
	      a: 0,
	      k: [214, 100]
	    },
	    r: {
	      a: 0,
	      k: 0
	    },
	    s: {
	      a: 0,
	      k: [100, 100]
	    },
	    sk: {
	      a: 0,
	      k: 0
	    },
	    sa: {
	      a: 0,
	      k: 0
	    }
	  },
	  ao: 0,
	  w: 100000,
	  h: 100000,
	  ip: 0,
	  op: 121,
	  st: 0,
	  bm: 0,
	  refId: "JdAp0MWiUXFdMBoa7kHAW"
	}];
	var meta$3 = {
	  g: "https://jitter.video"
	};
	var nm$3 = "Unnamed-file";
	var op$3 = 120;
	var v$3 = "5.7.4";
	var w$3 = 428;
	var GroupChatAnimation = {
	  assets: assets$3,
	  ddd: ddd$3,
	  fr: fr$3,
	  h: h$3,
	  ip: ip$3,
	  layers: layers$3,
	  meta: meta$3,
	  nm: nm$3,
	  op: op$3,
	  v: v$3,
	  w: w$3
	};

	// @vue/component
	const GroupChatPromo = {
	  components: {
	    PromoPopup,
	    MessengerButton: Button
	  },
	  emits: ['continue', 'close'],
	  data() {
	    return {};
	  },
	  computed: {
	    ButtonColor: () => ButtonColor,
	    ButtonSize: () => ButtonSize
	  },
	  mounted() {
	    ui_lottie.Lottie.loadAnimation({
	      animationData: GroupChatAnimation,
	      container: this.$refs.animationContainer,
	      renderer: 'svg',
	      loop: true,
	      autoplay: true
	    });
	  },
	  methods: {
	    loc(phraseCode) {
	      return this.$Bitrix.Loc.getMessage(phraseCode);
	    }
	  },
	  template: `
		<PromoPopup @close="$emit('close')">
			<div class="bx-im-group-chat-promo__container">
				<div class="bx-im-group-chat-promo__header">
					<div class="bx-im-group-chat-promo__title">
						{{ loc('IM_ELEMENTS_CREATE_CHAT_PROMO_CHAT_TITLE') }}
					</div>
					<div class="bx-im-group-chat-promo__close" @click="$emit('close')"></div>
				</div>
				<div class="bx-im-group-chat-promo__content">
					<div class="bx-im-group-chat-promo__content_image" ref="animationContainer"></div>
					<div class="bx-im-group-chat-promo__content_item">
						<div class="bx-im-group-chat-promo__content_icon --like-blue"></div>
						<div class="bx-im-group-chat-promo__content_text">
							{{ loc('IM_ELEMENTS_CREATE_CHAT_PROMO_CHAT_DESCRIPTION_1') }}
						</div>
					</div>
					<div class="bx-im-group-chat-promo__content_item">
						<div class="bx-im-group-chat-promo__content_icon --chat"></div>
						<div class="bx-im-group-chat-promo__content_text">
							{{ loc('IM_ELEMENTS_CREATE_CHAT_PROMO_CHAT_DESCRIPTION_2') }}
						</div>
					</div>
					<div class="bx-im-group-chat-promo__content_item">
						<div class="bx-im-group-chat-promo__content_icon --group"></div>
						<div class="bx-im-group-chat-promo__content_text">
							{{ loc('IM_ELEMENTS_CREATE_CHAT_PROMO_CHAT_DESCRIPTION_3') }}
						</div>
					</div>
				</div>
				<div class="bx-im-group-chat-promo__separator"></div>
				<div class="bx-im-group-chat-promo__button-panel">
					<MessengerButton
						:size="ButtonSize.XL"
						:color="ButtonColor.Primary"
						:isRounded="true" 
						:text="loc('IM_ELEMENTS_CREATE_CHAT_PROMO_BUTTON_CONTINUE')"
						@click="$emit('continue')"
					/>
					<MessengerButton
						:size="ButtonSize.XL"
						:color="ButtonColor.Link"
						:isRounded="true"
						:text="loc('IM_ELEMENTS_CREATE_CHAT_PROMO_BUTTON_CANCEL')"
						@click="$emit('close')"
					/>
				</div>
			</div>
		</PromoPopup>
	`
	};

	var assets$4 = [{
	  id: "aQGnT3I3eLUUW-pP3-yTx",
	  layers: []
	}, {
	  id: "eZfXh4__Gwk0wJhub5bEh",
	  layers: [{
	    ddd: 0,
	    ind: 184,
	    ty: 4,
	    nm: "",
	    ln: "FthDLExVgG0izVF3xrEb0184",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49974.5, 49992.5]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [133.33, 133.33]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      nm: "surface951",
	      it: [{
	        ty: "gr",
	        it: [{
	          ty: "gr",
	          it: [{
	            ty: "sh",
	            d: 1,
	            ks: {
	              a: 0,
	              k: {
	                c: true,
	                i: [[0, 0], [0.41, 0], [0, 0], [0, -1.66], [0, 0], [-1.66, 0], [0, 0], [0, 1.66]],
	                o: [[0, -0.41], [0, 0], [-1.66, 0], [0, 0], [0, 1.66], [0, 0], [1.66, 0], [0, 0]],
	                v: [[37.5, 0.75], [36.75, 0], [3, 0], [0, 3], [0, 8.25], [3, 11.25], [34.5, 11.25], [37.5, 8.25]]
	              }
	            }
	          }, {
	            ty: "fl",
	            c: {
	              a: 0,
	              k: [0.32, 0.36, 0.41, 1]
	            },
	            r: 1,
	            o: {
	              a: 0,
	              k: 10
	            }
	          }, {
	            ty: "tr",
	            nm: "Transform",
	            a: {
	              a: 0,
	              k: [0, 0]
	            },
	            o: {
	              a: 0,
	              k: 100
	            },
	            p: {
	              a: 0,
	              k: [0, 0]
	            },
	            r: {
	              a: 0,
	              k: 0
	            },
	            s: {
	              a: 0,
	              k: [100, 100]
	            },
	            sk: {
	              a: 0,
	              k: 0
	            },
	            sa: {
	              a: 0,
	              k: 0
	            }
	          }]
	        }, {
	          ty: "tr",
	          nm: "Transform",
	          a: {
	            a: 0,
	            k: [0, 0]
	          },
	          o: {
	            a: 0,
	            k: 100
	          },
	          p: {
	            a: 0,
	            k: [0, 0]
	          },
	          r: {
	            a: 0,
	            k: 0
	          },
	          s: {
	            a: 0,
	            k: [100, 100]
	          },
	          sk: {
	            a: 0,
	            k: 0
	          },
	          sa: {
	            a: 0,
	            k: 0
	          }
	        }]
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }]
	    }]
	  }]
	}, {
	  id: "JIIVbGurDMq_iQPl0T3Hi",
	  layers: [{
	    ddd: 0,
	    ind: 186,
	    ty: 4,
	    nm: "",
	    ln: "ewdBv5JEsIOJmlv7vHto7186",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [51, 15]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0, 0, 0]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "jzfBsuZPXr7l0IcdK4v8t",
	  layers: [{
	    ddd: 0,
	    ind: 185,
	    ty: 0,
	    nm: "",
	    td: 1,
	    ln: "precomp_BKkPinT1UsiMTYZ42EmNw185",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "JIIVbGurDMq_iQPl0T3Hi"
	  }, {
	    ddd: 0,
	    ind: 183,
	    ty: 0,
	    nm: "",
	    tt: 1,
	    ln: "precomp_-5zPi26hJQOLN2gzAWl8M183",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "eZfXh4__Gwk0wJhub5bEh"
	  }]
	}, {
	  id: "JjPQGu-ZHfGUEKU_aA83E",
	  layers: []
	}, {
	  id: "Wf4-hxd8m2Ul-E4aiYEi5",
	  layers: []
	}, {
	  id: "ziULq0QyFwV9liu_6NwM3",
	  layers: [{
	    ddd: 0,
	    ind: 181,
	    ty: 0,
	    nm: "",
	    ln: "precomp_G8ct7Rh9suQeLuYCN8Vbu181",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "aQGnT3I3eLUUW-pP3-yTx"
	  }, {
	    ddd: 0,
	    ind: 182,
	    ty: 0,
	    nm: "",
	    ln: "precomp_-5zPi26hJQOLN2gzAWl8M182",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "jzfBsuZPXr7l0IcdK4v8t"
	  }, {
	    ddd: 0,
	    ind: 187,
	    ty: 0,
	    nm: "",
	    ln: "precomp_OMdoVw9oqCesZdQXiG10l187",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "JjPQGu-ZHfGUEKU_aA83E"
	  }, {
	    ddd: 0,
	    ind: 188,
	    ty: 0,
	    nm: "",
	    ln: "precomp_lo3_F5S1B468s7MbKq0Pm188",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "Wf4-hxd8m2Ul-E4aiYEi5"
	  }]
	}, {
	  id: "3gQH_r4PIx1uWnzscOC8G",
	  layers: []
	}, {
	  id: "YETzw9NTnabuVrfevhHNO",
	  layers: [{
	    ddd: 0,
	    ind: 193,
	    ty: 4,
	    nm: "",
	    ln: "fOSYx8IbZwvUPijtAUKMP193",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49974, 49992.5]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [133.33, 133.33]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      nm: "surface946",
	      it: [{
	        ty: "gr",
	        it: [{
	          ty: "sh",
	          d: 1,
	          ks: {
	            a: 0,
	            k: {
	              c: true,
	              i: [[0, 0], [-0.41, 0], [0, 0], [0, -1.66], [0, 0], [1.66, 0], [0, 0], [0, 1.66]],
	              o: [[0, -0.41], [0, 0], [1.66, 0], [0, 0], [0, 1.66], [0, 0], [-1.66, 0], [0, 0]],
	              v: [[0, 0.75], [0.75, 0], [36, 0], [39, 3], [39, 8.25], [36, 11.25], [3, 11.25], [0, 8.25]]
	            }
	          }
	        }, {
	          ty: "fl",
	          c: {
	            a: 0,
	            k: [1, 1, 1, 1]
	          },
	          r: 1,
	          o: {
	            a: 0,
	            k: 100
	          }
	        }, {
	          ty: "tr",
	          nm: "Transform",
	          a: {
	            a: 0,
	            k: [0, 0]
	          },
	          o: {
	            a: 0,
	            k: 100
	          },
	          p: {
	            a: 0,
	            k: [0, 0]
	          },
	          r: {
	            a: 0,
	            k: 0
	          },
	          s: {
	            a: 0,
	            k: [100, 100]
	          },
	          sk: {
	            a: 0,
	            k: 0
	          },
	          sa: {
	            a: 0,
	            k: 0
	          }
	        }]
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }]
	    }]
	  }]
	}, {
	  id: "G18GXYfn8u09xMUiQAuM-",
	  layers: [{
	    ddd: 0,
	    ind: 195,
	    ty: 4,
	    nm: "",
	    ln: "YpFVrnzt8GmtidFwVQY_4195",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [52, 15]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0, 0, 0]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "700Mjynjneeh8hg_FTs9C",
	  layers: [{
	    ddd: 0,
	    ind: 194,
	    ty: 0,
	    nm: "",
	    td: 1,
	    ln: "precomp_eSFoxfJiHPHffinMBqZg6194",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "G18GXYfn8u09xMUiQAuM-"
	  }, {
	    ddd: 0,
	    ind: 192,
	    ty: 0,
	    nm: "",
	    tt: 1,
	    ln: "precomp_auicsxPbGPVo6aXzNealg192",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "YETzw9NTnabuVrfevhHNO"
	  }]
	}, {
	  id: "hMuurm-yzUze_x2O5AaIe",
	  layers: []
	}, {
	  id: "ewisD4v6XJiqiKKlCb4Fy",
	  layers: []
	}, {
	  id: "QD9970bZxIk98v65AQYar",
	  layers: [{
	    ddd: 0,
	    ind: 190,
	    ty: 0,
	    nm: "",
	    ln: "precomp_O47Jcae7q-DQve42ClDs5190",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "3gQH_r4PIx1uWnzscOC8G"
	  }, {
	    ddd: 0,
	    ind: 191,
	    ty: 0,
	    nm: "",
	    ln: "precomp_auicsxPbGPVo6aXzNealg191",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "700Mjynjneeh8hg_FTs9C"
	  }, {
	    ddd: 0,
	    ind: 196,
	    ty: 0,
	    nm: "",
	    ln: "precomp_z106v7FsW9-t0g06jdumG196",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "hMuurm-yzUze_x2O5AaIe"
	  }, {
	    ddd: 0,
	    ind: 197,
	    ty: 0,
	    nm: "",
	    ln: "precomp_N1fR-qVkV6A2x0LY8To12197",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "ewisD4v6XJiqiKKlCb4Fy"
	  }]
	}, {
	  id: "F8Hrm4mSKgqt5_55MCVO7",
	  layers: []
	}, {
	  id: "XEJ768Gn7PJNGZM6WY0ie",
	  layers: [{
	    ddd: 0,
	    ind: 202,
	    ty: 4,
	    nm: "",
	    ln: "1cDhjw0XXEp3VjrCHnOzH202",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49963.5, 49990]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [133.33, 133.33]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      nm: "surface941",
	      it: [{
	        ty: "gr",
	        it: [{
	          ty: "sh",
	          d: 1,
	          ks: {
	            a: 0,
	            k: {
	              c: true,
	              i: [[0, 0], [-0.41, 0], [0, 0], [0, -1.66], [0, 0], [1.66, 0], [0, 0], [0, 1.66]],
	              o: [[0, -0.41], [0, 0], [1.66, 0], [0, 0], [0, 1.66], [0, 0], [-1.66, 0], [0, 0]],
	              v: [[0, 0.75], [0.75, 0], [51.75, 0], [54.75, 3], [54.75, 12], [51.75, 15], [3, 15], [0, 12]]
	            }
	          }
	        }, {
	          ty: "fl",
	          c: {
	            a: 0,
	            k: [1, 1, 1, 1]
	          },
	          r: 1,
	          o: {
	            a: 0,
	            k: 100
	          }
	        }, {
	          ty: "tr",
	          nm: "Transform",
	          a: {
	            a: 0,
	            k: [0, 0]
	          },
	          o: {
	            a: 0,
	            k: 100
	          },
	          p: {
	            a: 0,
	            k: [0, 0]
	          },
	          r: {
	            a: 0,
	            k: 0
	          },
	          s: {
	            a: 0,
	            k: [100, 100]
	          },
	          sk: {
	            a: 0,
	            k: 0
	          },
	          sa: {
	            a: 0,
	            k: 0
	          }
	        }]
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }]
	    }]
	  }]
	}, {
	  id: "NqOKl34uayvBsSNYF6rPT",
	  layers: [{
	    ddd: 0,
	    ind: 204,
	    ty: 4,
	    nm: "",
	    ln: "dvFu0WD3f8eCDOTZZp9MW204",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [73, 20]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0, 0, 0]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "Hc5pd7CD8w-env_n5T2si",
	  layers: [{
	    ddd: 0,
	    ind: 203,
	    ty: 0,
	    nm: "",
	    td: 1,
	    ln: "precomp_bfvEKj2q2GTNT8IGS90MH203",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "NqOKl34uayvBsSNYF6rPT"
	  }, {
	    ddd: 0,
	    ind: 201,
	    ty: 0,
	    nm: "",
	    tt: 1,
	    ln: "precomp_9gYMrFEW14KCosjnr5Dbj201",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "XEJ768Gn7PJNGZM6WY0ie"
	  }]
	}, {
	  id: "HhgTpiPoKArJ6KJp_-lNd",
	  layers: []
	}, {
	  id: "9kRa7dFFUyROmxq5o1vVb",
	  layers: []
	}, {
	  id: "p1v-Ah-Jy_1Kb3k581RFW",
	  layers: [{
	    ddd: 0,
	    ind: 199,
	    ty: 0,
	    nm: "",
	    ln: "precomp_lZIb6JHN5cKEbCJ939rYf199",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "F8Hrm4mSKgqt5_55MCVO7"
	  }, {
	    ddd: 0,
	    ind: 200,
	    ty: 0,
	    nm: "",
	    ln: "precomp_9gYMrFEW14KCosjnr5Dbj200",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "Hc5pd7CD8w-env_n5T2si"
	  }, {
	    ddd: 0,
	    ind: 205,
	    ty: 0,
	    nm: "",
	    ln: "precomp_rZnd51CeC832gKIP3n_1x205",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "HhgTpiPoKArJ6KJp_-lNd"
	  }, {
	    ddd: 0,
	    ind: 206,
	    ty: 0,
	    nm: "",
	    ln: "precomp_OdGwMaMhPzI9kN0HX5Mi4206",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "9kRa7dFFUyROmxq5o1vVb"
	  }]
	}, {
	  id: "AhW5FUc3JqSf6ZBNPk9PU",
	  layers: []
	}, {
	  id: "UbK5aZR7Jt0Lm55Bo_qno",
	  layers: []
	}, {
	  id: "GvhdJW26OMxezeY79U1nI",
	  layers: [{
	    ddd: 0,
	    ind: 180,
	    ty: 0,
	    nm: "",
	    ln: "precomp_7LPoTtMUeiYpV4j7kEBmT180",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50015.5, 50002.5]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "ziULq0QyFwV9liu_6NwM3"
	  }, {
	    ddd: 0,
	    ind: 189,
	    ty: 0,
	    nm: "",
	    ln: "precomp_GrjzBFy_VXowif2wTIBOv189",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49986, 50021.5]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "QD9970bZxIk98v65AQYar"
	  }, {
	    ddd: 0,
	    ind: 198,
	    ty: 0,
	    nm: "",
	    ln: "precomp_LR8CFX2O2GPswnAvr0hEg198",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49996.5, 49981]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "p1v-Ah-Jy_1Kb3k581RFW"
	  }, {
	    ddd: 0,
	    ind: 207,
	    ty: 0,
	    nm: "",
	    ln: "precomp_tKm8ZTMGKtVTBS-jonkm9207",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "AhW5FUc3JqSf6ZBNPk9PU"
	  }, {
	    ddd: 0,
	    ind: 208,
	    ty: 0,
	    nm: "",
	    ln: "precomp_Qk5dM1ME53N2G16HL78p-208",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "UbK5aZR7Jt0Lm55Bo_qno"
	  }]
	}, {
	  id: "yjEOT9uzJzjtIxepiNswK",
	  layers: [{
	    ddd: 0,
	    ind: 213,
	    ty: 4,
	    nm: "",
	    ln: "X83tUulvScSgrXkGWu82Y213",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 53
	        },
	        s: {
	          a: 0,
	          k: [27, 3]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0.32, 0.36, 0.41]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 10.2
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "aRFdFhmPVIZ1SB4InQ_iL",
	  layers: []
	}, {
	  id: "so3Rk4RWYaepftDZSYmoY",
	  layers: []
	}, {
	  id: "QCsE60cbqsWY-_VWg0ZFB",
	  layers: [{
	    ddd: 0,
	    ind: 212,
	    ty: 0,
	    nm: "",
	    ln: "precomp_OGcDeOPXy-hO6bB8fwwd1212",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "yjEOT9uzJzjtIxepiNswK"
	  }, {
	    ddd: 0,
	    ind: 214,
	    ty: 0,
	    nm: "",
	    ln: "precomp_CZHhigd4slqtTxNP4MpgH214",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "aRFdFhmPVIZ1SB4InQ_iL"
	  }, {
	    ddd: 0,
	    ind: 215,
	    ty: 0,
	    nm: "",
	    ln: "precomp_6nj4DFiOGBV-kA0rRjNqC215",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "so3Rk4RWYaepftDZSYmoY"
	  }]
	}, {
	  id: "i21nqb7-SBEPwS7zHjATf",
	  layers: [{
	    ddd: 0,
	    ind: 217,
	    ty: 4,
	    nm: "",
	    ln: "t-sQP8yPherH9u3mr0YEs217",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "sh",
	        hd: false,
	        ix: 0,
	        ks: {
	          a: 0,
	          k: {
	            v: [[5.5, 0], [0, 5.5], [-5.5, 0], [0, -5.5], [5.5, 0]],
	            i: [[0, 0], [3.04, 0], [0, 3.04], [-3.04, 0], [0, -3.04]],
	            o: [[0, 3.04], [-3.04, 0], [0, -3.04], [3.04, 0], [0, 0]]
	          }
	        }
	      }, {
	        ty: "sh",
	        hd: false,
	        ix: 1,
	        ks: {
	          a: 0,
	          k: {
	            v: [[5.5, 0], [5.5, 0], [5.5, 0], [5.5, 0], [5.5, 0]],
	            i: [[0, 0], [0, 0], [0, 0], [0, 0], [0, 0]],
	            o: [[0, 0], [0, 0], [0, 0], [0, 0], [0, 0]]
	          }
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0.98, 0.43, 0.73]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "B89aRQr5qEG_025lEaNlp",
	  layers: []
	}, {
	  id: "2sJS5lDmAZWbvld11oC67",
	  layers: []
	}, {
	  id: "C4hEeeytXh8fMkGQIxJdc",
	  layers: [{
	    ddd: 0,
	    ind: 211,
	    ty: 0,
	    nm: "",
	    ln: "precomp_HzjvNpErVZEb9SsccJmRM211",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50008, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "QCsE60cbqsWY-_VWg0ZFB"
	  }, {
	    ddd: 0,
	    ind: 216,
	    ty: 0,
	    nm: "",
	    ln: "precomp_d6fVgpRova338r6WE_qYv216",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 45
	      },
	      p: {
	        a: 0,
	        k: [49984, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "i21nqb7-SBEPwS7zHjATf"
	  }, {
	    ddd: 0,
	    ind: 218,
	    ty: 0,
	    nm: "",
	    ln: "precomp_yhgV5tFHVGLwEzJWtdtSR218",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "B89aRQr5qEG_025lEaNlp"
	  }, {
	    ddd: 0,
	    ind: 219,
	    ty: 0,
	    nm: "",
	    ln: "precomp__fL7twT81ET1y1NQWLcx5219",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "2sJS5lDmAZWbvld11oC67"
	  }]
	}, {
	  id: "FBt-0YipqvvzGUeQfsWOq",
	  layers: [{
	    ddd: 0,
	    ind: 223,
	    ty: 4,
	    nm: "",
	    ln: "rIz0Ums1vUT_r8ul0QLPv223",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 53
	        },
	        s: {
	          a: 0,
	          k: [41, 3]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0.32, 0.36, 0.41]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 10.2
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "7Kwx6aSB4_hvxgFmIIrip",
	  layers: []
	}, {
	  id: "ka47LOByqyO1Z1LgDvg54",
	  layers: []
	}, {
	  id: "IwV2XMDUGnMMZcPtAGTH4",
	  layers: [{
	    ddd: 0,
	    ind: 222,
	    ty: 0,
	    nm: "",
	    ln: "precomp_RFi3xQq766VeRpyjlJej5222",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "FBt-0YipqvvzGUeQfsWOq"
	  }, {
	    ddd: 0,
	    ind: 224,
	    ty: 0,
	    nm: "",
	    ln: "precomp_w8cw58zOtZsP32gJ6UrnT224",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "7Kwx6aSB4_hvxgFmIIrip"
	  }, {
	    ddd: 0,
	    ind: 225,
	    ty: 0,
	    nm: "",
	    ln: "precomp_tOxVOAmuNMXvX-d9Y5Oyn225",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "ka47LOByqyO1Z1LgDvg54"
	  }]
	}, {
	  id: "-pfmVx2MA3Uk8OtyzDowd",
	  layers: [{
	    ddd: 0,
	    ind: 227,
	    ty: 4,
	    nm: "",
	    ln: "XyKU0eKjuvHPOjGccLHyH227",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "sh",
	        hd: false,
	        ix: 0,
	        ks: {
	          a: 0,
	          k: {
	            v: [[5.5, 0], [0, 5.5], [-5.5, 0], [0, -5.5], [5.5, 0]],
	            i: [[0, 0], [3.04, 0], [0, 3.04], [-3.04, 0], [0, -3.04]],
	            o: [[0, 3.04], [-3.04, 0], [0, -3.04], [3.04, 0], [0, 0]]
	          }
	        }
	      }, {
	        ty: "sh",
	        hd: false,
	        ix: 1,
	        ks: {
	          a: 0,
	          k: {
	            v: [[5.5, 0], [5.5, 0], [5.5, 0], [5.5, 0], [5.5, 0]],
	            i: [[0, 0], [0, 0], [0, 0], [0, 0], [0, 0]],
	            o: [[0, 0], [0, 0], [0, 0], [0, 0], [0, 0]]
	          }
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0.5, 0.87, 0.99]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "D_gZ4FCFof-AZuFmV2L_p",
	  layers: []
	}, {
	  id: "o04iX9xWG3AlNThvl3aJg",
	  layers: []
	}, {
	  id: "KOyumAUnMGS_gBuzI4onh",
	  layers: [{
	    ddd: 0,
	    ind: 221,
	    ty: 0,
	    nm: "",
	    ln: "precomp_lsClMh5ohnvzhV2xQvzZw221",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50008, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "IwV2XMDUGnMMZcPtAGTH4"
	  }, {
	    ddd: 0,
	    ind: 226,
	    ty: 0,
	    nm: "",
	    ln: "precomp_yujsa1ONvPgXPk7_sr1hP226",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49977, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "-pfmVx2MA3Uk8OtyzDowd"
	  }, {
	    ddd: 0,
	    ind: 228,
	    ty: 0,
	    nm: "",
	    ln: "precomp_YUiO3VFgeK0W6iVAJmztN228",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "D_gZ4FCFof-AZuFmV2L_p"
	  }, {
	    ddd: 0,
	    ind: 229,
	    ty: 0,
	    nm: "",
	    ln: "precomp_uYtiDjGAy67DzyDrYznu7229",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "o04iX9xWG3AlNThvl3aJg"
	  }]
	}, {
	  id: "QQWSFW13CIMWaaCARNYZI",
	  layers: [{
	    ddd: 0,
	    ind: 233,
	    ty: 4,
	    nm: "",
	    ln: "xnM46-kwcqcRUeYVptRlX233",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 53
	        },
	        s: {
	          a: 0,
	          k: [22, 3]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0.32, 0.36, 0.41]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 10.2
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "AX99qwVgLgvWpts_Js4ZY",
	  layers: []
	}, {
	  id: "1Z8vTJ2KDeTZcnLgfcnL6",
	  layers: []
	}, {
	  id: "u9VsO7-zPp0P0rCJRNHsW",
	  layers: [{
	    ddd: 0,
	    ind: 232,
	    ty: 0,
	    nm: "",
	    ln: "precomp_aqU4mCfneTAkNp1voDjrh232",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "QQWSFW13CIMWaaCARNYZI"
	  }, {
	    ddd: 0,
	    ind: 234,
	    ty: 0,
	    nm: "",
	    ln: "precomp_CwhD6Xe0jjh7kpJfQnHGP234",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "AX99qwVgLgvWpts_Js4ZY"
	  }, {
	    ddd: 0,
	    ind: 235,
	    ty: 0,
	    nm: "",
	    ln: "precomp_puXRWug9BEpgqlsJHG6wZ235",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "1Z8vTJ2KDeTZcnLgfcnL6"
	  }]
	}, {
	  id: "3cOJCIWKFjdBq6fQUezgV",
	  layers: [{
	    ddd: 0,
	    ind: 237,
	    ty: 4,
	    nm: "",
	    ln: "R40jx_AAfFa5dXiXng_CD237",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "sh",
	        hd: false,
	        ix: 0,
	        ks: {
	          a: 0,
	          k: {
	            v: [[5.5, 0], [0, 5.5], [-5.5, 0], [0, -5.5], [5.5, 0]],
	            i: [[0, 0], [3.04, 0], [0, 3.04], [-3.04, 0], [0, -3.04]],
	            o: [[0, 3.04], [-3.04, 0], [0, -3.04], [3.04, 0], [0, 0]]
	          }
	        }
	      }, {
	        ty: "sh",
	        hd: false,
	        ix: 1,
	        ks: {
	          a: 0,
	          k: {
	            v: [[5.5, 0], [5.5, 0], [5.5, 0], [5.5, 0], [5.5, 0]],
	            i: [[0, 0], [0, 0], [0, 0], [0, 0], [0, 0]],
	            o: [[0, 0], [0, 0], [0, 0], [0, 0], [0, 0]]
	          }
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0.73, 0.87, 0.3]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "1DqVOAnCnvyIf4Suvc7Yi",
	  layers: []
	}, {
	  id: "HXBqEqujRfVCZsxUKDLut",
	  layers: []
	}, {
	  id: "cXM4OyFyhgwcD6OSUbInf",
	  layers: [{
	    ddd: 0,
	    ind: 231,
	    ty: 0,
	    nm: "",
	    ln: "precomp_xL7eJzu7MC_BFvMD2dhP5231",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50008, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "u9VsO7-zPp0P0rCJRNHsW"
	  }, {
	    ddd: 0,
	    ind: 236,
	    ty: 0,
	    nm: "",
	    ln: "precomp_4-kJiFJxOV4eHtAkvPBvA236",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49986.5, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "3cOJCIWKFjdBq6fQUezgV"
	  }, {
	    ddd: 0,
	    ind: 238,
	    ty: 0,
	    nm: "",
	    ln: "precomp_tGHb2u3AZ3ZBj04UWNNWl238",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "1DqVOAnCnvyIf4Suvc7Yi"
	  }, {
	    ddd: 0,
	    ind: 239,
	    ty: 0,
	    nm: "",
	    ln: "precomp_f9ihxO1hGNTa3kzDkUkkq239",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "HXBqEqujRfVCZsxUKDLut"
	  }]
	}, {
	  id: "hIVu25ZpiL5KBPvP9a9jS",
	  layers: [{
	    ddd: 0,
	    ind: 243,
	    ty: 4,
	    nm: "",
	    ln: "f54X777zwOTMbdMdM3pgU243",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 53
	        },
	        s: {
	          a: 0,
	          k: [33, 3]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0.32, 0.36, 0.41]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 10.2
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "XF5I6ktkH_KqesuKIBURr",
	  layers: []
	}, {
	  id: "T17MpQDBObZy2PbTWfEhw",
	  layers: []
	}, {
	  id: "Hkk2Wkw4rHzsNRS9gLAkG",
	  layers: [{
	    ddd: 0,
	    ind: 242,
	    ty: 0,
	    nm: "",
	    ln: "precomp_4Y7nLBNA7TiwFJspTIA7p242",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "hIVu25ZpiL5KBPvP9a9jS"
	  }, {
	    ddd: 0,
	    ind: 244,
	    ty: 0,
	    nm: "",
	    ln: "precomp_hK3PBa3fgbIX5h7n13kA2244",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "XF5I6ktkH_KqesuKIBURr"
	  }, {
	    ddd: 0,
	    ind: 245,
	    ty: 0,
	    nm: "",
	    ln: "precomp_3kmg4lRy2cIfRa0o-ibaU245",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "T17MpQDBObZy2PbTWfEhw"
	  }]
	}, {
	  id: "n3S-xUdBOozn63OiHtLry",
	  layers: [{
	    ddd: 0,
	    ind: 247,
	    ty: 4,
	    nm: "",
	    ln: "MCfgtT_AEJnGzjwmyQcQr247",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "sh",
	        hd: false,
	        ix: 0,
	        ks: {
	          a: 0,
	          k: {
	            v: [[5.5, 0], [0, 5.5], [-5.5, 0], [0, -5.5], [5.5, 0]],
	            i: [[0, 0], [3.04, 0], [0, 3.04], [-3.04, 0], [0, -3.04]],
	            o: [[0, 3.04], [-3.04, 0], [0, -3.04], [3.04, 0], [0, 0]]
	          }
	        }
	      }, {
	        ty: "sh",
	        hd: false,
	        ix: 1,
	        ks: {
	          a: 0,
	          k: {
	            v: [[5.5, 0], [5.5, 0], [5.5, 0], [5.5, 0], [5.5, 0]],
	            i: [[0, 0], [0, 0], [0, 0], [0, 0], [0, 0]],
	            o: [[0, 0], [0, 0], [0, 0], [0, 0], [0, 0]]
	          }
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [1, 0.77, 0.3]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "3K0K8I5nwjWFuQxBqgmpf",
	  layers: []
	}, {
	  id: "B4Bi0-mw9wUkycqFPyY0W",
	  layers: []
	}, {
	  id: "E1sIm4sX1ItcJP2a0SSVo",
	  layers: [{
	    ddd: 0,
	    ind: 241,
	    ty: 0,
	    nm: "",
	    ln: "precomp_-ykmGdcPZdx2pMmEF3luH241",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50008, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "Hkk2Wkw4rHzsNRS9gLAkG"
	  }, {
	    ddd: 0,
	    ind: 246,
	    ty: 0,
	    nm: "",
	    ln: "precomp_QzX2aom8-KC1Tppha_BFu246",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49981, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "n3S-xUdBOozn63OiHtLry"
	  }, {
	    ddd: 0,
	    ind: 248,
	    ty: 0,
	    nm: "",
	    ln: "precomp_x3LC0r8w1wKsdqBk29MPF248",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "3K0K8I5nwjWFuQxBqgmpf"
	  }, {
	    ddd: 0,
	    ind: 249,
	    ty: 0,
	    nm: "",
	    ln: "precomp_qODguE-Ni8G6TqVoakTZH249",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "B4Bi0-mw9wUkycqFPyY0W"
	  }]
	}, {
	  id: "bvxGnYrPEOL7065QnK2Jl",
	  layers: []
	}, {
	  id: "QwypK2UPVw9huxfBo25P_",
	  layers: []
	}, {
	  id: "FbPlt8VHBKWY2zcJ6Ugp_",
	  layers: [{
	    ddd: 0,
	    ind: 210,
	    ty: 0,
	    nm: "",
	    ln: "precomp_lX8R2F1tRywqFKts5uEth210",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49993, 50021]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "C4hEeeytXh8fMkGQIxJdc"
	  }, {
	    ddd: 0,
	    ind: 220,
	    ty: 0,
	    nm: "",
	    ln: "precomp_EGrJ3_ii0cUHec-UtYwiS220",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50007]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "KOyumAUnMGS_gBuzI4onh"
	  }, {
	    ddd: 0,
	    ind: 230,
	    ty: 0,
	    nm: "",
	    ln: "precomp_xK6ttwY-ZHy-d5ued9eq8230",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49990.5, 49993]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "cXM4OyFyhgwcD6OSUbInf"
	  }, {
	    ddd: 0,
	    ind: 240,
	    ty: 0,
	    nm: "",
	    ln: "precomp_JCLvKq0-hR8gVg42hvMqV240",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49996, 49979]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "E1sIm4sX1ItcJP2a0SSVo"
	  }, {
	    ddd: 0,
	    ind: 250,
	    ty: 0,
	    nm: "",
	    ln: "precomp_M6KMdlXo-V1YwfiaDMnD1250",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "bvxGnYrPEOL7065QnK2Jl"
	  }, {
	    ddd: 0,
	    ind: 251,
	    ty: 0,
	    nm: "",
	    ln: "precomp_0iRJYsMi8YnK7MLXMI0WT251",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "QwypK2UPVw9huxfBo25P_"
	  }]
	}, {
	  id: "uzJdjC1IBwxbsB_i4lgVI",
	  layers: []
	}, {
	  h: 35,
	  id: "iLT9x7FHdRJ-Rz-po8XTr",
	  p: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAAXNSR0IArs4c6QAAEzNJREFUaEO9mgmQXNV1hr/b+94zPatmNDOSRkI7klgkhBAgMAYMmFTZjjGOXc5iFymylBMnTlVMYldiV+JylnIqcdlxsJ0iTkwoY8CLvABiN5sACUmjZTQazb70THdPT+/9bubc97qnJcBsrtypnu5+/d59979n+885T/FrHFprNxB1XiHAA/icW2igCFSARWBBKbXw67q9ercTaa1dwDrgUmAn0A/0AO1AEIg1AEkBeWAcGAFOAs8DjymlZt7NWt4VEK21LPxO4FZAJOB9m4sRKZWd19eAryilpt7mHOb0tw1Eax0B9izt6O8Cv/EOFv+r1ilS+TZwD3BUKSVq+JbG2wKitd64NOvngfcCTa+5g9ZUSiUqhQLlQhGrXMGq2mtRCtxeL8rtweMP4AsHcXnEhF53DAHfUUp94S2heKsS0VqLymwFHgBWNk6uLYtqpUI2maSQSmOVRVPshWutcIkFOYLXokjIP4189oZChFsS+CMR3AJKLjp3DAPXAkNKKetXgXpTiWitxVg/vWSkn3WM18yntSafzpCZnSGfTmNVyijlQinlrMeeuv5dazTKAJB/5k/LRwu3z0c4kSDW1oo/FD5/vYNLNvSXSqnvvVsgXwb+CPDXJpJdT09OUUinQVv2fhsAAsRefOMw3wWAkRJYVk0q2nzWWGhLG1WLtLUR6xCHd85IA3+glBLbed3xhhJxJPG5JZ//Z7UrRQqVfIHM+BhWpYKSP5nBgLCncrlk1+UXbR8HSsU8xXzWIFEuF6Fos5GoLRHzD8uyzGcB5guHiHd14QnU906mFjC/D9yrlKqej+Z1gWitJYj9FfCZRknkZpMU5lNGHWTBZmE1CbhsMObl3KVqWeRSScaGDjExcoyKpWntWMOFu27A5ZbYaaxlWd0sjaUd6Xi9hNta8UXESdbHmHhLpdRP3yqQi4AnG20iMznF4szs8mJdCrcBA8oFLiMDhcttrJt8NsPYyEnmRg4zfHaAXG6RUlWTLVa57TfvJNHVj9cfNConG2OrnICwjBZaVXnXJHp7CcRrMdVMLUF1vVJq+hz1PR+Z1no18AKQkN8sq0pqYoLMxKSxAbdb7MBlJFKTRs3IZVUupVhcmOPk4ad59cjzpDNJ/F4X85kcAb8Pj8dNNBwh0tzJlq27WbX2Ytwer6Nqyypm1ExrXG4Pid4eAjFhPvUh3lMkk6wdOUe1tNaBJXrxH8DttRMW5+c5e+xVqFZRyu0AkZ13O2rUoF5ak0lNc+jFn/Po009RKBSIhQNUq1XKluaClW1Mp3KyPfj8AQksbL1gM+u3XklTywpj8DXVEilZluPV/H7WXnQRHl+Nthmac6dS6ltvBOQaQNxcq9HfapXxI0exqlXHJsDtdptdF6O17VtihW0vEvyeeuw+nnvxcXLZLB1NESr5IiMzKeLxMC2xCAULfnlsjJZ4kJl0gZ2bVnHzzZ9gzdoLXyMVUTWRikgnEInQ3r8G5diWw9MuVEoV7FU0DK31vcCHbCvUZMbHyafStkdS4KqrlP3dPu4YPZrZyWEe/MHXmU1OEfG66WtuJuzx8/TxU0zlSqxsSxBwuRidTTE+l8EfDNC3ooXbbruT/nXb60CMnTgAxIsJILlfU3c3oURz45IlvnzpHCAO/Xilxp1KizkWxsfFSHDJ7rtsuzCAJFzXQRjfZSY/+eov+f7936RSWoRikY9fcz2FQol7n3iEeDRKIhxj7/bL8XpDDA0P8OTxo7gjQfbu+wCX7rneqJYBYHsA25uZYzYwl8dLrGelWYsz5oGLlFJnzAocKv59h8Wai1Kjo+SScyiXMpKQ91rAs1XptYHvyKEnefrx7zM2NsGe9Zu46cobcbu9pOZnSC5kaUu0Ew7GzMKqpRwLiymeGTyKjndy3Y0fc6iLA6bGAJzYIk5HgMW7VxBpNZovQ4jcHcDdNSDrgYMOFadUyBvb0JZtG3Z8cBnbEEkYCTn2Yb/bO3j26LN87/7v0N3SwkffcwtUKiwWC0S8QcKhGCg3QphcXi/VcoliLs0vDj+Lp2sDe6+82V5aQ6BcDppi+LZkPH4/XZs3NbKH+4DfqQH55FIi9G9ORsf08BAjxwdASWRwvJKoVoMU6kBkaXJzq0pgdoSHn9nP9ZddTTwYYfj0YWbmZjk1Nsqqjm5Wd/USDkQJhJqMEZd0gf2HX6F1/U7W9m+ypSzxSFblRP0a0awZvdhL/7btNHd01qQyANygtNbCpf/ZSZCMWo0dPky5WDzXvdYk02BZjg9wDNPCNXSUpw7+jOv33Egg3MT00BGOHH+FEyMjRAI+dl54CTOpOU6NjeMPRenp6uXIXIZdV91Ce9uKuhEb1tJgJzXDt98t4h2dtK1e1aheVwkQySu+C9wov5QLBcaPHKkz6nPtwrENh1oo1cAEhbakZpg++QKre9cRCDejK1XmJ4fJZlOEwxFird3sP/AQjzz/PL0r2kmsWEGsdxu7d19n3Lptdy4jLYOj0egNlbFfvnCY9v5+XB77GqFSAkTy6x8DW+RIZmaKmdNDrwFijL2mZkb8onY2PZH7CqbF6bO4Z0ZobUoQ8IdwuYPG61j5LN5QBMsTZOTkCzx/9GWy1TLdq9fRtW0fzc2tdenXVmYIsjMMsZTNcw6KnbT1r8EbkPhtxv8KkAsk+QeM0g0dO8TwiWN18ldTH9vobbdXyzGUnVzY0VhrCtkUieICPU0JvGJRxSKVfJbiYp7FapVwrJVsZpZ4vIXFapFxTwCruROXy207ELnGbJDb8C07AVvOWwwf0+Dxutl08S7iLXXvdUSAiJU9U6t2nDr8ItMjw06oFNdrv+q5hnEslg3KGGUVl6XJZuZR5Rw6PcWalnY82qJSyDKfzVIplzk5Osh8tsyGzi76OnqoRJqYTKxEOzHBkE4TpmThtqesB0VRM6tqAqNkP7K5F+66nNaOul2NC5Adjus1ezB27Ci5lBBMO+7XqXlD0iSJkI2hQiW/yPzsBNVKkWohi1pMUrUqRL1ekskJCqks7Z4QlUqZs6U8keYE0UCAdKCNUPd6Ots7CQalalQbth3W1MlA0wKiloTZZLJnwwbiy/GE1wCZPX2aQmahTl5MMHd2vzH7K2TTlLIZ8rks2VyayZlpFqZHuWJVNw+98jwhv4euWJyNze1MjY6SnJ6hHA4xRZlYoot7DrzIfK7M6t5ertt7Jdfvu6EOoFEaNVDaIZA1VtzRv4ZIwhB0e8+11tsdiZitmDp5kkIms3xCLVlyaLv9g2ZqfAivpZlJTrP/qSd4/OXDXHdBH3e8dy8vDJ3gwMBxtvSuZGtnDwlvgOn5GdK6wsn5FMens/zoyUOUqlWi0Qirezr4x7u+TESSKGN3y6pVB9LAveScjrX9jUAsAbJ5qbzzdM1GpgZPkZ62a2SNqawd1ZcNMJdOUs5neeDxR/npk89Rrhb5rUs2c/uenUwszPH0ieO8MjxK0OOjLRqhvamJ8ewiz508y8DIPB6fH69XKicQiwR4/7X7uOHqWwgIvbdvU5eQCYY1Imk8pYtVWzYTba5L5IwAkRLnw0CfXDkxNMjIiWP1NNbwQ/EnDk+u+/ZCjoHTx9CuMD95/CkODx7jQ9v6+e2r9lCslBjNzPHc8QGeGRhmJlMkHA6wqbeLRw6dIV208Hg9hsOJ41jRkeDmq3azbesuwmHJBp1ihc1YHO+1TOklL9lyyS7iiZaa5hwUIF1OveoSOZqeneHUyy/aEnGEYLtdJ25omJkZp5hP8/Czz3LNnmsYGZvmH779TTZ2NfOZG/fS29ZGOr/I6YkRDo+MksyXaY7FSKZyPHJkhGIVkxLHYhFWtHewYW0fnfE4Xd29dHf22vl8jaKY+CHeypaKeK5AOMKO3XsIR+pZ490CRApJkmmZPEQqhacPvmiSKRlGEuIXLW0TvUKO4YlTTM5O8tjBg3z4fbfSHu/g777xNY6eOsX2VR3cfvkOVrU3M5NJM5ZKMZ3NcXhogldH51goCIvVeH1eVvV2cfm2HcQjQSKxJnq719De0obbJUCM7JerLCaG2PEq2tTEuu3b6wUMYcA10vj3TtnHfJ8+cZJSXlJSoSxFsukMlrjXctHQhlR2lp8/+wyHBge5Ze9VrOvtx+eL8KVv/CtHT56gNR7hw7s30tEU5uxsmgNHRxhNLlB24kG1UsXn9RCLRPjTT91BsZynJd7Kys5uWlpal/ONulo5UnFKR/HODtr6jCXIkFbFrhqQ90uYr/UyMjMzjJ8YoFyqkJ6z44LX7cHrgtlMEo9L89yrL5HO5dixfjNNkTgrOvqYnU/zxa99ldNjIwS8HtZ3NTGeyjE1v1inPOVy2fCqWDxKNBzkYx/8AC3RBIlQFL8vSCgSJRgKGb02AVHMxaEmJo/Xmo2X7iQUravVoaXWxE01IG3Aq05Pw0Ti488+w+zEBPPpJLFwxBQQZBfPTg9TLpYZm55gz0WXmzxdEqZiqUQwEOb48BB3ffWfyBUKZiFiXzKf2JupMDq0JhAIsHXjWjZv6Gdr/yZaYy2muCExJBiM4A740U6FspY1io3EEgm2XLqzMUv8z6V+y6fqOfvSyVJl/2vjIyyLwUOvMHp8gMnkBH6fl2gwTGpxnmIpz9j0GJFQjAt61wJu3C4XUoOWYnY00sJXvvUtnjz4gtlVq1JFmVqX7LBdfAsFfFy0dR3dXR1kFhZZ19fHjg0XIxlPvpAjHIpS1KIz5XqdWCQhIN9zw63El91uaSnD/qhS6r5GIKJ00j0S6ZBOzvLSY49wZvQ0Yb+f1kgTpyfPEAuHSS2kSKbmCIT8xEMRmiIxYuFmwqGEIXUPHvgF333oh0ZaddJnal52yrx90yr6VnYxPD7FhRvXUczn2b5xBy2xdsqVIi6XB1w+/OGwMWi7GmnRvqKLrZfsrFN+QOLEZUqpzPlVFClYm1qvLGDw1Zd54pGf4PO4CPmCnJk+S3dLh3GBYzMjzKVn6W7vpCnaSizcQkVr5jNp9j/1GE8/f9jWbdF1cd0O8ZTg98ef+DipbIoTQ4P0dfeQSifp7e5jRUs3QV+QUrmEpXzEIjFCpjCnTdthw/YdJNrMPtfGLUqpH9rBu2ForS8G7nd6gFQqFfb/4L8ZGzpB0B8iW1igLd5C1SoblZuamyDsD9PS1M5cOkMuX+aJF15mcERKtOK6TSm7TjzFyK/bu5O2VpFeiHwuj8flpljOmUWvaF1JUyRBrpgH5SMaCtPW0YHH46Gjp4eVa0WV6+NBpZS0/Mw4H4iU8qQCf1fthJnpCfb/4L9MTlGplmmNNZNZnDfqlcolcWk3Lx8dZODUCIv5IuWqhcfjdbIth/6bOylammLcduv7aIqE8fsjzKXnSGfm8HhclMslutp7SMQ6yBYWTWIm0sHroW/NGrbt3NWoUsKhPqKUevR1gTgqJQFSuNeFtZPOnBpg/wPfw9JVmkNRsvkFcuUc6YVZAr4Y9+0/wMjYlHEStaKdJEqGgjjVeTkeCwf57Cc/RWuilWKlykRykqmZURN0zSYlOolHW8jl80QjTWQLeXp7+th3w40Ez20A3a2Ukh5mfZwjkdpRrfWapSDzk6VcXrJHM4ZODXDgZw9gFcvGDVeqEhwVU8l57rn/R6QymeUcwiRjdveqplqmwI3io++/mb2X7qKqXQyOnyGbnUW5PJTLUieOEQo1UygVCQUihOJxbrzpVhKt59iFdAluEgN/K0DEX34A+HcgXrvg7NBJ9j90L+5qBa9HdtvHLw++zI8ee8LEGRM3HI0VvTbJkJ3TOVxN0dma4G8//RmKFc3A2eOUilmCoSZKlTJ+l2WOh4MRVl+wkauvvYFo9JyWgnQJxN2eaATxGhs5/0ettZT//qURTDo9z6M/vpeF+XnypSpfv+d/mEom7XKnw70N/TcprJ1z27U8p0qxVGW8684/JNHazpnJEdLpCZriHcylkwS9Lizl5j3X3MKuK67G4z2nbS+Lv10pZTPa88brqlbjOVrrj0gjHxCWbEa1WmHoxDGeePxRPvfFLzmFbLvZWWsfGsbsRHG7zGcskKpV5fKLd3DFZZcZ9Uqnxmhu6uTM6Akuvmg3e/a+lzVrLmgkhHKhSOKONwLxphIxt7afLxEudndjb112ulgs8PCjD/P5v/kCY2Mj9YanLQAXLmGsQsClTV3jTpZmz84dXL7zUrKlChQzbNxyKes3b2H9+q34lnsgtX0Tz/R7SqnTryeJ2rE3lUjtRK21tFqF7u9rbMnJ7wsLCxx86UUefOgBTg2eYnp2hmw2Sz6fM7HC5lzCoUJEIxGu23cFe3buJt7Szpr+fnp6Vjdyp9otxcVKYf0vzjfsd6Ra56mZVCWlIik9923nTygRP5PJMDk1SSaTZjG3SG4xV+tMm2pjPBajq2sFiUQLXm+9A3X+VJKxSmpxQCllP4HwJuMtS+Q8QJJY/4nT9RUO8YbPYrzZApzfaw/XyMMBf16jHW/xWnPaOwLSoG5Snfyg85iFBNDetwlKkiJJH15aatg8KIG4scH5/wbEcQayGdIMl6gldeRdznNbEkylzNHtLEhaI5PAGUBaAU84AOSJoKRSSkC94/F/UmstviMrEs0AAAAASUVORK5CYII=",
	  u: "",
	  w: 35,
	  e: 1
	}, {
	  id: "2FIW4k_TqZDzHdrXfl8L3",
	  layers: [{
	    ddd: 0,
	    ind: 257,
	    ty: 2,
	    nm: "",
	    ln: "iLT9x7FHdRJ-Rz-po8XTr257",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49982.75, 49982.75]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "iLT9x7FHdRJ-Rz-po8XTr"
	  }]
	}, {
	  id: "WSsexbGSLkyXmnK7ZJyI0",
	  layers: [{
	    ddd: 0,
	    ind: 259,
	    ty: 4,
	    nm: "",
	    ln: "Qbx3H5UTvaRYvwbmfiRFW259",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [34.5, 34.5]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0, 0, 0]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "KOocqEYCNTkorAgN1tcSr",
	  layers: [{
	    ddd: 0,
	    ind: 258,
	    ty: 0,
	    nm: "",
	    td: 1,
	    ln: "precomp_drwiOOp0C_-tVTPj3B4E3258",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "WSsexbGSLkyXmnK7ZJyI0"
	  }, {
	    ddd: 0,
	    ind: 256,
	    ty: 0,
	    nm: "",
	    tt: 1,
	    ln: "precomp_O7BCeE69oUSCpLSy8pdD7256",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "2FIW4k_TqZDzHdrXfl8L3"
	  }]
	}, {
	  id: "4-d6p7Hz-kwjmtgIlaQjS",
	  layers: []
	}, {
	  id: "Bu3MZylm2KnY_Yudw91CB",
	  layers: []
	}, {
	  id: "889C06slQ3WFJpFpjjXcP",
	  layers: [{
	    ddd: 0,
	    ind: 254,
	    ty: 0,
	    nm: "",
	    ln: "precomp_E9IVRyq-gou2dIFm7Bf4_254",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "uzJdjC1IBwxbsB_i4lgVI"
	  }, {
	    ddd: 0,
	    ind: 255,
	    ty: 0,
	    nm: "",
	    ln: "precomp_O7BCeE69oUSCpLSy8pdD7255",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "KOocqEYCNTkorAgN1tcSr"
	  }, {
	    ddd: 0,
	    ind: 260,
	    ty: 0,
	    nm: "",
	    ln: "precomp_Muj1S5XBNspSLDTfVMpWA260",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "4-d6p7Hz-kwjmtgIlaQjS"
	  }, {
	    ddd: 0,
	    ind: 261,
	    ty: 0,
	    nm: "",
	    ln: "precomp_NSa0jDVAjXYKjfiCfdAW_261",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "Bu3MZylm2KnY_Yudw91CB"
	  }]
	}, {
	  id: "UfAfUhKRvlxCqSe2_8uq9",
	  layers: []
	}, {
	  id: "CC1cgtwgwAF8tbdgtaNdu",
	  layers: [{
	    ddd: 0,
	    ind: 266,
	    ty: 4,
	    nm: "",
	    ln: "XA1Zr7JnEGBn0YDybua6r266",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49952, 49970]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [133.33, 133.33]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      nm: "surface936",
	      it: [{
	        ty: "gr",
	        it: [{
	          ty: "sh",
	          d: 1,
	          ks: {
	            a: 0,
	            k: {
	              c: true,
	              i: [[0, 0], [4.14, 0], [0, 0], [0, 2.48], [0, 0], [-2.48, 0], [0, 0], [0, -2.48]],
	              o: [[0, 4.14], [0, 0], [-2.48, 0], [0, 0], [0, -2.48], [0, 0], [2.48, 0], [0, 0]],
	              v: [[71.25, 36.75], [63.75, 44.25], [4.5, 44.25], [0, 39.75], [0, 4.5], [4.5, 0], [66.75, 0], [71.25, 4.5]]
	            }
	          }
	        }, {
	          ty: "fl",
	          c: {
	            a: 0,
	            k: [0.97, 0.37, 0.62, 1]
	          },
	          r: 1,
	          o: {
	            a: 0,
	            k: 20
	          }
	        }, {
	          ty: "tr",
	          nm: "Transform",
	          a: {
	            a: 0,
	            k: [0, 0]
	          },
	          o: {
	            a: 0,
	            k: 100
	          },
	          p: {
	            a: 0,
	            k: [0, 0]
	          },
	          r: {
	            a: 0,
	            k: 0
	          },
	          s: {
	            a: 0,
	            k: [100, 100]
	          },
	          sk: {
	            a: 0,
	            k: 0
	          },
	          sa: {
	            a: 0,
	            k: 0
	          }
	        }]
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }]
	    }]
	  }]
	}, {
	  id: "LRnh8X_CvThcQObn5yAMD",
	  layers: [{
	    ddd: 0,
	    ind: 268,
	    ty: 4,
	    nm: "",
	    ln: "8oxps7s6qB2Jv5GQL8cnH268",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [96, 60]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0, 0, 0]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "aw2VE6sCseGUsPy2M5Lbv",
	  layers: [{
	    ddd: 0,
	    ind: 267,
	    ty: 0,
	    nm: "",
	    td: 1,
	    ln: "precomp_zTszrUmVjm_Klk1MuErh7267",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "LRnh8X_CvThcQObn5yAMD"
	  }, {
	    ddd: 0,
	    ind: 265,
	    ty: 0,
	    nm: "",
	    tt: 1,
	    ln: "precomp_z9dsOh31XqEKxB6Gzfczo265",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "CC1cgtwgwAF8tbdgtaNdu"
	  }]
	}, {
	  id: "7eJmeH9FKQr8XQD0sH384",
	  layers: []
	}, {
	  id: "oMrzXQof1sZbVssBDnlN-",
	  layers: []
	}, {
	  id: "p3A00JX3kNJlUSXi5OWff",
	  layers: [{
	    ddd: 0,
	    ind: 263,
	    ty: 0,
	    nm: "",
	    ln: "precomp_ijklOb3BUsy-s-8famyTY263",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "UfAfUhKRvlxCqSe2_8uq9"
	  }, {
	    ddd: 0,
	    ind: 264,
	    ty: 0,
	    nm: "",
	    ln: "precomp_z9dsOh31XqEKxB6Gzfczo264",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "aw2VE6sCseGUsPy2M5Lbv"
	  }, {
	    ddd: 0,
	    ind: 269,
	    ty: 0,
	    nm: "",
	    ln: "precomp__2LhidIXftUU2eblXrITr269",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "7eJmeH9FKQr8XQD0sH384"
	  }, {
	    ddd: 0,
	    ind: 270,
	    ty: 0,
	    nm: "",
	    ln: "precomp_-SdjIZLBTrRk1Xmy0dxxF270",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "oMrzXQof1sZbVssBDnlN-"
	  }]
	}, {
	  id: "HVkfglTnrUXR7xOso0mqV",
	  layers: []
	}, {
	  id: "QuGTNKyFmfgfDwVSy452t",
	  layers: []
	}, {
	  id: "QTA_OoyvMhFFQEXOh3AfM",
	  layers: [{
	    ddd: 0,
	    ind: 253,
	    ty: 0,
	    nm: "",
	    ln: "precomp_mPzexJkRg1Aw4CReSMUMD253",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49999.75, 49999.75]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "889C06slQ3WFJpFpjjXcP"
	  }, {
	    ddd: 0,
	    ind: 262,
	    ty: 0,
	    nm: "",
	    ln: "precomp_EFW32oZtoiSPSlRnXDyw8262",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 20
	      },
	      p: {
	        a: 0,
	        k: [50000.5, 50000.5]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "p3A00JX3kNJlUSXi5OWff"
	  }, {
	    ddd: 0,
	    ind: 271,
	    ty: 0,
	    nm: "",
	    ln: "precomp_FyAUL2uHMLBrQ7HRq-e4z271",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "HVkfglTnrUXR7xOso0mqV"
	  }, {
	    ddd: 0,
	    ind: 272,
	    ty: 0,
	    nm: "",
	    ln: "precomp_l31jdmh-DXv4n786ihGPb272",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "QuGTNKyFmfgfDwVSy452t"
	  }]
	}, {
	  id: "_8UDkvlNrzvtIHtiJYiqS",
	  layers: []
	}, {
	  h: 35,
	  id: "poJsSldcnHquuTked0lJY",
	  p: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAAXNSR0IArs4c6QAAFhhJREFUaEO9mgmUXOV153/fW+rV2kv1vqu7JbW21oYWViEBAQK20ITVxisBY0ycxA5g+wSDscfEJk6Mj2fiMRMDzmEyA3HseCaJTGAwMNg+WALCogXtLfVa1bWvr+q9942+p26NJCCAnTP3nDpSVb96df/f3f733if4dxQppQ7E5l5hwAACcz8hARtwgBJQEEIU/r1+Xvy2N5JSasAiYD2wARgG+oB2IAQ0nAIkC1SASeAYsB/YATwnhEj+Nrr8VkCklErx24GrAGUB830qo6xUn3t9D/iWEGLmfd7Dv/x9A5FSRoHzjp/o7wPbfgPl/y09lVUeBR4DdgshlBu+J3lfQKSUS4/f9SvApUDTW35BSrxaBVnM4RYyVLNp6sUCdadOsVRGD0cIx2LEOnsJxDsxwupM3lYOAz8UQtz3nlC8V4tIKZXLjAI/BXpPu7mUSOlQL6SQ6SncbAq3XPRfdrGM60GpWCSXL+A6VWINEULBMOWqjdk7TNPIamJt3QTDEYR4y7mOARcDh4UQ3r8F6l0tIqVUwfq540H6hbngPXE///SLOLUibjWPm8shSkWkXcUrF3GKRbx6jaoDxUKRQj6HrkkamxvxXJdCqULdClPWQ+RcjfjAIhYvH6Wjq+tMQAePx9CfCiEe/22BPAD8IWDN30i6NerZSbxqDikFHhJZKKHVa7i1KrKYp5bP4VSq1JRFCgWqlTKhWJhAKEitVCWTyVMxLapWhFS+TKJQpaqbnHP+Ji76nd85U+cc8AdCCBU7byvvaJE5S9x9POffefKbnotXzlGfPYyHi0o5Qg8gbRtZqeN5dajbyFIBp1zALldxHY9CNoNTd7AaouA45LJ5cvkyVStM1tMoVOqUXI9C3cVFp2doiA9su5q+7o5TlVZgbgOeEEK4Z6J5WyBSSlXE7gHuONUS9uQ+3OkjEAr6+U45rS5MXM9FkyBdB2lXkJUynm1jl8vUiiXymQyeZmBFw9iFArlMjmy1TrLiknXB9kBTlvIEVUfiBSxKsYVc93tbOXdp26k6T6hsKYR48r0CWQu8cGpM/MuTz7IuliJohRBWBEwDVwPdBSEljpQ+OM2p41UqeFWbSiZNJZWiWrURwRDBgEV6JkG+VCJVLDCTLTNdAy8QxAgFkcKgjkAPWhyrtzEWWs3XPrqa80ZOA6OK6ogQInEqmLdYREo5COwE4urCSsXmu9//Hzz95DM8fvcHCISiiIZmMAyklIhaHaFABYNQd6BaRhYKOMU85akExUwaKXSsaAxNg+T4FOlSiUw+R61eoyZ0pqrghmK4UswBCVIIdPOvjNLdGubObctYO9Ryqt4qeyrLpOY/PA2IlDJ4nF78APjw/AXPvvAKH7n5TxnujvEP913jKySbWxFKcUArF/EME88KQq0G2TReNkd5Nkl+esaPpFBDA1ZYFX6XySMTJGYzZFU6po5hmFSFwbQToOyBNAysUJS81syLrEHTBYOdDXz7E2fRGD5JHBTNuV0I8cg7AbkIUGmuVV2QL5RYefZHSGXyLB1u4mf3X4sVCiM6+pHBgG8BmU4hAgGEZeBVbJx0Ck9lqUIOdBNpmtj1OgHLwC6WyMwkmZ6apViu4Mk64VAYwwpwtCSZqQmkptMUjTBZsUjKPuW3TIW7Wbu0my9fPUrEUjzUF8XTVgohqurNmRZ5ArhW/cG2a9zyh/fzo58+D0LQFdd56YefRXds9HgXMhiGahXyWb+moKs0DLVigXQyxaHxSQ5NJDk8PkmhUCYaCtEUCRALBAjrGgFDI6BBNBrBMAPMVFzGbYGhG2jJJMPdXSxvbeHY2CTbjUUc7l7DZy5fzMXLO5Q686Lqy/2nAZmjH6/Oc6dnntvBh26+l3zeRqWkiFHnwM++glYu4ErQtADCriOdGp70SKXTHJvJsP35F9m5ax/T2RzVap0l/d2sXrQAU+jguggkkaBFvDFEyNBoCIcwTINCTTLuGriVKue0NmC4UHE8qsfS5BrbeKz7Moa649x/vbKK6hZ8yQBrhRBHfGxzVPzHcyyWWs3hj7/0HR75b9tPXC6gOST5p//0CUr5HMnZFE0Bk4G2ViLRME6hwO69B9m+cxdvjk1g2zYhy2B08TAXrFmFV7MZPzKO40ncWg09aBIKW4SCGlHdxLJMKq5gf8EhWLNZ093KsUPTLBkZRlQkNalxr7eGYLyVT18yzKWjJ+uLIpWfBh6eBzICvDxHxdl/cJzNH/wcmWwBgXIZl95Gj61rIhw4Os5MIsni7ja2nb+e9RvWous6U8fGeenVN9l/eILJTIZCqYrZ0ESgIcbM1CSWbhB0PVYN9rB4oIfW9ma8moNbLaujxJEGe1NZqsUKS1obKOdrrFu+HF3Tmc1W+UboQiKNUXrjIR740EpMXbVBvvwIuGkeyC3HG6G/muvo+O5DP+ZL9/01nlSuoPv/mjrc9cEertq4hP1vHuDpnW8wkcryhc/ezMq1o2T27+X553YwPpuhWqnyq10HGBldTdkKUsjM0GaaLO9pZ3igm97+HgIBjcxkgmwyRc2pY9dcXptMsGdsgqtWLaearhL0NIaH+xjT4vxty2a0gMAQkjuuXML6Ib86KNkLXC6klCoNPDjXIOE4LivPv4mxsSkEGlIT6sD8ONmyrIXrR8P8wy9fgdZedu15ncs2ruLPvv5l8r9+gTde3cVEtoCm68Sb43QNLiDSEkedneJhGh66JrDCQZ8FJA4dY2Z8mlKpRNl12HF0in1TSe7cdhl2skxQN1Fk5BeRQXa2bkQYEDA1Ll3RwcfPXzAf9Mq9LlRAVF/xt8Dv+jnt0ASrLrzVr9Z4itIIpPTQhM7C3hh/dNkAk/v3MTK6AjNg0NnbyYp1a0k+9TNmZlMY4ZBfN5q62ol1dKGbJtJTtBJkTZFKG9e2KapYO3iUmZlZipUqOdvmyb0HmZjN88VtlzK1d5yhrnasxjh/Z61gum0xQV3HMDVGuiL80aWLTk3Fdyggqr/+5+O+tkIBeeyJZ7j1T76DJgwcp+LnZ02otBigvyPIo1/ZRn+jiRWLohXKqHM2AgGOPvU0ebtCtLmRho5WovEWApEoumlBwPIt6xVK1O0K9XyRdGKGqWOTZBWBrNokajX+/sVXKdsOv79xDSN9vTSEg0zUwjzdtYW8EcIKmP4B97eFuf3ihXQ2nijKwN8pIItV8w90qk++9q3/zp//Z5XANDzXRrq2HyeaZrJiqIlH791GX0cEWXORtTq27UChxMSOHeTqNsFoiM6+PsLxZoxwBDMcRhqm755ePk9ZVf1MlunpaaZnkuTLFSoSnt17kJfGJrA0k1su3UI0GGJlTzs/s/t5M77UL5pCFwjp0RILceuWIYbbI/NAdikgy4BfzU87br/rr3j0iZ+jG0GkU8WxCz5VV4Vq/ZJ2/vqOi2hriWEooJqgmM5jJNIc3r2XI5OTOK7H4MgQi9etwQhZaJqOFAJZVxmqQnE2w+zENNOpJBlF5aXLa+PTPLNrH8Vanahp8fkPXE7FrnIgPEJy0YV4uiBkWfjhKiUNoQCfvGCApd3zAxomFZA1c6nXR3fNTQ/w1POvI3QTp172myehW37XtnqomR98fgs9LVG0hiiZ8Ukamtsp797HkQMHscJRAp7GK3v2cO7Wi2jv7QKh+TEiPI9KNkshmSaTzTORSJIrV5gqFnl2zyGOpnM4nkeTZXHDlovY27SaUs9aAqbw40IxB11o6BIMXeeTmwYY7TsJRLnc6UCuvukBnn7udTTdxKtXcZyyn72Ub3TFLf7mzktYOdRK3TQoHh7DwODIG/s4OpVgslCgzbCoZ8sMrBth3SXnnehT7Bqu52DncmSTaWZTWaZzBb/e7E+m2TU+TaJY8vv4cCDI0vO2Ypx1NQHLwrIMNE34caqpqqaBqQk+ccECVvSeDmT1nEX8mnL9LQ/yL8+97ldzWbOpO2VMPeA3T4YmuefGFXzqylXUheDnj/8zpVyWw8kMv9h9gO62NhbFYhiOx9kXr2f0wg0EdJ1aqYRTqWAXisxMJ8iUqozNphlLpJgtV8hU6xyaSnIsmWBhdzdLrrwNu+8sDEMjpMipahdUryM1hJCELYMbz+ljWc9JIJ6yyPLj451fzsfI5+75IY88/iye5ynW7dd1IV2QimPXWLcwyo+/fjW6GaDoeTzx0GPEQkGmZ/PYdY9Ivc765cMsXreMcHsbmvT8lFtNZSiVy6RTOaYzeY4kM0yn89hunZqmk6vW2LF7H4t7Ohm95Dr03uWUCVPXTAwrRN3zCwEBXSMWsbhhQw8LO06Ok44oIGrE+b+BAWWRbz/0j3z1Wz/yg0oNFtTXhWfjuap3EwSMGv/r61eyfKSfou3w53/2lzRHI7TH47y47wim63LFuWsZXbEIKxohZIJTrVIr26RmM0zNpDk0OUuiUKJUd/CkJNQcJ5Er8otX3+Cs4T4u2HoN3UtXk8yUqLkwaYepmE2ql8MydGIhk2vW99AXVz2OLy8rIN1z86p16pOnn3+d625+8ET35xdD6adh3zIYuF6Zj27p5FNbV/Pd//IDhpsaWNDVwcq163jpxVfYefAwRcehI95EU0OE5liYNYOdtDQ2Mjk9y7GEio8ShWoNM2Aymy9R9CR1ofOrV1/n+nNXYQ2txOpehG6F6OvtYDKRJ2EqWmP6zCAeMblu4wDNkfn5OA8rICoZq07L70OmE1nWXPQFKtUqQmg4Tt13Ld0IIL0To9ruphrXr9Np8Wwu7u4l1thJtWhz9MARJgp5JuwKiUqF2UqJkvRYt7iPS9eNMjY5y5FExh8yCE0gDB3blcwUqxxNZzl6dIxbLjuXcttCGpasx5UeA72dZHMFxmZdRHMXuqHT2xzmmg39vpvNyafnSeM358Y+/vtLfu8+dr52yM9WyqVUwyQ0w6csUlZRB/Hhs+psaNARE1XaO7px83lal4ygOR5jBw6SlQ7B9gb0xgCpfIa+jnbGU6qKO3ieJBKyyBTL5OsuU4UiO17fw7LudrauX0G2ZQhr4WrqdZvB/i5sf/ijcTAl0cKNbBhqZdMSNez3Ra0qNs4D2arK/Pwu4/Gf/ILb7nroBNWSrj888ISnKCRIxy+OW1e5fGLzIIuj3Ugrhp3LU67YJCeOkXMrhCIWkZhFa1sz0jI5MjHLr3cfYjqdpdmfNoIZDHI0kWLPkUmKxQzXXbCRwdYmUpE2gsvPoWbbDA50IzSTquMwk5NU9EY+ummYzka1sfDlteOriSvngah5yxtzOw1S6QKXX3sf+w9N+TGC6u50A8+r+WlQ101WdJT5zm0bCXrwk+0v8MKufdiOpKUhzGhfJ8sHumiKBAlGLQgGee3gOAcmUsykM3S2tqKZARL5AgfHpynk81w4uoSlXW2EAhrTboBE4xDd/b0sWNCDEbD8upbK1Qk2dXDt2Qv8WJmTvzm+b/nUyXfHFVZT9nvVH+uOy93/8TG+98j2E8M33VK9LZqa5/iOJrG0Kl+8qo3/cO5Sdh84xpMv7yefyrJpdISB5tCJlO3PTTTG8zn2TWWo1JSbCooVm3AoxL7xGQ6Pj7Np5VJW9nfSHLT838vUJJOhTlZfsJloQxTNCOBqJoVilUs3rqKz+STHqh0n7DcKIX50KhCVftX2yJ+GvfzaQT5y67cZn0j5kw0ppM+bVD1R/YY6kcFYhofv3Ex3Rytvjuewc1mWjS6jnklQzecplcocS2Z5+dAxDk/PUnM9wuGwX7H3Hh5ncmaWJQNdnL14kMH2OE69hl2rk6vUkMOj9K+7ANdxaWyMkqtIettbOXvpadbYA5wthMifOUVRA2t/1qsC8i++91O+9sATeGqppKYbwvS5DrqH0HQuv2ABFw2V+MD5Z7H9n56nu7PNT9NetUosEvSVePXwODv2j/kuFY02EI/H2Xt4jEwux8LOdkYX9LFiQTeRgE6+UKRUqVKoeTSu30y4dzGO9Ohta8SWAVYuXEB3/P/REuCDQoh/VPqeCeQs4CdzO0DKlRo33vqXPPP8v6oi78eKjnIxl7aWKH//6J/w/W/ew8XLFpBIZTg0NkXJrvoZKWQGqEtBKlfglQMHfT/v7GhnbHyKil1nUWcrgx0trBkeoL0xSq1uUyyWyOZLlLQAg1fcQFkLojK+gcvmc1bT23oyUylt/qcQQq38fDkTiKowagL/5fkL9rw5zsduf5A9+8dAC6ArF8Pj4k1LufOzV/LgN75Bu1altamRl3ftQ5VRqam07VF3HSZn09Qch/b2Dn+1EAyYNIVDdMebWDvYx2BXq58N1TIoXywym8ljLFzJ0KbLSBUquK6kMRTkqovPnYtRXzO1Z/yQEOLnbwtEfThXIBX3Wjl/0fanX+KGm+/HExZC1nz2+cef+SBbt13IL3/5ax75i68y0tPBm4eOULJVWhfohkGuUPRdw7Is4qEI/V3txBsixAImCzpbGO5sJd4YI5/NkSsWyGby/oR+0x/cRb7ikq/UiDfF2LRmBeHgyfWMUuthIYTaYZ6Ud1orDB0vMmqopbpHX7Y/tZPPf/n7jB+bIBQN89W7P8bSVcuIBgXT+3dzx2dv93tqBUD16YpOaJ5HyDRpiEYIWwGCpklzJERnvJHelkY621rAdUin06RzBdLZAo2rzqF97Xm8tPNlLHRuv+3jxPy58UlRW4IrVYC/FyAqz14N/NfjPLJx/gtP/Xwndz/wGEcmZ7n3Sx9jxfJBOhpDtEZMbrzsCkYXtHHVNVsJx+METIPSxDj79x1mbDLhE8yQcquQQXM4xILeLh+YWsllsllmcyUqVpglW2+k6ukkJya44pLN9HT7Hfi8qC2BSrf7Tv3wLTFy5h+llB8FvnsqmORsmpvueZwrL+jn3A3LMXVBSzTAFz/+SRY3BfjYTTcQ6evxhw5uucqx13dxYN8h0vmi32TpmkdLUxONzTGou+SyWZLpLMlMgaYNW2hfvZ6Vi4boVy3A6ctRpfyHhRAvnannuwKZi5kPqUU+oFiyL47jkJhNYQZN0rki8WiAr37mNvo0h2uv/V2aFg37ExRqVexUhsxUkunJBIVCkXK1SlNTI1bAoJwvkCvk/QDPE2DzZ+5kcGCA1saGMxeiyhKfficQ7xWImhgrLvbwmbt1RV/UsqZQyPDQN7+FNbGfrVu30D6yBL2pCd2u4KpdYrbI7NQsiUSSuuMRioTxnDozMzM+P2voGWTkoitYuHINus8eThOVmW4WQhx6O0vMf/au6+n5C6WUKokrur/ltDW1n+k83nxjF+O/fp7FC1po7ujAiMeR5TyyUsIr2xRTWfK5PHV0f0ykRqQi0kDXsjW09g8i3gpApVg1l/rimYH9G7nWqV+am0qqiaTaua96m5jy1wy4NZ+bqf/LuloSenhqHKSqm2mhW0G/fVXE8R1EdayqtXhWCKGeVXlXec8WOQOQGvF9fm7rqx5rOrlGetdffPsL5h+uUQ8H3DVPO97PvX4jIKe4m8qN18w9ZqEKaP/7BKWqp2ofXlGUQw1BTl1w/n8DMpfV1GGocYZizWqOvHHuuS1VTNXsv2dOIcX/p4Ejc6uA/zMHQD0RlBJCKFC/sfxf+j4HzZo9FS4AAAAASUVORK5CYII=",
	  u: "",
	  w: 35,
	  e: 1
	}, {
	  id: "vFo2XrGsOqFu_MMUa7iaC",
	  layers: [{
	    ddd: 0,
	    ind: 278,
	    ty: 2,
	    nm: "",
	    ln: "poJsSldcnHquuTked0lJY278",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49982.75, 49982.75]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "poJsSldcnHquuTked0lJY"
	  }]
	}, {
	  id: "kRBaWKgioYmjVC58WJE-a",
	  layers: [{
	    ddd: 0,
	    ind: 280,
	    ty: 4,
	    nm: "",
	    ln: "S6QE3WIKjQ5TD_6O3M4nd280",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [34.5, 34.5]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0, 0, 0]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "VFldyMMA3EbsLSVHZ9wWd",
	  layers: [{
	    ddd: 0,
	    ind: 279,
	    ty: 0,
	    nm: "",
	    td: 1,
	    ln: "precomp_-j9iu1l5sX2hLNr4t_f5N279",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "kRBaWKgioYmjVC58WJE-a"
	  }, {
	    ddd: 0,
	    ind: 277,
	    ty: 0,
	    nm: "",
	    tt: 1,
	    ln: "precomp_cRWgNmOyl3QVK7bnhS8qd277",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "vFo2XrGsOqFu_MMUa7iaC"
	  }]
	}, {
	  id: "GlKkiURinpqp1Ke9p84tD",
	  layers: []
	}, {
	  id: "dFwHblJ7nt_APoZXvr5Qm",
	  layers: []
	}, {
	  id: "1D_acXmWJE-DXS9Fer-4z",
	  layers: [{
	    ddd: 0,
	    ind: 275,
	    ty: 0,
	    nm: "",
	    ln: "precomp_xf63G5YPjFFlTYjZRxJFt275",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "_8UDkvlNrzvtIHtiJYiqS"
	  }, {
	    ddd: 0,
	    ind: 276,
	    ty: 0,
	    nm: "",
	    ln: "precomp_cRWgNmOyl3QVK7bnhS8qd276",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "VFldyMMA3EbsLSVHZ9wWd"
	  }, {
	    ddd: 0,
	    ind: 281,
	    ty: 0,
	    nm: "",
	    ln: "precomp_Xbfdq2dN5qBx7ZIxNBPYZ281",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "GlKkiURinpqp1Ke9p84tD"
	  }, {
	    ddd: 0,
	    ind: 282,
	    ty: 0,
	    nm: "",
	    ln: "precomp_9TWtoj3OefO-qNtfeu6zM282",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "dFwHblJ7nt_APoZXvr5Qm"
	  }]
	}, {
	  id: "VcEOGyUdsjmDIKu7NCoAF",
	  layers: []
	}, {
	  h: 60,
	  id: "hzQD64x_-hY6ZWff11gHq",
	  p: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAIcAAABVCAYAAABjEfcuAAAAAXNSR0IArs4c6QAAA8hJREFUeF7tmMtvTHEcxb/fe2fGoxmvEiQi3qQRFWFVEhFpvaZKYs/GH2eJ6IO2FroQGxYqaDUahAiJR+l07r1fKWlTIjI9ux5nVrO45zdzPueTeVy3BY8I896x09VlZhu8nO7NPFmX5LFy4TV6zkMgPBqJ+9tSHmPTLTNvOjcOfHO3mGvoC6r60MtaW1Ek+y2K1TwI1KQZArnFx8j9yandN0bNfgnyU47ZT4z+Zz1HSuX8YDMH6RpeApnFw67tNx/MfoL4rBjDk7W2IrcO3spqthgCWW4jXbtujHr/284W+1Y5nZqvW8wBupaXQO7+Oc8at/zO+IU95tlx3qpqhhCYKaWDPjB+7kzivgU5QBleApH4a789cf6KR1HmralmCIHC7LvfeVG7ioSV4ScgOfg3hhtKDhgdf1By8G8MN5QcMDr+oOTg3xhuKDlgdPxBycG/MdxQcsDo+IOSg39juKHkgNHxByUH/8ZwQ8kBo+MPSg7+jeGGkgNGxx+UHPwbww0lB4yOPyg5+DeGG0oOGB1/UHLwbww3lBwwOv6g5ODfGG4oOWB0/EHJwb8x3FBywOj4g5KDf2O4oeSA0fEHJQf/xnBDyQGj4w9KDv6N4YaSA0bHH5Qc/BvDDSUHjI4/KDn4N4YbSg4YHX9QcvBvDDeUHDA6/qDk4N8Ybig5YHT8QcnBvzHcUHLA6PiDkoN/Y7ih5IDR8QclB//GcEPJAaPjD0oO/o3hhpIDRscflBz8G8MNJQeMjj8oOfg3hhtKDhgdf1By8G8MN5QcMDr+oOTg3xhuKDlgdPxBycG/MdxQcsDo+IOSg39juKHkgNHxByUH/8ZwQ8kBo+MPSg7+jeGGPjhZuxyZVeATFKQl4AMvui8lFmtpG6oYTMBvj5876u5t8AkK0hLwwcmenUVWnHALp22pYhABv/e+uzr1yc6mSayCTlCIloBHmA9NdB8Li320LVUMIvDzq+T+qwutX7KsxwpLoVMUoiOQhX2d/50x+PzioUgbh+laqhBEYKbIHs/LMff1Upjt1Y9TiCdNKDwauVf6fvuH0v+os6VUrZwI8800TVVk8QRSn1izddPdv/59HXrZ3RGF74koyos/WYklTcC9bmF9J3dcf/dXOYbjeKk+vmpb6nbAPdYv6bJ6800R8NSjCPvgK2zk5Mbr72ZD/7zxde3apbR6oL6rVIl2N1vT1KvooiVJwBMbqzeykTO7e+tzBZq+Kzr8tLY+yt6ahVUT9xWFF8mSpKA3PU8gLJle7snn6U9Tk13tA1N/omlaDjH9/wj8ADhhUMxrgec7AAAAAElFTkSuQmCC",
	  u: "",
	  w: 95,
	  e: 1
	}, {
	  id: "o_E022Qk6y8iBQLuFkAL7",
	  layers: [{
	    ddd: 0,
	    ind: 287,
	    ty: 2,
	    nm: "",
	    ln: "hzQD64x_-hY6ZWff11gHq287",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49952.5, 49970]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "hzQD64x_-hY6ZWff11gHq"
	  }]
	}, {
	  id: "elA9DbSKGNIIvR6PkVmhy",
	  layers: [{
	    ddd: 0,
	    ind: 289,
	    ty: 4,
	    nm: "",
	    ln: "EuyJ_J7_i2j9iDEUouD09289",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [95, 60]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0, 0, 0]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "waFlb7LHL-hAZlxsXK7jj",
	  layers: [{
	    ddd: 0,
	    ind: 288,
	    ty: 0,
	    nm: "",
	    td: 1,
	    ln: "precomp_z5flzxtJTmQWspfRsUFUg288",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "elA9DbSKGNIIvR6PkVmhy"
	  }, {
	    ddd: 0,
	    ind: 286,
	    ty: 0,
	    nm: "",
	    tt: 1,
	    ln: "precomp_Mkx0P5-Cy_J8XWMZDJ2X_286",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "o_E022Qk6y8iBQLuFkAL7"
	  }]
	}, {
	  id: "OacD1AEa6Si4xPz8bm_KR",
	  layers: []
	}, {
	  id: "dWtOERYuW0R-y0OepZOwa",
	  layers: []
	}, {
	  id: "oF5FGPXup2hknmC4NiOAi",
	  layers: [{
	    ddd: 0,
	    ind: 284,
	    ty: 0,
	    nm: "",
	    ln: "precomp_YsaosyMrUjRQ52giYce7T284",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "VcEOGyUdsjmDIKu7NCoAF"
	  }, {
	    ddd: 0,
	    ind: 285,
	    ty: 0,
	    nm: "",
	    ln: "precomp_Mkx0P5-Cy_J8XWMZDJ2X_285",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "waFlb7LHL-hAZlxsXK7jj"
	  }, {
	    ddd: 0,
	    ind: 290,
	    ty: 0,
	    nm: "",
	    ln: "precomp_h6cQrUX_bWrMkkr8soRA1290",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "OacD1AEa6Si4xPz8bm_KR"
	  }, {
	    ddd: 0,
	    ind: 291,
	    ty: 0,
	    nm: "",
	    ln: "precomp_pPpv8O3o62LEukX4IgjI9291",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "dWtOERYuW0R-y0OepZOwa"
	  }]
	}, {
	  id: "ms1MMi_uxjp6qa75W1Nva",
	  layers: []
	}, {
	  id: "qf9Wbnp1_uUh0Zg46DbaY",
	  layers: []
	}, {
	  id: "5gqDMhAXvcH3a7FU94ZUz",
	  layers: [{
	    ddd: 0,
	    ind: 274,
	    ty: 0,
	    nm: "",
	    ln: "precomp_fD9v2YEF3FjLZAgWTEAQ9274",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49999.75, 49999.75]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "1D_acXmWJE-DXS9Fer-4z"
	  }, {
	    ddd: 0,
	    ind: 283,
	    ty: 0,
	    nm: "",
	    ln: "precomp_umA4zIpgagZ-SQkTRbWRd283",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 40
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000.5]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "oF5FGPXup2hknmC4NiOAi"
	  }, {
	    ddd: 0,
	    ind: 292,
	    ty: 0,
	    nm: "",
	    ln: "precomp_VYTwxLO4uf3w1cSmeuQQw292",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "ms1MMi_uxjp6qa75W1Nva"
	  }, {
	    ddd: 0,
	    ind: 293,
	    ty: 0,
	    nm: "",
	    ln: "precomp__MJtTEeKAqqctmb3vqnqB293",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "qf9Wbnp1_uUh0Zg46DbaY"
	  }]
	}, {
	  id: "ylWNoRceuZynhFW4b5izn",
	  layers: []
	}, {
	  h: 35,
	  id: "WM4E1jk4wabmThNnsJIjK",
	  p: "data:image/png;base64,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",
	  u: "",
	  w: 35,
	  e: 1
	}, {
	  id: "AK7LY4eF3YQKK8eyv_H-r",
	  layers: [{
	    ddd: 0,
	    ind: 299,
	    ty: 2,
	    nm: "",
	    ln: "WM4E1jk4wabmThNnsJIjK299",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49982.75, 49982.75]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "WM4E1jk4wabmThNnsJIjK"
	  }]
	}, {
	  id: "PRuCUdXypi-ZO1e9sdtDr",
	  layers: [{
	    ddd: 0,
	    ind: 301,
	    ty: 4,
	    nm: "",
	    ln: "z9_c6AZl-vNdFSjCp5CxP301",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [34.5, 34.5]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0, 0, 0]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "0GT-xXsA6y6P3pC-dw-P6",
	  layers: [{
	    ddd: 0,
	    ind: 300,
	    ty: 0,
	    nm: "",
	    td: 1,
	    ln: "precomp_XdGjM3OMdVq0P4T_41yn4300",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "PRuCUdXypi-ZO1e9sdtDr"
	  }, {
	    ddd: 0,
	    ind: 298,
	    ty: 0,
	    nm: "",
	    tt: 1,
	    ln: "precomp_YvKUVZMk35tXpsvhz87rJ298",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "AK7LY4eF3YQKK8eyv_H-r"
	  }]
	}, {
	  id: "owKg2KkPGTIioo7fY3j1K",
	  layers: []
	}, {
	  id: "gvySXiVCzR_cWgEA9_LYN",
	  layers: []
	}, {
	  id: "UAVmyRc9wO4VpimA1RraP",
	  layers: [{
	    ddd: 0,
	    ind: 296,
	    ty: 0,
	    nm: "",
	    ln: "precomp_QtVESsWliz6T4bZEXLD18296",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "ylWNoRceuZynhFW4b5izn"
	  }, {
	    ddd: 0,
	    ind: 297,
	    ty: 0,
	    nm: "",
	    ln: "precomp_YvKUVZMk35tXpsvhz87rJ297",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "0GT-xXsA6y6P3pC-dw-P6"
	  }, {
	    ddd: 0,
	    ind: 302,
	    ty: 0,
	    nm: "",
	    ln: "precomp_z2IZZZ_gr_HjiX8qY0o7l302",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "owKg2KkPGTIioo7fY3j1K"
	  }, {
	    ddd: 0,
	    ind: 303,
	    ty: 0,
	    nm: "",
	    ln: "precomp_6nwRUWRk2X5bmVPb-Qz8o303",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "gvySXiVCzR_cWgEA9_LYN"
	  }]
	}, {
	  id: "5xXNEKTC-IkaEqvQf4hW1",
	  layers: []
	}, {
	  id: "bQOTAc1C8uf4bVaNr5ZdZ",
	  layers: [{
	    ddd: 0,
	    ind: 308,
	    ty: 4,
	    nm: "",
	    ln: "8awKJgtWIP4zgaU8jfqnJ308",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49952.5, 49970.5]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [133.33, 133.33]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      nm: "surface931",
	      it: [{
	        ty: "gr",
	        it: [{
	          ty: "sh",
	          d: 1,
	          ks: {
	            a: 0,
	            k: {
	              c: true,
	              i: [[0, 0], [-2.48, 0], [0, 0], [0, -4.14], [0, 0], [2.48, 0], [0, 0], [0, 2.48]],
	              o: [[0, -2.48], [0, 0], [4.14, 0], [0, 0], [0, 2.48], [0, 0], [-2.48, 0], [0, 0]],
	              v: [[0, 4.5], [4.5, 0], [63.75, 0], [71.25, 7.5], [71.25, 39.75], [66.75, 44.25], [4.5, 44.25], [0, 39.75]]
	            }
	          }
	        }, {
	          ty: "fl",
	          c: {
	            a: 0,
	            k: [1, 0.76, 0.3, 1]
	          },
	          r: 1,
	          o: {
	            a: 0,
	            k: 40
	          }
	        }, {
	          ty: "tr",
	          nm: "Transform",
	          a: {
	            a: 0,
	            k: [0, 0]
	          },
	          o: {
	            a: 0,
	            k: 100
	          },
	          p: {
	            a: 0,
	            k: [0, 0]
	          },
	          r: {
	            a: 0,
	            k: 0
	          },
	          s: {
	            a: 0,
	            k: [100, 100]
	          },
	          sk: {
	            a: 0,
	            k: 0
	          },
	          sa: {
	            a: 0,
	            k: 0
	          }
	        }]
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }]
	    }]
	  }]
	}, {
	  id: "pFOuf2EJcW1m5_q0AqJwo",
	  layers: [{
	    ddd: 0,
	    ind: 310,
	    ty: 4,
	    nm: "",
	    ln: "qo6sMVaXeRw3Y2WsduOC4310",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [95, 59]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0, 0, 0]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "qgJbtPP0kAK0jYvewNxmm",
	  layers: [{
	    ddd: 0,
	    ind: 309,
	    ty: 0,
	    nm: "",
	    td: 1,
	    ln: "precomp_jBk2MZ7pND7VPOXzB_uCw309",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "pFOuf2EJcW1m5_q0AqJwo"
	  }, {
	    ddd: 0,
	    ind: 307,
	    ty: 0,
	    nm: "",
	    tt: 1,
	    ln: "precomp_CJFYVVwxLbQm6EHZ48OjW307",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "bQOTAc1C8uf4bVaNr5ZdZ"
	  }]
	}, {
	  id: "iUs2F4CZiSW7augs1wRW8",
	  layers: []
	}, {
	  id: "IsNM8ub3lzwXoWTk42Ikk",
	  layers: []
	}, {
	  id: "CwjNkOfCAfTGcCZ2L1gaT",
	  layers: [{
	    ddd: 0,
	    ind: 305,
	    ty: 0,
	    nm: "",
	    ln: "precomp_h68_5ort6Ar4C2Oc6BHbT305",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "5xXNEKTC-IkaEqvQf4hW1"
	  }, {
	    ddd: 0,
	    ind: 306,
	    ty: 0,
	    nm: "",
	    ln: "precomp_CJFYVVwxLbQm6EHZ48OjW306",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "qgJbtPP0kAK0jYvewNxmm"
	  }, {
	    ddd: 0,
	    ind: 311,
	    ty: 0,
	    nm: "",
	    ln: "precomp_zS_sApxtII51gXDIpcEWR311",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "iUs2F4CZiSW7augs1wRW8"
	  }, {
	    ddd: 0,
	    ind: 312,
	    ty: 0,
	    nm: "",
	    ln: "precomp_TEJBAYnhbZHHP1arubgxF312",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "IsNM8ub3lzwXoWTk42Ikk"
	  }]
	}, {
	  id: "YPvYpmoNsK0W7UtH-Wk4L",
	  layers: []
	}, {
	  id: "w5ymy1gHTIucpAO676wLE",
	  layers: []
	}, {
	  id: "CqYMKlT068iIyfHoQL1a9",
	  layers: [{
	    ddd: 0,
	    ind: 295,
	    ty: 0,
	    nm: "",
	    ln: "precomp_AoEUoDScrgL1oFeSjxPt9295",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49999.75, 49998.75]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "UAVmyRc9wO4VpimA1RraP"
	  }, {
	    ddd: 0,
	    ind: 304,
	    ty: 0,
	    nm: "",
	    ln: "precomp_VgIUn-tcwRVw2GB_xP6YI304",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 40
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "CwjNkOfCAfTGcCZ2L1gaT"
	  }, {
	    ddd: 0,
	    ind: 313,
	    ty: 0,
	    nm: "",
	    ln: "precomp_P3dkTJUIsdASB3jnrDiS6313",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "YPvYpmoNsK0W7UtH-Wk4L"
	  }, {
	    ddd: 0,
	    ind: 314,
	    ty: 0,
	    nm: "",
	    ln: "precomp_dkzA38USLz0BiDHMFHlyq314",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "w5ymy1gHTIucpAO676wLE"
	  }]
	}, {
	  id: "vIq3SQbe9NZEH5l2F-hmO",
	  layers: []
	}, {
	  h: 35,
	  id: "StrvvyFX15eLZ23U2H19E",
	  p: "data:image/png;base64,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",
	  u: "",
	  w: 35,
	  e: 1
	}, {
	  id: "YcR6Yb94rftfJ9c0WMZit",
	  layers: [{
	    ddd: 0,
	    ind: 320,
	    ty: 2,
	    nm: "",
	    ln: "StrvvyFX15eLZ23U2H19E320",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49982.75, 49982.75]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "StrvvyFX15eLZ23U2H19E"
	  }]
	}, {
	  id: "P9286cXiYvdBfiwxo5yaH",
	  layers: [{
	    ddd: 0,
	    ind: 322,
	    ty: 4,
	    nm: "",
	    ln: "xDIBZd-D76QsckjoxOTtQ322",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [34.5, 34.5]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0, 0, 0]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "a16HWJbJbY2V7-OO1W9tY",
	  layers: [{
	    ddd: 0,
	    ind: 321,
	    ty: 0,
	    nm: "",
	    td: 1,
	    ln: "precomp_R5tPVf54Jjqh5n1JneoZE321",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "P9286cXiYvdBfiwxo5yaH"
	  }, {
	    ddd: 0,
	    ind: 319,
	    ty: 0,
	    nm: "",
	    tt: 1,
	    ln: "precomp_rUPYesi94YqLycPrJgNpv319",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "YcR6Yb94rftfJ9c0WMZit"
	  }]
	}, {
	  id: "IFmLBCUezwbeZBpO7NGXU",
	  layers: []
	}, {
	  id: "jrRN2VGSTOFwXL1xd_DhX",
	  layers: []
	}, {
	  id: "r756ptstiHlQhd3NW7OFo",
	  layers: [{
	    ddd: 0,
	    ind: 317,
	    ty: 0,
	    nm: "",
	    ln: "precomp_u_S224Qm96qYNhr_AtWds317",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "vIq3SQbe9NZEH5l2F-hmO"
	  }, {
	    ddd: 0,
	    ind: 318,
	    ty: 0,
	    nm: "",
	    ln: "precomp_rUPYesi94YqLycPrJgNpv318",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "a16HWJbJbY2V7-OO1W9tY"
	  }, {
	    ddd: 0,
	    ind: 323,
	    ty: 0,
	    nm: "",
	    ln: "precomp_oSfb7MAKS9hp--xCtosCK323",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "IFmLBCUezwbeZBpO7NGXU"
	  }, {
	    ddd: 0,
	    ind: 324,
	    ty: 0,
	    nm: "",
	    ln: "precomp_I4t1pV3_Q-0ZkkMHlhm-d324",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "jrRN2VGSTOFwXL1xd_DhX"
	  }]
	}, {
	  id: "nWFiSJmXMxCw7MbyxfUAF",
	  layers: []
	}, {
	  id: "DPJeUzUQqqAuXrvNR0PTN",
	  layers: [{
	    ddd: 0,
	    ind: 329,
	    ty: 4,
	    nm: "",
	    ln: "d6mJyWdD_xZOpTikKKUBX329",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49952.5, 49970.5]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [133.33, 133.33]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      nm: "surface926",
	      it: [{
	        ty: "gr",
	        it: [{
	          ty: "sh",
	          d: 1,
	          ks: {
	            a: 0,
	            k: {
	              c: true,
	              i: [[0, 0], [-4.14, 0], [0, 0], [0, -2.48], [0, 0], [2.48, 0], [0, 0], [0, 2.48]],
	              o: [[0, -4.14], [0, 0], [2.48, 0], [0, 0], [0, 2.48], [0, 0], [-2.48, 0], [0, 0]],
	              v: [[0, 7.5], [7.5, 0], [66.75, 0], [71.25, 4.5], [71.25, 39.75], [66.75, 44.25], [4.5, 44.25], [0, 39.75]]
	            }
	          }
	        }, {
	          ty: "fl",
	          c: {
	            a: 0,
	            k: [0.33, 0.82, 0.88, 1]
	          },
	          r: 1,
	          o: {
	            a: 0,
	            k: 40
	          }
	        }, {
	          ty: "tr",
	          nm: "Transform",
	          a: {
	            a: 0,
	            k: [0, 0]
	          },
	          o: {
	            a: 0,
	            k: 100
	          },
	          p: {
	            a: 0,
	            k: [0, 0]
	          },
	          r: {
	            a: 0,
	            k: 0
	          },
	          s: {
	            a: 0,
	            k: [100, 100]
	          },
	          sk: {
	            a: 0,
	            k: 0
	          },
	          sa: {
	            a: 0,
	            k: 0
	          }
	        }]
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }]
	    }]
	  }]
	}, {
	  id: "imE8q_diT-SLq4y7G6d79",
	  layers: [{
	    ddd: 0,
	    ind: 331,
	    ty: 4,
	    nm: "",
	    ln: "yLrkcg2tuxJ6jbBNTeeUD331",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [95, 59]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0, 0, 0]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "IqbSbBS7CapToEGdAuuD3",
	  layers: [{
	    ddd: 0,
	    ind: 330,
	    ty: 0,
	    nm: "",
	    td: 1,
	    ln: "precomp_oOtXNPzVMoS88oUdDgfLI330",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "imE8q_diT-SLq4y7G6d79"
	  }, {
	    ddd: 0,
	    ind: 328,
	    ty: 0,
	    nm: "",
	    tt: 1,
	    ln: "precomp_lLQCL2dL_QpqoHhCBkpJM328",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "DPJeUzUQqqAuXrvNR0PTN"
	  }]
	}, {
	  id: "HpqIBQ7Al4oDUjmOxGfTf",
	  layers: []
	}, {
	  id: "StyKx_aiQS9ZYFaLff35X",
	  layers: []
	}, {
	  id: "a2VWdepVHlohbAERHZVPt",
	  layers: [{
	    ddd: 0,
	    ind: 326,
	    ty: 0,
	    nm: "",
	    ln: "precomp_NWwszh7AU2d39y_rNOKPQ326",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "nWFiSJmXMxCw7MbyxfUAF"
	  }, {
	    ddd: 0,
	    ind: 327,
	    ty: 0,
	    nm: "",
	    ln: "precomp_lLQCL2dL_QpqoHhCBkpJM327",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "IqbSbBS7CapToEGdAuuD3"
	  }, {
	    ddd: 0,
	    ind: 332,
	    ty: 0,
	    nm: "",
	    ln: "precomp_QX7A1mP_Wv-H8NctsJKVU332",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "HpqIBQ7Al4oDUjmOxGfTf"
	  }, {
	    ddd: 0,
	    ind: 333,
	    ty: 0,
	    nm: "",
	    ln: "precomp_IqfSGrGvG6-fMe2Q_-N1B333",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "StyKx_aiQS9ZYFaLff35X"
	  }]
	}, {
	  id: "WdkenVMwbz-3CgWqmZhX1",
	  layers: []
	}, {
	  id: "Gb6mW7iQjN_l6IH823d6r",
	  layers: []
	}, {
	  id: "mpkplZ5R6iiRnRlOOhZmm",
	  layers: [{
	    ddd: 0,
	    ind: 316,
	    ty: 0,
	    nm: "",
	    ln: "precomp_pRMba8MAVs7I41WscJyXd316",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49999.75, 49997.75]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "r756ptstiHlQhd3NW7OFo"
	  }, {
	    ddd: 0,
	    ind: 325,
	    ty: 0,
	    nm: "",
	    ln: "precomp_g2amzBBlNMefldst5rLfv325",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 40
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "a2VWdepVHlohbAERHZVPt"
	  }, {
	    ddd: 0,
	    ind: 334,
	    ty: 0,
	    nm: "",
	    ln: "precomp_dP1OMY1geEHW-H8Y_Qzyg334",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "WdkenVMwbz-3CgWqmZhX1"
	  }, {
	    ddd: 0,
	    ind: 335,
	    ty: 0,
	    nm: "",
	    ln: "precomp_3nhJn7zsgnIXuyYLwQAkE335",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "Gb6mW7iQjN_l6IH823d6r"
	  }]
	}, {
	  id: "k3DEjmws4diiovBFJ6sKL",
	  layers: [{
	    ddd: 0,
	    ind: 337,
	    ty: 4,
	    nm: "",
	    ln: "np27GnlTAkDhDFXbW-NuK337",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 9
	        },
	        s: {
	          a: 0,
	          k: [222, 149]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [1, 1, 1]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "9wHHrJfsng76jqVNMaEW6",
	  layers: [{
	    ddd: 0,
	    ind: 339,
	    ty: 4,
	    nm: "",
	    ln: "3Up9T89kqDUbUT4UhZX3m339",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 9
	        },
	        s: {
	          a: 0,
	          k: [222, 149]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0.93, 0.95, 0.96]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "q8zsonvLiZ_cVmXcAEtBp",
	  layers: []
	}, {
	  id: "-cUIRyY07ZMKyrBF8VIds",
	  layers: []
	}, {
	  id: "AMowLb-BBOX6JkRr7XFMB",
	  layers: [{
	    ddd: 0,
	    ind: 179,
	    ty: 0,
	    nm: "",
	    ln: "precomp_hcFYPWKNHyYjHS4ZRiEFj179",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 1,
	        k: [{
	          t: 0,
	          s: [100],
	          h: 1
	        }, {
	          t: 0,
	          s: [0],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 0,
	          s: [0],
	          h: 1
	        }, {
	          t: 147,
	          s: [0],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 171,
	          s: [100],
	          h: 1
	        }]
	      },
	      p: {
	        a: 1,
	        k: [{
	          t: 0,
	          s: [50110.5, 50033.5],
	          h: 1
	        }, {
	          t: 0,
	          s: [50110.5, 50062.5],
	          i: {
	            x: 0,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 0,
	          s: [50110.5, 50062.5],
	          h: 1
	        }, {
	          t: 147,
	          s: [50110.5, 50062.5],
	          i: {
	            x: 0,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 171,
	          s: [50110.5, 50033.5],
	          h: 1
	        }]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "GvhdJW26OMxezeY79U1nI"
	  }, {
	    ddd: 0,
	    ind: 209,
	    ty: 0,
	    nm: "",
	    ln: "precomp_3nuMcRawJiVVQ3oWs6qyh209",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 1,
	        k: [{
	          t: 0,
	          s: [100],
	          h: 1
	        }, {
	          t: 0,
	          s: [0],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 0,
	          s: [0],
	          h: 1
	        }, {
	          t: 111,
	          s: [0],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 135,
	          s: [100],
	          h: 1
	        }]
	      },
	      p: {
	        a: 1,
	        k: [{
	          t: 0,
	          s: [50099, 49966],
	          h: 1
	        }, {
	          t: 0,
	          s: [50099, 49992.5],
	          i: {
	            x: 0,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 0,
	          s: [50099, 49992.5],
	          h: 1
	        }, {
	          t: 111,
	          s: [50099, 49992.5],
	          i: {
	            x: 0,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 135,
	          s: [50099, 49966],
	          h: 1
	        }]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "FbPlt8VHBKWY2zcJ6Ugp_"
	  }, {
	    ddd: 0,
	    ind: 252,
	    ty: 0,
	    nm: "",
	    ln: "precomp_bPlnWOMC20ffwfaiaEeHO252",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 1,
	        k: [{
	          t: 0,
	          s: [100],
	          h: 1
	        }, {
	          t: 0,
	          s: [0],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 0,
	          s: [0],
	          h: 1
	        }, {
	          t: 60,
	          s: [0],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 69,
	          s: [100],
	          h: 1
	        }]
	      },
	      p: {
	        a: 1,
	        k: [{
	          t: 0,
	          s: [50003, 50033],
	          h: 1
	        }, {
	          t: 0,
	          s: [50003, 50062.5],
	          i: {
	            x: 0,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 0,
	          s: [50003, 50062.5],
	          h: 1
	        }, {
	          t: 60,
	          s: [50003, 50062.5],
	          i: {
	            x: 0,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 69,
	          s: [50003, 50033],
	          h: 1
	        }]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "QTA_OoyvMhFFQEXOh3AfM"
	  }, {
	    ddd: 0,
	    ind: 273,
	    ty: 0,
	    nm: "",
	    ln: "precomp_amXkI3Q4y6CxGJyaJ9KL3273",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 1,
	        k: [{
	          t: 0,
	          s: [100],
	          h: 1
	        }, {
	          t: 0,
	          s: [0],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 0,
	          s: [0],
	          h: 1
	        }, {
	          t: 52.2,
	          s: [0],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 61.2,
	          s: [100],
	          h: 1
	        }]
	      },
	      p: {
	        a: 1,
	        k: [{
	          t: 0,
	          s: [49900, 50033],
	          h: 1
	        }, {
	          t: 0,
	          s: [49900, 50062.5],
	          i: {
	            x: 0,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 0,
	          s: [49900, 50062.5],
	          h: 1
	        }, {
	          t: 52.2,
	          s: [49900, 50062.5],
	          i: {
	            x: 0,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 61.2,
	          s: [49900, 50033],
	          h: 1
	        }]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "5gqDMhAXvcH3a7FU94ZUz"
	  }, {
	    ddd: 0,
	    ind: 294,
	    ty: 0,
	    nm: "",
	    ln: "precomp_tDxfhuqJBbotWMESf2WI6294",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 1,
	        k: [{
	          t: 0,
	          s: [100],
	          h: 1
	        }, {
	          t: 0,
	          s: [0],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 0,
	          s: [0],
	          h: 1
	        }, {
	          t: 44.4,
	          s: [0],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 53.4,
	          s: [100],
	          h: 1
	        }]
	      },
	      p: {
	        a: 1,
	        k: [{
	          t: 0,
	          s: [50003, 49967],
	          h: 1
	        }, {
	          t: 0,
	          s: [50003, 49996.5],
	          i: {
	            x: 0,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 0,
	          s: [50003, 49996.5],
	          h: 1
	        }, {
	          t: 44.4,
	          s: [50003, 49996.5],
	          i: {
	            x: 0,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 53.4,
	          s: [50003, 49967],
	          h: 1
	        }]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "CqYMKlT068iIyfHoQL1a9"
	  }, {
	    ddd: 0,
	    ind: 315,
	    ty: 0,
	    nm: "",
	    ln: "precomp_y7cjUA9DyBaz7Fg-z4XBr315",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 1,
	        k: [{
	          t: 0,
	          s: [100],
	          h: 1
	        }, {
	          t: 0,
	          s: [0],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 0,
	          s: [0],
	          h: 1
	        }, {
	          t: 36.6,
	          s: [0],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 45.6,
	          s: [100],
	          h: 1
	        }]
	      },
	      p: {
	        a: 1,
	        k: [{
	          t: 0,
	          s: [49900, 49967],
	          h: 1
	        }, {
	          t: 0,
	          s: [49900, 49996.5],
	          i: {
	            x: 0,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 0,
	          s: [49900, 49996.5],
	          h: 1
	        }, {
	          t: 36.6,
	          s: [49900, 49996.5],
	          i: {
	            x: 0,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 45.6,
	          s: [49900, 49967],
	          h: 1
	        }]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "mpkplZ5R6iiRnRlOOhZmm"
	  }, {
	    ddd: 0,
	    ind: 336,
	    ty: 0,
	    nm: "",
	    ln: "precomp_FFshO3fuIy0kHdmXT9Umd336",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 1,
	        k: [{
	          t: 0,
	          s: [100],
	          h: 1
	        }, {
	          t: 0,
	          s: [0],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 0,
	          s: [0],
	          h: 1
	        }, {
	          t: 7.2,
	          s: [0],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 31.2,
	          s: [100],
	          h: 1
	        }]
	      },
	      p: {
	        a: 0,
	        k: [49951.5, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "k3DEjmws4diiovBFJ6sKL"
	  }, {
	    ddd: 0,
	    ind: 338,
	    ty: 0,
	    nm: "",
	    ln: "precomp_NHoyrrnRBPoCCzym9w1gT338",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 1,
	        k: [{
	          t: 0,
	          s: [100],
	          h: 1
	        }, {
	          t: 0,
	          s: [0],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 0,
	          s: [0],
	          h: 1
	        }, {
	          t: 7.2,
	          s: [0],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 31.2,
	          s: [100],
	          h: 1
	        }]
	      },
	      p: {
	        a: 1,
	        k: [{
	          t: 0,
	          s: [49951.5, 50000],
	          h: 1
	        }, {
	          t: 79.2,
	          s: [49951.5, 50000],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 80,
	          s: [49959.04, 50000],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 81,
	          s: [49982.93, 50000],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 82,
	          s: [50007.09, 50000],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 83,
	          s: [50028.59, 50000],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 84,
	          s: [50042.25, 50000],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 85,
	          s: [50050.87, 50000],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 86,
	          s: [50054.57, 50000],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 87,
	          s: [50055.66, 50000],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 88,
	          s: [50055.24, 50000],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 89,
	          s: [50054.21, 50000],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 90,
	          s: [50053.22, 50000],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 91,
	          s: [50052.36, 50000],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 92,
	          s: [50051.83, 50000],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 93,
	          s: [50051.51, 50000],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 94,
	          s: [50051.36, 50000],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 95,
	          s: [50051.33, 50000],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 96,
	          s: [50051.35, 50000],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 97,
	          s: [50051.39, 50000],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 98,
	          s: [50051.43, 50000],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 99,
	          s: [50051.47, 50000],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 100,
	          s: [50051.49, 50000],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 101,
	          s: [50051.5, 50000],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 102,
	          s: [50051.51, 50000],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 103,
	          s: [50051.51, 50000],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 103.2,
	          s: [50051.5, 50000],
	          h: 1
	        }]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ef: [{
	      ty: 25,
	      nm: "S",
	      ix: 0,
	      ef: [{
	        ty: 2,
	        nm: "Color",
	        ix: 0,
	        v: {
	          a: 0,
	          k: [0, 0, 0]
	        }
	      }, {
	        ty: 0,
	        nm: "Opacity",
	        ix: 0,
	        v: {
	          a: 0,
	          k: 25.5
	        }
	      }, {
	        ty: 1,
	        nm: "a",
	        ix: 0,
	        v: {
	          x: "var e=thisLayer.effect(\"S\")(\"d\"),d=e.valueAtTime(time),a=value*0.01745,p=thisLayer.fromWorldVec([d*Math.cos(a),d*Math.sin(a)]),$bm_rt=Math.atan2(p[1],p[0])*57.296",
	          a: 0,
	          k: 180
	        }
	      }, {
	        ty: 0,
	        nm: "d",
	        ix: 0,
	        v: {
	          x: "var e=thisLayer.effect(\"S\")(\"a\"),a=e.valueAtTime(time)*0.01745,p=thisLayer.fromWorldVec([value*Math.cos(a),value*Math.sin(a)]),$bm_rt=Math.hypot(p[0],p[1])",
	          a: 0,
	          k: 1
	        }
	      }, {
	        ty: 0,
	        nm: "Blur",
	        ix: 0,
	        v: {
	          x: "var p=thisLayer.fromWorldVec([value,0]),$bm_rt=Math.hypot(p[0],p[1])",
	          a: 0,
	          k: 6
	        }
	      }],
	      en: 1
	    }],
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "9wHHrJfsng76jqVNMaEW6"
	  }, {
	    ddd: 0,
	    ind: 340,
	    ty: 0,
	    nm: "",
	    ln: "precomp_vSWFy4vZx8ZkdnqUxfxsB340",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "q8zsonvLiZ_cVmXcAEtBp"
	  }, {
	    ddd: 0,
	    ind: 341,
	    ty: 0,
	    nm: "",
	    ln: "precomp_VTBgK99kLU1UDMngqps8D341",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "-cUIRyY07ZMKyrBF8VIds"
	  }]
	}, {
	  id: "7Sy1ok1f7fzDeuUPpdowu",
	  layers: []
	}, {
	  h: 200,
	  id: "SX_8nJYRNJOeq4KkMsNYh",
	  p: "data:image/png;base64,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",
	  u: "",
	  w: 428,
	  e: 1
	}, {
	  id: "_tqDigltrGgvNIiCAU0qY",
	  layers: [{
	    ddd: 0,
	    ind: 346,
	    ty: 2,
	    nm: "",
	    ln: "SX_8nJYRNJOeq4KkMsNYh346",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49786, 49900]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "SX_8nJYRNJOeq4KkMsNYh"
	  }]
	}, {
	  id: "2CgJPuISqNFR8SGB-lhmY",
	  layers: [{
	    ddd: 0,
	    ind: 348,
	    ty: 4,
	    nm: "",
	    ln: "7fQ5Ibn7N97oeZmF1FOWf348",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [428, 200]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0, 0, 0]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "cRBYOLTY-0x1nNFGR23zH",
	  layers: [{
	    ddd: 0,
	    ind: 347,
	    ty: 0,
	    nm: "",
	    td: 1,
	    ln: "precomp_5Xkf8RdonJls5EkR7Iytt347",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "2CgJPuISqNFR8SGB-lhmY"
	  }, {
	    ddd: 0,
	    ind: 345,
	    ty: 0,
	    nm: "",
	    tt: 1,
	    ln: "precomp_5BqygfhGaQv8fO9ppsjb4345",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "_tqDigltrGgvNIiCAU0qY"
	  }]
	}, {
	  id: "YQkYkRqs55DIHxiT5icOR",
	  layers: []
	}, {
	  id: "H48hhzqqt80C1czDnzvbx",
	  layers: []
	}, {
	  id: "-vBrrqXwdwiVEWIaKtxwQ",
	  layers: [{
	    ddd: 0,
	    ind: 343,
	    ty: 0,
	    nm: "",
	    ln: "precomp_WLHJe4PtbV1YHqkayOzuS343",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "7Sy1ok1f7fzDeuUPpdowu"
	  }, {
	    ddd: 0,
	    ind: 344,
	    ty: 0,
	    nm: "",
	    ln: "precomp_5BqygfhGaQv8fO9ppsjb4344",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "cRBYOLTY-0x1nNFGR23zH"
	  }, {
	    ddd: 0,
	    ind: 349,
	    ty: 0,
	    nm: "",
	    ln: "precomp_INeT79mUXH9wlHnuzBzT_349",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "YQkYkRqs55DIHxiT5icOR"
	  }, {
	    ddd: 0,
	    ind: 350,
	    ty: 0,
	    nm: "",
	    ln: "precomp_HAWOWm2K18WU3B_5oXgXG350",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "H48hhzqqt80C1czDnzvbx"
	  }]
	}, {
	  id: "v2ajwt9Ka3mBFzoj_H77y",
	  layers: []
	}, {
	  id: "4XvQUEOYpfN3N1iMm7rP2",
	  layers: [{
	    ddd: 0,
	    ind: 353,
	    ty: 4,
	    nm: "",
	    ln: "pCSnxqWg_3Wj5DFU1rld7353",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [428, 200]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [1, 1, 1]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "p7msQxFFNGQfqCf6IUO5i",
	  layers: [{
	    ddd: 0,
	    ind: 178,
	    ty: 0,
	    nm: "",
	    ln: "precomp_mQMfR9i1NnwrpwXvjTdWT178",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 1,
	        k: [{
	          t: 0,
	          s: [100],
	          h: 1
	        }, {
	          t: 183.6,
	          s: [100],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 0,
	            y: 0
	          }
	        }, {
	          t: 201.6,
	          s: [0],
	          h: 1
	        }]
	      },
	      p: {
	        a: 1,
	        k: [{
	          t: 0,
	          s: [50000, 50000],
	          h: 1
	        }, {
	          t: 183.6,
	          s: [50000, 50000],
	          i: {
	            x: 1,
	            y: 1
	          },
	          o: {
	            x: 1,
	            y: 0
	          }
	        }, {
	          t: 201.6,
	          s: [50000, 50074.5],
	          h: 1
	        }]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "AMowLb-BBOX6JkRr7XFMB"
	  }, {
	    ddd: 0,
	    ind: 342,
	    ty: 0,
	    nm: "",
	    ln: "precomp_4URAMTDad_z4c7g9sDQSO342",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "-vBrrqXwdwiVEWIaKtxwQ"
	  }, {
	    ddd: 0,
	    ind: 351,
	    ty: 0,
	    nm: "",
	    ln: "precomp_RhfrgPiNX_77uRVfV0tqb351",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "v2ajwt9Ka3mBFzoj_H77y"
	  }, {
	    ddd: 0,
	    ind: 352,
	    ty: 0,
	    nm: "",
	    ln: "precomp_iOG_1_Ng_732mFbciECLx352",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 223,
	    st: 0,
	    bm: 0,
	    refId: "4XvQUEOYpfN3N1iMm7rP2"
	  }]
	}];
	var ddd$4 = 0;
	var fr$4 = 60;
	var h$4 = 200;
	var ip$4 = 0;
	var layers$4 = [{
	  ddd: 0,
	  ind: 177,
	  ty: 0,
	  nm: "",
	  ln: "precomp_ezVA-RRjE-fkV4xIkzYJb177",
	  sr: 1,
	  ks: {
	    a: {
	      a: 0,
	      k: [50000, 50000]
	    },
	    o: {
	      a: 0,
	      k: 100
	    },
	    p: {
	      a: 0,
	      k: [214, 100]
	    },
	    r: {
	      a: 0,
	      k: 0
	    },
	    s: {
	      a: 0,
	      k: [100, 100]
	    },
	    sk: {
	      a: 0,
	      k: 0
	    },
	    sa: {
	      a: 0,
	      k: 0
	    }
	  },
	  ao: 0,
	  w: 100000,
	  h: 100000,
	  ip: 0,
	  op: 223,
	  st: 0,
	  bm: 0,
	  refId: "p7msQxFFNGQfqCf6IUO5i"
	}];
	var meta$4 = {
	  g: "https://jitter.video"
	};
	var nm$4 = "Unnamed-file";
	var op$4 = 222;
	var v$4 = "5.7.4";
	var w$4 = 428;
	var ConferenceAnimation = {
	  assets: assets$4,
	  ddd: ddd$4,
	  fr: fr$4,
	  h: h$4,
	  ip: ip$4,
	  layers: layers$4,
	  meta: meta$4,
	  nm: nm$4,
	  op: op$4,
	  v: v$4,
	  w: w$4
	};

	// @vue/component
	const ConferencePromo = {
	  components: {
	    PromoPopup,
	    MessengerButton: Button
	  },
	  emits: ['continue', 'close'],
	  data() {
	    return {};
	  },
	  computed: {
	    ButtonColor: () => ButtonColor,
	    ButtonSize: () => ButtonSize
	  },
	  mounted() {
	    ui_lottie.Lottie.loadAnimation({
	      animationData: ConferenceAnimation,
	      container: this.$refs.animationContainer,
	      renderer: 'svg',
	      loop: true,
	      autoplay: true
	    });
	  },
	  methods: {
	    loc(phraseCode) {
	      return this.$Bitrix.Loc.getMessage(phraseCode);
	    }
	  },
	  template: `
		<PromoPopup @close="$emit('close')">
			<div class="bx-im-group-chat-promo__container">
				<div class="bx-im-group-chat-promo__header">
					<div class="bx-im-group-chat-promo__title">
						{{ loc('IM_ELEMENTS_CREATE_CHAT_PROMO_CONFERENCE_TITLE') }}
					</div>
					<div class="bx-im-group-chat-promo__close" @click="$emit('close')"></div>
				</div>
				<div class="bx-im-group-chat-promo__content">
					<div class="bx-im-group-chat-promo__content_image" ref="animationContainer"></div>
					<div class="bx-im-group-chat-promo__content_item">
						<div class="bx-im-group-chat-promo__content_icon --camera"></div>
						<div class="bx-im-group-chat-promo__content_text">
							{{ loc('IM_ELEMENTS_CREATE_CHAT_PROMO_CONFERENCE_DESCRIPTION_1') }}
						</div>
					</div>
					<div class="bx-im-group-chat-promo__content_item">
						<div class="bx-im-group-chat-promo__content_icon --link"></div>
						<div class="bx-im-group-chat-promo__content_text">
							{{ loc('IM_ELEMENTS_CREATE_CHAT_PROMO_CONFERENCE_DESCRIPTION_2') }}
						</div>
					</div>
					<div class="bx-im-group-chat-promo__content_item">
						<div class="bx-im-group-chat-promo__content_icon --like-orange"></div>
						<div class="bx-im-group-chat-promo__content_text">
							{{ loc('IM_ELEMENTS_CREATE_CHAT_PROMO_CONFERENCE_DESCRIPTION_3') }}
						</div>
					</div>
				</div>
				<div class="bx-im-group-chat-promo__separator"></div>
				<div class="bx-im-group-chat-promo__button-panel">
					<MessengerButton
						:size="ButtonSize.XL"
						:color="ButtonColor.Primary"
						:isRounded="true" 
						:text="loc('IM_ELEMENTS_CREATE_CHAT_PROMO_BUTTON_CONTINUE')"
						@click="$emit('continue')"
					/>
					<MessengerButton
						:size="ButtonSize.XL"
						:color="ButtonColor.Link"
						:isRounded="true"
						:text="loc('IM_ELEMENTS_CREATE_CHAT_PROMO_BUTTON_CANCEL')"
						@click="$emit('close')"
					/>
				</div>
			</div>
		</PromoPopup>
	`
	};

	var assets$5 = [{
	  id: "U2bK6mOmmlW4ZlwlYCBvs",
	  layers: [{
	    ddd: 0,
	    ind: 273,
	    ty: 4,
	    nm: "",
	    ln: "U3J_JQg_ITa-oRWBuNgeN273",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 53
	        },
	        s: {
	          a: 0,
	          k: [46.68, 3.5]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0.8, 0.92, 0.48]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "e5O90-2hVUsRKQbHLQ2KR",
	  layers: [{
	    ddd: 0,
	    ind: 275,
	    ty: 4,
	    nm: "",
	    ln: "HIIXphOawB5835NQ9rZrq275",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 53
	        },
	        s: {
	          a: 0,
	          k: [61.22, 3.5]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0.8, 0.92, 0.48]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "9m5qgndvsyKqFigoNOG2u",
	  layers: []
	}, {
	  id: "U4npDKDpyula8CxCcM94Z",
	  layers: [{
	    ddd: 0,
	    ind: 280,
	    ty: 4,
	    nm: "",
	    ln: "GaDK5diqidzwGgdE4fEqS280",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49959, 49988]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [133.33, 133.33]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      nm: "surface1111",
	      it: [{
	        ty: "gr",
	        it: [{
	          ty: "sh",
	          d: 1,
	          ks: {
	            a: 0,
	            k: {
	              c: true,
	              i: [[0, 0], [0, -1.66], [0, 0], [-1.66, 0], [0, 0], [0, 0], [0, 0], [0.43, 0.55], [0, 1.61], [0, 0], [0, 0], [0, 0], [1.66, 0]],
	              o: [[-1.66, 0], [0, 0], [0, 1.66], [0, 0], [0, 0], [0, 0], [0.69, 0], [-0.82, -1.05], [0, 0], [0, 0], [0, 0], [0, -1.66], [0, 0]],
	              v: [[3, 0], [0, 3], [0, 15], [3, 18], [56.25, 18], [56.27, 18], [60.33, 18], [60.98, 16.53], [59.28, 12.35], [59.28, 10.02], [59.25, 10.02], [59.25, 3], [56.25, 0]]
	            }
	          }
	        }, {
	          ty: "fl",
	          c: {
	            a: 0,
	            k: [0.91, 1, 0.8, 1]
	          },
	          r: 2,
	          o: {
	            a: 0,
	            k: 100
	          }
	        }, {
	          ty: "tr",
	          nm: "Transform",
	          a: {
	            a: 0,
	            k: [0, 0]
	          },
	          o: {
	            a: 0,
	            k: 100
	          },
	          p: {
	            a: 0,
	            k: [0, 0]
	          },
	          r: {
	            a: 0,
	            k: 0
	          },
	          s: {
	            a: 0,
	            k: [100, 100]
	          },
	          sk: {
	            a: 0,
	            k: 0
	          },
	          sa: {
	            a: 0,
	            k: 0
	          }
	        }]
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }]
	    }]
	  }]
	}, {
	  id: "apCJoEDVjN-i-wJ6hxBc8",
	  layers: [{
	    ddd: 0,
	    ind: 282,
	    ty: 4,
	    nm: "",
	    ln: "KZ13jgm75_9K2qSylBj8F282",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [82, 24]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0, 0, 0]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "hxHPLISm5zjlvOOdbpAIK",
	  layers: [{
	    ddd: 0,
	    ind: 281,
	    ty: 0,
	    nm: "",
	    td: 1,
	    ln: "precomp_wC_ptSJ1TRX_LMTOBzt8n281",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "apCJoEDVjN-i-wJ6hxBc8"
	  }, {
	    ddd: 0,
	    ind: 279,
	    ty: 0,
	    nm: "",
	    tt: 1,
	    ln: "precomp_k37qOpM--mr-65IUELDms279",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "U4npDKDpyula8CxCcM94Z"
	  }]
	}, {
	  id: "-W23n8nx4d-IQbHVg0VvT",
	  layers: []
	}, {
	  id: "aSK7m0es_aoLv7KXzg4nA",
	  layers: []
	}, {
	  id: "BI77knc6tQwnqT_KVPC34",
	  layers: [{
	    ddd: 0,
	    ind: 277,
	    ty: 0,
	    nm: "",
	    ln: "precomp_1Kv5ESSvjF4RsTVPPKMvd277",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "9m5qgndvsyKqFigoNOG2u"
	  }, {
	    ddd: 0,
	    ind: 278,
	    ty: 0,
	    nm: "",
	    ln: "precomp_k37qOpM--mr-65IUELDms278",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "hxHPLISm5zjlvOOdbpAIK"
	  }, {
	    ddd: 0,
	    ind: 283,
	    ty: 0,
	    nm: "",
	    ln: "precomp_bhBvEtCe9CSIc6BYoSdu2283",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "-W23n8nx4d-IQbHVg0VvT"
	  }, {
	    ddd: 0,
	    ind: 284,
	    ty: 0,
	    nm: "",
	    ln: "precomp_exU47-62hwGeEtytS795Y284",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "aSK7m0es_aoLv7KXzg4nA"
	  }]
	}, {
	  id: "Yp9cQ_0oClQ3LXM2PtRJ8",
	  layers: []
	}, {
	  id: "HwX00Yyf1BO3JJKgrcSGg",
	  layers: []
	}, {
	  id: "KVNmc0yDBNG23iqm7fXni",
	  layers: [{
	    ddd: 0,
	    ind: 272,
	    ty: 0,
	    nm: "",
	    ln: "precomp_qIePr3NQ2SQUX8X0_WHJX272",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49988.59, 50003.5]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "U2bK6mOmmlW4ZlwlYCBvs"
	  }, {
	    ddd: 0,
	    ind: 274,
	    ty: 0,
	    nm: "",
	    ln: "precomp_m2ClqETgblFInQ_k1bxeM274",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49995.86, 49996.5]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "e5O90-2hVUsRKQbHLQ2KR"
	  }, {
	    ddd: 0,
	    ind: 276,
	    ty: 0,
	    nm: "",
	    ln: "precomp_fU6OInPeUKV9WeBPa5c3i276",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000.23, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "BI77knc6tQwnqT_KVPC34"
	  }, {
	    ddd: 0,
	    ind: 285,
	    ty: 0,
	    nm: "",
	    ln: "precomp_gGtTp-GB-66mO-JaayC5f285",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "Yp9cQ_0oClQ3LXM2PtRJ8"
	  }, {
	    ddd: 0,
	    ind: 286,
	    ty: 0,
	    nm: "",
	    ln: "precomp_X_bC4ow3aRqo_0RluuwHH286",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "HwX00Yyf1BO3JJKgrcSGg"
	  }]
	}, {
	  id: "4gejeptL41StrVI_KJ9we",
	  layers: [{
	    ddd: 0,
	    ind: 291,
	    ty: 4,
	    nm: "",
	    ln: "-loU94AfgR6RY2LCeDeWJ291",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 53
	        },
	        s: {
	          a: 0,
	          k: [47.36, 3.5]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0.66, 0.68, 0.71]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "PFeXrEQGM9KB36_hCjFsq",
	  layers: [{
	    ddd: 0,
	    ind: 293,
	    ty: 4,
	    nm: "",
	    ln: "bNqChUxryubTmqUl7EuFe293",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 53
	        },
	        s: {
	          a: 0,
	          k: [57.78, 3.5]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0.66, 0.68, 0.71]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "yyJ4IRuwcJEX9sO3dTZ8c",
	  layers: []
	}, {
	  id: "XSk8ZV_cR6pTZsG2Jtn_-",
	  layers: []
	}, {
	  id: "MyCmZhnIYnPpu1NyU0FUl",
	  layers: [{
	    ddd: 0,
	    ind: 290,
	    ty: 0,
	    nm: "",
	    ln: "precomp_7q4gQPxtBG-g1qVhR4jpk290",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 34
	      },
	      p: {
	        a: 0,
	        k: [49994.79, 50003.5]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "4gejeptL41StrVI_KJ9we"
	  }, {
	    ddd: 0,
	    ind: 292,
	    ty: 0,
	    nm: "",
	    ln: "precomp_msBppt3RI5BFdyh41oFl0292",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 34
	      },
	      p: {
	        a: 0,
	        k: [50000, 49996.5]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "PFeXrEQGM9KB36_hCjFsq"
	  }, {
	    ddd: 0,
	    ind: 294,
	    ty: 0,
	    nm: "",
	    ln: "precomp_gj4uJI03wUz3MNWSN98QZ294",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "yyJ4IRuwcJEX9sO3dTZ8c"
	  }, {
	    ddd: 0,
	    ind: 295,
	    ty: 0,
	    nm: "",
	    ln: "precomp_nKZp5ImcTGRzaBCYyXQjy295",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "XSk8ZV_cR6pTZsG2Jtn_-"
	  }]
	}, {
	  id: "Z_vBHF8Z4nchUhky9oyr-",
	  layers: []
	}, {
	  id: "sUZgPs07tpqwto3y9x7ra",
	  layers: [{
	    ddd: 0,
	    ind: 300,
	    ty: 4,
	    nm: "",
	    ln: "2voOJFz5qSaYgm8jHyIIb300",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49960, 49988]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [133.33, 133.33]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      nm: "surface1106",
	      it: [{
	        ty: "gr",
	        it: [{
	          ty: "sh",
	          d: 1,
	          ks: {
	            a: 0,
	            k: {
	              c: true,
	              i: [[0, 0], [0, -1.66], [0, 0], [0.7, -0.74], [-0.73, 0], [0, 0], [0, 1.66], [0, 0], [1.66, 0]],
	              o: [[-1.66, 0], [0, 0], [-0.37, 1.05], [-0.51, 0.54], [0, 0], [1.66, 0], [0, 0], [0, -1.66], [0, 0]],
	              v: [[5.03, 0], [2.03, 3], [2.03, 13.68], [0.23, 16.42], [0.83, 18], [56.3, 18], [59.3, 15], [59.3, 3], [56.3, 0]]
	            }
	          }
	        }, {
	          ty: "fl",
	          c: {
	            a: 0,
	            k: [0.93, 0.95, 0.96, 1]
	          },
	          r: 2,
	          o: {
	            a: 0,
	            k: 100
	          }
	        }, {
	          ty: "tr",
	          nm: "Transform",
	          a: {
	            a: 0,
	            k: [0, 0]
	          },
	          o: {
	            a: 0,
	            k: 100
	          },
	          p: {
	            a: 0,
	            k: [0, 0]
	          },
	          r: {
	            a: 0,
	            k: 0
	          },
	          s: {
	            a: 0,
	            k: [100, 100]
	          },
	          sk: {
	            a: 0,
	            k: 0
	          },
	          sa: {
	            a: 0,
	            k: 0
	          }
	        }]
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }]
	    }]
	  }]
	}, {
	  id: "Yl2BPuzJYKyOOFdmBF5oj",
	  layers: [{
	    ddd: 0,
	    ind: 302,
	    ty: 4,
	    nm: "",
	    ln: "xJDdKBAReB1UMFVj1SYiR302",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [80, 24]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0, 0, 0]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "nSZAic_A1qd7F5QlyDLGg",
	  layers: [{
	    ddd: 0,
	    ind: 301,
	    ty: 0,
	    nm: "",
	    td: 1,
	    ln: "precomp_WZDInYQdKUXiCy1sro1uH301",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "Yl2BPuzJYKyOOFdmBF5oj"
	  }, {
	    ddd: 0,
	    ind: 299,
	    ty: 0,
	    nm: "",
	    tt: 1,
	    ln: "precomp_HYvuhu6AdNXMkYCYhSS7Z299",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "sUZgPs07tpqwto3y9x7ra"
	  }]
	}, {
	  id: "RvIZMW1aHLVVoagEL5MC8",
	  layers: []
	}, {
	  id: "m4jK1M5KW5ZN7ZeZQHzH4",
	  layers: []
	}, {
	  id: "_AERe35iqjZGfIjxhzOZr",
	  layers: [{
	    ddd: 0,
	    ind: 297,
	    ty: 0,
	    nm: "",
	    ln: "precomp_NvYfdW8qSIMfOALy8pnZ3297",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "Z_vBHF8Z4nchUhky9oyr-"
	  }, {
	    ddd: 0,
	    ind: 298,
	    ty: 0,
	    nm: "",
	    ln: "precomp_HYvuhu6AdNXMkYCYhSS7Z298",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "nSZAic_A1qd7F5QlyDLGg"
	  }, {
	    ddd: 0,
	    ind: 303,
	    ty: 0,
	    nm: "",
	    ln: "precomp_3h-tY0FCIbLlHT4l3QMGj303",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "RvIZMW1aHLVVoagEL5MC8"
	  }, {
	    ddd: 0,
	    ind: 304,
	    ty: 0,
	    nm: "",
	    ln: "precomp_a9ZipleyJD40g6C76HqF8304",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "m4jK1M5KW5ZN7ZeZQHzH4"
	  }]
	}, {
	  id: "JEkAOWlQhzV3npcdHaWwK",
	  layers: []
	}, {
	  id: "iY5-JZLJJOhuhJHEcZiy5",
	  layers: []
	}, {
	  id: "-NZhm6J6D3AxGG9rGemku",
	  layers: [{
	    ddd: 0,
	    ind: 289,
	    ty: 0,
	    nm: "",
	    ln: "precomp_1B63NKdn9yF0oYnr4tssZ289",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49998.09, 50000.25]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "MyCmZhnIYnPpu1NyU0FUl"
	  }, {
	    ddd: 0,
	    ind: 296,
	    ty: 0,
	    nm: "",
	    ln: "precomp_6be3EEShxySbbJNzHrqZn296",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000.47, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "_AERe35iqjZGfIjxhzOZr"
	  }, {
	    ddd: 0,
	    ind: 305,
	    ty: 0,
	    nm: "",
	    ln: "precomp_blZuAB6AbWVPP3LYhsEjY305",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "JEkAOWlQhzV3npcdHaWwK"
	  }, {
	    ddd: 0,
	    ind: 306,
	    ty: 0,
	    nm: "",
	    ln: "precomp_EoUZX-_Kja6Azve1pvsFM306",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "iY5-JZLJJOhuhJHEcZiy5"
	  }]
	}, {
	  id: "6Cl0rrsHXXJh1rglRfkRG",
	  layers: []
	}, {
	  h: 19,
	  id: "l2aWDrpMI6ZjZ7GEB4AIw",
	  p: "data:image/png;base64,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",
	  u: "",
	  w: 19,
	  e: 1
	}, {
	  id: "zi2ryaD28Y1AcCjJJ4QSk",
	  layers: [{
	    ddd: 0,
	    ind: 311,
	    ty: 2,
	    nm: "",
	    ln: "l2aWDrpMI6ZjZ7GEB4AIw311",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49990.5, 49990.5]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "l2aWDrpMI6ZjZ7GEB4AIw"
	  }]
	}, {
	  id: "jGvzCT5Oe_Z91_ImebJGG",
	  layers: [{
	    ddd: 0,
	    ind: 313,
	    ty: 4,
	    nm: "",
	    ln: "gXEDW5feRgIfgB6KYAqeO313",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [19, 19]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0, 0, 0]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "7hgISVWX2lkpkfU0j_m6r",
	  layers: [{
	    ddd: 0,
	    ind: 312,
	    ty: 0,
	    nm: "",
	    td: 1,
	    ln: "precomp_sCeMDwCYYhRvBfELdWbNw312",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "jGvzCT5Oe_Z91_ImebJGG"
	  }, {
	    ddd: 0,
	    ind: 310,
	    ty: 0,
	    nm: "",
	    tt: 1,
	    ln: "precomp_eninJmSJ3zeqPVOmXqfqj310",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "zi2ryaD28Y1AcCjJJ4QSk"
	  }]
	}, {
	  id: "VFkum_ub0TNR9SVDblP9_",
	  layers: []
	}, {
	  id: "OjBKVx_HpwP8nzGadhEEM",
	  layers: []
	}, {
	  id: "gVfZvK8k6SOku-eUKBv22",
	  layers: [{
	    ddd: 0,
	    ind: 308,
	    ty: 0,
	    nm: "",
	    ln: "precomp_IHfLQXXAPjMGYaygLTaT6308",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "6Cl0rrsHXXJh1rglRfkRG"
	  }, {
	    ddd: 0,
	    ind: 309,
	    ty: 0,
	    nm: "",
	    ln: "precomp_eninJmSJ3zeqPVOmXqfqj309",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "7hgISVWX2lkpkfU0j_m6r"
	  }, {
	    ddd: 0,
	    ind: 314,
	    ty: 0,
	    nm: "",
	    ln: "precomp_gjro9khK38hZbOWkK8Dxg314",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "VFkum_ub0TNR9SVDblP9_"
	  }, {
	    ddd: 0,
	    ind: 315,
	    ty: 0,
	    nm: "",
	    ln: "precomp_DWCRbyPH8xOn6e05e5bK2315",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "OjBKVx_HpwP8nzGadhEEM"
	  }]
	}, {
	  id: "GL03abPYjTfxQC-G4I3js",
	  layers: []
	}, {
	  id: "daI-E4kZf4idG0Ka59hYt",
	  layers: []
	}, {
	  id: "QrMFNDsMXdDN0T8MQ6OkF",
	  layers: [{
	    ddd: 0,
	    ind: 288,
	    ty: 0,
	    nm: "",
	    ln: "precomp_sgXVi59XPdKETgxt4r7ll288",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50011.15, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "-NZhm6J6D3AxGG9rGemku"
	  }, {
	    ddd: 0,
	    ind: 307,
	    ty: 0,
	    nm: "",
	    ln: "precomp_JSYju55hY_deAtSBVqLeN307",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49958.82, 50002.5]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "gVfZvK8k6SOku-eUKBv22"
	  }, {
	    ddd: 0,
	    ind: 316,
	    ty: 0,
	    nm: "",
	    ln: "precomp_pi2qsq4PJ_Vx90HKkB--s316",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "GL03abPYjTfxQC-G4I3js"
	  }, {
	    ddd: 0,
	    ind: 317,
	    ty: 0,
	    nm: "",
	    ln: "precomp_qGPhlLhy6xPuEI5rBFmDT317",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "daI-E4kZf4idG0Ka59hYt"
	  }]
	}, {
	  id: "sq-PIK_L7qkRufb4kcaAq",
	  layers: []
	}, {
	  id: "lk16T6zbnw1cLUjIYgLgI",
	  layers: [{
	    ddd: 0,
	    ind: 323,
	    ty: 4,
	    nm: "",
	    ln: "R6eYpdFuso_lTkrEFpfWr323",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49996.5, 49997]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [133.33, 133.33]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      nm: "surface1101",
	      it: [{
	        ty: "gr",
	        it: [{
	          ty: "gr",
	          it: [{
	            ty: "sh",
	            d: 1,
	            ks: {
	              a: 0,
	              k: {
	                c: true,
	                i: [[0, 0], [0.01, -0.39], [0, -0.09], [-0.05, -0.15], [-0.13, -0.18], [-0.12, -0.11], [0, 0], [-0.15, 0.15], [-0.1, 0.14], [-0.04, 0.25], [0, 0.09], [0.04, 0.13], [0.25, 0.15], [0.16, 0.02], [0.11, -0.02], [0.16, -0.12], [0.09, -0.14], [0, 0], [0.01, 0.02], [0.21, 0.1], [0.14, 0.01], [0.04, 0], [0.05, -0.01], [0.12, -0.07]],
	                o: [[-0.36, 0.19], [0, 0.09], [0.01, 0.11], [0.05, 0.15], [0.1, 0.13], [0.18, 0.17], [0, 0], [0.13, -0.12], [0.15, -0.21], [0.01, -0.09], [0, -0.13], [-0.07, -0.28], [-0.14, -0.09], [-0.11, -0.01], [-0.2, 0.03], [-0.13, 0.11], [0, 0], [-0.02, -0.02], [-0.13, -0.19], [-0.12, -0.07], [-0.04, 0], [-0.05, 0], [-0.14, 0.02], [0, 0]],
	                v: [[1.02, 0.4], [0.38, 1.35], [0.38, 1.61], [0.46, 1.94], [0.79, 2.51], [1.12, 2.86], [2.63, 4.04], [4.16, 2.82], [4.5, 2.44], [4.85, 1.75], [4.88, 1.48], [4.84, 1.08], [4.27, 0.43], [3.81, 0.27], [3.5, 0.28], [2.96, 0.51], [2.63, 0.88], [2.63, 0.89], [2.59, 0.84], [2.09, 0.39], [1.69, 0.27], [1.57, 0.27], [1.41, 0.28], [1.02, 0.4]]
	              }
	            }
	          }, {
	            ty: "fl",
	            c: {
	              a: 0,
	              k: [1, 0.6, 0.59, 1]
	            },
	            r: 2,
	            o: {
	              a: 0,
	              k: 100
	            }
	          }, {
	            ty: "tr",
	            nm: "Transform",
	            a: {
	              a: 0,
	              k: [0, 0]
	            },
	            o: {
	              a: 0,
	              k: 100
	            },
	            p: {
	              a: 0,
	              k: [0, 0]
	            },
	            r: {
	              a: 0,
	              k: 0
	            },
	            s: {
	              a: 0,
	              k: [100, 100]
	            },
	            sk: {
	              a: 0,
	              k: 0
	            },
	            sa: {
	              a: 0,
	              k: 0
	            }
	          }]
	        }, {
	          ty: "tr",
	          nm: "Transform",
	          a: {
	            a: 0,
	            k: [0, 0]
	          },
	          o: {
	            a: 0,
	            k: 100
	          },
	          p: {
	            a: 0,
	            k: [0, 0]
	          },
	          r: {
	            a: 0,
	            k: 0
	          },
	          s: {
	            a: 0,
	            k: [100, 100]
	          },
	          sk: {
	            a: 0,
	            k: 0
	          },
	          sa: {
	            a: 0,
	            k: 0
	          }
	        }]
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }]
	    }]
	  }]
	}, {
	  id: "uDXFpHENRpF56QwrqT_r4",
	  layers: [{
	    ddd: 0,
	    ind: 325,
	    ty: 4,
	    nm: "",
	    ln: "mWZp2xzOHilAX6Rk7uRab325",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [7, 6]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0, 0, 0]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "fPdfEO-igOtvNCkTgcSr2",
	  layers: [{
	    ddd: 0,
	    ind: 324,
	    ty: 0,
	    nm: "",
	    td: 1,
	    ln: "precomp_dlAUNgGiGanVk2oXqTW-r324",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "uDXFpHENRpF56QwrqT_r4"
	  }, {
	    ddd: 0,
	    ind: 322,
	    ty: 0,
	    nm: "",
	    tt: 1,
	    ln: "precomp_xAZ5Ho4xYwhjokQTYV4N1322",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "lk16T6zbnw1cLUjIYgLgI"
	  }]
	}, {
	  id: "x0TMJgEZzgoEj9mdKlv8r",
	  layers: []
	}, {
	  id: "DbQUpn-wGEsZE_Ieprphj",
	  layers: []
	}, {
	  id: "LwutY8-725EC6Pk7yQi4o",
	  layers: [{
	    ddd: 0,
	    ind: 320,
	    ty: 0,
	    nm: "",
	    ln: "precomp_BYemmC30xRsjVbO4D5RL9320",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "sq-PIK_L7qkRufb4kcaAq"
	  }, {
	    ddd: 0,
	    ind: 321,
	    ty: 0,
	    nm: "",
	    ln: "precomp_xAZ5Ho4xYwhjokQTYV4N1321",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "fPdfEO-igOtvNCkTgcSr2"
	  }, {
	    ddd: 0,
	    ind: 326,
	    ty: 0,
	    nm: "",
	    ln: "precomp_KBhpBAexabvf9-_qNs0Xe326",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "x0TMJgEZzgoEj9mdKlv8r"
	  }, {
	    ddd: 0,
	    ind: 327,
	    ty: 0,
	    nm: "",
	    ln: "precomp_wQqPLErKUARgCionTj3dy327",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "DbQUpn-wGEsZE_Ieprphj"
	  }]
	}, {
	  id: "wStbfH894GRZx3sXwtBbi",
	  layers: []
	}, {
	  h: 19,
	  id: "fzg3XWveobm5edf-dGFNs",
	  p: "data:image/png;base64,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",
	  u: "",
	  w: 19,
	  e: 1
	}, {
	  id: "thxWflxf1kFqBU0sVl_j0",
	  layers: [{
	    ddd: 0,
	    ind: 332,
	    ty: 2,
	    nm: "",
	    ln: "fzg3XWveobm5edf-dGFNs332",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49990.5, 49990.5]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "fzg3XWveobm5edf-dGFNs"
	  }]
	}, {
	  id: "Anv_U82CCDx9C1u6aVcpo",
	  layers: [{
	    ddd: 0,
	    ind: 334,
	    ty: 4,
	    nm: "",
	    ln: "SZNahkvFhZ0iAt2dy_D0W334",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [19, 19]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0, 0, 0]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "6R3mi78FI2l5LKx9YoJcC",
	  layers: [{
	    ddd: 0,
	    ind: 333,
	    ty: 0,
	    nm: "",
	    td: 1,
	    ln: "precomp_VHlIkzsOxcKaI_z4RlCNG333",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "Anv_U82CCDx9C1u6aVcpo"
	  }, {
	    ddd: 0,
	    ind: 331,
	    ty: 0,
	    nm: "",
	    tt: 1,
	    ln: "precomp_mMyuUYziPpDdNZrhAo-5X331",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "thxWflxf1kFqBU0sVl_j0"
	  }]
	}, {
	  id: "tRU00wn5cuWwv6KPkwLlz",
	  layers: []
	}, {
	  id: "IL7IRwOhjsfaD_b3GSL93",
	  layers: []
	}, {
	  id: "AaIfXKj34dlFNOOo6tMhK",
	  layers: [{
	    ddd: 0,
	    ind: 329,
	    ty: 0,
	    nm: "",
	    ln: "precomp_OiedX-uJQZubWbghdpt4J329",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "wStbfH894GRZx3sXwtBbi"
	  }, {
	    ddd: 0,
	    ind: 330,
	    ty: 0,
	    nm: "",
	    ln: "precomp_mMyuUYziPpDdNZrhAo-5X330",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "6R3mi78FI2l5LKx9YoJcC"
	  }, {
	    ddd: 0,
	    ind: 335,
	    ty: 0,
	    nm: "",
	    ln: "precomp_h3uX2uy5bFBSDDBr8C4VX335",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "tRU00wn5cuWwv6KPkwLlz"
	  }, {
	    ddd: 0,
	    ind: 336,
	    ty: 0,
	    nm: "",
	    ln: "precomp_Fu8alfdRg2CuSTsyhUGQx336",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "IL7IRwOhjsfaD_b3GSL93"
	  }]
	}, {
	  id: "8GT7zA1yCGAtbzdHcyMeg",
	  layers: [{
	    ddd: 0,
	    ind: 340,
	    ty: 4,
	    nm: "",
	    ln: "AI_tmnqN69QS-wcjcCe1o340",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 53
	        },
	        s: {
	          a: 0,
	          k: [63.82, 3.5]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0.66, 0.68, 0.71]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "l1wbCTYB3_fyPkcz64M2f",
	  layers: [{
	    ddd: 0,
	    ind: 342,
	    ty: 4,
	    nm: "",
	    ln: "dOnuWqpBcTUy7C7YrqXZG342",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 53
	        },
	        s: {
	          a: 0,
	          k: [85.54, 3.5]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0.66, 0.68, 0.71]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "wlZCNbeRgvkD6GFIsYifw",
	  layers: []
	}, {
	  id: "AIwKbtNVEhjc1M5cxaH4G",
	  layers: []
	}, {
	  id: "rQCxgH1vZw4sXy4LkHqaK",
	  layers: [{
	    ddd: 0,
	    ind: 339,
	    ty: 0,
	    nm: "",
	    ln: "precomp_hCcSFaXGh2IlVl7rQ6RCI339",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 34
	      },
	      p: {
	        a: 0,
	        k: [49989.14, 50003.5]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "8GT7zA1yCGAtbzdHcyMeg"
	  }, {
	    ddd: 0,
	    ind: 341,
	    ty: 0,
	    nm: "",
	    ln: "precomp_84GoN0f0IEnDXaRB2Yra4341",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 34
	      },
	      p: {
	        a: 0,
	        k: [50000, 49996.5]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "l1wbCTYB3_fyPkcz64M2f"
	  }, {
	    ddd: 0,
	    ind: 343,
	    ty: 0,
	    nm: "",
	    ln: "precomp_Vz_tkemVU3GxCPU1C445T343",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "wlZCNbeRgvkD6GFIsYifw"
	  }, {
	    ddd: 0,
	    ind: 344,
	    ty: 0,
	    nm: "",
	    ln: "precomp_Ee4wCKfHfHVcs080VESg9344",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "AIwKbtNVEhjc1M5cxaH4G"
	  }]
	}, {
	  id: "0K3RvGPyyD-54NU4xbZIN",
	  layers: []
	}, {
	  id: "K-X2levTqkFM4d0xCJ-HX",
	  layers: [{
	    ddd: 0,
	    ind: 349,
	    ty: 4,
	    nm: "",
	    ln: "8tj9VkkwekSgcRJZsnIbF349",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49943, 49988]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [133.33, 133.33]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      nm: "surface1096",
	      it: [{
	        ty: "gr",
	        it: [{
	          ty: "sh",
	          d: 1,
	          ks: {
	            a: 0,
	            k: {
	              c: true,
	              i: [[0, 0], [0, -1.66], [0, 0], [0.7, -0.74], [-0.73, 0], [0, 0], [0, 1.66], [0, 0], [1.66, 0]],
	              o: [[-1.66, 0], [0, 0], [-0.37, 1.05], [-0.51, 0.54], [0, 0], [1.66, 0], [0, 0], [0, -1.66], [0, 0]],
	              v: [[5.03, 0], [2.03, 3], [2.03, 13.68], [0.23, 16.42], [0.83, 18], [82, 18], [85, 15], [85, 3], [82, 0]]
	            }
	          }
	        }, {
	          ty: "fl",
	          c: {
	            a: 0,
	            k: [0.93, 0.95, 0.96, 1]
	          },
	          r: 2,
	          o: {
	            a: 0,
	            k: 100
	          }
	        }, {
	          ty: "tr",
	          nm: "Transform",
	          a: {
	            a: 0,
	            k: [0, 0]
	          },
	          o: {
	            a: 0,
	            k: 100
	          },
	          p: {
	            a: 0,
	            k: [0, 0]
	          },
	          r: {
	            a: 0,
	            k: 0
	          },
	          s: {
	            a: 0,
	            k: [100, 100]
	          },
	          sk: {
	            a: 0,
	            k: 0
	          },
	          sa: {
	            a: 0,
	            k: 0
	          }
	        }]
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }]
	    }]
	  }]
	}, {
	  id: "927-Kmj8sm2ZKu4S9Xfi1",
	  layers: [{
	    ddd: 0,
	    ind: 351,
	    ty: 4,
	    nm: "",
	    ln: "yKfJSDCkGtAKfE164OskG351",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [114, 24]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0, 0, 0]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "_exe4mVPB8wRlfxqZF_Nb",
	  layers: [{
	    ddd: 0,
	    ind: 350,
	    ty: 0,
	    nm: "",
	    td: 1,
	    ln: "precomp_x_AS2ocJq4B7iXakLeasW350",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "927-Kmj8sm2ZKu4S9Xfi1"
	  }, {
	    ddd: 0,
	    ind: 348,
	    ty: 0,
	    nm: "",
	    tt: 1,
	    ln: "precomp_HoFC242SSkAAr3GXkiOC7348",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "K-X2levTqkFM4d0xCJ-HX"
	  }]
	}, {
	  id: "CjYByfLGbT1iKbl2aC6dR",
	  layers: []
	}, {
	  id: "NKduypBhZ_deo8wbITPE7",
	  layers: []
	}, {
	  id: "-vGxDs4es9gL2fz9ZLmKC",
	  layers: [{
	    ddd: 0,
	    ind: 346,
	    ty: 0,
	    nm: "",
	    ln: "precomp_F8pBBF-VUKopw2MRhvtcV346",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "0K3RvGPyyD-54NU4xbZIN"
	  }, {
	    ddd: 0,
	    ind: 347,
	    ty: 0,
	    nm: "",
	    ln: "precomp_HoFC242SSkAAr3GXkiOC7347",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "_exe4mVPB8wRlfxqZF_Nb"
	  }, {
	    ddd: 0,
	    ind: 352,
	    ty: 0,
	    nm: "",
	    ln: "precomp_99XLlhBNgzV7Hh20kGhyC352",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "CjYByfLGbT1iKbl2aC6dR"
	  }, {
	    ddd: 0,
	    ind: 353,
	    ty: 0,
	    nm: "",
	    ln: "precomp_cYvFTbZFXP53w2xB3w82p353",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "NKduypBhZ_deo8wbITPE7"
	  }]
	}, {
	  id: "0gly30RPZ0wH7KuoYkTnP",
	  layers: []
	}, {
	  id: "s-uJAgUc1c6_xZpldlbIP",
	  layers: []
	}, {
	  id: "jZOOeuNSYz2KK1u7XUiki",
	  layers: [{
	    ddd: 0,
	    ind: 338,
	    ty: 0,
	    nm: "",
	    ln: "precomp_mvUd01o1JtZjYqH3BgODh338",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49994.83, 50000.25]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "rQCxgH1vZw4sXy4LkHqaK"
	  }, {
	    ddd: 0,
	    ind: 345,
	    ty: 0,
	    nm: "",
	    ln: "precomp_218xQ5j1j7xdgkyLnpzsU345",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000.33, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "-vGxDs4es9gL2fz9ZLmKC"
	  }, {
	    ddd: 0,
	    ind: 354,
	    ty: 0,
	    nm: "",
	    ln: "precomp_m9jya8A3YTU53iqKdLRjr354",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "0gly30RPZ0wH7KuoYkTnP"
	  }, {
	    ddd: 0,
	    ind: 355,
	    ty: 0,
	    nm: "",
	    ln: "precomp_wQYIt5RCvcRj1iNb-j58D355",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "s-uJAgUc1c6_xZpldlbIP"
	  }]
	}, {
	  id: "jXKcQDC8NADF-FiWzJmZh",
	  layers: []
	}, {
	  id: "Gr5bnt8pep7viZXrrUj5-",
	  layers: []
	}, {
	  id: "v_i5QwqVIMZ4E9rXEyBKd",
	  layers: [{
	    ddd: 0,
	    ind: 319,
	    ty: 0,
	    nm: "",
	    ln: "precomp_YJPuJXmnCHuTAHSTHlo6Z319",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50061.69, 50007]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "LwutY8-725EC6Pk7yQi4o"
	  }, {
	    ddd: 0,
	    ind: 328,
	    ty: 0,
	    nm: "",
	    ln: "precomp_sxTBVGZ7Vok9LpKU06RD_328",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49941.69, 50002.5]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "AaIfXKj34dlFNOOo6tMhK"
	  }, {
	    ddd: 0,
	    ind: 337,
	    ty: 0,
	    nm: "",
	    ln: "precomp_ogB1jKvgfwePOzC_Xx3Q7337",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50011.15, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "jZOOeuNSYz2KK1u7XUiki"
	  }, {
	    ddd: 0,
	    ind: 356,
	    ty: 0,
	    nm: "",
	    ln: "precomp_YfGgzEGnIDs4OgRwk57va356",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "jXKcQDC8NADF-FiWzJmZh"
	  }, {
	    ddd: 0,
	    ind: 357,
	    ty: 0,
	    nm: "",
	    ln: "precomp_yOzCxu0E5UnahpLr1FnVV357",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "Gr5bnt8pep7viZXrrUj5-"
	  }]
	}, {
	  id: "pXl94lv6kSnTGTxi7w2JR",
	  layers: []
	}, {
	  id: "kS1FH6Pfd31rAZDepJfBw",
	  layers: [{
	    ddd: 0,
	    ind: 363,
	    ty: 4,
	    nm: "",
	    ln: "jYEkmHKACbcBA97ZdPZHD363",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49996.5, 49996.5]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [133.33, 133.33]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      nm: "surface1091",
	      it: [{
	        ty: "gr",
	        it: [{
	          ty: "sh",
	          d: 1,
	          ks: {
	            a: 0,
	            k: {
	              c: true,
	              i: [[0, 0], [0, 0], [0.01, 0.03], [-0.05, 0.11], [0.07, 0.25], [0.32, 0.02], [0.05, -0.09], [0, -0.02], [0.02, -0.22], [0.26, -0.35], [0.03, 0], [0.07, -0.01], [0, -0.01], [0, -0.87], [-0.02, 0], [-0.14, -0.04], [-0.28, -0.09], [-0.02, 0], [0, 0], [-0.01, 0.18], [0.04, 0.09], [-0.01, 0], [0.26, 0.26], [-0.01, 0], [-0.03, 0.14], [0.02, 0.05], [0.04, 0.05], [-0.02, 0.01], [0, 0.16], [0.15, 0]],
	              o: [[0, 0], [-0.03, 0], [-0.05, -0.12], [0.09, -0.25], [-0.07, -0.18], [-0.1, 0.02], [-0.01, 0.02], [0, 0], [-0.02, 0.21], [-0.02, 0.02], [-0.1, 0.02], [-0.02, 0], [0, 0.44], [0, 0.01], [0.05, 0.01], [0.17, 0.05], [0.02, 0], [0, 0], [0.17, -0.03], [0, -0.1], [0, -0.01], [0.17, -0.03], [-0.01, -0.01], [0.14, -0.04], [0.02, -0.05], [-0.02, -0.06], [-0.01, -0.02], [0.14, -0.05], [0.02, -0.15], [0, 0]],
	              v: [[4.67, 2.07], [3.63, 2.07], [3.56, 2.02], [3.57, 1.66], [3.6, 0.89], [3.18, 0.38], [2.95, 0.54], [2.93, 0.59], [2.93, 1.12], [2.24, 2.24], [2.17, 2.28], [1.82, 2.33], [1.79, 2.36], [1.79, 4.32], [1.82, 4.35], [2.14, 4.42], [2.73, 4.7], [2.77, 4.71], [4.09, 4.71], [4.4, 4.36], [4.34, 4.07], [4.36, 4.04], [4.48, 3.43], [4.48, 3.41], [4.77, 3.12], [4.76, 2.96], [4.67, 2.78], [4.68, 2.74], [4.92, 2.4], [4.67, 2.07]]
	            }
	          }
	        }, {
	          ty: "sh",
	          d: 1,
	          ks: {
	            a: 0,
	            k: {
	              c: false,
	              i: [[0, 0], [0, 0], [-0.01, -0.04], [0, 0], [-0.04, 0], [0, 0], [0, 0.04], [0, 0], [0.04, 0]],
	              o: [[0, 0], [-0.04, 0], [0, 0], [0.01, 0.04], [0, 0], [0.04, 0], [0, 0], [0, -0.04], [0, 0]],
	              v: [[1.39, 2.15], [0.64, 2.15], [0.58, 2.22], [1.01, 4.66], [1.09, 4.73], [1.37, 4.73], [1.45, 4.65], [1.45, 2.21], [1.39, 2.15]]
	            }
	          }
	        }, {
	          ty: "fl",
	          c: {
	            a: 0,
	            k: [0.38, 0.66, 0.95, 1]
	          },
	          r: 2,
	          o: {
	            a: 0,
	            k: 100
	          }
	        }, {
	          ty: "tr",
	          nm: "Transform",
	          a: {
	            a: 0,
	            k: [0, 0]
	          },
	          o: {
	            a: 0,
	            k: 100
	          },
	          p: {
	            a: 0,
	            k: [0, 0]
	          },
	          r: {
	            a: 0,
	            k: 0
	          },
	          s: {
	            a: 0,
	            k: [100, 100]
	          },
	          sk: {
	            a: 0,
	            k: 0
	          },
	          sa: {
	            a: 0,
	            k: 0
	          }
	        }]
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }]
	    }]
	  }]
	}, {
	  id: "9oVcxjjTZZTaZv-DVKHUE",
	  layers: [{
	    ddd: 0,
	    ind: 365,
	    ty: 4,
	    nm: "",
	    ln: "Uutd87LB6Tpp92KFs3jMu365",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [7, 7]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0, 0, 0]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "ijNzamU8Q-vu3or0tpvoF",
	  layers: [{
	    ddd: 0,
	    ind: 364,
	    ty: 0,
	    nm: "",
	    td: 1,
	    ln: "precomp_IiaJ-9VGk4gOmb3ZXS8YZ364",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "9oVcxjjTZZTaZv-DVKHUE"
	  }, {
	    ddd: 0,
	    ind: 362,
	    ty: 0,
	    nm: "",
	    tt: 1,
	    ln: "precomp_ZkEUVWM2oGEgPl-OkK572362",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "kS1FH6Pfd31rAZDepJfBw"
	  }]
	}, {
	  id: "CUSBnfpzWAIzI7s69Ym00",
	  layers: []
	}, {
	  id: "DH6aC-zAI2Tf5hIQ_6I-f",
	  layers: []
	}, {
	  id: "vw3845df2EQ8Gs9DRlcA2",
	  layers: [{
	    ddd: 0,
	    ind: 360,
	    ty: 0,
	    nm: "",
	    ln: "precomp_bqwFS_Di4fJzLx0vR_2tv360",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "pXl94lv6kSnTGTxi7w2JR"
	  }, {
	    ddd: 0,
	    ind: 361,
	    ty: 0,
	    nm: "",
	    ln: "precomp_ZkEUVWM2oGEgPl-OkK572361",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "ijNzamU8Q-vu3or0tpvoF"
	  }, {
	    ddd: 0,
	    ind: 366,
	    ty: 0,
	    nm: "",
	    ln: "precomp_jWqi35t29rslQyYOIVqMY366",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "CUSBnfpzWAIzI7s69Ym00"
	  }, {
	    ddd: 0,
	    ind: 367,
	    ty: 0,
	    nm: "",
	    ln: "precomp_1w80UE4YWI29VKyxZyIFl367",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "DH6aC-zAI2Tf5hIQ_6I-f"
	  }]
	}, {
	  id: "-EnL1uhJG_02m2BpBU6jQ",
	  layers: [{
	    ddd: 0,
	    ind: 370,
	    ty: 4,
	    nm: "",
	    ln: "AxJxxzU3cUIa3n1c_aT3X370",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 53
	        },
	        s: {
	          a: 0,
	          k: [58.55, 3.5]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0.66, 0.68, 0.71]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "Z7WYOzqgeV0IibOWphGbt",
	  layers: [{
	    ddd: 0,
	    ind: 372,
	    ty: 4,
	    nm: "",
	    ln: "TVcyAO42GEB2h7Y8G5cSA372",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 53
	        },
	        s: {
	          a: 0,
	          k: [78.47, 3.5]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0.66, 0.68, 0.71]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "hNLMINLcQfgn9HLLOkLFH",
	  layers: []
	}, {
	  id: "8C2qtykvUd-yxT1DnOi0o",
	  layers: [{
	    ddd: 0,
	    ind: 377,
	    ty: 4,
	    nm: "",
	    ln: "jksLpPJzRxgJU0uqB8Q0X377",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49952, 49988]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [133.33, 133.33]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      nm: "surface1086",
	      it: [{
	        ty: "gr",
	        it: [{
	          ty: "sh",
	          d: 1,
	          ks: {
	            a: 0,
	            k: {
	              c: true,
	              i: [[0, 0], [0, -1.66], [0, 0], [0, 0], [0, 0], [1, -1.05], [-0.73, 0], [0, 0], [0, 1.66], [0, 0], [1.66, 0]],
	              o: [[-1.66, 0], [0, 0], [0, 0], [0, 0], [0, 1.56], [-0.51, 0.54], [0, 0], [1.66, 0], [0, 0], [0, -1.66], [0, 0]],
	              v: [[5.38, 0], [2.38, 3], [2.38, 10.02], [2.27, 10.02], [2.27, 12.35], [0.23, 16.42], [0.83, 18], [68.92, 18], [71.92, 15], [71.92, 3], [68.92, 0]]
	            }
	          }
	        }, {
	          ty: "fl",
	          c: {
	            a: 0,
	            k: [0.93, 0.95, 0.96, 1]
	          },
	          r: 2,
	          o: {
	            a: 0,
	            k: 100
	          }
	        }, {
	          ty: "tr",
	          nm: "Transform",
	          a: {
	            a: 0,
	            k: [0, 0]
	          },
	          o: {
	            a: 0,
	            k: 100
	          },
	          p: {
	            a: 0,
	            k: [0, 0]
	          },
	          r: {
	            a: 0,
	            k: 0
	          },
	          s: {
	            a: 0,
	            k: [100, 100]
	          },
	          sk: {
	            a: 0,
	            k: 0
	          },
	          sa: {
	            a: 0,
	            k: 0
	          }
	        }]
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }]
	    }]
	  }]
	}, {
	  id: "Qv1_Lt4a9nV5QsA3DriuF",
	  layers: [{
	    ddd: 0,
	    ind: 379,
	    ty: 4,
	    nm: "",
	    ln: "oxpQirPh0_fGLMng1r5o6379",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [96, 24]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0, 0, 0]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "kTpXBBpRJNMtuEUhVXXAd",
	  layers: [{
	    ddd: 0,
	    ind: 378,
	    ty: 0,
	    nm: "",
	    td: 1,
	    ln: "precomp_DYKj5LRVwe84q7HJ_7o6b378",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "Qv1_Lt4a9nV5QsA3DriuF"
	  }, {
	    ddd: 0,
	    ind: 376,
	    ty: 0,
	    nm: "",
	    tt: 1,
	    ln: "precomp_DjL1nWHz1fNB-fUFcASti376",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "8C2qtykvUd-yxT1DnOi0o"
	  }]
	}, {
	  id: "0aivnIqHirhfv5zq8-P6c",
	  layers: []
	}, {
	  id: "68EV_9aA7Vd0VfJ7ZW2H8",
	  layers: []
	}, {
	  id: "nX0swrj6_dgdl48uFI1Yc",
	  layers: [{
	    ddd: 0,
	    ind: 374,
	    ty: 0,
	    nm: "",
	    ln: "precomp_Lav9MbCjfBTlThsVKbyP9374",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "hNLMINLcQfgn9HLLOkLFH"
	  }, {
	    ddd: 0,
	    ind: 375,
	    ty: 0,
	    nm: "",
	    ln: "precomp_DjL1nWHz1fNB-fUFcASti375",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "kTpXBBpRJNMtuEUhVXXAd"
	  }, {
	    ddd: 0,
	    ind: 380,
	    ty: 0,
	    nm: "",
	    ln: "precomp_fEKxsJO53B5yOwNUkaWwJ380",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "0aivnIqHirhfv5zq8-P6c"
	  }, {
	    ddd: 0,
	    ind: 381,
	    ty: 0,
	    nm: "",
	    ln: "precomp_AxB_qxLb410mR84JZDbPk381",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "68EV_9aA7Vd0VfJ7ZW2H8"
	  }]
	}, {
	  id: "GMxCNVqd294t0bEvhPhDf",
	  layers: []
	}, {
	  id: "1QbWHWNs0pYHgxzZbKXW0",
	  layers: []
	}, {
	  id: "EnjQBz_HFDyntdZnK5dBW",
	  layers: [{
	    ddd: 0,
	    ind: 369,
	    ty: 0,
	    nm: "",
	    ln: "precomp_ZSU_qTBjBPvB02wi-PFc0369",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 34
	      },
	      p: {
	        a: 0,
	        k: [49990.53, 50003.5]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "-EnL1uhJG_02m2BpBU6jQ"
	  }, {
	    ddd: 0,
	    ind: 371,
	    ty: 0,
	    nm: "",
	    ln: "precomp_Iv2VELfTdRIEfBikQ0XXw371",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 34
	      },
	      p: {
	        a: 0,
	        k: [50000.49, 49996.5]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "Z7WYOzqgeV0IibOWphGbt"
	  }, {
	    ddd: 0,
	    ind: 373,
	    ty: 0,
	    nm: "",
	    ln: "precomp_iYzpmLc7f6CNeRYVPEKTQ373",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000.06, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "nX0swrj6_dgdl48uFI1Yc"
	  }, {
	    ddd: 0,
	    ind: 382,
	    ty: 0,
	    nm: "",
	    ln: "precomp_FUMCVdHYgc_Aqw7jstQjK382",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "GMxCNVqd294t0bEvhPhDf"
	  }, {
	    ddd: 0,
	    ind: 383,
	    ty: 0,
	    nm: "",
	    ln: "precomp_1MXr91l-d4Hfqxu6-oqli383",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "1QbWHWNs0pYHgxzZbKXW0"
	  }]
	}, {
	  id: "a-QeGHIHr-WbGID61eMWZ",
	  layers: []
	}, {
	  h: 19,
	  id: "OGb93rhBNhpMbWNXvrgXS",
	  p: "data:image/png;base64,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",
	  u: "",
	  w: 19,
	  e: 1
	}, {
	  id: "lv902mpkKnKs4KAGHFTVs",
	  layers: [{
	    ddd: 0,
	    ind: 388,
	    ty: 2,
	    nm: "",
	    ln: "OGb93rhBNhpMbWNXvrgXS388",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49990.5, 49990.5]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "OGb93rhBNhpMbWNXvrgXS"
	  }]
	}, {
	  id: "N6v7Yw7kiBsaBjAn5UDox",
	  layers: [{
	    ddd: 0,
	    ind: 390,
	    ty: 4,
	    nm: "",
	    ln: "tBM07xd0SZz5j9y7AtAXm390",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [19, 19]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	        bm: 0,
	        c: {
	          a: 0,
	          k: [0, 0, 0]
	        },
	        r: 1,
	        o: {
	          a: 0,
	          k: 100
	        }
	      }, {
	        ty: "tr",
	        nm: "Transform",
	        a: {
	          a: 0,
	          k: [0, 0]
	        },
	        o: {
	          a: 0,
	          k: 100
	        },
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [100, 100]
	        },
	        sk: {
	          a: 0,
	          k: 0
	        },
	        sa: {
	          a: 0,
	          k: 0
	        }
	      }],
	      np: 0
	    }]
	  }]
	}, {
	  id: "h80sizc5Er2ymrrq25iNe",
	  layers: [{
	    ddd: 0,
	    ind: 389,
	    ty: 0,
	    nm: "",
	    td: 1,
	    ln: "precomp_hMJfYeRdmPzLAS0WsjpI0389",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "N6v7Yw7kiBsaBjAn5UDox"
	  }, {
	    ddd: 0,
	    ind: 387,
	    ty: 0,
	    nm: "",
	    tt: 1,
	    ln: "precomp_rZ5hwq43iYJex4vWukzxU387",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [100000, 100000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "lv902mpkKnKs4KAGHFTVs"
	  }]
	}, {
	  id: "kxVwi9q27bjAcuG7N1nQW",
	  layers: []
	}, {
	  id: "magxU3gtLMBZ17gAPutoG",
	  layers: []
	}, {
	  id: "0SXyaKAhdLu8sUlDt2Gex",
	  layers: [{
	    ddd: 0,
	    ind: 385,
	    ty: 0,
	    nm: "",
	    ln: "precomp_v7H5Jj3PvsOSAshBIR-ws385",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "a-QeGHIHr-WbGID61eMWZ"
	  }, {
	    ddd: 0,
	    ind: 386,
	    ty: 0,
	    nm: "",
	    ln: "precomp_rZ5hwq43iYJex4vWukzxU386",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "h80sizc5Er2ymrrq25iNe"
	  }, {
	    ddd: 0,
	    ind: 391,
	    ty: 0,
	    nm: "",
	    ln: "precomp_KMNvwpLZkhYe5QFqmbun6391",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "kxVwi9q27bjAcuG7N1nQW"
	  }, {
	    ddd: 0,
	    ind: 392,
	    ty: 0,
	    nm: "",
	    ln: "precomp_X0wEO3vJsc5DXoiBahLFz392",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "magxU3gtLMBZ17gAPutoG"
	  }]
	}, {
	  id: "r6jXlnFe9tvyjkLSCAImX",
	  layers: []
	}, {
	  id: "jKsVoK_W-Y4p5UsWXb5Vo",
	  layers: []
	}, {
	  id: "SVshibuIbjeUTypq9_LWE",
	  layers: [{
	    ddd: 0,
	    ind: 359,
	    ty: 0,
	    nm: "",
	    ln: "precomp_Rcjn5zTNshQ-XLjRD1Zoj359",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50052.64, 50006.5]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "vw3845df2EQ8Gs9DRlcA2"
	  }, {
	    ddd: 0,
	    ind: 368,
	    ty: 0,
	    nm: "",
	    ln: "precomp_WaPvC6HotFMxoVrIjmJkF368",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50010.91, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "EnjQBz_HFDyntdZnK5dBW"
	  }, {
	    ddd: 0,
	    ind: 384,
	    ty: 0,
	    nm: "",
	    ln: "precomp_AQkW5XqdPZr5kcTPf2N8U384",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49950.64, 50002.5]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "0SXyaKAhdLu8sUlDt2Gex"
	  }, {
	    ddd: 0,
	    ind: 393,
	    ty: 0,
	    nm: "",
	    ln: "precomp_pOAxlHLBhgqEwqmOvJ3LN393",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "r6jXlnFe9tvyjkLSCAImX"
	  }, {
	    ddd: 0,
	    ind: 394,
	    ty: 0,
	    nm: "",
	    ln: "precomp_QUlk4EDI8w3mlcgZRfUtc394",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    w: 100000,
	    h: 100000,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "jKsVoK_W-Y4p5UsWXb5Vo"
	  }]
	}, {
	  id: "sy8LGBUCGLLLqXqdgZtFk",
	  layers: []
	}, {
	  h: 146,
	  id: "ExQBSMtzZXTgsdVrHsmKj",
	  p: "data:image/png;base64,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",
	  u: "",
	  w: 195,
	  e: 1
	}, {
	  id: "BS2Nalc1X2YPvilZ_XDnH",
	  layers: [{
	    ddd: 0,
	    ind: 401,
	    ty: 2,
	    nm: "",
	    ln: "ExQBSMtzZXTgsdVrHsmKj401",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [49902.5, 49927]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    refId: "ExQBSMtzZXTgsdVrHsmKj"
	  }]
	}, {
	  id: "roer1RLq7zTPY0M1AaJvj",
	  layers: [{
	    ddd: 0,
	    ind: 403,
	    ty: 4,
	    nm: "",
	    ln: "eU_2kvDAEFvabLCZ6zTfq403",
	    sr: 1,
	    ks: {
	      a: {
	        a: 0,
	        k: [0, 0]
	      },
	      o: {
	        a: 0,
	        k: 100
	      },
	      p: {
	        a: 0,
	        k: [50000, 50000]
	      },
	      r: {
	        a: 0,
	        k: 0
	      },
	      s: {
	        a: 0,
	        k: [100, 100]
	      },
	      sk: {
	        a: 0,
	        k: 0
	      },
	      sa: {
	        a: 0,
	        k: 0
	      }
	    },
	    ao: 0,
	    ip: 0,
	    op: 181,
	    st: 0,
	    bm: 0,
	    shapes: [{
	      ty: "gr",
	      hd: false,
	      bm: 0,
	      it: [{
	        ty: "rc",
	        hd: false,
	        p: {
	          a: 0,
	          k: [0, 0]
	        },
	        r: {
	          a: 0,
	          k: 0
	        },
	        s: {
	          a: 0,
	          k: [195, 146]
	        }
	      }, {
	        ty: "fl",
	        hd: false,
	 