(function(t,e,s,a,i,n,r,o){"use strict";
/**
	 * Bitrix Messenger
	 * Message Vue component
	 *
	 * @package bitrix
	 * @subpackage im
	 * @copyright 2001-2019 Bitrix
	 */a.BitrixVue.component("bx-im-view-message",{props:{userId:{default:0},dialogId:{default:0},chatId:{default:0},enableReactions:{default:true},enableDateActions:{default:true},enableCreateContent:{default:true},enableGestureQuote:{default:true},enableGestureQuoteFromRight:{default:true},enableGestureMenu:{default:false},showAvatar:{default:true},showMenu:{default:true},showName:{default:true},showLargeFont:{default:true},capturedMoveEvent:{default:null},referenceContentClassName:{default:""},referenceContentBodyClassName:{default:""},referenceContentNameClassName:{default:""},message:{type:Object,default:s.MessagesModel.create().getElementState}},data:function t(){return{componentBodyId:"bx-im-view-message-body",drag:false,dragWidth:0,dragPosition:0,dragIconShowLeft:false,dragIconShowRight:false}},created:function t(){this.dragStartPositionX=0;this.dragStartPositionY=0;this.dragMovePositionX=0;this.dragMovePositionY=0},beforeDestroy:function t(){clearTimeout(this.dragStartTimeout1);clearTimeout(this.dragStartTimeout2);if(this.dragBackAnimation){r.Animation.cancel(this.dragBackAnimation)}},methods:{clickByAvatar:function t(e){o.EventEmitter.emit(i.EventType.dialog.clickOnUserName,e)},clickByMessageMenu:function t(e){o.EventEmitter.emit(i.EventType.dialog.clickOnMessageMenu,e)},clickByMessageRetry:function t(e){o.EventEmitter.emit(i.EventType.dialog.clickOnMessageRetry,e)},doubleClickByMessage:function t(e){o.EventEmitter.emit(i.EventType.dialog.doubleClickOnMessage,e)},gestureRouter:function t(e,s){this.gestureQuote(e,s);this.gestureMenu(e,s)},gestureMenu:function t(e,s){var a=this;if(!this.enableGestureMenu){return}if(e==="touchstart"){this.gestureMenuStarted=true;this.gestureMenuPreventTouchEnd=false;if(s.target.tagName==="A"){return false}this.gestureMenuStartPosition={x:s.changedTouches[0].clientX,y:s.changedTouches[0].clientY};this.gestureMenuTimeout=setTimeout((function(){a.gestureMenuPreventTouchEnd=true;a.clickByMessageMenu({message:a.message,event:s})}),500)}else if(e==="touchmove"){if(!this.gestureMenuStarted){return false}if(Math.abs(this.gestureMenuStartPosition.x-s.changedTouches[0].clientX)>=10||Math.abs(this.gestureMenuStartPosition.y-s.changedTouches[0].clientY)>=10){this.gestureMenuStarted=false;clearTimeout(this.gestureMenuTimeout)}}else if(e==="touchend"){if(!this.gestureMenuStarted){return false}this.gestureMenuStarted=false;clearTimeout(this.gestureMenuTimeout);if(this.gestureMenuPreventTouchEnd){s.preventDefault()}}},gestureQuote:function t(e,s){var a=this;var g=n.Utils.browser.findParent(s.target,"bx-im-message")||s.target;if(!this.enableGestureQuote||n.Utils.platform.isAndroid()){return}var d=this.enableGestureQuoteFromRight;var u=g.getBoundingClientRect().left+s.layerX;var l=g.getBoundingClientRect().top+s.layerY;if(e==="touchstart"){this.dragCheck=true;this.dragStartInitialX=g.getBoundingClientRect().left;this.dragStartInitialY=g.getBoundingClientRect().top;this.dragStartPositionX=u;this.dragStartPositionY=l;this.dragMovePositionX=null;this.dragMovePositionY=null;clearTimeout(this.dragStartTimeout1);clearTimeout(this.dragStartTimeout2);this.dragStartTimeout1=setTimeout((function(){if(a.dragMovePositionX!==null){if(Math.abs(a.dragStartPositionY-a.dragMovePositionY)>=10){a.dragCheck=false}}}),29);this.dragStartTimeout2=setTimeout((function(){a.dragCheck=false;if(Math.abs(a.dragStartPositionY-a.dragMovePositionY)>=10){return}if(a.dragMovePositionX===null){return}else if(d&&a.dragStartPositionX-a.dragMovePositionX<9){return}else if(!d&&a.dragStartPositionX-a.dragMovePositionX>9){return}r.Animation.cancel(a.dragBackAnimation);a.drag=true;a.$emit("dragMessage",{result:a.drag,event:s});a.dragWidth=a.$refs.body.offsetWidth}),80)}else if(e==="touchmove"){if(this.drag||!this.dragCheck){return false}this.dragMovePositionX=u;this.dragMovePositionY=l}else if(e==="touchend"){clearTimeout(this.dragStartTimeout1);clearTimeout(this.dragStartTimeout2);this.dragCheck=false;if(!this.drag){this.dragIconShowLeft=false;this.dragIconShowRight=false;return}r.Animation.cancel(this.dragBackAnimation);this.drag=false;this.$emit("dragMessage",{result:this.drag,event:s});if(this.enableGestureQuoteFromRight&&this.dragIconShowRight&&this.dragPosition!==0||!this.enableGestureQuoteFromRight&&this.dragIconShowLeft&&this.dragPosition!==this.dragStartInitialX){if(n.Utils.platform.isBitrixMobile()){setTimeout((function(){return app.exec("callVibration")}),200)}o.EventEmitter.emit(i.EventType.dialog.quoteMessage,{message:this.message})}this.dragIconShowLeft=false;this.dragIconShowRight=false;this.dragBackAnimation=r.Animation.start({start:this.dragPosition,end:this.dragStartInitialX,increment:20,duration:300,element:this,elementProperty:"dragPosition",callback:function t(){a.dragLayerPosition=undefined;a.dragWidth=0;a.dragPosition=0}})}}},watch:{capturedMoveEvent:function t(e){if(!this.drag||!e){return}var s=n.Utils.browser.findParent(e.target,"bx-im-message")||e.target;var a=s.getBoundingClientRect().left+e.layerX;if(typeof this.dragLayerPosition==="undefined"){this.dragLayerPosition=a}var i=this.dragLayerPosition-a;this.dragLayerPosition=a;this.dragPosition=this.dragPosition-i;if(this.enableGestureQuoteFromRight){var r=(this.showAvatar?30:0)+45;var o=this.showAvatar?30:30;if(this.dragPosition<-r){this.dragPosition=-r}else if(this.dragPosition<-o){if(!this.dragIconShowRight){this.dragIconShowRight=true}}else if(this.dragPosition>=0){this.dragPosition=0}}else{var g=60;var d=40;if(this.dragPosition<=this.dragStartInitialX){this.dragPosition=this.dragStartInitialX}else if(this.dragPosition>=g){this.dragPosition=g}else if(this.dragPosition>=d){if(!this.dragIconShowLeft){this.dragIconShowLeft=true}}}}},computed:{MessageType:function t(){return i.MessageType},dialog:function t(){var t=this.$store.getters["dialogues/get"](this.dialogId);return t?t:this.$store.getters["dialogues/getBlank"]()},type:function t(){if(this.message.system||this.message.authorId==0){return i.MessageType.system}else if(this.message.authorId===-1||this.message.authorId==this.userId){return i.MessageType.self}else{return i.MessageType.opponent}},userData:function t(){return this.$store.getters["users/get"](this.message.authorId,true)},userAvatar:function t(){if(this.message.params.AVATAR){return"url('".concat(this.message.params.AVATAR,"')")}if(this.userData.avatar){return"url('".concat(this.userData.avatar,"')")}return""},filesData:function t(){var e=this.$store.getters["files/getList"](this.chatId);return e?e:{}},isEdited:function t(){return this.message.params.IS_EDITED==="Y"},isDeleted:function t(){return this.message.params.IS_DELETED==="Y"},isLargeFont:function t(){return this.showLargeFont&&this.message.params.LARGE_FONT==="Y"}},template:'\n\t\t<div :class="[\'bx-im-message\', {\n\t\t\t\t\'bx-im-message-without-menu\': !showMenu,\n\t\t\t\t\'bx-im-message-without-avatar\': !showAvatar,\n\t\t\t\t\'bx-im-message-type-system\': type === MessageType.system,\n\t\t\t\t\'bx-im-message-type-self\': type === MessageType.self,\n\t\t\t\t\'bx-im-message-type-other\': type !== MessageType.self,\n\t\t\t\t\'bx-im-message-type-opponent\': type === MessageType.opponent,\n\t\t\t\t\'bx-im-message-status-error\': message.error,\n\t\t\t\t\'bx-im-message-status-unread\': message.unread,\n\t\t\t\t\'bx-im-message-status-blink\': message.blink,\n\t\t\t\t\'bx-im-message-status-edited\': isEdited,\n\t\t\t\t\'bx-im-message-status-deleted\': isDeleted,\n\t\t\t\t\'bx-im-message-large-font\': isLargeFont,\n\t\t\t}]" \n\t\t\t@touchstart="gestureRouter(\'touchstart\', $event)"\n\t\t\t@touchmove="gestureRouter(\'touchmove\', $event)"\n\t\t\t@touchend="gestureRouter(\'touchend\', $event)"\n\t\t\t@dblclick="doubleClickByMessage({message: message, event: $event})"\n\t\t\tref="body"\n\t\t\t:style="{\n\t\t\t\twidth: dragWidth > 0? dragWidth+\'px\': \'\', \n\t\t\t\tmarginLeft: (enableGestureQuoteFromRight && dragPosition < 0) || (!enableGestureQuoteFromRight && dragPosition > 0)? dragPosition+\'px\': \'\',\n\t\t\t}"\n\t\t>\n\t\t\t<template v-if="type === MessageType.self">\n\t\t\t\t<template v-if="dragIconShowRight">\n\t\t\t\t\t<div class="bx-im-message-reply bx-im-message-reply-right">\n\t\t\t\t\t\t<div class="bx-im-message-reply-icon"></div>\n\t\t\t\t\t</div>\n\t\t\t\t</template> \n\t\t\t\t<div class="bx-im-message-box">\n\t\t\t\t\t<component :is="componentBodyId"\n\t\t\t\t\t\t:userId="userId" \n\t\t\t\t\t\t:message="message"\n\t\t\t\t\t\t:dialogId="dialogId"\n\t\t\t\t\t\t:chatId="chatId"\n\t\t\t\t\t\t:messageType="type"\n\t\t\t\t\t\t:showAvatar="showAvatar"\n\t\t\t\t\t\t:showName="showName"\n\t\t\t\t\t\t:enableReactions="enableReactions"\n\t\t\t\t\t\t:referenceContentBodyClassName="referenceContentBodyClassName"\n\t\t\t\t\t\t:referenceContentNameClassName="referenceContentNameClassName"\n\t\t\t\t\t/>\n\t\t\t\t</div>\n\t\t\t\t<div class="bx-im-message-box-status">\n\t\t\t\t\t<template v-if="message.sending">\n\t\t\t\t\t\t<div class="bx-im-message-sending"></div>\n\t\t\t\t\t</template>\n\t\t\t\t\t<transition name="bx-im-message-status-retry">\n\t\t\t\t\t\t<template v-if="!message.sending && message.error && message.retry">\n\t\t\t\t\t\t\t<div class="bx-im-message-status-retry" :title="$Bitrix.Loc.getMessage(\'IM_MESSENGER_MESSAGE_RETRY_TITLE\')" @click="clickByMessageRetry({message: message, event: $event})">\n\t\t\t\t\t\t\t\t<span class="bx-im-message-retry-icon"></span>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</template>\n\t\t\t\t\t</transition>\n\t\t\t\t\t<template v-if="showMenu && !message.sending && !message.error">\n\t\t\t\t\t\t<div class="bx-im-message-status-menu" :title="$Bitrix.Loc.getMessage(\'IM_MESSENGER_MESSAGE_MENU_TITLE\')" @click="clickByMessageMenu({message: message, event: $event})">\n\t\t\t\t\t\t\t<span class="bx-im-message-menu-icon"></span>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</template> \n\t\t\t\t</div>\n\t\t\t\t<template v-if="dragIconShowLeft">\n\t\t\t\t\t<div class="bx-im-message-reply bx-im-message-reply-left">\n\t\t\t\t\t\t<div class="bx-im-message-reply-icon"></div>\n\t\t\t\t\t</div>\n\t\t\t\t</template> \n\t\t\t</template>\n\t\t\t<template v-else-if="type !== MessageType.self">\n\t\t\t\t<template v-if="dragIconShowLeft">\n\t\t\t\t\t<div class="bx-im-message-reply bx-im-message-reply-left">\n\t\t\t\t\t\t<div class="bx-im-message-reply-icon"></div>\n\t\t\t\t\t</div>\n\t\t\t\t</template> \n\t\t\t\t<template v-if="type === MessageType.opponent">\n\t\t\t\t\t<div v-if="showAvatar" class="bx-im-message-avatar" @click="clickByAvatar({user: userData, event: $event})">\n\t\t\t\t\t\t<div :class="[\'bx-im-message-avatar-image\', {\n\t\t\t\t\t\t\t\t\'bx-im-message-avatar-image-default\': !userData.avatar\n\t\t\t\t\t\t\t}]"\n\t\t\t\t\t\t\t:style="{\n\t\t\t\t\t\t\t\tbackgroundColor: !userData.avatar? userData.color: \'\', \n\t\t\t\t\t\t\t\tbackgroundImage: userAvatar\n\t\t\t\t\t\t\t}" \n\t\t\t\t\t\t\t:title="userData.name"\n\t\t\t\t\t\t></div>\t\n\t\t\t\t\t</div>\n\t\t\t\t</template>\n\t\t\t\t<div class="bx-im-message-box">\n\t\t\t\t\t<component :is="componentBodyId"\n\t\t\t\t\t\t:message="message"\n\t\t\t\t\t\t:userId="userId" \n\t\t\t\t\t\t:dialogId="dialogId"\n\t\t\t\t\t\t:chatId="chatId"\n\t\t\t\t\t\t:messageType="type"\n\t\t\t\t\t\t:files="filesData"\n\t\t\t\t\t\t:showAvatar="showAvatar"\n\t\t\t\t\t\t:showName="showName"\n\t\t\t\t\t\t:enableReactions="enableReactions"\n\t\t\t\t\t\t:referenceContentBodyClassName="referenceContentBodyClassName"\n\t\t\t\t\t\t:referenceContentNameClassName="referenceContentNameClassName"\n\t\t\t\t\t/>\n\t\t\t\t</div>\n\t\t\t\t<div v-if="showMenu"  class="bx-im-message-menu" :title="$Bitrix.Loc.getMessage(\'IM_MESSENGER_MESSAGE_MENU_TITLE\')" @click="clickByMessageMenu({message: message, event: $event})">\n\t\t\t\t\t<span class="bx-im-message-menu-icon"></span>\n\t\t\t\t</div>\t\n\t\t\t\t<template v-if="dragIconShowRight">\n\t\t\t\t\t<div class="bx-im-message-reply bx-im-message-reply-right">\n\t\t\t\t\t\t<div class="bx-im-message-reply-icon"></div>\n\t\t\t\t\t</div>\n\t\t\t\t</template> \n\t\t\t</template>\n\t\t</div>\n\t'})})(this.window=this.window||{},window,BX.Messenger.Model,BX,BX.Messenger.Const,BX.Messenger.Lib,BX.Messenger.Lib,BX.Event);
//# sourceMappingURL=message.bundle.map.js