(function(t,e,s,i,n){"use strict";e.Vue.component("bx-im-view-textarea",{props:{siteId:{default:"default"},userId:{default:0},dialogId:{default:0},enableCommand:{default:true},enableMention:{default:true},desktopMode:{default:false},enableEdit:{default:false},enableFile:{default:false},sendByEnter:{default:true},autoFocus:{default:null},writesEventLetter:{default:0},styles:{type:Object,default:function t(){return{}}},listenEventInsertText:{default:""},listenEventFocus:{default:""},listenEventBlur:{default:""}},data:function t(){return{placeholderMessage:"",currentMessage:"",previousMessage:"",commandListen:false,mentionListen:false,stylesDefault:Object.freeze({button:{backgroundColor:null,iconColor:null}})}},created:function t(){if(this.listenEventInsertText){e.Vue.event.$on(this.listenEventInsertText,this.onInsertText);this.$root.$on(this.listenEventInsertText,this.onInsertText)}if(this.listenEventFocus){e.Vue.event.$on(this.listenEventFocus,this.onFocusSet);this.$root.$on(this.listenEventFocus,this.onFocusSet)}if(this.listenEventBlur){e.Vue.event.$on(this.listenEventBlur,this.onFocusClear);this.$root.$on(this.listenEventBlur,this.onFocusClear)}this.localStorage=s.LocalStorage;this.textareaHistory=this.localStorage.get(this.siteId,this.userId,"textarea-history",{});this.currentMessage=this.textareaHistory[this.dialogId]||"";this.placeholderMessage=this.currentMessage},beforeDestroy:function t(){if(this.listenEventInsertText){e.Vue.event.$off(this.listenEventInsertText,this.onInsertText);this.$root.$off(this.listenEventInsertText,this.onInsertText)}if(this.listenEventFocus){e.Vue.event.$off(this.listenEventFocus,this.onFocusSet);this.$root.$off(this.listenEventFocus,this.onFocusSet)}if(this.listenEventBlur){e.Vue.event.$off(this.listenEventBlur,this.onFocusClear);this.$root.$off(this.listenEventBlur,this.onFocusClear)}clearTimeout(this.messageStoreTimeout);this.localStorage.set(this.siteId,this.userId,"textarea-history",this.textareaHistory);this.localStorage=null},computed:{textareaClassName:function t(){return"bx-im-textarea"+(i.Utils.device.isMobile()?" bx-im-textarea-mobile":"")},buttonStyle:function t(){var e=Object.assign({},this.stylesDefault,this.styles);var s=false;if(e.button.iconColor){s=i.Utils.isDarkColor(e.button.iconColor)}else{s=!i.Utils.isDarkColor(e.button.backgroundColor)}e.button.className=s?"bx-im-textarea-send-button":"bx-im-textarea-send-button bx-im-textarea-send-button-bright-arrow";e.button.style=e.button.backgroundColor?"background-color: "+e.button.backgroundColor+";":"";return e},localize:function t(){return e.Vue.getFilteredPhrases("BX_MESSENGER_TEXTAREA_",this.$root.$bitrixMessages)},isIE11:function t(){return n.Browser.isIE11()}},directives:{"bx-im-focus":{inserted:function t(e,s){if(s.value===true||s.value===null&&!i.Utils.device.isMobile()){e.focus()}}}},methods:{insertText:function t(e){var s=arguments.length>1&&arguments[1]!==undefined?arguments[1]:false;var i=arguments.length>2&&arguments[2]!==undefined?arguments[2]:"current";var n=arguments.length>3&&arguments[3]!==undefined?arguments[3]:"after";var a=arguments.length>4&&arguments[4]!==undefined?arguments[4]:true;var l=this.$refs.textarea;var o=l.selectionStart;var r=l.selectionEnd;if(i=="start"){if(s){e=e+"\n"}l.value=e+l.value;if(a){if(n=="after"){l.selectionStart=e.length;l.selectionEnd=l.selectionStart}else if(n=="before"){l.selectionStart=0;l.selectionEnd=l.selectionStart}}}else if(i=="current"){if(s){if(l.value.substring(0,o).trim().length>0){e="\n"+e}e=e+"\n"}else{if(l.value&&!l.value.endsWith(" ")){e=" "+e}}l.value=l.value.substring(0,o)+e+l.value.substring(r,l.value.length);if(a){if(n=="after"){l.selectionStart=o+e.length;l.selectionEnd=l.selectionStart}else if(n=="before"){l.selectionStart=o;l.selectionEnd=l.selectionStart}}}else if(i=="end"){if(s){if(l.value.substring(0,o).trim().length>0){e="\n"+e}e=e+"\n"}else{if(l.value&&!l.value.endsWith(" ")){e=" "+e}}l.value=l.value+e;if(a){if(n=="after"){l.selectionStart=l.value.length;l.selectionEnd=l.selectionStart}else if(n=="before"){l.selectionStart=l.value.length-e.length;l.selectionEnd=l.selectionStart}}}if(a){if(n=="start"){l.selectionStart=0;l.selectionEnd=0}else if(n=="end"){l.selectionStart=l.value.length;l.selectionEnd=l.selectionStart}l.focus()}this.textChangeEvent()},sendMessage:function t(e){e.preventDefault();this.$emit("send",{text:this.currentMessage.trim()});var s=this.$refs.textarea;if(s){s.value=""}if(this.autoFocus===null||this.autoFocus){s.focus()}this.textChangeEvent()},textChangeEvent:function t(){var e=this;var s=this.$refs.textarea;if(!s){return}var i=s.value.trim();if(this.currentMessage===i){return}if(this.writesEventLetter<=i.length){this.$emit("writes",{text:i})}this.previousMessage=this.currentMessage;this.previousSelectionStart=s.selectionStart;this.previousSelectionEnd=this.previousSelectionStart;this.currentMessage=i;if(i.toString().length>0){this.textareaHistory[this.dialogId]=i}else{delete this.textareaHistory[this.dialogId]}clearTimeout(this.messageStoreTimeout);this.messageStoreTimeout=setTimeout(function(){e.localStorage.set(e.siteId,e.userId,"textarea-history",e.textareaHistory,e.userId?0:10)},500)},onKeyDown:function t(e){this.$emit("keydown",e);var s=e.target;var n=s.value.trim();var a=i.Utils.platform.isMac();var l=i.Utils.platform.isBitrixDesktop()||!i.Utils.browser.isChrome();if(this.commandListen);else if(this.mentionListen);else if(!(e.altKey&&e.ctrlKey)){if(this.enableMention&&e.shiftKey&&(e.keyCode==61||e.keyCode==50||e.keyCode==187||e.keyCode==187)||e.keyCode==107);else if(this.enableCommand&&(e.keyCode==191||e.keyCode==111||e.keyCode==220));}if(e.keyCode==27){if(s.value!=""&&s===document.activeElement){e.preventDefault();e.stopPropagation()}if(e.shiftKey){s.value=""}}else if(e.metaKey||e.ctrlKey){if(l&&e.key==="t"||!l&&e.key==="e"){e.preventDefault()}else if(["b","s","i","u"].includes(e.key)){var o=s.selectionStart;var r=s.selectionEnd;var u="["+e.key.toLowerCase()+"]";var c="[/"+e.key.toLowerCase()+"]";var f=s.value.substring(o,r);if(f.startsWith(u)&&f.endsWith(c)){f=f.substring(u.length,f.indexOf(c))}else{f=u+f+c}s.value=s.value.substring(0,o)+f+s.value.substring(r,s.value.length);s.selectionStart=o;s.selectionEnd=o+f.length;e.preventDefault()}}if(e.keyCode==9){this.insertText("\t");e.preventDefault()}else if(this.enableEdit&&e.keyCode==38&&n.length<=0){this.$emit("edit",{})}else if(e.keyCode==13){if(i.Utils.device.isMobile());else if(this.sendByEnter==true){if(e.ctrlKey||e.altKey||e.shiftKey){if(!e.shiftKey){this.insertText("\n")}}else if(n.length<=0){e.preventDefault()}else{this.sendMessage(e)}}else{if(e.ctrlKey==true){this.sendMessage(e)}else if(a&&(e.metaKey==true||e.altKey==true)){this.sendMessage(e)}}}else if((e.ctrlKey||e.metaKey)&&e.key=="z"){if(this.previousMessage){s.value=this.previousMessage;s.selectionStart=this.previousSelectionStart;s.selectionEnd=this.previousSelectionEnd;this.previousMessage="";e.preventDefault()}}},onKeyUp:function t(e){this.$emit("keyup",{event:e,text:this.currentMessage});this.textChangeEvent()},onPaste:function t(e){this.$nextTick(this.textChangeEvent)},onInput:function t(e){this.textChangeEvent()},onFocus:function t(e){this.$emit("focus",e)},onBlur:function t(e){this.$emit("blur",e)},onAppButtonClick:function t(e,s){this.$emit("appButtonClick",{appId:e,event:s})},onInsertText:function t(){var e=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};if(!e.text){return false}this.insertText(e.text,e.breakline,e.position,e.cursor,e.focus);this.$emit("keyup",{event:e,text:this.currentMessage});return true},onFocusSet:function t(){this.$refs.textarea.focus();return true},onFocusClear:function t(){this.$refs.textarea.blur();return true},onFileClick:function t(e){e.target.value=""},onFileSelect:function t(e){this.$emit("fileSelected",{fileChangeEvent:e,fileInput:e.target})},log:function t(e,s,i){console.warn(e);if(s==1){i.preventDefault()}},preventDefault:function t(e){e.preventDefault()}},template:'\n\t\t<div :class="textareaClassName">\n\t\t\t<div class="bx-im-textarea-box">\n\t\t\t\t<textarea ref="textarea" class="bx-im-textarea-input" @keydown="onKeyDown" @keyup="onKeyUp" @paste="onPaste" @input="onInput" @focus="onFocus" @blur="onBlur" v-bx-im-focus="autoFocus" :placeholder="localize.BX_MESSENGER_TEXTAREA_PLACEHOLDER">{{placeholderMessage}}</textarea>\n\t\t\t\t<transition enter-active-class="bx-im-textarea-send-button-show" leave-active-class="bx-im-textarea-send-button-hide">\n\t\t\t\t\t<button \n\t\t\t\t\t\tv-if="currentMessage" \n\t\t\t\t\t\t:class="buttonStyle.button.className" \n\t\t\t\t\t\t:style="buttonStyle.button.style" \n\t\t\t\t\t\t:title="localize.BX_MESSENGER_TEXTAREA_BUTTON_SEND"\n\t\t\t\t\t\t@click="sendMessage" \n\t\t\t\t\t\t@touchend="sendMessage" \n\t\t\t\t\t\t@mousedown="preventDefault" \n\t\t\t\t\t\t@touchstart="preventDefault" \n\t\t\t\t\t/>\n\t\t\t\t</transition>\n\t\t\t</div>\n\t\t\t<div class="bx-im-textarea-app-box">\n\t\t\t\t<label v-if="enableFile && !isIE11" class="bx-im-textarea-app-button bx-im-textarea-app-file" :title="localize.BX_MESSENGER_TEXTAREA_FILE">\n\t\t\t\t\t<input type="file" @click="onFileClick($event)" @change="onFileSelect($event)" multiple>\n\t\t\t\t</label>\n\t\t\t\t<button class="bx-im-textarea-app-button bx-im-textarea-app-smile" :title="localize.BX_MESSENGER_TEXTAREA_SMILE" @click="onAppButtonClick(\'smile\', $event)"></button>\n\t\t\t\t<button v-if="false" class="bx-im-textarea-app-button bx-im-textarea-app-gif" :title="localize.BX_MESSENGER_TEXTAREA_GIPHY" @click="onAppButtonClick(\'giphy\', $event)"></button>\n\t\t\t</div>\n\t\t</div>\n\t'})})(this.window=this.window||{},BX,BX.Messenger.Lib,BX.Messenger.Lib,BX);
//# sourceMappingURL=textarea.bundle.map.js