(function(e){"use strict";BX.Vue.component("bx-messenger-textarea",{props:{siteId:{default:"default"},userId:{default:0},dialogId:{default:0},enableCommand:{default:true},enableMention:{default:true},desktopMode:{default:false},enableEdit:{default:false},enableFile:{default:false},sendByEnter:{default:true},autoFocus:{default:null},writesEventLetter:{default:0},styles:{type:Object,default:function e(){return{}}},listenEventInsertText:{default:""},listenEventFocus:{default:""},listenEventBlur:{default:""}},data:function e(){return{placeholderMessage:"",currentMessage:"",previousMessage:"",commandListen:false,mentionListen:false,stylesDefault:Object.freeze({button:{backgroundColor:null,iconColor:null}})}},created:function e(){if(this.listenEventInsertText){BX.Vue.event.$on(this.listenEventInsertText,this.onInsertText);this.$root.$on(this.listenEventInsertText,this.onInsertText)}if(this.listenEventFocus){BX.Vue.event.$on(this.listenEventFocus,this.onFocusSet);this.$root.$on(this.listenEventFocus,this.onFocusSet)}if(this.listenEventBlur){BX.Vue.event.$on(this.listenEventBlur,this.onFocusClear);this.$root.$on(this.listenEventBlur,this.onFocusClear)}this.localStorage=BX.Messenger.LocalStorage;this.textareaHistory=this.localStorage.get(this.siteId,this.userId,"textarea-history",{});this.currentMessage=this.textareaHistory[this.dialogId]||"";this.placeholderMessage=this.currentMessage},beforeDestroy:function e(){if(this.listenEventInsertText){BX.Vue.event.$off(this.listenEventInsertText,this.onInsertText);this.$root.$off(this.listenEventInsertText,this.onInsertText)}if(this.listenEventFocus){BX.Vue.event.$off(this.listenEventFocus,this.onFocusSet);this.$root.$off(this.listenEventFocus,this.onFocusSet)}if(this.listenEventBlur){BX.Vue.event.$off(this.listenEventBlur,this.onFocusClear);this.$root.$off(this.listenEventBlur,this.onFocusClear)}clearTimeout(this.messageStoreTimeout);this.localStorage.set(this.siteId,this.userId,"textarea-history",this.textareaHistory);this.localStorage=null},computed:{textareaClassName:function e(){return"bx-im-textarea"+(BX.Messenger.Utils.device.isMobile()?" bx-im-textarea-mobile":"")},buttonStyle:function e(){var t=Object.assign({},this.stylesDefault,this.styles);var s=false;if(t.button.iconColor){s=BX.Messenger.Utils.isDarkColor(t.button.iconColor)}else{s=!BX.Messenger.Utils.isDarkColor(t.button.backgroundColor)}t.button.className=s?"bx-im-textarea-send-button":"bx-im-textarea-send-button bx-im-textarea-send-button-bright-arrow";t.button.style=t.button.backgroundColor?"background-color: "+t.button.backgroundColor+";":"";return t},localize:function e(){return BX.Vue.getFilteredPhrases("BX_MESSENGER_TEXTAREA_",this.$root.$bitrixMessages)}},directives:{"bx-im-focus":{inserted:function e(t,s){if(s.value===true||s.value===null&&!BX.Messenger.Utils.device.isMobile()){t.focus()}}}},methods:{insertText:function e(t){var s=arguments.length>1&&arguments[1]!==undefined?arguments[1]:false;var i=arguments.length>2&&arguments[2]!==undefined?arguments[2]:"current";var n=arguments.length>3&&arguments[3]!==undefined?arguments[3]:"after";var a=arguments.length>4&&arguments[4]!==undefined?arguments[4]:true;var o=this.$refs.textarea;var l=o.selectionStart;var r=o.selectionEnd;if(i=="start"){if(s){t=t+"\n"}o.value=t+o.value;if(a){if(n=="after"){o.selectionStart=t.length;o.selectionEnd=o.selectionStart}else if(n=="before"){o.selectionStart=0;o.selectionEnd=o.selectionStart}}}else if(i=="current"){if(s){if(o.value.substring(0,l).trim().length>0){t="\n"+t}t=t+"\n"}o.value=o.value.substring(0,l)+t+o.value.substring(r,o.value.length);if(a){if(n=="after"){o.selectionStart=l+t.length;o.selectionEnd=o.selectionStart}else if(n=="before"){o.selectionStart=l;o.selectionEnd=o.selectionStart}}}else if(i=="end"){if(s){if(o.value.substring(0,l).trim().length>0){t="\n"+t}t=t+"\n"}o.value=o.value+t;if(a){if(n=="after"){o.selectionStart=o.value.length;o.selectionEnd=o.selectionStart}else if(n=="before"){o.selectionStart=o.value.length-t.length;o.selectionEnd=o.selectionStart}}}if(a){if(n=="start"){o.selectionStart=0;o.selectionEnd=0}else if(n=="end"){o.selectionStart=o.value.length;o.selectionEnd=o.selectionStart}o.focus()}this.textChangeEvent()},sendMessage:function e(){this.$emit("send",{text:this.currentMessage.trim()});var t=this.$refs.textarea;if(t){t.value=""}if(this.autoFocus===null||this.autoFocus){t.focus()}this.textChangeEvent()},textChangeEvent:function e(){var t=this;var s=this.$refs.textarea;if(!s){return}var i=s.value.trim();if(this.currentMessage===i){return}if(this.writesEventLetter<=i.length){this.$emit("writes",{text:i})}this.previousMessage=this.currentMessage;this.previousSelectionStart=s.selectionStart;this.previousSelectionEnd=this.previousSelectionStart;this.currentMessage=i;if(i.toString().length>0){this.textareaHistory[this.dialogId]=i}else{delete this.textareaHistory[this.dialogId]}clearTimeout(this.messageStoreTimeout);this.messageStoreTimeout=setTimeout(function(){t.localStorage.set(t.siteId,t.userId,"textarea-history",t.textareaHistory,t.userId?0:10)},500)},onKeyDown:function e(t){this.$emit("keydown",t);var s=t.target;var i=s.value.trim();var n=BX.Messenger.Utils.platform.isMac();var a=BX.Messenger.Utils.platform.isBitrixDesktop()||!BX.Messenger.Utils.browser.isChrome();if(this.commandListen);else if(this.mentionListen);else if(!(t.altKey&&t.ctrlKey)){if(this.enableMention&&t.shiftKey&&(t.keyCode==61||t.keyCode==50||t.keyCode==187||t.keyCode==187)||t.keyCode==107);else if(this.enableCommand&&(t.keyCode==191||t.keyCode==111||t.keyCode==220));}if(t.keyCode==27){if(s.value!=""&&s===document.activeElement){t.preventDefault();t.stopPropagation()}if(t.shiftKey){s.value=""}}else if(t.metaKey||t.ctrlKey){if(a&&t.key==="t"||!a&&t.key==="e"){t.preventDefault()}else if(["b","s","i","u"].includes(t.key)){var o=s.selectionStart;var l=s.selectionEnd;var r="["+t.key.toLowerCase()+"]";var u="[/"+t.key.toLowerCase()+"]";var c=s.value.substring(o,l);if(c.startsWith(r)&&c.endsWith(u)){c=c.substring(r.length,c.indexOf(u))}else{c=r+c+u}s.value=s.value.substring(0,o)+c+s.value.substring(l,s.value.length);s.selectionStart=o;s.selectionEnd=o+c.length;t.preventDefault()}}if(t.keyCode==9){this.insertText("\t");t.preventDefault()}else if(this.enableEdit&&t.keyCode==38&&i.length<=0){this.$emit("edit",{})}else if(t.keyCode==13){if(BX.Messenger.Utils.device.isMobile());else if(this.sendByEnter==true){if(t.ctrlKey||t.altKey||t.shiftKey){if(!t.shiftKey){this.insertText("\n")}}else if(i.length<=0){t.preventDefault()}else{this.sendMessage();t.preventDefault()}}else{if(t.ctrlKey==true){this.sendMessage();t.preventDefault()}else if(n&&(t.metaKey==true||t.altKey==true)){this.sendMessage();t.preventDefault()}}}else if((t.ctrlKey||t.metaKey)&&t.key=="z"){if(this.previousMessage){s.value=this.previousMessage;s.selectionStart=this.previousSelectionStart;s.selectionEnd=this.previousSelectionEnd;this.previousMessage="";t.preventDefault()}}},onKeyUp:function e(t){this.$emit("keyup",t);this.textChangeEvent()},onPaste:function e(t){this.$nextTick(this.textChangeEvent)},onInput:function e(t){this.textChangeEvent()},onFocus:function e(t){this.$emit("focus",t)},onBlur:function e(t){this.$emit("blur",t)},onAppButtonClick:function e(t,s){this.$emit("appButtonClick",{appId:t,event:s})},onInsertText:function e(){var t=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};if(!t.text){return false}this.insertText(t.text,t.breakline,t.position,t.cursor,t.focus);return true},onFocusSet:function e(){this.$refs.textarea.focus();return true},onFocusClear:function e(){this.$refs.textarea.blur();return true},onFileClick:function e(t){t.target.value=""},onFileSelect:function e(t){this.$emit("fileSelected",{fileInput:t.target})}},template:'\n\t\t<div :class="textareaClassName">\n\t\t\t<div class="bx-im-textarea-box">\n\t\t\t\t<textarea ref="textarea" class="bx-im-textarea-input" @keydown="onKeyDown" @keyup="onKeyUp" @paste="onPaste" @input="onInput" @focus="onFocus" @blur="onBlur" v-bx-im-focus="autoFocus" :placeholder="localize.BX_MESSENGER_TEXTAREA_PLACEHOLDER">{{placeholderMessage}}</textarea>\n\t\t\t\t<transition enter-active-class="bx-im-textarea-send-button-show" leave-active-class="bx-im-textarea-send-button-hide">\n\t\t\t\t\t<button v-if="currentMessage" :class="buttonStyle.button.className" :style="buttonStyle.button.style" @click="sendMessage" :title="localize.BX_MESSENGER_TEXTAREA_BUTTON_SEND"></button>\n\t\t\t\t</transition>\n\t\t\t</div>\n\t\t\t<div class="bx-im-textarea-app-box">\n\t\t\t\t<label v-if="enableFile" class="bx-im-textarea-app-button bx-im-textarea-app-file" :title="localize.BX_MESSENGER_TEXTAREA_FILE"><input type="file" @click="onFileClick($event)" @change="onFileSelect($event)"></label>\n\t\t\t\t<button class="bx-im-textarea-app-button bx-im-textarea-app-smile" :title="localize.BX_MESSENGER_TEXTAREA_SMILE" @click="onAppButtonClick(\'smile\', $event)"></button>\n\t\t\t\t<button v-if="false" class="bx-im-textarea-app-button bx-im-textarea-app-gif" :title="localize.BX_MESSENGER_TEXTAREA_GIPHY" @click="onAppButtonClick(\'giphy\', $event)"></button>\n\t\t\t</div>\n\t\t</div>\n\t'})})(this.window=this.window||{});
//# sourceMappingURL=messenger.component.textarea.bundle.map.js