<?php

namespace Bitrix\Im\V2\Chat;

use Bitrix\Im\V2\Error;
use Bitrix\Main\Localization\Loc;

class ChatError extends Error
{
	public const
		WRONG_TYPE = 'WRONG_MESSAGE_TYPE',
		WRONG_PARAMETER = 'WRONG_PARAMETER',
		WRONG_SENDER = 'WRONG_SENDER',
		WRONG_RECIPIENT = 'WRONG_RECIPIENT',
		WRONG_TARGET_CHAT = 'WRONG_TARGET_CHAT',
		WRONG_COLOR = 'WRONG_COLOR',
		WRONG_PARENT_CHAT = 'WRONG_PARENT_CHAT',
		WRONG_PARENT_MESSAGE = 'WRONG_PARENT_MESSAGE',
		WRONG_DISAPPEARING_DURATION = 'WRONG_DISAPPEARING_DURATION',
		ALREADY_DISAPPEARING = 'ALREADY_DISAPPEARING',
		ACCESS_DENIED = 'ACCESS_DENIED',
		NOT_FOUND = 'CHAT_NOT_FOUND',
		BEFORE_SEND_EVENT = 'EVENT_MESSAGE_SEND',
		FROM_OTHER_MODULE = 'FROM_OTHER_MODULE',
		CREATION_ERROR = 'CREATION_ERROR',
		ID_EMPTY_ERROR = 'ID_EMPTY_ERROR',
		INVALID_PIN_POSITION = 'INVALID_PIN_POSITION',
		MAX_PINNED_CHATS_ERROR = 'MAX_PINNED_CHATS_ERROR',
		USER_ID_EMPTY_ERROR = 'USER_ID_EMPTY_ERROR',
		IMBOT_NOT_INSTALLED = 'IMBOT_NOT_INSTALLED',
		COPILOT_NOT_INSTALLED = 'COPILOT_NOT_INSTALLED',
		COPILOT_DELETE_ERROR = 'COPILOT_DELETE_ERROR',
		TASK_ACCESS_ERROR = 'TASK_ACCESS_ERROR',
		CONVERT_ERROR = 'CONVERT_ERROR',
		WRONG_CHAT_TYPE = 'WRONG_CHAT_TYPE',
		ENTITY_ID_EMPTY = 'ENTITY_ID_EMPTY',
		MANAGE_ACCESS_DENIED = 'MANAGE_ACCESS_DENIED'
	;

	protected function loadErrorMessage($code, $replacements): string
	{
		return Loc::getMessage("ERROR_CHAT_{$code}", $replacements) ?: '';
	}

	protected function loadErrorDescription($code, $replacements): string
	{
		return Loc::getMessage("ERROR_CHAT_{$code}_DESC", $replacements) ?: '';
	}
}