<?php

namespace Bitrix\Im\V2\Message;

use Bitrix\Im\V2\Error;
use Bitrix\Main\Localization\Loc;

class MessageError extends Error
{
	public const
		WRONG_PARAMETER = 'WRONG_PARAMETER',
		WRONG_SENDER = 'WRONG_SENDER',
		EMPTY_MESSAGE = 'EMPTY_MESSAGE',
		NOTIFY_MODULE = 'NOTIFY_MODULE',
		NOTIFY_EVENT = 'NOTIFY_EVENT',
		NOTIFY_TYPE = 'NOTIFY_TYPE',
		NOTIFY_BUTTONS = 'NOTIFY_BUTTONS',
		MESSAGE_NOT_FOUND = 'MESSAGE_NOT_FOUND',
		MESSAGE_DUPLICATED_BY_UUID = 'MESSAGE_DUPLICATED_BY_UUID',
		MESSAGE_IS_ALREADY_FAVORITE = 'MESSAGE_IS_ALREADY_FAVORITE',
		MESSAGE_IS_ALREADY_PIN = 'MESSAGE_IS_ALREADY_PIN',
		MESSAGE_IS_ALREADY_IN_REMINDERS = 'MESSAGE_IS_ALREADY_IN_REMINDERS',
		ACCESS_DENIED = 'MESSAGE_ACCESS_DENIED',
		MESSAGE_ACCESS_DENIED_BY_TARIFF = 'MESSAGE_ACCESS_DENIED_BY_TARIFF',
		NOT_FOUND = 'MESSAGE_NOT_FOUND',
		MESSAGE_TOO_OLD_FOR_DELETION = 'MESSAGE_TOO_OLD_FOR_DELETION',
		DIFFERENT_CHAT_ERROR = 'MESSAGES_IN_DIFFERENT_CHAT_ERROR',
		TOO_MANY_MESSAGES = 'TOO_MANY_MESSAGES',
		SENDING_FAILED = 'SENDING_FAILED',
		MARK_FAILED = 'MESSAGE_MARK_FAILED',
		INFORM_USER_CONTEXT_ERROR = 'INFORM_USER_CONTEXT_ERROR',
		INFORM_VIEWED_ERROR = 'INFORM_VIEWED_ERROR',
		INFORM_TIMEOUT_ERROR = 'INFORM_TIMEOUT_ERROR',
		INFORM_USER_STATUS_ERROR = 'INFORM_USER_STATUS_ERROR',
		REPLY_ERROR = 'REPLY_ERROR',
		PARAMS_ERROR = 'PARAMS_ERROR',
		WRONG_UUID = 'WRONG_UUID'
	;

	protected function loadErrorMessage($code, $replacements): string
	{
		return Loc::getMessage("ERROR_MESSAGE_{$code}", $replacements) ?: '';
	}

	protected function loadErrorDescription($code, $replacements): string
	{
		return Loc::getMessage("ERROR_MESSAGE_{$code}_DESC", $replacements) ?: '';
	}
}