CREATE TABLE b_ldap_server (
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	NAME varchar(255) NOT NULL,
	DESCRIPTION text,
	CODE varchar(255),
	ACTIVE char(1) NOT NULL DEFAULT 'Y',
	SERVER varchar(255) NOT NULL,
	PORT int NOT NULL DEFAULT 389,
	ADMIN_LOGIN varchar(255) NOT NULL,
	ADMIN_PASSWORD varchar(255) NOT NULL,
	BASE_DN varchar(255) NOT NULL,
	GROUP_FILTER text NOT NULL,
	GROUP_ID_ATTR varchar(255) NOT NULL,
	GROUP_NAME_ATTR varchar(255),
	GROUP_MEMBERS_ATTR varchar(255),
	USER_FILTER text NOT NULL,
	USER_ID_ATTR varchar(255) NOT NULL,
	USER_NAME_ATTR varchar(255),
	USER_LAST_NAME_ATTR varchar(255),
	USER_EMAIL_ATTR varchar(255),
	USER_GROUP_ATTR varchar(255),
	USER_GROUP_ACCESSORY char(1) DEFAULT 'N',
	USER_DEPARTMENT_ATTR varchar(255),
	USER_MANAGER_ATTR varchar(255),
	CONVERT_UTF8 char(1) DEFAULT 'N',
	SYNC_PERIOD int,
	FIELD_MAP text,
	ROOT_DEPARTMENT int,
	DEFAULT_DEPARTMENT_NAME varchar(255),
	IMPORT_STRUCT char(1) DEFAULT 'N',
	STRUCT_HAVE_DEFAULT char(1),
	SET_DEPARTMENT_HEAD char(1) DEFAULT 'Y',
	SYNC char(1),
	SYNC_ATTR varchar(255),
	SYNC_LAST timestamp,
	MAX_PAGE_SIZE int,
	LDAP_OPT_TIMELIMIT int NOT NULL DEFAULT 100,
	LDAP_OPT_TIMEOUT int NOT NULL DEFAULT 5,
	LDAP_OPT_NETWORK_TIMEOUT int NOT NULL DEFAULT 5,
	SYNC_USER_ADD char(1),
	CONNECTION_TYPE int,
	PRIMARY KEY (ID)
);

CREATE TABLE b_ldap_group (
	LDAP_SERVER_ID int NOT NULL,
	GROUP_ID int NOT NULL,
	LDAP_GROUP_ID varchar(255) NOT NULL,
	PRIMARY KEY (LDAP_SERVER_ID, GROUP_ID, LDAP_GROUP_ID)
);
