<?php

use Bitrix\Main\Loader;

//main is usually included directly
$moduleRoot = realpath(__DIR__ . '/../');
foreach(
	[
		'Bitrix\\Main' => '/lib',
		'Psr\\Container' => '/vendor/psr/container/src',
		'Psr\\Log' => '/vendor/psr/log/src',
		'Psr\\Http\\Message' => '/vendor/psr/http-message/src',
		'Psr\\Http\\Client' => '/vendor/psr/http-client/src',
		'Http\\Promise' => '/vendor/php-http/promise/src',
		'PHPMailer\\PHPMailer' => '/vendor/phpmailer/phpmailer/src',
		'GeoIp2' => '/vendor/geoip2/geoip2/src',
		'MaxMind\\Db' => '/vendor/maxmind-db/reader/src/MaxMind/Db',
		'PhpParser' => '/vendor/nikic/php-parser/lib/PhpParser',
	]
	as $namespace => $namespacePath
)
{
	Loader::registerNamespace($namespace, $moduleRoot . $namespacePath);
}

$documentRoot = Loader::getDocumentRoot();
Loader::registerNamespace('Bitrix\\UI', $documentRoot . '/bitrix/modules/ui/lib');

unset($namespace, $namespacePath);

if (is_dir($moduleRoot . '/dev'))
{
	// developer mode
	Loader::registerNamespace('Dev\Main', $moduleRoot . '/dev');
}

spl_autoload_register([Loader::class, 'autoLoad']);

Loader::registerAutoLoadClasses(
	'main',
	[
		'bitrix\\main\\application' => 'lib/application.php',
		'bitrix\\main\\httpapplication' => 'lib/httpapplication.php',
		'bitrix\\main\\argumentexception' => 'lib/exception.php',
		'bitrix\\main\\argumentnullexception' => 'lib/exception.php',
		'bitrix\\main\\argumentoutofrangeexception' => 'lib/exception.php',
		'bitrix\\main\\argumenttypeexception' => 'lib/exception.php',
		'bitrix\\main\\notimplementedexception' => 'lib/exception.php',
		'bitrix\\main\\notsupportedexception' => 'lib/exception.php',
		'bitrix\\main\\invalidoperationexception' => 'lib/exception.php',
		'bitrix\\main\\objectpropertyexception' => 'lib/exception.php',
		'bitrix\\main\\objectnotfoundexception' => 'lib/exception.php',
		'bitrix\\main\\objectexception' => 'lib/exception.php',
		'bitrix\\main\\systemexception' => 'lib/exception.php',
		'bitrix\\main\\accessdeniedexception' => 'lib/exception.php',
		'bitrix\\main\\decodingexception' => 'lib/exception.php',
		'bitrix\\main\\io\\invalidpathexception' => 'lib/io/ioexception.php',
		'bitrix\\main\\io\\filenotfoundexception' => 'lib/io/ioexception.php',
		'bitrix\\main\\io\\filedeleteexception' => 'lib/io/ioexception.php',
		'bitrix\\main\\io\\fileopenexception' => 'lib/io/ioexception.php',
		'bitrix\\main\\io\\filenotopenedexception' => 'lib/io/ioexception.php',
		'bitrix\\main\\context' => 'lib/context.php',
		'bitrix\\main\\httpcontext' => 'lib/httpcontext.php',
		'bitrix\\main\\dispatcher' => 'lib/dispatcher.php',
		'bitrix\\main\\environment' => 'lib/environment.php',
		'bitrix\\main\\event' => 'lib/event.php',
		'bitrix\\main\\eventmanager' => 'lib/eventmanager.php',
		'bitrix\\main\\eventresult' => 'lib/eventresult.php',
		'bitrix\\main\\request' => 'lib/request.php',
		'bitrix\\main\\httprequest' => 'lib/httprequest.php',
		'bitrix\\main\\response' => 'lib/response.php',
		'bitrix\\main\\httpresponse' => 'lib/httpresponse.php',
		'bitrix\\main\\modulemanager' => 'lib/modulemanager.php',
		'bitrix\\main\\server' => 'lib/server.php',
		'bitrix\\main\\config\\configuration' => 'lib/config/configuration.php',
		'bitrix\\main\\config\\option' => 'lib/config/option.php',
		'bitrix\\main\\context\\culture' => 'lib/context/culture.php',
		'bitrix\\main\\data\\cache' => 'lib/data/cache.php',
		'bitrix\\main\\data\\cacheengineapc' => 'lib/data/cacheengineapc.php',
		'bitrix\\main\\data\\cacheenginememcache' => 'lib/data/cacheenginememcache.php',
		'bitrix\\main\\data\\cacheenginefiles' => 'lib/data/cacheenginefiles.php',
		'bitrix\\main\\data\\cacheenginenone' => 'lib/data/cacheenginenone.php',
		'bitrix\\main\\data\\connection' => 'lib/data/connection.php',
		'bitrix\\main\\data\\connectionpool' => 'lib/data/connectionpool.php',
		'bitrix\\main\\data\\icacheengine' => 'lib/data/cache.php',
		'bitrix\\main\\data\\hsphpreadconnection' => 'lib/data/hsphpreadconnection.php',
		'bitrix\\main\\data\\managedcache' => 'lib/data/managedcache.php',
		'bitrix\\main\\data\\taggedcache' => 'lib/data/taggedcache.php',
		'bitrix\\main\\data\\memcacheconnection' => 'lib/data/memcacheconnection.php',
		'bitrix\\main\\data\\memcachedconnection' => 'lib/data/memcachedconnection.php',
		'bitrix\\main\\data\\nosqlconnection' => 'lib/data/nosqlconnection.php',
		'bitrix\\main\\db\\arrayresult' => 'lib/db/arrayresult.php',
		'bitrix\\main\\db\\result' => 'lib/db/result.php',
		'bitrix\\main\\db\\connection' => 'lib/db/connection.php',
		'bitrix\\main\\db\\sqlexception' => 'lib/db/sqlexception.php',
		'bitrix\\main\\db\\sqlqueryexception' => 'lib/db/sqlexception.php',
		'bitrix\\main\\db\\transactionexception' => 'lib/db/sqlexception.php',
		'bitrix\\main\\db\\duplicateentryexception' => 'lib/db/sqlexception.php',
		'bitrix\\main\\db\\sqlexpression' => 'lib/db/sqlexpression.php',
		'bitrix\\main\\db\\sqlhelper' => 'lib/db/sqlhelper.php',
		'bitrix\\main\\db\\mysqlcommonconnection' => 'lib/db/mysqlcommonconnection.php',
		'bitrix\\main\\db\\mysqliconnection' => 'lib/db/mysqliconnection.php',
		'bitrix\\main\\db\\mysqliresult' => 'lib/db/mysqliresult.php',
		'bitrix\\main\\db\\mysqlisqlhelper' => 'lib/db/mysqlisqlhelper.php',
		'bitrix\\main\\db\\mssqlconnection' => 'lib/db/mssqlconnection.php',
		'bitrix\\main\\db\\mssqlresult' => 'lib/db/mssqlresult.php',
		'bitrix\\main\\db\\mssqlsqlhelper' => 'lib/db/mssqlsqlhelper.php',
		'bitrix\\main\\db\\oracleconnection' => 'lib/db/oracleconnection.php',
		'bitrix\\main\\db\\oracleresult' => 'lib/db/oracleresult.php',
		'bitrix\\main\\db\\oraclesqlhelper' => 'lib/db/oraclesqlhelper.php',
		'bitrix\\main\\db\\pgsqlconnection' => 'lib/db/pgsqlconnection.php',
		'bitrix\\main\\diag\\httpexceptionhandleroutput' => 'lib/diag/httpexceptionhandleroutput.php',
		'bitrix\\main\\diag\\fileexceptionhandlerlog' => 'lib/diag/fileexceptionhandlerlog.php',
		'bitrix\\main\\diag\\exceptionhandler' => 'lib/diag/exceptionhandler.php',
		'bitrix\\main\\diag\\iexceptionhandleroutput' => 'lib/diag/iexceptionhandleroutput.php',
		'bitrix\\main\\diag\\exceptionhandlerlog' => 'lib/diag/exceptionhandlerlog.php',
		'bitrix\\main\\io\\file' => 'lib/io/file.php',
		'bitrix\\main\\io\\fileentry' => 'lib/io/fileentry.php',
		'bitrix\\main\\io\\path' => 'lib/io/path.php',
		'bitrix\\main\\io\\filesystementry' => 'lib/io/filesystementry.php',
		'bitrix\\main\\io\\ifilestream' => 'lib/io/ifilestream.php',
		'bitrix\\main\\localization\\loc' => 'lib/localization/loc.php',
		'bitrix\\main\\mail\\mail' => 'lib/mail/mail.php',
		'bitrix\\main\\mail\\tracking' => 'lib/mail/tracking.php',
		'bitrix\\main\\mail\\eventmanager' => 'lib/mail/eventmanager.php',
		'bitrix\\main\\mail\\eventmessagecompiler' => 'lib/mail/eventmessagecompiler.php',
		'bitrix\\main\\mail\\eventmessagethemecompiler' => 'lib/mail/eventmessagethemecompiler.php',
		'bitrix\\main\\mail\\internal\\event' => 'lib/mail/internal/event.php',
		'bitrix\\main\\mail\\internal\\eventattachment' => 'lib/mail/internal/eventattachment.php',
		'bitrix\\main\\mail\\internal\\eventmessage' => 'lib/mail/internal/eventmessage.php',
		'bitrix\\main\\mail\\internal\\eventmessagesite' => 'lib/mail/internal/eventmessagesite.php',
		'bitrix\\main\\mail\\internal\\eventmessageattachment' => 'lib/mail/internal/eventmessageattachment.php',
		'bitrix\\main\\mail\\internal\\eventtype' => 'lib/mail/internal/eventtype.php',
		'bitrix\\main\\text\\converter' => 'lib/text/converter.php',
		'bitrix\\main\\text\\emptyconverter' => 'lib/text/emptyconverter.php',
		'bitrix\\main\\text\\encoding' => 'lib/text/encoding.php',
		'bitrix\\main\\text\\htmlconverter' => 'lib/text/htmlconverter.php',
		'bitrix\\main\\text\\binarystring' => 'lib/text/binarystring.php',
		'bitrix\\main\\text\\xmlconverter' => 'lib/text/xmlconverter.php',
		'bitrix\\main\\type\\collection' => 'lib/type/collection.php',
		'bitrix\\main\\type\\date' => 'lib/type/date.php',
		'bitrix\\main\\type\\datetime' => 'lib/type/datetime.php',
		'bitrix\\main\\type\\dictionary' => 'lib/type/dictionary.php',
		'bitrix\\main\\type\\filterabledictionary' => 'lib/type/filterabledictionary.php',
		'bitrix\\main\\type\\parameterdictionary' => 'lib/type/parameterdictionary.php',
		'bitrix\\main\\web\\cookie' => 'lib/web/cookie.php',
		'bitrix\\main\\web\\uri' => 'lib/web/uri.php',
		'bitrix\\main\\sendereventhandler' => 'lib/senderconnector.php',
		'bitrix\\main\\senderconnectoruser' => 'lib/senderconnector.php',
		'bitrix\\main\\urlrewriterrulemaker' => 'lib/urlrewriter.php',
		'bitrix\\main\\update\\stepper' => 'lib/update/stepper.php',
		'bitrix\\main\\composite\\abstractresponse' => 'lib/composite/responder.php',
		'bitrix\\main\\composite\\fileresponse' => 'lib/composite/responder.php',
		'bitrix\\main\\composite\\memcachedresponse' => 'lib/composite/responder.php',
		'bitrix\\main\\security\\otpexception' => 'lib/security/securityexception.php',
		'CTimeZone' => 'classes/general/time.php',
		'CBXPunycode' => 'classes/general/punycode.php',
		'IBXVirtualIO' => 'classes/general/virtual_io.php',
		'IBXGetErrors' => 'classes/general/virtual_io.php',
		'CBXVirtualIo' => 'classes/general/virtual_io.php',
		'CBXVirtualFileBase' => 'classes/general/virtual_file.php',
		'CBXVirtualFile' => 'classes/general/virtual_file.php',
		'CBXVirtualDirectory' => 'classes/general/virtual_file.php',
		'CAllOption' => 'classes/general/option.php',
		'COption' => 'classes/general/option.php',
		'CAllPageOption' => 'classes/general/pageoption.php',
		'CPageOption' => 'classes/general/pageoption.php',
		'CAllSQLWhere' => 'classes/general/sqlwhere.php',
		'CSQLWhereExpression' => 'classes/general/sqlwhere.php',
		'CSQLWhere' => 'classes/general/sqlwhere.php',
		'CAllLanguage' => 'classes/general/language.php',
		'CLanguage' => 'classes/general/language.php',
		'CLangAdmin' => 'classes/general/language.php',
		'_CLangDBResult' => 'classes/general/langdbresult.php',
		'CAllAgent' => 'classes/general/agent.php',
		'CAgent' => 'classes/general/agent.php',
		'CApplicationException' => 'classes/general/applicationexception.php',
		'CAdminException' => 'classes/general/adminexception.php',
		'CAllSite' => 'classes/general/site.php',
		'CAllLang' => 'classes/general/site.php',
		'CSite' => 'classes/general/site.php',
		'CLang' => 'classes/general/site.php',
		'CHTTP' => 'classes/general/http.php',
		'CUtil' => 'classes/general/util.php',
		'CAllMain' => 'classes/general/main.php',
		'CMain' => 'classes/general/main.php',
		'CAllDatabase' => 'classes/general/database.php',
		'CAllDBResult' => 'classes/general/dbresult.php',
		'CDatabaseMysql' => 'classes/mysql/database.php',
		'CDBResultMysql' => 'classes/mysql/dbresult.php',
		'ICacheBackend' => 'classes/general/cache_backend.php',
		'CPHPCache' => 'classes/general/cache.php',
		'CCacheManager' => 'classes/general/cache_manager.php',
		'CPageCache' => 'classes/general/page_cache.php',
		'CStackCacheEntry' => 'classes/general/stack_cache_entry.php',
		'CStackCacheManager' => 'classes/general/stack_cache.php',
		'CModule' => '/classes/general/module.php',
		'CSiteTemplate' => 'classes/general/site_template.php',
		'CBitrixComponent' => 'classes/general/component.php',
		'CComponentEngine' => 'classes/general/component_engine.php',
		'CComponentAjax' => 'classes/general/component_ajax.php',
		'CBitrixComponentTemplate' => 'classes/general/component_template.php',
		'CComponentUtil' => 'classes/general/component_util.php',
		'CControllerClient' => 'classes/general/controller_member.php',
		'PHPParser' => 'classes/general/php_parser.php',
		'CDiskQuota' => 'classes/general/quota.php',
		'CEventLog' => 'classes/general/event_log.php',
		'CEventMain' => 'classes/general/event_log.php',
		'CAdminFileDialog' => 'classes/general/file_dialog.php',
		'WLL_User' => 'classes/general/liveid.php',
		'WLL_ConsentToken' => 'classes/general/liveid.php',
		'WindowsLiveLogin' => 'classes/general/liveid.php',
		'CFile' => 'classes/general/file.php',
		'CTempFile' => 'classes/general/file_temp.php',
		'CFavorites' => 'classes/general/favorites.php',
		'CBXFavAdmMenu' => 'classes/general/favorites.php',
		'CBXFavUrls' => 'classes/general/favorites.php',
		'CUserOptions' => 'classes/general/user_options.php',
		'CGridOptions' => 'classes/general/grids.php',
		'CUndo' => '/classes/general/undo.php',
		'CAutoSave' => '/classes/general/undo.php',
		'CRatings' => 'classes/general/ratings.php',
		'CRatingsComponentsMain' => 'classes/general/ratings_components.php',
		'CRatingRule' => 'classes/general/rating_rule.php',
		'CRatingRulesMain' => 'classes/general/rating_rules.php',
		'CTopPanel' => 'public/top_panel.php',
		'CEditArea' => 'public/edit_area.php',
		'CComponentPanel' => 'public/edit_area.php',
		'CTextParser' => 'classes/general/textparser.php',
		'CPHPCacheFiles' => 'classes/general/cache_files.php',
		'CDataXMLNode' => 'classes/general/xml.php',
		'CDataXMLDocument' => 'classes/general/xml.php',
		'CDataXML' => 'classes/general/xml.php',
		'CXMLFileStream' => 'classes/general/xml.php',
		'CRsaProvider' => 'classes/general/rsasecurity.php',
		'CRsaSecurity' => 'classes/general/rsasecurity.php',
		'CRsaBcmathProvider' => 'classes/general/rsabcmath.php',
		'CRsaOpensslProvider' => 'classes/general/rsaopenssl.php',
		'CASNReader' => 'classes/general/asn.php',
		'CBXShortUri' => 'classes/general/short_uri.php',
		'CFinder' => 'classes/general/finder.php',
		'CAccess' => 'classes/general/access.php',
		'CAuthProvider' => 'classes/general/authproviders.php',
		'IProviderInterface' => 'classes/general/authproviders.php',
		'CGroupAuthProvider' => 'classes/general/authproviders.php',
		'CUserAuthProvider' => 'classes/general/authproviders.php',
		'CTableSchema' => 'classes/general/table_schema.php',
		'CCSVData' => 'classes/general/csv_data.php',
		'CSmile' => 'classes/general/smile.php',
		'CSmileGallery' => 'classes/general/smile.php',
		'CSmileSet' => 'classes/general/smile.php',
		'CGlobalCounter' => 'classes/general/global_counter.php',
		'CAllUserCounter' => 'classes/general/user_counter.php',
		'CUserCounter' => 'classes/general/user_counter.php',
		'CUserCounterPage' => 'classes/general/user_counter_page.php',
		'CHotKeys' => 'classes/general/hot_keys.php',
		'CHotKeysCode' => 'classes/general/hot_keys.php',
		'CBXSanitizer' => 'classes/general/sanitizer.php',
		'IBXArchive' => 'classes/general/archive.php',
		'CBXArchive' => 'classes/general/archive.php',
		'CAdminNotify' => 'classes/general/admin_notify.php',
		'CAdminInformer' => 'classes/general/admin_informer.php',
		'CSiteCheckerTest' => 'classes/general/site_checker.php',
		'CSqlUtil' => 'classes/general/sql_util.php',
		'CFileUploader' => 'classes/general/uploader.php',
		'LPA' => 'classes/general/lpa.php',
		'CAdminFilter' => 'interface/admin_filter.php',
		'CAdminList' => 'interface/admin_list.php',
		'CAdminListRow' => 'interface/admin_list.php',
		'CAdminUiList' => 'interface/admin_ui_list.php',
		'CAdminUiListRow' => 'interface/admin_ui_list.php',
		'CAdminUiResult' => 'interface/admin_ui_list.php',
		'CAdminUiContextMenu' => 'interface/admin_ui_list.php',
		'CAdminUiSorting' => 'interface/admin_ui_list.php',
		'CAdminUiListActionPanel' => 'interface/admin_ui_list.php',
		'CAdminTabControl' => 'interface/admin_tabcontrol.php',
		'CAdminForm' => 'interface/admin_form.php',
		'CAdminFormSettings' => 'interface/admin_form.php',
		'CAdminTabControlDrag' => 'interface/admin_tabcontrol_drag.php',
		'CAdminDraggableBlockEngine' => 'interface/admin_tabcontrol_drag.php',
		'CJSPopup' => 'interface/jspopup.php',
		'CJSPopupOnPage' => 'interface/jspopup.php',
		'CAdminCalendar' => 'interface/admin_calendar.php',
		'CAdminViewTabControl' => 'interface/admin_viewtabcontrol.php',
		'CAdminTabEngine' => 'interface/admin_tabengine.php',
		'CCaptcha' => 'classes/general/captcha.php',
		'CMpNotifications' => 'classes/general/mp_notifications.php',
		'CAllTask' => 'classes/general/task.php',
		'CTask' => 'classes/general/task.php',
		'CAllOperation' => 'classes/general/operation.php',
		'COperation' => 'classes/general/operation.php',
		'CAllGroup' => 'classes/general/group.php',
		'CGroup' => 'classes/general/group.php',
		'CAjax' => 'ajax_tools.php',
		'CAllUser' => 'classes/general/user.php',
		'CUser' => 'classes/general/user.php',
		'CAllEvent' => 'classes/general/event.php',
		'CEvent' => 'classes/general/event.php',
		'CAllEventMessage' => 'classes/general/eventmessage.php',
		'CEventMessage' => 'classes/general/eventmessage.php',
		'CEventType' => 'classes/general/eventmessage.php',
		'_CEventTypeResult' => 'classes/general/eventmessage.php',
		'CDBResultEventMultiResult' => 'classes/general/eventmessage.php',
		'CDebugInfo' => 'classes/general/debuginfo.php',
		'CCaptchaAgent' => 'classes/general/captchaagent.php',
		'CAllFilterQuery' => 'classes/general/filterquery.php',
		'CFilterQuery' => 'classes/general/filterquery.php',
		'CConvertorsPregReplaceHelper' => 'classes/general/convertorspregreplacehelper.php',
		'CSpacer' => 'classes/general/spacer.php',
		'UpdateTools' => 'classes/general/updatetools.php',
		'CJSCore' => 'classes/general/jscore.php',
		'CCheckListTools' => 'classes/general/checklist.php',
		'CMenu' => 'classes/general/menu.php',
		'CMenuCustom' => 'classes/general/menucustom.php',
		'CAllUserTypeEntity' => 'classes/general/usertype.php',
		'CUserTypeEntity' => 'classes/general/usertype.php',
		'CUserFieldEnum' => 'classes/general/userfieldenum.php',
		'CUserTypeSQL' => 'classes/general/usertypesql.php',
		'CUserTypeManager' => 'classes/general/usertypemanager.php',
		'CUserTypeString' => 'classes/general/usertypestr.php',
		'CUserTypeInteger' => 'classes/general/usertypeint.php',
		'CUserTypeDouble' => 'classes/general/usertypedbl.php',
		'CUserTypeDateTime' => 'classes/general/usertypetime.php',
		'CUserTypeDate' => 'classes/general/usertypedate.php',
		'CUserTypeBoolean' => 'classes/general/usertypebool.php',
		'CUserTypeFile' => 'classes/general/usertypefile.php',
		'CUserTypeEnum' => 'classes/general/usertypeenum.php',
		'CUserTypeIBlockSection' => 'classes/general/usertypesection.php',
		'CIBlockSectionEnum' => 'classes/general/usertypesection.php',
		'CUserTypeIBlockElement' => 'classes/general/usertypeelement.php',
		'CUserTypeStringFormatted' => 'classes/general/usertypestrfmt.php',
		'CUserTypeUrl' => 'classes/general/usertypeurl.php',
		'BXGadget' => 'classes/general/gadget.php',
		'CMainAdmin' => 'classes/general/main_admin.php',
		'CTemplates' => 'classes/general/templates.php',
		'CPageTemplate' => 'classes/general/page_template.php',
		'FilesCmp' => 'classes/general/files_cmp.php',
		'CArchiver' => 'classes/general/tar_gz.php',
		'CZip' => 'classes/general/zip.php',
		'CFileCacheCleaner' => 'classes/general/cache_files_cleaner.php',
		'CFileTree' => 'classes/general/file_tree.php',
		'CDesktopMenu' => 'interface/desktop_menu.php',
		'CAdminTopPanel' => 'interface/top_panel.php',
		'CUpdateClient' => 'classes/general/update_client.php',
		'CUpdateExpertMode' => 'classes/general/update_client.php',

		//deprecated
		'CUrlRewriter' => 'classes/general/urlrewriter.php',
		'CharsetConverter' => 'classes/general/charset_converter.php',
		'CHTMLPagesCache' => 'lib/composite/helper.php',
		'StaticHtmlMemcachedResponse' => 'lib/composite/responder.php',
		'StaticHtmlFileResponse' => 'lib/composite/responder.php',
		'Bitrix\\Main\\Page\\Frame' => 'lib/composite/engine.php',
		'Bitrix\\Main\\Page\\FrameStatic' => 'lib/composite/staticarea.php',
		'Bitrix\\Main\\Page\\FrameBuffered' => 'lib/composite/bufferarea.php',
		'Bitrix\\Main\\Page\\FrameHelper' => 'lib/composite/bufferarea.php',
		'Bitrix\\Main\\Data\\StaticHtmlCache' => 'lib/composite/page.php',
		'Bitrix\\Main\\Data\\StaticHtmlStorage' => 'lib/composite/data/abstractstorage.php',
		'Bitrix\\Main\\Data\\StaticHtmlFileStorage' => 'lib/composite/data/filestorage.php',
		'Bitrix\\Main\\Data\\StaticHtmlMemcachedStorage' => 'lib/composite/data/memcachedstorage.php',
		'Bitrix\\Main\\Data\\StaticCacheProvider' => 'lib/composite/data/cacheprovider.php',
		'Bitrix\\Main\\Data\\AppCacheManifest' => 'lib/composite/appcache.php',
	]
);

Loader::registerHandler([\Bitrix\Main\ORM\Loader::class, 'autoLoad']);

// old class names compatibility
require_once __DIR__.'/compatibility.php';
