
CREATE TABLE b_lang (
  LID char(2) NOT NULL,
  SORT int NOT NULL DEFAULT '100',
  DEF char(1) NOT NULL DEFAULT 'N',
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  NAME varchar(50) NOT NULL,
  DIR varchar(50) NOT NULL,
  FORMAT_DATE varchar(50),
  FORMAT_DATETIME varchar(50),
  FORMAT_NAME varchar(255),
  WEEK_START int,
  CHARSET varchar(255),
  LANGUAGE_ID char(2) NOT NULL,
  DOC_ROOT varchar(255),
  DOMAIN_LIMITED char(1) NOT NULL DEFAULT 'N',
  SERVER_NAME varchar(255),
  SITE_NAME varchar(255),
  EMAIL varchar(255),
  CULTURE_ID int,
  PRIMARY KEY (LID)
);
CREATE INDEX ix_b_lang_def_active ON b_lang (DEF, ACTIVE);

CREATE TABLE b_language (
  LID char(2) NOT NULL,
  SORT int NOT NULL DEFAULT '100',
  DEF char(1) NOT NULL DEFAULT 'N',
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  NAME varchar(50) NOT NULL,
  FORMAT_DATE varchar(50),
  FORMAT_DATETIME varchar(50),
  FORMAT_NAME varchar(255),
  WEEK_START int,
  CHARSET varchar(255),
  DIRECTION char(1),
  CULTURE_ID int,
  CODE varchar(35),
  PRIMARY KEY (LID)
);

CREATE TABLE b_culture (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CODE varchar(50),
  NAME varchar(255),
  FORMAT_DATE varchar(50),
  FORMAT_DATETIME varchar(50),
  FORMAT_NAME varchar(50),
  WEEK_START int DEFAULT 1,
  CHARSET varchar(50),
  DIRECTION char(1) DEFAULT 'Y',
  SHORT_DATE_FORMAT varchar(50) DEFAULT 'n/j/Y',
  MEDIUM_DATE_FORMAT varchar(50) DEFAULT 'M j, Y',
  LONG_DATE_FORMAT varchar(50) DEFAULT 'F j, Y',
  FULL_DATE_FORMAT varchar(50) DEFAULT 'l, F j, Y',
  DAY_MONTH_FORMAT varchar(50) DEFAULT 'F j',
  DAY_SHORT_MONTH_FORMAT varchar(50) DEFAULT 'M j',
  DAY_OF_WEEK_MONTH_FORMAT varchar(50) DEFAULT 'l, F j',
  SHORT_DAY_OF_WEEK_MONTH_FORMAT varchar(50) DEFAULT 'D, F j',
  SHORT_DAY_OF_WEEK_SHORT_MONTH_FORMAT varchar(50) DEFAULT 'D, M j',
  SHORT_TIME_FORMAT varchar(50) DEFAULT 'g:i a',
  LONG_TIME_FORMAT varchar(50) DEFAULT 'g:i:s a',
  AM_VALUE varchar(20) DEFAULT 'am',
  PM_VALUE varchar(20) DEFAULT 'pm',
  NUMBER_THOUSANDS_SEPARATOR varchar(10) DEFAULT ',',
  NUMBER_DECIMAL_SEPARATOR varchar(10) DEFAULT '.',
  NUMBER_DECIMALS smallint DEFAULT '2',
  PRIMARY KEY (ID)
);

CREATE TABLE b_lang_domain (
  LID char(2) NOT NULL,
  DOMAIN varchar(255) NOT NULL,
  PRIMARY KEY (LID, DOMAIN)
);

CREATE TABLE b_event_type (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  LID char(2) NOT NULL,
  EVENT_NAME varchar(255) NOT NULL,
  NAME varchar(100),
  DESCRIPTION text,
  SORT int NOT NULL DEFAULT '150',
  EVENT_TYPE varchar(10) NOT NULL DEFAULT 'email',
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_event_type_event_name_lid ON b_event_type (event_name, lid);

CREATE TABLE b_event_message (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TIMESTAMP_X timestamp DEFAULT CURRENT_TIMESTAMP,
  EVENT_NAME varchar(255) NOT NULL,
  LID char(2),
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  EMAIL_FROM varchar(255) NOT NULL DEFAULT '#EMAIL_FROM#',
  EMAIL_TO varchar(255) NOT NULL DEFAULT '#EMAIL_TO#',
  SUBJECT varchar(255),
  MESSAGE text,
  MESSAGE_PHP text,
  BODY_TYPE varchar(4) NOT NULL DEFAULT 'text',
  BCC text,
  REPLY_TO varchar(255),
  CC varchar(255),
  IN_REPLY_TO varchar(255),
  PRIORITY varchar(50),
  FIELD1_NAME varchar(50),
  FIELD1_VALUE varchar(255),
  FIELD2_NAME varchar(50),
  FIELD2_VALUE varchar(255),
  SITE_TEMPLATE_ID varchar(255) DEFAULT NULL,
  ADDITIONAL_FIELD text,
  LANGUAGE_ID char(2),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_event_message_event_name ON b_event_message (event_name);

CREATE TABLE b_event_attachment (
  EVENT_ID int NOT NULL,
  FILE_ID int NOT NULL,
  IS_FILE_COPIED char(1) NOT NULL DEFAULT 'Y',
  PRIMARY KEY (EVENT_ID, FILE_ID)
);

CREATE TABLE b_event_message_attachment (
  EVENT_MESSAGE_ID int NOT NULL,
  FILE_ID int NOT NULL,
  PRIMARY KEY (EVENT_MESSAGE_ID, FILE_ID)
);

CREATE TABLE b_event (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  EVENT_NAME varchar(255) NOT NULL,
  MESSAGE_ID int,
  LID varchar(255) NOT NULL,
  C_FIELDS text,
  DATE_INSERT timestamp,
  DATE_EXEC timestamp,
  SUCCESS_EXEC char(1) NOT NULL DEFAULT 'N',
  DUPLICATE char(1) NOT NULL DEFAULT 'Y',
  LANGUAGE_ID char(2),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_event_success_exec ON b_event (success_exec);
CREATE INDEX ix_b_event_date_exec ON b_event (date_exec);

CREATE TABLE b_group (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TIMESTAMP_X timestamp DEFAULT CURRENT_TIMESTAMP,
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  C_SORT int NOT NULL DEFAULT '100',
  ANONYMOUS char(1) NOT NULL DEFAULT 'N',
  IS_SYSTEM char(1) NOT NULL DEFAULT 'Y',
  NAME varchar(255) NOT NULL,
  DESCRIPTION varchar(255),
  SECURITY_POLICY text,
  STRING_ID varchar(255),
  PRIMARY KEY (ID)
);

CREATE TABLE b_user (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TIMESTAMP_X timestamp DEFAULT CURRENT_TIMESTAMP,
  LOGIN varchar(50) NOT NULL,
  PASSWORD varchar(255) NOT NULL,
  CHECKWORD varchar(255),
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  NAME varchar(50),
  LAST_NAME varchar(50),
  EMAIL varchar(255),
  LAST_LOGIN timestamp,
  DATE_REGISTER timestamp NOT NULL,
  LID char(2),
  PERSONAL_PROFESSION varchar(255),
  PERSONAL_WWW varchar(255),
  PERSONAL_ICQ varchar(255),
  PERSONAL_GENDER char(1),
  PERSONAL_BIRTHDATE varchar(50),
  PERSONAL_PHOTO int,
  PERSONAL_PHONE varchar(255),
  PERSONAL_FAX varchar(255),
  PERSONAL_MOBILE varchar(255),
  PERSONAL_PAGER varchar(255),
  PERSONAL_STREET text,
  PERSONAL_MAILBOX varchar(255),
  PERSONAL_CITY varchar(255),
  PERSONAL_STATE varchar(255),
  PERSONAL_ZIP varchar(255),
  PERSONAL_COUNTRY varchar(255),
  PERSONAL_NOTES text,
  WORK_COMPANY varchar(255),
  WORK_DEPARTMENT varchar(255),
  WORK_POSITION varchar(255),
  WORK_WWW varchar(255),
  WORK_PHONE varchar(255),
  WORK_FAX varchar(255),
  WORK_PAGER varchar(255),
  WORK_STREET text,
  WORK_MAILBOX varchar(255),
  WORK_CITY varchar(255),
  WORK_STATE varchar(255),
  WORK_ZIP varchar(255),
  WORK_COUNTRY varchar(255),
  WORK_PROFILE text,
  WORK_LOGO int,
  WORK_NOTES text,
  ADMIN_NOTES text,
  STORED_HASH varchar(32),
  XML_ID varchar(255),
  PERSONAL_BIRTHDAY date,
  EXTERNAL_AUTH_ID varchar(255),
  CHECKWORD_TIME timestamp,
  SECOND_NAME varchar(50),
  CONFIRM_CODE varchar(8),
  LOGIN_ATTEMPTS int,
  LAST_ACTIVITY_DATE timestamp,
  AUTO_TIME_ZONE char(1),
  TIME_ZONE varchar(50),
  TIME_ZONE_OFFSET int,
  TITLE varchar(255),
  BX_USER_ID varchar(32),
  LANGUAGE_ID char(2),
  BLOCKED char(1) NOT NULL DEFAULT 'N',
  PASSWORD_EXPIRED char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_user_login_external_auth_id ON b_user (login, external_auth_id);
CREATE INDEX ix_b_user_email ON b_user (email);
CREATE INDEX ix_b_user_last_activity_date ON b_user (last_activity_date);
CREATE INDEX ix_b_user_xml_id ON b_user (xml_id);
CREATE INDEX ix_b_user_last_login ON b_user (last_login);
CREATE INDEX ix_b_user_date_register ON b_user (date_register);

CREATE TABLE b_user_password (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int8 NOT NULL,
  PASSWORD varchar(255) NOT NULL,
  DATE_CHANGE timestamp NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_user_password_user_id_date_change ON b_user_password (user_id, date_change);

CREATE TABLE b_user_index (
  USER_ID int NOT NULL,
  SEARCH_USER_CONTENT text,
  SEARCH_DEPARTMENT_CONTENT text,
  SEARCH_ADMIN_CONTENT text,
  NAME varchar(50),
  LAST_NAME varchar(50),
  SECOND_NAME varchar(50),
  WORK_POSITION varchar(255),
  UF_DEPARTMENT_NAME varchar(255),
  PRIMARY KEY (USER_ID)
);
CREATE INDEX tx_b_user_index_search_user_content ON b_user_index USING GIN (to_tsvector('english', search_user_content));
CREATE INDEX tx_b_user_index_search_department_content ON b_user_index USING GIN (to_tsvector('english', search_department_content));
CREATE INDEX tx_b_user_index_search_admin_content ON b_user_index USING GIN (to_tsvector('english', search_admin_content));

CREATE TABLE b_user_group (
  USER_ID int NOT NULL,
  GROUP_ID int NOT NULL,
  DATE_ACTIVE_FROM timestamp,
  DATE_ACTIVE_TO timestamp
);
CREATE UNIQUE INDEX ux_b_user_group_user_id_group_id ON b_user_group (user_id, group_id);
CREATE INDEX ix_b_user_group_group_id ON b_user_group (group_id);

CREATE TABLE b_user_field_confirm (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int NOT NULL,
  DATE_CHANGE timestamp DEFAULT CURRENT_TIMESTAMP,
  FIELD varchar(255) NOT NULL,
  FIELD_VALUE varchar(255) NOT NULL,
  CONFIRM_CODE varchar(32) NOT NULL,
  ATTEMPTS int DEFAULT 0,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_user_field_confirm_user_id_confirm_code ON b_user_field_confirm (user_id, confirm_code);

CREATE TABLE b_module (
  ID varchar(50) NOT NULL,
  DATE_ACTIVE timestamp DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (ID)
);

CREATE TABLE b_option (
  MODULE_ID varchar(50) NOT NULL,
  NAME varchar(100) NOT NULL,
  VALUE text,
  DESCRIPTION varchar(255),
  SITE_ID char(2),
  PRIMARY KEY (MODULE_ID, NAME)
);
CREATE INDEX ix_b_option_name ON b_option (name);

CREATE TABLE b_option_site (
  MODULE_ID varchar(50) NOT NULL,
  NAME varchar(100) NOT NULL,
  SITE_ID char(2) NOT NULL,
  VALUE text,
  PRIMARY KEY (MODULE_ID, NAME, SITE_ID)
);
CREATE INDEX ix_b_option_site_module_id_site_id ON b_option_site (module_id, site_id);

CREATE TABLE b_module_to_module (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TIMESTAMP_X timestamp DEFAULT CURRENT_TIMESTAMP,
  SORT int NOT NULL DEFAULT '100',
  FROM_MODULE_ID varchar(50) NOT NULL,
  MESSAGE_ID varchar(255) NOT NULL,
  TO_MODULE_ID varchar(50) NOT NULL,
  TO_PATH varchar(255),
  TO_CLASS varchar(255),
  TO_METHOD varchar(255),
  TO_METHOD_ARG varchar(255),
  VERSION int,
  UNIQUE_ID varchar(32) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_module_to_module_from_module_id_message_id_to_module_id_to ON b_module_to_module (from_module_id, message_id, to_module_id, to_class, to_method);
CREATE UNIQUE INDEX ux_b_module_to_module_unique_id ON b_module_to_module (unique_id);

CREATE TABLE b_agent (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  MODULE_ID varchar(50),
  SORT int NOT NULL DEFAULT '100',
  NAME text,
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  LAST_EXEC timestamp,
  NEXT_EXEC timestamp NOT NULL,
  DATE_CHECK timestamp,
  AGENT_INTERVAL int DEFAULT '86400',
  IS_PERIOD char(1) DEFAULT 'Y',
  USER_ID int,
  RUNNING char(1) NOT NULL DEFAULT 'N',
  RETRY_COUNT int NOT NULL DEFAULT 0,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_agent_user_id ON b_agent (user_id);
CREATE INDEX ix_b_agent_name ON b_agent (name);
CREATE INDEX ix_b_agent_active_is_period_next_exec ON b_agent (active, is_period, next_exec);
CREATE INDEX ix_b_agent_next_exec ON b_agent (next_exec);
CREATE INDEX ix_b_agent_module_id_active ON b_agent (module_id, active);

CREATE TABLE b_file (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TIMESTAMP_X timestamp DEFAULT CURRENT_TIMESTAMP,
  MODULE_ID varchar(50),
  HEIGHT int,
  WIDTH int,
  FILE_SIZE int8,
  CONTENT_TYPE varchar(255) DEFAULT 'IMAGE',
  SUBDIR varchar(255),
  FILE_NAME varchar(255) NOT NULL,
  ORIGINAL_NAME varchar(255),
  DESCRIPTION varchar(255),
  HANDLER_ID varchar(50),
  EXTERNAL_ID varchar(50),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_file_external_id ON b_file (external_id);

CREATE TABLE b_file_duplicate (
  DUPLICATE_ID int NOT NULL,
  ORIGINAL_ID int NOT NULL,
  COUNTER int NOT NULL DEFAULT 1,
  ORIGINAL_DELETED char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (DUPLICATE_ID, ORIGINAL_ID)
);
CREATE INDEX ix_b_file_duplicate_original_id_original_deleted ON b_file_duplicate (original_id, original_deleted);

CREATE TABLE b_file_hash (
  FILE_ID int NOT NULL,
  FILE_SIZE int8 NOT NULL,
  FILE_HASH varchar(50) NOT NULL,
  PRIMARY KEY (FILE_ID)
);
CREATE INDEX ix_b_file_hash_file_size_file_hash ON b_file_hash (file_size, file_hash);

CREATE TABLE b_file_version (
  ORIGINAL_ID int NOT NULL,
  VERSION_ID int NOT NULL,
  META text,
  PRIMARY KEY (ORIGINAL_ID)
);
CREATE UNIQUE INDEX ux_b_file_version_version_id ON b_file_version (version_id);

CREATE TABLE b_file_preview (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  FILE_ID int NOT NULL,
  PREVIEW_ID int,
  PREVIEW_IMAGE_ID int,
  CREATED_AT timestamp NOT NULL,
  TOUCHED_AT timestamp,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_file_preview_touched_at ON b_file_preview (touched_at);
CREATE INDEX ix_b_file_preview_file_id ON b_file_preview (file_id);

CREATE TABLE b_module_group (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  MODULE_ID varchar(50) NOT NULL,
  GROUP_ID int NOT NULL,
  G_ACCESS varchar(255) NOT NULL,
  SITE_ID char(2),
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_module_group_module_id_group_id_site_id ON b_module_group (module_id, group_id, site_id);

CREATE TABLE b_favorite (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TIMESTAMP_X timestamp,
  DATE_CREATE timestamp,
  C_SORT int NOT NULL DEFAULT '100',
  MODIFIED_BY int,
  CREATED_BY int,
  MODULE_ID varchar(50),
  NAME varchar(255),
  URL text,
  COMMENTS text,
  LANGUAGE_ID char(2),
  USER_ID int,
  CODE_ID int,
  COMMON char(1) NOT NULL DEFAULT 'Y',
  MENU_ID varchar(255),
  PRIMARY KEY (ID)
);

CREATE TABLE b_user_stored_auth (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int NOT NULL,
  DATE_REG timestamp NOT NULL,
  LAST_AUTH timestamp NOT NULL,
  STORED_HASH varchar(32) NOT NULL,
  TEMP_HASH char(1) NOT NULL DEFAULT 'N',
  IP_ADDR int8 NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_user_stored_auth_user_id ON b_user_stored_auth (user_id);

CREATE TABLE b_site_template (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  SITE_ID char(2) NOT NULL,
  CONDITION varchar(255),
  SORT int NOT NULL DEFAULT '500',
  TEMPLATE varchar(255) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_site_template_site_id ON b_site_template (site_id);

CREATE TABLE b_event_message_site (
  EVENT_MESSAGE_ID int NOT NULL,
  SITE_ID char(2) NOT NULL,
  PRIMARY KEY (EVENT_MESSAGE_ID, SITE_ID)
);

CREATE TABLE b_user_option (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int NOT NULL,
  CATEGORY varchar(50) NOT NULL,
  NAME varchar(255) NOT NULL,
  VALUE text,
  COMMON char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_user_option_user_id_category_name ON b_user_option (user_id, category, name);

CREATE TABLE b_captcha (
  ID varchar(32) NOT NULL,
  CODE varchar(20) NOT NULL,
  IP varchar(15) NOT NULL,
  DATE_CREATE timestamp NOT NULL
);
CREATE UNIQUE INDEX ux_b_captcha_id ON b_captcha (id);

CREATE TABLE b_user_field (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_ID varchar(50),
  FIELD_NAME varchar(50),
  USER_TYPE_ID varchar(50),
  XML_ID varchar(255),
  SORT int,
  MULTIPLE char(1) NOT NULL DEFAULT 'N',
  MANDATORY char(1) NOT NULL DEFAULT 'N',
  SHOW_FILTER char(1) NOT NULL DEFAULT 'N',
  SHOW_IN_LIST char(1) NOT NULL DEFAULT 'Y',
  EDIT_IN_LIST char(1) NOT NULL DEFAULT 'Y',
  IS_SEARCHABLE char(1) NOT NULL DEFAULT 'N',
  SETTINGS text,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_user_field_entity_id_field_name ON b_user_field (entity_id, field_name);

CREATE TABLE b_user_field_lang (
  USER_FIELD_ID int,
  LANGUAGE_ID char(2),
  EDIT_FORM_LABEL varchar(255),
  LIST_COLUMN_LABEL varchar(255),
  LIST_FILTER_LABEL varchar(255),
  ERROR_MESSAGE varchar(255),
  HELP_MESSAGE varchar(255),
  PRIMARY KEY (USER_FIELD_ID, LANGUAGE_ID)
);

CREATE TABLE b_user_field_enum (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_FIELD_ID int,
  VALUE varchar(255) NOT NULL,
  DEF char(1) NOT NULL DEFAULT 'N',
  SORT int NOT NULL DEFAULT 500,
  XML_ID varchar(255) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_user_field_enum_user_field_id_xml_id ON b_user_field_enum (user_field_id, xml_id);

CREATE TABLE b_user_field_permission (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  USER_FIELD_ID int8 NOT NULL,
  ACCESS_CODE varchar(100) NOT NULL,
  PERMISSION_ID varchar(32) NOT NULL,
  VALUE int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_user_field_permission_entity_type_id ON b_user_field_permission (entity_type_id);
CREATE INDEX ix_b_user_field_permission_user_field_id ON b_user_field_permission (user_field_id);
CREATE INDEX ix_b_user_field_permission_permission_id ON b_user_field_permission (permission_id);

CREATE TABLE b_task (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  NAME varchar(100) NOT NULL,
  LETTER char(1),
  MODULE_ID varchar(50) NOT NULL,
  SYS char(1) NOT NULL,
  DESCRIPTION varchar(255),
  BINDING varchar(50) DEFAULT 'module',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_task_module_id_binding_letter_sys ON b_task (module_id, binding, letter, sys);

CREATE TABLE b_group_task (
  GROUP_ID int NOT NULL,
  TASK_ID int NOT NULL,
  EXTERNAL_ID varchar(50) DEFAULT '',
  PRIMARY KEY (GROUP_ID, TASK_ID)
);

CREATE TABLE b_operation (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  NAME varchar(50) NOT NULL,
  MODULE_ID varchar(50) NOT NULL,
  DESCRIPTION varchar(255),
  BINDING varchar(50) DEFAULT 'module',
  PRIMARY KEY (ID)
);

CREATE TABLE b_task_operation (
  TASK_ID int NOT NULL,
  OPERATION_ID int NOT NULL,
  PRIMARY KEY (TASK_ID, OPERATION_ID)
);

CREATE TABLE b_group_subordinate (
  ID int NOT NULL,
  AR_SUBGROUP_ID text NOT NULL,
  PRIMARY KEY (ID)
);

CREATE TABLE b_rating (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ACTIVE char(1) NOT NULL,
  NAME varchar(512) NOT NULL,
  ENTITY_ID varchar(50) NOT NULL,
  CALCULATION_METHOD varchar(3) NOT NULL DEFAULT 'SUM',
  CREATED timestamp,
  LAST_MODIFIED timestamp,
  LAST_CALCULATED timestamp,
  POSITION char(1) DEFAULT 'N',
  AUTHORITY char(1) DEFAULT 'N',
  CALCULATED char(1) NOT NULL DEFAULT 'N',
  CONFIGS text,
  PRIMARY KEY (ID)
);

CREATE TABLE b_rating_component (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  RATING_ID int NOT NULL,
  ACTIVE char(1) NOT NULL DEFAULT 'N',
  ENTITY_ID varchar(50) NOT NULL,
  MODULE_ID varchar(50) NOT NULL,
  RATING_TYPE varchar(50) NOT NULL,
  NAME varchar(50) NOT NULL,
  COMPLEX_NAME varchar(200) NOT NULL,
  CLASS varchar(255) NOT NULL,
  CALC_METHOD varchar(255) NOT NULL,
  EXCEPTION_METHOD varchar(255),
  LAST_MODIFIED timestamp,
  LAST_CALCULATED timestamp,
  NEXT_CALCULATION timestamp,
  REFRESH_INTERVAL int NOT NULL,
  CONFIG text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_rating_component_rating_id_active_next_calculation ON b_rating_component (rating_id, active, next_calculation);

CREATE TABLE b_rating_component_results (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  RATING_ID int NOT NULL,
  ENTITY_TYPE_ID varchar(50) NOT NULL,
  ENTITY_ID int NOT NULL,
  MODULE_ID varchar(50) NOT NULL,
  RATING_TYPE varchar(50) NOT NULL,
  NAME varchar(50) NOT NULL,
  COMPLEX_NAME varchar(200) NOT NULL,
  CURRENT_VALUE decimal,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_rating_component_results_entity_type_id ON b_rating_component_results (entity_type_id);
CREATE INDEX ix_b_rating_component_results_complex_name ON b_rating_component_results (complex_name);
CREATE INDEX ix_b_rating_component_results_rating_id_complex_name ON b_rating_component_results (rating_id, complex_name);

CREATE TABLE b_rating_results (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  RATING_ID int NOT NULL,
  ENTITY_TYPE_ID varchar(50) NOT NULL,
  ENTITY_ID int NOT NULL,
  CURRENT_VALUE decimal,
  PREVIOUS_VALUE decimal,
  CURRENT_POSITION int DEFAULT '0',
  PREVIOUS_POSITION int DEFAULT '0',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_rating_results_rating_id_entity_type_id_entity_id ON b_rating_results (rating_id, entity_type_id, entity_id);
CREATE INDEX ix_b_rating_results_rating_id_entity_id ON b_rating_results (rating_id, entity_id);

CREATE TABLE b_rating_vote (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  RATING_VOTING_ID int NOT NULL,
  ENTITY_TYPE_ID varchar(50) NOT NULL,
  ENTITY_ID int NOT NULL,
  OWNER_ID int NOT NULL,
  VALUE decimal NOT NULL,
  ACTIVE char(1) NOT NULL,
  CREATED timestamp NOT NULL,
  USER_ID int NOT NULL,
  USER_IP varchar(64) NOT NULL,
  REACTION varchar(8),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_rating_vote_rating_voting_id_user_id ON b_rating_vote (rating_voting_id, user_id);
CREATE INDEX ix_b_rating_vote_entity_type_id_entity_id_user_id ON b_rating_vote (entity_type_id, entity_id, user_id);
CREATE INDEX ix_b_rating_vote_owner_id_created ON b_rating_vote (owner_id, created);
CREATE INDEX ix_b_rating_vote_created_value ON b_rating_vote (created, value);
CREATE INDEX ix_b_rating_vote_active ON b_rating_vote (active);
CREATE INDEX ix_b_rating_vote_rating_voting_id_created ON b_rating_vote (rating_voting_id, created);
CREATE INDEX ix_b_rating_vote_entity_type_id_created ON b_rating_vote (entity_type_id, created);
CREATE INDEX ix_b_rating_vote_created_user_id ON b_rating_vote (created, user_id);
CREATE INDEX ix_b_rating_vote_user_id_owner_id ON b_rating_vote (user_id, owner_id);

CREATE TABLE b_rating_voting (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_TYPE_ID varchar(50) NOT NULL,
  ENTITY_ID int NOT NULL,
  OWNER_ID int NOT NULL,
  ACTIVE char(1) NOT NULL,
  CREATED timestamp,
  LAST_CALCULATED timestamp,
  TOTAL_VALUE decimal NOT NULL,
  TOTAL_VOTES int NOT NULL,
  TOTAL_POSITIVE_VOTES int NOT NULL,
  TOTAL_NEGATIVE_VOTES int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_rating_voting_entity_type_id_entity_id_active ON b_rating_voting (entity_type_id, entity_id, active);
CREATE INDEX ix_b_rating_voting_total_value ON b_rating_voting (total_value);

CREATE TABLE b_rating_voting_prepare (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  RATING_VOTING_ID int NOT NULL,
  TOTAL_VALUE decimal NOT NULL,
  TOTAL_VOTES int NOT NULL,
  TOTAL_POSITIVE_VOTES int NOT NULL,
  TOTAL_NEGATIVE_VOTES int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_rating_voting_prepare_rating_voting_id ON b_rating_voting_prepare (rating_voting_id);

CREATE TABLE b_rating_voting_reaction (
  ENTITY_TYPE_ID varchar(50) NOT NULL,
  ENTITY_ID int NOT NULL,
  REACTION varchar(8) NOT NULL DEFAULT '',
  TOTAL_VOTES int NOT NULL,
  PRIMARY KEY (ENTITY_TYPE_ID, ENTITY_ID, REACTION)
);

CREATE TABLE b_rating_prepare (
  ID int
);

CREATE TABLE b_rating_rule (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ACTIVE char(1) NOT NULL DEFAULT 'N',
  NAME varchar(256) NOT NULL,
  ENTITY_TYPE_ID varchar(50) NOT NULL,
  CONDITION_NAME varchar(200) NOT NULL,
  CONDITION_MODULE varchar(50),
  CONDITION_CLASS varchar(255) NOT NULL,
  CONDITION_METHOD varchar(255) NOT NULL,
  CONDITION_CONFIG text,
  ACTION_NAME varchar(200) NOT NULL,
  ACTION_CONFIG text,
  ACTIVATE char(1) NOT NULL DEFAULT 'N',
  ACTIVATE_CLASS varchar(255) NOT NULL,
  ACTIVATE_METHOD varchar(255) NOT NULL,
  DEACTIVATE char(1) NOT NULL DEFAULT 'N',
  DEACTIVATE_CLASS varchar(255) NOT NULL,
  DEACTIVATE_METHOD varchar(255) NOT NULL,
  CREATED timestamp,
  LAST_MODIFIED timestamp,
  LAST_APPLIED timestamp,
  PRIMARY KEY (ID)
);

CREATE TABLE b_rating_rule_vetting (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  RULE_ID int NOT NULL,
  ENTITY_TYPE_ID varchar(50) NOT NULL,
  ENTITY_ID int NOT NULL,
  ACTIVATE char(1) NOT NULL DEFAULT 'N',
  APPLIED char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_rating_rule_vetting_rule_id_entity_type_id_entity_id ON b_rating_rule_vetting (rule_id, entity_type_id, entity_id);

CREATE TABLE b_rating_user (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  RATING_ID int NOT NULL,
  ENTITY_ID int NOT NULL,
  BONUS decimal DEFAULT '0.0000',
  VOTE_WEIGHT decimal DEFAULT '0.0000',
  VOTE_COUNT int DEFAULT '0',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_rating_user_rating_id_entity_id ON b_rating_user (rating_id, entity_id);
CREATE INDEX ix_b_rating_user_entity_id ON b_rating_user (entity_id);

CREATE TABLE b_rating_vote_group (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  GROUP_ID int NOT NULL,
  TYPE char(1) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_rating_vote_group_group_id_type ON b_rating_vote_group (group_id, type);

CREATE TABLE b_rating_weight (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  RATING_FROM decimal NOT NULL,
  RATING_TO decimal NOT NULL,
  WEIGHT decimal DEFAULT '0',
  COUNT int DEFAULT '0',
  PRIMARY KEY (ID)
);

CREATE TABLE b_event_log (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TIMESTAMP_X timestamp DEFAULT CURRENT_TIMESTAMP,
  SEVERITY varchar(50) NOT NULL,
  AUDIT_TYPE_ID varchar(50) NOT NULL,
  MODULE_ID varchar(50) NOT NULL,
  ITEM_ID varchar(255) NOT NULL,
  REMOTE_ADDR varchar(40),
  USER_AGENT text,
  REQUEST_URI text,
  SITE_ID char(2),
  USER_ID int,
  GUEST_ID int,
  DESCRIPTION text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_event_log_timestamp_x ON b_event_log (timestamp_x);
CREATE INDEX ix_b_event_log_audit_type_id_timestamp_x ON b_event_log (audit_type_id, timestamp_x);

CREATE TABLE b_log_notification (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  NAME varchar(50),
  AUDIT_TYPE_ID varchar(50) NOT NULL,
  ITEM_ID varchar(255),
  USER_ID int,
  REMOTE_ADDR varchar(40),
  USER_AGENT varchar(1000),
  REQUEST_URI varchar(1000),
  CHECK_INTERVAL int,
  ALERT_COUNT int,
  DATE_CHECKED timestamp,
  PRIMARY KEY (ID)
);

CREATE TABLE b_log_notification_action (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  NOTIFICATION_ID int8 NOT NULL,
  NOTIFICATION_TYPE varchar(15) NOT NULL,
  RECIPIENT varchar(50),
  ADDITIONAL_TEXT text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_log_notification_action_notification_id ON b_log_notification_action (notification_id);

CREATE TABLE b_cache_tag (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  SITE_ID char(2),
  CACHE_SALT char(4),
  RELATIVE_PATH varchar(255),
  TAG varchar(100),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_cache_tag_site_id_cache_salt_relative_path_tag ON b_cache_tag (SITE_ID, CACHE_SALT, RELATIVE_PATH, TAG);
CREATE INDEX ix_b_cache_tag_relative_path ON b_cache_tag (RELATIVE_PATH);
CREATE INDEX ix_b_cache_tag_tag_relative_path ON b_cache_tag (TAG, RELATIVE_PATH);

CREATE TABLE b_cache_clean_path
(
	ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	PREFIX text,
	CLEAN_FROM timestamp DEFAULT CURRENT_TIMESTAMP,
	CLUSTER_GROUP int NOT NULL DEFAULT 0,
	PRIMARY KEY (ID)
);
CREATE INDEX ix_b_cache_clean_path_cluster_group_clean_from ON b_cache_clean_path (CLUSTER_GROUP, CLEAN_FROM);

CREATE TABLE b_user_hit_auth (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int NOT NULL,
  HASH varchar(32) NOT NULL,
  URL varchar(255) NOT NULL,
  SITE_ID char(2),
  TIMESTAMP_X timestamp DEFAULT CURRENT_TIMESTAMP,
  VALID_UNTIL timestamp,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_user_hit_auth_hash ON b_user_hit_auth (hash);
CREATE INDEX ix_b_user_hit_auth_user_id ON b_user_hit_auth (user_id);
CREATE INDEX ix_b_user_hit_auth_timestamp_x ON b_user_hit_auth (timestamp_x);

CREATE TABLE b_undo (
  ID varchar(255) NOT NULL,
  MODULE_ID varchar(50),
  UNDO_TYPE varchar(50),
  UNDO_HANDLER varchar(255),
  CONTENT text,
  USER_ID int,
  TIMESTAMP_X int,
  PRIMARY KEY (ID)
);

CREATE TABLE b_user_digest (
  USER_ID int NOT NULL,
  DIGEST_HA1 varchar(32) NOT NULL,
  PRIMARY KEY (USER_ID)
);

CREATE TABLE b_checklist (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_CREATE varchar(255),
  TESTER varchar(255),
  COMPANY_NAME varchar(255),
  PICTURE int,
  TOTAL int,
  SUCCESS int,
  FAILED int,
  PENDING int,
  SKIP int,
  STATE text,
  REPORT_COMMENT text,
  REPORT char(1) DEFAULT 'Y',
  EMAIL varchar(50),
  PHONE varchar(50),
  SENDED_TO_BITRIX char(1) DEFAULT 'N',
  HIDDEN char(1) DEFAULT 'N',
  PRIMARY KEY (ID)
);

CREATE TABLE b_short_uri (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  URI varchar(2000) NOT NULL,
  URI_CRC int NOT NULL,
  SHORT_URI bytea NOT NULL,
  SHORT_URI_CRC int NOT NULL,
  STATUS int NOT NULL DEFAULT 301,
  MODIFIED timestamp NOT NULL,
  LAST_USED timestamp,
  NUMBER_USED int NOT NULL DEFAULT 0,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_short_uri_short_uri_crc ON b_short_uri (short_uri_crc);
CREATE INDEX ix_b_short_uri_uri_crc ON b_short_uri (uri_crc);

CREATE TABLE b_user_access (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int,
  PROVIDER_ID varchar(50),
  ACCESS_CODE varchar(100),
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_user_access_user_id_access_code ON b_user_access (user_id, access_code);
CREATE INDEX ix_b_user_access_user_id_provider_id ON b_user_access (user_id, provider_id);
CREATE INDEX ix_b_user_access_access_code ON b_user_access (access_code);
CREATE INDEX ix_b_user_access_provider_id ON b_user_access (provider_id);

CREATE TABLE b_user_access_check (
  USER_ID int,
  PROVIDER_ID varchar(50),
  DATE_CHECK timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
);
CREATE UNIQUE INDEX ux_b_user_access_check_user_id_provider_id_date_check ON b_user_access_check (user_id, provider_id, date_check);

CREATE TABLE b_user_counter (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int NOT NULL,
  SITE_ID char(2) NOT NULL DEFAULT '**',
  CODE varchar(50) NOT NULL,
  CNT int NOT NULL DEFAULT 0,
  LAST_DATE timestamp,
  TIMESTAMP_X timestamp NOT NULL DEFAULT '3000-01-01 00:00:00',
  TAG varchar(255),
  PARAMS text,
  SENT char(1) DEFAULT '0',
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_user_counter_user_id_site_id_code ON b_user_counter (user_id, site_id, code);
CREATE INDEX ix_b_user_counter_tag ON b_user_counter (tag);
CREATE INDEX ix_b_user_counter_code ON b_user_counter (code);
CREATE INDEX ix_b_user_counter_timestamp_x ON b_user_counter (timestamp_x);
CREATE INDEX ix_b_user_counter_sent_user_id ON b_user_counter (sent, user_id);

CREATE TABLE b_hot_keys_code (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CLASS_NAME varchar(50),
  CODE varchar(255),
  NAME varchar(255),
  COMMENTS varchar(255),
  TITLE_OBJ varchar(50),
  URL varchar(255),
  IS_CUSTOM smallint NOT NULL DEFAULT '1',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_hot_keys_code_class_name ON b_hot_keys_code (class_name);
CREATE INDEX ix_b_hot_keys_code_url ON b_hot_keys_code (url);

CREATE TABLE b_hot_keys (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  KEYS_STRING varchar(20) NOT NULL,
  CODE_ID int NOT NULL,
  USER_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_hot_keys_code_id_user_id ON b_hot_keys (code_id, user_id);
CREATE INDEX ix_b_hot_keys_user_id ON b_hot_keys (user_id);

CREATE TABLE b_admin_notify (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  MODULE_ID varchar(50),
  TAG varchar(255),
  MESSAGE text,
  ENABLE_CLOSE char(1) DEFAULT 'Y',
  PUBLIC_SECTION char(1) NOT NULL DEFAULT 'N',
  NOTIFY_TYPE char(1) NOT NULL DEFAULT 'M',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_admin_notify_tag ON b_admin_notify (tag);

CREATE TABLE b_admin_notify_lang (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  NOTIFY_ID int NOT NULL,
  LID char(2) NOT NULL,
  MESSAGE text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_admin_notify_lang_lid ON b_admin_notify_lang (lid);
CREATE UNIQUE INDEX ux_b_admin_notify_lang_notify_id_lid ON b_admin_notify_lang (notify_id, lid);

CREATE TABLE b_filters (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int,
  FILTER_ID varchar(255) NOT NULL,
  NAME varchar(255) NOT NULL,
  FIELDS text NOT NULL,
  COMMON char(1),
  PRESET char(1),
  LANGUAGE_ID char(2),
  PRESET_ID varchar(255),
  SORT int,
  SORT_FIELD varchar(255),
  PRIMARY KEY (ID)
);

CREATE TABLE b_component_params (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  SITE_ID char(2) NOT NULL,
  COMPONENT_NAME varchar(255) NOT NULL,
  TEMPLATE_NAME varchar(255),
  REAL_PATH varchar(255) NOT NULL,
  SEF_MODE char(1) NOT NULL DEFAULT 'Y',
  SEF_FOLDER varchar(255),
  START_CHAR int NOT NULL,
  END_CHAR int NOT NULL,
  PARAMETERS text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_component_params_component_name ON b_component_params (component_name);
CREATE INDEX ix_b_component_params_site_id_real_path ON b_component_params (site_id, real_path);
CREATE INDEX ix_b_component_params_site_id_component_name ON b_component_params (site_id, component_name);

CREATE TABLE b_smile (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TYPE char(1) NOT NULL DEFAULT 'S',
  SET_ID int NOT NULL DEFAULT 0,
  SORT int NOT NULL DEFAULT '150',
  TYPING varchar(100),
  CLICKABLE char(1) NOT NULL DEFAULT 'Y',
  HIDDEN char(1) NOT NULL DEFAULT 'N',
  IMAGE varchar(255) NOT NULL,
  IMAGE_DEFINITION varchar(10) NOT NULL DEFAULT 'SD',
  IMAGE_WIDTH int NOT NULL DEFAULT 0,
  IMAGE_HEIGHT int NOT NULL DEFAULT 0,
  PRIMARY KEY (ID)
);

CREATE TABLE b_smile_set (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TYPE char(1) NOT NULL DEFAULT 'G',
  PARENT_ID int NOT NULL DEFAULT 0,
  STRING_ID varchar(255),
  SORT int NOT NULL DEFAULT '150',
  PRIMARY KEY (ID)
);

CREATE TABLE b_smile_lang (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TYPE char(1) NOT NULL DEFAULT 'S',
  SID int NOT NULL,
  LID char(2) NOT NULL,
  NAME varchar(255) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_smile_lang_type_sid_lid ON b_smile_lang (type, sid, lid);

CREATE TABLE b_app_password (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int NOT NULL,
  APPLICATION_ID varchar(255) NOT NULL,
  PASSWORD varchar(255) NOT NULL,
  DIGEST_PASSWORD varchar(255) NOT NULL,
  DATE_CREATE timestamp,
  DATE_LOGIN timestamp,
  LAST_IP varchar(255),
  COMMENT varchar(255),
  SYSCOMMENT varchar(255),
  CODE varchar(255),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_app_password_user_id ON b_app_password (user_id);

CREATE TABLE b_counter_data (
  ID varchar(16) NOT NULL,
  TYPE varchar(30) NOT NULL,
  DATA text NOT NULL,
  PRIMARY KEY (ID)
);

CREATE TABLE b_finder_dest (
  USER_ID int NOT NULL,
  CODE varchar(30) NOT NULL,
  CODE_USER_ID int,
  CODE_TYPE varchar(10),
  CONTEXT varchar(50) NOT NULL,
  LAST_USE_DATE timestamp,
  PRIMARY KEY (USER_ID, CODE, CONTEXT)
);
CREATE INDEX ix_b_finder_dest_code_type ON b_finder_dest (code_type);

CREATE TABLE b_entity_usage (
  USER_ID int NOT NULL,
  CONTEXT varchar(50) NOT NULL,
  ENTITY_ID varchar(30) NOT NULL,
  ITEM_ID varchar(50) NOT NULL,
  ITEM_ID_INT int NOT NULL DEFAULT 0,
  PREFIX varchar(10) NOT NULL DEFAULT '',
  LAST_USE_DATE timestamp NOT NULL,
  PRIMARY KEY (USER_ID, CONTEXT, ENTITY_ID, ITEM_ID)
);
CREATE INDEX ix_b_entity_usage_item_id_int ON b_entity_usage (item_id_int);
CREATE INDEX ix_b_entity_usage_last_use_date ON b_entity_usage (last_use_date);

CREATE TABLE b_urlpreview_metadata (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  URL varchar(2000) NOT NULL,
  TYPE char(1) NOT NULL DEFAULT 'S',
  DATE_INSERT timestamp NOT NULL,
  DATE_EXPIRE timestamp,
  TITLE varchar(200),
  DESCRIPTION text,
  IMAGE_ID int,
  IMAGE varchar(2000),
  EMBED text,
  EXTRA text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_urlpreview_metadata_url ON b_urlpreview_metadata (url);

CREATE TABLE b_urlpreview_route (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ROUTE varchar(2000) NOT NULL,
  MODULE varchar(50) NOT NULL,
  CLASS varchar(150) NOT NULL,
  PARAMETERS text,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_urlpreview_route_route ON b_urlpreview_route (route);

CREATE TABLE b_geoip_handlers (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  SORT int NOT NULL DEFAULT 100,
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  CLASS_NAME varchar(255) NOT NULL,
  CONFIG text,
  PRIMARY KEY (ID)
);

CREATE TABLE b_consent_user_consent (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_INSERT timestamp NOT NULL,
  AGREEMENT_ID int NOT NULL,
  USER_ID int DEFAULT NULL,
  IP varchar(15) NOT NULL,
  URL varchar(4000) DEFAULT NULL,
  ORIGIN_ID varchar(30) DEFAULT NULL,
  ORIGINATOR_ID varchar(30) DEFAULT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_consent_user_consent_agreement_id ON b_consent_user_consent (agreement_id);
CREATE INDEX ix_b_consent_user_consent_user_id_origin_id ON b_consent_user_consent (user_id, origin_id);

CREATE TABLE b_consent_agreement (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CODE varchar(45) DEFAULT NULL,
  DATE_INSERT timestamp NOT NULL,
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  NAME varchar(255) NOT NULL,
  TYPE char(1) DEFAULT NULL,
  LANGUAGE_ID char(2) DEFAULT NULL,
  DATA_PROVIDER varchar(45) DEFAULT NULL,
  AGREEMENT_TEXT text DEFAULT NULL,
  LABEL_TEXT varchar(4000) DEFAULT NULL,
  SECURITY_CODE varchar(32) DEFAULT NULL,
  USE_URL char(1) NOT NULL DEFAULT 'N',
  URL varchar(255) DEFAULT NULL,
  IS_AGREEMENT_TEXT_HTML char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_consent_agreement_code ON b_consent_agreement (code);

CREATE TABLE b_consent_field (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  AGREEMENT_ID int NOT NULL,
  CODE varchar(100) DEFAULT NULL,
  VALUE text NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_consent_field_agreement_id ON b_consent_field (agreement_id);

CREATE TABLE b_consent_user_consent_item (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_CONSENT_ID int NOT NULL,
  VALUE varchar(50) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_consent_user_consent_item_user_consent_id ON b_consent_user_consent_item (user_consent_id);

CREATE TABLE b_composite_page (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CACHE_KEY varchar(2000) NOT NULL,
  HOST varchar(100) NOT NULL,
  URI varchar(2000) NOT NULL,
  TITLE varchar(250),
  CREATED timestamp NOT NULL,
  CHANGED timestamp NOT NULL,
  LAST_VIEWED timestamp NOT NULL,
  VIEWS int NOT NULL DEFAULT 0,
  REWRITES int NOT NULL DEFAULT 0,
  SIZE int NOT NULL DEFAULT 0,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_composite_page_cache_key ON b_composite_page (cache_key);
CREATE INDEX ix_b_composite_page_last_viewed ON b_composite_page (last_viewed);
CREATE INDEX ix_b_composite_page_host ON b_composite_page (host);

CREATE TABLE b_composite_log (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  HOST varchar(100) NOT NULL,
  URI varchar(2000) NOT NULL,
  TITLE varchar(250),
  CREATED timestamp NOT NULL,
  TYPE varchar(50) NOT NULL,
  MESSAGE text,
  AJAX char(1) NOT NULL DEFAULT 'N',
  USER_ID int NOT NULL DEFAULT 0,
  PAGE_ID int NOT NULL DEFAULT 0,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_composite_log_page_id ON b_composite_log (page_id);
CREATE INDEX ix_b_composite_log_host ON b_composite_log (host);
CREATE INDEX ix_b_composite_log_type ON b_composite_log (type);

CREATE TABLE b_user_auth_action (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int NOT NULL,
  PRIORITY int NOT NULL DEFAULT 100,
  ACTION varchar(20),
  ACTION_DATE timestamp NOT NULL,
  APPLICATION_ID varchar(255),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_user_auth_action_user_id_priority ON b_user_auth_action (user_id, priority);
CREATE INDEX ix_b_user_auth_action_action_date ON b_user_auth_action (action_date);

CREATE TABLE b_main_mail_sender (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  NAME varchar(255) NOT NULL DEFAULT '',
  EMAIL varchar(255) NOT NULL,
  USER_ID int NOT NULL,
  IS_CONFIRMED smallint NOT NULL DEFAULT 0,
  IS_PUBLIC smallint NOT NULL DEFAULT 0,
  OPTIONS text,
  PARENT_MODULE_ID varchar(50) NOT NULL DEFAULT 'main',
  PARENT_ID int DEFAULT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_main_mail_sender_user_id_is_confirmed_is_public ON b_main_mail_sender (user_id, is_confirmed, is_public);
CREATE INDEX ix_b_main_mail_sender_email ON b_main_mail_sender (email);

CREATE TABLE b_main_mail_sender_send_counter (
  DATE_STAT date NOT NULL,
  EMAIL varchar(255) NOT NULL,
  CNT int NOT NULL,
  PRIMARY KEY (DATE_STAT, EMAIL)
);

CREATE TABLE b_main_mail_blacklist (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_INSERT timestamp NOT NULL,
  CATEGORY_ID int NOT NULL DEFAULT 0,
  CODE varchar(255),
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_main_mail_blacklist_code ON b_main_mail_blacklist (code);

CREATE TABLE b_numerator (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  NAME varchar(255) DEFAULT NULL,
  TEMPLATE varchar(255) DEFAULT NULL,
  TYPE varchar(50) DEFAULT NULL,
  SETTINGS text,
  CREATED_AT timestamp DEFAULT NULL,
  CREATED_BY int DEFAULT NULL,
  UPDATED_AT timestamp DEFAULT NULL,
  UPDATED_BY int DEFAULT NULL,
  CODE varchar(255) DEFAULT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_numerator_code ON b_numerator (code);

CREATE TABLE b_numerator_sequence (
  NUMERATOR_ID int NOT NULL DEFAULT '0',
  "key" varchar(32) NOT NULL DEFAULT '0',
  TEXT_KEY varchar(50) DEFAULT NULL,
  NEXT_NUMBER int DEFAULT NULL,
  LAST_INVOCATION_TIME int DEFAULT NULL,
  PRIMARY KEY (NUMERATOR_ID, KEY)
);

CREATE TABLE b_user_profile_history (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int NOT NULL,
  EVENT_TYPE int,
  DATE_INSERT timestamp,
  REMOTE_ADDR varchar(40),
  USER_AGENT text,
  REQUEST_URI text,
  UPDATED_BY_ID int,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_user_profile_history_user_id ON b_user_profile_history (user_id);
CREATE INDEX ix_b_user_profile_history_date_insert ON b_user_profile_history (date_insert);

CREATE TABLE b_user_profile_record (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  HISTORY_ID int NOT NULL,
  FIELD varchar(40),
  DATA text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_user_profile_record_history_id_field ON b_user_profile_record (history_id, field);

CREATE TABLE b_user_phone_auth (
  USER_ID int NOT NULL,
  PHONE_NUMBER varchar(25) NOT NULL,
  OTP_SECRET text,
  ATTEMPTS int DEFAULT 0,
  CONFIRMED char(1) DEFAULT 'N',
  DATE_SENT timestamp,
  PRIMARY KEY (USER_ID)
);
CREATE UNIQUE INDEX ux_b_user_phone_auth_phone_number ON b_user_phone_auth (phone_number);

CREATE TABLE b_user_auth_code (
  USER_ID int NOT NULL,
  CODE_TYPE varchar(20) NOT NULL DEFAULT 'email',
  OTP_SECRET text,
  ATTEMPTS int DEFAULT 0,
  DATE_SENT timestamp,
  DATE_RESENT timestamp,
  PRIMARY KEY (USER_ID, CODE_TYPE)
);

CREATE TABLE b_user_session (
  SESSION_ID varchar(250) NOT NULL,
  TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  SESSION_DATA text,
  PRIMARY KEY (SESSION_ID)
);
CREATE INDEX ix_b_user_session_timestamp_x ON b_user_session (timestamp_x);

CREATE TABLE b_sms_template (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  EVENT_NAME varchar(255) NOT NULL,
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  SENDER varchar(50),
  RECEIVER varchar(50),
  MESSAGE text,
  LANGUAGE_ID char(2),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sms_template_event_name ON b_sms_template (event_name);

CREATE TABLE b_sms_template_site (
  TEMPLATE_ID int NOT NULL,
  SITE_ID char(2) NOT NULL,
  PRIMARY KEY (TEMPLATE_ID, SITE_ID)
);

CREATE TABLE b_sm_version_history (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_INSERT timestamp,
  VERSIONS text,
  PRIMARY KEY (ID)
);

CREATE TABLE b_user_device (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int8 NOT NULL,
  DEVICE_UID varchar(50) NOT NULL,
  DEVICE_TYPE int8 NOT NULL DEFAULT 0,
  BROWSER varchar(100),
  PLATFORM varchar(25),
  USER_AGENT varchar(1000),
  COOKABLE char(1) NOT NULL DEFAULT 'N',
  APP_PASSWORD_ID int,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_user_device_user_id_device_uid ON b_user_device (user_id, device_uid);
CREATE INDEX ix_b_user_device_user_cookable_appwd ON b_user_device (user_id, cookable, app_password_id);

CREATE TABLE b_user_device_login (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DEVICE_ID int8 NOT NULL,
  LOGIN_DATE timestamp,
  IP varchar(20),
  CITY_GEOID int8,
  REGION_GEOID int8,
  COUNTRY_ISO_CODE varchar(10),
  APP_PASSWORD_ID int8,
  STORED_AUTH_ID int8,
  HIT_AUTH_ID int8,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_user_device_login_device_id ON b_user_device_login (device_id);
CREATE INDEX ix_b_user_device_login_login_date ON b_user_device_login (login_date);

CREATE TABLE b_geoname (
  ID int8 NOT NULL,
  LANGUAGE_CODE varchar(35),
  NAME varchar(600),
  PRIMARY KEY (ID, LANGUAGE_CODE)
);

CREATE TABLE b_sidepanel_toolbar (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int NOT NULL,
  CONTEXT varchar(50) NOT NULL,
  COLLAPSED char(1) NOT NULL,
  CREATED_DATE timestamp NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sidepanel_toolbar_user_id_context ON b_sidepanel_toolbar (user_id, context);

CREATE TABLE b_sidepanel_toolbar_item (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TOOLBAR_ID int8 NOT NULL,
  URL varchar(2000) NOT NULL,
  TITLE varchar(255) NOT NULL,
  ENTITY_TYPE varchar(50) NOT NULL,
  ENTITY_ID varchar(50) NOT NULL,
  CREATED_DATE timestamp NOT NULL,
  LAST_USE_DATE timestamp NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sidepanel_toolbar_item_toolbar_id_entity_type_entity_id ON b_sidepanel_toolbar_item (toolbar_id, entity_type, entity_id);
CREATE INDEX ix_b_sidepanel_toolbar_item_toolbar_id_last_use_date ON b_sidepanel_toolbar_item (toolbar_id, last_use_date);

CREATE TABLE b_sec_wwall_rules
(
	ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	DATA text,
	MODULE varchar(50) NOT NULL,
	MODULE_VERSION varchar(20) NOT NULL,
	PRIMARY KEY(ID)
);

CREATE TABLE b_sec_vendor_notification
(
	VENDOR_ID VARCHAR(50) not null,
	DATA TEXT,
	PRIMARY KEY(VENDOR_ID)
);

CREATE TABLE b_sec_vendor_notification_sign
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	USER_ID int NOT NULL,
	NOTIFICATION_VENDOR_ID VARCHAR(50) not null,
	DATE timestamp NOT NULL,
	PRIMARY KEY(ID)
);
CREATE UNIQUE INDEX ux_b_sec_vendor_notification_sign_user_id_notification_vendor_id ON b_sec_vendor_notification_sign (user_id, notification_vendor_id);

CREATE TABLE b_main_messenger_message
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	QUEUE_ID varchar(255) NOT NULL,
	ITEM_ID varchar(255),
	CLASS varchar(255) NOT NULL,
	PAYLOAD text NOT NULL,
	CREATED_AT timestamp NOT NULL,
	UPDATED_AT timestamp NOT NULL,
	TTL int NOT NULL,
	AVAILABLE_AT timestamp NOT NULL,
	STATUS varchar(255) NOT NULL,
	PRIMARY KEY(ID)
);
CREATE INDEX ix_b_main_messenger_message_queue_id_status_available_at ON b_main_messenger_message (QUEUE_ID, STATUS, AVAILABLE_AT);
CREATE INDEX ix_b_main_messenger_message_status_available_at ON b_main_messenger_message (STATUS, UPDATED_AT);
