<?php

/**
 * Bitrix Framework
 * @package bitrix
 * @subpackage tasks
 * @copyright 2001-2021 Bitrix
 */

namespace Bitrix\Main\UI\Selector;

use Bitrix\Main\Access\AccessCode;
use Bitrix\Main\Localization\Loc;

class UserGroups extends EntityBase
{
	private const GROUP_PREFIX = 'A';

	public function loadAll()
	{
		return parent::loadAll(); // TODO: Change the autogenerated stub
	}

	public function search()
	{
		$result = [
			'ITEMS' => [],
			'ADDITIONAL_INFO' => []
		];

		return $result;
	}

	public function getData($params = [])
	{
		$entityType = Handler::ENTITY_TYPE_GROUP;

		$result = [
			'ITEMS' => [],
			'ITEMS_LAST' => [],
			'ITEMS_HIDDEN' => [],
			'ADDITIONAL_INFO' => [
				'GROUPS_LIST' => [
					'usergroups' => [
						'TITLE' => Loc::getMessage('MAIN_UI_SELECTOR_TITLE_SONETGROUPS'),
						'TYPE_LIST' => [$entityType],
						'DESC_LESS_MODE' => 'Y',
						'SORT' => 20
					]
				],
				'PREFIX' => self::GROUP_PREFIX,
				'SORT_SELECTED' => 300
			]
		];

		$options = (!empty($params['options']) ? $params['options'] : []);

		$lastItems = (!empty($params['lastItems']) ? $params['lastItems'] : []);
		$selectedItems = (!empty($params['selectedItems']) ? $params['selectedItems'] : []);

		$result['ITEMS'][AccessCode::ACCESS_DIRECTOR . '0'] = [
			"id" 		=> AccessCode::ACCESS_DIRECTOR . '0',
			"entityId" 	=> 0,
			"name" 		=> Loc::getMessage('MAIN_UI_SELECTOR_DIRECTOR_NAME'),
			"desc" 		=> Loc::getMessage('MAIN_UI_SELECTOR_DIRECTOR_DESCRIPTION')
		];
		$result['ITEMS'][AccessCode::ACCESS_EMPLOYEE . '0'] = [
			"id" 		=> AccessCode::ACCESS_EMPLOYEE . '0',
			"entityId" 	=> 0,
			"name" 		=> Loc::getMessage('MAIN_UI_SELECTOR_EMPLOYEE_NAME'),
			"desc" 		=> Loc::getMessage('MAIN_UI_SELECTOR_EMPLOYEE_DESCRIPTION')
		];

		if (!empty($lastItems[$entityType])) {
			$result["ITEMS_LAST"] = array_values($lastItems[$entityType]);
		}

		return $result;
	}

	public function getTabList($params = [])
	{
		$result = [];

		$options = (!empty($params['options']) ? $params['options'] : []);

		if (
			isset($options['addTab'])
			&& $options['addTab'] == 'Y'
		) {
			$result = array(
				array(
					'id' => 'usergroups',
					'name' => Loc::getMessage('MAIN_UI_SELECTOR_TAB_USERGROUPS'),
					'sort' => 20
				)
			);
		}

		return $result;
	}
}