(function(){BX.namespace("BX.VisualConstructor");"use strict";BX.VisualConstructor.BoardBase=function(t){this.renderTo=t.renderTo;this.boardId=t.boardId;this.filterId=t.filterId;this.isNowFiltering=false;this.rows=t.rows;this.dashboard=null;this.demoMode=t.demoMode||false;this.defaultBoard=t.defaultBoard||false;this.layout={demoModeFlagContainer:null};this.onAfterWidgetAddHandler=this.loadWidget.bind(this);this.onAferWidgetMoveHandler=this.saveWidgetPositions.bind(this);this.onAfterFormSaveHandler=this.handleFormSave.bind(this);this.onAfterFormCancelHandler=this.closeSlidePanel.bind(this);this.onAfterRemoveBoardRowHandler=this.removeRow.bind(this);this.onAfterAdjustBoardRowsHandler=this.adjustRows.bind(this);this.onBeforeFilterApplyHandler=this.onBeforeApplyFilter.bind(this);this.onFilterApplyHandler=this.onApplyFilter.bind(this);this.init()};BX.VisualConstructor.BoardBase.prototype={init:function(){this.buildDashboard();this.getDashboard().render();this.renderTo.style.position="relative";this.renderTo.appendChild(this.getDemoModeFlagContainer());if(this.isDemoMode()){this.showDemoFlag()}this.bindEvents();BX.VisualConstructor.BoardRepository.addBoard(this)},bindEvents:function(){BX.addCustomEvent("BX.Report.VisualConstructor.afterWidgetAdd",this.onAfterWidgetAddHandler);BX.addCustomEvent(this.dashboard,"BX.Report.Dashboard.Widget:afterMove",this.onAferWidgetMoveHandler);BX.addCustomEvent("BX.Report.VisualConstructor.Widget.Form:afterSave",this.onAfterFormSaveHandler);BX.addCustomEvent("BX.Report.VisualConstructor.Widget.Form:cancel",this.onAfterFormCancelHandler);BX.addCustomEvent(this.dashboard,"BX.Report.Dashboard.Board:afterRowRemove",this.onAfterRemoveBoardRowHandler);BX.addCustomEvent(this.dashboard,"BX.Report.Dashboard.Board:afterRowsAdjust",this.onAfterAdjustBoardRowsHandler);BX.addCustomEvent("BX.Main.Filter:beforeApply",this.onBeforeFilterApplyHandler);BX.addCustomEvent("BX.Main.Filter:apply",this.onFilterApplyHandler)},unbindEvents:function(){BX.removeCustomEvent("BX.Report.VisualConstructor.afterWidgetAdd",this.onAfterWidgetAddHandler);BX.removeCustomEvent(this.dashboard,"BX.Report.Dashboard.Widget:afterMove",this.onAferWidgetMoveHandler);BX.removeCustomEvent("BX.Report.VisualConstructor.Widget.Form:afterSave",this.onAfterFormSaveHandler);BX.removeCustomEvent("BX.Report.VisualConstructor.Widget.Form:cancel",this.onAfterFormCancelHandler);BX.removeCustomEvent(this.dashboard,"BX.Report.Dashboard.Board:afterRowRemove",this.onAfterRemoveBoardRowHandler);BX.removeCustomEvent(this.dashboard,"BX.Report.Dashboard.Board:afterRowsAdjust",this.onAfterAdjustBoardRowsHandler);BX.removeCustomEvent("BX.Main.Filter:beforeApply",this.onBeforeFilterApplyHandler);BX.removeCustomEvent("BX.Main.Filter:apply",this.onFilterApplyHandler)},showDemoFlag:function(){this.getDemoModeFlagContainer().classList.add("report-visualconstructor-demo-flag-visible")},hideDemoFlag:function(){this.getDemoModeFlagContainer().classList.remove("report-visualconstructor-demo-flag-visible")},getDemoModeFlagContainer:function(){if(this.layout.demoModeFlagContainer){return this.layout.demoModeFlagContainer}this.layout.demoModeFlagContainer=BX.create("div",{attrs:{className:"report-visualconstructor-demo-flag"},children:[BX.create("div",{attrs:{className:"report-visualconstructor-demo-flag-text"},text:BX.message("DASHBOARD_DEMO_FLAG_TEXT")}),BX.create("div",{attrs:{className:"report-visualconstructor-demo-flag-close-button"},events:{click:this.hideDemoFlag.bind(this)}}),BX.create("div",{attrs:{className:"report-visualconstructor-demo-flag-hide-link"},text:BX.message("DASHBOARD_DEMO_FLAG_HIDE_LINK"),events:{click:this.toggleDemoMode.bind(this)}})]});return this.layout.demoModeFlagContainer},toggleDemoMode:function(){BX.Report.VC.Core.abortAllRunningRequests();BX.Report.VC.Core.ajaxPost("board.toggleMode",{data:{boardKey:this.boardId},onFullSuccess:BX.delegate(function(t){if(!t.errors.length){this.getDashboard().clearRows();this.getDashboard().destroy();this.setDemoMode(t.data.demoMode);BX.Report.VC.Core.ajaxGet("widget.loadByBoardId",{urlParams:{boardId:this.boardId},onFullSuccess:BX.delegate(function(t){if(t.data.rows){this.getDashboard().addRows(t.data.rows);this.getDashboard().render()}},this)})}},this)})},onBeforeApplyFilter:function(t){if(this.filterId!==t){return}if(this.isNowFiltering){return}this.getDashboard().clearRows();this.getDashboard().destroy()},onApplyFilter:function(t,e,o,i,a){if(this.filterId!==t||this.isNowFiltering){return}this.isNowFiltering=true;this.reload().then(function(){this.isNowFiltering=false}.bind(this))},reload:function(){BX.Report.VC.Core.abortAllRunningRequests();this.getDashboard().clearRows();this.getDashboard().destroy();return new Promise(function(t){BX.Report.VC.Core.ajaxGet("widget.loadByBoardId",{urlParams:{boardId:this.getBoardId()},onFullSuccess:BX.defer(function(e){if(e.data.rows){this.getDashboard().addRows(e.data.rows);this.getDashboard().render()}t()},this)})}.bind(this))},isDemoMode:function(){return this.demoMode},setDemoMode:function(t){this.demoMode=t;if(!this.demoMode){this.hideDemoFlag()}else{this.showDemoFlag()}},getBoardId:function(){return this.boardId},saveWidgetPositions:function(t,e){if(e.isPseudo()){BX.Report.VC.Core.ajaxPost("row.add",{data:{params:{boardKey:this.getBoardId(),layoutMap:e.getRowLayout().getMapWithoutDomElements()}},onFullSuccess:BX.delegate(function(o){e.setId(o.data.id);this.getDashboard().adjustRowsWeight();this.sendWidgetUpdateRequests(t)},this)})}else{this.sendWidgetUpdateRequests(t)}},adjustRows:function(t){var e=[];for(var o=0;o<t.length;o++){e[t[o].getId()]={weight:t[o].getWeight()}}BX.Report.VC.Core.ajaxPost("row.adjustWeights",{data:{boardKey:this.getBoardId(),rows:e},onFullSuccess:function(t){}})},sendWidgetUpdateRequests:function(t){for(var e=0;e<t.length;e++){BX.Report.VC.Core.ajaxPost("widget.update",{data:{boardKey:this.getBoardId(),widgetId:t[e].getId(),params:{rowId:t[e].getCell().getRow().getId(),rowLayoutMap:t[e].getCell().getRow().getRowLayout().getMapWithoutDomElements(),cellId:t[e].getCell().getId()}},onFullSuccess:function(t){}})}},loadWidget:function(t){BX.Report.VC.Core.ajaxGet("widget.load",{urlParams:{widgetId:t.widgetId},onFullSuccess:BX.defer(function(t){var e=this.getDashboard().getRow(t.data.row.id);if(!e){e=new BX.Report.Dashboard.Row({id:t.data.row.id,layoutMap:t.data.row.layoutMap});this.getDashboard().addRowToStart(e);this.getDashboard().adjustRowsWeight()}e.addWidget(t.data)},this)})},handleFormSave:function(t){switch(t.mode){case"create":this.handleWidgetCreate(t);break;case"update":this.handleWidgetUpdate(t);break}},handleWidgetCreate:function(t){this.loadWidget(t)},handleWidgetUpdate:function(t){var e=this.getDashboard().getWidget(t.widgetId);e.reload(function(){e.sidePanel.close()})},closeSlidePanel:function(){var t=BX.SidePanel.Instance;t.close()},removeRow:function(t){setTimeout(function(){if(!t.row.isPseudo()){BX.Report.VC.Core.ajaxPost("row.delete",{data:{params:{boardId:t.row.getBoard().getId(),rowId:t.row.getId()}},onFullSuccess:function(t){}})}},3e3)},getDashboard:function(){return this.dashboard},buildDashboard:function(){this.dashboard=new BX.Report.Dashboard.Board({id:this.getBoardId(),renderTo:this.renderTo,rows:this.rows,designerMode:false,defaultWidgetClass:"BX.VisualConstructor.Widget",isDefault:this.defaultBoard})},reBuildDashboard:function(t){this.dashboard=new BX.Report.Dashboard.Board({id:this.getBoardId(),renderTo:this.renderTo,rows:t,designerMode:false,defaultWidgetClass:"BX.VisualConstructor.Widget",isDefault:this.defaultBoard})},destroy:function(){this.unbindEvents();this.dashboard=null;this.renderTo=null;this.layout=null;this.rows=null}};BX.VisualConstructor.BoardRepository={dashboards:[],addBoard:function(t){this.dashboards.push(t)},getBoard:function(t){var e=this.getBoards();for(var o=0;o<e.length;o++){if(e[o].getBoardId()===t){return e[o]}}return false},getBoards:function(){return this.dashboards},getLast:function(){if(this.dashboards.length>0){return this.dashboards[this.dashboards.length-1]}else{return null}},destroyBoards:function(){for(var t=0;t<this.dashboards.length;t++){this.dashboards[t].destroy();this.dashboards[t]=null}this.dashboards=[]}};BX.VisualConstructor.Widget=function(t){this.sidePanel=null;t.actionItems=[BX.create("div",{text:BX.message("DASHBOARD_WIDGET_PROPERTIES_TITLE"),events:{click:this.onPropertiesClickHandler.bind(this)}})];t.events=t.events||{};BX.Report.Dashboard.Widget.apply(this,arguments);this.layout.timePeriodMark=null;this.timePeriodMark=t.config.timePeriod||""};BX.VisualConstructor.Widget.prototype={__proto__:BX.Report.Dashboard.Widget.prototype,constructor:BX.VisualConstructor.Widget,setTimePeriodMark:function(t){this.timePeriodMark=t},onPropertiesClickHandler:function(){if(this.propertiesPopup){this.getPropertiesPopup().close()}this.sidePanel=BX.SidePanel.Instance;this.sidePanel.open("widget:properties-edit-"+this.id,{cacheable:false,contentCallback:BX.delegate(function t(e){var o=new BX.Promise;BX.Report.VC.Core.ajaxGet("widget.showConfigurationForm",{urlParams:{boardId:this.getRow().getBoard().getId(),widgetId:this.id},onFullSuccess:BX.delegate(function(t){e.getData().set("configurationFormContent",t.data);o.fulfill(t.data)},this)});return o},this),animationDuration:100,width:950,events:{onLoad:function(t){var e=t.getSlider();BX.html(e.layout.content,e.getData().get("configurationFormContent"))},onClose:function(){BX.Report.VC.PopupWindowManager.closeAllPopups()}}})},reload:function(t){if(!BX.type.isFunction(t)){t=BX.DoNothing}BX.Report.VC.Core.ajaxGet("widget.load",{urlParams:{widgetId:this.id},onFullSuccess:BX.delegate(function(e){this.config.title=e.data.config.title;this.setTimePeriodMark(e.data.config.timePeriod);this.setColor(e.data.config.color);this.setContent(e.data.content);BX.Report.Dashboard.Widget.prototype.lazyLoad.call(this);this.getCell().setHeight(this.getHeight());t.call(this)},this)})},lazyLoad:function(){if(!this.loaded){BX.Report.VC.Core.ajaxGet("widget.load",{urlParams:{widgetId:this.id},onFullSuccess:BX.delegate(function(t){this.config.title=t.data.config.title;this.setColor(t.data.config.color);this.setTimePeriodMark(t.data.config.timePeriod);this.setContent(t.data.content);BX.Report.Dashboard.Widget.prototype.lazyLoad.call(this)},this)})}},remove:function(){BX.Report.VC.Core.ajaxPost("widget.remove",{data:{params:{boardId:this.getRow().getBoard().getId(),widgetId:this.id}},onFullSuccess:BX.defer(function(){BX.Report.Dashboard.Widget.prototype.remove.call(this)},this)})},getContentWrapper:function(){var t=BX.Report.Dashboard.Widget.prototype.getContentWrapper.call(this);if(this.checkIsRendered()){BX.cleanNode(t)}if(this.getCell()!==null&&!this.getCell().getRow().getBoard().isDefault){t.appendChild(this.getWidgetTimePeriodMark())}else if(this.getCell()===null){t.appendChild(this.getWidgetTimePeriodMark())}return t},getWidgetTimePeriodMark:function(){var t=null;if(this.layout.timePeriodMark){t=this.layout.timePeriodMark}else{t=BX.create("div",{attrs:{className:"report-visualconstructor-widget-timer-period-mark-container"}})}t.innerHTML=this.timePeriodMark;this.layout.timePeriodMark=t;return this.layout.timePeriodMark},getControlsContainer:function(){var t=BX.Report.Dashboard.Widget.prototype.getControlsContainer.call(this);if(!this.getCell().getRow().getBoard().isDefault){t.appendChild(this.settingsButtonInHeader())}else{t.classList.add("report-visualconstuctor-widget-property-invisible")}return t},settingsButtonInHeader:function(){if(this.layout.settingsButtonContainer){return this.layout.settingsButtonContainer}this.layout.settingsButtonContainer=BX.create("div",{attrs:{className:"report-visualconstructor-properties-in-heed-button"},text:BX.message("DASHBOARD_WIDGET_PROPERTIES_BUTTON_HEAD_TITLE"),events:{click:this.onPropertiesClickHandler.bind(this)}});return this.layout.settingsButtonContainer}}})();
//# sourceMappingURL=script.map.js