<?if (!defined("B_PROLOG_INCLUDED") || B_PROLOG_INCLUDED!==true) die();

use Bitrix\Main,
	Bitrix\Main\Localization\Loc,
	Bitrix\Sale;

class SaleBasketLineComponent extends CBitrixComponent
{
	protected $bUseCatalog = null;
	protected $readyForOrderFilter = array("CAN_BUY" => "Y", "DELAY" => "N", "SUBSCRIBE" => "N");
	protected $disableUseBasket = false;

	protected ?int $currentFuser = null;
	protected bool $loaderCurrentFuser = false;

	/** @var Sale\Basket\Storage $basketStorage */
	protected $basketStorage;	// temporary unused

	public function onPrepareComponentParams($arParams)
	{
		// common

		$path = $arParams['PATH_TO_BASKET'] ?? '';
		$path = is_string($path) ? trim($path) : '';
		$arParams['PATH_TO_BASKET'] = $path ?: SITE_DIR . 'personal/cart/';

		$path = $arParams['PATH_TO_ORDER'] ?? '';
		$path = is_string($path) ? trim($path) : '';
		$arParams['PATH_TO_ORDER'] = $path ?: SITE_DIR . 'personal/order/make/';
		unset($path);

		$arParams["HIDE_ON_BASKET_PAGES"] = ($arParams["HIDE_ON_BASKET_PAGES"] ?? 'Y') === 'N' ? 'N' : 'Y';
		$arParams['SHOW_NUM_PRODUCTS'] = ($arParams['SHOW_NUM_PRODUCTS'] ?? 'Y') === 'N' ? 'N' : 'Y';
		$arParams['SHOW_TOTAL_PRICE'] = ($arParams['SHOW_TOTAL_PRICE'] ?? 'Y') === 'N' ? 'N' : 'Y';
		$arParams['SHOW_EMPTY_VALUES'] = ($arParams['SHOW_EMPTY_VALUES'] ?? 'Y') === 'N' ? 'N' : 'Y';

		// personal

		$arParams['SHOW_PERSONAL_LINK'] = ($arParams['SHOW_PERSONAL_LINK'] ?? 'N') === 'Y' ? 'Y' : 'N';

		$arParams['PATH_TO_PERSONAL'] = trim($arParams['PATH_TO_PERSONAL']);
		if ($arParams['PATH_TO_PERSONAL'] == '')
			$arParams['PATH_TO_PERSONAL'] = SITE_DIR.'personal/';

		// authorization

		$arParams['SHOW_AUTHOR'] = ($arParams['SHOW_AUTHOR'] ?? 'N') === 'Y' ? 'Y' : 'N';
		if ($arParams['SHOW_AUTHOR'] === 'Y')
		{
			$arParams['SHOW_REGISTRATION'] = ($arParams['SHOW_REGISTRATION'] ?? 'Y') === 'N' ? 'N' : 'Y';
		}
		else
		{
			$arParams['SHOW_REGISTRATION'] = 'N';
		}

		$path = $arParams['PATH_TO_REGISTER'] ?? '';
		$path = is_string($path) ? trim($path) : '';
		$arParams['PATH_TO_REGISTER'] = $path ?: Main\Config\Option::get('main', 'custom_register_page');
		if ($arParams['PATH_TO_REGISTER'] === '')
		{
			$arParams['PATH_TO_REGISTER'] = SITE_DIR . 'login/';
		}

		$path = $arParams['PATH_TO_AUTHORIZE'] ?? '';
		$path = is_string($path) ? trim($path) : '';
		$arParams['PATH_TO_AUTHORIZE'] = $path ?: $arParams['PATH_TO_REGISTER'];

		$path = $arParams['PATH_TO_PROFILE'] ?? '';
		$path = is_string($path) ? trim($path) : '';
		$arParams['PATH_TO_PROFILE'] = $path ?: SITE_DIR . 'personal/';
		unset($path);

		// list

		$arParams['SHOW_PRODUCTS'] = ($arParams['SHOW_PRODUCTS'] ?? 'N') === 'Y' ? 'Y' : 'N';
		$arParams['SHOW_DELAY'] = ($arParams['SHOW_DELAY'] ?? 'Y') === 'N' ? 'N' : 'Y';
		$arParams['SHOW_NOTAVAIL'] = ($arParams['SHOW_NOTAVAIL'] ?? 'Y') === 'N' ? 'N' : 'Y';
		$arParams['SHOW_IMAGE'] = ($arParams['SHOW_IMAGE'] ?? 'Y') === 'N' ? 'N' : 'Y';
		$arParams['SHOW_PRICE'] = ($arParams['SHOW_PRICE'] ?? 'Y') === 'N' ? 'N' : 'Y';
		$arParams['SHOW_SUMMARY'] = ($arParams['SHOW_SUMMARY'] ?? 'Y') === 'N' ? 'N' : 'Y';

		// Visual
		$arParams['POSITION_FIXED'] = ($arParams['POSITION_FIXED'] ?? 'N') === 'Y' ? 'Y' : 'N';

		if (!isset($arParams['POSITION_VERTICAL']) || ($arParams['POSITION_VERTICAL'] != 'bottom' && $arParams['POSITION_VERTICAL'] != 'vcenter'))
			$arParams['POSITION_VERTICAL'] = 'top';

		if (!isset($arParams['POSITION_HORIZONTAL']) || ($arParams['POSITION_HORIZONTAL'] != 'left' && $arParams['POSITION_HORIZONTAL'] != 'hcenter'))
			$arParams['POSITION_HORIZONTAL'] = 'right';

		$arParams['MAX_IMAGE_SIZE'] = (isset($arParams['MAX_IMAGE_SIZE']) ? (int)$arParams['MAX_IMAGE_SIZE'] : 70);
		if ($arParams['MAX_IMAGE_SIZE'] <= 0)
			$arParams['MAX_IMAGE_SIZE'] = 70;

		// ajax

		$arParams['AJAX'] = ($arParams['AJAX'] ?? 'N') === 'Y' ? 'Y' : 'N';

		return $arParams;
	}

	protected function getUserFilter()
	{
		$fUserID = (int)$this->currentFuser;
		return ($fUserID > 0)
			? array("=FUSER_ID" => $fUserID, "=LID" => SITE_ID, "ORDER_ID" => null)
			: null; // no basket for current user
	}

	protected function removeItemFromCart()
	{
		if (preg_match('/^[0-9]+$/', $_POST["sbblRemoveItemFromCart"]) !== 1)
			return;

		if (!($userFilter = $this->getUserFilter()))
			return;

		$numProducts = CSaleBasket::GetList(
			array(),
			$userFilter + array("ID" => $_POST['sbblRemoveItemFromCart']),
			array()
		);

		if ($numProducts > 0)
			CSaleBasket::Delete($_POST['sbblRemoveItemFromCart']);
	}

	public function executeComponent()
	{
		if ($this->arParams['HIDE_ON_BASKET_PAGES'] == 'Y')
		{
			$currentPage = mb_strtolower(\Bitrix\Main\Context::getCurrent()->getRequest()->getRequestedPage());
			$basketPage = mb_strtolower($this->arParams['PATH_TO_BASKET']);
			$orderPage = mb_strtolower($this->arParams['PATH_TO_ORDER']);
			if (
				strncmp($currentPage, $basketPage, mb_strlen($basketPage)) == 0
				|| strncmp($currentPage, $orderPage, mb_strlen($orderPage)) == 0
			)
				$this->disableUseBasket = true;
		}
		if (
			$this->disableUseBasket
			&& $this->arParams['SHOW_AUTHOR'] == 'N'
			&& $this->arParams['SHOW_PERSONAL_LINK'] == 'N'
		)
			return;

		if(!\Bitrix\Main\Loader::includeModule('sale'))
		{
			ShowError(GetMessage('SALE_MODULE_NOT_INSTALL'));
			return;
		}

		$this->loadCurrentFuser();

		if (isset($_POST['sbblRemoveItemFromCart']))
			$this->removeItemFromCart();

		// prepare result

		if(!\Bitrix\Main\Loader::includeModule("currency"))
		{
			ShowError(GetMessage("CURRENCY_MODULE_NOT_INSTALLED"));
			return;
		}

		$this->bUseCatalog = \Bitrix\Main\Loader::includeModule('catalog');

		$this->arResult = array(
			"TOTAL_PRICE" => 0,
			"TOTAL_PRICE_RAW" => 0,
			"NUM_PRODUCTS" => 0,
			"CATEGORIES" => array(),
			"ERROR_MESSAGE" => '',
			"DISABLE_USE_BASKET" => $this->disableUseBasket
		);

		if (!$this->disableUseBasket)
			$this->arResult['ERROR_MESSAGE'] = GetMessage("TSB1_EMPTY"); // deprecated

		if ($this->disableUseBasket)
		{
			$this->arParams['SHOW_PRODUCTS'] = 'N';
			$this->arParams['SHOW_TOTAL_PRICE'] = 'N';
			$this->arParams['SHOW_NUM_PRODUCTS'] = 'N';
			if ($this->arParams['SHOW_AUTHOR'] == 'Y')
				$this->arParams['SHOW_PERSONAL_LINK'] = 'N';
		}

		if($this->arParams["SHOW_PRODUCTS"] == "Y")
		{
			$this->arResult = $this->getProducts() + $this->arResult;
		}
		else
		{
			$currentFuser = $this->getFuserId();
			if($this->arParams["SHOW_TOTAL_PRICE"] == "Y")
			{
				$this->arResult["TOTAL_PRICE"] = \Bitrix\Sale\BasketComponentHelper::getFUserBasketPrice(
					$currentFuser,
					$this->getSiteId()
				);
			}

			$this->arResult["NUM_PRODUCTS"] = \Bitrix\Sale\BasketComponentHelper::getFUserBasketQuantity(
				$currentFuser,
				$this->getSiteId()
			);
			unset($currentFuser);
		}
		$this->arResult["TOTAL_PRICE_RAW"] = $this->arResult["TOTAL_PRICE"];

		if ($this->arParams["SHOW_TOTAL_PRICE"] == "Y")
		{
			$this->arResult["TOTAL_PRICE"] = CCurrencyLang::CurrencyFormat(
				$this->arResult["TOTAL_PRICE"],
				Sale\Internals\SiteCurrencyTable::getSiteCurrency($this->getSiteId()),
				true
			);
		}

		$messages = [
			'ZERO' => 'BX_CP_SBBL_MESS_POSITION_DESCR_0',
			'ONE' => 'BX_CP_SBBL_MESS_POSITION_DESCR_1',
			'TEN' => 'BX_CP_SBBL_MESS_POSITION_DESCR_10_20',
			'MOD_ONE' => 'BX_CP_SBBL_MESS_POSITION_DESCR_MOD_1',
			'MOD_TWO' => 'BX_CP_SBBL_MESS_POSITION_DESCR_MOD_2_4',
			'OTHER' => 'BX_CP_SBBL_MESS_POSITION_DESCR_OTHER'
		];
		$this->arResult['BASKET_COUNT_DESCRIPTION'] = $this->getBasketCountDescription(
			$this->arResult["NUM_PRODUCTS"],
			$messages
		);

		// compatibility begin!
		$messages = [
			'ZERO' => 'BX_CP_SBBL_MESS_POSITION_SHORT_DESCR_0',
			'ONE' => 'BX_CP_SBBL_MESS_POSITION_SHORT_DESCR_1',
			'TEN' => 'BX_CP_SBBL_MESS_POSITION_SHORT_DESCR_10_20',
			'MOD_ONE' => 'BX_CP_SBBL_MESS_POSITION_SHORT_DESCR_MOD_1',
			'MOD_TWO' => 'BX_CP_SBBL_MESS_POSITION_SHORT_DESCR_MOD_2_4',
			'OTHER' => 'BX_CP_SBBL_MESS_POSITION_SHORT_DESCR_OTHER'
		];
		$this->arResult['PRODUCT(S)'] = $this->getBasketCountDescription(
			$this->arResult["NUM_PRODUCTS"],
			$messages
		);
		$this->arResult["PRODUCTS"] = Loc::getMessage(
			'BX_CP_SBBL_MESS_TOTAL_POSITITON',
			['#VALUE#' => $this->arResult['BASKET_COUNT_DESCRIPTION']]

		);
		// compatibility end!
		unset($messages);

		// output
		if ($this->arParams['AJAX'] == 'Y')
			$this->includeComponentTemplate('ajax_template');
		else
			$this->includeComponentTemplate();
	}

	private static $nextNumber = 0;

	public static function getNextNumber()
	{
		return ++self::$nextNumber;
	}

	private function getProducts()
	{
		$result = [
			'NUM_PRODUCTS' => 0,
			'TOTAL_PRICE' => 0,
			'CATEGORIES' => [
				'READY' => []
			]
		];

		$currentFuser = $this->getFuserId();
		if ($currentFuser === null)
		{
			return $result;
		}

		$registry = Sale\Registry::getInstance(Sale\Registry::REGISTRY_TYPE_ORDER);

		/** @var Sale\Basket $basketClass */
		$basketClass = $registry->getBasketClassName();

		$fullBasket = $basketClass::loadItemsForFUser($currentFuser, $this->getSiteId());
		if ($fullBasket->isEmpty())
			return $result;

		$basketItemList = [];

		/** @var Sale\Basket $basketClone */
		$basketClone = $fullBasket->createClone();
		$orderableBasket = $basketClone->getOrderableItems();
		unset($basketClone);
		if (!$orderableBasket->isEmpty())
		{
			$onlySaleDiscounts = (string)Main\Config\Option::get('sale', 'use_sale_discount_only') == 'Y';
			if (!$onlySaleDiscounts)
			{
				$orderableBasket->refresh(Sale\Basket\RefreshFactory::create(Sale\Basket\RefreshFactory::TYPE_FULL));
			}
			$discounts = Sale\Discount::buildFromBasket(
				$orderableBasket,
				new Sale\Discount\Context\Fuser($this->getFuserId())
			);
			$discountResult = $discounts->calculate();
			if ($discountResult->isSuccess())
			{
				$showPrices = $discounts->getShowPrices();
				if (!empty($showPrices['BASKET']))
				{
					foreach ($showPrices['BASKET'] as $basketCode => $data)
					{
						$basketItem = $orderableBasket->getItemByBasketCode($basketCode);
						if ($basketItem instanceof Sale\BasketItemBase)
						{
							$basketItem->setFieldNoDemand('BASE_PRICE', $data['SHOW_BASE_PRICE']);
							$basketItem->setFieldNoDemand('PRICE', $data['SHOW_PRICE']);
							$basketItem->setFieldNoDemand('DISCOUNT_PRICE', $data['SHOW_DISCOUNT']);
						}
					}
					unset($basketItem, $basketCode, $data);
				}
				unset($showPrices);
			}
			unset($discountResult);

			$result['TOTAL_PRICE'] = $orderableBasket->getPrice();
			$result['NUM_PRODUCTS'] = $orderableBasket->count();

			/** @var Sale\BasketItem $basketItem */
			foreach ($orderableBasket as $basketItem)
			{
				$basketItemList[] = $this->getItemData($basketItem);
			}
			unset($item, $basketItem);
		}
		unset($orderableBasket);

		/** @var Sale\BasketItem $basketItem */
		foreach ($fullBasket as $basketItem)
		{
			$skip = false;
			if ($basketItem->canBuy())
			{
				if (
					!$basketItem->isDelay()
					|| ($basketItem->isDelay() && $this->arParams['SHOW_DELAY'] == 'N')
				)
					$skip = true;
			}
			else
			{
				if ($this->arParams['SHOW_NOTAVAIL'] == 'N')
					$skip = true;
			}
			if ($skip)
				continue;
			$item = $this->getItemData($basketItem);
			$basketItemList[] = $item;
		}
		unset($basketItem, $fullBasket);

		if (empty($basketItemList))
			return $result;

		$this->loadProductPictures($basketItemList);

		if ($this->arParams['SHOW_DELAY'] != 'N')
			$result['CATEGORIES']['DELAY'] = [];
		if ($this->arParams['SHOW_NOTAVAIL'] != 'N')
		{
			$result['CATEGORIES']['SUBSCRIBE'] = [];
			$result['CATEGORIES']['NOTAVAIL'] = [];
		}

		foreach ($basketItemList as $item)
		{
			if ($item['CAN_BUY'] == 'Y')
			{
				if ($item['DELAY'] == 'Y')
					$result['CATEGORIES']['DELAY'][] = $item;
				else
					$result['CATEGORIES']['READY'][] = $item;
			}
			else
			{
				if ($item['SUBSCRIBE'] == 'Y')
					$result['CATEGORIES']['SUBSCRIBE'][] = $item;
				else
					$result['CATEGORIES']['NOTAVAIL'][] = $item;
			}
		}
		unset($basketItemList, $item);

		foreach (array_keys($result['CATEGORIES']) as $index)
		{
			if (empty($result['CATEGORIES'][$index]))
				unset($result['CATEGORIES'][$index]);
		}
		unset($index);

		return $result;
	}

	protected function loadProductPictures(array &$basketItemList)
	{
		if ($this->arParams['SHOW_IMAGE'] == 'Y' && $this->bUseCatalog)
		{
			$elementIdList = array();
			$productMap = array();
			foreach ($basketItemList as $item)
			{
				if ((string)$item['MODULE'] !== 'catalog')
					continue;
				$elementIdList[$item['PRODUCT_ID']] = $item['PRODUCT_ID'];
			}
			unset($item);
			if (!empty($elementIdList))
			{
				$productList = \CCatalogSku::getProductList($elementIdList);
				if (!empty($productList))
				{
					foreach ($productList as $offerId => $data)
						$productMap[$offerId] = $data['ID'];
					unset($offerId, $data);
				}
				unset($productList);
			}
			$this->setImgSrc($basketItemList, $elementIdList, $productMap);
			unset($productMap, $elementIdList);
		}
	}

	private function setImgSrc(&$arBasketItems, $arElementId, $arSku2Parent)
	{
		//TODO: need refactoring
		$arImgFields = array ("PREVIEW_PICTURE", "DETAIL_PICTURE", "PROPERTY_MORE_PHOTO");
		$arProductData = getProductProps(array_merge($arElementId, $arSku2Parent), array_merge(array("ID"), $arImgFields));

		foreach ($arBasketItems as &$arItem)
		{
			if (array_key_exists($arItem["PRODUCT_ID"], $arProductData) && is_array($arProductData[$arItem["PRODUCT_ID"]]))
			{
				foreach ($arProductData[$arItem["PRODUCT_ID"]] as $key => $value)
				{
					if (mb_strpos($key, "PROPERTY_") !== false || in_array($key, $arImgFields))
						$arItem[$key] = $value;
				}
			}

			if (array_key_exists($arItem["PRODUCT_ID"], $arSku2Parent)) // if sku element doesn't have value of some property - we'll show parent element value instead
			{
				foreach ($arImgFields as $field) // fields to be filled with parents' values if empty
				{
					$fieldVal = (in_array($field, $arImgFields)) ? $field : $field."_VALUE";
					$parentId = $arSku2Parent[$arItem["PRODUCT_ID"]];

					if ((!isset($arItem[$fieldVal]) || (isset($arItem[$fieldVal]) && $arItem[$fieldVal] == ''))
						&& (isset($arProductData[$parentId][$fieldVal]) && !empty($arProductData[$parentId][$fieldVal]))) // can be array or string
					{
						$arItem[$fieldVal] = $arProductData[$parentId][$fieldVal];
					}
				}
			}

			$arItem["PICTURE_SRC"] = "";
			$arImage = null;
			if (isset($arItem["PREVIEW_PICTURE"]) && intval($arItem["PREVIEW_PICTURE"]) > 0)
				$arImage = CFile::GetFileArray($arItem["PREVIEW_PICTURE"]);
			elseif (isset($arItem["DETAIL_PICTURE"]) && intval($arItem["DETAIL_PICTURE"]) > 0)
				$arImage = CFile::GetFileArray($arItem["DETAIL_PICTURE"]);
			if ($arImage)
			{
				$arFileTmp = CFile::ResizeImageGet(
					$arImage,
					array("width" => $this->arParams['MAX_IMAGE_SIZE'], "height" => $this->arParams['MAX_IMAGE_SIZE']),
					BX_RESIZE_IMAGE_PROPORTIONAL,
					true
				);
				$arItem["PICTURE_SRC"] = $arFileTmp["src"];
			}
		}
	}

	/**
	 * @param \Bitrix\Main\Event $event
	 *
	 * @return \Bitrix\Main\EventResult
	 */
	public function onSaleBasketItemEntitySaved(\Bitrix\Main\Event $event)
	{
		return \Bitrix\Sale\BasketComponentHelper::onSaleBasketItemEntitySaved($event);
	}

	/**
	 * @param \Bitrix\Main\Event $event
	 *
	 * @return \Bitrix\Main\EventResult
	 */
	public function onSaleBasketItemDeleted(\Bitrix\Main\Event $event)
	{
		return \Bitrix\Sale\BasketComponentHelper::onSaleBasketItemDeleted($event);
	}

	/**
	 * @param \Bitrix\Sale\Basket $basket
	 *
	 * @return float
	 */
	protected static function getActualBasketPrice(\Bitrix\Sale\Basket $basket)
	{
		$basketPrice = 0;

		/** @var \Bitrix\Sale\Basket $basketOrderable */
		$basketOrderable = $basket->getOrderableItems();

		/** @var \Bitrix\Sale\BasketItem $basketItem */
		foreach ($basketOrderable as $basketItem)
		{
			if (intval($basketItem->getField('ORDER_ID')) > 0)
			{
				continue;
			}

			if (!$basketItem->isBundleChild())
			{
				$basketPrice += $basketItem->getFinalPrice();
			}
		}

		return $basketPrice;
	}

	/**
	 * @param \Bitrix\Sale\Basket $basket
	 *
	 * @return float
	 */
	protected static function getActualBasketQuantity(\Bitrix\Sale\Basket $basket)
	{
		$basketQuantity = 0;

		/** @var \Bitrix\Sale\Basket $basketOrderable */
		$basketOrderable = $basket->getOrderableItems();
		/** @var \Bitrix\Sale\BasketItem $basketItem */
		foreach ($basketOrderable as $basketItem)
		{
			if (intval($basketItem->getField('ORDER_ID')) > 0)
			{
				continue;
			}

			if (!$basketItem->isBundleChild())
			{
				$basketQuantity++;
			}
		}

		return $basketQuantity;
	}

	protected function getFuserId(): ?int
	{
		if (!$this->loaderCurrentFuser)
		{
			$this->loadCurrentFuser();
		}

		return $this->currentFuser;
	}

	protected function loadCurrentFuser()
	{
		if ($this->loaderCurrentFuser)
		{
			return;
		}
		$this->currentFuser = Sale\Fuser::getId(true);
		$this->loaderCurrentFuser = true;
	}

	protected function getBasketStorage()
	{
		if (!isset($this->basketStorage))
		{
			$this->basketStorage = Sale\Basket\Storage::getInstance($this->currentFuser, $this->getSiteId());
		}

		return $this->basketStorage;
	}

	private function makeCompatibleArray(&$array)
	{
		if (empty($array) || !is_array($array))
			return;

		$arr = array();
		foreach ($array as $key => $value)
		{
			if (is_array($value) || preg_match("/[;&<>\"]/", $value))
			{
				$arr[$key] = htmlspecialcharsEx($value);
			}
			else
			{
				$arr[$key] = $value;
			}

			$arr['~'.$key] = $value;
		}

		$array = $arr;
	}

	private function getItemData(Sale\BasketItem $item)
	{
		$result = $item->getFieldValues();
		$this->makeCompatibleArray($result);
		$result['PRODUCT_ID'] = (int)$result['PRODUCT_ID'];
		$result['QUANTITY'] = $item->getQuantity();
		$result['MEASURE_NAME'] = (string)$result['MEASURE_NAME'];
		if ($result['MEASURE_NAME'] == '')
			$result['MEASURE_NAME'] = GetMessage('TSB1_MEASURE_NAME');
		$result['PRICE'] = Sale\PriceMaths::roundPrecision($result['PRICE']);
		$result['BASE_PRICE'] = Sale\PriceMaths::roundPrecision($result['BASE_PRICE']);
		$result['DISCOUNT_PRICE'] = Sale\PriceMaths::roundPrecision($result['DISCOUNT_PRICE']);
		$result['SUM_VALUE'] = $result['PRICE'] * $result['QUANTITY'];

		$result['SUM'] = \CCurrencyLang::CurrencyFormat($result['SUM_VALUE'], $result['CURRENCY'], true);
		$result['PRICE_FMT'] = \CCurrencyLang::CurrencyFormat($result['PRICE'], $result['CURRENCY'], true);
		$result['FULL_PRICE'] = \CCurrencyLang::CurrencyFormat($result['BASE_PRICE'], $result['CURRENCY'], true);

		// unused fields from \CSaleDiscount::DoProcessOrder - compatibility
		$result['PRICE_FORMATED'] = $result['PRICE_FMT'];
		$result['DISCOUNT_PRICE_PERCENT'] = Sale\Discount::calculateDiscountPercent(
			$result['BASE_PRICE'],
			$result['DISCOUNT_PRICE']
		);
		$result['DISCOUNT_PRICE_PERCENT_FORMATED'] = $result['DISCOUNT_PRICE_PERCENT'].'%';

		return $result;
	}

	/**
	 * @param int $count
	 * @param array $messages
	 * @return string
	 */
	protected static function getBasketCountDescription(int $count, array $messages)
	{
		if ($count < 0)
			return '';

		$val = ($count < 100 ? $count : $count % 100);
		$dec = $val % 10;

		if ($val == 0)
		{
			$messageId = 'ZERO';
		}
		elseif ($val == 1)
		{
			$messageId = 'ONE';
		}
		elseif ($val >= 10 && $val <= 20)
		{
			$messageId = 'TEN';
		}
		elseif ($dec == 1)
		{
			$messageId = 'MOD_ONE';
		}
		elseif (2 <= $dec && $dec <= 4)
		{
			$messageId = 'MOD_TWO';
		}
		else
		{
			$messageId = 'OTHER';
		}

		return (isset($messages[$messageId])
			? Loc::getMessage($messages[$messageId], ['#VALUE#' => $count])
			: ''
		);
	}
}

// Compatibility
if (!function_exists('BasketNumberWordEndings'))
{
	function BasketNumberWordEndings($num, $lang = false, $arEnds = false)
	{
		if ($lang===false)
			$lang = LANGUAGE_ID;

		if ($arEnds===false)
			$arEnds = array(GetMessage("TSB1_WORD_OBNOVL_END1"), GetMessage("TSB1_WORD_OBNOVL_END2"), GetMessage("TSB1_WORD_OBNOVL_END3"), GetMessage("TSB1_WORD_OBNOVL_END4"));

		if ($lang=="ru")
		{
			if (mb_strlen($num) > 1 && mb_substr($num, mb_strlen($num) - 2, 1) == "1")
			{
				return $arEnds[0];
			}
			else
			{
				$c = intval(mb_substr($num, mb_strlen($num) - 1, 1));
				if ($c==0 || ($c>=5 && $c<=9))
					return $arEnds[1];
				elseif ($c==1)
					return $arEnds[2];
				else
					return $arEnds[3];
			}
		}
		elseif ($lang=="en")
		{
			if (intval($num)>1)
			{
				return "s";
			}
			return "";
		}
		else
		{
			return "";
		}
	}
}