(function(){"use strict";BX.namespace("BX.Sale.BasketComponent");BX.Sale.BasketComponent={maxItemsShowCount:30,precisionFactor:Math.pow(10,6),stickyHeaderOffset:0,duration:{priceAnimation:300,filterTimer:300},ids:{item:"basket-item-",quantity:"basket-item-quantity-",price:"basket-item-price-",sumPrice:"basket-item-sum-price-",sumPriceOld:"basket-item-sum-price-old-",sumPriceDiff:"basket-item-sum-price-difference-",itemHeightAligner:"basket-item-height-aligner-",total:"basket-total-price",basketRoot:"basket-root",itemListWrapper:"basket-items-list-wrapper",itemListContainer:"basket-items-list-container",itemList:"basket-item-list",itemListTable:"basket-item-table",itemListEmptyResult:"basket-item-list-empty-result",itemListOverlay:"basket-items-list-overlay",warning:"basket-warning"},initializePrimaryFields:function(){this.templates={};this.nodes={};this.items={};this.sortedItems=[];this.shownItems=[];this.changedItems=[];this.postponedItems=[];this.warningItems=[];this.isMobile=BX.browser.IsMobile();this.isTouch=BX.hasClass(document.documentElement,"bx-touch");this.lastAction="initialLoad";this.coupons=null;this.imagePopup=null;this.loadingScreen=null;this.quantityDelay=null;this.quantityTimer=null},init:function(t){this.initializePrimaryFields();this.params=t.params||{};this.template=t.template||"";this.signedParamsString=t.signedParamsString||"";this.siteId=t.siteId||"";this.siteTemplateId=t.siteTemplateId||"";this.ajaxUrl=this.params.AJAX_PATH||"";this.templateFolder=t.templateFolder||"";this.useDynamicScroll=this.params.USE_DYNAMIC_SCROLL==="Y";this.useItemsFilter=this.params.SHOW_FILTER==="Y"&&!this.isMobile;this.initializeFilter();this.applyBasketResult(t.result);this.initializeActionPool();if(this.useItemsFilter){this.checkHeaderDisplay();this.bindHeaderEvents()}this.initializeBasketItems();this.editTotal();this.editWarnings();this.getCacheNode(this.ids.basketRoot).style.opacity=1;this.bindInitialEvents()},getTemplate:function(t){if(!this.templates.hasOwnProperty(t)){var i=BX(t);this.templates[t]=BX.type.isDomNode(i)?i.innerHTML:""}return this.templates[t]},getCacheNode:function(t){if(!this.nodes.hasOwnProperty(t)){this.nodes[t]=BX(t)}return this.nodes[t]},getEntity:function(t,i,e){if(!t||!i)return null;e=e||"";return t.querySelector(e+'[data-entity="'+i+'"]')},getEntities:function(t,i,e){if(!t||!i)return{length:0};e=e||"";return t.querySelectorAll(e+'[data-entity="'+i+'"]')},bindInitialEvents:function(){this.bindWarningEvents();BX.bind(window,"scroll",BX.proxy(this.checkStickyHeaders,this));BX.bind(window,"scroll",BX.proxy(this.lazyLoad,this));BX.bind(window,"resize",BX.throttle(this.checkStickyHeaders,20,this))},bindWarningEvents:function(){var t=this.getEntity(BX(this.ids.warning),"basket-items-warning-count");if(BX.type.isDomNode(t)){t.style.display="";BX.bind(t,"click",BX.delegate(function(){this.toggleFilter("warning")},this))}BX.bind(this.getEntity(BX(this.ids.warning),"basket-items-warning-notification-close"),"click",BX.proxy(this.removeAllWarnings,this))},toggleFilter:function(t){var i=BX.type.isNotEmptyString(t)?this.getEntity(this.getCacheNode(this.ids.itemListWrapper),"basket-items-count",'[data-filter="'+t+'"]'):BX.getEventTarget(t);if(!BX.type.isDomNode(i)||BX.hasClass(i,"active"))return;var e=i.getAttribute("data-filter");var s=i.parentNode.querySelectorAll("[data-filter]");for(var a=0;a<s.length;a++){if(s[a].getAttribute("data-filter")===e){BX.addClass(s[a],"active")}else if(BX.hasClass(s[a],"active")){BX.removeClass(s[a],"active")}}this.filter.showFilterByName(e)},scrollToFirstItem:function(){var t=this.getEntity(this.getCacheNode(this.ids.itemListWrapper),"basket-items-list-header");if(BX.type.isDomNode(t)){var i=BX.pos(this.getCacheNode(this.ids.itemListContainer)).top;var e=BX.pos(t).bottom;if(i<e){window.scrollTo(0,i-this.stickyHeaderOffset)}}},showItemsOverlay:function(){var t=this.getCacheNode(this.ids.itemListOverlay);if(BX.type.isDomNode(t)){t.style.display=""}},hideItemsOverlay:function(){var t=this.getCacheNode(this.ids.itemListOverlay);if(BX.type.isDomNode(t)){t.style.display="none"}},checkHeaderDisplay:function(){var t=this.getCacheNode(this.ids.itemListWrapper);if(BX.type.isDomNode(t)){BX.removeClass(t,"basket-items-list-wrapper-light")}},bindHeaderEvents:function(){var t=this.getEntities(this.getCacheNode(this.ids.itemListWrapper),"basket-items-count");for(var i=0;i<t.length;i++){BX.bind(t[i],"click",BX.proxy(this.toggleFilter,this))}},checkStickyHeaders:function(){if(this.isMobile)return;var t,i;var e=2,s=0;var a=this.getDocumentScrollTop();var n=BX.pos(this.getCacheNode(this.ids.basketRoot));var r=a+200>=n.bottom;if(BX.util.in_array("top",this.params.TOTAL_BLOCK_DISPLAY)){var o=this.getEntity(this.getCacheNode(this.ids.basketRoot),"basket-total-block");if(BX.type.isDomNode(o)){t=this.getEntity(o,"basket-checkout-aligner");if(BX.type.isDomNode(t)){i=BX.pos(o);if(a>=i.top){s+=t.clientHeight;if(!BX.hasClass(t,"basket-checkout-container-fixed")){o.style.height=i.height+"px";t.style.width=t.clientWidth+e+"px";BX.addClass(t,"basket-checkout-container-fixed")}}else if(BX.hasClass(t,"basket-checkout-container-fixed")){o.style.height="";t.style.width="";BX.removeClass(t,"basket-checkout-container-fixed")}if(r){if(!BX.hasClass(t,"basket-checkout-container-fixed-hide")){BX.addClass(t,"basket-checkout-container-fixed-hide")}}else if(BX.hasClass(t,"basket-checkout-container-fixed-hide")){BX.removeClass(t,"basket-checkout-container-fixed-hide")}}}}if(this.useItemsFilter){var h=this.getCacheNode(this.ids.itemListWrapper);t=this.getEntity(h,"basket-items-list-header");if(BX.type.isDomNode(t)){i=BX.pos(h);if(a+s>=i.top&&!r){if(!BX.hasClass(t,"basket-items-list-header-fixed")){t.style.width=t.clientWidth+e+"px";h.style.paddingTop=t.clientHeight+"px";BX.addClass(t,"basket-items-list-header-fixed")}if(s){t.style.top=s+"px"}s+=t.clientHeight}else if(BX.hasClass(t,"basket-items-list-header-fixed")){h.style.paddingTop="";t.style.width="";t.style.top="";BX.removeClass(t,"basket-items-list-header-fixed")}}}this.stickyHeaderOffset=s},getDocumentScrollTop:function(){return window.scrollY||window.pageYOffset||document.body.scrollTop+(document.documentElement&&document.documentElement.scrollTop||0)},lazyLoad:function(){var t=BX.pos(this.getCacheNode(this.ids.itemListContainer));if(this.getDocumentScrollTop()+window.innerHeight>=t.bottom-400){var i=this.getItemsAfter();if(i.length){this.editBasketItems(i)}}},fireCustomEvents:function(){if(this.result.EVENT_ONCHANGE_ON_START==="Y"){BX.onCustomEvent("OnBasketChange")}if(this.params.HIDE_COUPON!=="Y"){if(this.coupons!==null&&this.coupons!==this.result.COUPON_LIST){BX.onCustomEvent("OnCouponApply")}this.coupons=this.result.COUPON_LIST}},editTotal:function(){this.fillTotalBlocks();this.showItemsCount();this.showWarningItemsCount();this.showNotAvailableItemsCount();this.showDelayedItemsCount()},fillTotalBlocks:function(){var t=this.getEntities(this.getCacheNode(this.ids.basketRoot),"basket-total-block");if(t&&t.length){var i=this.getTemplate("basket-total-template");if(i){var e=this.render(i,this.result.TOTAL_RENDER_DATA);for(var s in t){if(t.hasOwnProperty(s)&&BX.type.isDomNode(t[s])){t[s].innerHTML=e;this.bindTotalEvents(t[s])}}}}this.checkStickyHeaders()},showItemsCount:function(){var t=this.getEntity(this.getCacheNode(this.ids.itemListWrapper),"basket-items-count",'[data-filter="all"]');if(BX.type.isDomNode(t)){t.innerHTML=BX.message("SBB_IN_BASKET")+" "+this.result.BASKET_ITEMS_COUNT+" "+this.getGoodsMessage(this.result.BASKET_ITEMS_COUNT);t.style.display=""}},showSimilarCount:function(t){var i=this.getEntity(this.getCacheNode(this.ids.itemListWrapper),"basket-items-count",'[data-filter="similar"]');if(BX.type.isDomNode(i)){if(t){i.innerHTML=this.sortedItems.length+" "+this.getGoodsMessage(this.result.BASKET_ITEMS_COUNT,"SBB_SIMILAR_ITEM");i.style.display=""}else{i.style.display="none"}}},showWarningItemsCount:function(){var t=this.getEntity(this.getCacheNode(this.ids.itemListWrapper),"basket-items-count",'[data-filter="warning"]');if(BX.type.isDomNode(t)){if(this.warningItems.length){t.innerHTML=this.warningItems.length+" "+BX.message("SBB_BASKET_ITEMS_WARNING");t.style.display=""}else{t.style.display="none"}}},showNotAvailableItemsCount:function(){var t=this.getEntity(this.getCacheNode(this.ids.itemListWrapper),"basket-items-count",'[data-filter="not-available"]');if(BX.type.isDomNode(t)){if(parseInt(this.result.NOT_AVAILABLE_BASKET_ITEMS_COUNT)){t.innerHTML=this.result.NOT_AVAILABLE_BASKET_ITEMS_COUNT+" "+this.getGoodsMessage(this.result.NOT_AVAILABLE_BASKET_ITEMS_COUNT,"SBB_NOT_AVAILABLE_ITEM");t.style.display=""}else{t.style.display="none"}}},showDelayedItemsCount:function(){var t=this.getEntity(this.getCacheNode(this.ids.itemListWrapper),"basket-items-count",'[data-filter="delayed"]');if(BX.type.isDomNode(t)){if(parseInt(this.result.DELAYED_BASKET_ITEMS_COUNT)){t.innerHTML=this.result.DELAYED_BASKET_ITEMS_COUNT+" "+this.getGoodsMessage(this.result.DELAYED_BASKET_ITEMS_COUNT,"SBB_DELAYED_ITEM");t.style.display=""}else{t.style.display="none"}}},getGoodsMessage:function(t,i){var e;var s=t>10&&t<20?0:t%10;if(s===1){e=i||"SBB_GOOD"}else if(s>=2&&s<=4){e=i?i+"_2":"SBB_GOOD_2"}else{e=i?i+"S":"SBB_GOODS"}return BX.message(e)},bindTotalEvents:function(t){if(!this.result.TOTAL_RENDER_DATA.DISABLE_CHECKOUT){BX.bind(this.getEntity(t,"basket-checkout-button"),"click",BX.proxy(this.checkOutAction,this))}BX.bind(this.getEntity(t,"basket-coupon-input"),"change",BX.proxy(this.addCouponAction,this));BX.bind(this.getEntity(t,"basket-coupon-input"),"paste",BX.proxy(this.pasteCouponAction,this));var i=this.getEntities(t,"basket-coupon-delete");for(var e=0,s=i.length;e<s;e++){BX.bind(i[e],"click",BX.proxy(this.removeCouponAction,this))}},checkOutAction:function(){document.location.href=this.params.PATH_TO_ORDER},addCouponAction:function(t){var i=BX.getEventTarget(t);if(i&&i.value){this.actionPool.addCoupon(i.value);i.disabled=true}},pasteCouponAction:function(t){setTimeout(BX.delegate(function(){this.addCouponAction(t)},this),10)},removeCouponAction:function(){var t=BX.proxy_context&&BX.util.trim(BX.proxy_context.getAttribute("data-coupon"));if(t){this.actionPool.removeCoupon(t)}},initializeActionPool:function(){this.actionPool=new BX.Sale.BasketActionPool(this)},initializeFilter:function(){this.filter=new BX.Sale.BasketFilter(this)},sendRequest:function(t,i){this.lastAction=t;if(this.lastAction==="recalculateAjax"){i.lastAppliedDiscounts=BX.util.array_keys(this.result.FULL_DISCOUNT_LIST).join(",");if(this.params.USE_ENHANCED_ECOMMERCE==="Y"){this.checkAnalytics(i)}}BX.ajax({method:"POST",dataType:"json",url:this.ajaxUrl,data:this.getData(i),onsuccess:BX.delegate(function(t){this.actionPool.doProcessing(false);if(!BX.type.isPlainObject(t))return;this.actionPool.setRefreshStatus(t.BASKET_REFRESHED);if(t.RESTORED_BASKET_ITEMS){this.restoreBasketItems(t.RESTORED_BASKET_ITEMS)}if(t.DELETED_BASKET_ITEMS){this.deleteBasketItems(t.DELETED_BASKET_ITEMS,this.params.SHOW_RESTORE==="Y")}if(t.MERGED_BASKET_ITEMS){this.deleteBasketItems(t.MERGED_BASKET_ITEMS,false,true)}this.applyBasketResult(t.BASKET_DATA);this.editBasketItems(this.getItemsToEdit());this.editTotal();this.applyPriceAnimation();this.editWarnings();this.actionPool.switchTimer();if(this.isBasketIntegrated()&&this.isBasketChanged()){BX.Sale.OrderAjaxComponent.sendRequest()}},this),onfailure:BX.delegate(function(){this.actionPool.doProcessing(false)},this)})},isBasketIntegrated:function(){return this.params.BASKET_WITH_ORDER_INTEGRATION==="Y"},isBasketChanged:function(){return this.changedItems.length},addPriceAnimationData:function(t,i,e,s){if(!BX.type.isPlainObject(this.priceAnimationData)){this.clearPriceAnimationData()}this.priceAnimationData.start[t]=parseFloat(i);this.priceAnimationData.finish[t]=parseFloat(e);this.priceAnimationData.currency[t]=s;this.priceAnimationData.int[t]=parseFloat(i)===parseInt(i)&&parseFloat(e)===parseInt(e)},clearPriceAnimationData:function(){this.priceAnimationData={start:{},finish:{},currency:{},int:{}}},applyBasketResult:function(t){this.changedItems=[];this.clearPriceAnimationData();if(!BX.type.isPlainObject(t)){return}if(t.BASKET_ITEM_RENDER_DATA){var i,e;for(i in t.BASKET_ITEM_RENDER_DATA){if(t.BASKET_ITEM_RENDER_DATA.hasOwnProperty(i)){e=t.BASKET_ITEM_RENDER_DATA[i];e.WARNINGS=this.checkBasketItemWarnings(e,t.WARNING_MESSAGE_WITH_CODE);if(this.items[e.ID]){if(JSON.stringify(this.items[e.ID])===JSON.stringify(e)){continue}}else{this.addSortedItem(e.ID,true)}this.changedItems.push(e.ID);e=this.checkBasketItemsAnimation(e);this.items[e.ID]=e}}this.changedItems=BX.util.array_unique(this.changedItems.concat(this.getChangedSimilarOffers()));if(this.isBasketChanged()){this.sortSortedItems(true)}}if(t.TOTAL_RENDER_DATA){t.TOTAL_RENDER_DATA=this.checkTotalAnimation(t.TOTAL_RENDER_DATA)}this.result=t},itemSortFunction:function(t,i){if(!this.items.hasOwnProperty(t)||!this.items.hasOwnProperty(i)){return 0}return parseFloat(this.items[t].SORT)-parseFloat(this.items[i].SORT)},getChangedSimilarOffers:function(){var t=[];var i,e;var s=this.getHashMap();for(var a in s){if(s.hasOwnProperty(a)){if(s[a].length>1){for(var n=0;n<s[a].length;n++){i=0;e=0;for(var r=0;r<s[a].length;r++){if(s[a][r]!=s[a][n]){i+=parseFloat(this.items[s[a][r]].QUANTITY)}e+=parseFloat(this.items[s[a][r]].QUANTITY)}if(!this.items[s[a][n]].HAS_SIMILAR_ITEMS||this.items[s[a][n]].SIMILAR_ITEMS_QUANTITY!=i||this.items[s[a][n]].TOTAL_SIMILAR_ITEMS_QUANTITY!=e){t.push(s[a][n]);this.items[s[a][n]].HAS_SIMILAR_ITEMS=true;this.items[s[a][n]].SIMILAR_ITEMS_QUANTITY=i;this.items[s[a][n]].TOTAL_SIMILAR_ITEMS_QUANTITY=e;this.items[s[a][n]].ALL_AVAILABLE_QUANTITY=this.items[s[a][n]].AVAILABLE_QUANTITY;this.items[s[a][n]].AVAILABLE_QUANTITY=this.items[s[a][n]].ALL_AVAILABLE_QUANTITY-i}}}else if(s[a][0]&&this.items[s[a][0]].HAS_SIMILAR_ITEMS){t.push(s[a][0]);delete this.items[s[a][0]].HAS_SIMILAR_ITEMS;delete this.items[s[a][0]].SIMILAR_ITEMS_QUANTITY;delete this.items[s[a][0]].TOTAL_SIMILAR_ITEMS_QUANTITY;this.items[s[a][0]].AVAILABLE_QUANTITY=this.items[s[a][0]].ALL_AVAILABLE_QUANTITY;delete this.items[s[a][0]].ALL_AVAILABLE_QUANTITY}}}return t},getHashMap:function(){var t={};for(var i in this.items){if(this.items.hasOwnProperty(i)&&this.isItemAvailable(i)){if(!t.hasOwnProperty(this.items[i].HASH)){t[this.items[i].HASH]=[]}t[this.items[i].HASH].push(i)}}return t},isItemAvailable:function(t){var i=this.filter.isActive()?this.filter.realSortedItems:this.sortedItems;return!this.items[t].NOT_AVAILABLE&&!this.items[t].SHOW_RESTORE&&BX.util.in_array(t,i)},checkTotalAnimation:function(t){if(this.result&&this.result.TOTAL_RENDER_DATA&&parseFloat(this.result.TOTAL_RENDER_DATA.PRICE)>parseFloat(t.PRICE)){t.PRICE_NEW=t.PRICE;t.PRICE=this.result.TOTAL_RENDER_DATA.PRICE;t.PRICE_FORMATED_NEW=t.PRICE_FORMATED;t.PRICE_FORMATED=this.result.TOTAL_RENDER_DATA.PRICE_FORMATED;this.addPriceAnimationData(this.ids.total,t.PRICE,t.PRICE_NEW,t.CURRENCY)}return t},checkBasketItemsAnimation:function(t){var i=t.ID;if(this.items[i]){var e=BX(this.ids.quantity+i);if(BX.type.isDomNode(e)&&!this.actionPool.isItemInPool(i)&&parseFloat(e.value)!==parseFloat(t.QUANTITY)){t.QUANTITY_ANIMATION=true;this.actionPool.clearLastActualQuantityPool(i)}if(parseFloat(this.items[i].PRICE)>parseFloat(t.PRICE)){t.PRICE_NEW=t.PRICE;t.PRICE=this.items[i].PRICE;t.PRICE_FORMATED_NEW=t.PRICE_FORMATED;t.PRICE_FORMATED=this.items[i].PRICE_FORMATED;this.addPriceAnimationData(this.ids.price+i,t.PRICE,t.PRICE_NEW,t.CURRENCY)}if(BX.util.in_array("SUM",this.params.COLUMNS_LIST)&&parseFloat(this.items[i].SUM_PRICE)>parseFloat(t.SUM_PRICE)&&parseFloat(this.items[i].QUANTITY)===parseFloat(t.QUANTITY)){t.SUM_PRICE_NEW=t.SUM_PRICE;t.SUM_PRICE=this.items[i].SUM_PRICE;t.SUM_PRICE_FORMATED_NEW=t.SUM_PRICE_FORMATED;t.SUM_PRICE_FORMATED=this.items[i].SUM_PRICE_FORMATED;this.addPriceAnimationData(this.ids.sumPrice+i,t.SUM_PRICE,t.SUM_PRICE_NEW,t.CURRENCY)}}return t},getData:function(t){t=t||{};t[this.params.ACTION_VARIABLE]=this.lastAction;t.via_ajax="Y";t.site_id=this.siteId;t.site_template_id=this.siteTemplateId;t.sessid=BX.bitrix_sessid();t.template=this.template;t.signedParamsString=this.signedParamsString;return t},startLoader:function(){},endLoader:function(){},editWarnings:function(){this.editGeneralWarnings();this.editBasketItemWarnings();this.toggleWarningBlock();this.showWarningItemsCount()},editGeneralWarnings:function(){var t=this.getEntity(this.getCacheNode(this.ids.warning),"basket-general-warnings");if(BX.type.isDomNode(t)){var i=t.innerHTML;if(this.result.WARNING_MESSAGE_WITH_CODE){for(var e in this.result.WARNING_MESSAGE_WITH_CODE){if(this.result.WARNING_MESSAGE_WITH_CODE.hasOwnProperty(e)){if(!this.items[e]&&i.indexOf(this.result.WARNING_MESSAGE_WITH_CODE[e])===-1){i+=this.result.WARNING_MESSAGE_WITH_CODE[e]+"<br/>"}}}}if(i){t.innerHTML=i;t.style.display=""}else{t.style.display="none";t.innerHTML=""}}},editBasketItemWarnings:function(){var t=this.getEntity(this.getCacheNode(this.ids.warning),"basket-item-warnings");if(BX.type.isDomNode(t)){if(this.warningItems.length){var i=this.getEntity(t,"basket-items-warning-count");if(BX.type.isDomNode(i)){i.innerHTML=this.warningItems.length+" "+this.getGoodsMessage(this.warningItems.length)}t.style.display=""}else if(t.style.display!=="none"){t.style.display="none";if(this.filter.isActive()){this.toggleFilter("all")}}}},toggleWarningBlock:function(){var t=this.getCacheNode(this.ids.warning);if(BX.type.isDomNode(t)){var i=this.getEntity(t,"basket-general-warnings");var e=this.getEntity(t,"basket-item-warnings");if((!BX.type.isDomNode(i)||i.style.display==="none")&&(!BX.type.isDomNode(e)||e.style.display==="none")){t.style.display="none"}else{t.style.display=""}}},checkBasketItemWarnings:function(t,i){if(!t)return;var e;if(this.items[t.ID]&&this.lastAction==="refreshAjax"){e=this.items[t.ID].WARNINGS}else{e=[]}if(BX.type.isArray(i[t.ID])&&i[t.ID].length){for(var s in i[t.ID]){if(i[t.ID].hasOwnProperty(s)&&!BX.util.in_array(i[t.ID][s],e)){e.push(i[t.ID][s])}}}if(e.length){if(!BX.util.in_array(t.ID,this.warningItems)){this.warningItems.push(t.ID)}}else if(BX.util.in_array(t.ID,this.warningItems)){this.warningItems.splice(BX.util.array_search(t.ID,this.warningItems),1)}return e},removeAllWarnings:function(t){this.clearGeneralWarnings();this.clearBasketItemsWarnings();this.editWarnings();t&&t.preventDefault()},clearGeneralWarnings:function(){this.result.WARNING_MESSAGE_WITH_CODE={};var t=this.getEntity(this.getCacheNode(this.ids.warning),"basket-general-warnings");if(BX.type.isDomNode(t)){t.innerHTML=""}},clearBasketItemsWarnings:function(){var t=[];for(var i in this.warningItems){if(this.warningItems.hasOwnProperty(i)){this.items[this.warningItems[i]].WARNINGS=[];if(this.isItemShown(this.warningItems[i])){t.push(this.warningItems[i])}}}this.warningItems=[];this.editBasketItems(t)},isItemShown:function(t){return BX.util.in_array(t,this.shownItems)},initializeBasketItems:function(){if(Object.keys(this.items).length===0)return;for(var t=0;t<this.sortedItems.length;t++){if(this.useDynamicScroll&&this.shownItems.length>=this.maxItemsShowCount){break}this.createBasketItem(this.sortedItems[t])}},createBasketItem:function(t){if(!this.items[t]){return}var i=this.getTemplate("basket-item-template");if(i){var e=this.renderBasketItem(i,this.items[t]);var s=BX.util.array_search(t,this.sortedItems);if(this.shownItems.length&&s>=0){if(s<BX.util.array_search(this.shownItems[0],this.sortedItems)){BX(this.ids.item+this.shownItems[0]).insertAdjacentHTML("beforebegin",e);this.shownItems.unshift(t)}else if(s>BX.util.array_search(this.shownItems[this.shownItems.length-1],this.sortedItems)){BX(this.ids.item+this.shownItems[this.shownItems.length-1]).insertAdjacentHTML("afterend",e);this.shownItems.push(t)}else{BX(this.ids.item+this.sortedItems[s+1]).insertAdjacentHTML("beforebegin",e);this.shownItems.splice(s+1,0,t)}}else{this.getCacheNode(this.ids.itemListTable).insertAdjacentHTML("beforeend",e);this.shownItems.push(t)}this.bindBasketItemEvents(this.items[t]);if(this.filter.isActive()){this.filter.highlightSearchMatch(this.items[t])}}},getItemsToEdit:function(){var t=[];if(this.isBasketChanged()){for(var i in this.changedItems){if(this.changedItems.hasOwnProperty(i)&&this.isItemShown(this.changedItems[i])){t.push(this.changedItems[i])}}}return t},getItemsAfter:function(){var t=[];if(this.useDynamicScroll){var i=this.shownItems[this.shownItems.length-1]||false;if(i){var e=0;var s=BX.util.array_search(i,this.sortedItems);while(this.sortedItems[++s]&&e++<this.maxItemsShowCount){t.push(this.sortedItems[s])}}}return t},editBasketItems:function(t){if(!t||t.length===0){return}var i,e;for(i in t){if(!t.hasOwnProperty(i)||!BX.type.isPlainObject(this.items[t[i]])){continue}e=this.items[t[i]];if(this.actionPool.isItemInPool(e.ID)){if(!BX.util.in_array(e.ID,this.postponedItems)){this.postponedItems.push(e.ID)}continue}if(BX.type.isDomNode(BX(this.ids.item+e.ID))){this.redrawBasketItemNode(e.ID);this.applyQuantityAnimation(e.ID)}else{this.createBasketItem(e.ID)}}},editPostponedBasketItems:function(){if(!this.postponedItems.length)return;var t=[];for(var i in this.postponedItems){if(this.postponedItems.hasOwnProperty(i)&&this.isItemShown(this.postponedItems[i])){t.push(this.postponedItems[i])}}this.postponedItems=[];this.editBasketItems(t)},applyQuantityAnimation:function(t){var i=BX(this.ids.item+t);if(BX.type.isDomNode(i)&&this.items[t]){if(this.items[t].QUANTITY_ANIMATION){BX.addClass(BX(this.ids.quantity+t),"basket-updated")}}},applyPriceAnimation:function(){if(!this.priceAnimationData||Object.keys(this.priceAnimationData.start).length===0)return;var t=this.priceAnimationData,i={};new BX.easing({duration:this.params.USE_PRICE_ANIMATION==="Y"?this.duration.priceAnimation:1,start:t.start,finish:t.finish,transition:BX.easing.makeEaseOut(BX.easing.transitions.quad),step:BX.delegate(function(e){for(var s in t.start){if(t.start.hasOwnProperty(s)){if(!i[s]){if(s===this.ids.total){i[s]=this.getEntities(this.getCacheNode(this.ids.basketRoot),this.ids.total)}else{var a=BX(s);i[s]=a?[a]:[]}}if(!t.int[s]){e[s]=(e[s]+e[s]%1e3/1e3).toFixed(5)}for(var n=0;n<i[s].length;n++){i[s][n].innerHTML=this.getFormatPrice(e[s],t.currency[s])}}}},this),complete:BX.delegate(function(){var e,s,a,n;for(e in t.start){if(t.start.hasOwnProperty(e)){s=this.getFormatPrice(t.finish[e],t.currency[e]);for(var r=0;r<i[e].length;r++){i[e][r].innerHTML=s}if(e.indexOf(this.ids.sumPrice)!==-1){n="SUM_PRICE";a=e.substr(this.ids.sumPrice.length)}else if(e.indexOf(this.ids.price)!==-1){n="PRICE";a=e.substr(this.ids.price.length)}else if(e.indexOf(this.ids.total)!==-1){n="TOTAL";a=""}else{a="";n=""}if(BX.type.isNotEmptyString(n)){if(a){this.items[a][n]=t.finish[e];delete this.items[a][n+"_NEW"];this.items[a][n+"_FORMATED"]=s;delete this.items[a][n+"_FORMATED_NEW"]}else if(n==="TOTAL"){this.result.TOTAL_RENDER_DATA.PRICE=t.finish[e];delete this.result.TOTAL_RENDER_DATA.PRICE_NEW;this.result.TOTAL_RENDER_DATA.PRICE_FORMATED=s;delete this.result.TOTAL_RENDER_DATA.PRICE_FORMATED_NEW}}}}this.filter.highlightFoundItems()},this)}).animate()},getFormatPrice:function(t,i){return BX.Currency.currencyFormat(t,i,true)},deleteBasketItems:function(t,i,e){if(!t||!t.length){return}for(var s in t){if(t.hasOwnProperty(s)){this.deleteBasketItem(t[s],i,e)}}},deleteBasketItem:function(t,i,e){if(this.items[t].NOT_AVAILABLE&&i){i=false;e=true}if(i){this.items[t].SHOW_RESTORE=true;this.items[t].SHOW_LOADING=false;this.redrawBasketItemNode(t)}else{this.changeShownItem(t);BX.remove(BX(this.ids.item+t))}if(e){this.changeSortedItem(t,false,true);this.changeShownItem(t,false,true)}},addSortedItem:function(t,i){this.sortedItems.push(t.toString());if(i&&this.filter.isActive()){this.filter.realSortedItems.push(t.toString())}},changeSortedItem:function(t,i,e){var s=BX.util.array_search(t,this.sortedItems);if(s>=0){if(i){this.sortedItems.splice(s,1,i.toString())}else{this.sortedItems.splice(s,1)}}if(e&&this.filter.isActive()){s=BX.util.array_search(t,this.filter.realSortedItems);if(s>=0){if(i){this.filter.realSortedItems.splice(s,1,i.toString())}else{this.filter.realSortedItems.splice(s,1)}}}},sortSortedItems:function(t){this.sortedItems.sort(BX.proxy(this.itemSortFunction,this));if(t&&this.filter.isActive()){this.filter.realSortedItems.sort(BX.proxy(this.itemSortFunction,this))}},changeShownItem:function(t,i,e){var s=BX.util.array_search(t,this.shownItems);if(s>=0){if(i){this.shownItems.splice(s,1,i.toString())}else{this.shownItems.splice(s,1)}}if(e&&this.filter.isActive()){s=BX.util.array_search(t,this.filter.realShownItems);if(s>=0){if(i){this.filter.realShownItems.splice(s,1,i.toString())}else{this.filter.realShownItems.splice(s,1)}}}},redrawBasketItemNode:function(t){var i=BX(this.ids.item+t);if(!this.items[t]||!BX.type.isDomNode(i))return;var e=this.getTemplate("basket-item-template");if(e){var s=BX(this.ids.itemHeightAligner+t),a;if(BX.type.isDomNode(s)){a=s.clientHeight}var n=this.renderBasketItem(e,this.items[t]);i.insertAdjacentHTML("beforebegin",n);BX.remove(i);if(a){s=BX(this.ids.itemHeightAligner+t);if(BX.type.isDomNode(s)&&s.clientHeight<a){s.style.minHeight=a+"px";setTimeout(function(){s.style.minHeight="0px"},1)}}this.bindBasketItemEvents(this.items[t]);if(this.filter.isActive()){this.filter.highlightSearchMatch(this.items[t])}}},restoreBasketItems:function(t){if(!t||Object.keys(t).length===0){return}var i,e,s;for(i in t){if(t.hasOwnProperty(i)){e=t[i];if(this.isItemShown(i)){this.changeShownItem(i,e,true);s=BX(this.ids.item+i);if(BX.type.isDomNode(s)){s.id=this.ids.item+e;s.setAttribute("data-id",e)}}this.changeSortedItem(i,false,true)}}},bindBasketItemEvents:function(t){if(!t)return;var i=BX(this.ids.item+t.ID);if(BX.type.isDomNode(i)){this.bindQuantityEvents(i,t);this.bindSkuEvents(i,t);this.bindImageEvents(i,t);this.bindActionEvents(i,t);this.bindRestoreAction(i,t);this.bindItemWarningEvents(i,t)}},bindQuantityEvents:function(t,i){if(!t||!i||!this.isItemAvailable(i.ID))return;var e;var s=this.getEntity(t,"basket-item-quantity-block");if(s){var a=this.isTouch?"touchstart":"mousedown";var n=this.isTouch?"touchend":"mouseup";e=this.getEntity(s,"basket-item-quantity-minus");BX.bind(e,a,BX.proxy(this.startQuantityInterval,this));BX.bind(e,n,BX.proxy(this.clearQuantityInterval,this));BX.bind(e,"mouseout",BX.proxy(this.clearQuantityInterval,this));BX.bind(e,"click",BX.proxy(this.quantityMinus,this));e=this.getEntity(s,"basket-item-quantity-plus");BX.bind(e,a,BX.proxy(this.startQuantityInterval,this));BX.bind(e,n,BX.proxy(this.clearQuantityInterval,this));BX.bind(e,"mouseout",BX.proxy(this.clearQuantityInterval,this));BX.bind(e,"click",BX.proxy(this.quantityPlus,this));e=this.getEntity(s,"basket-item-quantity-field");BX.bind(e,"change",BX.proxy(this.quantityChange,this))}},startQuantityInterval:function(){var t=BX.proxy_context;var i=t.getAttribute("data-entity")==="basket-item-quantity-minus"?BX.proxy(this.quantityMinus,this):BX.proxy(this.quantityPlus,this);this.quantityDelay=setTimeout(BX.delegate(function(){this.quantityTimer=setInterval(function(){i(t)},150)},this),300)},clearQuantityInterval:function(){clearTimeout(this.quantityDelay);clearInterval(this.quantityTimer)},quantityPlus:function(t){if(!BX.type.isDomNode(t)){t=BX.proxy_context;this.clearQuantityInterval()}var i=this.getItemDataByTarget(t);if(i){var e=BX(this.ids.quantity+i.ID);var s=this.isQuantityFloat(i);var a=s?parseFloat(e.value):Math.round(e.value);var n=s?parseFloat(i.MEASURE_RATIO):parseInt(i.MEASURE_RATIO);var r=parseFloat((a+n).toFixed(5));r=this.getCorrectQuantity(i,r);this.setQuantity(i,r)}},quantityMinus:function(t){t=BX.type.isDomNode(t)?t:BX.proxy_context;var i=this.getItemDataByTarget(t);if(i){var e=BX(this.ids.quantity+i.ID);var s=this.isQuantityFloat(i);var a=s?parseFloat(e.value):Math.round(e.value);var n=s?parseFloat(i.MEASURE_RATIO):parseInt(i.MEASURE_RATIO);var r=parseFloat((a-n).toFixed(5));r=this.getCorrectQuantity(i,r);this.setQuantity(i,r)}},quantityChange:function(){var t=this.getItemDataByTarget(BX.proxy_context);if(t){var i,e;i=BX(this.ids.quantity+t.ID);e=this.getCorrectQuantity(t,i.value);this.setQuantity(t,e)}},isQuantityFloat:function(t){return this.params.QUANTITY_FLOAT==="Y"||parseInt(t.MEASURE_RATIO)!==parseFloat(t.MEASURE_RATIO)},getCorrectQuantity:function(t,i){var e=this.isQuantityFloat(t),s=e?parseFloat(t.MEASURE_RATIO):parseInt(t.MEASURE_RATIO),a=0;i=(e?parseFloat(i):parseInt(i,10))||0;if(i<0){i=0}if(s>0&&i<s){i=s}if(t.CHECK_MAX_QUANTITY==="Y"){a=e?parseFloat(t.AVAILABLE_QUANTITY):parseInt(t.AVAILABLE_QUANTITY);if(a>0&&i>a){i=a}}var n=(i/s-(i/s).toFixed(0)).toFixed(5),r;if(parseFloat(n)===0){return i}if(s!==0&&s!==1){r=i*this.precisionFactor%(s*this.precisionFactor)/this.precisionFactor;if(s>0&&r>0){if(r>=s/2&&(a===0||i+s-r<=a)){i+=s-r}else{i-=r}}}i=e?parseFloat(i):parseInt(i,10);return i},setQuantity:function(t,i){var e=BX(this.ids.quantity+t.ID),s;if(e){i=parseFloat(i);s=parseFloat(e.getAttribute("data-value"));e.value=i;if(parseFloat(t.QUANTITY)!==parseFloat(i)){this.animatePriceByQuantity(t,i);this.actionPool.changeQuantity(t.ID,i,s)}}},animatePriceByQuantity:function(t,i){var e=BX(this.ids.sumPrice+t.ID);if(!BX.type.isDomNode(e))return;var s=i/parseFloat(t.MEASURE_RATIO);var a=parseFloat(t.SUM_PRICE),n=parseFloat(t.PRICE)*s,r=parseInt(a)===parseFloat(a)&&parseInt(n)===parseFloat(n);if(a!==n){this.items[t.ID].QUANTITY=i;this.items[t.ID].SUM_PRICE=n;new BX.easing({duration:this.params.USE_PRICE_ANIMATION==="Y"?this.duration.priceAnimation:1,start:{price:a},finish:{price:n},transition:BX.easing.makeEaseOut(BX.easing.transitions.quad),step:BX.delegate(function(i){if(!r){i.price=(i.price+i.price%1e3/1e3).toFixed(5)}e.innerHTML=this.getFormatPrice(i.price,t.CURRENCY)},this),complete:BX.delegate(function(){var i,a;e.innerHTML=this.getFormatPrice(n,t.CURRENCY);i=BX(this.ids.sumPriceOld+t.ID);if(BX.type.isDomNode(i)){a=parseFloat(t.FULL_PRICE)*s;i.innerHTML=this.getFormatPrice(a,t.CURRENCY)}i=BX(this.ids.sumPriceDiff+t.ID);if(BX.type.isDomNode(i)){a=parseFloat(t.DISCOUNT_PRICE)*s;i.innerHTML=this.getFormatPrice(a,t.CURRENCY)}},this)}).animate()}},getItemDataByTarget:function(t){var i=false;var e;var s=BX.findParent(t,{attrs:{"data-entity":"basket-item"}});if(s){e=s.getAttribute("data-id");i=this.items[e]}return i},bindSkuEvents:function(t,i){if(!t||!i)return;var e=this.getEntities(t,"basket-item-sku-block");var s,a,n,r,o;for(a=0,n=e.length;a<n;a++){s=this.getEntities(e[a],"basket-item-sku-field");for(r=0,o=s.length;r<o;r++){BX.bind(s[r],"click",BX.proxy(this.changeSku,this))}}},changeSku:function(){var t,i;var e=BX.proxy_context;if(BX.hasClass(e,"selected"))return;var s=this.getItemDataByTarget(e);if(s){var a=BX(this.ids.item+s.ID);if(a){var n=this.getEntities(e.parentNode,"basket-item-sku-field");for(t=0,i=n.length;t<i;t++){if(n[t].isEqualNode(e)){BX.addClass(n[t],"selected")}else{BX.removeClass(n[t],"selected")}}this.actionPool.changeSku(s.ID,this.getSkuPropertyValues(a),this.getInitialSkuPropertyValues(a))}}},getSkuPropertyValues:function(t){var i={};var e=this.getEntities(t,"basket-item-sku-field",".selected");for(var s=0,a=e.length;s<a;s++){i[e[s].getAttribute("data-property")]=BX.util.htmlspecialcharsback(e[s].getAttribute("data-value-id"))}return i},getInitialSkuPropertyValues:function(t){var i={};var e=this.getEntities(t,"basket-item-sku-field",'[data-initial="true"]');for(var s=0,a=e.length;s<a;s++){i[e[s].getAttribute("data-property")]=BX.util.htmlspecialcharsback(e[s].getAttribute("data-value-id"))}return i},bindImageEvents:function(t,i){if(!t||!i)return;var e=t.querySelectorAll(".basket-item-custom-block-photo-item");for(var s=0,a=e.length;s<a;s++){BX.bind(e[s],"click",BX.proxy(this.showPropertyImagePopup,this))}},showPropertyImagePopup:function(){var t,i,e,s,a,n;t=BX.proxy_context;s=this.getItemDataByTarget(t);i=t.getAttribute("data-column-property-code");e=t.getAttribute("data-image-index");if(s&&s.COLUMN_LIST){for(n in s.COLUMN_LIST){if(s.COLUMN_LIST.hasOwnProperty(n)&&s.COLUMN_LIST[n].CODE===i&&s.COLUMN_LIST[n].VALUE[e]){a=s.COLUMN_LIST[n].VALUE[e].IMAGE_SRC_ORIGINAL;break}}}if(!a){return}if(this.imagePopup){this.imagePopup.destroy()}var r="bx-soa-image-popup-content";var o=this;this.imagePopup=new BX.PopupWindow("bx-soa-image-popup",null,{lightShadow:true,offsetTop:0,offsetLeft:0,closeIcon:{top:"3px",right:"10px"},autoHide:true,bindOptions:{position:"bottom"},closeByEsc:true,zIndex:100,events:{onPopupShow:function(){BX.create("IMG",{props:{src:a},events:{load:function(){var t=BX(r);if(t){var i=BX.GetWindowInnerSize(),e=o.isMobile?.5:.9,s,a;BX.cleanNode(t);t.appendChild(this);s=t.offsetHeight;a=t.offsetWidth;if(s>i.innerHeight*e){t.style.height=i.innerHeight*e+"px";t.style.width=a*(i.innerHeight*e/s)+"px";s=t.offsetHeight;a=t.offsetWidth}if(a>i.innerWidth*e){t.style.width=i.innerWidth*e+"px";t.style.height=s*(i.innerWidth*e/a)+"px"}t.style.height=t.offsetHeight+"px";t.style.width=t.offsetWidth+"px";o.imagePopup.adjustPosition()}}}})},onPopupClose:function(){this.destroy()}},content:BX.create("DIV",{props:{id:r}})});this.imagePopup.show()},bindActionEvents:function(t,i){if(!t||!i)return;var e;if(BX.util.in_array("DELETE",this.params.COLUMNS_LIST)){e=this.getEntities(t,"basket-item-delete");for(var s=0,a=e.length;s<a;s++){BX.bind(e[s],"click",BX.proxy(this.deleteAction,this))}}if(BX.util.in_array("DELAY",this.params.COLUMNS_LIST)){e=this.getEntity(t,"basket-item-add-delayed");BX.bind(e,"click",BX.proxy(this.addDelayedAction,this))}e=this.getEntity(t,"basket-item-remove-delayed");BX.bind(e,"click",BX.proxy(this.removeDelayedAction,this));e=this.getEntity(t,"basket-item-merge-sku-link");BX.bind(e,"click",BX.proxy(this.mergeAction,this));e=this.getEntity(t,"basket-item-show-similar-link");BX.bind(e,"click",BX.delegate(function(){this.toggleFilter("similar")},this))},deleteAction:function(){var t=this.getItemDataByTarget(BX.proxy_context);if(t){this.actionPool.deleteItem(t.ID);this.items[t.ID].SHOW_LOADING=true;if(this.params.SHOW_RESTORE==="Y"&&this.isItemAvailable(t.ID)){this.items[t.ID].SHOW_RESTORE=true}this.redrawBasketItemNode(t.ID)}},addDelayedAction:function(){var t=this.getItemDataByTarget(BX.proxy_context);if(t){this.actionPool.addDelayed(t.ID);this.items[t.ID].SHOW_LOADING=true;this.redrawBasketItemNode(t.ID)}},removeDelayedAction:function(){var t=this.getItemDataByTarget(BX.proxy_context);if(t){this.actionPool.removeDelayed(t.ID);this.items[t.ID].SHOW_LOADING=true;this.redrawBasketItemNode(t.ID)}},mergeAction:function(){var t=this.getItemDataByTarget(BX.proxy_context);if(t){this.actionPool.mergeSku(t.ID)}},bindRestoreAction:function(t,i){if(!t||!i||this.params.SHOW_RESTORE!=="Y")return;BX.bind(this.getEntity(t,"basket-item-restore-button"),"click",BX.delegate(function(){this.actionPool.restoreItem(i.ID,{PRODUCT_ID:i.PRODUCT_ID,QUANTITY:i.QUANTITY,PROPS:i.PROPS_ALL,SORT:i.SORT,MODULE:i.MODULE,PRODUCT_PROVIDER_CLASS:i.PRODUCT_PROVIDER_CLASS});this.items[i.ID].SHOW_RESTORE=false;this.items[i.ID].SHOW_LOADING=true;this.redrawBasketItemNode(i.ID)},this));BX.bind(this.getEntity(t,"basket-item-close-restore-button"),"click",BX.delegate(function(){this.deleteBasketItem(i.ID,false,true)},this))},bindItemWarningEvents:function(t,i){if(!t||!i)return;BX.bind(this.getEntity(BX(this.ids.item+i.ID),"basket-item-warning-close"),"click",BX.proxy(this.closeItemWarnings,this))},closeItemWarnings:function(){var t=BX.proxy_context;if(BX.type.isDomNode(t)){var i=this.getItemDataByTarget(t);this.items[i.ID].WARNINGS=[];this.warningItems.splice(BX.util.array_search(i.ID,this.warningItems),1);this.redrawBasketItemNode(i.ID);this.editWarnings()}},renderBasketItem:function(t,i){var e=BX.clone(i);if(BX.type.isPlainObject(e)){e.USE_FILTER=this.useItemsFilter&&!this.filter.currentFilter.similarHash.length}return Mustache.render(t,e)},render:function(t,i){return Mustache.render(t,i)},checkAnalytics:function(t){if(!t||!t.basket)return;var i,e={};for(var s in t.basket){if(t.basket.hasOwnProperty(s)){if(s.indexOf("QUANTITY_")>=0){i=s.substr(9);if(this.items[i]){e[i]=parseFloat(t.basket[s])-parseFloat(BX(this.ids.quantity+i).getAttribute("data-value"))}}else if(s.indexOf("DELETE_")>=0){i=s.substr(7);if(this.items[i]){e[i]=-parseFloat(this.items[i].QUANTITY)}}else if(s.indexOf("RESTORE_")>=0){i=s.substr(8);if(this.items[i]){e[i]=parseFloat(this.items[i].QUANTITY)}}}}this.setAnalyticsDataLayer(e)},setAnalyticsDataLayer:function(t){if(!t||Object.keys(t).length===0)return;window[this.params.DATA_LAYER_NAME]=window[this.params.DATA_LAYER_NAME]||[];var i=[],e=[];for(var s in t){if(t.hasOwnProperty(s)){if(t[s]>0){i.push(this.getItemAnalyticsInfo(s,t[s]))}else if(t[s]<0){e.push(this.getItemAnalyticsInfo(s,t[s]))}}}if(i.length){window[this.params.DATA_LAYER_NAME].push({event:"addToCart",ecommerce:{currencyCode:this.items[s].CURRENCY||"",add:{products:i}}})}if(e.length){window[this.params.DATA_LAYER_NAME].push({event:"removeFromCart",ecommerce:{currencyCode:this.items[s].CURRENCY||"",remove:{products:e}}})}},getItemAnalyticsInfo:function(t,i){if(!this.items[t])return{};var e=(this.items[t].BRAND||"").split(",  ").join("/");var s=[];var a=this.getEntities(BX(this.ids.item+t),"basket-item-sku-field",".selected");for(var n=0,r=a.length;n<r;n++){s.push(a[n].getAttribute("data-sku-name"))}return{name:this.items[t].NAME||"",id:this.items[t].PRODUCT_ID||"",price:this.items[t].PRICE||0,brand:e,variant:s.join("/"),quantity:Math.abs(i)}}}})();
//# sourceMappingURL=component.map.js