
CREATE TABLE b_sale_auxiliary (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  ITEM varchar(255) NOT NULL,
  ITEM_MD5 varchar(32) NOT NULL,
  USER_ID int NOT NULL,
  DATE_INSERT timestamp NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sale_auxiliary_user_id_item_md5 ON b_sale_auxiliary (user_id, item_md5);

CREATE TABLE b_sale_lang (
  LID char(2) NOT NULL,
  CURRENCY char(3) NOT NULL,
  PRIMARY KEY (LID)
);

CREATE TABLE b_sale_fuser (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_INSERT timestamp NOT NULL,
  DATE_UPDATE timestamp NOT NULL,
  USER_ID int,
  CODE varchar(32),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_fuser_user_id ON b_sale_fuser (user_id);
CREATE INDEX ix_b_sale_fuser_code ON b_sale_fuser (code);

CREATE TABLE b_sale_basket (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  FUSER_ID int NOT NULL,
  ORDER_ID int,
  PRODUCT_ID int NOT NULL,
  PRODUCT_PRICE_ID int,
  PRICE_TYPE_ID int,
  PRICE decimal NOT NULL,
  CURRENCY char(3) NOT NULL,
  BASE_PRICE decimal,
  VAT_INCLUDED char(1) NOT NULL DEFAULT 'Y',
  DATE_INSERT timestamp NOT NULL,
  DATE_UPDATE timestamp NOT NULL,
  DATE_REFRESH timestamp,
  WEIGHT double precision,
  QUANTITY double precision NOT NULL DEFAULT '0',
  LID char(2) NOT NULL,
  DELAY char(1) NOT NULL DEFAULT 'N',
  NAME varchar(255) NOT NULL,
  CAN_BUY char(1) NOT NULL DEFAULT 'Y',
  MARKING_CODE_GROUP varchar(100),
  MODULE varchar(100),
  CALLBACK_FUNC varchar(100),
  NOTES varchar(250),
  ORDER_CALLBACK_FUNC varchar(100),
  DETAIL_PAGE_URL varchar(250),
  DISCOUNT_PRICE decimal NOT NULL,
  CANCEL_CALLBACK_FUNC varchar(100),
  PAY_CALLBACK_FUNC varchar(100),
  PRODUCT_PROVIDER_CLASS varchar(100),
  CATALOG_XML_ID varchar(100),
  PRODUCT_XML_ID varchar(100),
  DISCOUNT_NAME varchar(255),
  DISCOUNT_VALUE char(32),
  DISCOUNT_COUPON char(32),
  VAT_RATE decimal DEFAULT '0.00',
  SUBSCRIBE char(1) NOT NULL DEFAULT 'N',
  DEDUCTED char(1) NOT NULL DEFAULT 'N',
  RESERVED char(1) NOT NULL DEFAULT 'N',
  BARCODE_MULTI char(1) NOT NULL DEFAULT 'N',
  RESERVE_QUANTITY double precision,
  CUSTOM_PRICE char(1) NOT NULL DEFAULT 'N',
  DIMENSIONS varchar(255),
  TYPE int,
  SET_PARENT_ID int,
  MEASURE_CODE int,
  MEASURE_NAME varchar(50),
  RECOMMENDATION varchar(40),
  XML_ID varchar(255),
  SORT int NOT NULL DEFAULT '100',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_basket_lid ON b_sale_basket (lid);
CREATE INDEX ix_b_sale_basket_fuser_id_lid_order_id ON b_sale_basket (fuser_id, lid, order_id);
CREATE INDEX ix_b_sale_basket_order_id ON b_sale_basket (order_id);
CREATE INDEX ix_b_sale_basket_product_id ON b_sale_basket (product_id);
CREATE INDEX ix_b_sale_basket_product_price_id ON b_sale_basket (product_price_id);
CREATE INDEX ix_b_sale_basket_product_xml_id_catalog_xml_id ON b_sale_basket (product_xml_id, catalog_xml_id);
CREATE INDEX ix_b_sale_basket_date_insert ON b_sale_basket (date_insert);
CREATE INDEX ix_b_sale_basket_set_parent_id ON b_sale_basket (set_parent_id);

CREATE TABLE b_sale_basket_props (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  BASKET_ID int NOT NULL,
  NAME varchar(255) NOT NULL,
  VALUE varchar(255),
  CODE varchar(255),
  SORT int NOT NULL DEFAULT '100',
  XML_ID varchar(255),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_basket_props_basket_id ON b_sale_basket_props (basket_id);
CREATE INDEX ix_b_sale_basket_props_code ON b_sale_basket_props (code);

CREATE TABLE b_sale_order (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  LID char(2) NOT NULL,
  PERSON_TYPE_ID int NOT NULL,
  PAYED char(1) NOT NULL DEFAULT 'N',
  DATE_PAYED timestamp,
  EMP_PAYED_ID int,
  CANCELED char(1) NOT NULL DEFAULT 'N',
  DATE_CANCELED timestamp,
  EMP_CANCELED_ID int,
  REASON_CANCELED varchar(255),
  STATUS_ID varchar(2) NOT NULL,
  DATE_STATUS timestamp NOT NULL,
  EMP_STATUS_ID int,
  PRICE_DELIVERY decimal NOT NULL DEFAULT '0.0000',
  PRICE_PAYMENT decimal NOT NULL DEFAULT '0.0000',
  ALLOW_DELIVERY char(1) NOT NULL DEFAULT 'N',
  DATE_ALLOW_DELIVERY timestamp,
  EMP_ALLOW_DELIVERY_ID int,
  DEDUCTED char(1) NOT NULL DEFAULT 'N',
  DATE_DEDUCTED timestamp,
  EMP_DEDUCTED_ID int,
  REASON_UNDO_DEDUCTED varchar(255),
  MARKED char(1) NOT NULL DEFAULT 'N',
  DATE_MARKED timestamp,
  EMP_MARKED_ID int,
  REASON_MARKED varchar(255),
  RESERVED char(1) NOT NULL DEFAULT 'N',
  PRICE decimal NOT NULL,
  CURRENCY char(3) NOT NULL,
  DISCOUNT_VALUE decimal NOT NULL DEFAULT '0.0000',
  USER_ID int NOT NULL,
  PAY_SYSTEM_ID int,
  DELIVERY_ID varchar(50),
  DATE_INSERT timestamp NOT NULL,
  DATE_UPDATE timestamp NOT NULL,
  USER_DESCRIPTION varchar(2000),
  ADDITIONAL_INFO varchar(255),
  PS_STATUS char(1),
  PS_STATUS_CODE char(5),
  PS_STATUS_DESCRIPTION varchar(250),
  PS_STATUS_MESSAGE varchar(250),
  PS_SUM decimal,
  PS_CURRENCY char(3),
  PS_RESPONSE_DATE timestamp,
  COMMENTS text,
  TAX_VALUE decimal NOT NULL DEFAULT '0.00',
  STAT_GID varchar(255),
  SUM_PAID decimal NOT NULL DEFAULT '0',
  IS_RECURRING char(1) NOT NULL DEFAULT 'N',
  RECURRING_ID int,
  PAY_VOUCHER_NUM varchar(20),
  PAY_VOUCHER_DATE date,
  LOCKED_BY int,
  DATE_LOCK timestamp,
  RECOUNT_FLAG char(1) NOT NULL DEFAULT 'Y',
  AFFILIATE_ID int,
  DELIVERY_DOC_NUM varchar(20),
  DELIVERY_DOC_DATE date,
  UPDATED_1C char(1) NOT NULL DEFAULT 'N',
  STORE_ID int,
  ORDER_TOPIC varchar(255),
  CREATED_BY int,
  RESPONSIBLE_ID int,
  COMPANY_ID int,
  DATE_PAY_BEFORE timestamp,
  DATE_BILL timestamp,
  ACCOUNT_NUMBER varchar(100),
  TRACKING_NUMBER varchar(255),
  XML_ID varchar(255),
  ID_1C varchar(36),
  VERSION_1C varchar(15),
  VERSION int NOT NULL DEFAULT '0',
  EXTERNAL_ORDER char(1) NOT NULL DEFAULT 'N',
  RUNNING char(1) NOT NULL DEFAULT 'N',
  BX_USER_ID varchar(32),
  SEARCH_CONTENT text,
  IS_SYNC_B24 char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_order_person_type_id ON b_sale_order (person_type_id);
CREATE INDEX ix_b_sale_order_status_id ON b_sale_order (status_id);
CREATE INDEX ix_b_sale_order_recurring_id ON b_sale_order (recurring_id);
CREATE INDEX ix_b_sale_order_affiliate_id ON b_sale_order (affiliate_id);
CREATE INDEX ix_b_sale_order_updated_1c ON b_sale_order (updated_1c);
CREATE INDEX ix_b_sale_order_user_id_lid_payed_canceled ON b_sale_order (user_id, lid, payed, canceled);
CREATE INDEX ix_b_sale_order_date_update ON b_sale_order (date_update);
CREATE INDEX ix_b_sale_order_xml_id ON b_sale_order (xml_id);
CREATE INDEX ix_b_sale_order_id_1c ON b_sale_order (id_1c);
CREATE INDEX ix_b_sale_order_date_allow_delivery ON b_sale_order (date_allow_delivery);
CREATE INDEX ix_b_sale_order_allow_delivery ON b_sale_order (allow_delivery);
CREATE INDEX ix_b_sale_order_date_canceled ON b_sale_order (date_canceled);
CREATE INDEX ix_b_sale_order_canceled ON b_sale_order (canceled);
CREATE INDEX ix_b_sale_order_date_payed ON b_sale_order (date_payed);
CREATE INDEX ix_b_sale_order_date_insert ON b_sale_order (date_insert);
CREATE INDEX ix_b_sale_order_date_pay_before ON b_sale_order (date_pay_before);
CREATE UNIQUE INDEX ux_b_sale_order_account_number ON b_sale_order (account_number);
CREATE INDEX tx_b_sale_order_search_content ON b_sale_order USING GIN (to_tsvector('english', search_content));

CREATE TABLE b_sale_person_type (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  LID char(2) NOT NULL,
  NAME varchar(255) NOT NULL,
  CODE varchar(255),
  SORT int NOT NULL DEFAULT '150',
  ACTIVE varchar(1) NOT NULL DEFAULT 'Y',
  ENTITY_REGISTRY_TYPE varchar(255),
  XML_ID varchar(255),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_person_type_lid ON b_sale_person_type (lid);

CREATE TABLE b_sale_order_props_group (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  PERSON_TYPE_ID int NOT NULL,
  NAME varchar(255) NOT NULL,
  CODE varchar(50) DEFAULT null,
  SORT int NOT NULL DEFAULT '100',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_order_props_group_person_type_id ON b_sale_order_props_group (person_type_id);

CREATE TABLE b_sale_order_props (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  PERSON_TYPE_ID int NOT NULL,
  NAME varchar(255) NOT NULL,
  TYPE varchar(20) NOT NULL,
  REQUIRED char(1) NOT NULL DEFAULT 'N',
  DEFAULT_VALUE varchar(500),
  SORT int NOT NULL DEFAULT '100',
  USER_PROPS char(1) NOT NULL DEFAULT 'N',
  IS_LOCATION char(1) NOT NULL DEFAULT 'N',
  PROPS_GROUP_ID int NOT NULL,
  DESCRIPTION varchar(255),
  IS_EMAIL char(1) NOT NULL DEFAULT 'N',
  IS_PROFILE_NAME char(1) NOT NULL DEFAULT 'N',
  IS_PAYER char(1) NOT NULL DEFAULT 'N',
  IS_LOCATION4TAX char(1) NOT NULL DEFAULT 'N',
  IS_FILTERED char(1) NOT NULL DEFAULT 'N',
  CODE varchar(50),
  IS_ZIP char(1) NOT NULL DEFAULT 'N',
  IS_PHONE char(1) NOT NULL DEFAULT 'N',
  ACTIVE varchar(1) NOT NULL DEFAULT 'Y',
  UTIL varchar(1) NOT NULL DEFAULT 'N',
  INPUT_FIELD_LOCATION int NOT NULL DEFAULT '0',
  MULTIPLE char(1) NOT NULL DEFAULT 'N',
  IS_ADDRESS char(1) NOT NULL DEFAULT 'N',
  IS_ADDRESS_FROM char(1) NOT NULL DEFAULT 'N',
  IS_ADDRESS_TO char(1) NOT NULL DEFAULT 'N',
  SETTINGS varchar(500),
  ENTITY_REGISTRY_TYPE varchar(255),
  XML_ID varchar(255),
  ENTITY_TYPE varchar(255) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_order_props_person_type_id ON b_sale_order_props (person_type_id);
CREATE INDEX ix_b_sale_order_props_type ON b_sale_order_props (type);
CREATE INDEX ix_b_sale_order_props_code ON b_sale_order_props (code);

CREATE TABLE b_sale_order_props_value (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ORDER_ID int NOT NULL,
  ORDER_PROPS_ID int,
  NAME varchar(255) NOT NULL,
  VALUE varchar(500),
  CODE varchar(50),
  XML_ID varchar(255),
  ENTITY_ID int NOT NULL,
  ENTITY_TYPE varchar(255) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sale_order_props_value_entity_id_entity_type_order_props_i ON b_sale_order_props_value (entity_id, entity_type, order_props_id);
CREATE INDEX ix_b_sale_order_props_value_order_id_order_props_id ON b_sale_order_props_value (order_id, order_props_id);

CREATE TABLE b_sale_order_props_variant (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ORDER_PROPS_ID int NOT NULL,
  NAME varchar(255) NOT NULL,
  VALUE varchar(255),
  SORT int NOT NULL DEFAULT '100',
  DESCRIPTION varchar(255),
  XML_ID varchar(255),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_order_props_variant_order_props_id ON b_sale_order_props_variant (order_props_id);

CREATE TABLE b_sale_order_props_relation (
  PROPERTY_ID int NOT NULL,
  ENTITY_ID varchar(35) NOT NULL,
  ENTITY_TYPE char(1) NOT NULL,
  PRIMARY KEY (PROPERTY_ID, ENTITY_ID, ENTITY_TYPE)
);

CREATE TABLE b_sale_pay_system_action (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  PAY_SYSTEM_ID int,
  PERSON_TYPE_ID int,
  NAME varchar(255) NOT NULL,
  PSA_NAME varchar(255) NOT NULL,
  CODE varchar(50),
  SORT int NOT NULL DEFAULT '100',
  DESCRIPTION varchar(2000),
  ACTION_FILE varchar(255),
  RESULT_FILE varchar(255),
  NEW_WINDOW char(1) NOT NULL DEFAULT 'Y',
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  PS_MODE varchar(20),
  PS_CLIENT_TYPE varchar(10) DEFAULT null,
  PARAMS text,
  TARIF text,
  HAVE_PAYMENT char(1) NOT NULL DEFAULT 'N',
  HAVE_ACTION char(1) NOT NULL DEFAULT 'N',
  AUTO_CHANGE_1C char(1) NOT NULL DEFAULT 'N',
  HAVE_RESULT char(1) NOT NULL DEFAULT 'N',
  HAVE_PRICE char(1) NOT NULL DEFAULT 'N',
  HAVE_PREPAY char(1) NOT NULL DEFAULT 'N',
  HAVE_RESULT_RECEIVE char(1) NOT NULL DEFAULT 'N',
  ALLOW_EDIT_PAYMENT char(1) NOT NULL DEFAULT 'Y',
  ENCODING varchar(45),
  LOGOTIP int,
  IS_CASH char(1) NOT NULL DEFAULT 'N',
  CAN_PRINT_CHECK char(1) NOT NULL DEFAULT 'N',
  ENTITY_REGISTRY_TYPE varchar(255),
  XML_ID varchar(255),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_pay_system_action_ps_client_type ON b_sale_pay_system_action (ps_client_type);

CREATE TABLE b_sale_pay_system_rest_handlers (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  NAME varchar(255) NOT NULL,
  CODE varchar(50),
  SORT int NOT NULL DEFAULT '100',
  SETTINGS text,
  APP_ID varchar(128),
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sale_pay_system_rest_handlers_code ON b_sale_pay_system_rest_handlers (code);

CREATE TABLE b_sale_location_country (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  NAME varchar(100) NOT NULL,
  SHORT_NAME varchar(100),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_location_country_name ON b_sale_location_country (name);

CREATE TABLE b_sale_location_country_lang (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  COUNTRY_ID int NOT NULL,
  LID char(2) NOT NULL,
  NAME varchar(100) NOT NULL,
  SHORT_NAME varchar(100),
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sale_location_country_lang_country_id_lid ON b_sale_location_country_lang (country_id, lid);

CREATE TABLE b_sale_location_region (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  NAME varchar(255) NOT NULL,
  SHORT_NAME varchar(100),
  PRIMARY KEY (ID)
);

CREATE TABLE b_sale_location_region_lang (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  REGION_ID int NOT NULL,
  LID char(2) NOT NULL,
  NAME varchar(100) NOT NULL,
  SHORT_NAME varchar(100),
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sale_location_region_lang_region_id_lid ON b_sale_location_region_lang (region_id, lid);
CREATE INDEX ix_b_sale_location_region_lang_name ON b_sale_location_region_lang (name);

CREATE TABLE b_sale_location_city (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  NAME varchar(100) NOT NULL,
  SHORT_NAME varchar(100),
  REGION_ID int,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_location_city_region_id ON b_sale_location_city (region_id);

CREATE TABLE b_sale_location_city_lang (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CITY_ID int NOT NULL,
  LID char(2) NOT NULL,
  NAME varchar(100) NOT NULL,
  SHORT_NAME varchar(100),
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sale_location_city_lang_city_id_lid ON b_sale_location_city_lang (city_id, lid);
CREATE INDEX ix_b_sale_location_city_lang_name ON b_sale_location_city_lang (name);

CREATE TABLE b_sale_location_zip (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  LOCATION_ID int NOT NULL DEFAULT '0',
  ZIP varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_location_zip_location_id ON b_sale_location_zip (location_id);
CREATE INDEX ix_b_sale_location_zip_zip ON b_sale_location_zip (zip);

CREATE TABLE b_sale_location (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  SORT int NOT NULL DEFAULT '100',
  CODE varchar(100) NOT NULL,
  LEFT_MARGIN int,
  RIGHT_MARGIN int,
  PARENT_ID int DEFAULT '0',
  DEPTH_LEVEL int DEFAULT '1',
  TYPE_ID int,
  LATITUDE decimal,
  LONGITUDE decimal,
  COUNTRY_ID int,
  REGION_ID int,
  CITY_ID int,
  LOC_DEFAULT char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sale_location_code ON b_sale_location (code);
CREATE INDEX ix_b_sale_location_left_margin_right_margin ON b_sale_location (left_margin, right_margin);
CREATE INDEX ix_b_sale_location_right_margin_left_margin ON b_sale_location (right_margin, left_margin);
CREATE INDEX ix_b_sale_location_parent_id ON b_sale_location (parent_id);
CREATE INDEX ix_b_sale_location_depth_level ON b_sale_location (depth_level);
CREATE INDEX ix_b_sale_location_type_id ON b_sale_location (type_id);
CREATE INDEX ix_b_sale_location_country_id ON b_sale_location (country_id);
CREATE INDEX ix_b_sale_location_region_id ON b_sale_location (region_id);
CREATE INDEX ix_b_sale_location_city_id ON b_sale_location (city_id);
CREATE INDEX ix_b_sale_location_sort ON b_sale_location (sort);
CREATE INDEX ix_b_sale_location_type_id_left_margin_right_margin ON b_sale_location (type_id, left_margin, right_margin);

CREATE TABLE b_sale_loc_name (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  LANGUAGE_ID char(2) NOT NULL,
  LOCATION_ID int NOT NULL,
  NAME varchar(100) NOT NULL,
  NAME_UPPER varchar(100) NOT NULL,
  NAME_NORM varchar(100),
  SHORT_NAME varchar(100),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_loc_name_name_upper ON b_sale_loc_name (name_upper);
CREATE INDEX ix_b_sale_loc_name_name_norm ON b_sale_loc_name (name_norm);
CREATE INDEX ix_b_sale_loc_name_location_id_language_id ON b_sale_loc_name (location_id, language_id);

CREATE TABLE b_sale_loc_ext_srv (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CODE varchar(100) NOT NULL,
  PRIMARY KEY (ID)
);

CREATE TABLE b_sale_loc_ext (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  SERVICE_ID int NOT NULL,
  LOCATION_ID int NOT NULL,
  XML_ID varchar(100) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_loc_ext_location_id_service_id ON b_sale_loc_ext (location_id, service_id);
CREATE INDEX ix_b_sale_loc_ext_xml_id_service_id ON b_sale_loc_ext (xml_id, service_id);

CREATE TABLE b_sale_loc_type (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CODE varchar(30) NOT NULL,
  SORT int DEFAULT '100',
  DISPLAY_SORT int DEFAULT '100',
  PRIMARY KEY (ID)
);

CREATE TABLE b_sale_loc_type_name (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  LANGUAGE_ID char(2) NOT NULL,
  NAME varchar(100) NOT NULL,
  TYPE_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_loc_type_name_type_id_language_id ON b_sale_loc_type_name (type_id, language_id);

CREATE TABLE b_sale_loc_2site (
  LOCATION_ID int NOT NULL,
  SITE_ID char(2) NOT NULL,
  LOCATION_TYPE char(1) NOT NULL DEFAULT 'L',
  PRIMARY KEY (SITE_ID, LOCATION_ID, LOCATION_TYPE)
);

CREATE TABLE b_sale_loc_def2site (
  LOCATION_CODE varchar(100) NOT NULL,
  SITE_ID char(2) NOT NULL,
  SORT int DEFAULT '100',
  PRIMARY KEY (LOCATION_CODE, SITE_ID)
);

CREATE TABLE b_sale_location_group (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CODE varchar(100) NOT NULL,
  SORT int NOT NULL DEFAULT '100',
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sale_location_group_code ON b_sale_location_group (code);

CREATE TABLE b_sale_location_group_lang (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  LOCATION_GROUP_ID int NOT NULL,
  LID char(2) NOT NULL,
  NAME varchar(250) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sale_location_group_lang_location_group_id_lid ON b_sale_location_group_lang (location_group_id, lid);

CREATE TABLE b_sale_location2location_group (
  LOCATION_ID int NOT NULL,
  LOCATION_GROUP_ID int NOT NULL,
  PRIMARY KEY (LOCATION_ID, LOCATION_GROUP_ID)
);

CREATE TABLE b_sale_delivery2location (
  DELIVERY_ID int NOT NULL,
  LOCATION_CODE varchar(100) NOT NULL,
  LOCATION_TYPE char(2) NOT NULL DEFAULT 'L',
  PRIMARY KEY (DELIVERY_ID, LOCATION_CODE, LOCATION_TYPE)
);

CREATE TABLE b_sale_company2location (
  COMPANY_ID int NOT NULL,
  LOCATION_CODE varchar(100) NOT NULL,
  LOCATION_TYPE char(1) NOT NULL DEFAULT 'L',
  PRIMARY KEY (COMPANY_ID, LOCATION_CODE, LOCATION_TYPE)
);

CREATE TABLE b_sale_company2service (
  COMPANY_ID int NOT NULL,
  SERVICE_ID int NOT NULL,
  SERVICE_TYPE int NOT NULL,
  PRIMARY KEY (COMPANY_ID, SERVICE_ID, SERVICE_TYPE)
);

CREATE TABLE b_sale_discount (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  XML_ID varchar(255),
  LID char(2) NOT NULL,
  NAME varchar(255),
  PRICE_FROM decimal,
  PRICE_TO decimal,
  CURRENCY char(3),
  DISCOUNT_VALUE decimal NOT NULL,
  DISCOUNT_TYPE char(1) NOT NULL DEFAULT 'P',
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  SORT int NOT NULL DEFAULT '100',
  ACTIVE_FROM timestamp,
  ACTIVE_TO timestamp,
  TIMESTAMP_X timestamp,
  MODIFIED_BY int,
  DATE_CREATE timestamp,
  CREATED_BY int,
  PRIORITY int NOT NULL DEFAULT 1,
  LAST_DISCOUNT char(1) NOT NULL DEFAULT 'Y',
  LAST_LEVEL_DISCOUNT char(1) DEFAULT 'N',
  VERSION int NOT NULL DEFAULT 1,
  CONDITIONS text,
  UNPACK text,
  ACTIONS text,
  APPLICATION text,
  PREDICTION_TEXT text,
  PREDICTIONS text,
  PREDICTIONS_APP text,
  USE_COUPONS char(1) NOT NULL DEFAULT 'N',
  EXECUTE_MODULE varchar(50) NOT NULL DEFAULT 'all',
  EXECUTE_MODE int DEFAULT 0,
  HAS_INDEX char(1) DEFAULT 'N',
  PRESET_ID varchar(255),
  SHORT_DESCRIPTION text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_discount_lid ON b_sale_discount (lid);
CREATE INDEX ix_b_sale_discount_active_from_active_to ON b_sale_discount (active_from, active_to);
CREATE INDEX ix_b_sale_discount_preset_id ON b_sale_discount (preset_id);

CREATE TABLE b_sale_discount_coupon (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DISCOUNT_ID int NOT NULL,
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  ACTIVE_FROM timestamp,
  ACTIVE_TO timestamp,
  COUPON varchar(32) NOT NULL,
  TYPE int NOT NULL DEFAULT 0,
  MAX_USE int NOT NULL DEFAULT 0,
  USE_COUNT int NOT NULL DEFAULT 0,
  USER_ID int NOT NULL DEFAULT 0,
  DATE_APPLY timestamp,
  TIMESTAMP_X timestamp,
  MODIFIED_BY int,
  DATE_CREATE timestamp,
  CREATED_BY int,
  DESCRIPTION text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_discount_coupon_coupon ON b_sale_discount_coupon (coupon);

CREATE TABLE b_sale_discount_group (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DISCOUNT_ID int NOT NULL,
  ACTIVE char(1),
  GROUP_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sale_discount_group_discount_id_group_id ON b_sale_discount_group (discount_id, group_id);
CREATE UNIQUE INDEX ux_b_sale_discount_group_group_id_discount_id ON b_sale_discount_group (group_id, discount_id);

CREATE TABLE b_sale_discount_module (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DISCOUNT_ID int NOT NULL,
  MODULE_ID varchar(50) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_discount_module_discount_id ON b_sale_discount_module (discount_id);

CREATE TABLE b_sale_discount_entities (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DISCOUNT_ID int NOT NULL,
  MODULE_ID varchar(50) NOT NULL,
  ENTITY varchar(255) NOT NULL,
  FIELD_ENTITY varchar(255) NOT NULL,
  FIELD_TABLE varchar(255) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_discount_entities_discount_id ON b_sale_discount_entities (discount_id);

CREATE TABLE b_sale_order_discount (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  MODULE_ID varchar(50) NOT NULL,
  DISCOUNT_ID int NOT NULL,
  NAME varchar(255) NOT NULL,
  DISCOUNT_HASH varchar(32) NOT NULL,
  CONDITIONS text,
  UNPACK text,
  ACTIONS text,
  APPLICATION text,
  USE_COUPONS char(1) NOT NULL,
  SORT int NOT NULL,
  PRIORITY int NOT NULL,
  LAST_DISCOUNT char(1) NOT NULL,
  ACTIONS_DESCR text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_order_discount_discount_hash ON b_sale_order_discount (discount_hash);

CREATE TABLE b_sale_order_coupons (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ORDER_ID int NOT NULL,
  ORDER_DISCOUNT_ID int NOT NULL,
  COUPON varchar(32) NOT NULL,
  TYPE int NOT NULL,
  COUPON_ID int NOT NULL,
  DATA text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_order_coupons_order_id ON b_sale_order_coupons (order_id);

CREATE TABLE b_sale_order_modules (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ORDER_DISCOUNT_ID int NOT NULL,
  MODULE_ID varchar(50) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_order_modules_order_discount_id ON b_sale_order_modules (order_discount_id);

CREATE TABLE b_sale_order_rules (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  MODULE_ID varchar(50) NOT NULL,
  ORDER_DISCOUNT_ID int NOT NULL,
  ORDER_ID int NOT NULL,
  ENTITY_TYPE int NOT NULL,
  ENTITY_ID int NOT NULL,
  ENTITY_VALUE varchar(255),
  COUPON_ID int NOT NULL,
  APPLY char(1) NOT NULL,
  ACTION_BLOCK_LIST text,
  APPLY_BLOCK_COUNTER int NOT NULL DEFAULT 0,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_order_rules_order_id ON b_sale_order_rules (order_id);

CREATE TABLE b_sale_order_rules_descr (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  MODULE_ID varchar(50) NOT NULL,
  ORDER_DISCOUNT_ID int NOT NULL,
  ORDER_ID int NOT NULL,
  RULE_ID int NOT NULL,
  DESCR text NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_order_rules_descr_order_id ON b_sale_order_rules_descr (order_id);
CREATE INDEX ix_b_sale_order_rules_descr_rule_id ON b_sale_order_rules_descr (rule_id);

CREATE TABLE b_sale_order_discount_data (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ORDER_ID int NOT NULL,
  ENTITY_TYPE int NOT NULL,
  ENTITY_ID int NOT NULL,
  ENTITY_VALUE varchar(255),
  ENTITY_DATA text NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_order_discount_data_order_id_entity_type ON b_sale_order_discount_data (order_id, entity_type);

CREATE TABLE b_sale_order_round (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ORDER_ID int NOT NULL,
  APPLY_BLOCK_COUNTER int NOT NULL DEFAULT 0,
  ORDER_ROUND char(1) NOT NULL,
  ENTITY_TYPE int NOT NULL,
  ENTITY_ID int NOT NULL,
  ENTITY_VALUE varchar(255),
  APPLY char(1) NOT NULL,
  ROUND_RULE text NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_order_round_order_id ON b_sale_order_round (order_id);

CREATE TABLE b_sale_user_props (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  NAME varchar(255) NOT NULL,
  USER_ID int NOT NULL,
  PERSON_TYPE_ID int NOT NULL,
  DATE_UPDATE timestamp NOT NULL,
  XML_ID varchar(50),
  VERSION_1C varchar(15),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_user_props_user_id ON b_sale_user_props (user_id);
CREATE INDEX ix_b_sale_user_props_person_type_id ON b_sale_user_props (person_type_id);
CREATE INDEX ix_b_sale_user_props_xml_id ON b_sale_user_props (xml_id);

CREATE TABLE b_sale_d_ix_element (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DISCOUNT_ID int NOT NULL,
  ELEMENT_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_d_ix_element_element_id_discount_id ON b_sale_d_ix_element (element_id, discount_id);

CREATE TABLE b_sale_d_ix_section (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DISCOUNT_ID int NOT NULL,
  SECTION_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_d_ix_section_section_id_discount_id ON b_sale_d_ix_section (section_id, discount_id);

CREATE TABLE b_sale_user_props_value (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_PROPS_ID int NOT NULL,
  ORDER_PROPS_ID int NOT NULL,
  NAME varchar(255) NOT NULL,
  VALUE varchar(255),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_user_props_value_user_props_id ON b_sale_user_props_value (user_props_id);
CREATE INDEX ix_b_sale_user_props_value_order_props_id ON b_sale_user_props_value (order_props_id);

CREATE TABLE b_sale_status (
  ID varchar(2) NOT NULL,
  TYPE char(1) NOT NULL DEFAULT 'O',
  SORT int NOT NULL DEFAULT '100',
  NOTIFY char(1) NOT NULL DEFAULT 'Y',
  COLOR varchar(10),
  XML_ID varchar(255),
  PRIMARY KEY (ID)
);

CREATE TABLE b_sale_status_lang (
  STATUS_ID varchar(2) NOT NULL,
  LID char(2) NOT NULL,
  NAME varchar(100) NOT NULL,
  DESCRIPTION varchar(250),
  PRIMARY KEY (STATUS_ID, LID)
);

CREATE TABLE b_sale_status_group_task (
  STATUS_ID varchar(2) NOT NULL,
  GROUP_ID int NOT NULL,
  TASK_ID int NOT NULL,
  PRIMARY KEY (STATUS_ID, GROUP_ID, TASK_ID)
);

CREATE TABLE b_sale_tax (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  LID char(2) NOT NULL,
  NAME varchar(250) NOT NULL,
  DESCRIPTION varchar(255),
  TIMESTAMP_X timestamp NOT NULL,
  CODE varchar(50),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_tax_lid ON b_sale_tax (lid);

CREATE TABLE b_sale_tax_rate (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TAX_ID int NOT NULL,
  PERSON_TYPE_ID int,
  VALUE decimal NOT NULL,
  CURRENCY char(3),
  IS_PERCENT char(1) NOT NULL DEFAULT 'Y',
  IS_IN_PRICE char(1) NOT NULL DEFAULT 'N',
  APPLY_ORDER int NOT NULL DEFAULT '100',
  TIMESTAMP_X timestamp NOT NULL,
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_tax_rate_person_type_id ON b_sale_tax_rate (person_type_id);
CREATE INDEX ix_b_sale_tax_rate_tax_id ON b_sale_tax_rate (tax_id);
CREATE INDEX ix_b_sale_tax_rate_is_in_price ON b_sale_tax_rate (is_in_price);

CREATE TABLE b_sale_tax2location (
  TAX_RATE_ID int NOT NULL,
  LOCATION_CODE varchar(100) NOT NULL,
  LOCATION_TYPE char(1) NOT NULL DEFAULT 'L',
  PRIMARY KEY (TAX_RATE_ID, LOCATION_CODE, LOCATION_TYPE)
);

CREATE TABLE b_sale_tax_exempt2group (
  GROUP_ID int NOT NULL,
  TAX_ID int NOT NULL,
  PRIMARY KEY (GROUP_ID, TAX_ID)
);

CREATE TABLE b_sale_order_tax (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ORDER_ID int NOT NULL,
  TAX_NAME varchar(255) NOT NULL,
  VALUE decimal,
  VALUE_MONEY decimal NOT NULL,
  APPLY_ORDER int NOT NULL,
  CODE varchar(50),
  IS_PERCENT char(1) NOT NULL DEFAULT 'Y',
  IS_IN_PRICE char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_order_tax_order_id ON b_sale_order_tax (order_id);

CREATE TABLE b_sale_order_flags2group (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  GROUP_ID int NOT NULL,
  ORDER_FLAG char(1) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sale_order_flags2group_group_id_order_flag ON b_sale_order_flags2group (group_id, order_flag);

CREATE TABLE b_sale_site2group (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  GROUP_ID int NOT NULL,
  SITE_ID char(2) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sale_site2group_group_id_site_id ON b_sale_site2group (group_id, site_id);

CREATE TABLE b_sale_user_account (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int NOT NULL,
  TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  CURRENT_BUDGET decimal NOT NULL DEFAULT '0.0',
  CURRENCY char(3) NOT NULL,
  LOCKED char(1) NOT NULL DEFAULT 'N',
  DATE_LOCKED timestamp,
  NOTES text,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sale_user_account_user_id_currency ON b_sale_user_account (user_id, currency);

CREATE TABLE b_sale_recurring (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int NOT NULL,
  TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  MODULE varchar(100),
  PRODUCT_ID int,
  PRODUCT_NAME varchar(255),
  PRODUCT_URL varchar(255),
  PRODUCT_PRICE_ID int,
  PRICE_TYPE char(1) NOT NULL DEFAULT 'R',
  RECUR_SCHEME_TYPE char(1) NOT NULL DEFAULT 'M',
  RECUR_SCHEME_LENGTH int NOT NULL DEFAULT '0',
  WITHOUT_ORDER char(1) NOT NULL DEFAULT 'N',
  PRICE decimal NOT NULL DEFAULT '0.0',
  CURRENCY char(3),
  CANCELED char(1) NOT NULL DEFAULT 'N',
  DATE_CANCELED timestamp,
  PRIOR_DATE timestamp,
  NEXT_DATE timestamp NOT NULL,
  CALLBACK_FUNC varchar(100),
  PRODUCT_PROVIDER_CLASS varchar(100),
  DESCRIPTION varchar(255),
  CANCELED_REASON varchar(255),
  ORDER_ID int NOT NULL,
  REMAINING_ATTEMPTS int NOT NULL DEFAULT '0',
  SUCCESS_PAYMENT char(1) NOT NULL DEFAULT 'Y',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_recurring_user_id ON b_sale_recurring (user_id);
CREATE INDEX ix_b_sale_recurring_next_date_canceled_remaining_attempts ON b_sale_recurring (next_date, canceled, remaining_attempts);
CREATE INDEX ix_b_sale_recurring_module_product_id_product_price_id ON b_sale_recurring (module, product_id, product_price_id);

CREATE TABLE b_sale_user_cards (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int NOT NULL,
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  SORT int NOT NULL DEFAULT '100',
  TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PAY_SYSTEM_ACTION_ID int NOT NULL,
  CURRENCY char(3),
  CARD_TYPE varchar(20) NOT NULL,
  CARD_NUM text NOT NULL,
  CARD_CODE varchar(5),
  CARD_EXP_MONTH int NOT NULL,
  CARD_EXP_YEAR int NOT NULL,
  DESCRIPTION varchar(255),
  SUM_MIN decimal,
  SUM_MAX decimal,
  SUM_CURRENCY char(3),
  LAST_STATUS char(1),
  LAST_STATUS_CODE varchar(5),
  LAST_STATUS_DESCRIPTION varchar(250),
  LAST_STATUS_MESSAGE varchar(255),
  LAST_SUM decimal,
  LAST_CURRENCY char(3),
  LAST_DATE timestamp,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_user_cards_user_id_active_currency ON b_sale_user_cards (user_id, active, currency);

CREATE TABLE b_sale_user_transact (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int NOT NULL,
  TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  TRANSACT_DATE timestamp NOT NULL,
  AMOUNT decimal NOT NULL DEFAULT '0.0',
  CURRENCY char(3) NOT NULL,
  DEBIT char(1) NOT NULL DEFAULT 'N',
  ORDER_ID int,
  DESCRIPTION varchar(255) NOT NULL,
  NOTES text,
  PAYMENT_ID int,
  EMPLOYEE_ID int,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_user_transact_user_id_currency ON b_sale_user_transact (user_id, currency);
CREATE INDEX ix_b_sale_user_transact_order_id ON b_sale_user_transact (order_id);
CREATE INDEX ix_b_sale_user_transact_payment_id ON b_sale_user_transact (payment_id);

CREATE TABLE b_sale_affiliate_plan (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  SITE_ID char(2) NOT NULL,
  NAME varchar(250) NOT NULL,
  DESCRIPTION text,
  TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  BASE_RATE decimal NOT NULL DEFAULT '0',
  BASE_RATE_TYPE char(1) NOT NULL DEFAULT 'P',
  BASE_RATE_CURRENCY char(3),
  MIN_PAY decimal NOT NULL DEFAULT '0',
  MIN_PLAN_VALUE decimal,
  VALUE_CURRENCY char(3),
  PRIMARY KEY (ID)
);

CREATE TABLE b_sale_affiliate (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  SITE_ID char(2) NOT NULL,
  USER_ID int NOT NULL,
  AFFILIATE_ID int,
  PLAN_ID int NOT NULL,
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  DATE_CREATE timestamp NOT NULL,
  PAID_SUM decimal NOT NULL DEFAULT '0',
  APPROVED_SUM decimal NOT NULL DEFAULT '0',
  PENDING_SUM decimal NOT NULL DEFAULT '0',
  ITEMS_NUMBER int NOT NULL DEFAULT '0',
  ITEMS_SUM decimal NOT NULL DEFAULT '0',
  LAST_CALCULATE timestamp,
  AFF_SITE varchar(200),
  AFF_DESCRIPTION text,
  FIX_PLAN char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sale_affiliate_user_id_site_id ON b_sale_affiliate (user_id, site_id);
CREATE INDEX ix_b_sale_affiliate_affiliate_id ON b_sale_affiliate (affiliate_id);

CREATE TABLE b_sale_affiliate_plan_section (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  PLAN_ID int NOT NULL,
  MODULE_ID varchar(50) NOT NULL DEFAULT 'catalog',
  SECTION_ID varchar(255) NOT NULL,
  RATE decimal NOT NULL DEFAULT '0',
  RATE_TYPE char(1) NOT NULL DEFAULT 'P',
  RATE_CURRENCY char(3),
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sale_affiliate_plan_section_plan_id_module_id_section_id ON b_sale_affiliate_plan_section (plan_id, module_id, section_id);

CREATE TABLE b_sale_affiliate_tier (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  SITE_ID char(2) NOT NULL,
  RATE1 decimal NOT NULL DEFAULT '0',
  RATE2 decimal NOT NULL DEFAULT '0',
  RATE3 decimal NOT NULL DEFAULT '0',
  RATE4 decimal NOT NULL DEFAULT '0',
  RATE5 decimal NOT NULL DEFAULT '0',
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sale_affiliate_tier_site_id ON b_sale_affiliate_tier (site_id);

CREATE TABLE b_sale_affiliate_transact (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  AFFILIATE_ID int NOT NULL,
  TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  TRANSACT_DATE timestamp NOT NULL,
  AMOUNT decimal NOT NULL,
  CURRENCY char(3) NOT NULL,
  DEBIT char(1) NOT NULL DEFAULT 'N',
  DESCRIPTION varchar(100) NOT NULL,
  EMPLOYEE_ID int,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_affiliate_transact_affiliate_id ON b_sale_affiliate_transact (affiliate_id);

CREATE TABLE b_sale_export (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  PERSON_TYPE_ID int NOT NULL,
  VARS text,
  PRIMARY KEY (ID)
);

CREATE TABLE b_sale_order_delivery (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ORDER_ID int NOT NULL,
  ACCOUNT_NUMBER varchar(100),
  DATE_INSERT timestamp NOT NULL,
  DATE_REQUEST timestamp DEFAULT NULL,
  DATE_UPDATE timestamp DEFAULT NULL,
  DELIVERY_LOCATION varchar(50) DEFAULT NULL,
  PARAMS text,
  STATUS_ID varchar(2) NOT NULL,
  PRICE_DELIVERY decimal DEFAULT NULL,
  DISCOUNT_PRICE decimal DEFAULT NULL,
  BASE_PRICE_DELIVERY decimal DEFAULT NULL,
  CUSTOM_PRICE_DELIVERY char(1) DEFAULT NULL,
  ALLOW_DELIVERY char(1) DEFAULT 'N',
  DATE_ALLOW_DELIVERY timestamp DEFAULT NULL,
  EMP_ALLOW_DELIVERY_ID int DEFAULT NULL,
  DEDUCTED char(1) DEFAULT 'N',
  DATE_DEDUCTED timestamp DEFAULT NULL,
  EMP_DEDUCTED_ID int DEFAULT NULL,
  REASON_UNDO_DEDUCTED varchar(255) DEFAULT NULL,
  RESERVED char(1) DEFAULT NULL,
  DELIVERY_ID int NOT NULL,
  DELIVERY_DOC_NUM varchar(20) DEFAULT NULL,
  DELIVERY_DOC_DATE timestamp DEFAULT NULL,
  TRACKING_NUMBER varchar(255) DEFAULT NULL,
  XML_ID varchar(255) DEFAULT NULL,
  DELIVERY_NAME varchar(128) DEFAULT NULL,
  CANCELED char(1) DEFAULT 'N',
  DATE_CANCELED timestamp DEFAULT NULL,
  EMP_CANCELED_ID int DEFAULT NULL,
  REASON_CANCELED varchar(255) DEFAULT '',
  MARKED char(1) DEFAULT NULL,
  DATE_MARKED timestamp DEFAULT NULL,
  EMP_MARKED_ID int DEFAULT NULL,
  REASON_MARKED varchar(255) DEFAULT NULL,
  CURRENCY varchar(3) DEFAULT NULL,
  SYSTEM char(1) NOT NULL DEFAULT 'N',
  WEIGHT double precision DEFAULT 0,
  RESPONSIBLE_ID int DEFAULT NULL,
  EMP_RESPONSIBLE_ID int DEFAULT NULL,
  DATE_RESPONSIBLE_ID timestamp DEFAULT NULL,
  COMMENTS text,
  COMPANY_ID int DEFAULT NULL,
  TRACKING_STATUS int,
  TRACKING_DESCRIPTION varchar(255),
  TRACKING_LAST_CHECK timestamp,
  TRACKING_LAST_CHANGE timestamp,
  ID_1C varchar(36) DEFAULT NULL,
  VERSION_1C varchar(15) DEFAULT NULL,
  EXTERNAL_DELIVERY char(1) NOT NULL DEFAULT 'N',
  UPDATED_1C char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_order_delivery_order_id ON b_sale_order_delivery (order_id);
CREATE INDEX ix_b_sale_order_delivery_date_allow_delivery ON b_sale_order_delivery (date_allow_delivery);
CREATE INDEX ix_b_sale_order_delivery_allow_delivery ON b_sale_order_delivery (allow_delivery);
CREATE INDEX ix_b_sale_order_delivery_date_canceled ON b_sale_order_delivery (date_canceled);
CREATE INDEX ix_b_sale_order_delivery_canceled ON b_sale_order_delivery (canceled);
CREATE UNIQUE INDEX ux_b_sale_order_delivery_account_number ON b_sale_order_delivery (account_number);

CREATE TABLE b_sale_order_dlv_basket (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ORDER_DELIVERY_ID int NOT NULL,
  BASKET_ID int NOT NULL,
  DATE_INSERT timestamp NOT NULL,
  QUANTITY decimal NOT NULL,
  RESERVED_QUANTITY decimal NOT NULL,
  XML_ID varchar(255),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_order_dlv_basket_order_delivery_id ON b_sale_order_dlv_basket (order_delivery_id);
CREATE INDEX ix_b_sale_order_dlv_basket_basket_id ON b_sale_order_dlv_basket (basket_id);

CREATE TABLE b_sale_order_delivery_req (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ORDER_ID int NOT NULL,
  DATE_REQUEST timestamp,
  DELIVERY_LOCATION varchar(50) DEFAULT NULL,
  PARAMS text,
  SHIPMENT_ID int,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_order_delivery_req_order_id ON b_sale_order_delivery_req (order_id);
CREATE INDEX ix_b_sale_order_delivery_req_shipment_id ON b_sale_order_delivery_req (shipment_id);

CREATE TABLE b_sale_order_payment (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ORDER_ID int NOT NULL,
  ACCOUNT_NUMBER varchar(100),
  PAID char(1) NOT NULL DEFAULT 'N',
  DATE_PAID timestamp DEFAULT NULL,
  EMP_PAID_ID int DEFAULT NULL,
  PAY_SYSTEM_ID int NOT NULL,
  PS_STATUS char(1) DEFAULT NULL,
  PS_INVOICE_ID varchar(250),
  PS_STATUS_CODE varchar(255) DEFAULT NULL,
  PS_STATUS_DESCRIPTION varchar(512) DEFAULT NULL,
  PS_STATUS_MESSAGE varchar(250) DEFAULT NULL,
  PS_SUM decimal DEFAULT NULL,
  PS_CURRENCY char(3) DEFAULT NULL,
  PS_RESPONSE_DATE timestamp DEFAULT NULL,
  PS_RECURRING_TOKEN varchar(255) DEFAULT NULL,
  PS_CARD_NUMBER varchar(64) DEFAULT NULL,
  PAY_VOUCHER_NUM varchar(20) DEFAULT NULL,
  PAY_VOUCHER_DATE date DEFAULT NULL,
  DATE_PAY_BEFORE timestamp DEFAULT NULL,
  DATE_BILL timestamp DEFAULT NULL,
  XML_ID varchar(255) DEFAULT NULL,
  SUM decimal NOT NULL,
  PRICE_COD decimal NOT NULL DEFAULT 0,
  CURRENCY char(3) NOT NULL,
  PAY_SYSTEM_NAME varchar(128) NOT NULL,
  RESPONSIBLE_ID int DEFAULT NULL,
  DATE_RESPONSIBLE_ID timestamp DEFAULT NULL,
  EMP_RESPONSIBLE_ID int DEFAULT NULL,
  COMMENTS text,
  COMPANY_ID int DEFAULT NULL,
  PAY_RETURN_DATE date DEFAULT NULL,
  EMP_RETURN_ID int DEFAULT NULL,
  PAY_RETURN_NUM varchar(20) DEFAULT NULL,
  PAY_RETURN_COMMENT text,
  IS_RETURN char(1) NOT NULL DEFAULT 'N',
  MARKED char(1) DEFAULT NULL,
  DATE_MARKED timestamp DEFAULT NULL,
  EMP_MARKED_ID int DEFAULT NULL,
  REASON_MARKED varchar(255) DEFAULT NULL,
  ID_1C varchar(36) DEFAULT NULL,
  VERSION_1C varchar(15) DEFAULT NULL,
  EXTERNAL_PAYMENT char(1) NOT NULL DEFAULT 'N',
  UPDATED_1C char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_order_payment_order_id ON b_sale_order_payment (order_id);
CREATE INDEX ix_b_sale_order_payment_date_paid ON b_sale_order_payment (date_paid);
CREATE INDEX ix_b_sale_order_payment_paid ON b_sale_order_payment (paid);
CREATE UNIQUE INDEX ux_b_sale_order_payment_account_number ON b_sale_order_payment (account_number);

CREATE TABLE b_sale_order_payment_item (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  PAYMENT_ID int NOT NULL,
  ENTITY_ID int NOT NULL,
  ENTITY_TYPE varchar(15) NOT NULL,
  DATE_INSERT timestamp NOT NULL,
  QUANTITY decimal NOT NULL,
  XML_ID varchar(255),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_order_payment_item_entity_id_entity_type ON b_sale_order_payment_item (entity_id, entity_type);
CREATE INDEX ix_b_sale_order_payment_item_payment_id ON b_sale_order_payment_item (payment_id);

CREATE TABLE b_sale_product2product (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  PRODUCT_ID int NOT NULL,
  PARENT_PRODUCT_ID int NOT NULL,
  CNT int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_product2product_product_id ON b_sale_product2product (product_id);

CREATE TABLE b_sale_order_product_stat (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  PRODUCT_ID int NOT NULL,
  RELATED_PRODUCT_ID int NOT NULL,
  ORDER_DATE timestamp NOT NULL,
  CNT int NOT NULL DEFAULT 1,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sale_order_product_stat_product_id_related_product_id_orde ON b_sale_order_product_stat (product_id, related_product_id, order_date);
CREATE INDEX ix_b_sale_order_product_stat_order_date ON b_sale_order_product_stat (order_date);

CREATE TABLE b_sale_person_type_site (
  PERSON_TYPE_ID int NOT NULL DEFAULT '0',
  SITE_ID char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (PERSON_TYPE_ID, SITE_ID)
);

CREATE TABLE b_sale_viewed_product (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  FUSER_ID int8 NOT NULL DEFAULT '0',
  DATE_VISIT timestamp NOT NULL,
  PRODUCT_ID int8 NOT NULL DEFAULT '0',
  MODULE varchar(100),
  LID char(2) NOT NULL,
  NAME varchar(255) NOT NULL,
  DETAIL_PAGE_URL varchar(255),
  CURRENCY char(3),
  PRICE decimal NOT NULL DEFAULT '0.00',
  NOTES varchar(255),
  PREVIEW_PICTURE int,
  DETAIL_PICTURE int,
  CALLBACK_FUNC varchar(45),
  PRODUCT_PROVIDER_CLASS varchar(100),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_viewed_product_fuser_id_lid ON b_sale_viewed_product (fuser_id, lid);
CREATE INDEX ix_b_sale_viewed_product_product_id ON b_sale_viewed_product (product_id);
CREATE INDEX ix_b_sale_viewed_product_date_visit ON b_sale_viewed_product (date_visit);

CREATE TABLE b_sale_order_history (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  H_USER_ID int8 NOT NULL,
  H_DATE_INSERT timestamp NOT NULL,
  H_ORDER_ID int8 NOT NULL,
  H_CURRENCY char(3) NOT NULL,
  PERSON_TYPE_ID int8,
  PAYED char(1),
  DATE_PAYED timestamp,
  EMP_PAYED_ID int8,
  CANCELED char(1),
  DATE_CANCELED timestamp,
  REASON_CANCELED varchar(255),
  STATUS_ID varchar(2) NOT NULL,
  DATE_STATUS timestamp,
  PRICE_DELIVERY decimal,
  ALLOW_DELIVERY char(1),
  DATE_ALLOW_DELIVERY timestamp,
  RESERVED char(1),
  DEDUCTED char(1),
  DATE_DEDUCTED timestamp,
  REASON_UNDO_DEDUCTED varchar(255),
  MARKED char(1),
  DATE_MARKED timestamp,
  REASON_MARKED varchar(255),
  PRICE decimal,
  CURRENCY char(3),
  DISCOUNT_VALUE decimal,
  USER_ID int8,
  PAY_SYSTEM_ID int8,
  DELIVERY_ID varchar(50),
  PS_STATUS char(1),
  PS_STATUS_CODE char(5),
  PS_STATUS_DESCRIPTION varchar(250),
  PS_STATUS_MESSAGE varchar(250),
  PS_SUM decimal,
  PS_CURRENCY char(3),
  PS_RESPONSE_DATE timestamp,
  TAX_VALUE decimal,
  STAT_GID varchar(255),
  SUM_PAID decimal,
  PAY_VOUCHER_NUM varchar(20),
  PAY_VOUCHER_DATE date,
  AFFILIATE_ID int8,
  DELIVERY_DOC_NUM varchar(20),
  DELIVERY_DOC_DATE date,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_order_history_h_order_id ON b_sale_order_history (h_order_id);

CREATE TABLE b_sale_delivery2paysystem (
  DELIVERY_ID int NOT NULL,
  LINK_DIRECTION char(1) NOT NULL,
  PAYSYSTEM_ID int NOT NULL
);
CREATE INDEX ix_b_sale_delivery2paysystem_delivery_id ON b_sale_delivery2paysystem (delivery_id);
CREATE INDEX ix_b_sale_delivery2paysystem_paysystem_id ON b_sale_delivery2paysystem (paysystem_id);
CREATE INDEX ix_b_sale_delivery2paysystem_link_direction ON b_sale_delivery2paysystem (link_direction);

CREATE TABLE b_sale_store_barcode (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  BASKET_ID int NOT NULL,
  BARCODE varchar(100),
  MARKING_CODE varchar(200),
  STORE_ID int,
  QUANTITY double precision NOT NULL,
  DATE_CREATE timestamp,
  DATE_MODIFY timestamp,
  CREATED_BY int,
  MODIFIED_BY int,
  ORDER_DELIVERY_BASKET_ID int NOT NULL DEFAULT 0,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_store_barcode_order_delivery_basket_id ON b_sale_store_barcode (order_delivery_basket_id);

CREATE TABLE b_sale_order_change (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ORDER_ID int NOT NULL,
  TYPE varchar(255) NOT NULL,
  DATA varchar(512),
  DATE_CREATE timestamp NOT NULL,
  DATE_MODIFY timestamp NOT NULL,
  USER_ID int NOT NULL,
  ENTITY varchar(50) DEFAULT NULL,
  ENTITY_ID int DEFAULT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_order_change_order_id ON b_sale_order_change (order_id);
CREATE INDEX ix_b_sale_order_change_type ON b_sale_order_change (type);

CREATE TABLE b_sale_order_processing (
  ORDER_ID int DEFAULT '0',
  PRODUCTS_ADDED char(1) DEFAULT 'N',
  PRODUCTS_REMOVED char(1) DEFAULT 'N'
);
CREATE INDEX ix_b_sale_order_processing_order_id ON b_sale_order_processing (order_id);

CREATE TABLE b_sale_tp (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CODE varchar(20) NOT NULL,
  ACTIVE char(1) NOT NULL,
  NAME varchar(500) NOT NULL,
  DESCRIPTION text,
  SETTINGS text,
  CATALOG_SECTION_TAB_CLASS_NAME varchar(255),
  CLASS varchar(255),
  XML_ID varchar(255),
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sale_tp_code ON b_sale_tp (code);

CREATE TABLE b_sale_delivery_srv (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CODE varchar(50),
  PARENT_ID int,
  NAME varchar(255) NOT NULL,
  ACTIVE char(1) NOT NULL,
  DESCRIPTION text,
  SORT int NOT NULL,
  LOGOTIP int,
  CONFIG text,
  CLASS_NAME varchar(255) NOT NULL,
  CURRENCY char(3) NOT NULL,
  TRACKING_PARAMS varchar(255),
  ALLOW_EDIT_SHIPMENT char(1) NOT NULL DEFAULT 'Y',
  VAT_ID int,
  XML_ID varchar(255),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_delivery_srv_code ON b_sale_delivery_srv (code);
CREATE INDEX ix_b_sale_delivery_srv_parent_id ON b_sale_delivery_srv (parent_id);

CREATE TABLE b_sale_service_rstr (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  SERVICE_ID int NOT NULL,
  SERVICE_TYPE int NOT NULL,
  SORT int DEFAULT 100,
  CLASS_NAME varchar(255) NOT NULL,
  PARAMS text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_service_rstr_service_id ON b_sale_service_rstr (service_id);

CREATE TABLE b_sale_delivery_es (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CODE varchar(50),
  NAME varchar(255) NOT NULL,
  DESCRIPTION varchar(255),
  CLASS_NAME varchar(255) NOT NULL,
  PARAMS text,
  RIGHTS char(3) NOT NULL,
  DELIVERY_ID int NOT NULL,
  INIT_VALUE varchar(255),
  ACTIVE char(1) NOT NULL,
  SORT int DEFAULT 100,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_delivery_es_delivery_id ON b_sale_delivery_es (delivery_id);

CREATE TABLE b_sale_company (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  NAME varchar(128) NOT NULL,
  LOCATION_ID varchar(128),
  CODE varchar(45),
  SORT int DEFAULT 100,
  XML_ID varchar(45),
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  DATE_CREATE timestamp,
  DATE_MODIFY timestamp,
  CREATED_BY int,
  MODIFIED_BY int,
  ADDRESS varchar(255),
  PRIMARY KEY (ID)
);

CREATE TABLE b_sale_bizval (
  CODE_KEY varchar(50) NOT NULL,
  CONSUMER_KEY varchar(50) NOT NULL,
  PERSON_TYPE_ID int NOT NULL,
  PROVIDER_KEY varchar(50) NOT NULL,
  PROVIDER_VALUE text,
  PRIMARY KEY (CODE_KEY, CONSUMER_KEY, PERSON_TYPE_ID)
);

CREATE TABLE b_sale_bizval_persondomain (
  PERSON_TYPE_ID int NOT NULL,
  DOMAIN char(1) NOT NULL,
  PRIMARY KEY (PERSON_TYPE_ID, DOMAIN)
);

CREATE TABLE b_sale_bizval_code_1c (
  PERSON_TYPE_ID int NOT NULL,
  CODE_INDEX int NOT NULL,
  NAME varchar(255) NOT NULL,
  PRIMARY KEY (PERSON_TYPE_ID, CODE_INDEX)
);

CREATE TABLE b_sale_order_delivery_es (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  SHIPMENT_ID int NOT NULL,
  EXTRA_SERVICE_ID int NOT NULL,
  VALUE varchar(255),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_order_delivery_es_shipment_id ON b_sale_order_delivery_es (shipment_id);
CREATE INDEX ix_b_sale_order_delivery_es_extra_service_id ON b_sale_order_delivery_es (extra_service_id);

CREATE TABLE b_sale_tp_map (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_ID int NOT NULL,
  VALUE_EXTERNAL varchar(100) NOT NULL,
  VALUE_INTERNAL varchar(100) NOT NULL,
  PARAMS text,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sale_tp_map_entity_id_value_external_value_internal ON b_sale_tp_map (entity_id, value_external, value_internal);

CREATE TABLE b_sale_tp_map_entity (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TRADING_PLATFORM_ID int NOT NULL,
  CODE varchar(255) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sale_tp_map_entity_trading_platform_id_code ON b_sale_tp_map_entity (trading_platform_id, code);

CREATE TABLE b_sale_tp_ebay_cat (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  NAME varchar(255) NOT NULL,
  CATEGORY_ID int NOT NULL,
  PARENT_ID int NOT NULL,
  LEVEL int NOT NULL,
  LAST_UPDATE timestamp NOT NULL,
  PRIMARY KEY (ID)
);

CREATE TABLE b_sale_tp_ebay_cat_var (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CATEGORY_ID int NOT NULL,
  NAME varchar(255) NOT NULL,
  VALUE text,
  REQUIRED char(1) NOT NULL,
  MIN_VALUES int NOT NULL,
  MAX_VALUES int NOT NULL,
  SELECTION_MODE varchar(255) NOT NULL,
  ALLOWED_AS_VARIATION char(1) NOT NULL,
  HELP_URL varchar(255) NOT NULL,
  PRIMARY KEY (ID)
);

CREATE TABLE b_sale_tp_ebay_fq (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  FEED_TYPE varchar(50) NOT NULL,
  DATA text NOT NULL,
  PRIMARY KEY (ID)
);

CREATE TABLE b_sale_tp_ebay_fr (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  FILENAME varchar(255) NOT NULL,
  FEED_TYPE varchar(50) NOT NULL,
  UPLOAD_TIME timestamp NOT NULL,
  PROCESSING_REQUEST_ID varchar(50),
  PROCESSING_RESULT varchar(100),
  RESULTS text,
  IS_SUCCESS varchar(1),
  PRIMARY KEY (ID)
);

CREATE TABLE b_sale_tp_order (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ORDER_ID int NOT NULL,
  TRADING_PLATFORM_ID int NOT NULL,
  EXTERNAL_ORDER_ID varchar(100) NOT NULL,
  PARAMS text,
  XML_ID varchar(255),
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sale_tp_order_order_id_trading_platform_id_external_order_ ON b_sale_tp_order (order_id, trading_platform_id, external_order_id);

CREATE TABLE b_sale_gift_related_data (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DISCOUNT_ID int NOT NULL,
  ELEMENT_ID int,
  SECTION_ID int,
  MAIN_PRODUCT_SECTION_ID int,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_gift_related_data_discount_id ON b_sale_gift_related_data (discount_id);
CREATE INDEX ix_b_sale_gift_related_data_main_product_section_id ON b_sale_gift_related_data (main_product_section_id);

CREATE TABLE b_sale_pay_system_err_log (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  MESSAGE text NOT NULL,
  DATE_INSERT timestamp NOT NULL,
  PRIMARY KEY (ID)
);

CREATE TABLE b_sale_yandex_settings (
  SHOP_ID int NOT NULL,
  CSR text,
  SIGN text,
  CERT text,
  PKEY text,
  PUB_KEY text,
  PRIMARY KEY (SHOP_ID)
);

CREATE TABLE b_sale_hdaln (
  LOCATION_ID int NOT NULL,
  LEFT_MARGIN int NOT NULL,
  RIGHT_MARGIN int NOT NULL,
  NAME varchar(100) NOT NULL,
  PRIMARY KEY (LOCATION_ID)
);
CREATE INDEX ix_b_sale_hdaln_name ON b_sale_hdaln (name);

CREATE TABLE b_sale_entity_marker (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ORDER_ID int NOT NULL,
  ENTITY_TYPE varchar(25) NOT NULL,
  ENTITY_ID int NOT NULL,
  TYPE varchar(10) NOT NULL,
  CODE varchar(255) NOT NULL,
  MESSAGE varchar(255) NOT NULL,
  COMMENT varchar(500) DEFAULT null,
  USER_ID int DEFAULT null,
  DATE_CREATE timestamp DEFAULT null,
  DATE_UPDATE timestamp DEFAULT null,
  SUCCESS char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_entity_marker_type ON b_sale_entity_marker (type);
CREATE INDEX ix_b_sale_entity_marker_entity_type ON b_sale_entity_marker (entity_type);

CREATE TABLE b_sale_tp_vk_profile (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DESCRIPTION varchar(255) NOT NULL,
  PLATFORM_ID int NOT NULL,
  VK_SETTINGS text,
  EXPORT_SETTINGS text,
  OAUTH text,
  PROCESS text,
  JOURNAL text,
  PRIMARY KEY (ID)
);

CREATE TABLE b_sale_tp_vk_log (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  EXPORT_ID int NOT NULL,
  ERROR_CODE varchar(255),
  ITEM_ID varchar(255),
  TIME timestamp,
  ERROR_PARAMS text,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sale_tp_vk_log_id_export_id_error_code ON b_sale_tp_vk_log (id, export_id, error_code);

CREATE TABLE b_sale_order_archive (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  LID char(2) NOT NULL,
  ORDER_ID int NOT NULL,
  ACCOUNT_NUMBER varchar(100) NOT NULL,
  DATE_INSERT timestamp NOT NULL,
  PERSON_TYPE_ID int NOT NULL,
  USER_ID int NOT NULL,
  STATUS_ID varchar(2) NOT NULL,
  PAYED char(1) NOT NULL DEFAULT 'N',
  DEDUCTED char(1) NOT NULL DEFAULT 'N',
  CANCELED char(1) NOT NULL DEFAULT 'N',
  PRICE decimal NOT NULL,
  SUM_PAID decimal,
  CURRENCY char(3) NOT NULL,
  XML_ID varchar(255),
  ID_1C varchar(36),
  ORDER_DATA text,
  RESPONSIBLE_ID int,
  COMPANY_ID int,
  VERSION int NOT NULL,
  DATE_ARCHIVED timestamp NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_order_archive_user_id ON b_sale_order_archive (user_id);
CREATE INDEX ix_b_sale_order_archive_status_id ON b_sale_order_archive (status_id);
CREATE INDEX ix_b_sale_order_archive_date_insert ON b_sale_order_archive (date_insert);
CREATE INDEX ix_b_sale_order_archive_date_archived ON b_sale_order_archive (date_archived);
CREATE INDEX ix_b_sale_order_archive_xml_id ON b_sale_order_archive (xml_id);
CREATE INDEX ix_b_sale_order_archive_id_1c ON b_sale_order_archive (id_1c);
CREATE INDEX ix_b_sale_order_archive_responsible_id ON b_sale_order_archive (responsible_id);
CREATE INDEX ix_b_sale_order_archive_company_id ON b_sale_order_archive (company_id);
CREATE INDEX ix_b_sale_order_archive_order_id ON b_sale_order_archive (order_id);
CREATE INDEX ix_b_sale_order_archive_account_number ON b_sale_order_archive (account_number);

CREATE TABLE b_sale_order_archive_packed (
  ORDER_ARCHIVE_ID int NOT NULL,
  ORDER_DATA text,
  PRIMARY KEY (ORDER_ARCHIVE_ID)
);

CREATE TABLE b_sale_basket_archive (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ARCHIVE_ID int NOT NULL,
  PRODUCT_ID int NOT NULL,
  PRODUCT_PRICE_ID int,
  NAME varchar(255) NOT NULL,
  PRICE decimal,
  CURRENCY char(3),
  QUANTITY double precision,
  WEIGHT double precision,
  DATE_INSERT timestamp NOT NULL,
  MODULE varchar(100),
  PRODUCT_XML_ID varchar(100),
  TYPE int,
  SET_PARENT_ID int,
  MEASURE_CODE int,
  MEASURE_NAME varchar(50),
  BASKET_DATA text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_basket_archive_product_id ON b_sale_basket_archive (product_id);
CREATE INDEX ix_b_sale_basket_archive_archive_id ON b_sale_basket_archive (archive_id);

CREATE TABLE b_sale_basket_archive_packed (
  BASKET_ARCHIVE_ID int NOT NULL,
  BASKET_DATA text,
  PRIMARY KEY (BASKET_ARCHIVE_ID)
);

CREATE TABLE b_sale_company_group (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  COMPANY_ID int NOT NULL,
  GROUP_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_company_group_company_id ON b_sale_company_group (company_id);

CREATE TABLE b_sale_company_resp_grp (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  COMPANY_ID int NOT NULL,
  GROUP_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_company_resp_grp_company_id ON b_sale_company_resp_grp (company_id);

CREATE TABLE b_sale_cashbox (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  NAME varchar(255) NOT NULL,
  HANDLER varchar(255) NOT NULL,
  EMAIL varchar(255) NOT NULL,
  DATE_CREATE timestamp NOT NULL,
  DATE_LAST_CHECK timestamp,
  SORT int DEFAULT 100,
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  USE_OFFLINE char(1) NOT NULL DEFAULT 'N',
  ENABLED char(1) NOT NULL DEFAULT 'N',
  KKM_ID varchar(255),
  OFD varchar(255),
  OFD_SETTINGS text,
  NUMBER_KKM varchar(64),
  SETTINGS text,
  PRIMARY KEY (ID)
);

CREATE TABLE b_sale_cashbox_err_log (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CASHBOX_ID int,
  DATE_INSERT timestamp NOT NULL,
  MESSAGE text,
  PRIMARY KEY (ID)
);

CREATE TABLE b_sale_cashbox_check (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CASHBOX_ID int,
  EXTERNAL_UUID varchar(100),
  PAYMENT_ID int,
  SHIPMENT_ID int,
  CNT_FAIL_PRINT int DEFAULT 0,
  ORDER_ID int,
  DATE_CREATE timestamp NOT NULL,
  DATE_PRINT_START timestamp,
  DATE_PRINT_END timestamp,
  SUM decimal,
  CURRENCY char(3),
  STATUS char(1) NOT NULL DEFAULT 'N',
  TYPE varchar(255) NOT NULL,
  ENTITY_REGISTRY_TYPE varchar(255) NOT NULL,
  LINK_PARAMS text,
  ERROR_MESSAGE text DEFAULT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_cashbox_check_order_id ON b_sale_cashbox_check (order_id);
CREATE INDEX ix_b_sale_cashbox_check_payment_id ON b_sale_cashbox_check (payment_id);
CREATE INDEX ix_b_sale_cashbox_check_shipment_id ON b_sale_cashbox_check (shipment_id);
CREATE INDEX ix_b_sale_cashbox_check_status ON b_sale_cashbox_check (status);

CREATE TABLE b_sale_cashbox_check_correction (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CHECK_ID int NOT NULL,
  CORRECTION_TYPE varchar(50) NOT NULL,
  DOCUMENT_NUMBER varchar(35) NOT NULL,
  DOCUMENT_DATE date NOT NULL,
  DESCRIPTION varchar(255) DEFAULT '',
  CORRECTION_PAYMENT text DEFAULT '',
  CORRECTION_VAT text DEFAULT '',
  PRIMARY KEY (ID)
);

CREATE TABLE b_sale_check2cashbox (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CHECK_ID int NOT NULL,
  CASHBOX_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sale_check2cashbox_check_id_cashbox_id ON b_sale_check2cashbox (check_id, cashbox_id);

CREATE TABLE b_sale_cashbox_z_report (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CASHBOX_ID int NOT NULL,
  DATE_CREATE timestamp NOT NULL,
  DATE_PRINT_START timestamp,
  DATE_PRINT_END timestamp,
  CASH_SUM decimal,
  CASHLESS_SUM decimal,
  CUMULATIVE_SUM decimal,
  RETURNED_SUM decimal,
  STATUS char(1) NOT NULL DEFAULT 'N',
  CNT_FAIL_PRINT int DEFAULT 0,
  LINK_PARAMS text,
  CURRENCY char(3),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_cashbox_z_report_cashbox_id ON b_sale_cashbox_z_report (cashbox_id);

CREATE TABLE b_sale_cashbox_connect (
  HASH varchar(100) NOT NULL,
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  DATE_CREATE timestamp NOT NULL,
  PRIMARY KEY (HASH)
);

CREATE TABLE b_sale_buyer_stat (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int NOT NULL,
  LID char(2) NOT NULL,
  CURRENCY char(3) NOT NULL,
  LAST_ORDER_DATE timestamp NOT NULL,
  COUNT_FULL_PAID_ORDER int,
  COUNT_PART_PAID_ORDER int,
  SUM_PAID decimal,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_buyer_stat_currency_lid_user_id ON b_sale_buyer_stat (currency, lid, user_id);
CREATE INDEX ix_b_sale_buyer_stat_user_id ON b_sale_buyer_stat (user_id);
CREATE INDEX ix_b_sale_buyer_stat_last_order_date ON b_sale_buyer_stat (last_order_date);
CREATE INDEX ix_b_sale_buyer_stat_count_full_paid_order ON b_sale_buyer_stat (count_full_paid_order);
CREATE INDEX ix_b_sale_buyer_stat_count_part_paid_order ON b_sale_buyer_stat (count_part_paid_order);
CREATE INDEX ix_b_sale_buyer_stat_sum_paid ON b_sale_buyer_stat (sum_paid);

CREATE TABLE b_sale_delivery_req (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE timestamp DEFAULT CURRENT_TIMESTAMP,
  DELIVERY_ID int NOT NULL,
  STATUS int,
  CREATED_BY int,
  EXTERNAL_ID varchar(100) NOT NULL,
  EXTERNAL_STATUS varchar(255) DEFAULT NULL,
  EXTERNAL_STATUS_SEMANTIC varchar(50) DEFAULT NULL,
  EXTERNAL_PROPERTIES text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_delivery_req_delivery_id_external_id ON b_sale_delivery_req (delivery_id, external_id);

CREATE TABLE b_sale_delivery_req_shp (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  SHIPMENT_ID int NOT NULL,
  REQUEST_ID int,
  EXTERNAL_ID varchar(50),
  ERROR_DESCRIPTION varchar(2048),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_delivery_req_shp_request_id_external_id ON b_sale_delivery_req_shp (request_id, external_id);

CREATE TABLE b_sale_check_related_entities (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CHECK_ID int NOT NULL,
  ENTITY_ID int NOT NULL,
  ENTITY_TYPE char(1) NOT NULL,
  ENTITY_CHECK_TYPE varchar(50),
  PRIMARY KEY (ID)
);

CREATE TABLE b_sale_exchange_log (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_ID int NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  PARENT_ID int DEFAULT NULL,
  OWNER_ENTITY_ID int DEFAULT NULL,
  ENTITY_DATE_UPDATE timestamp DEFAULT NULL,
  XML_ID varchar(50) DEFAULT NULL,
  MARKED varchar(1) DEFAULT NULL,
  DESCRIPTION text,
  MESSAGE text,
  DATE_INSERT timestamp DEFAULT NULL,
  DIRECTION varchar(1) NOT NULL,
  PROVIDER varchar(50) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_exchange_log_entity_id_entity_type_id ON b_sale_exchange_log (entity_id, entity_type_id);
CREATE INDEX ix_b_sale_exchange_log_entity_date_update ON b_sale_exchange_log (entity_date_update);
CREATE INDEX ix_b_sale_exchange_log_date_insert ON b_sale_exchange_log (date_insert);

CREATE TABLE b_sale_synchronizer_log (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  MESSAGE_ID text,
  MESSAGE text,
  DATE_INSERT timestamp DEFAULT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_synchronizer_log_date_insert ON b_sale_synchronizer_log (date_insert);

CREATE TABLE b_sale_order_converter_crm_error (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ORDER_ID int NOT NULL,
  ERROR text,
  PRIMARY KEY (ID)
);

CREATE TABLE b_sale_usergroup_restr (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_ID int NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  GROUP_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_usergroup_restr_entity_type_id_entity_id_group_id ON b_sale_usergroup_restr (entity_type_id, entity_id, group_id);

CREATE TABLE b_sale_documentgenerator_callback_registry (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_INSERT timestamp NOT NULL,
  MODULE_ID varchar(50) NOT NULL,
  DOCUMENT_ID int NOT NULL,
  CALLBACK_CLASS varchar(100) NOT NULL,
  CALLBACK_METHOD varchar(100) NOT NULL,
  PRIMARY KEY (ID)
);

CREATE TABLE b_sale_order_entities_custom_fields (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_ID int NOT NULL,
  ENTITY_TYPE varchar(25) NOT NULL,
  ENTITY_REGISTRY_TYPE varchar(15) NOT NULL,
  FIELD varchar(25) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_order_entities_custom_fields_entity_id_entity_type_en ON b_sale_order_entities_custom_fields (entity_id, entity_type, entity_registry_type);

CREATE TABLE b_sale_domain_verification (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DOMAIN varchar(255) NOT NULL,
  PATH varchar(255) NOT NULL,
  CONTENT text,
  ENTITY varchar(1024) NOT NULL,
  PRIMARY KEY (ID)
);

CREATE TABLE b_sale_b24integration_bind (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  SRC_ENTITY_TYPE_ID int8 NOT NULL,
  SRC_ENTITY_ID int8 NOT NULL,
  DST_ENTITY_TYPE_ID int8 NOT NULL,
  DST_ENTITY_ID int8 NOT NULL,
  CREATED_TIME timestamp,
  LAST_UPDATED_TIME timestamp,
  PRIMARY KEY (SRC_ENTITY_TYPE_ID, SRC_ENTITY_ID, DST_ENTITY_TYPE_ID, DST_ENTITY_ID)
);
CREATE INDEX ix_b_sale_b24integration_bind_id ON b_sale_b24integration_bind (id);

CREATE TABLE b_sale_b24integration_relation (
  SRC_ENTITY_TYPE_ID int8 NOT NULL,
  SRC_ENTITY_ID int8 NOT NULL,
  DST_ENTITY_TYPE_ID int8 NOT NULL,
  DST_ENTITY_ID int8 NOT NULL,
  CREATED_TIME timestamp DEFAULT NULL,
  LAST_UPDATED_TIME timestamp DEFAULT NULL,
  PRIMARY KEY (SRC_ENTITY_ID, DST_ENTITY_TYPE_ID, SRC_ENTITY_TYPE_ID)
);

CREATE TABLE b_sale_b24integration_token (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  GUID varchar(100) NOT NULL,
  ACCESS_TOKEN varchar(100) NOT NULL,
  REFRESH_TOKEN varchar(100) NOT NULL,
  REST_ENDPOINT varchar(255) NOT NULL,
  PORTAL_ID varchar(100) NOT NULL,
  CREATED timestamp NOT NULL,
  CHANGED timestamp NOT NULL,
  EXPIRES timestamp NOT NULL,
  PRIMARY KEY (ID)
);

CREATE TABLE b_sale_delivery_rest_handler (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  NAME varchar(255) NOT NULL,
  CODE varchar(50) NOT NULL,
  SORT int NOT NULL DEFAULT '100',
  DESCRIPTION text,
  SETTINGS text NOT NULL,
  PROFILES text NOT NULL,
  APP_ID varchar(128),
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sale_delivery_rest_handler_code ON b_sale_delivery_rest_handler (code);

CREATE TABLE b_sale_b24integration_stat_provider (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  NAME varchar(255) NOT NULL DEFAULT '',
  EXTERNAL_SERVER_HOST varchar(255) NOT NULL DEFAULT '',
  XML_ID varchar(255) NOT NULL DEFAULT '',
  TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  SETTINGS text DEFAULT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sale_b24integration_stat_provider_xml_id ON b_sale_b24integration_stat_provider (xml_id);

CREATE TABLE b_sale_b24integration_stat (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  ENTITY_ID int NOT NULL,
  DATE_UPDATE timestamp NOT NULL,
  PROVIDER_ID int NOT NULL,
  CURRENCY char(3) NOT NULL,
  STATUS char(1) NOT NULL,
  XML_ID varchar(255) NOT NULL DEFAULT '',
  AMOUNT decimal NOT NULL,
  TIMESTAMP_X timestamp DEFAULT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sale_b24integration_stat_entity_id_entity_type_id_provider ON b_sale_b24integration_stat (entity_id, entity_type_id, provider_id);

CREATE TABLE b_sale_cashbox_rest_handler (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  NAME varchar(255) NOT NULL,
  CODE varchar(50) NOT NULL,
  SORT int NOT NULL DEFAULT '100',
  SETTINGS text NOT NULL,
  APP_ID varchar(128),
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sale_cashbox_rest_handler_code ON b_sale_cashbox_rest_handler (code);

CREATE TABLE b_sale_delivery_yandex_taxi_claims (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CREATED_AT timestamp NOT NULL,
  UPDATED_AT timestamp NOT NULL,
  FURTHER_CHANGES_EXPECTED char(1) NOT NULL DEFAULT 'Y',
  SHIPMENT_ID int NOT NULL,
  INITIAL_CLAIM text NOT NULL,
  EXTERNAL_ID varchar(255) NOT NULL,
  EXTERNAL_STATUS varchar(255) NOT NULL,
  EXTERNAL_RESOLUTION varchar(20) DEFAULT NULL,
  EXTERNAL_CREATED_TS varchar(255) NOT NULL,
  EXTERNAL_UPDATED_TS varchar(255) NOT NULL,
  EXTERNAL_CURRENCY char(3) DEFAULT NULL,
  EXTERNAL_FINAL_PRICE decimal DEFAULT NULL,
  IS_SANDBOX_ORDER char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_sale_delivery_yandex_taxi_claims_external_id ON b_sale_delivery_yandex_taxi_claims (external_id);
CREATE INDEX ix_b_sale_delivery_yandex_taxi_claims_further_changes_expected ON b_sale_delivery_yandex_taxi_claims (further_changes_expected);
CREATE INDEX ix_b_sale_delivery_yandex_taxi_claims_created_at_is_sandbox_ord ON b_sale_delivery_yandex_taxi_claims (created_at, is_sandbox_order);

CREATE TABLE b_sale_basket_reservation (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  QUANTITY double precision NOT NULL,
  DATE_RESERVE timestamp NOT NULL,
  DATE_RESERVE_END timestamp NOT NULL,
  RESERVED_BY int8,
  BASKET_ID int8 NOT NULL,
  STORE_ID int8,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_basket_reservation_basket_id ON b_sale_basket_reservation (basket_id);

CREATE TABLE b_sale_facebook_conversion_params (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  EVENT_NAME varchar(50) NOT NULL,
  LID char(2) NOT NULL,
  ENABLED char(1) NOT NULL,
  PARAMS varchar(500) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_facebook_conversion_params_event_name_lid ON b_sale_facebook_conversion_params (event_name, lid);

CREATE TABLE b_sale_analytics (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CODE varchar(255) NOT NULL,
  CREATED_AT timestamp NOT NULL,
  PAYLOAD text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_analytics_created_at ON b_sale_analytics (created_at);
CREATE INDEX ix_b_sale_analytics_code_created_at ON b_sale_analytics (code, created_at);

CREATE TABLE b_sale_order_payment_ps_available (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  PAYMENT_ID int NOT NULL,
  PAY_SYSTEM_ID int NOT NULL
);
CREATE INDEX ix_b_sale_order_payment_ps_available_payment_id ON b_sale_order_payment_ps_available (payment_id);

CREATE TABLE b_sale_basket_reservation_history (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  RESERVATION_ID int NOT NULL,
  DATE_RESERVE timestamp NOT NULL,
  QUANTITY real NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sale_basket_reservation_history_reservation_id ON b_sale_basket_reservation_history (reservation_id);

CREATE TABLE b_sale_entity_label (
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	ENTITY_ID int NOT NULL,
	ENTITY_TYPE varchar(255) NOT NULL,
	LABEL_NAME varchar(255) NOT NULL,
	LABEL_VALUE text,
	PRIMARY KEY (ID)
);
CREATE INDEX IX_SALE_LABEL_ENTITY_ID_ENTITY_TYPE ON b_sale_entity_label (entity_id, entity_type);
CREATE UNIQUE INDEX IX_SALE_LABEL_ENTITY_ID_ENTITY_TYPE_LABEL_NAME ON b_sale_entity_label (entity_id, entity_type, label_name);
