(function(){"use strict";BX.namespace("BX.Translate");if(BX.Translate.Editor){return}var e=function(){this.id="";this.tabId="";this.filePath="";this.linkBack="";this.editLink="";this.messages={};this.viewMode="";this.viewModeMenu=[];this.extraMenu=[];this.deleteMenu=[];this.mode="";this.controller="";this.action="";this.params={};this.xhr=null};e.prototype.VIEW_MODE={ShowAll:"ShowAll",Untranslated:"Untranslated",SourceEdit:"SourceEdit",SourceView:"SourceView"};e.prototype.STATES={intermediate:"INTERMEDIATE",running:"RUNNING",error:"ERROR"};e.prototype.STYLES={editor:"translate-edit",fade:"translate-edit-fade",editRow:"translate-edit-row",editRowPhrase:"phrase",editRowHighlight:"highlight",editArea:"translate-edit-area",editable:"editable",eraser:"eraser",eraserLabel:"eraser-label",errorLess:"error-less",errorMore:"error-more",menuItemChecked:"menu-popup-item-accept",delete:"delete",errorPhrase:"error-phrase"};e.prototype.init=function(e){e=e||{};if(!BX.type.isNotEmptyString(e.tabId))throw"BX.Translate.Editor: 'tabId' parameter missing.";if(!BX.type.isNotEmptyString(e.filePath))throw"BX.Translate.Editor: 'filePath' parameter missing.";if(!BX.type.isNotEmptyString(e.editLink))throw"BX.Translate.Editor: 'editLink' parameter missing.";if(!BX.type.isNotEmptyString(e.linkBack))throw"BX.Translate.Editor: 'linkBack' parameter missing.";if(BX.type.isNotEmptyString(e.mode)){this.mode=e.mode}this.filePath=e.filePath;this.editLink=e.editLink;this.linkBack=e.linkBack;this.tabId=e.tabId;this.id=e.id||"bx-translate-editor-"+this.tabId;if(!BX.type.isNotEmptyString(e.controller)){throw"BX.Translate.Editor: Could not find ajax controller endpoint."}this.controller=e.controller;this.param=e.param||{};if(!BX.type.isNotEmptyString(e.viewMode)){this.viewMode=e.viewMode}else{this.viewMode=this.VIEW_MODE.ShowAll}this.viewModeMenu=e.viewModeMenu;this.extraMenu=e.extraMenu;this.deleteMenu=e.deleteMenu;if(BX.type.isPlainObject(e.messages)){this.messages=e.messages}if(BX.type.isPlainObject(e.messages)){this.messages=e.messages}var t=BX("bx-translate-mode-menu-view-anchor");if(t){BX.bind(t,"click",BX.proxy(this.showViewModeMenu,this))}var i=BX("bx-translate-extra-menu-anchor");if(i){BX.bind(i,"click",BX.proxy(this.showExtraMenu,this))}if(this.getForm()){var r=this.getForm().querySelectorAll("."+this.STYLES.editable);if(r){r.forEach(BX.proxy((function(e){BX.bind(e,"focus",BX.delegate(this.showEditArea,this))}),this))}var s=BX("bx-translate-delete-menu-anchor");if(s){BX.bind(s,"click",BX.proxy(this.showDeleteMenu,this))}r=this.getForm().querySelectorAll("."+this.STYLES.eraserLabel);if(r){r.forEach(BX.proxy((function(e){BX.bind(e,"keydown",(function(e){var t=e.currentTarget;var i=e.keyCode?e.keyCode:e.which?e.which:null;if(!!t&&i===32){e.stopPropagation();e.preventDefault();if(document.createEvent){var r=document.createEvent("MouseEvents");r.initEvent("click",true,false);t.dispatchEvent(r)}else if(document.createEventObject){t.fireEvent("onclick")}else if(typeof t.onclick=="function"){t.onclick()}return false}return true}))}),this))}r=this.getForm().querySelectorAll("."+this.STYLES.eraser);if(r){r.forEach(BX.proxy((function(e){BX.bind(e,"change",BX.proxy((function(e){var t=e.currentTarget,i=BX.data(t,"code"),r=t.checked;var s=this.getForm().querySelectorAll("."+this.STYLES.editRow+"."+this.STYLES.editRowPhrase+"[rel='"+i+"']");if(s){s.forEach(BX.proxy((function(e){if(r){BX.addClass(e,this.STYLES.delete)}else{BX.removeClass(e,this.STYLES.delete)}}),this))}return true}),this))}),this))}}BX.Event.EventEmitter.subscribe(BX.UI.StepProcessing.ProcessEvent.BeforeRequest,BX.delegate((function(e){var t=e.data.process?e.data.process:{};var i=e.data.actionData?e.data.actionData:{};if(t instanceof BX.UI.StepProcessing.Process){t.setParam("file",this.getCurrentPath());t.method="POST"}if(i instanceof FormData){i.append("file",this.getCurrentPath());i.append("tabId",this.tabId);i.append("AJAX_CALL","Y");if(this.mode=="admin"){i.append("admin_section","Y");i.append("lang",BX.message("LANGUAGE_ID"))}}else{i["file"]=this.getCurrentPath();i["tabId"]=this.tabId;i["AJAX_CALL"]="Y";if(this.mode=="admin"){i["admin_section"]="Y";i["lang"]=BX.message("LANGUAGE_ID")}}}),this));var a="";if(BX.type.isNotEmptyString(e.highlightPhrase)){a=e.highlightPhrase}else if(BX.type.isNotEmptyString(window.location.hash)){a=window.location.hash.replace(/#/g,"")}if(a!=""){var n=a.replace(/[^a-z1-9_]+/gi,""),o=this.getForm().querySelector("[name='"+a+"']");if(o){o.scrollIntoView({behavior:"smooth",block:"start"})}r=this.getForm().querySelectorAll("."+this.STYLES.editRow+"."+this.STYLES.editRowPhrase+"[rel='"+n+"']");if(r){r.forEach(BX.proxy((function(e){BX.addClass(e,this.STYLES.editRowHighlight)}),this))}}};e.prototype.toggleDelete=function(e){var t,i,r,a,n,o=s.getMenuItems();i=false;for(a in o){if(!o.hasOwnProperty(a))continue;n=o[a];if(n.id=="translate-delete-"+e){i=BX.hasClass(n.layout.item,this.STYLES.menuItemChecked);if(i){BX.removeClass(n.layout.item,this.STYLES.menuItemChecked)}else{BX.addClass(n.layout.item,this.STYLES.menuItemChecked)}}else{BX.removeClass(n.layout.item,this.STYLES.menuItemChecked)}}t="";if(i){r=false}else if(e=="all"){r=true}else if(e=="ethalon"){t=this.STYLES.errorMore;r=true}var h=this.getForm().querySelectorAll("input."+this.STYLES.eraser);if(h){h.forEach(BX.proxy((function(e){if(t!=""){if(BX.hasClass(e,t)){e.checked=r}else{e.checked=false}}else{e.checked=r}if(document.createEvent){var i=document.createEvent("HTMLEvents");i.initEvent("change",true,false);e.dispatchEvent(i)}else if(document.createEventObject){e.fireEvent("onchange")}else if(typeof e.onchange=="function"){e.onchange()}}),this))}if(s){s.close()}};e.prototype.showEditArea=function(e){var t=e.currentTarget;if(t){var i=BX.data(t,"fld"),r=BX.data(t,"lng"),s=parseInt(BX.data(t,"length")),a=parseInt(BX.data(t,"lines")),n=BX.data(t,"code");a=a?a:1;a++;if(s>100&&Math.round(s/100)>a){a=Math.round(s/100)+1}if(a>10){a=10}var o=BX.create("TEXTAREA",{attrs:{className:this.STYLES.editArea,cols:60,rows:a,name:i,tabIndex:t.tabIndex,value:t.innerText},text:"",dataset:{fld:i,lng:r,code:n}});var h=BX.create("DIV",{attrs:{className:"value edit"},children:[o]});BX.insertAfter(h,t);BX.hide(t);o.value=t.innerText;o.focus();t.removeAttribute("tabIndex")}};e.prototype.cancel=function(){if(this.getForm()){var e=this.getForm().querySelectorAll("."+this.STYLES.editArea);if(BX.type.isArray(e)){e.forEach((function(e){BX.remove(e.parentNode)}))}e=this.getForm().querySelectorAll("."+this.STYLES.editable);if(BX.type.isArray(e)){e.forEach((function(e){BX.show(e)}))}}this.fade();window.location=this.linkBack};e.prototype.save=function(e){if(this.getState()===this.STATES.running){return}this.setState(this.STATES.running);this.setAction("save");var t=BX.clone(this.params);t["file"]=this.getCurrentPath();t["tabId"]=this.tabId;t["AJAX_CALL"]="Y";if(this.mode=="admin"){t["admin_section"]="Y";t["lang"]=BX.message("LANGUAGE_ID")}t["KEYS"]=[];t["DROP"]=[];t["LANGS"]=[];var i=this.getForm();for(var r=0,s=i.elements.length,a,n;r<s;r++){var o=i.elements[r];if(o.disabled)continue;switch(o.type.toLowerCase()){case"textarea":if(o.className.indexOf(this.STYLES.editArea)<0){break}a=BX.data(o,"code");if(t["KEYS"].indexOf(a)===-1){t["KEYS"].push(a)}n=BX.data(o,"lng");if(t["LANGS"].indexOf(n)===-1){t["LANGS"].push(n)}t[o.name]=o.value;break;case"checkbox":if(o.checked){a=BX.data(o,"code");if(t["DROP"].indexOf(a)===-1){t["DROP"].push(a)}}break;default:}}this.fade();BX.ajax.runAction(this.getController()+"."+this.getAction(),{data:t,method:"POST",onrequeststart:BX.delegate(this.onRequestStart,this)}).then(BX.delegate(this.onRequestSuccess,this),BX.delegate(this.onRequestFailure,this)).then(BX.delegate((function(t){if(e===true){window.location=this.linkBack}else{window.location=this.editLink}}),this))};e.prototype.saveSource=function(e){if(this.getState()===this.STATES.running){return}this.setState(this.STATES.running);this.setAction("savesource");var t=BX.clone(this.params);t["file"]=this.getCurrentPath();t["tabId"]=this.tabId;t["AJAX_CALL"]="Y";if(this.mode=="admin"){t["admin_section"]="Y";t["lang"]=BX.message("LANGUAGE_ID")}t["LANGS"]=[];var i=this.getForm();for(var r=0,s=i.elements.length,a,n;r<s;r++){var o=i.elements[r];if(o.disabled)continue;switch(o.type.toLowerCase()){case"textarea":if(o.className.indexOf(this.STYLES.editArea)<0){break}n=BX.data(o,"lng");if(t["LANGS"].indexOf(n)===-1){t["LANGS"].push(n)}t[o.name]=o.value;break;default:}}this.fade();BX.ajax.runAction(this.getController()+"."+this.getAction(),{data:t,method:"POST",onrequeststart:BX.delegate(this.onRequestStart,this)}).then(BX.delegate(this.onRequestSuccess,this),BX.delegate(this.onRequestFailure,this)).then(BX.delegate((function(t){if(e===true){window.location=this.linkBack}else{window.location=this.editLink}}),this))};e.prototype.onRequestStart=function(e){this.xhr=e};e.prototype.onRequestSuccess=function(e){this.xhr=null;if(!e){BX.UI.Notification.Center.notify({content:this.getMessage("RequestError")});this.setState(this.STATES.error);return}if(BX.type.isArray(e["errors"])&&e["errors"].length>0){var t=e["errors"][e["errors"].length-1];BX.UI.Notification.Center.notify({content:t.message});this.setState(this.STATES.error);return}var i=e["data"];var r=BX.type.isNotEmptyString(i["SUMMARY"])?i["SUMMARY"]:"";if(r!==""){BX.UI.Notification.Center.notify({content:r})}else{BX.UI.Notification.Center.notify({content:this.getMessage("RequestCompleted")})}this.setState(this.STATES.intermediate);return e};e.prototype.onRequestFailure=function(e){this.unFade();if(BX.type.isArray(e["errors"])&&e["errors"].length>0){var t=e["errors"][e["errors"].length-1];BX.UI.Notification.Center.notify({content:t.message});if(t.code&&(t.code==="ERROR_PHP_TOKEN_PHRASE"||t.code==="ERROR_PHP_TOKEN_CODE")&&t.customData&&t.customData.phraseId){var i=this.getForm().querySelectorAll("."+this.STYLES.editRow+"."+this.STYLES.editRowPhrase+"[rel='"+t.customData.phraseId+"']");if(i){i.forEach(BX.proxy((function(e){BX.addClass(e,this.STYLES.errorPhrase)}),this))}}}else{BX.UI.Notification.Center.notify({content:this.getMessage("RequestError")})}this.xhr=null;this.setState(this.STATES.error);var r=BX("ui-button-panel").querySelectorAll(".ui-btn-wait");if(r){r.forEach((function(e){BX.removeClass(e,"ui-btn-wait")}))}};e.prototype.setState=function(e){if(this.state===e){return}this.state=e};e.prototype.getState=function(){return this.state};e.prototype.getController=function(){return this.controller};e.prototype.setController=function(e){this.controller=e};e.prototype.getAction=function(){return this.action};e.prototype.setAction=function(e){this.action=e};e.prototype.getId=function(){return this.id};e.prototype.setId=function(e){this.id=e};e.prototype.getParams=function(){return this.params};e.prototype.getParam=function(e){return this.params[e]?this.params[e]:null};e.prototype.setParam=function(e,t){this.params[e]=t};e.prototype.getForm=function(){return BX(this.getId())};e.prototype.getContainer=function(){return this.getForm().querySelector("."+this.STYLES.editor)};e.prototype.getMessage=function(e){return BX.type.isNotEmptyString(this.messages[e])?this.messages[e]:""};e.prototype.getCurrentPath=function(){return this.filePath};var t;e.prototype.fade=function(){if(!(t instanceof BX.Loader)){t=new BX.Loader({target:this.getForm()})}BX.addClass(this.getContainer(),this.STYLES.fade);t.show();BX.onCustomEvent("Grid::disabled",[this])};e.prototype.unFade=function(){BX.removeClass(this.getContainer(),this.STYLES.fade);t.hide()};var i;e.prototype.showViewModeMenu=function(e){var t=e.currentTarget;if(!i){i=new BX.PopupMenuWindow("translate-view-mode-menu",t,this.viewModeMenu,{autoHide:true,autoClose:true,closeByEsc:true})}i.bindElement=t;i.show()};var r;e.prototype.showExtraMenu=function(e){var t=e.currentTarget;if(!r){r=new BX.PopupMenuWindow("translate-extra-menu",t,this.extraMenu,{autoHide:true,autoClose:true,closeByEsc:true})}r.bindElement=t;r.show()};var s;e.prototype.showDeleteMenu=function(e){var t=e.currentTarget;if(!s){s=new BX.PopupMenuWindow("translate-delete-menu",t,this.deleteMenu,{autoHide:true,autoClose:true,closeByEsc:true})}s.bindElement=t;s.show()};BX.Translate.Editor=new e})(window);
//# sourceMappingURL=script.map.js