(function(){"use strict";BX.namespace("BX.Translate");if(BX.Translate.ProcessDialog){return}BX.Translate.ProcessDialog=function(){this.id="";this.settings={};this.optionsFieldsBlock=null;this.popupWindow=null;this.isShown=false;this.buttons={};this.summaryBlock=null;this.error=null;this.errorBlock=null;this.warningBlock=null;this.progressBar=null;this.progressBarBlock=null;this.messages={};this.handlers={}};BX.Translate.ProcessDialog.prototype={STYLES:{dialogProcessWindow:"bx-translate-dialog-process",dialogProcessPopup:"bx-translate-dialog-process-popup",dialogProcessSummary:"bx-translate-dialog-process-summary",dialogProcessProgressbar:"bx-translate-dialog-process-progressbar",dialogProcessOptions:"bx-translate-dialog-process-options",dialogProcessOptionsTitle:"bx-translate-dialog-process-options-title",dialogProcessOptionsInput:"bx-translate-dialog-process-options-input",dialogProcessOptionsObligatory:"ui-alert ui-alert-xs ui-alert-warning",dialogProcessOptionText:"bx-translate-dialog-process-option-text",dialogButtonAccept:"popup-window-button-accept",dialogButtonDisable:"popup-window-button-disable",dialogButtonCancel:"popup-window-button-link-cancel",dialogButtonDownload:"ui-btn ui-btn-sm ui-btn-success ui-btn-icon-download",dialogButtonRemove:"ui-btn ui-btn-sm ui-btn-default ui-btn-icon-remove"},init:function(t){this.settings=t?t:{};this.id=BX.type.isNotEmptyString(this.settings.id)?this.settings.id:"TranslateProcessDialog_"+Math.random().toString().substring(2);this.messages=this.getSetting("messages");if(!this.messages){this.messages={}}var e=this.getSetting("optionsFields");if(!e){this.setSetting("optionsFields",{})}var s=this.getSetting("optionsFieldsValue");if(!s){this.setSetting("optionsFieldsValue",{})}var i=this.getSetting("showButtons");if(!i){this.setSetting("showButtons",{start:true,stop:true,close:true})}if(typeof BX.UI!="undefined"&&typeof BX.UI.ProgressBar!="undefined"){this.progressBar=new BX.UI.ProgressBar({statusType:BX.UI.ProgressBar.Status.COUNTER,size:BX.UI.ProgressBar.Size.LARGE,fill:true})}this.handlers=this.getSetting("handlers");if(!this.handlers){this.handlers={}}if(BX.type.isArray(t.styles)){this.STYLES=BX.mergeEx(this.STYLES,t.styles)}},destroy:function(){if(this.popupWindow){this.popupWindow.destroy();this.popupWindow=null}},getId:function(){return this.id},getSetting:function(t,e){return this.settings.hasOwnProperty(t)?this.settings[t]:e},setSetting:function(t,e){this.settings[t]=e;return this},getMessage:function(t){return this.messages&&this.messages.hasOwnProperty(t)?this.messages[t]:""},callHandler:function(t,e){if(typeof this.handlers[t]=="function"){this.handlers[t].apply(this,e)}},setHandler:function(t,e){if(typeof e=="function"){this.handlers[t]=e}return this},show:function(){if(this.isShown){return}this.error=new BX.UI.Alert({color:BX.UI.Alert.Color.DANGER,icon:BX.UI.Alert.Icon.DANGER,size:BX.UI.Alert.Size.SMALL});this.warning=new BX.UI.Alert({color:BX.UI.Alert.Color.WARNING,icon:BX.UI.Alert.Icon.WARNING,size:BX.UI.Alert.Size.SMALL});this.popupWindow=BX.PopupWindowManager.create(this.id.toLowerCase(),null,{className:this.STYLES.dialogProcessWindow,autoHide:false,bindOptions:{forceBindPosition:false},buttons:this.prepareDialogButtons(),closeByEsc:false,closeIcon:false,content:this.prepareDialogContent(),draggable:true,events:{onPopupClose:BX.delegate(this.onDialogClose,this)},offsetLeft:0,offsetTop:0,titleBar:this.getMessage("title"),overlay:true,resizable:true});if(!this.popupWindow.isShown()){this.popupWindow.show()}this.isShown=this.popupWindow.isShown();if(this.isShown){this.callHandler("dialogShown");BX.onCustomEvent(this,"BX.Translate.ProcessDialog.Shown",[this])}return this},close:function(){if(!this.isShown){return}if(this.popupWindow){this.popupWindow.close()}this.isShown=false;this.callHandler("dialogClosed");BX.onCustomEvent(this,"BX.Translate.ProcessDialog.Closed",[this])},start:function(){this.callHandler("start");BX.onCustomEvent(this,"BX.Translate.ProcessDialog.Start",[this])},stop:function(){this.callHandler("stop");BX.onCustomEvent(this,"BX.Translate.ProcessDialog.Stop",[this])},prepareDialogContent:function(){var t=this.getMessage("summary");this.summaryBlock=BX.create("DIV",{attrs:{className:this.STYLES.dialogProcessSummary},html:t});this.errorBlock=this.error.getContainer();this.warningBlock=this.warning.getContainer();this.errorBlock.style.display="none";this.warningBlock.style.display="none";if(this.progressBar){this.progressBarBlock=BX.create("DIV",{attrs:{className:this.STYLES.dialogProcessProgressbar},style:{display:"none"},children:[this.progressBar.getContainer()]})}if(this.optionsFieldsBlock===null){this.optionsFieldsBlock=BX.create("DIV",{attrs:{className:this.STYLES.dialogProcessOptions}})}else{BX.clean(this.optionsFieldsBlock)}var e,s,i,o,a,r,l,n,c=0,h,u,p,d,B;s=this.getSetting("optionsFields",{});i=this.getSetting("optionsFieldsValue",{});for(o in s){if(s.hasOwnProperty(o)){e=s[o];a=i[o]?i[o]:null;if(BX.type.isPlainObject(e)&&e.hasOwnProperty("name")&&e.hasOwnProperty("type")&&e.hasOwnProperty("title")){h=r=null;l=this.id+"_opt_"+o;n=this.id+"_alert_"+o;switch(e["type"]){case"text":h={id:l,name:o,rows:e["size"]?e["size"]:10,cols:50,value:e["value"]?e["value"]:""};d=[];d.push(BX.create("DIV",{attrs:{className:this.STYLES.dialogProcessOptionsTitle},children:[BX.create("LABEL",{attrs:{for:l},text:e["title"]})]}));var g=BX.create("TEXTAREA",{attrs:h});if(e["value"]){g.value=e["value"]}d.push(BX.create("DIV",{attrs:{className:this.STYLES.dialogProcessOptionsInput},children:[g]}));if(e["obligatory"]===true){d.push(BX.create("DIV",{attrs:{id:n,className:this.STYLES.dialogProcessOptionsObligatory},style:{display:"none"},children:[BX.create("SPAN",{attrs:{className:"ui-alert-message"},text:e["emptyMessage"]})]}))}r=BX.create("DIV",{children:d,attrs:{className:this.STYLES.dialogProcessOptionText}});break;case"file":h={id:l,type:e["type"],name:o};d=[];d.push(BX.create("DIV",{attrs:{className:this.STYLES.dialogProcessOptionsTitle},children:[BX.create("LABEL",{attrs:{for:l},text:e["title"]})]}));d.push(BX.create("DIV",{attrs:{className:this.STYLES.dialogProcessOptionsInput},children:[BX.create("INPUT",{attrs:h})]}));if(e["obligatory"]===true){d.push(BX.create("DIV",{attrs:{id:n,className:this.STYLES.dialogProcessOptionsObligatory},style:{display:"none"},children:[BX.create("SPAN",{attrs:{className:"ui-alert-message"},text:e["emptyMessage"]})]}))}r=BX.create("DIV",{children:d,attrs:{className:this.STYLES.dialogProcessOptionFile}});break;case"checkbox":h={id:l,type:e["type"],name:o,value:"Y"};if(e["value"]&&(e["value"]!=="Y"&&e["value"]!=="N")){h["value"]=e["value"]}if(a==="Y"||a===null&&e["value"]==="Y"||a!==null&&e["value"]!=="N"&&e["value"]===a){h["checked"]="checked"}r=BX.create("DIV",{children:[BX.create("DIV",{attrs:{className:this.STYLES.dialogProcessOptionsTitle},children:[BX.create("LABEL",{attrs:{for:l},text:e["title"]})]}),BX.create("DIV",{attrs:{className:this.STYLES.dialogProcessOptionsInput},children:[BX.create("INPUT",{attrs:h})]})],attrs:{className:this.STYLES.dialogProcessOptionCheckbox}});break;case"select":h={id:l,name:o};if(e["multiple"]==="Y"){h["multiple"]="Y";if(e["size"]){h["size"]=e["size"]}}p=[];for(u in e.list){if(e.list.hasOwnProperty(u)){if(e["multiple"]==="Y"){B=BX.type.isArray(a)&&a.indexOf(u)!==-1||a===null&&BX.type.isArray(e["value"])&&e["value"].indexOf(u)!==-1}else{B=u===a||a===null&&u===e["value"]}p.push(BX.create("OPTION",{attrs:{value:u,selected:B},text:e.list[u]}))}}d=[];d.push(BX.create("DIV",{text:e["title"],attrs:{className:this.STYLES.dialogProcessOptionsTitle}}));d.push(BX.create("DIV",{attrs:{className:this.STYLES.dialogProcessOptionsInput},children:[BX.create("SELECT",{attrs:h,children:p})]}));if(e["obligatory"]===true){d.push(BX.create("DIV",{attrs:{id:n,className:this.STYLES.dialogProcessOptionsObligatory},style:{display:"none"},children:[BX.create("SPAN",{attrs:{className:"ui-alert-message"},text:e["emptyMessage"]})]}))}r=BX.create("DIV",{children:d,attrs:{className:this.STYLES.dialogProcessOptionSelect}});break;case"radio":h={name:o,type:e["type"]};p=[];for(u in e.list){if(e.list.hasOwnProperty(u)){h.value=u;h.checked=u===a||a===null&&u===e["value"];p.push(BX.create("LABEL",{children:[BX.create("INPUT",{attrs:h}),e.list[u]]}))}}d=[];d.push(BX.create("DIV",{text:e["title"],attrs:{className:this.STYLES.dialogProcessOptionsTitle}}));d.push(BX.create("DIV",{attrs:{className:this.STYLES.dialogProcessOptionsInput,id:l},children:p}));if(e["obligatory"]===true){d.push(BX.create("DIV",{attrs:{id:n,className:this.STYLES.dialogProcessOptionsObligatory},style:{display:"none"},children:[BX.create("SPAN",{attrs:{className:"ui-alert-message"},text:e["emptyMessage"]})]}))}r=BX.create("DIV",{children:d,attrs:{className:this.STYLES.dialogProcessOptionRadio}});break}if(r!==null){this.optionsFieldsBlock.appendChild(r);c++}}}}var f=[this.summaryBlock,this.warningBlock,this.errorBlock];if(this.progressBarBlock)f.push(this.progressBarBlock);if(this.optionsFieldsBlock)f.push(this.optionsFieldsBlock);return BX.create("DIV",{attrs:{className:this.STYLES.dialogProcessPopup},children:f})},prepareDialogButtons:function(){var t=[],e=this.getSetting("showButtons");this.buttons={};if(e.start){var s=this.getMessage("startButton");this.buttons["start"]=new BX.PopupWindowButton({text:s!==""?s:"Start",className:this.STYLES.dialogButtonAccept,events:{click:BX.delegate(this.handleStartButtonClick,this)}});t.push(this.buttons["start"])}if(e.stop){var i=this.getMessage("stopButton");this.buttons["stop"]=new BX.PopupWindowButton({text:i!==""?i:"Stop",className:this.STYLES.dialogButtonDisable,events:{click:BX.delegate(this.handleStopButtonClick,this)}});t.push(this.buttons["stop"])}if(e.close){var o=this.getMessage("closeButton");this.buttons["close"]=new BX.PopupWindowButtonLink({text:o!==""?o:"Close",className:this.STYLES.dialogButtonCancel,events:{click:BX.delegate(this.handleCloseButtonClick,this)}});t.push(this.buttons["close"])}return t},getButton:function(t){return typeof this.buttons[t]!=="undefined"?this.buttons[t]:null},onDialogClose:function(t){if(this.popupWindow){this.popupWindow.destroy();this.popupWindow=null}this.buttons={};this.summaryBlock=null;this.isShown=false;this.callHandler("dialogClosed");BX.onCustomEvent(this,"BX.Translate.ProcessDialog.Closed",[this])},handleStartButtonClick:function(){var t=this.getButton("start");if(t){var e=BX.data(t.buttonNode,"disabled");if(e===true){return}}this.start()},handleStopButtonClick:function(){var t=this.getButton("stop");if(t){var e=BX.data(t.buttonNode,"disabled");if(e===true){return}}this.stop()},handleCloseButtonClick:function(){this.popupWindow.close()},lockButton:function(t,e){var s=this.getButton(t);if(!s){return}if(!!e){BX.removeClass(s.buttonNode,this.STYLES.dialogButtonAccept);BX.addClass(s.buttonNode,this.STYLES.dialogButtonDisable);s.buttonNode.disabled=true;BX.data(s.buttonNode,"disabled",true)}else{BX.removeClass(s.buttonNode,this.STYLES.dialogButtonDisable);BX.addClass(s.buttonNode,this.STYLES.dialogButtonAccept);s.buttonNode.disabled=false;BX.data(s.buttonNode,"disabled",false)}return this},showButton:function(t,e){var s=this.getButton(t);if(s){s.buttonNode.style.display=!!e?"":"none"}return this},setSummary:function(t,e){if(this.optionsFieldsBlock){BX.clean(this.optionsFieldsBlock)}if(BX.type.isNotEmptyString(t)){if(this.summaryBlock){if(!!e)this.summaryBlock.innerHTML=t;else this.summaryBlock.innerHTML=BX.util.htmlspecialchars(t);this.summaryBlock.style.display="block"}}else{this.summaryBlock.innerHTML="";this.summaryBlock.style.display="none"}return this},setError:function(t,e){if(BX.type.isNotEmptyString(t)){if(this.progressBar){this.progressBar.setColor(BX.UI.ProgressBar.Color.DANGER)}if(!!e)this.error.setText(t);else this.error.setText(BX.util.htmlspecialchars(t));this.errorBlock.style.display="flex"}else{if(this.errorBlock){this.error.setText("");this.errorBlock.style.display="none"}}return this},setWarning:function(t,e){if(BX.type.isNotEmptyString(t)){if(!!e)this.warning.setText(t);else this.warning.setText(BX.util.htmlspecialchars(t));this.warningBlock.style.display="flex"}else{if(this.warningBlock){this.warning.setText("");this.warningBlock.style.display="none"}}return this},setDownloadButtons:function(t,e,s){BX.clean(this.optionsFieldsBlock);if(t){var i=this.getMessage("downloadButton");var o=BX.create("A",{text:i!==""?i:"Download",props:{href:t,download:e},attrs:{className:this.STYLES.dialogButtonDownload}});this.optionsFieldsBlock.appendChild(o)}if(typeof s=="function"){var a=this.getMessage("clearButton");var r=BX.create("BUTTON",{text:a!==""?a:"Drop",attrs:{className:this.STYLES.dialogButtonRemove},events:{click:s}});this.optionsFieldsBlock.appendChild(r)}return this},setProgressBar:function(t,e,s){if(this.progressBar){if(BX.type.isNumber(e)&&BX.type.isNumber(t)&&t>0){BX.show(this.progressBarBlock);this.progressBar.setColor(BX.UI.ProgressBar.Color.PRIMARY);this.progressBar.setMaxValue(t);s=s||"";this.progressBar.setTextBefore(s);this.progressBar.update(e)}else{BX.hide(this.progressBarBlock)}}return this},hideProgressBar:function(){if(this.progressBar){BX.hide(this.progressBarBlock)}return this},getOptions:function(){var t={};if(this.optionsFieldsBlock){var e,s,i,o,a,r,l,n,c,h;s=this.getSetting("optionsFields",{});for(i in s){if(s.hasOwnProperty(i)){e=s[i];if(BX.type.isPlainObject(e)&&e.hasOwnProperty("name")&&e.hasOwnProperty("type")&&e.hasOwnProperty("title")){c=false;o=this.id+"_opt_"+i;switch(e["type"]){case"text":a=BX(o);if(a){if(typeof a.value!="undefined"){t[i]=a.value}}break;case"file":a=BX(o);if(a){if(typeof a.files[0]!="undefined"){t[i]=a.files[0]}}break;case"radio":n=BX(o);if(n){r=n.querySelectorAll("input[type=radio]");if(r){for(h=0;h<r.length;h++){if(r[h].checked){l=r[h].value;c=true;break}}}}break;case"checkbox":a=BX(o);if(a){if(a.value){l=a.checked?a.value:""}else{l=a.checked?"Y":"N"}c=true}break;case"select":a=BX(o);if(a){if(e.multiple==="Y"){l=[];for(h=0;h<a.options.length;h++){if(a.options[h].selected){l.push(a.options[h].value);c=true}}}else{l=a.value;c=true}}break}if(c){t[i]=l}}e=null;n=null;l=null;a=null;r=null}}}return t},getOption:function(t){var e;if(this.optionsFieldsBlock){var s,i,o,a;a=this.getSetting("optionsFields",{});s=a[t];if(BX.type.isPlainObject(s)&&s.hasOwnProperty("name")&&s.hasOwnProperty("type")&&s.hasOwnProperty("title")){i=this.id+"_opt_"+t;switch(s["type"]){case"file":case"checkbox":case"select":e=BX(i);break;case"radio":o=BX(i);if(o){e=o.querySelectorAll("input[type=radio]")}break}}}return e},checkOptions:function(){var t=true;if(this.optionsFieldsBlock){var e,s,i,o,a,r,l,n,c,h;s=this.getSetting("optionsFields",{});for(i in s){if(s.hasOwnProperty(i)){e=s[i];if(BX.type.isPlainObject(e)&&e.hasOwnProperty("name")&&e.hasOwnProperty("type")&&e.hasOwnProperty("title")){c=false;o=this.id+"_opt_"+i;a=this.id+"_alert_"+i;switch(e["type"]){case"file":r=BX(o);if(r&&e["obligatory"]===true){if(typeof r.files[0]=="undefined"){t=false;BX.show(BX(a))}else{BX.hide(BX(a))}}break;case"radio":n=BX(o);if(n&&e["obligatory"]===true){l=n.querySelectorAll("input[type=radio]");if(l){for(h=0;h<l.length;h++){if(l[h].checked){c=true;break}}}if(!c){t=false}}break;case"select":r=BX(o);if(r&&e["obligatory"]===true){if(e.multiple==="Y"){for(h=0;h<r.options.length;h++){if(r.options[h].selected){c=true}}}else{c=true}if(!c){t=false}}break}}e=null;n=null;r=null;l=null}}}return t}};if(typeof BX.Translate.ProcessDialogManager=="undefined"){BX.Translate.ProcessDialogManager={}}if(typeof BX.Translate.ProcessDialogManager.items=="undefined"){BX.Translate.ProcessDialogManager.items={}}BX.Translate.ProcessDialogManager.create=function(t){var e=new BX.Translate.ProcessDialog;e.init(t);BX.Translate.ProcessDialogManager.items[e.getId()]=e;return e};BX.Translate.ProcessDialogManager.delete=function(t){if(BX.Translate.ProcessDialogManager.items.hasOwnProperty(t)){BX.Translate.ProcessDialogManager.items[t].destroy();delete BX.Translate.ProcessDialogManager.items[t]}};BX.Translate.ProcessDialogManager.getInstance=function(t){return BX.Translate.ProcessDialogManager.items[t]?BX.Translate.ProcessDialogManager.items[t]:null}})();
//# sourceMappingURL=dialog.map.js