CREATE TABLE b_ui_entity_editor_config
(
	ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
	CATEGORY VARCHAR(20) NOT NULL,
	ENTITY_TYPE_ID VARCHAR(60) NOT NULL,
	NAME VARCHAR(100) NOT NULL,
	CONFIG LONGTEXT NOT NULL,
	COMMON VARCHAR(1) NOT NULL,
	AUTO_APPLY_SCOPE varchar(1) NOT NULL DEFAULT 'N',
	OPTION_CATEGORY varchar(50) NOT NULL,
	PRIMARY KEY (ID),
	INDEX ENTITY_TYPE_ID (ENTITY_TYPE_ID),
	INDEX CATEGORY (CATEGORY)
);

CREATE TABLE b_ui_entity_editor_config_ac
(
	ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
	ACCESS_CODE VARCHAR(10) NOT NULL,
	CONFIG_ID INTEGER(10) NOT NULL,
	PRIMARY KEY (ID),
	INDEX ACCESS_CODE (ACCESS_CODE),
	INDEX CONFIG_ID (CONFIG_ID)
);

CREATE TABLE b_ui_file_uploader_temp_file
(
	ID INT NOT NULL AUTO_INCREMENT,
	GUID CHAR(36) NOT NULL,
	FILE_ID INT,
	FILENAME VARCHAR(255) NOT NULL,
	SIZE BIGINT NOT NULL,
	PATH VARCHAR(255) NOT NULL,
	MIMETYPE VARCHAR(255) NOT NULL,
	RECEIVED_SIZE BIGINT NOT NULL DEFAULT 0,
	WIDTH INT NOT NULL DEFAULT 0,
	HEIGHT INT NOT NULL DEFAULT 0,
	BUCKET_ID INT,
	MODULE_ID VARCHAR(50) NOT NULL,
	CONTROLLER VARCHAR(255) NOT NULL,
	CLOUD TINYINT(1) NOT NULL DEFAULT 0,
	UPLOADED TINYINT(1) NOT NULL DEFAULT 0,
	DELETED TINYINT(1) NOT NULL DEFAULT 0,
	CREATED_BY INT NOT NULL DEFAULT 0,
	CREATED_AT DATETIME NOT NULL,

	INDEX IX_B_UI_UPLOADER_FILE_ID(FILE_ID),
	INDEX IX_B_UI_UPLOADER_CREATED_AT(CREATED_AT),
	UNIQUE INDEX IX_B_UI_UPLOADER_GUID(GUID),
	PRIMARY KEY (ID)
);

CREATE TABLE b_ui_avatar_mask_group (
	ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
	OWNER_TYPE VARCHAR(100) NOT NULL,
	OWNER_ID VARCHAR(20) NOT NULL,
	TITLE VARCHAR(255) NOT NULL,
	DESCRIPTION VARCHAR(255),
	SORT INT NOT NULL DEFAULT 100,
	TIMESTAMP_X DATETIME NOT NULL,
	INDEX IX_B_UI_AVATAR_MASK_GROUP_OWNER(OWNER_ID, OWNER_TYPE),
	PRIMARY KEY (ID)
);

CREATE TABLE b_ui_avatar_mask_item
(
	ID INT UNSIGNED NOT NULL AUTO_INCREMENT,
	OWNER_TYPE VARCHAR(100) NOT NULL,
	OWNER_ID VARCHAR(20) NOT NULL,
	FILE_ID INT NOT NULL,
	GROUP_ID INTEGER(10),
	TITLE VARCHAR(255),
	DESCRIPTION VARCHAR(255),
	SORT INT NOT NULL DEFAULT 100,
	TIMESTAMP_X DATETIME NOT NULL,
	PRIMARY KEY (ID),
	INDEX B_UI_AVATAR_MASK_ITEM_OWNER (OWNER_TYPE, OWNER_ID),
	INDEX B_UI_AVATAR_MASK_ITEM_FILE_ID (FILE_ID)
);

CREATE TABLE b_ui_avatar_mask_access
(
	ID BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
	ITEM_ID INT(11) NOT NULL,
	ACCESS_CODE VARCHAR(50) NOT NULL,
	PRIMARY KEY (ID),
	UNIQUE KEY B_UI_AVATAR_MASK_RIGHT_3 (ITEM_ID,ACCESS_CODE),
	KEY B_UI_AVATAR_MASK_RIGHT_1 (ITEM_ID),
	KEY B_UI_AVATAR_MASK_RIGHT_2 (ACCESS_CODE)
);

CREATE TABLE b_ui_avatar_mask_recently_used (
	ID bigint unsigned NOT NULL AUTO_INCREMENT,
	ITEM_ID INT NOT NULL,
	USER_ID INT NOT NULL,
	TIMESTAMP_X DATETIME ,
	PRIMARY KEY (ID),
	UNIQUE INDEX B_UI_AVATAR_MASK_ITEM_R_OWNER (ITEM_ID, USER_ID)
);


CREATE TABLE b_ui_avatar_mask_item_applied_to (
	ID bigint unsigned NOT NULL AUTO_INCREMENT,
	ORIGINAL_FILE_ID INT NOT NULL,
	FILE_ID INT NOT NULL,
	ITEM_ID INT NOT NULL,
	USER_ID INT NOT NULL,
	TIMESTAMP_X DATETIME NOT NULL,
	PRIMARY KEY (ID),
	INDEX b_ui_avatar_mask_item_applied1 (FILE_ID, ITEM_ID),
	INDEX b_ui_avatar_mask_item_applied2 (ITEM_ID),
	INDEX b_ui_avatar_mask_item_applied3 (USER_ID)
);

CREATE TABLE b_ui_avatar_mask_file_deleted (
	ID bigint NOT NULL AUTO_INCREMENT,
	ENTITY VARCHAR(50) NOT NULL,
	ORIGINAL_FILE_ID INT NOT NULL,
	FILE_ID INT NOT NULL,
	ITEM_ID INT NOT NULL,
	PRIMARY KEY (ID),
	KEY B_UI_AVATAR_MASK_FILE_DELETED_1 (ENTITY),
	KEY B_UI_AVATAR_MASK_FILE_DELETED_2 (ITEM_ID),
	KEY B_UI_AVATAR_MASK_FILE_DELETED_3 (FILE_ID)
);