(function(){"use strict";BX.namespace("BX.TileGrid");BX.TileGrid.Grid=function(t){this.options=t;this.id=t.id;this.tileMargin=t.tileMargin;this.sizeRatio=t.sizeRatio;this.tileSize=t.tileSize;this.itemHeight=t.itemHeight;this.itemMinWidth=t.itemMinWidth;this.checkBoxing=t.checkBoxing;this.items=[];this.renderTo=t.container;this.multiSelectMode=null;this.style=null;this.containerWidth=null;this.countItemsPerRow=null;this.layout={container:null,content:null};this.emptyBlock=null;this.loader=null;this.dragger=new BX.TileGrid.DragDrop(this);this.gridTile=null;this.backspaceButton=null;this.deleteButton=null;this.enterButton=null;this.currentItem=null;this.firstCurrentItem=null;this.currentItem=null;this.itemType=this.getItemType(t.itemType);this.loadData(t);this.bindEvents();this.pressedShiftKey=null;this.pressedDeleteKey=null;this.pressedSelectAllKeys=null;this.pressedArrowTopMultipleKey=null;this.pressedArrowRightMultipleKey=null;this.pressedArrowBottomMultipleKey=null;this.pressedArrowLeftMultipleKey=null;this.pressedArrowTopKey=null;this.pressedArrowRightKey=null;this.pressedArrowBottomKey=null;this.pressedArrowLeftKey=null;this.pressedEscapeKey=null;this.pressedControlKey=null;BX.onCustomEvent("BX.TileGrid.Grid::ready",[this])};BX.TileGrid.Grid.prototype={getId:function(){return this.id},getTileMargin:function(t){if(!this.tileMargin){this.tileMargin=9}return this.tileMargin},getSizeRatio:function(t){if(!this.sizeRatio)return false;return this.sizeRatio},bindEvents:function(){BX.bind(window,"resize",this.setStyle.bind(this));BX.bind(window,"keydown",function(t){this.defineEscapeKey(t);if(this.isKeyPressedEscape()){this.resetSelection();return}this.defineShiftKey(t);this.defineDeleteKey(t);this.defineSelectAllKeys(t);this.defineArrowMultipleKey(t);this.defineArrowSingleKey(t);this.defineControlKey(t);if(this.isKeyPressedSelectAll()&&this.isFocusOnTile())this.selectAllItems();this.setBackspaceButton(t);this.setEnterButton(t);if(this.isFocusOnTile()){this.processButtonSelection();if(this.isKeyPressedDelete()&&!this.isKeyPressedShift()&&!this.isKeyControlKey()){this.removeSelectedItems(t)}else if(this.backspaceButton){this.handleBackspace()}this.handleEnter(t)}}.bind(this));BX.bind(window,"keyup",function(t){this.resetShiftKey(t);this.resetDeleteKey(t);this.resetSelectAllKeys(t);this.resetArrowKey(t);this.resetEscapeKey(t);this.resetControlKey(t);this.resetBackspaceButton();this.resetEnterButton()}.bind(this));BX.bind(window,"click",function(t){if(this.checkParent(t.target))return;this.resetSelection();this.resetSetMultiSelectMode()}.bind(this))},handleEnter:function(){if(!this.enterButton||!this.currentItem)return;this.currentItem.handleEnter()},handleBackspace:function(){},checkParent:function(t){var e=BX.findParent(t,{className:"ui-grid-tile-item"});if(!e)e=BX.findParent(t,{attr:{"data-tile-grid":"tile-grid-stop-close"}});return e},appendItem:function(t){this.addItem(t);var e=this.items[this.items.length-1].render();BX.addClass(e,"ui-grid-tile-item-inserted");this.container.appendChild(e);this.items[this.items.length-1].afterRender()},addItem:function(t){var e=this.getItemType(t.itemType);var i=new e(t);i.gridTile=this;this.items.push(i)},_deleteItem:function(t,e){t.removeNode();for(var i=0;i<this.items.length;i++){if(this.items[i].id===t.id){if(BX.type.isFunction(e)){e(t)}delete this.items[i];this.items.splice(i,1);if(this.items.length===0){this.setMinHeightContainer();this.appendEmptyBlock()}return}}},removeItem:function(t){this._deleteItem(t,function(t){BX.onCustomEvent(this,"TileGrid.Grid:onItemRemove",[t,this])}.bind(this))},moveItem:function(t,e){this._deleteItem(t,function(t){BX.onCustomEvent(this,"TileGrid.Grid:onItemMove",[t,e,this])}.bind(this))},getSelectedItems:function(){return this.items.filter((function(t){return t.selected}))},removeSelectedItems:function(){var t;this.getSelectedItems().forEach((function(e){t=this.items.indexOf(e);this.removeItem(e);if(t===this.items.length)t=this.items.length-1}),this);this.currentItem=this.items[t];this.firstCurrentItem=this.items[t];this.resetSetMultiSelectMode();this.selectItem(this.currentItem)},selectAllItems:function(){this.items.forEach((function(t){this.selectItem(t);this.checkItem(t)}),this);this.currentItem=null;this.firstCurrentItem=null;if(this.isKeyPressedSelectAll())BX.PreventDefault();BX.onCustomEvent("BX.TileGrid.Grid:selectAllItems",[this])},loadData:function(t){t.items.forEach((function(t){this.addItem(t)}),this)},countItems:function(){return this.items.length},getItem:function(t){for(var e=0;e<this.items.length;e++){if(this.items[e].id.toString()===t.toString())return this.items[e]}},getItemHeight:function(){return this.itemHeight},changeTileSize:function(t){this.tileSize=t;this.setStyle()},setStyle:function(){if(this.calculateCountItemsPerRow()===this.countItemsPerRow){return}var t=document.head;var e="#"+this.getId()+" .ui-grid-tile-item { "+"width: calc("+100/this.calculateCountItemsPerRow()+"% - "+this.getTileMargin()*2+"px); "+"} ";if(this.sizeRatio){var i="#"+this.getId()+" .ui-grid-tile-item:before { "+"padding-top: "+this.getSizeRatio()+"} ";e=e+i}if(!this.style){this.getStyleNode()}BX.cleanNode(this.style);e=document.createTextNode(e);this.style.appendChild(e);t.appendChild(this.style);this.countItemsPerRow=this.calculateCountItemsPerRow()},getItemType:function(t){var e=this.getClass(t);if(BX.type.isFunction(e)){return e}return this.itemType||BX.TileGrid.Item},getClass:function(t){if(!BX.type.isNotEmptyString(t)){return null}var e=null;var i=window;var s=t.split(".");for(var r=0;r<s.length;r++){var n=s[r];if(!i[n]){return null}i=i[n];e=i}return e},getStyleNode:function(){this.style=BX.create("style",{attrs:{type:"text/css"}})},calculateCountItemsPerRow:function(){if(this.tileSize==="xl"){return this.calculateCountItemsPerRowXL()}if(!this.itemMinWidth){return this.calculateCountItemsPerRowM()}var t=-1;var e=0;var i=this.itemMinWidth+this.tileMargin*2;while(e<this.getContainerWidth()){e=e+i;t++}return t},calculateCountItemsPerRowM:function(){if(this.itemMinWidth){return Math.round(this.getContainerWidth()/(this.itemMinWidth+this.itemMinWidth/5))}switch(true){case this.getContainerWidth()<=720:return 3;case this.getContainerWidth()<=990:return 4;case this.getContainerWidth()<=1100:return 5;case this.getContainerWidth()>1100:return 6}},calculateCountItemsPerRowXL:function(){switch(true){case this.getContainerWidth()<=990:return 2;case this.getContainerWidth()<=1200:return 3;case this.getContainerWidth()>1200:return 4}},getContainerWidth:function(){this.containerWidth=this.renderTo.offsetWidth||this.containerWidth;return this.containerWidth},getContainer:function(){return this.container},getWrapper:function(){if(this.container){return}this.container=BX.create("div",{attrs:{id:this.getId(),className:"ui-grid-tile"},style:{margin:"0 -"+this.getTileMargin()+"px"}});return this.container},setMinHeightContainer:function(){var t=BX.findParent(this.container);this.container.style.height="0";BX.cleanNode(this.container);for(var e=0;t.offsetHeight<=0;e++){t=BX.findParent(t)}this.container.style.minHeight=t.offsetHeight+"px"},unSetMinHeightContainer:function(){this.container.style.minHeight=""},setHeightContainer:function(){this.container.style.height=this.container.offsetHeight},unSetHeightContainer:function(){this.container.style.height=""},setFadeContainer:function(){BX.addClass(this.container,"ui-grid-tile-fade")},unSetFadeContainer:function(){BX.removeClass(this.container,"ui-grid-tile-fade")},getLoader:function(){if(this.loader===null){this.loader=new BX.Loader({target:this.container})}return this.loader},showLoader:function(){this.loader.show();if(this.container.getBoundingClientRect().top<0){var t=this.container.getBoundingClientRect().top*-1+BX.pos(this.container).top;this.loader.layout.style.top=t+100+"px";this.loader.layout.style.transform="translateY(0)";return}if(this.loader.layout.getBoundingClientRect().top<window.innerHeight){this.loader.layout.style.top="100px";this.loader.layout.style.transform="translateY(0)"}},redraw:function(t){BX.onCustomEvent("BX.TileGrid.Grid:beforeRedraw",[this]);this.items.forEach((function(t){t.removeNode(false)}),this);this.items=[];this.loadData({items:t});this.draw();this.resetSelection();BX.onCustomEvent("BX.TileGrid.Grid:redraw",[this])},draw:function(){this.getWrapper();this.setStyle(this.getContainerWidth());for(var t=0,e;t<this.items.length;t++){e=this.items[t];this.container.appendChild(e.render())}this.renderTo.appendChild(this.container);for(var i=0;i<this.items.length;i++){this.items[i].afterRender()}if(this.items.length===0){this.setMinHeightContainer();this.appendEmptyBlock();return}this.removeEmptyBlock();this.unSetMinHeightContainer()},buildEmptyBlock:function(){if(BX.type.isFunction(this.options.generatorEmptyBlock)){this.emptyBlock=this.options.generatorEmptyBlock.call(this);return}this.emptyBlock=BX.create("div",{props:{className:"ui-grid-tile-no-data-inner"},children:[BX.create("div",{props:{className:"ui-grid-tile-no-data-image"}})]})},appendEmptyBlock:function(){if(!this.emptyBlock)this.buildEmptyBlock();this.container.appendChild(this.emptyBlock)},removeEmptyBlock:function(){if(!this.emptyBlock)return;this.container.removeChild(this.emptyBlock);this.emptyBlock=null},setBackspaceButton:function(t){t.key==="Backspace"?this.backspaceButton="Backspace":null},resetBackspaceButton:function(){this.backspaceButton=null},setEnterButton:function(t){if(t.key!=="Enter")return;this.enterButton="Enter"},resetEnterButton:function(){this.enterButton=null},processButtonSelection:function(){var e,i;if(this.isFocusOnTile()&&!this.currentItem&&this.items.length>0){this.setCurrentItem(this.items[0])}if(!this.currentItem)return;if(this.isKeyMultipleArrowRight()){this.selectFromToItems(this.firstCurrentItem,this.items[this.selectNextItemNumber(this.currentItem)])}if(this.isKeyArrowRight()){this.resetSelectAllItems();this.selectItem(this.items[this.selectNextItemNumber(this.currentItem)]);i=this.items[this.items.indexOf(this.currentItem)+1];if(i&&!i.isVisibleItem()){t(i.getContainer().getBoundingClientRect().height)}return}if(this.isKeyMultipleArrowLeft()){this.selectFromToItems(this.firstCurrentItem,this.items[this.selectPreviousItemNumber(this.currentItem)])}if(this.isKeyArrowLeft()){this.resetSelectAllItems();this.selectItem(this.items[this.selectPreviousItemNumber(this.currentItem)]);i=this.items[this.items.indexOf(this.currentItem)-1];if(i&&!i.isVisibleItem()){t(-i.getContainer().getBoundingClientRect().height)}return}if(this.isKeyMultipleArrowTop()){e=this.items[this.items.indexOf(this.currentItem)-this.countItemsPerRow];e?this.currentItem=e:this.currentItem=this.items[0];this.selectFromToItems(this.firstCurrentItem,this.currentItem)}if(this.isKeyArrowTop()){e=this.items[this.items.indexOf(this.currentItem)-this.countItemsPerRow];e?this.currentItem=e:this.currentItem=this.items[0];this.resetSelectAllItems();this.selectItem(this.currentItem);i=this.items[this.items.indexOf(this.currentItem)-this.countItemsPerRow];if(i&&!i.isVisibleItem()){t(-i.getContainer().getBoundingClientRect().height)}return}if(this.isKeyMultipleArrowBottom()){e=this.items[this.items.indexOf(this.currentItem)+this.countItemsPerRow];e?this.currentItem=e:this.currentItem=this.items[this.items.length-1];this.selectFromToItems(this.firstCurrentItem,this.currentItem)}if(this.isKeyArrowBottom()){e=this.items[this.items.indexOf(this.currentItem)+this.countItemsPerRow];e?this.currentItem=e:this.currentItem=this.items[this.items.length-1];this.resetSelectAllItems();this.selectItem(this.currentItem);i=this.items[this.items.indexOf(this.currentItem)+this.countItemsPerRow];if(i&&!i.isVisibleItem()){t(i.getContainer().getBoundingClientRect().height)}}},selectNextItemNumber:function(t){if(!t)return;var e=this.items.indexOf(t);if(e+1===this.items.length){this.setCurrentItem(this.items[this.items.length-1]);return this.items.length-1}this.setCurrentItem(this.items[e+1]);return e+1},selectPreviousItemNumber:function(t){if(!t)return;var e=this.items.indexOf(t);if(e-1<0){this.setCurrentItem(this.items[0]);return 0}this.setCurrentItem(this.items[e-1]);return e-1},selectFromToItems:function(t,e){if(!t||!e){return}this.resetSelectAllItems();this.setMultiSelectMode();var i=this.items.indexOf(t);var s=this.items.indexOf(e);if(i>s){i=this.items.indexOf(e);s=this.items.indexOf(t)}for(var r=i;r<=s;r++){this.selectItem(this.items[r]);this.checkItem(this.items[r])}},setCheckbox:function(t){BX.addClass(t.layout.checkbox,"ui-grid-tile-item-checkbox-checked")},resetFromToItems:function(){this.firstCurrentItem=null;this.currentItem=null},resetSelection:function(){this.resetSetMultiSelectMode();this.resetSelectAllItems();this.resetFromToItems()},defineArrowMultipleKey:function(t){if(t.shiftKey&&t.code==="ArrowUp")this.pressedArrowTopMultipleKey=true;if(t.shiftKey&&t.code==="ArrowRight")this.pressedArrowRightMultipleKey=true;if(t.shiftKey&&t.code==="ArrowDown")this.pressedArrowBottomMultipleKey=true;if(t.shiftKey&&t.code==="ArrowLeft")this.pressedArrowLeftMultipleKey=true},defineArrowSingleKey:function(t){if(!t.shiftKey&&t.code==="ArrowUp")this.pressedArrowTopKey=true;if(!t.shiftKey&&t.code==="ArrowRight")this.pressedArrowRightKey=true;if(!t.shiftKey&&t.code==="ArrowDown")this.pressedArrowBottomKey=true;if(!t.shiftKey&&t.code==="ArrowLeft")this.pressedArrowLeftKey=true},isKeyMultipleArrowTop:function(){return this.pressedArrowTopMultipleKey},isKeyMultipleArrowRight:function(){return this.pressedArrowRightMultipleKey},isKeyMultipleArrowBottom:function(){return this.pressedArrowBottomMultipleKey},isKeyMultipleArrowLeft:function(){return this.pressedArrowLeftMultipleKey},isKeyArrowTop:function(){return this.pressedArrowTopKey},isKeyArrowRight:function(){return this.pressedArrowRightKey},isKeyArrowBottom:function(){return this.pressedArrowBottomKey},isKeyArrowLeft:function(){return this.pressedArrowLeftKey},resetArrowKey:function(t){if(t.code==="ArrowUp"||t.code==="ArrowRight"||t.code==="ArrowDown"||t.code==="ArrowLeft"){this.pressedArrowTopMultipleKey=null;this.pressedArrowRightMultipleKey=null;this.pressedArrowBottomMultipleKey=null;this.pressedArrowLeftMultipleKey=null;this.pressedArrowTopKey=null;this.pressedArrowRightKey=null;this.pressedArrowBottomKey=null;this.pressedArrowLeftKey=null}},defineSelectAllKeys:function(t){if((t.metaKey||t.ctrlKey)&&t.code==="KeyA")this.pressedSelectAllKeys=true},resetSelectAllKeys:function(t){if(t.key==="Control"||t.key==="Meta"){this.pressedSelectAllKeys=null}},isKeyPressedSelectAll:function(){return this.pressedSelectAllKeys},defineDeleteKey:function(t){if(t.key==="Delete"){this.pressedDeleteKey=true;return}if(t.key==="Backspace"&&t.metaKey)this.pressedDeleteKey=true},resetDeleteKey:function(t){if(t.key==="Delete"){this.pressedDeleteKey=null;return}if(t.key==="Backspace"||t.key==="Meta")this.pressedDeleteKey=null},isKeyPressedDelete:function(){return this.pressedDeleteKey},defineEscapeKey:function(t){if(t.key==="Escape"){this.pressedEscapeKey=true;BX.onCustomEvent("BX.TileGrid.Grid:defineEscapeKey",[this])}},resetEscapeKey:function(t){if(t.key==="Escape")this.pressedEscapeKey=null},isKeyPressedEscape:function(){return this.pressedEscapeKey},defineControlKey:function(t){if(t.key==="Meta"||t.key==="Control")this.pressedControlKey=true},resetControlKey:function(t){if(t.key==="Meta"||t.key==="Control")this.pressedControlKey=null},isKeyControlKey:function(){return this.pressedControlKey},defineShiftKey:function(t){if(t.key==="Shift")this.pressedShiftKey=true},resetShiftKey:function(t){if(t.key==="Shift")this.pressedShiftKey=null},isKeyPressedShift:function(){return this.pressedShiftKey},setCurrentItem:function(t){if(this.currentItem!==t)this.currentItem=t},getCurrentItem:function(){return this.currentItem},resetCurrentItem:function(){this.currentItem=null},isFocusOnTile:function(){if(BX.getClass("BX.UI.Viewer.Instance")&&BX.UI.Viewer.Instance.isOpen()){return false}if(!document.activeElement){return true}var t=document.activeElement.tagName.toLowerCase();if(t==="body"){return true}if(t==="input"||t==="select"||t==="textarea"){return false}return!!BX.findParent(document.activeElement,{className:"ui-grid-tile"})},setFirstCurrentItem:function(t){if(this.firstCurrentItem!==t)this.firstCurrentItem=t},getFirstCurrentItem:function(){return this.firstCurrentItem},resetFirstCurrentItem:function(){this.firstCurrentItem=null},selectItem:function(t){if(!t)return;BX.addClass(t.layout.container,"ui-grid-tile-item-selected");t.selected=true;if(this.isLastSelectedItem())this.resetSetMultiSelectMode();BX.onCustomEvent("BX.TileGrid.Grid:selectItem",[t,this])},unSelectItem:function(t){if(!t)return;BX.removeClass(t.layout.container,"ui-grid-tile-item-selected");t.selected=false;if(this.isLastSelectedItem())this.resetSetMultiSelectMode();BX.onCustomEvent("BX.TileGrid.Grid:unSelectItem",[t,this])},isLastSelectedItem:function(){for(var t=0;t<this.items.length;t++){if(this.items[t].selected)return false}BX.onCustomEvent("BX.TileGrid.Grid:lastSelectedItem");return true},checkItem:function(t){if(!t)return;BX.addClass(t.layout.checkbox,"ui-grid-tile-item-checkbox-checked");t.checked=true;if(!this.isMultiSelectMode())this.setMultiSelectMode();BX.onCustomEvent("BX.TileGrid.Grid:checkItem",[t,this])},unCheckItem:function(t){BX.removeClass(t.layout.checkbox,"ui-grid-tile-item-checkbox-checked");t.checked=false;BX.onCustomEvent("BX.TileGrid.Grid:unCheckItem",[t,this])},setMultiSelectMode:function(){BX.addClass(this.container,"ui-grid-tile-multi-select-mode");this.multiSelectMode=true;BX.onCustomEvent("BX.TileGrid.Grid:multiSelectModeOn",[this])},resetSetMultiSelectMode:function(){BX.removeClass(this.container,"ui-grid-tile-multi-select-mode");this.multiSelectMode=null;BX.onCustomEvent("BX.TileGrid.Grid:multiSelectModeOff",[this])},isMultiSelectMode:function(){return this.multiSelectMode},resetSelectAllItems:function(){if(this.isMultiSelectMode())this.resetSetMultiSelectMode();BX.onCustomEvent("BX.TileGrid.Grid:resetSelectAllItems",[this]);for(var t=0;t<this.items.length;t++){this.items[t].selected=false;this.items[t].checked=false;BX.removeClass(this.items[t].layout.checkbox,"ui-grid-tile-item-checkbox-checked");BX.removeClass(this.items[t].layout.container,"ui-grid-tile-item-selected")}BX.onCustomEvent("BX.TileGrid.Grid:afterResetSelectAllItems",[this])}};var t=function(t){var e=document.documentElement.scrollTop?document.documentElement.scrollTop:document.body.scrollTop;var i=new BX.easing({duration:300,start:{scrollY:e},finish:{scrollY:e+t},transition:BX.easing.makeEaseOut(BX.easing.transitions.quad),step:function(t){window.scrollTo(0,t.scrollY)}});i.animate()}})();
//# sourceMappingURL=grid.map.js