import createBlobFromDataUri from '../../src/helpers/create-blob-from-data-uri';

// 100 x 100 (1041 bytes)
const png = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAYAAABw4pVUAAAABmJLR0QA/wD/AP+gvaeTAAADxklEQVR4nO3dTUhUURgG4FdnEO2OQYxplmGDUwtHo0U/kIWLzIWJMaCJQhQtA8E2rVy6cpMgtIykKBpNo3ZtSrRFriKdNo2ZUMJoKpiSxszcFqPS+FOO98w9n8777O6d4zlXX+Z89xsvChARERFZVezxDRZ7fIO6r0MSp+b1L2heX5xM3RdAiRiIMAxEGJGBpHOx113Ut5K2xV7kOySdMRBhGIgwGaonLCkpOxoxzQ6YqARQqHp+ISZhYiDidNz9Hvr4TeXESgM54j1Z5IxGPwBwq5xXsJmIw3FKZShK77KckWgHMuCuOHsAbXeOoyAvS+X0YoR//Eb7vc94NzzndkaiHQCaVc2ttoZkoBIA2lq9ezYMACjIy0Jbqzd+sPI9q8KiLozaQEwMAEB7Zwjh6WWlU0sSnl5Ge2cofmDircq5WdStUV7UHaomAoCfs+F5V17hk8yYWYgMuAHkqpxfkEmYeBVxOupF3/auV+zxmQDQ1PsslcvY5ml9IwBgYjyYsp8bi7owDEQYW7YsK4z8fNTd7wIAvLzdAgAJx4tTU//9ms3GWJHKLYs1JAmsIWmIgQjDQIRhIMJof8ih/+YtLC0sJpzLdhnwP3wgYpzdtAeytLCI8dBQwjmPd+NDJ0sLi/g69j7h3LGSc5bGbWddu3HLEoaBCMNAhGEgwmgv6tkuY0MxzXYZm45bX5ytjtvOunbjZ1lJ4GdZaYiBCKO9hrBTT6Q9ENWdteqO3m7csoRhIMIwEGEYiDDai7rqzlp1R283dupJYKeehhiIMNprCDv1RNoDSaYD1zHObtyyhGEgwjAQYRiIMNqLejIduI5xdmOnngR26mmIgQijvYawU0+kPZBUPNXOp99JGQYiDAMRhoEIo72op+Kpdj79vgV26snjliWM9i3LiqngJ4wEejA7NgYAcHu9OHGlBkVnTmu+sp3btYEEe/swEuiBGYutnQuPBhEeDaKsoR7ljQ0ar27ndmUgq+8MhyMTzc11qK46DwB4MzCM7scvEHzeh0PlPhwsLdV8pcnblTVkJBCAGYuhubEW/quXYBg5MIwc1NZUoulaDcxYDCOBXt2XuSO7MpC5sXEAWHtn/O1yVQUAYCb0xdZrUsWWLWv1dvGwaz9e+28AAKr7uzG5ML825l+vbcUwcjacy3XtAwBEln6trbsdq+uvrr3+2C629CGj11uUzlv2KP7n+/p7ujZ93d8QXy9V67IPSSMMRBgGIgwDEYaBCGP5bmHlH0Dq/2W0DEMT48GLVibgO4SIiIiIiIiIiIiIiPa6PxNdwlmdizXQAAAAAElFTkSuQmCC';

// 128 x 68
const pngFried = 'data:image/png;base64,iVBORw0KGgoAAAAEQ2dCSTAAIAIQ80R8AAAADUlIRFIAAACAAAAARAgGAAAASUc9aQAACklpQ0NQUGhvdG9zaG9wIElDQyBwcm9maWxlAACdU2dUU+kWPffe9EJLiICUS29SFQggUkKLgBSRJiohCRBKiCGh2RVRwRFFRQQbyKCIA46OgIwVUSwMigrYB+Qhoo6Do4iKyvvhe6Nr1rz35s3+tdc+56zznbPPB8AIDJZIM1E1gAypQh4R4IPHxMbh5C5AgQokcAAQCLNkIXP9IwEA+H48PCsiwAe+AAF40wsIAMBNm8AwHIf/D+pCmVwBgIQBwHSROEsIgBQAQHqOQqYAQEYBgJ2YJlMAoAQAYMtjYuMAUC0AYCd/5tMAgJ34mXsBAFuUIRUBoJEAIBNliEQAaDsArM9WikUAWDAAFGZLxDkA2C0AMElXZkgAsLcAwM4QC7IACAwAMFGIhSkABHsAYMgjI3gAhJkAFEbyVzzxK64Q5yoAAHiZsjy5JDlFgVsILXEHV1cuHijOSRcrFDZhAmGaQC7CeZkZMoE0D+DzzAAAoJEVEeCD8/14zg6uzs42jrYOXy3qvwb/ImJi4/7lz6twQAAA4XR+0f4sL7MagDsGgG3+oiXuBGheC6B194tmsg9AtQCg6dpX83D4fjw8RaGQudnZ5eTk2ErEQlthyld9/mfCX8BX/Wz5fjz89/XgvuIkgTJdgUcE+ODCzPRMpRzPkgmEYtzmj0f8twv//B3TIsRJYrlYKhTjURJxjkSajPMypSKJQpIpxSXS/2Ti3yz7Az7fNQCwaj4Be5EtqF1jA/ZLJxBYdMDi9wAA8rtvwdQoCAOAaIPhz3f/7z/9R6AlAIBmSZJxAABeRCQuVMqzP8cIAABEoIEqsEEb9MEYLMAGHMEF3MEL/GA2hEIkxMJCEEIKZIAccmAprIJCKIbNsB0qYC/UQB00wFFohpNwDi7CVbgOPXAP+mEInsEovIEJBEHICBNhIdqIAWKKWCOOCBeZhfghwUgEEoskIMmIFFEiS5E1SDFSilQgVUgd8j1yAjmHXEa6kTvIADKC/Ia8RzGUgbJRPdQMtUO5qDcahEaiC9BkdDGajxagm9BytBo9jDah59CraA/ajz5DxzDA6BgHM8RsMC7Gw0KxOCwJk2PLsSKsDKvGGrBWrAO7ifVjz7F3BBKBRcAJNgR3QiBhHkFIWExYTthIqCAcJDQR2gk3CQOEUcInIpOoS7QmuhH5xBhiMjGHWEgsI9YSjxMvEHuIQ8Q3JBKJQzInuZACSbGkVNIS0kbSblIj6SypmzRIGiOTydpka7IHOZQsICvIheSd5MPkM+Qb5CHyWwqdYkBxpPhT4ihSympKGeUQ5TTlBmWYMkFVo5pS3aihVBE1j1pCraG2Uq9Rh6gTNHWaOc2DFklLpa2ildMaaBdo92mv6HS6Ed2VHk6X0FfSy+lH6JfoA/R3DA2GFYPHiGcoGZsYBxhnGXcYr5hMphnTixnHVDA3MeuY55kPmW9VWCq2KnwVkcoKlUqVJpUbKi9Uqaqmqt6qC1XzVctUj6leU32uRlUzU+OpCdSWq1WqnVDrUxtTZ6k7qIeqZ6hvVD+kfln9iQZZw0zDT0OkUaCxX+O8xiALYxmzeCwhaw2rhnWBNcQmsc3ZfHYqu5j9HbuLPaqpoTlDM0ozV7NS85RmPwfjmHH4nHROCecop5fzforeFO8p4ikbpjRMuTFlXGuqlpeWWKtIq1GrR+u9Nq7tp52mvUW7WfuBDkHHSidcJ0dnj84FnedT2VPdpwqnFk09OvWuLqprpRuhu0R3v26n7pievl6Ankxvp955vef6HH0v/VT9bfqn9UcMWAazDCQG2wzOGDzFNXFvPB0vx9vxUUNdw0BDpWGVYZfhhJG50Tyj1UaNRg+MacZc4yTjbcZtxqMmBiYhJktN6k3umlJNuaYppjtMO0zHzczNos3WmTWbPTHXMueb55vXm9+3YFp4Wiy2qLa4ZUmy5FqmWe62vG6FWjlZpVhVWl2zRq2drSXWu627pxGnuU6TTque1mfDsPG2ybaptxmw5dgG2662bbZ9YWdiF2e3xa7D7pO9k326fY39PQcNh9kOqx1aHX5ztHIUOlY63prOnO4/fcX0lukvZ1jPEM/YM+O2E8spxGmdU5vTR2cXZ7lzg/OIi4lLgssulz4umxvG3ci95Ep09XFd4XrS9Z2bs5vC7ajbr+427mnuh9yfzDSfKZ5ZM3PQw8hD4FHl0T8Ln5Uwa9+sfk9DT4FntecjL2MvkVet17C3pXeq92HvFz72PnKf4z7jPDfeMt5ZX8w3wLfIt8tPw2+eX4XfQ38j/2T/ev/RAKeAJQFnA4mBQYFbAvv4enwhv44/Ottl9rLZ7UGMoLlBFUGPgq2C5cGtIWjI7JCtIffnmM6RzmkOhVB+6NbQB2HmYYvDfgwnhYeFV4Y/jnCIWBrRMZc1d9HcQ3PfRPpElkTem2cxTzmvLUo1Kj6qLmo82je6NLo/xi5mWczVWJ1YSWxLHDkuKq42bmy+3/zt84fineIL43sXmC/IXXB5oc7C9IWnFqkuEiw6lkBMiE44lPBBECqoFowl8hN3JY4KecIdwmciL9E20YjYQ1wqHk7ySCpNepLskbw1eSTFM6Us5bmEJ6mQvEwNTN2bOp4WmnYgbTI9Or0xg5KRkHFCqiFNk7Zn6mfmZnbLrGWFsv7Fbou3Lx6VB8lrs5CsBVktCrZCpuhUWijXKgeyZ2VXZr/Nico5lqueK83tzLPK25A3nO+f/+0SwhLhkralhktXLR1Y5r2sajmyPHF52wrjFQUrhlYGrDy4irYqbdVPq+1Xl65+vSZ6TWuBXsHKgsG1AWvrC1UK5YV969zX7V1PWC9Z37Vh+oadGz4ViYquFNsXlxV/2CjceOUbh2/Kv5nclLSpq8S5ZM9m0mbp5t4tnlsOlqqX5pcObg3Z2rQN31a07fX2Rdsvl80o27uDtkO5o788uLxlp8nOzTs/VKRU9FT6VDbu0t21Ydf4btHuG3u89jTs1dtbvPf9Psm+21UBVU3VZtVl+0n7s/c/romq6fiW+21drU5tce3HA9ID/QcjDrbXudTVHdI9VFKP1ivrRw7HH77+ne93LQ02DVWNnMbiI3BEeeTp9wnf9x4NOtp2jHus4QfTH3YdZx0vakKa8ppGm1Oa+1tiW7pPzD7R1ureevxH2x8PnDQ8WXlK81TJadrpgtOTZ/LPjJ2VnX1+LvncYNuitnvnY87fag9v77oQdOHSRf+L5zu8O85c8rh08rLb5RNXuFearzpfbep06jz+k9NPx7ucu5quuVxrue56vbV7ZvfpG543zt30vXnxFv/W1Z45Pd2983pv98X39d8W3X5yJ/3Oy7vZdyfurbxPvF/0QO1B2UPdh9U/W/7c2O/cf2rAd6Dz0dxH9waFg8/+kfWPD0MFj5mPy4YNhuueOD45OeI/cv3p/KdDz2TPJp4X/qL+y64XFi9++NXr187RmNGhl/KXk79tfKX96sDrGa/bxsLGHr7JeDMxXvRW++3Bd9x3He+j3w9P5Hwgfyj/aPmx9VPQp/uTGZOT/wTZH+4dAAAAIGNIUk0AAHolAACAgwAA+f8AAIDpAAB1MAAA6mAAADqYAAAXb5JfxUYAAAAJcEhZcwAACxMAAAsTAQCanBgAAAE8SURBVO3SQW7kMAxFQdKd+184rc8sLLsdYA4QYGrxQFHyyqieztSR0v9ZAwAAAAD4EQAIAAEgAASAABAAAkAACAABIAAEgAAQAAJAAAgAASAABIAAEAACQAAIAAEgAASAANAfB9BzzDFfv8sr17mf+5792Pt5d++vvR/p6+4+H4/9uPdevTqdziuVI71q3W/p1N6vt0qnV59zv9f9XafWrMqxZ+33z5x9n++svJO81zm/18r6x3x/5jznSrIed0nmutvnSZKc30yu9vvVJLXnve9zzbXP3PeTVH32mpmpc1adbzXJ1Mx5ftw/AgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA4I8D+AE29+irAAAAAElFTkSuQmCC';

// 32 x 16 (452 bytes)
const gif = 'data:image/gif;base64,R0lGODlhIAAQANUAAO3FWe3HXOK1OP/ZVcWsVeq8Ocy2auzBS+i6OeS4OcmyYbKVLu3DT+3BRr+kRc+aL//WSe3HYuzHYO3AQ8KoTf3TQv/aW/vSQv7UQ7CTLvXNQe2/Ori4uPTMQPLKQPfOQa+TLvzSQriaMey+OvjPQee6Ob2hPsq0ZsqpNf/bX/7cZ9KyXrWYL+3AP//WR/bNQcSdMOzIZrSXL9a0PMiwXXUpAPXNQP/dZcmyYv/XTP7dbPHJQPnQQa+SLm8nAP/VQyH5BAEAABwALAAAAAAgABAAAAbhQI5heMIZj8ikUkEjUBwc3CoWi0h02Kx2y1WlBjMRTWINAG7otHqN9qW/kJCMADADGJZ83sfv+/t6AxAVPDIUDIgNEzmMjY6PkC4VFx8LDgc1NQ8bP52dfZ6hoj8YFzwaGZc1DTWco6+ePp6lp6mYmq6xf7uynbSoqqy5sMSkpsCYwqKgxb7HtpmbzaO9xiSoJhMtLSMFFd/fvLvgITwfHSAi3QUFCDzv8PHy8yQvHTs9IuwlCQk2///6ABxI0EYHDx7wsYCRQIDDHRAjSpxIMSKKHhwWgOjBsaPHjyBDcggCADs=';

// 250 x 167
const jpg = 'data:image/jpeg;base64,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';

const bmp = 'data:image/bmp;base64,Qk12CAAAAAAAADYAAAAoAAAAGAAAAOr///8BACAAAAAAAEAIAAATCwAAEwsAAAAAAAAAAAAA////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////';
const tiff = 'data:image/tiff;base64,SUkqADgAAAD/2P/AABEIAAoACgMBIgACEQEDEQH/2gAMAwEAAhEDEQA/AP7gKKKK/lc/QD//2QAUAAABAwABAAAACgAAAAEBAwABAAAACgAAAAIBAwADAAAAPgEAAAMBAwABAAAABwAAAAYBAwABAAAABgAAAA0BAgALAAAAuAMAABEBBAABAAAACAAAABIBAwABAAAAAQAAABUBAwABAAAAAwAAABYBAwABAAAAEAAAABcBBAABAAAALwAAABoBBQABAAAALgEAABsBBQABAAAANgEAABwBAwABAAAAAQAAACgBAwABAAAAAgAAACkBAwACAAAAAAABADEBAgAhAAAAxAMAAFMBAwADAAAARAEAAFsBBwA+AgAAegEAABQCBQAGAAAASgEAAAAAAACQAAAAAQAAAJAAAAABAAAACAAIAAgAAQABAAEAAAAAAAEAAAD/AAAAAQAAAIAAAAABAAAA/wAAAAEAAACAAAAAAQAAAP8AAAABAAAA/9j/2wBDAAEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQH/2wBDAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQH/xAAfAAABBQEBAQEBAQAAAAAAAAAAAQIDBAUGBwgJCgv/xAC1EAACAQMDAgQDBQUEBAAAAX0BAgMABBEFEiExQQYTUWEHInEUMoGRoQgjQrHBFVLR8CQzYnKCCQoWFxgZGiUmJygpKjQ1Njc4OTpDREVGR0hJSlNUVVZXWFlaY2RlZmdoaWpzdHV2d3h5eoOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4eLj5OXm5+jp6vHy8/T19vf4+fr/xAAfAQADAQEBAQEBAQEBAAAAAAAAAQIDBAUGBwgJCgv/xAC1EQACAQIEBAMEBwUEBAABAncAAQIDEQQFITEGEkFRB2FxEyIygQgUQpGhscEJIzNS8BVictEKFiQ04SXxFxgZGiYnKCkqNTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqCg4SFhoeIiYqSk5SVlpeYmZqio6Slpqeoqaqys7S1tre4ubrCw8TFxsfIycrS09TV1tfY2dri4+Tl5ufo6ery8/T19vf4+fr/2XRlbXA2LnRpZmYAAEFkb2JlIFBob3Rvc2hvcCAyMy4wIChNYWNpbnRvc2gpAA==';

// eslint-disable-next-line no-unused-vars
const webpVP8 = 'data:image/webp;base64,UklGRiIAAABXRUJQVlA4IBYAAAAwAQCdASoBAAEADsD+JaQAA3AAAAAA';
const webpVP8L = 'data:image/webp;base64,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';
// eslint-disable-next-line no-unused-vars
const webpVP8X = 'data:image/webp;base64,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';

const createFileByType = (type) => {
	if (type === 'png')
	{
		const blob = createBlobFromDataUri(png);

		return new File([blob], 'image.png', { type: 'image/png' });
	}

	if (type === 'png_fried')
	{
		const blob = createBlobFromDataUri(pngFried);

		return new File([blob], 'image_fried.png', { type: 'image/png' });
	}

	if (type === 'gif')
	{
		const blob = createBlobFromDataUri(gif);

		return new File([blob], 'image.gif', { type: 'image/gif' });
	}

	if (type === 'bmp')
	{
		const blob = createBlobFromDataUri(bmp);

		return new File([blob], 'image.bmp', { type: 'image/bmp' });
	}

	if (type === 'jpg')
	{
		const blob = createBlobFromDataUri(jpg);

		return new File([blob], 'birds.jpg', { type: 'image/jpg' });
	}

	if (type === 'webp')
	{
		const blob = createBlobFromDataUri(webpVP8L);

		return new File([blob], 'image.webp', { type: 'image/webp' });
	}

	if (type === 'unsupported-image')
	{
		const blob = createBlobFromDataUri(tiff);

		return new File([blob], 'image.jpeg', { type: 'image/jpeg' });
	}

	if (type === 'tiff' || type === 'tif')
	{
		const blob = createBlobFromDataUri(tiff);

		return new File([blob], 'image.tiff', { type: 'image/tiff' });
	}

	if (['webpVP8', 'webpVP8L', 'webpVP8X'].includes(type))
	{
		// eslint-disable-next-line no-eval
		const variable = eval(type);
		const blob = createBlobFromDataUri(variable);

		return new File([blob], 'image.webp', { type: 'image/webp' });
	}

	if (type === 'csv')
	{
		return new File(
			[
				'John,Doe,120 jefferson st.,Riverside, NJ, 08075\n'
				+ 'Jack,McGinnis,220 hobo Av.,Phila, PA,09119',
			],
			'addresses.csv',
			{ type: 'text/csv' },
		);
	}

	if (type === 'json')
	{
		return new File(
			[
				'{ "status": "success", "errors": null, data: 123 }',
			],
			'response.json',
			{ type: 'application/json' },
		);
	}

	if (type === 'html')
	{
		return new File(['<html><body><b>Hello</b></body></html>'], 'index.html', { type: 'text/html' });
	}

	if (type === 'css')
	{
		return new File(['body { color: red }'], 'styles.css', { type: 'text/css' });
	}

	if (type === 'text')
	{
		return new File(['0123456789'.repeat(100)], 'text.txt', { type: 'text/plain' });
	}

	return new File(['123'], 'unknown.file', { type: 'application/octet-stream' });
};

export default createFileByType;
