(function(){"use strict";BX.namespace("BX.UI.Viewer");BX.UI.Viewer.Item=function(e){e=e||{};this.controller=null;this.title=e.title;this.src=e.src;this.nakedActions=BX.Type.isArrayFilled(e.nakedActions)?e.nakedActions:[];this.actions=BX.Type.isArrayFilled(e.actions)?e.actions:[];this.contentType=e.contentType;this.isLoaded=false;this.isLoading=false;this.isTransforming=false;this.isTransformationError=false;this.sourceNode=null;this.transformationTimeoutId=null;this.longPollingTimeoutId=null;this.viewerGroupBy=null;this.previewUrl=null;this.downloadUrl=null;this.isSeparate=false;this.transformationTimeout=e.transformationTimeout||22e3;this.layout={container:null};this.onTransformationComplete=this.handleTransformationComplete.bind(this);this.options=e;this.init()};BX.UI.Viewer.Item.prototype={setController(e){if(!(e instanceof BX.UI.Viewer.Controller)){throw new TypeError("BX.UI.Viewer.Item: 'controller' has to be instance of BX.UI.Viewer.Controller.")}this.controller=e},setPropertiesByNode(e){this.title=e.dataset.title||e.title||e.alt;this.src=e.dataset.src;this.viewerGroupBy=e.dataset.viewerGroupBy;this.isSeparate=e.dataset.viewerSeparateItem||false;this.nakedActions=e.dataset.actions?JSON.parse(e.dataset.actions):[];let t=null;if(BX.Type.isStringFilled(e.dataset.viewerPreview)){t=e.dataset.viewerPreview}else if(BX.Type.isStringFilled(e.dataset.bxPreview)){t=e.dataset.bxPreview}else if(BX.Type.isStringFilled(e.dataset.thumbSrc)){t=e.dataset.thumbSrc}else if(this instanceof BX.UI.Viewer.Image&&BX.Type.isStringFilled(e.src)){t=e.src}this.previewUrl=t===null||t.startsWith("data:image")?null:t},bindSourceNode(e){this.sourceNode=e},applyReloadOptions(e){},isSeparateItem(){return this.isSeparate},isPullConnected(){if(top.BX.PULL){if(BX.type.isFunction(top.BX.PULL.isConnected)){return top.BX.PULL.isConnected()}const e=top.BX.PULL.getDebugInfoArray();return e.connected}return false},registerTransformationHandler(e){if(this.isLoaded){return}if(this.controller.getCurrentItem()===this){this.controller.setTextOnLoading(BX.message("JS_UI_VIEWER_ITEM_TRANSFORMATION_IN_PROGRESS"))}if(this.isPullConnected()){BX.Event.EventEmitter.subscribe("onPullEvent-main",this.onTransformationComplete);console.log("BX.PULL.extendWatch");BX.PULL.extendWatch(e)}else{this.resetLongPollingTimeout();this.longPollingTimeoutId=setTimeout((()=>{BX.ajax.promise({url:BX.util.add_url_param(this.src,{ts:"bxviewer"}),method:"GET",dataType:"json",headers:[{name:"BX-Viewer-check-transformation",value:null}]}).then((e=>{if(!e.data||!e.data.transformation){this.registerTransformationHandler()}else{this.controller.reload(this,{forceTransformation:true})}}))}),5e3)}if(this.transformationTimeoutId===null&&this.isTransformationError===false){this.transformationTimeoutId=setTimeout((()=>{if(this.isLoading){console.log("Throw transformationTimeout");if(this._loadPromise){this._loadPromise.reject({status:"timeout",message:BX.message("JS_UI_VIEWER_ITEM_TRANSFORMATION_ERROR_1").replace("#DOWNLOAD_LINK#",this.getSrc()),item:this});this.isLoading=false;this.isTransformationError=true}}else{console.log("We don't have transformationTimeout :) ")}}),this.transformationTimeout)}},handleTransformationComplete(e){const[t]=e.getCompatData();if(t==="transformationComplete"&&this.isTransforming){this.controller.reload(this,{forceTransformation:true})}},resetTransformationTimeout(){if(this.transformationTimeoutId){clearTimeout(this.transformationTimeoutId)}this.transformationTimeoutId=null},resetLongPollingTimeout(){if(this.longPollingTimeoutId){clearTimeout(this.longPollingTimeoutId)}this.longPollingTimeoutId=null},init(){},load(){const e=new BX.Promise;if(this.isLoaded){e.fulfill(this);console.log("isLoaded");return e}if(this.isTransformationError){e.reject({item:this});return e}if(this.isLoading){console.log("isLoading");if(this.isTransforming&&this.controller.getCurrentItem()===this){this.controller.setTextOnLoading(BX.Loc.getMessage("JS_UI_VIEWER_ITEM_TRANSFORMATION_IN_PROGRESS"))}return this._loadPromise}this.isLoading=true;this._loadPromise=this.loadData().then((e=>{this.isLoaded=true;this.isLoading=false;this.isTransforming=false;return e})).catch((e=>{console.log("catch");this.isLoaded=false;this.isLoading=false;this.isTransforming=false;if(!e.item){e.item=this}const t=new BX.Promise;t.reject(e);return t}));console.log("will load");return this._loadPromise},listContainerModifiers(){return[]},getSrc(){return this.src},hashCode(e){let t=0;const i=e.length;let s=0;if(i>0){while(s<i){t=(t<<5)-t+e.charCodeAt(s++)|0}}return t},generateUniqueId(){return this.hashCode(this.getSrc()||"")+Math.floor(Math.random()*Math.floor(1e4))},getTitle(){return this.title},getPreviewUrl(){return this.previewUrl},getDownloadUrl(){return this.downloadUrl===null?this.src:this.downloadUrl},setDownloadUrl(e){if(BX.Type.isStringFilled(e)||e===null){this.downloadUrl=e}},getGroupBy(){return this.viewerGroupBy},getNakedActions(){return this.nakedActions},setActions(e){this.actions=e},getActions(){return this.actions},loadData(){const e=new BX.Promise;e.setAutoResolve(true);e.fulfill(this);return e},render(){},renderExtraActions(){},getMoreMenuItems(){return[]},getContentWidth(){},handleKeyPress(e){},handleClickOnItemContainer(e){},handleResize(){},asFirstToShow(){},afterRender(){},beforeHide(){},destroy(){this.resetTransformationTimeout();this.resetLongPollingTimeout();BX.Event.EventEmitter.unsubscribe("onPullEvent-main",this.onTransformationComplete)},abort(){return false}};BX.UI.Viewer.Image=function(e){e=e||{};BX.UI.Viewer.Item.apply(this,arguments);this.resizedSrc=e.resizedSrc;this.width=e.width;this.height=e.height;this.scale=1;this.rotation=0;this.translate={x:0,y:0};this.panning=false;this.imageNode=null;this.layout={container:null,actions:null};this.xhr=null;this.onPointerDownHandler=null;this.onPointerMoveHandler=null;this.onPointerUpHandler=null};BX.UI.Viewer.Image.prototype={__proto__:BX.UI.Viewer.Item.prototype,constructor:BX.UI.Viewer.Item,setPropertiesByNode(e){BX.UI.Viewer.Item.prototype.setPropertiesByNode.apply(this,arguments);this.src=e.dataset.src||e.src;this.width=e.dataset.width;this.height=e.dataset.height;if(!BX.Type.isUndefined(e.dataset.viewerResized)){this.resizedSrc=this.src}},applyReloadOptions(e){this.controller.unsetCachedData(this.src)},tryToExportResizedSrcFromSourceNode(){const e=210;if(!(this.sourceNode instanceof Image)){return}if(!this.sourceNode.naturalWidth||this.sourceNode.src.startsWith("data:image")){return}if(this.sourceNode.src===this.src){this.resizedSrc=this.src}else if(!this.sourceNode.src.endsWith(".gif")&&!this.sourceNode.src.endsWith(".webp")){const t=this.controller.getItemContainer().offsetHeight;const i=this.controller.getItemContainer().offsetWidth;const s=t/i;const r=t-e;const o=r/s;if(this.sourceNode.naturalWidth>=o||this.sourceNode.naturalHeight>=r){this.resizedSrc=this.sourceNode.src}}},loadData(){const e=new BX.Promise;if(!BX.Type.isStringFilled(this.resizedSrc)){if(!this.shouldRunLocalResize()){this.resizedSrc=this.src}else{this.tryToExportResizedSrcFromSourceNode();if(this.controller.getCachedData(this.src)){this.resizedSrc=this.controller.getCachedData(this.src).resizedSrc}}}if(this.resizedSrc){this.imageNode=new Image;this.imageNode.className="ui-viewer-image";this.imageNode.draggable=false;this.imageNode.onload=()=>{e.fulfill(this)};this.imageNode.onerror=this.imageNode.onabort=t=>{console.log("reject");e.reject({item:this,type:"error"})};this.imageNode.src=this.resizedSrc}else{this.xhr=new XMLHttpRequest;this.xhr.onreadystatechange=()=>{if(this.xhr.readyState!==XMLHttpRequest.DONE){return}if((this.xhr.status===200||this.xhr.status===0)&&BX.Type.isBlob(this.xhr.response)&&/^image\/[\d.a-z-]+$/i.test(this.xhr.response.type)){console.log("resize image");this.resizedSrc=URL.createObjectURL(this.xhr.response);this.imageNode=new Image;this.imageNode.className="ui-viewer-image";this.imageNode.draggable=false;this.imageNode.src=this.resizedSrc;this.imageNode.onload=()=>{e.fulfill(this)};this.controller.setCachedData(this.src,{resizedSrc:this.resizedSrc})}else{e.reject({item:this,type:"error"})}};this.xhr.open("GET",BX.util.add_url_param(this.src,{ts:"bxviewer"}),true);this.xhr.responseType="blob";this.xhr.setRequestHeader("BX-Viewer-image","x");this.xhr.send()}return e},abort(){if(this.xhr!==null&&!this.isLoaded){console.log("abort xhr");this.xhr.abort();this.xhr=null;return true}return false},shouldRunLocalResize(){return!this.controller.isExternalLink(this.src)},render(){const e=document.createDocumentFragment();e.appendChild(this.imageNode);this.imageNode.alt=this.title;return e},getMoreMenuItems(){if(this.title){return[{text:BX.Loc.getMessage("JS_UI_VIEWER_IMAGE_VIEW_FULL_SIZE_MSGVER_1"),href:BX.util.add_url_param(this.src,{ts:"bxviewer",ibxShowImage:1}),target:"_blank",onclick:()=>{this.controller.moreMenu?.close()}}]}return[]},renderExtraActions(){if(this.layout.actions===null){this.layout.actions=BX.Tag.render`
					<div class="ui-viewer-image-extra-actions">
						<div 
							class="ui-viewer-action-btn" 
							onclick="${this.handleZoomOut.bind(this)}"
							title="${BX.Text.encode(BX.Loc.getMessage("JS_UI_VIEWER_SINGLE_DOCUMENT_SCALE_ZOOM_OUT"))}"
						>
							<div class="ui-icon-set --zoom-out ui-viewer-action-btn-icon"></div>
						</div>
						<div 
							class="ui-viewer-action-btn" 
							onclick="${this.handleZoomIn.bind(this)}" 
							title="${BX.Text.encode(BX.Loc.getMessage("JS_UI_VIEWER_SINGLE_DOCUMENT_SCALE_ZOOM_IN"))}"
						>
							<div class="ui-icon-set --zoom-in ui-viewer-action-btn-icon"></div>
						</div>
						<div 
							class="ui-viewer-action-btn" 
							onclick="${this.handleRotate.bind(this)}"
							title="${BX.Text.encode(BX.Loc.getMessage("JS_UI_VIEWER_ITEM_ACTION_ROTATE"))}"
						>
							<div class="ui-icon-set --image-rotate-left ui-viewer-action-btn-icon"></div>
						</div>
					</div>
				`}return this.layout.actions},getContentWidth(){const e=new BX.Promise;e.fulfill(this.imageNode.offsetWidth*this.scale);return e},afterRender(){},enablePanning(){if(this.panning){return}this.onPointerDownHandler=this.handlePointerDown.bind(this);BX.Event.bind(this.imageNode,"pointerdown",this.onPointerDownHandler);this.panning=true},disablePanning(){BX.Event.unbind(this.imageNode,"pointerdown",this.onPointerDownHandler);this.onPointerDownHandler=null;this.panning=false},handleKeyPress(e){if(!this.isLoaded){return false}if(e.code==="Equal"){e.preventDefault();e.stopPropagation();this.zoomIn();return true}if(e.code==="Minus"){e.preventDefault();e.stopPropagation();this.zoomOut();return true}return false},handleClickOnItemContainer(e){if(!this.panning){this.controller.showNext()}},handlePointerDown(e){this.onPointerMoveHandler=this.handlePointerMove.bind(this);this.onPointerUpHandler=this.handlePointerUp.bind(this);BX.Event.bind(document,"pointermove",this.onPointerMoveHandler);BX.Event.bind(document,"pointerup",this.onPointerUpHandler)},handlePointerMove(e){const{movementX:t,movementY:i}=e;const s=window.innerWidth;const r=window.innerHeight;let o=this.imageNode.offsetWidth*this.scale;let n=this.imageNode.offsetHeight*this.scale;const a=Math.abs(this.rotation)/90%2!==0;if(a){[o,n]=[n,o]}const l=o>s?(o-s)/2:0;const h=n>r?(n-r)/2:0;let d=this.translate.x+t;let c=this.translate.y+i;if(Math.abs(d)>l){d=l*Math.sign(d)}if(Math.abs(c)>h){c=h*Math.sign(c)}this.translate.x=d;this.translate.y=c;this.applyTransform()},handlePointerUp(){BX.Event.unbind(document,"pointermove",this.onPointerMoveHandler);BX.Event.unbind(document,"pointerup",this.onPointerUpHandler);this.onPointerMoveHandler=null;this.onPointerUpHandler=null},applyTransform(){BX.Dom.style(this.imageNode,"translate",`${this.translate.x}px ${this.translate.y}px`);BX.Dom.style(this.imageNode,"scale",this.scale);BX.Dom.style(this.imageNode,"rotate",`${this.rotation}deg`)},resetTranslate(){this.translate.x=0;this.translate.y=0},togglePanning(){if(this.scale>1||this.rotation!==0){this.enablePanning()}else{this.disablePanning()}},zoomIn(){this.scale=Math.min(4,this.scale+1);this.applyTransform();this.togglePanning();this.controller.adjustControlsSize(this.getContentWidth())},zoomOut(){this.scale=Math.max(1,this.scale-1);this.resetTranslate();this.applyTransform();this.togglePanning();this.controller.adjustControlsSize(this.getContentWidth())},rotate(){this.rotation-=90;this.resetTranslate();this.applyTransform();this.togglePanning()},handleZoomOut(){this.zoomOut()},handleZoomIn(){this.zoomIn()},handleRotate(){this.rotate()}};BX.UI.Viewer.PlainText=function(e){e=e||{};BX.UI.Viewer.Item.apply(this,arguments);this.content=e.content};BX.UI.Viewer.PlainText.prototype={__proto__:BX.UI.Viewer.Item.prototype,constructor:BX.UI.Viewer.Item,setPropertiesByNode(e){BX.UI.Viewer.Item.prototype.setPropertiesByNode.apply(this,arguments);this.content=e.dataset.content},render(){const e=BX.create("span",{text:this.content});e.style.fontSize="14px";e.style.color="white";return e}};BX.UI.Viewer.Audio=function(e){e=e||{};BX.UI.Viewer.Item.apply(this,arguments);this.playerId=`audio-playerId_${this.generateUniqueId()}`;this.svgMask=null};BX.UI.Viewer.Audio.prototype={__proto__:BX.UI.Viewer.Item.prototype,constructor:BX.UI.Viewer.Item,setPropertiesByNode(e){BX.UI.Viewer.Item.prototype.setPropertiesByNode.apply(this,arguments);this.playerId=`audio-playerId_${this.generateUniqueId()}`},loadData(){const e=new BX.Promise;BX.Runtime.loadExtension("ui.video-player").then((()=>{const t=[{name:"BX-Viewer-src",value:this.src},{name:"BX-Viewer",value:"audio"}];const i=BX.ajax.promise({url:BX.util.add_url_param(this.src,{ts:"bxviewer"}),method:"GET",dataType:"json",headers:t});i.then((t=>{if(!t||!t.data){const i=t?t.errors:[];e.reject({item:this,type:"error",errors:i||[]});return}e.fulfill(this)}))}));return e},render(){this.player=new BX.UI.VideoPlayer.Player(this.playerId,{width:320,height:52,isAudio:true,skin:"vjs-viewer-audio-player-skin",sources:[{src:this.src,type:"audio/mp3"}]});return this.player.createElement()},afterRender(){this.player.init()}};BX.UI.Viewer.HightlightCode=function(e){e=e||{};BX.UI.Viewer.Item.apply(this,arguments);this.content=e.content};BX.UI.Viewer.HightlightCode.prototype={__proto__:BX.UI.Viewer.Item.prototype,constructor:BX.UI.Viewer.Item,setPropertiesByNode(e){BX.UI.Viewer.Item.prototype.setPropertiesByNode.apply(this,arguments);this.content=e.dataset.content},listContainerModifiers(){return["ui-viewer-document","ui-viewer-document-hlcode"]},loadData(){const e=new BX.Promise;BX.loadExt("ui.highlightjs").then((()=>{if(this.content){e.fulfill(this)}else{const t=new XMLHttpRequest;t.onreadystatechange=function(){if(t.readyState!==XMLHttpRequest.DONE){return}if((t.status===200||t.status===0)&&t.response){this.content=t.response;console.log("text content is loaded");this.controller.setCachedData(this.src,{content:this.content});e.fulfill(this)}else{e.reject({item:this,type:"error"})}}.bind(this);t.open("GET",BX.util.add_url_param(this.src,{ts:"bxviewerText"}),true);t.responseType="text";t.send()}}));return e},render(){const e=this.getTitle().slice(Math.max(0,this.getTitle().lastIndexOf(".")+1));return BX.create("div",{props:{tabIndex:2208},attrs:{className:"ui-viewer-item-document-content"},style:{width:"100%",height:"100%",paddingTop:"85px",background:"rgba(0, 0, 0, 0.1)",overflow:"auto"},children:[BX.create("pre",{children:[this.codeNode=BX.create("code",{props:{className:hljs.getLanguage(e)?e:"plaintext"},style:{fontSize:"14px",textAlign:"left"},text:this.content})]})]})},getContentWidth(){const e=new BX.Promise;e.fulfill(this.codeNode.offsetWidth);return e},afterRender(){hljs.highlightBlock(this.codeNode)}};BX.UI.Viewer.Unknown=function(e){BX.UI.Viewer.Item.apply(this,arguments)};BX.UI.Viewer.Unknown.prototype={__proto__:BX.UI.Viewer.Item.prototype,constructor:BX.UI.Viewer.Item,render(){return BX.create("div",{props:{className:"ui-viewer-unsupported"},children:[BX.create("div",{props:{className:"ui-viewer-unsupported-title"},text:BX.message("JS_UI_VIEWER_ITEM_UNKNOWN_TITLE")}),BX.create("div",{props:{className:"ui-viewer-unsupported-text"},text:BX.message("JS_UI_VIEWER_ITEM_UNKNOWN_NOTICE")}),BX.create("a",{props:{className:"ui-btn ui-btn-light-border ui-btn-themes",href:this.getSrc(),target:"_blank"},text:BX.message("JS_UI_VIEWER_ITEM_UNKNOWN_DOWNLOAD_ACTION")})]})}};BX.UI.Viewer.Video=function(e){e=e||{};BX.UI.Viewer.Item.apply(this,arguments);this.player=null;this.sources=[];this.contentNode=null;this.forceTransformation=false;this.videoWidth=null;this.playerId=`playerId_${this.generateUniqueId()}`};BX.UI.Viewer.Video.prototype={__proto__:BX.UI.Viewer.Item.prototype,constructor:BX.UI.Viewer.Item,setPropertiesByNode(e){BX.UI.Viewer.Item.prototype.setPropertiesByNode.apply(this,arguments);this.playerId=`playerId_${this.generateUniqueId()}`},applyReloadOptions(e){if(e.forceTransformation){this.forceTransformation=true}},loadData(){const e=new BX.Promise;BX.Runtime.loadExtension("ui.video-player").then((()=>{const t=[{name:"BX-Viewer-src",value:this.src}];t.push({name:this.forceTransformation?"BX-Viewer-force-transformation":"BX-Viewer",value:"video"});const i=BX.ajax.promise({url:BX.util.add_url_param(this.src,{ts:"bxviewer"}),method:"GET",dataType:"json",headers:t});i.then((t=>{if(!t||!t.data){const i=t?t.errors:[];e.reject({item:this,type:"error",errors:i||[]});return}if(t.data.hasOwnProperty("pullTag")){if(!this.isTransforming){this.registerTransformationHandler(t.data.pullTag)}this.isTransforming=true}else{this.isTransforming=false;if(t.data.data){this.width=t.data.data.width;this.height=t.data.data.height;this.sources=t.data.data.sources}e.fulfill(this)}}))}));return e},handleAfterInit(){if(this.handleVideoError()){return}if(this.player.vjsPlayer.videoWidth()>0&&this.player.vjsPlayer.videoHeight()>0){this.adjustVideo()}else{BX.Event.EventEmitter.subscribeOnce(this.player,"Player:onLoadedMetadata",(()=>{this.adjustVideo()}))}},handleVideoError(){if(this.player.vjsPlayer.error()&&!this.forceTransformation){this.controller.reload(this,{forceTransformation:true});return true}return false},adjustVideo(){const e=this.contentNode;if(!e){return}if(!this.player.vjsPlayer){return}this.adjustVideoWidth(this.player.width,this.player.height,this.player.vjsPlayer.videoWidth(),this.player.vjsPlayer.videoHeight());BX.addClass(e,"player-loaded");BX.style(e,"opacity",1);this.controller.hideLoading()},adjustVideoWidth(e,t,i,s){if(!e||!t||!i||!s){return false}t=Math.min(t,window.innerHeight-250);let r=Math.max(i,400);let o=Math.max(s,130);if(s>t||i>e){const n=e/t;const a=i/s;let l=1;if(n>a){l=t/s}else{l=e/i}r=Math.max(i*l,400);o=Math.max(s*l,130)}this.player.vjsPlayer.fluid(false);BX.Dom.style(this.contentNode,"width",`${r}px`);BX.Dom.style(this.contentNode,"height",`${o}px`);this.player.vjsPlayer.width("auto");this.player.vjsPlayer.height("auto");BX.Dom.style(this.player.vjsPlayer.el(),"width","100%");BX.Dom.style(this.player.vjsPlayer.el(),"min-width","300px");BX.Dom.style(this.player.vjsPlayer.el(),"aspect-ratio",`${r} / ${o}`);BX.Dom.style(this.player.vjsPlayer.el(),"height","auto");this.videoWidth=r;if(!this.contentWidthPromise.state){this.contentWidthPromise.fulfill(this.videoWidth)}return true},getContentWidth(){this.contentWidthPromise=new BX.Promise;if(this.videoWidth){this.contentWidthPromise.fulfill(this.videoWidth)}return this.contentWidthPromise},render(e){if(this.player===null){this.player=new BX.UI.VideoPlayer.Player(this.playerId,{autoplay:e.asFirstToShow===true,width:this.width,height:this.height,sources:this.sources,disablePictureInPicture:this.shouldDisablePictureInPicture()});this.controller.showLoading();BX.Event.EventEmitter.subscribe(this.player,"Player:onAfterInit",this.handleAfterInit.bind(this));BX.Event.EventEmitter.subscribe(this.player,"Player:onError",this.handleVideoError.bind(this));BX.Event.EventEmitter.subscribe(this.player,"Player:onEnterPictureInPicture",(()=>{this.controller.close()}));BX.Event.EventEmitter.subscribe(this.player,"Player:onLeavePictureInPicture",(()=>{if(this.player){this.player.pause();if(!this.controller.isOpen()){this.player.destroy();this.player=null}}}));this.contentNode=BX.create("div",{attrs:{className:"ui-viewer-video"},style:{opacity:0},children:[this.player.createElement()]})}else{this.adjustVideo()}return this.contentNode},shouldDisablePictureInPicture(){return BX.Browser.isFirefox()||navigator.userAgent.includes("YaBrowser")},asFirstToShow(){if(this.player){this.player.vjsPlayer.one("canplay",(()=>{this.player.mute(false);this.player.play();this.player.focus()}))}},afterRender(){const e=this.shouldDisablePictureInPicture()&&!this.player.isInited();this.player.init();if(e){this.player.vjsPlayer.controlBar.removeChild("PictureInPictureToggle")}},destroy(){BX.UI.Viewer.Item.prototype.destroy.apply(this);if(this.player!==null&&!this.player.vjsPlayer.isInPictureInPicture()){this.player.destroy();this.player=null}},beforeHide(){if(this.player!==null&&!this.player.vjsPlayer.isInPictureInPicture()){this.player.pause()}},handleResize(){this.adjustVideo()},temp(){}}})();
//# sourceMappingURL=ui.viewer.item.map.js