<?php

#############################################
# Bitrix Site Manager Forum					#
# Copyright (c) 2002-2009 Bitrix			#
# https://www.bitrixsoft.com					#
# mailto:admin@bitrixsoft.com				#
#############################################

use Bitrix\Vote;

IncludeModuleLangFile(__FILE__);

class CAllVoteQuestion
{
	public static function CheckFields($ACTION, &$arFields, $ID = 0)
	{
		$aMsg = array();
		$ID = intval($ID);
		$ACTION = ($ACTION == "UPDATE" ? "UPDATE" : "ADD");
		$arQuestion = array();
		if ($ID > 0 && $ACTION == "UPDATE"):
			$db_res = CVoteQuestion::GetByID($ID);
			if (!($db_res && $arQuestion = $db_res->Fetch())):
				$aMsg[] = array(
					"id" => "ID",
					"text" => GetMessage("VOTE_QUESTION_NOT_FOUND"));
			endif;
		endif;

		unset($arFields["ID"]);
		if (is_set($arFields, "VOTE_ID") || $ACTION == "ADD")
		{
			$arFields["VOTE_ID"] = intval($arFields["VOTE_ID"]);
			if ($arFields["VOTE_ID"] <= 0):
				$aMsg[] = array(
					"id" => "VOTE_ID",
					"text" => GetMessage("VOTE_FORGOT_VOTE_ID"));
			endif;
		}

		if (isset($arFields["QUESTION"]) || $ACTION == "ADD")
		{
			$arFields["QUESTION"] = trim($arFields["QUESTION"]);

			global $USER;
			if (!$USER || $USER->CanDoOperation('edit_php') !== true)
			{
				$arFields["QUESTION"] = Vote\Inner\Sanitizer::cleanText($arFields["QUESTION"]);
			}
			if ($arFields["QUESTION"] === "")
			{
				$aMsg[] = ["id" => "QUESTION", "text" => GetMessage("VOTE_FORGOT_QUESTION")];
			}
		}

		if (is_set($arFields, "IMAGE_ID") && $arFields["IMAGE_ID"]["name"] == '' && $arFields["IMAGE_ID"]["del"] == '')
		{
			unset($arFields["IMAGE_ID"]);
		}
		elseif (is_set($arFields, "IMAGE_ID"))
		{
			if ($str = CFile::CheckImageFile($arFields["IMAGE_ID"])):
				$aMsg[] = array(
					"id" => "IMAGE_ID",
					"text" => $str);
			else:
				$arFields["IMAGE_ID"]["MODULE_ID"] = "vote";
				if (!empty($arQuestion)):
					$arFields["IMAGE_ID"]["old_file"] = $arQuestion["IMAGE_ID"];
				endif;
			endif;
		}

		if (isset($arFields['ACTIVE']) || $ACTION == 'ADD') $arFields['ACTIVE'] = ($arFields['ACTIVE'] ?? 'Y') === 'N' ? 'N' : 'Y';
		if (isset($arFields['FIELD_TYPE']) || $ACTION == 'ADD') $arFields['FIELD_TYPE'] = intval($arFields['FIELD_TYPE'] ?? 0);
		unset($arFields['TIMESTAMP_X']);
		if (isset($arFields['C_SORT']) || $ACTION == 'ADD') $arFields['C_SORT'] = intval($arFields['C_SORT'] ?? 100);
		if (isset($arFields['COUNTER']) || $ACTION == 'ADD') $arFields['COUNTER'] = intval($arFields['COUNTER'] ?? 0);
		if (isset($arFields['QUESTION_TYPE']) || $ACTION == 'ADD') $arFields['QUESTION_TYPE'] = (($arFields['QUESTION_TYPE'] ?? 'text') == 'html' ? 'html' : 'text');
		if (isset($arFields['DIAGRAM']) || $ACTION == 'ADD') $arFields['DIAGRAM'] = (($arFields['DIAGRAM'] ?? 'Y') === 'N' ? 'N' : 'Y');
		if (isset($arFields['DIAGRAM_TYPE']) && (empty($arFields['DIAGRAM_TYPE']) || in_array($arFields['DIAGRAM_TYPE'], GetVoteDiagramArray()))):
			$arFields['DIAGRAM_TYPE'] = VOTE_DEFAULT_DIAGRAM_TYPE;
		endif;
		if (isset($arFields['TEMPLATE'])) $arFields['TEMPLATE'] = mb_substr(trim($arFields['TEMPLATE']), 0, 255);
		if (isset($arFields['TEMPLATE_NEW'])) $arFields['TEMPLATE_NEW'] = mb_substr(trim($arFields['TEMPLATE_NEW']), 0, 255);

		if ((isset($arFields['TEMPLATE']) || isset($arFields['TEMPLATE_NEW']))
			&& COption::GetOptionString("vote", "VOTE_COMPATIBLE_OLD_TEMPLATE", "N") == "Y")
		{
			$old_module_version = CVote::IsOldVersion();
			if ($old_module_version != "Y")
				unset($arFields["TEMPLATE"]);
			else
				unset($arFields["TEMPLATE_NEW"]);
		}

		if(!empty($aMsg))
		{
			global $APPLICATION;
			$e = new CAdminException(array_reverse($aMsg));
			$APPLICATION->ThrowException($e);
			return false;
		}
		return true;
	}

	public static function Add($arFields, $strUploadDir = false)
	{
		global $DB;
		$strUploadDir = ($strUploadDir === false ? "vote" : $strUploadDir);

		if (!CVoteQuestion::CheckFields("ADD", $arFields))
			return false;
/***************** Event onBeforeVoteQuestionAdd *******************/
		foreach (GetModuleEvents("vote", "onBeforeVoteQuestionAdd", true) as $arEvent)
			if (ExecuteModuleEventEx($arEvent, array(&$arFields)) === false)
				return false;
/***************** /Event ******************************************/
		if (empty($arFields))
			return false;

		if (
			array_key_exists("IMAGE_ID", $arFields)
			&& is_array($arFields["IMAGE_ID"])
			&& (
				!array_key_exists("MODULE_ID", $arFields["IMAGE_ID"])
				|| $arFields["IMAGE_ID"]["MODULE_ID"] == ''
			)
		)
			$arFields["IMAGE_ID"]["MODULE_ID"] = "vote";

		CFile::SaveForDB($arFields, "IMAGE_ID", $strUploadDir);

		if ($DB->type == "ORACLE")
			$arFields["ID"] = $DB->NextID("SQ_B_VOTE_QUESTION");

		if (isset($arFields['QUESTION']))
		{
			$arFields['QUESTION'] = \Bitrix\Main\Text\Emoji::encode($arFields['QUESTION']);
		}

		$arInsert = $DB->PrepareInsert("b_vote_question", $arFields);

		$DB->QueryBind("INSERT INTO b_vote_question (".$arInsert[0].", TIMESTAMP_X) VALUES(".$arInsert[1].", ".$DB->GetNowFunction().")", array("QUESTION" => $arFields["QUESTION"]), false);
		$ID = intval($DB->type == "ORACLE" ? $arFields["ID"] : $DB->LastID());

/***************** Event onAfterVoteQuestionAdd ********************/
		foreach (GetModuleEvents("vote", "onAfterVoteQuestionAdd", true) as $arEvent)
			ExecuteModuleEventEx($arEvent, array($ID, $arFields));
/***************** /Event ******************************************/
		return $ID;
	}

	public static function Update($ID, $arFields, $strUploadDir = false)
	{
		global $DB;

		$arBinds = array();
		$strUploadDir = ($strUploadDir === false ? "vote" : $strUploadDir);

		$ID = intval($ID);
		if ($ID <= 0 || !CVoteQuestion::CheckFields("UPDATE", $arFields, $ID))
			return false;
/***************** Event onBeforeVoteQuestionUpdate ****************/
		foreach (GetModuleEvents("vote", "onBeforeVoteQuestionUpdate", true) as $arEvent)
			if (ExecuteModuleEventEx($arEvent, array(&$ID, &$arFields)) === false)
				return false;
/***************** /Event ******************************************/
		if (empty($arFields))
			return false;

		if (
			array_key_exists("IMAGE_ID", $arFields)
			&& is_array($arFields["IMAGE_ID"])
			&& (
				!array_key_exists("MODULE_ID", $arFields["IMAGE_ID"])
				|| $arFields["IMAGE_ID"]["MODULE_ID"] == ''
			)
		)
			$arFields["IMAGE_ID"]["MODULE_ID"] = "vote";

		CFile::SaveForDB($arFields, "IMAGE_ID", $strUploadDir);

		if (isset($arFields['QUESTION']))
		{
			$arFields['QUESTION'] = \Bitrix\Main\Text\Emoji::encode($arFields['QUESTION']);
		}

		$arFields["~TIMESTAMP_X"] = $DB->GetNowFunction();
		$strUpdate = $DB->PrepareUpdate("b_vote_question", $arFields);
		if (is_set($arFields, "QUESTION"))
			$arBinds["QUESTION"] = $arFields["QUESTION"];

		if (!empty($strUpdate))
			$DB->QueryBind("UPDATE b_vote_question SET ".$strUpdate." WHERE ID=".$ID, $arBinds);

		unset($GLOBALS["VOTE_CACHE"]["QUESTION"][$ID]);
/***************** Event onAfterVoteQuestionUpdate *****************/
		foreach (GetModuleEvents("vote", "onAfterVoteQuestionUpdate", true) as $arEvent)
			ExecuteModuleEventEx($arEvent, array($ID, $arFields));
/***************** /Event ******************************************/
		return $ID;
	}

	public static function Copy($ID, $newVoteID)
	{
		$ID = intval($ID);
		if ($ID <= 0)
			return false;
		$newVoteID = intval($newVoteID);
		if ($newVoteID <= 0)
			return false;
		$res = CVoteQuestion::GetByID($ID);
		if (!($arQuestion = $res->Fetch()))
			return false;
		$arQuestion['VOTE_ID'] = $newVoteID;
		unset($arQuestion['ID']);
		$newQuestionID = CVoteQuestion::Add($arQuestion);
		if ($newQuestionID === false)
			return false;
		$state = true;
		$rAnswers = CVoteAnswer::GetList($ID);
		while ($arAnswer = $rAnswers->Fetch())
		{
			$arAnswer['QUESTION_ID'] = $newQuestionID;
			unset($arAnswer['ID']);
			$state = $state && (CVoteAnswer::Add($arAnswer) !== false);
		}
		if (!$state) return $state;
		CVoteQuestion::Reset($newQuestionID);

		return $newQuestionID;
	}

	public static function GetNextSort($VOTE_ID)
	{
		global $DB;

		$VOTE_ID = intval($VOTE_ID);
		$strSql = "SELECT max(C_SORT) as MAX_SORT FROM b_vote_question WHERE VOTE_ID='$VOTE_ID'";
		$z = $DB->Query($strSql);
		$zr = $z->Fetch();
		return (intval($zr["MAX_SORT"]) + 100);
	}

	public static function GetByID($ID)
	{
		$ID = intval($ID);
		$res = false;
		if ($ID <= 0):
			return false;
		endif;
		if (!is_array($GLOBALS["VOTE_CACHE"]["QUESTION"]))
			$GLOBALS["VOTE_CACHE"]["QUESTION"] = array();

		if (!array_key_exists($ID, $GLOBALS["VOTE_CACHE"]["QUESTION"]))
		{
			$db_res = CVoteQuestion::GetList(0, '', '', array("ID" => $ID));
			if ($db_res) $res = $db_res->Fetch();
			$GLOBALS["VOTE_CACHE"]["QUESTION"][$ID] = $res;
		}
		$db_res = new CDBResult;
		$db_res->InitFromArray(array($GLOBALS["VOTE_CACHE"]["QUESTION"][$ID]));
		return $db_res;
	}

	public static function GetList($VOTE_ID, $by = 's_c_sort', $order = 'asc', $arFilter = [])
	{
		global $DB;

		$VOTE_ID = (int) $VOTE_ID;
		$arSqlSearch = [];
		$arFilter = (is_array($arFilter) ? $arFilter : []);

		foreach ($arFilter as $key => $val)
		{
			if (empty($key) || empty($val) || $val === 'NOT_REF')
			{
				continue;
			}

			$key_res = VoteGetFilterOperation($key);
			$strNegative = $key_res['NEGATIVE'];
			$strOperation = $key_res['OPERATION'];
			$key = strtoupper($key_res['FIELD']);

			switch($key)
			{
				case 'ID':
					$match = (($arFilter[$key . '_EXACT_MATCH'] ?? 'Y') === 'N' ? 'Y' : 'N'); //turn off
					$arSqlSearch[] = GetFilterQuery('Q.ID', $val, $match);
					break;
				case 'DIAGRAM':
				case 'ACTIVE':
				case 'REQUIRED':
					$arSqlSearch[] = ($strNegative === 'Y' ? ' Q.' . $key . ' IS NULL OR NOT ' : '')
						. ' (Q.' . $key . ' ' . $strOperation . ' \'' . $DB->ForSql($val) . '\')';
					break;
				case 'QUESTION':
					$match = (($arFilter[$key . '_EXACT_MATCH'] ?? 'Y') !== 'N' ? 'Y' : 'N'); //turn on
					$arSqlSearch[] = GetFilterQuery('Q.QUESTION', $val, $match);
					break;
			}
		}
		if ($VOTE_ID > 0)
			$arSqlSearch[] = 'Q.VOTE_ID = ' . $VOTE_ID;

		// Order
		$by = strtoupper(strpos($by, 's_') === 0 ? substr($by, 2) : $by);
		$by = in_array($by, ['ID', 'TIMESTAMP_X', 'ACTIVE', 'DIAGRAM', 'C_SORT', 'REQUIRED']) ? $by : 'C_SORT';
		$order = ($order !== 'desc' ? 'asc' : 'desc');
		$strSqlOrder = 'Q.' . $by . ' ' . $order;

		// Sql
		$strSqlSearch = GetFilterSqlSearch($arSqlSearch);
		$strSql = '
			SELECT Q.*,
				' . $DB->DateToCharFunction('Q.TIMESTAMP_X','SHORT') . ' TIMESTAMP_X
			FROM b_vote_question Q
			WHERE ' . $strSqlSearch . '
			ORDER BY ' . $strSqlOrder;
		$res = $DB->Query($strSql);

		return $res;
	}

	public static function GetListEx($arOrder = array("ID" => "ASC"), $arFilter=array())
	{
		global $DB;

		$arSqlSearch = array();
		$strSqlSearch = "";
		$arSqlOrder = array();
		$strSqlOrder = "";

		$arFilter = (is_array($arFilter) ? $arFilter : array());
		foreach ($arFilter as $key => $val)
		{
			if($val === "NOT_REF")
				continue;
			$key_res = VoteGetFilterOperation($key);
			$strNegative = $key_res["NEGATIVE"];
			$strOperation = $key_res["OPERATION"];
			$key = mb_strtoupper($key_res["FIELD"]);

			switch($key)
			{
				case "ID":
				case "VOTE_ID":
					$str = ($strNegative=="Y"?"NOT":"")."(VQ.".$key." IS NULL OR VQ.".$key."<=0)";
					if (!empty($val))
					{
						$str = ($strNegative=="Y"?" VQ.".$key." IS NULL OR NOT ":"")."(VQ.".$key." ".$strOperation." ".intval($val).")";
						if ($strOperation == "IN")
						{
							$val = array_unique(array_map("intval", (is_array($val) ? $val : explode(",", $val))), SORT_NUMERIC);
							if (!empty($val))
							{
								$str = ($strNegative=="Y"?" NOT ":"")."(VQ.".$key." IN (".implode(",", $val)."))";
							}
						}
					}
					$arSqlSearch[] = $str;
					break;
				case "CHANNEL_ID":
					if ($val == '')
						$arSqlSearch[] = ($strNegative=="Y"?"NOT":"")."(V.".$key." IS NULL OR V.".$key."<=0)";
					else
						$arSqlSearch[] = ($strNegative=="Y"?" V.".$key." IS NULL OR NOT ":"")."(V.".$key." ".$strOperation." ".intval($val).")";
					break;
				case "ACTIVE":
					if (empty($val))
						$arSqlSearch[] = ($strNegative=="Y"?"NOT":"")."(VQ.".$key." IS NULL OR ".($DB->type == "MSSQL" ? "LEN" : "LENGTH")."(VQ.".$key.")<=0)";
					else
						$arSqlSearch[] = ($strNegative=="Y"?" VQ.".$key." IS NULL OR NOT ":"")."(VQ.".$key." ".$strOperation." '".$DB->ForSql($val)."')";
					break;
			}
		}
		if (count($arSqlSearch) > 0)
			$strSqlSearch = " AND (".implode(") AND (", $arSqlSearch).") ";

		foreach ($arOrder as $by => $order)
		{
			$by = mb_strtoupper($by);
			$order = mb_strtoupper($order);
			$by = ($by == "ACTIVE" ? $by : "ID");
			if ($order!="ASC") $order = "DESC";
			if ($by == "ACTIVE") $arSqlOrder[] = " VQ.ACTIVE ".$order." ";
			else $arSqlOrder[] = " VQ.ID ".$order." ";
		}
		DelDuplicateSort($arSqlOrder);
		if (count($arSqlOrder) > 0)
			$strSqlOrder = " ORDER BY ".implode(", ", $arSqlOrder);

		$strSql = "
			SELECT VQ.*
			FROM
				b_vote_question VQ, b_vote V
			WHERE VQ.VOTE_ID = V.ID ".
			$strSqlSearch."
			".$strSqlOrder;
		return $DB->Query($strSql);
	}

	public static function Delete($ID, $VOTE_ID = false)
	{
		global $DB;
/***************** Event onBeforeVoteQuestionDelete ****************/
		foreach (GetModuleEvents("vote", "onBeforeVoteQuestionDelete", true) as $arEvent)
			if (ExecuteModuleEventEx($arEvent, array(&$ID, &$VOTE_ID)) === false)
				return false;
/***************** /Event ******************************************/
		if (!CVoteAnswer::Delete(false, $ID, $VOTE_ID))
			return false;

		$ID = (intval($ID) > 0 ? intval($ID) : false);
		$VOTE_ID = (intval($VOTE_ID) > 0 ? intval($VOTE_ID) : false);
		if ($ID === false && $VOTE_ID === false):
			return false;
		elseif ($ID === false):
			$strSqlID = "SELECT Q.ID FROM b_vote_question Q WHERE Q.VOTE_ID=".$VOTE_ID;
		else:
			$strSqlID = "".$ID."";
		endif;

		$DB->StartTransaction();
		$strSql = "SELECT IMAGE_ID FROM b_vote_question WHERE ID IN (".$strSqlID.") AND IMAGE_ID > 0";
		$z = $DB->Query($strSql);
		while ($zr = $z->Fetch()) CFile::Delete($zr["IMAGE_ID"]);

		// drop question events
		if (!$DB->Query("DELETE FROM b_vote_event_question WHERE QUESTION_ID IN (".$strSqlID.")")):
			$DB->Rollback();
			return false;
		endif;
		// drop question
		if ($ID === false):
			$strSql = "DELETE FROM b_vote_question WHERE VOTE_ID=".$VOTE_ID;
		else:
			$strSql = "DELETE FROM b_vote_question WHERE ID=".$ID;
		endif;

		if (!$DB->Query($strSql)):
			$DB->Rollback();
			return false;
		endif;

		$DB->Commit();
/***************** Cleaning cache **********************************/
		if ($ID === false)
			unset($GLOBALS["VOTE_CACHE"]["QUESTION"]);
		else
			unset($GLOBALS["VOTE_CACHE"]["QUESTION"][$ID]);

/***************** Cleaning cache/**********************************/

/***************** Event onAfterForumDelete ************************/
		foreach (GetModuleEvents("vote", "onAfterVoteQuestionDelete", true) as $arEvent)
			ExecuteModuleEventEx($arEvent, array($ID, $VOTE_ID));
/***************** /Event ******************************************/
		return true;
	}

	public static function Reset($ID, $VOTE_ID = false)
	{
		global $DB;

		$ID = (intval($ID) > 0 ? intval($ID) : false);
		$VOTE_ID = (intval($VOTE_ID) > 0 ? intval($VOTE_ID) : false);

		if ($ID > 0):
			$strSqlID = "".$ID."";
		elseif ($VOTE_ID > 0):
			$strSqlID = "SELECT Q.ID FROM b_vote_question Q WHERE Q.VOTE_ID=".$VOTE_ID;
		else:
			return false;
		endif;

		// drop answer events
		$DB->Query("DELETE FROM b_vote_event_answer WHERE EVENT_QUESTION_ID IN (
			SELECT ID FROM b_vote_event_question WHERE QUESTION_ID IN (".$strSqlID."))");
		// drop question events
		$DB->Query("DELETE FROM b_vote_event_question WHERE QUESTION_ID IN (".$strSqlID.")");

		// zeroize answers counter
		$arFields = array("COUNTER"=>"0");
		$DB->Update("b_vote_answer", $arFields, "WHERE QUESTION_ID IN (".$strSqlID.")");

		// zeroize questions counter
		$arFields = array("COUNTER" => "0");
		$DB->Update("b_vote_question", $arFields, "WHERE ".(
			$ID > 0 ? "ID = ".$ID."" : "VOTE_ID = ".$VOTE_ID.""));


/***************** Cleaning cache **********************************/
		if ($ID === false)
			unset($GLOBALS["VOTE_CACHE"]["QUESTION"]);
		else
			unset($GLOBALS["VOTE_CACHE"]["QUESTION"][$ID]);
/***************** Cleaning cache/**********************************/
		return true;
	}

	public static function setActive($ID, $activate = true)
	{
		$ID = intval($ID);
		if ($ID <= 0)
			return false;
		$activate = (!!$activate);
/***************** Event onBeforeVoteQuestionUpdate ****************/
		foreach (GetModuleEvents("vote", "onVoteQuestionActivate", true) as $arEvent)
			if (ExecuteModuleEventEx($arEvent, array($ID, $activate)) === false)
				return false;
/***************** /Event ******************************************/

		global $DB;

		$strUpdate = $DB->PrepareUpdate("b_vote_question", array("ACTIVE" => ($activate ? "Y" : "N"), "~TIMESTAMP_X" => $DB->GetNowFunction()));
		$DB->QueryBind("UPDATE b_vote_question SET ".$strUpdate." WHERE ID=".$ID, array());
		unset($GLOBALS["VOTE_CACHE"]["QUESTION"][$ID]);

		return $ID;
	}
}
