
CREATE TABLE b_vote_channel (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  SYMBOLIC_NAME varchar(255) NOT NULL,
  C_SORT int DEFAULT '100',
  FIRST_SITE_ID char(2),
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  HIDDEN char(1) NOT NULL DEFAULT 'N',
  TIMESTAMP_X timestamp NOT NULL,
  TITLE varchar(255) NOT NULL,
  VOTE_SINGLE char(1) NOT NULL DEFAULT 'Y',
  USE_CAPTCHA char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ID)
);

CREATE TABLE b_vote_channel_2_group (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CHANNEL_ID int NOT NULL DEFAULT '0',
  GROUP_ID int NOT NULL DEFAULT '0',
  PERMISSION int NOT NULL DEFAULT '0',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_vote_channel_2_group_channel_id_group_id ON b_vote_channel_2_group (channel_id, group_id);

CREATE TABLE b_vote_channel_2_site (
  CHANNEL_ID int NOT NULL DEFAULT '0',
  SITE_ID char(2) NOT NULL,
  PRIMARY KEY (CHANNEL_ID, SITE_ID)
);

CREATE TABLE b_vote (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CHANNEL_ID int NOT NULL DEFAULT '0',
  C_SORT int DEFAULT '100',
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  ANONYMITY int NOT NULL DEFAULT '0',
  NOTIFY char(1) NOT NULL DEFAULT 'N',
  AUTHOR_ID int,
  TIMESTAMP_X timestamp NOT NULL,
  DATE_START timestamp NOT NULL,
  DATE_END timestamp NOT NULL,
  URL varchar(255),
  COUNTER int NOT NULL DEFAULT '0',
  TITLE varchar(255),
  DESCRIPTION text,
  DESCRIPTION_TYPE varchar(4) NOT NULL DEFAULT 'html',
  IMAGE_ID int,
  EVENT1 varchar(255),
  EVENT2 varchar(255),
  EVENT3 varchar(255),
  UNIQUE_TYPE int NOT NULL DEFAULT '2',
  KEEP_IP_SEC int,
  OPTIONS int DEFAULT '1',
  TEMPLATE varchar(255),
  RESULT_TEMPLATE varchar(255),
  STOP_EVENT_HANDLED smallint null default null,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_vote_channel_id ON b_vote (channel_id);

CREATE TABLE b_vote_question (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  TIMESTAMP_X timestamp NOT NULL,
  VOTE_ID int NOT NULL DEFAULT '0',
  C_SORT int DEFAULT '100',
  IMAGE_ID int,
  QUESTION text NOT NULL,
  QUESTION_TYPE varchar(4) NOT NULL DEFAULT 'html',
  FIELD_TYPE int NOT NULL DEFAULT '0',
  REQUIRED char(1) NOT NULL DEFAULT 'N',
  COUNTER int NOT NULL DEFAULT '0',
  DIAGRAM char(1) NOT NULL DEFAULT 'Y',
  DIAGRAM_TYPE varchar(10) NOT NULL DEFAULT 'histogram',
  TEMPLATE varchar(255),
  TEMPLATE_NEW varchar(255),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_vote_question_vote_id ON b_vote_question (vote_id);

CREATE TABLE b_vote_answer (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  TIMESTAMP_X timestamp NOT NULL,
  QUESTION_ID int NOT NULL DEFAULT '0',
  C_SORT int DEFAULT '100',
  IMAGE_ID int,
  MESSAGE text,
  MESSAGE_TYPE varchar(4) NOT NULL DEFAULT 'html',
  COUNTER int NOT NULL DEFAULT '0',
  FIELD_TYPE int NOT NULL DEFAULT '0',
  FIELD_WIDTH int,
  FIELD_HEIGHT int,
  FIELD_PARAM varchar(255),
  COLOR varchar(7),
  REACTION varchar(50) null default null,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_vote_answer_question_id ON b_vote_answer (question_id);

CREATE TABLE b_vote_event (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  VOTE_ID int NOT NULL DEFAULT '0',
  VOTE_USER_ID int NOT NULL DEFAULT '0',
  DATE_VOTE timestamp NOT NULL,
  STAT_SESSION_ID int,
  IP varchar(15),
  VALID char(1) NOT NULL DEFAULT 'Y',
  VISIBLE char(1) NOT NULL DEFAULT 'Y',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_vote_event_vote_user_id ON b_vote_event (vote_user_id);
CREATE INDEX ix_b_vote_event_vote_id_ip ON b_vote_event (vote_id, ip);

CREATE TABLE b_vote_event_question (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  EVENT_ID int NOT NULL DEFAULT '0',
  QUESTION_ID int NOT NULL DEFAULT '0',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_vote_event_question_event_id ON b_vote_event_question (event_id);

CREATE TABLE b_vote_event_answer (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  EVENT_QUESTION_ID int NOT NULL DEFAULT '0',
  ANSWER_ID int NOT NULL DEFAULT '0',
  MESSAGE text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_vote_event_answer_event_question_id ON b_vote_event_answer (event_question_id);
CREATE INDEX ix_b_vote_event_answer_answer_id ON b_vote_event_answer (ANSWER_ID);

CREATE TABLE b_vote_user (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  COOKIE_ID int NOT NULL,
  AUTH_USER_ID int,
  COUNTER int NOT NULL DEFAULT '0',
  DATE_FIRST timestamp NOT NULL,
  DATE_LAST timestamp NOT NULL,
  LAST_IP varchar(15),
  STAT_GUEST_ID int,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_vote_user_cookie_id_auth_user_id ON b_vote_user (cookie_id, auth_user_id);

CREATE TABLE b_vote_attached_object (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  OBJECT_ID int NOT NULL,
  MODULE_ID varchar(32) NOT NULL,
  ENTITY_TYPE varchar(100) NOT NULL,
  ENTITY_ID int NOT NULL,
  CREATE_TIME timestamp NOT NULL,
  CREATED_BY int,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_vote_attached_object_object_id ON b_vote_attached_object (object_id);
CREATE INDEX ix_b_vote_attached_object_module_id_entity_type_entity_id ON b_vote_attached_object (module_id, entity_type, entity_id);
