
CREATE TABLE IF NOT EXISTS b_workflow_document (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  STATUS_ID int NOT NULL DEFAULT '0',
  DATE_ENTER timestamp,
  DATE_MODIFY timestamp,
  DATE_LOCK timestamp,
  ENTERED_BY int,
  MODIFIED_BY int,
  LOCKED_BY int,
  FILENAME varchar(255) NOT NULL,
  SITE_ID char(2),
  TITLE varchar(255),
  BODY text,
  BODY_TYPE varchar(4) NOT NULL DEFAULT 'html',
  PROLOG text,
  EPILOG text,
  COMMENTS text,
  PRIMARY KEY (ID)
);

CREATE TABLE IF NOT EXISTS b_workflow_file (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DOCUMENT_ID int DEFAULT '0',
  TIMESTAMP_X timestamp,
  MODIFIED_BY int,
  TEMP_FILENAME varchar(255),
  FILENAME varchar(255),
  FILESIZE int,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_workflow_file_temp_filename ON b_workflow_file (temp_filename);

CREATE TABLE IF NOT EXISTS b_workflow_log (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DOCUMENT_ID int NOT NULL DEFAULT '0',
  TIMESTAMP_X timestamp,
  MODIFIED_BY int,
  TITLE varchar(255),
  FILENAME varchar(255),
  SITE_ID char(2),
  BODY text,
  BODY_TYPE varchar(4) NOT NULL DEFAULT 'html',
  STATUS_ID int NOT NULL DEFAULT '0',
  COMMENTS text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_workflow_log_document_id ON b_workflow_log (document_id);

CREATE TABLE IF NOT EXISTS b_workflow_move (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TIMESTAMP_X timestamp NOT NULL,
  DOCUMENT_ID int,
  IBLOCK_ELEMENT_ID int,
  OLD_STATUS_ID int NOT NULL DEFAULT '0',
  STATUS_ID int NOT NULL DEFAULT '0',
  LOG_ID int,
  USER_ID int,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_workflow_move_document_id ON b_workflow_move (document_id);
CREATE INDEX ix_b_workflow_move_iblock_element_id ON b_workflow_move (iblock_element_id);

CREATE TABLE IF NOT EXISTS b_workflow_preview (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DOCUMENT_ID int NOT NULL DEFAULT '0',
  TIMESTAMP_X timestamp,
  FILENAME varchar(255),
  PRIMARY KEY (ID)
);

CREATE TABLE IF NOT EXISTS b_workflow_status (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TIMESTAMP_X timestamp DEFAULT CURRENT_TIMESTAMP,
  C_SORT int DEFAULT '100',
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  TITLE varchar(255) NOT NULL,
  DESCRIPTION text,
  IS_FINAL char(1) NOT NULL DEFAULT 'N',
  NOTIFY char(1) NOT NULL DEFAULT 'Y',
  PRIMARY KEY (ID)
);

CREATE TABLE IF NOT EXISTS b_workflow_status2group (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  STATUS_ID int NOT NULL DEFAULT '0',
  GROUP_ID int NOT NULL DEFAULT '0',
  PERMISSION_TYPE int NOT NULL DEFAULT '0',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_workflow_status2group_status_id ON b_workflow_status2group (status_id);
